package config;
use strict;
use POSIX qw(strftime);

my $version;


sub check_input
{
	my $confighash = shift;
	$confighash->{localtime_start} = strftime "%H:%M:%S", localtime;
	my $date = strftime "%y%m%d", localtime;
	my $time = strftime "%H%M%S", localtime;
	print "pmSummary.pl $confighash->{version}\nby Martin Aldrin, Henrik Schller\n" if !defined $confighash->{amos};
	if (defined  $confighash->{html}  )
	{
		$confighash->{html} =~ s/DATE/${date}/g;
		$confighash->{html} =~ s/TIME/${time}/g;
		my $filepath = $confighash->{html};
		$filepath=~s/\.html$//;
		$filepath = './'  if $filepath eq "";
		
		$confighash->{html} = $filepath  . '/' . 'index.html';
		$confighash->{htmlpath} = $filepath . '/';
		$confighash->{flotpath} = $filepath . '/' . '/dataseries/';
		$confighash->{jspath} = $filepath . '/' . '/js/';
		$confighash->{csspath} = $filepath . '/' . '/css/';
		$confighash->{imagespath} = $filepath . '/' . '/images/';
		if (!defined $confighash->{force})
		{		
			print "html file $confighash->{html}\n";
			print "htmlpath $confighash->{htmlpath}\n";
			print "flotpath $confighash->{flotpath}\n";
		}
		if (-d $confighash->{htmlpath} && !defined $confighash->{force})
		{
			print STDERR "\nfile $confighash->{html} alrady exist\n";
			exit;
		}
		
		system("mkdir -p " . $confighash->{flotpath} ) if ((defined $confighash->{flotpath} || $confighash->{flotpath} ne "") && !-d $confighash->{flotpath});
		system("mkdir -p " . $confighash->{imagespath} ) if ((defined $confighash->{imagespath} || $confighash->{imagespath} ne "") && !-d $confighash->{imagespath});
		system("mkdir -p " . $confighash->{jspath} ) if ((defined $confighash->{jspath} || $confighash->{jspath} ne "") && !-d $confighash->{jspath});
		system("mkdir -p " . $confighash->{csspath} ) if ((defined $confighash->{csspath} || $confighash->{csspath} ne "") && !-d $confighash->{csspath});
		if ((defined $filepath || $filepath ne "") && !-d $filepath)
		{
			print "couldn't create dirctory $filepath\n";
			exit;
		}
		$confighash->{imagespath} =~s/\/+/\//g;
		$confighash->{htmlpath} =~s/\/+/\//g;
		$confighash->{flotpath} =~s/\/+/\//g;
		$confighash->{html} =~s/\/+/\//g;
		$confighash->{filepath} = $filepath;
	}
	$confighash->{LastRop} = 0;
	$confighash->{exceptionfile} = $confighash->{flotpath} . "exception.txt";
	if (defined $confighash->{y2})
	{
		my @files = split(/,/,$confighash->{y2});
		foreach my $file (@files)
		{
			open FILE, "< $file";
			while(my $line = <FILE>)
			{
				$line =~s/\s*#.*//;
				next if $line eq "";
				if ($line =~ /(\S+)/)
				{
					$confighash->{y2data}->{$1}=1;
				}
			}
			close FILE;
		}
	}		
}

1;
