package convert_funcs;
use strict;

my $indexhash;
my $stringhash;
my $index = 0;

sub stringTOindex
{
	my $stringref = shift;
	
	if (defined $indexhash->{$$stringref})
	{
		return $indexhash->{$$stringref};
	}
	if (!defined $indexhash->{$$stringref})
	{
		$index++;
		$indexhash->{$$stringref} = $index;
		$stringhash->{$index} = $$stringref;
		return $indexhash->{$$stringref};
	}
	$$stringref = undef;
}

sub convert_lgt_format
{
	my $lineref = shift;
	if ($$lineref =~ /^(\d{4}-\d{2}-\d{2}\s+\d{2}:\d{2}:\d{2}\.\d{3})\s+TE\s+(\d+\S*)/)
	{
		my $timestamp = $1;
		my $board = $2;
		
		$$lineref =~ s/^$timestamp\s+TE\s+$board\s+//;
		$$lineref =~ s/^\*\*\S+\s+//;
		$$lineref =~ s/^[A-Za-z_-]+\s+//;
		$timestamp = '[' . $timestamp . ']';
		if ($board =~ /(\d{4})(SP\d+)/)
		{
			$board = $1 . '00'. '/' . lc($2) . '.lnh';
		}
		elsif ($board =~ /\d{4}/)
		{
			$board .= '00';
		}
		$$lineref = $timestamp . " " . $board . '/' . $$lineref;
	}
}
sub covert_te_log
{
	my $lineref = shift;
	$$lineref =~ s/\[\d*\;?\d+m//g;
	if ($$lineref =~ /^((\d{4}(SP[0-9])?):\s+(\[.+?\])\s*)/)
	{
		my $rm = $1;
		my $module = $2;
		my $time = $4;
		$rm =~ s/\[/\\[/g;
		$rm =~ s/\]/\\]/g;
		$$lineref =~ s/$rm//;
		$$lineref = $time . $module . ' ' . $$lineref;
	}	
}

sub clean_line 
{
	my $lineref = shift;
	chomp($$lineref);
	$$lineref =~ s/\n//g;
	$$lineref =~ s/\[0m//g;
	$$lineref =~ s/\D+\.cc:\d+ //;
	$$lineref =~ s/[0o]x[A-Fa-f0-9]+/xxx/g;
	$$lineref =~ s/\(-?xxx,-?xxx,-?xxx\)//g;
	$$lineref =~ s/[A-Fa-f0-9]*\d+[A-Fa-f0-9]*/xxx/g;
	$$lineref =~ s/\w+ HEX/xxx HEX/g;
	$$lineref =~ s/\s+/ /g;
	$$lineref =~ s/\e//g;
	$$lineref =~ s/rrcMsgData\{.+?,/rrcMsgData\{\},/gs;
	return;
}
1;