package formula;
use strict;

my %f = ();

my @a;
sub parse_formula
{
	my $config = shift;
	return if !defined $config->{formulafile};
	open(FORMULA, "<$config->{formulafile}");
	my $i = 0;
	while(my $line = <FORMULA>)
	{
		$line =~s/\r//g;
		if($line =~ /^ *#/) { next; }
		if($line =~ /^ *$/) { next; }	

		if($line =~ /(.*)=(.*)/)
		{
			$f{strip($1)} = $2;	
		}
		$i++;
	}
	close FORMULA;
	my $strings = ();
	open F ,">".$config->{flotpath}.'/formulas.js';
	print F "var formulas = {\n";
	foreach my $k (keys %f)
	{
		@a = ();
		pushFormulas($k,$f{$k});
		#print  F 
		my $string = "$k: [";
		foreach my $s (@a)
		{
			$string .= "['$s'],";
		}
		chop $string;
		push(@$strings, $string . "],");

	}
	chop @$strings[-1];
	foreach my $string (@$strings)
	{
		print F $string;
	}
	print F "};\n";
}
   
sub pushFormulas
{
    my $k = shift;
    my $string = shift;
    push(@a, "$k = $string");
    my @parts = split(/\(|\)|\*|\/|\+|-/, $string);
	
    foreach my $p (@parts)
    {
	$p = strip($p);

	if(defined $f{$p}) 
	{ 
	    pushFormulas($p,$f{$p});
	}    
    }
}
#print Dumper(\%f);


sub strip
{
    my $f = shift;
    $f =~ s/^\s+//;
    $f =~ s/\s+$//;
    return $f;
}
1;
