#!/usr/bin/gawk -f

BEGIN {
# THIS SCRIPT IS TO BE USED TOGETHER WITH check_scb.mos
    if ( ARGC < 2 ) {
        print "Syntax: make_a_table.awk <mo_part> <SPAS_part>";
	   exit
	}
    data_mo=ARGV[1];
    data_spas=ARGV[2];
    data_clock=ARGV[3];
	data_pwr=ARGV[4];
    a="====================================================================================================================="; 
#    printf("\n%s\n%5s |%8s |%7s | %14s |%7s | %4s  <--------> %4s |%7s |%14s |%7s |%8s \n%s\n",a,"STATE"," Subrack","SCB ","RgRo superv.","PORT ","LED ","LED ","PORT ","RgRo superv.","SCB "," Subrack ",a);
    isl_num=0
    sub_num=0
    swm_num=0
    while (( getline < data_mo ) > 0 )
    {
        if ( $1 ~ /^InternalLinkGroup.*SwitchInternalLink.*/  )
	       if ( $2 != "!!!!" ) {
	     	 isl_num++
	     	 isl_slot1[isl_num]=$13;
			 isl_slot2[isl_num]=$14;
			 isl_id[isl_num]=$2
			 isl_state_admin[isl_num]=$3;
			 isl_state_oper_traffic[isl_num]=$11;
			 isl_state_oper_sync[isl_num]=$9;
			 isl_siliport1[isl_num]=$15;
  			 isl_siliport2[isl_num]=$16;
	       }    else {
		      print "ERROR: Unable to read SwitchInternalLink record, MO record is corrupted"
			 isl_num=0;
			 sub_num=0;
			 swm_num=0;
			 break
		  }	 
			 
	   if ( $1 ~ /^Subrack.*/ ) 
	       if ( $2 != "!!!!" ) {
	     	 sub_num++;
			 subrack_lname[sub_num]=$2;
			 subrack_name[sub_num]=$1;

    #		  subrack_number[sub_num]=$3;
          	 subrack_swmod[sub_num]=$3
    #		  if (subrack_number[sub_num]<10) subrack_number[sub_num]="0"subrack_number[sub_num];

	       } else  {
		      print "ERROR: Unable to read Subrack MO record !"
			 isl_num=0;
			 sub_num=0;
			 swm_num=0;
			 break
		  }	 
                  
	   if ( $1 ~/^SwitchModule=.*/ ) 
	       if ( $2 != "!!!!" ) {
	     	 swm_num++
			 swm_name[swm_num]=$1
			 swm_number[swm_num]=$2
	       } else {
		      print "ERROR: Unable to read SwitchModule MO record !"
			 isl_num=0;
			 sub_num=0;
			 swm_num=0;
			 break
		  }
    }
    close(data_mo);
    
    # Required to get SMN
    for (i=1; i<=sub_num; i++ )
	   for ( j=1; j<=swm_num; j++ )
		   if ( swm_name[j] == subrack_swmod[i] )  
	     	  if ( swm_number[j] < 10 ) 
		     	  subrack_number[i]="0"swm_number[j];
			  else  
		     	  subrack_number[i]=swm_number[j];

    led_rc = 0;
    rgro_rc = 0; 
    scb_rc = 0;   
    while (( getline < data_spas ) > 0 ) {

     	if ( ($2 == "lhsh" ) && ($4 == "spasislledinfo" ) ) {
	         
		    lhsh = $3
		    getline < data_spas;
		    if ( $2 == "Ledstatus" ) {
    			   led_rc++;
			   cISL_LED_lnh[led_rc]=lhsh;
			   if ( $5 ~ /FLICKERING/ ) cISL_LED_p[led_rc,1]="16Hz";
			   else if ( $5 ~ /SLOW/  ) cISL_LED_p[led_rc,1]="5Hz";
			   else if ( $5 ~ /OFF/   ) cISL_LED_p[led_rc,1]="OFF";
			   else if ( $5 ~ /ON/    ) cISL_LED_p[led_rc,1]="ON";
			   else                     cISL_LED_p[led_rc,1]="X";
			   getline < data_spas;
			   if ( $5 ~ /FLICKERING/ ) cISL_LED_p[led_rc,2]="16Hz";
			   else if ( $5 ~ /SLOW/  ) cISL_LED_p[led_rc,2]="5Hz";
			   else if ( $5 ~ /OFF/   ) cISL_LED_p[led_rc,2]="OFF";
			   else if ( $5 ~ /ON/    ) cISL_LED_p[led_rc,2]="ON";
			   else                     cISL_LED_p[led_rc,2]="ERR";
			   getline < data_spas;
			   if ( $5 ~ /FLICKERING/ ) cISL_LED_p[led_rc,3]="16Hz";
			   else if ( $5 ~ /SLOW/  ) cISL_LED_p[led_rc,3]="5Hz";
			   else if ( $5 ~ /OFF/   ) cISL_LED_p[led_rc,3]="OFF";
			   else if ( $5 ~ /ON/    ) cISL_LED_p[led_rc,3]="ON";
			   else                     cISL_LED_p[led_rc,3]="ERR";
			   getline < data_spas;
			   if ( $5 ~ /FLICKERING/ ) cISL_LED_p[led_rc,4]="16Hz";
			   else if ( $5 ~ /SLOW/  ) cISL_LED_p[led_rc,4]="5Hz";
			   else if ( $5 ~ /OFF/   ) cISL_LED_p[led_rc,4]="OFF";
			   else if ( $5 ~ /ON/    ) cISL_LED_p[led_rc,4]="ON";
			   else                     cISL_LED_p[led_rc,4]="ERR";
		    }
		}
		if ( ($2 == "lhsh" ) && ( $4 == "spaspccinfo" ) ) {
		     lhsh=$3
		     getline < data_spas;
			# 0301: Plane Change Control Status:
			if ( $2 == "Plane" ) {
		         scb_rc++
		         cSCB_lnh[scb_rc] = lhsh;
	    
			    getline < data_spas;
			    # 0301: - Active Plane: B
			    cSCB_pcc_ap[scb_rc] = $5;
			    getline < data_spas;
			    # 0301: - Ordered Plane changes: 0 times
			    cSCB_pcc_opc[scb_rc] = $6;
			    getline < data_spas;
			    # 0301: - Total Plane changes: 0 times
			    cSCB_pcc_tpc[scb_rc] = $6;
			    getline < data_spas;
			    # 0301: - Control Plane status: Unlock
			    cSCB_pcc_cps[scb_rc] = $6;
			    getline < data_spas;
			    # 0301: - Operational Plane status: Enable
			    cSCB_pcc_ops[scb_rc] = $6;
			    getline < data_spas;
			    # 0301: - Armed Plane status: Armed
			    cSCB_pcc_aps[scb_rc] = $6;
			    getline < data_spas;
			    # 0301: - Plane A status: Ok
			    cSCB_pcc_pas[scb_rc] = $6
			    getline < data_spas;
			    # 0301: - Plane B status: Ok
			    cSCB_pcc_pbs[scb_rc] = $6
			    getline < data_spas;
			    # 0301: - smAspStatusA: 0
			    cSCB_pcc_smA[scb_rc] = $4
			    getline < data_spas;
			    # 0301: - smAspStatusB: 1
			    cSCB_pcc_smB[scb_rc] = $4
			}
		}
		if ( $3 == "ArrivedMaintenanceCells_31:" ) {
		      if ( substr($1,1,4) == substr(cSCB_lnh[scb_rc],1,4) ) 
			     cSCB_pcc_AMC_31[scb_rc]=$4
		}
		if ( $3 == "ArrivedMaintenanceCells_63:" ) {
		      if ( substr($1,1,4) == substr(cSCB_lnh[scb_rc],1,4) ) 
			     cSCB_pcc_AMC_63[scb_rc]=$4
		}

		if ( $3 == "LostMaintenanceCellsStatus_A_31:" ) {
		      if ( substr($1,1,4) == substr(cSCB_lnh[scb_rc],1,4) ) 
			     cSCB_pcc_LMCS_A_31[scb_rc]=$4
		}
		if ( $3 == "LostMaintenanceCellsStatus_A_63:" ) {
		      if ( substr($1,1,4) == substr(cSCB_lnh[scb_rc],1,4) ) 
			     cSCB_pcc_LMCS_A_63[scb_rc]=$4
		}
		if ( $3 == "LostMaintenanceCellsStatus_B_31:" ) {
		      if ( substr($1,1,4) == substr(cSCB_lnh[scb_rc],1,4) ) 
			     cSCB_pcc_LMCS_B_31[scb_rc]=$4
		}
		if ( $3 == "LostMaintenanceCellsStatus_B_63:" ) {
		      if ( substr($1,1,4) == substr(cSCB_lnh[scb_rc],1,4) ) 
			     cSCB_pcc_LMCS_B_63[scb_rc]=$4
		}
		if ( $3 == "PlaneStatus_A_31:" ) {
		      if ( substr($1,1,4) == substr(cSCB_lnh[scb_rc],1,4) ) 
			     cSCB_pcc_PS_A_31[scb_rc]=$4
		}
		if ( $3 == "PlaneStatus_A_63:" ) {
		      if ( substr($1,1,4) == substr(cSCB_lnh[scb_rc],1,4) ) 
			     cSCB_pcc_PS_A_63[scb_rc]=$4
		}
		if ( $3 == "PlaneStatus_B_31:" ) {
		      if ( substr($1,1,4) == substr(cSCB_lnh[scb_rc],1,4) ) 
			     cSCB_pcc_PS_B_31[scb_rc]=$4
		}
		if ( $3 == "PlaneStatus_B_63:" ) {
		      if ( substr($1,1,4) == substr(cSCB_lnh[scb_rc],1,4) ) 
			     cSCB_pcc_PS_B_63[scb_rc]=$4
		}
				
	     if ( ($2 == "lhsh" ) && ( $4 == "spasrgroinfo" ) ) {
	       # index for rgro records
		  lhsh=$3
		  getline < data_spas;
		  if ( $2 == "RgRo" ) {
	     	 rgro_rc++;
			 cISL_rg_lnh[rgro_rc]=lhsh;
      		 # index for RgRo instances in RgRo records
  			 cISL_rg_p[rgro_rc]=0;

			 getline < data_spas;
			 while ($0 !~ /^=.*/ ) {
		     	 if ($4 ~ /RgRo.[0-9]./ ) {
			     	 #  0005: Data for RgRo[0] is
			     	 cISL_rg_p[rgro_rc]++;
					 cISL_rg_pid[rgro_rc,cISL_rg_p[rgro_rc]]=substr($4,index($4,"[")+1,1);
					 getline < data_spas;
					 #  0005:   Other APN 0, Other Port 0, Other EAPN 0
					 if ( (length($7) - 1) == 1 )
					     cISL_rg_other_port[rgro_rc,cISL_rg_p[rgro_rc]]=substr($7,1,1); 
					 else {
					     print "ERROR occured when parsing RgRo for port: "cISL_rg_pid[rgro_rc,cISL_rg_p[rgro_rc]]": "$0
						 cISL_rg_other_port[rgro_rc,cISL_rg_p[rgro_rc]]=-1;
					 }				  
					 
					 if ( (length($4)-1) == 1 )
					     cISL_rg_other_lnh[rgro_rc,cISL_rg_p[rgro_rc]]=substr(cISL_rg_lnh[rgro_rc],1,2)"0"substr($4,1,1)"00"; 
					 else if ( (length($4)-1) == 2 )	 
					     cISL_rg_other_lnh[rgro_rc,cISL_rg_p[rgro_rc]]=substr(cISL_rg_lnh[rgro_rc],1,2)substr($4,1,2)"00"; 
					 else {
					     print "ERROR occured when parsing RgRo for port: "cISL_rg_pid[rgro_rc,cISL_rg_p[rgro_rc]]": "$0
						 cISL_rg_other_lnh[rgro_rc,cISL_rg_p[rgro_rc]]="XXPPPP"
                     }   					 
					 getline < data_spas;
					 #  0005:   ExtensionSm 1, Extension APN 0, ExtensionPort 2  LinkTableEntry 0
					 if ( substr(cISL_rg_lnh[rgro_rc],2,1) == "0" ) {
					    if ( ((length($3) - 1) == 1) && ((length($6)-1) == 1 ) )
						    cISL_rg_ext_lnh[rgro_rc,cISL_rg_p[rgro_rc]]="0"substr($3,1,index($3,",")-1)"0"substr($6,1,1)"00"
						else if ( ((length($3) - 1) == 2 ) && ((length($6)-1) == 1 )) 	
						    cISL_rg_ext_lnh[rgro_rc,cISL_rg_p[rgro_rc]]=substr($3,1,index($3,",")-1)"0"substr($6,1,1)"00"
						else if ( ((length($3) - 1) == 2 ) && ((length($6)-1) == 2 )) 
						    cISL_rg_ext_lnh[rgro_rc,cISL_rg_p[rgro_rc]]=substr($3,1,index($3,",")-1)substr($6,1,index($6,",")-1)"00"	    
						else if ( ((length($3) - 1) == 1 ) && ((length($6)-1) == 2 )) 
						    cISL_rg_ext_lnh[rgro_rc,cISL_rg_p[rgro_rc]]="0"substr($3,1,index($3,",")-1)substr($6,1,index($6,",")-1)"00"	    
						else {
                                print "ERROR occured when parsing RgRo for port: "cISL_rg_pid[rgro_rc,cISL_rg_p[rgro_rc]]": "$0
                                cISL_rg_ext_lnh[rgro_rc,cISL_rg_p[rgro_rc]]="XXXXXX"								
							}
						}
					 else
				     	cISL_rg_ext_lnh[rgro_rc,cISL_rg_p[rgro_rc]]="N/A";

					 cISL_rg_ext_port[rgro_rc,cISL_rg_p[rgro_rc]]=$8; 
					 getline < data_spas; 
					 # 0005:   MaintStatOwn 8, MainStatOther 8
					 cISL_rg_state_own[rgro_rc,cISL_rg_p[rgro_rc]]=substr($3,1,1); 
					 cISL_rg_state_other[rgro_rc,cISL_rg_p[rgro_rc]]=$5;
					 getline < data_spas;
					 # 0005:   Working 5, Supervise 5 (1=Own, 2=Other,3=Both)
					 getline < data_spas;
					 #  0005:   MainStatOwnPhysLink 8, MainStatOtherPhysLink 8 (6=Enabled, 8=Disabled, 1=Unknown)
					 cISL_rg_state_phy_own[rgro_rc,cISL_rg_p[rgro_rc]]= substr($3,1,1);
					 cISL_rg_state_phy_other[rgro_rc,cISL_rg_p[rgro_rc]]=$5;
					 getline < data_spas;
					 # 0005:   RelGroupRoState 3 (1=Init, 2=Announce, 3=Stopped, 4=Created, 5=InitStopped
					 cISL_rg_RoState[rgro_rc,cISL_rg_p[rgro_rc]]=$3;

		         }
			    getline < data_spas;
	     	 }
		  }
	   }
	   # THIS PART DOESN'T WORK FOR SCB-DF/TF
	   if ( ($2 ~ /SILI[0-9]_port/ ) && ( $4 == "Connected" ) ) {
	       if ( substr($1,1,4) == substr(cISL_rg_lnh[rgro_rc],1,4)) {
		      if ( cISL_rg_pid[rgro_rc,substr($2,5,1)+1] == substr($2,5,1)) {
			     port=substr($2,5,1)+1;
				bad_c=0;
			     getline < data_spas;
				# getline < data_spas
				# 0901: Reset counter            : 0
				if ( $2 == "Reset") {
				    if ( $5 > 100 ) {bad_c++; cISL_rg_port_error[rgro_rc,port]=", M15: "cISL_rg_lnh[rgro_rc]" port:"port-1" - "bad_c" counter(s) looks bad";}
				    getline < data_spas; 
				}
				# 0901: Lost connection          : 1
				if ( $2 == "Lost" ) {
				    if ( $5 > 100 ) {bad_c++; cISL_rg_port_error[rgro_rc,port]=", M15: "cISL_rg_lnh[rgro_rc]" port:"port-1" - "bad_c" counter(s) looks bad";}
				    getline < data_spas;
				}
				# 0901: Error, reg 1008          : 0
				if ( $2 == "Error," ) {
                        if ( $6 > 100 ) {bad_c++; cISL_rg_port_error[rgro_rc,port]=", M15: "cISL_rg_lnh[rgro_rc]" port:"port-1" - "bad_c" counter(s) looks bad";}
				    getline < data_spas;
				}
				# 0901: Discarded cells, reg 1010: 0
				if ( $2 == "Discarded" ) {
				    if ( $6 > 100 ) {bad_c++; cISL_rg_port_error[rgro_rc,port]=", M15: "cISL_rg_lnh[rgro_rc]" port:"port-1" - "bad_c" counter(s) looks bad";}
				    getline < data_spas;
				}
				# 0901: SAI & SILI error status 1, reg 2001:
				if ( $2 == "SAI" )  
				    getline < data_spas;				
				# 0901: - Ingr stage addr error  : 0
				if ( $3 == "Ingr" ) {
				    if ( $8 > 100 ) {bad_c++; cISL_rg_port_error[rgro_rc,port]=", M15: "cISL_rg_lnh[rgro_rc]" port:"port-1" - "bad_c" counter(s) looks bad";}
				    getline < data_spas;
				}    
				# 0901: - Tag parity error       : 0
				if ( $3 == "Tag" ) {				
				    if ( $7 > 100 ) {bad_c++; cISL_rg_port_error[rgro_rc,port]=", M15: "cISL_rg_lnh[rgro_rc]" port:"port-1" - "bad_c" counter(s) looks bad";}
				    getline < data_spas;
				}
				# 0901: SAI & SILI error status 2, reg 2002:    
          		if ( $2 == "SAI" )  
				    getline < data_spas;	
				# 0901: - Cell size error        : 0
				if ( $3 == "Cell" ) {
				    if ( $7 > 100 ) {bad_c++; cISL_rg_port_error[rgro_rc,port]=", M15: "cISL_rg_lnh[rgro_rc]" port:"port-1" - "bad_c" counter(s) looks bad";}
				    getline < data_spas;
				}    
				# 0901: - Null detected          : 0
				if ( $3 == "Null" ) 
				    if ( $6 > 100 ) {bad_c++; cISL_rg_port_error[rgro_rc,port]=", M15: "cISL_rg_lnh[rgro_rc]" port:"port-1" - "bad_c" counter(s) looks bad";}
			 }
 
	       }
        }
	 
    }
    close(data_spas);

#    exit;
    print "Legend:"
    print "+ Act.Pl - Active plane"
    print "+ OPC - Ordered Plane Changes"
    print "+ TPC - Total Plane Changes"
    print "+ CPS - Control Plane Status"
    print "+ OPS - Operation Plane Status"
    print "+ PAS - Plane A Status"
    print "+ PBS - Plane B Status"
    print "+ STATE - ISL MO state administrative/OperationalTraffic/OperationalSync"
    print "+ RgRoSv - RgRo active supervision"
    print "+ P - port"
    print ""
    print "SCB status table according to SPAS coli output."
    printf("%s\n %6s | %6s | %5s | %5s | %7s | %8s | %8s | %3s | %3s | %8s | %s\n%s\n",a,"SCB","Act.Pl","OPC","TPC","CPS","OPS","Armed","PAS","PBS","AMC","WARNINGS",a);
    for ( i=1; i<=scb_rc; i++ ) {
       err_status="-"
	  if ( (cSCB_pcc_ap[i] != "A") && (cSCB_pcc_ap[i] != "B") )
	      err_status=err_status", H12: No active plane selected";
	  if ( (cSCB_pcc_tpc[i] - cSCB_pcc_opc[i] ) > 100 ) 
	      err_status=err_status", M05: Too many plane changes:"cSCB_pcc_tpc[i];	 
	  if ( cSCB_pcc_cps[i] != "Unlock" )
	      err_status=err_status", L06: Plane is "cSCB_pcc_cps[i];
	  if	( cSCB_pcc_ops[i] != "Enable" )
	      err_status=err_status", H13: Plane is "cSCB_pcc_ops[i]; 	 
	  if ( cSCB_pcc_aps[i] != "Armed" )
	      err_status=err_status", M06: Plane is not reliable";	 
	  if ( cSCB_pcc_pas[i] != "Ok" )
	      if (substr(cSCB_lnh[i],3,2) == "01" )
		     err_status=err_status", M07: Plane is not ok";	
		 else
		     err_status=err_status", M08: Remote plane is not ok";
	  if ( cSCB_pcc_pbs[i] != "Ok" )
	      if (substr(cSCB_lnh[i],3,2) == "00" )
		     err_status=err_status", M07: Plane is not ok";	
		 else
		     err_status=err_status", M08: Remote plane is not ok";
       if (substr(cSCB_lnh[i],3,2) == "00" )
	       remote_plane=substr(cSCB_lnh[i],1,2)"0100";		
	  else
  	       remote_plane=substr(cSCB_lnh[i],1,2)"0000";

	  if ( (cSCB_pcc_LMCS_A_31[i] != "00000000") && (length(cSCB_pcc_LMCS_A_31[i]) > 0 ) )	
	        err_status=err_status", M10: Plane lost maintenance cells, A_31 status:"cSCB_pcc_LMCS_A_31[i];
	  if ( (cSCB_pcc_LMCS_A_63[i] != "00000000") && (length(cSCB_pcc_LMCS_A_63[i]) > 0 ) )	
	        err_status=err_status", M10: Plane lost maintenance cells, A_63 status:"cSCB_pcc_LMCS_A_63[i];
       if ( (cSCB_pcc_LMCS_B_31[i] != "00000000" ) && (length(cSCB_pcc_LMCS_B_31[i]) > 0 ))	
	        err_status=err_status", M10: Plane lost maintenance cells, B_31 status:"cSCB_pcc_LMCS_B_31[i];		   		     		
       if ( (cSCB_pcc_LMCS_B_63[i] != "00000000") && (length(cSCB_pcc_LMCS_B_63[i]) > 0 ) )	
	        err_status=err_status", M10: Plane lost maintenance cells, B_63 status:"cSCB_pcc_LMCS_B_63[i];
	  if ( (cSCB_pcc_PS_A_31[i] != "00000000") && (length(cSCB_pcc_PS_A_31[i]) > 0 ) )
	        err_status=err_status", M10: Plane status is not OK, A_31 status:"cSCB_pcc_PS_A_31[i];	   		   
	  if ( (cSCB_pcc_PS_A_63[i] != "00000000") && (length(cSCB_pcc_PS_A_63[i]) > 0 ) )
	        err_status=err_status", M10: Plane status is not OK, A_63 status:"cSCB_pcc_PS_A_63[i];	 	   
	  if ( (cSCB_pcc_PS_B_31[i] != "00000000") && (length(cSCB_pcc_PS_B_31[i]) > 0 ) )
	        err_status=err_status", M10: Plane status is not OK, B_31 status:"cSCB_pcc_PS_B_31[i];	   		   
	  if ( (cSCB_pcc_PS_B_63[i] != "00000000") && (length(cSCB_pcc_PS_B_63[i]) > 0 ) )
	        err_status=err_status", M10: Plane status is not OK, B_63 status:"cSCB_pcc_PS_B_63[i];
	 	   	 	   		   
       found=0
	  for ( j=1; j<=scb_rc; j++ ) 
	      if ( cSCB_lnh[j] == remote_plane ) {
		     found++
			if ( (cSCB_pcc_AMC_31[i] != cSCB_pcc_AMC_31[j] ) && (length(cSCB_pcc_AMC_31[i])+length(cSCB_pcc_AMC_31[j]) == 16) ) 
			    err_status=err_status", H11: Board "cSCB_lnh[i]" and "remote_plane" see different board setup "cSCB_pcc_AMC_31[i]" <> "cSCB_pcc_AMC_31[j]
			if ( cSCB_pcc_ap[i] != cSCB_pcc_ap[j] )
			    err_status=err_status", H15: Remote plane "cSCB_lnh[j]" has different opinion about active plane:"cSCB_pcc_ap[j];
			    
		 }
	 if ( found == 0 )
	     err_status=err_status", H14: Remote plane "remote_plane" is unavailable"
	 else if ( found !=1 )
	     err_status=err_status"; ER: Unable to find remote plane"remote_plane" script error !"	
	 if (length(err_status) > 1 )
	      err_status=substr(err_status,4)	
	 printf(" %6s | %6s | %5s | %5s | %7s | %8s | %8s | %3s | %3s | %8s | %s\n",cSCB_lnh[i],cSCB_pcc_ap[i],cSCB_pcc_opc[i],cSCB_pcc_tpc[i],cSCB_pcc_cps[i],cSCB_pcc_ops[i],cSCB_pcc_aps[i],cSCB_pcc_pas[i],cSCB_pcc_pbs[i],cSCB_pcc_AMC_31[i],err_status);
    }
    print a;
    print "Informatin about consistency between SwitchInternalLink and RgRo. In the table you may see configuration and"
    print "status based on MO configuration. In WARNINGs column you may observed inconsistency warnings"
    
    printf("%s\n%14s | %5s | %4s | %6s | %6s | %1s | %3s  <->  %3s | %1s | %6s | %6s | %4s | %s\n%s\n",a,"ISL MO","STATE","SUB","SCB  1","RgRoSv","P","LED","LED","P","RgRoSv","SCB  2","SUB","WARNINGS",a);
    for ( i=1; i<=isl_num; i++ ) {
         split(isl_slot1[i],slot_elem,",");
	    slotA=substr(slot_elem[2],index(slot_elem[2],"=")+1);
	    subA=slot_elem[1];
	    if (length(slotA) < 2) slotA="0"slotA;
    	    if (slotA == 28 ) slotA="00";

	    split(isl_slot2[i],slot_elem,",");
	    slotB=substr(slot_elem[2],index(slot_elem[2],"=")+1);
	    subB=slot_elem[1];
	    if (length(slotB) < 2) slotB="0"slotB;
	    if (slotB == 28 ) slotB="00";

	    for (j=1; j<=sub_num; j++ ) {

	         if ( subrack_name[j] == subA ) {
		        isl_subname1[i]=subrack_lname[j];
			   isl_slot1_lnh[i]=subrack_number[j]slotA"00"

		    }
		    if ( subrack_name[j] == subB ) {
		        isl_subname2[i]=subrack_lname[j];
			   isl_slot2_lnh[i]=subrack_number[j]slotB"00"

		    }
	    }
	    err_status="-"	
	    rgro_found=0
    	    remote_led="X";
	    local_led="X";
	    s_sv_local="X"
	    s_sv_ext="X"
	    for ( p=1; p<=rgro_rc; p++ ) 
	        if ( cISL_rg_lnh[p] == isl_slot1_lnh[i] ) {
		       rgro_found++
     	       if ( cISL_rg_pid[p,isl_siliport1[i]+1] != isl_siliport1[i] )
			  	  err_status=err_status", L01: Port doesn't match: "isl_siliport1[i]" <> "cISL_rg_pid[p,isl_siliport1[i]+1] 
		       if ( cISL_rg_ext_lnh[p,isl_siliport1[i]+1] != 	isl_slot2_lnh[i] )
			       err_status=err_status", H01: Remote slot mismatch - MO: "isl_slot2_lnh[i]" RO: "cISL_rg_ext_lnh[p,isl_siliport1[i]+1];
			  if (cISL_rg_ext_port[p,isl_siliport1[i]+1] != isl_siliport2[i])	  
			       err_status=err_status", H02: Remote port mismatch - MO:"isl_siliport2[i]" RO: "cISL_rg_ext_port[p,isl_siliport1[i]+1];
			  if (cISL_rg_state_own[p,isl_siliport1[i]+1] != cISL_rg_state_phy_own[p,isl_siliport1[i]+1])
			       err_status=err_status", M01: RO port state is not consistent";
			  if ( length ( cISL_rg_other_port[p,isl_siliport1[i]+1] ) == 1 )	   {
     			  if ((cISL_rg_pid[p,isl_siliport1[i]+1] != cISL_rg_other_port[p,isl_siliport1[i]+1]) && (cISL_rg_RoState[p,isl_siliport1[i]+1] == 4 ) && (cISL_rg_other_lnh[p,isl_siliport1[i]+1]!="XXXXXX") )
	    		       err_status=err_status", H03: Another plane: "cISL_rg_other_lnh[p,isl_siliport1[i]+1]" is using different port: "cISL_rg_other_port[p,isl_siliport1[i]+1];
				  }	   
			 else if ( length(cISL_rg_other_port[p,isl_siliport1[i]+1]) > 1 )
            	   err_status=err_status", H04: Active RgRo SCB has misconfiguration - another plane port is out of range";
			 else
			       err_status=err_status", ER: Script failed to parse RgRo configuration for this port "cISL_rg_other_port[p,isl_siliport1[i]+1];	   
			 if ( length(cISL_rg_other_lnh[p,isl_siliport1[i]+1]) != 6 ) {	
			    print cISL_rg_other_lnh[p,isl_siliport1[i]+1]":"length(cISL_rg_other_lnh[p,isl_siliport1[i]+1])
                   err_status=err_status", ER: Script failed to parse RgRo configuration for another board"	   			 ;
			    }
			  if ((cISL_rg_RoState[p,isl_siliport1[i]+1] == 4 ) && (cISL_rg_other_lnh[p,isl_siliport1[i]+1]=="XXXXXX"))
			       err_status=err_status", H05: Active RgRo SCB has misconfiguration - another plane APN is out of range";
			  if (isl_state_oper_traffic[i] != 1) 
			       err_status=err_status", M02: ISL link is down";

			  if (isl_state_oper_sync[i] != 1)
			       err_status=err_status", M03: Time sync over ISL is down";	  
			  if ((cISL_rg_state_own[p,isl_siliport1[i]+1] != 6) && (cISL_rg_RoState[p,isl_siliport1[i]+1] == 4 ))
			       err_status=err_status", H06: Port is down";
			  
	            err_status=err_status""cISL_rg_port_error[p,isl_siliport1[i]+1];
			  if ( cISL_rg_lnh[p] == cISL_rg_other_lnh[p,isl_siliport1[i]+1] ) {
			  	  if ( substr(cISL_rg_lnh[p],3,2) == "00" )
				      s_rem_lnh=substr(cISL_rg_lnh[p],1,2)"0100"
				  else
				      s_rem_lnh=substr(cISL_rg_lnh[p],1,2)"0000"	 
				  err_status=err_status", L04: Inactive RgRo doesn't have right info about other plane, picked "s_rem_lnh;
			  }
			  else
			      s_rem_lnh=cISL_rg_other_lnh[p,isl_siliport1[i]+1];
				 			  
			  if ( cISL_rg_RoState[p,isl_siliport1[i]+1] == 4 ) 
			       
				  s_sv_local=cISL_rg_lnh[p];
			  else if ( cISL_rg_lnh[p] != cISL_rg_other_lnh[p,isl_siliport1[i]+1] )
			       s_sv_local=cISL_rg_other_lnh[p,isl_siliport1[i]+1];
			  else
			       s_sv_local=s_rem_lnh	  
				  
			  # To check own port conditions from RgRo supervision board
			  p_rgro_found=0;
			  if ( cISL_rg_RoState[p,isl_siliport1[i]+1] != 4 )  {
			       for ( k=1; k<=rgro_rc; k++ ) 

               	      if ( cISL_rg_lnh[k] == s_rem_lnh ) {			
					     p_rgro_found++;
					     # cISL_rg_other_port[rgro_rc,cISL_rg_p[rgro_rc]]
						if ( (cISL_rg_other_port[k,isl_siliport1[i]+1] != isl_siliport1[i]) && (length(cISL_rg_other_port[k,isl_siliport1[i]+1]) == 1) )
						    err_status=err_status", L05: Port mismatch inactive RgRO:"cISL_rg_other_port[k,isl_siliport1[i]+1]" MO:"isl_siliport1[i];
						else if ( cISL_rg_other_port[k,isl_siliport1[i]+1] == "-1" )	
						    err_status=err_status", L02: Port for inactive RgRO is out of range, check active RgRo settings";
					    if ((cISL_rg_state_other[k,isl_siliport1[i]+1] != 6) && (cISL_rg_RoState[k,isl_siliport1[i]+1] == 4 ))
			                   err_status=err_status", H07: Active port is down";
			           }  
			        if ( p_rgro_found == 0 ) err_status=err_status", ER: RgRo not found for other plane "cISL_rg_other_lnh[p,isl_siliport1[i]+1] 	 		  	  
			  }

			  p_rgro_found=0;	  	  
			  for ( k=1; k<=rgro_rc; k++ )
			      if ( cISL_rg_lnh[k] == 	cISL_rg_ext_lnh[p,isl_siliport1[i]+1] ) {
				     p_rgro_found++
                         if ( cISL_rg_pid[k,cISL_rg_ext_port[p,isl_siliport1[i]+1]+1] != isl_siliport2[i] )
			  	         err_status=err_status", L03: Ext Port doesn't match: "isl_siliport2[i]" <> "cISL_rg_pid[p,cISL_rg_ext_port[p,isl_siliport1[i]+1]]+1 
			     	if (cISL_rg_state_own[k,cISL_rg_ext_port[p,isl_siliport1[i]+1]+1] != cISL_rg_state_phy_own[k,cISL_rg_ext_port[p,isl_siliport1[i]+1]+1])
			          	err_status=err_status", M04: Ext. RO port state is not consistent";
			     	if ((cISL_rg_pid[k,cISL_rg_ext_port[p,isl_siliport1[i]+1]+1] != cISL_rg_other_port[k,cISL_rg_ext_port[p,isl_siliport1[i]+1]+1]) && (cISL_rg_RoState[k,cISL_rg_ext_port[p,isl_siliport1[i]+1]+1] == 4))
			          	err_status=err_status", H08: Ext Another plane: "cISL_rg_other_lnh[k,cISL_rg_ext_port[p,isl_siliport1[i]+1]+1]" is using different port: "cISL_rg_other_port[k,cISL_rg_ext_port[p,isl_siliport1[i]+1]+1];
					if ( cISL_rg_RoState[k,cISL_rg_ext_port[p,isl_siliport1[i]+1]+1] == 4 ) 
 			                s_sv_ext=cISL_rg_lnh[k];	

			          else
					      # WORK AROUND, because in ES other_lnh has always wrong subrack 00
              				 s_sv_ext=substr(cISL_rg_lnh[k],1,2)substr(cISL_rg_other_lnh[k,cISL_rg_ext_port[p,isl_siliport1[i]+1]+1],3,4);
           	          err_status=err_status""cISL_rg_port_error[k,cISL_rg_ext_port[p,isl_siliport1[i]+1]+1];
                         break;					    
				 }
			  if ( p_rgro_found == 0 ) err_status=err_status", ER: RgRo not found for external plane "cISL_rg_ext_lnh[p,isl_siliport1[i]+1] 	 
			  for ( j=1; j<=led_rc; j++) {
			      if ( cISL_LED_lnh[j] == cISL_rg_lnh[k] ) { led_found_a++; remote_led=cISL_LED_p[j,isl_siliport2[i]+1]; }
				 if ( cISL_LED_lnh[j] == cISL_rg_lnh[p] ) { led_found_b++; local_led=cISL_LED_p[j,isl_siliport1[i]+1];  }
			  }

  			  if ( (local_led == "ON") && (remote_led == "ON") && (isl_state_admin[i] != 0))
			      err_status=err_status", H16: Link is locked according to LEDs, but not according to MO"	 
				 
  			  if ( (local_led == "OFF") && (remote_led == "OFF") )
			      err_status=err_status", M16: No connection"	 
  			  if ( (local_led == "OFF") && (remote_led == "ON") )
			      err_status=err_status", H17: Wrong cable connection"	 				 
  			  if ( (local_led == "ON") && (remote_led == "OFF") )
			      err_status=err_status", H17: Wrong cable connection"
				 	 				 				 
				 	 
			  break  	  	  
		   }
	    #printf("%8s | %4s | %4s | %10s | %10s | %s/%s/%s | %3s | %3s | %s\n",isl_id[i],isl_subname1[i],isl_subname2[i],isl_slot1_lnh[i],isl_slot2_lnh[i],isl_state_admin[i],isl_state_oper_traffic[i],isl_state_oper_sync[i],isl_siliport1[i],isl_siliport2[i],err_status);
	    if (rgro_found == 0) {
               err_status=err_status", ER: RgRo not found for "isl_slot1_lnh[i]
	    }	    
         if (length(err_status) > 1 )
	      err_status=substr(err_status,4)
	 
	    printf("%14s | %s/%s/%s | %4s | %6s | %6s | %1s | %4s <-> %4s | %1s | %6s | %6s | %4s | %s\n",isl_id[i],isl_state_admin[i],isl_state_oper_traffic[i],isl_state_oper_sync[i],isl_subname1[i],isl_slot1_lnh[i],s_sv_local,isl_siliport1[i],local_led,remote_led,isl_siliport2[i],s_sv_ext, isl_slot2_lnh[i],isl_subname2[i],err_status);
    }
    
    print a;
    if ( (( rgro_rc - scb_rc ) != 0 ) && ( scb_rc != led_rc ) )
        print "WARNING ! SPAS coli printouts are inconsistant, please run script again or check results menually";
    else if ( (scb_rc % 2 ) != 0 )
        print "WARNING ! SPAS coli printouts are missing from one or more SCB, please check results carefully";
    errors=0
    while (( getline < data_clock ) > 0 ) {
        if ( ($2 == "lhsh") && ($4 == "spashwinfo" ) ) {
	       err_status="-"
	       slot_lnh= $3
	       getline < data_clock
		  # 0926: HW Clock Status:
		  if ( $2 == "HW" ) {
          	  getline < data_clock
			  # 0926: - Current_clk : A
			  if ( ($5 != "A") && ($5 != "B") ) 
		     	 err_status=err_status", M11: Running on internal clock"
			  getline < data_clock
			  # 	 0926: - Clk_A_stat : Ok
			  getline < data_clock
			  #   0926: - Clk_B_stat : Ok
			  getline < data_clock
			  # 0926: - Local_clk_stat : Ok
			  getline < data_clock
			  # 0926: Clock Settings  : Status
			  getline < data_clock
			  # 0926: - Clock select  : 3 Auto
          	  getline < data_clock
			  # 0926: - First choice  : 0 A
			  getline < data_clock
			  # 0926: - Second choice : 1 B
			  getline < data_clock
			  # 0926: Clock Debug counters:
			  getline < data_clock
			  # 0926: - Total clock switches : 0
          	  if ( $7 > 100 )
		     	 err_status=err_status", M13: Experienced too many "$7" clock plane changes"
			  getline < data_clock
			  # 0926: - Clk_A selections : 1
			  Clk_A_s=$6
			  getline < data_clock
			  # 0926: - Clk_A Errors     : 0
			  if ( $6 > 100 )
		     	 err_status=err_status", M12: Clock plane A has too many "$6" errors occured"	 
			  getline < data_clock
			  # 0926: - Clk_B selections : 0
			  Clk_B_s=$6
			  getline < data_clock
			  # 	0926: - Clk_B Errors     : 0
			  if ( $6 > 100 )
		     	 err_status=err_status", M12: Clock plane B has too many "$6" errors occured" 
          	  getline < data_clock		 
			  # 0926: - LocalClk selections : 0
			  if ( $6 > (Clk_A_s + Clk_B_s ) )
		     	 err_status=err_status", M14: Selected internal clock more often "$6" times then plane A and B all together"
		  }	else
		      err_status=err_status", not available"; 
		  if (length(err_status)>1) 	{ 
		      printf("Board: %6s - %s\n",slot_lnh,substr(err_status,4));	 
			 errors++
            } 
		  
	   }
    }
    close(data_clock);
	print "Information about power measurements for each subrack. This information is only valid for subracks with SCB-TF boards.";
	printPwrLine=0;
	while (( getline < data_pwr ) > 0 ) {
		#Alfa> lh scb pboot sh pa | grep productname
		#
		#120323-19:29:15 10.67.25.84 8.0z CPP_MOM-CPP-C12-LSV89.5_gen3_COMPLETE stopfile=/tmp/17563
		#0000: *productname=SCB-DF
		#0001: *productname=SCB-DF
		#0100: *productname=SCB-TF
		#0101: *productname=SCB-TF
		if ($0 ~ /productname/) {
			split($0, boards, ":");
			board = boards[1];
			split(boards[2], types, "=");
			type = types[2];
			if (board ~/^0/) {
				t_subrackNo = substr(board, 2, 1);
			} else {
				t_subrackNo = substr(board, 1, 2);
			}
			t_slotNo = substr(board, 4, 1);
			boardMap[t_subrackNo, t_slotNo] = type;
		}

		if ($0 ~ /=====/) {
			printPwrLine++;
		}

		if (printPwrLine > 0) {
			infoText = "";
			if ($1 == "MO") {
				$2 = "Subrack";
				infoText = "Information";
			}

			if ($0 ~ /====/) {
				printf("%s%s\n", $0, "====");
			} else {
				if ($1 ~ /^Subrack=/) {
					subrackNo = -1;
					for (i=1; i <=swm_num; i++) {
						split(swm_name[i], parts, "=");
						if (parts[2] == $2) {
							subrackNo = swm_number[i];
							break;
						}
					}

					if (subrackNo > -1) {
						left = boardMap[subrackNo, 1];
						right = boardMap[subrackNo, 0];
						if (left !~ /SCB-TF/) {
							$3 = "N/A";
							$6 = "N/A";
						}

						if (right !~ /SCB-TF/) {
							$4 = "N/A";
							$7 = "N/A";
						}

						if (right !~ /SCB-TF/ && left !~ /SCB-TF/) {
							$5 = "N/A";
							infoText = "Power measurements is only for SCB-TF";
						}

					} else {
						infoText = "ERROR: Unable to map board no subrack number";
					}
					printf("%7s | %9s | %6s | %7s | %7s | %6s | %7s | %7s | %s\n", $2, $5, left, $3, $6, right, $4, $7, infoText);
				} else {
					printf("%19s | %-26s | %-26s |\n", "", "Left", "Right");
					printf("%7s | %9s | %-6s | %7s | %7s | %-6s | %7s | %7s | %s\n", "Subrack", "Dist. pwr", "Type", "Current", "Voltage", "Type", "Current", "Voltage", "Information");
					}
		
#printf("%7s | %11s | %12s | %16s | %11s | %12s | %s\n", $2, $3, $4, $5, $6, $7, infoText);
			}
		}

		if (printPwrLine == 3) {
			printPwrLine = 0;
		}
	}
	close(data_pwr);
    if (errors>0)
        print a;	   
    printf ("MO printouts: %s\nSPAS coli printouts: %s\nSPAS HW Clock setup: %s\nPower measurements: %s\n",data_mo,data_spas,data_clock,data_pwr)
    print a;


}
