#!/usr/bin/perl -w  

###############################################################################
#                                                                             #
# © Ericsson AB 2014 - All Rights Reserved                                   #
#                                                                             #
# The copyright to the computer program(s) herein is the property of Ericsson #
# AB, Sweden. The programs may be used and/or copied only with the written    #
# permission from Ericsson AB or in accordance with the terms and conditions  #
# stipulated in the agreement/contract under which the program(s) have been   #
# supplied.                                                                   #
#                                                                             #
###############################################################################

use strict;
require Digest::Perl::MD5;
import Digest::Perl::MD5 'md5_hex';
use bigint;
no warnings 'portable';


while (<>) {
	
        ## Censure bus message lines
        if (/^[0-9]|BUS (SEND|RECEIVE)/)
        {
            next;
        }

        ## Hash the imsi and match the length of the original imsi - with md5 module
        if (/(IMSI *[:=]* *)(\d{3})(\d{11,15})/)
        {
            my $imsi;
            my $x = substr(Digest::Perl::MD5::md5_hex($3) , -(length($3)+1));
            $imsi = substr(hex("$x"),-length($3));
            s/(IMSI *[:=]* *)(\d{3})(\d{11,15})/$1$2$imsi/;
        }  
        ## Hash the imei and match the length of the original imei - with md5 module
        if (/(IMEISV *[:=]* *)(\d{8})(\d{6})(\d{2})/)
        {
            my $imei;
            my $x = substr(Digest::Perl::MD5::md5_hex($3),-(length($3)+2));
            $imei = substr(hex("$x"), -length($3));
            s/(IMEISV *[:=]* *)(\d{8})(\d{6})(\d{2})/$1$2$imei$4/;
        }

        print $_;
    }




