#Execute with:
# lh ru llog -l | $gawk -f /path/to/parse_llog.awk [-v int_crash=XXX -v int_reg=YYY -v int_prog=ZZZ]   (the -v are optional)
BEGIN{ 
	if (int_crash=="") int_crash=150
	if (int_reg=="")   int_reg=210
	if (int_prog=="")  int_prog=30
	n=split("No|Reason|Time|Program|Pid|Rank|Signal|PMD|Extra",a,/\|/) 
	for (i in a) f[i]=a[i]":" 
}
{gsub("\r","") ; gsub("\x00","") }
$2~/^(No|Reason|Time|Program|Pid|Rank|Signal|PMD|Extra):$/ { 
	if ($2=="No:" && $3~/^[1-9][0-9]*$/) {e=$3;b=$1 }
	r[e,b,$2]=gensub(/^[^ \t]+[ \t]+[^ \t]+[ \t]+/,"",1,$0) 
	if ($2=="Time:") r[e,b,"timestamp"]=make_timestamp($3,$4)
	next
}
$2~/^-----------------+$/{ next}
$1~/^=================+$/ || $1=="coli>" || $1=="$" { print_restarts() }
#$2=="lhsh" { bd=$2 }
#$1=="coli>/fruacc/lhsh" { bd=$2}
{print}
END { print print_restarts() }


function print_restarts()
{
	for (i=e;i>=1;i--)
	{
		if (r[i,b,"No:"]=="") continue
		if (r[i,b,"Extra:"]~/faultId: (0x998|0xf06e) /)
		{
			match(r[i,b,"Extra:"],/faultId: (0x998|0xf06e) /,fI)
			r[i,b,"faultId"]=fI[1] 
		}
		#print i,b,int_prog,r[i,b,"No:"],r[i-1,b,"No:"],r[i,b,"Rank:"],r[i-1,b,"Rank:"],r[i,b,"timestamp"],r[i-1,b,"timestamp"],r[i,b,"Time:"],r[i-1,b,"Time:"]
		if ((r[i,b,"faultId"]!="")&&(((r[i,b,"timestamp"]-r[i-2,b,"timestamp"])<int_crash ||strftime("%Y-%m-%d",r[i-2,b,"timestamp"])=="2000-01-01")&&(r[i-2,b,"Reason:"]=="Program Crash")))
		{
			#BXP_2048: No:       66
			#BXP_2048: Reason:   Program Crash
			#BXP_2048: Time:     2019-10-23 17:32:36
			#BXP_2048: Program:  ngr2.elf
			#BXP_2048: Pid:      782
			#BXP_2048: Rank:     -
			#BXP_2048: Signal:   11
			#BXP_2048: PMD:      /var/log/pmd/pmd-PimDataService-782-20191023-173054.tgz
			#BXP_2048: Extra:    CXP9013268%15_R78LC
			#BXP_2048: ---------------------------------------------------
			#BXP_2048: No:       67
			#BXP_2048: Reason:   Program Crash
			#BXP_2048: Time:     2019-10-23 17:32:36
			#BXP_2048: Program:  -
			#BXP_2048: Pid:      -
			#BXP_2048: Rank:     Cold
			#BXP_2048: Signal:   -
			#BXP_2048: PMD:      -
			#BXP_2048: Extra:    -
			#BXP_2048: ---------------------------------------------------
			#BXP_2048: No:       68
			#BXP_2048: Reason:   Ordered restart
			#BXP_2048: Time:     2019-10-23 17:33:33
			#BXP_2048: Program:  ngr2.elf
			#BXP_2048: Pid:      -
			#BXP_2048: Rank:     Cold
			#BXP_2048: Signal:   -
			#BXP_2048: PMD:      -
			#BXP_2048: Extra:    Application ordered restart, faultId: 0xf06e (Restart), faultDescription: Application ordered restart
			r[i,b,"No:"]=r[i-2,b,"No:"]","r[i-1,b,"No:"]","r[i,b,"No:"]
			if (strftime("%Y-%m-%d",r[i-2,b,"timestamp"])!="2000-01-01") r[i,b,"Time:"]=r[i-2,b,"Time:"]
			r[i,b,"Program:"]=r[i-2,b,"Program:"]
			r[i,b,"Pid:"]=r[i-2,b,"Pid:"]
			r[i,b,"Signal:"]=r[i-2,b,"Signal:"]
			r[i,b,"PMD:"]=r[i-2,b,"PMD:"]
			r[i,b,"Extra:"]="faultId: "r[i,b,"faultId"] " "r[i-2,b,"Extra:"]
			r[i,b,"Reason:"]=r[i-2,b,"Reason:"]
			r[i-1,b,"No:"]=""
			r[i-2,b,"No:"]=""
		}
		else if ((r[i,b,"faultId"]!="")&&(((r[i,b,"timestamp"]-r[i-1,b,"timestamp"])<int_reg)||strftime("%Y-%m-%d",r[i-1,b,"timestamp"])=="2000-01-01"))
		{
			#No:       300
			#Reason:   Ordered restart
			#Time:     2019-10-23 08:50:40
			#Program:  lh_supd					
			#Pid:      -
			#Rank:     Cold
			#Signal:   -
			#PMD:      -
			#Extra:    Restart ordered due to Link timeout
			#---------------------------------------------------
			#No:       301
			#Reason:   Ordered restart
			#Time:     2019-10-23 08:51:33
			#Program:  ngr2.elf
			#Pid:      -
			#Rank:     Cold
			#Signal:   -
			#PMD:      -
			#Extra:    Application ordered restart, faultId: 0xf06e (Restart), faultDescription: Application ordered restart
			r[i,b,"No:"]=r[i-1,b,"No:"]","r[i,b,"No:"]
			r[i,b,"Program:"]=r[i-1,b,"Program:"]
			r[i,b,"Extra:"]="faultId: "r[i,b,"faultId"] " "r[i-1,b,"Extra:"]
			if (strftime("%Y-%m-%d",r[i-1,b,"timestamp"])=="2000-01-01") r[i,b,"Reason:"]=r[i-1,b,"Reason:"]   #Power on, watchdog, etc
			r[i-1,b,"No:"]=""
		}
		else if (((r[i,b,"timestamp"]-r[i-1,b,"timestamp"])<int_prog)&&r[i-1,b,"Rank:"]~/^(-|Program)$/&&r[i,b,"Rank:"]!~/^(-|Program)$/)
		{
			#A program restart escalated to board restart
			#No:       9
			#Reason:   Program Crash
			#Time:     2019-06-24 11:29:16
			#Program:  babeltrace
			#Pid:      11461
			#Rank:     -
			#Signal:   11
			#PMD:      /var/log/pmd/pmd-babeltrace-11461-20190624-112911.tgz
			#Extra:    CXP2030006%1_R41A101
			#---------------------------------------------------
			#No:       10
			#Reason:   Program Crash
			#Time:     2019-06-24 11:29:16
			#Program:  -
			#Pid:      -
			#Rank:     Cold
			#Signal:   -
			#PMD:      -
			#Extra:    -
			r[i,b,"No:"]=r[i-1,b,"No:"]","r[i,b,"No:"]
			r[i,b,"Reason:"]=r[i-1,b,"Reason:"]
			r[i,b,"Program:"]=r[i-1,b,"Program:"]
			r[i,b,"Pid:"]=r[i-1,b,"Pid:"]
			r[i,b,"Signal:"]=r[i-1,b,"Signal:"]
			r[i,b,"PMD:"]=r[i-1,b,"PMD:"]
			sub(/^-$/,"",r[i,b,"Extra:"]) 
			sub(/^-$/,"",r[i-1,b,"Extra:"]) 
			r[i,b,"Extra:"]=r[i,b,"Extra:"]". "r[i-1,b,"Extra:"]
			sub(/^\. +/,"",r[i,b,"Extra:"])
			r[i-1,b,"No:"]=""
		}
	}
	if (fix_2000==1)
	{
		sdate=edate=0
		for (i=1;i<=e;i++)
		{
			if (r[i,b,"No:"]=="") continue
			if (strftime("%Y-%m-%d",r[i,b,"timestamp"])>"2000-01-01") sdate=r[i,b,"timestamp"]+0 
			if (sdate==0) continue
			if (strftime("%Y-%m-%d",r[i,b,"timestamp"])=="2000-01-01")
			{
				edate=0
				for (j=(i+1);j<=e;j++)
				{
					if (r[j,b,"timestamp"]>sdate) 
					{
						edate=r[j,b,"timestamp"]
						break
					}
				}
				if (edate>sdate) 
				{
					r[i,b,"timestamp"]=sdate+(edate-sdate)/2
					r[i,b,"Time:"]=strftime("%Y-%m-%d %H:%M:%S",r[i,b,"timestamp"])
				}
			}
		}
	}
		
	for (i=1;i<=e;i++)
	{
		if (r[i,b,"No:"]=="") continue
		print b" ---------------------------------------------------"
		for (j=1;j<=n;j++) printf("%s %-9s %s\n",b,f[j],r[i,b,f[j]])
	}
	e=0 ; b="" ; delete r
}


function make_timestamp(date,time,   datearray,timearray,array)
{
	#if the first argument contains both the date and time, we extract the time
	if (date ~ /^[1-2][0-9][0-9][0-9]-?[0-1][0-9]-?[0-3][0-9].[0-2][0-9]/)
	{
		time=gensub(/^[1-2][0-9][0-9][0-9]-?[0-1][0-9]-?[0-3][0-9]./,"",1,date)
	}

	#possible formats (time is optional, seconds are optional, minutes are optional)
	# 2006-03-10 15:10:30
	# 2006-03-10 15:10
	# 20060310 151030
	# 20060310 1510
	if (date !~ "-")
	{
		split(date,array,"")
		datearray[1]=array[1] array[2] array[3] array[4]
		datearray[2]=array[5] array[6]
		datearray[3]=array[7] array[8]
		split(time,array,"")
		timearray[1]=array[1] array[2]
		timearray[2]=array[3] array[4]
		timearray[3]=array[5] array[6]
	}
	else
	{
		split(date,datearray,"-")
		split(time,timearray,":")
	}
	return mymktime(sprintf("%s %s %s %s %s %s",datearray[1],datearray[2],datearray[3],timearray[1]+0,timearray[2]+0,timearray[3]+0))
} 
function mymktime(arg,    array)
{
	#needed for cygwin version 1.7.19 and above where the mymktime function hangs for 30 seconds if the year is 0
	split(arg,array," ")
	if ((array[1]+0)==0) arg="1970 01 01 00 00 00"
	return mktime(arg)
} 

#=============================================================================================
#coli>/fruacc/lhsh BXP_2048 llog -l
#BXP_2048: ---------------------------------------------------
#BXP_2048: No:       1
#BXP_2048: Reason:   Power on
#BXP_2048: Time:     2000-01-01 00:00:01
#BXP_2048: Program:  -
#BXP_2048: Pid:      -
#BXP_2048: Rank:     Cold
#BXP_2048: Signal:   -
#BXP_2048: PMD:      -
#BXP_2048: Extra:    -
#
#Gen1 DU with mix of OSE/Linux radios 10.86.246.108
#=============================================================================================
#$ lhsh 000100/BXP_2_1 llog -l
#0001BXP_2_1: ----------------------------------------------------------------------------
#0001BXP_2_1:  1.    Time           :  2019-05-14, 02:25:56
#0001BXP_2_1:        Error code     :             (Ordered restart)
#0001BXP_2_1:        Product info   :  LMC PID   : CXP9013268%9_R75MD
#0001BXP_2_1:                          XPP PID   : CXC1321797/3_R40Y
#0001BXP_2_1:                          XPL PID   : CXC1321812/1-R6A
#0001BXP_2_1:                          IBOOT PID : CXC1321302/3-R4K
#0001BXP_2_1:                          HW TYPE   : WARP3 Flash=64Mb RAM=128Mb HW-id=CXC10115111 HW-rev=R1A000000 OSE Delta PowerPC
#0001BXP_2_1:                          HW PID    : KRC 161 282/2
#0001BXP_2_1:                          HW REV    : R1E
#0001BXP_2_1:                          HW NAME   : RRUS 12 B3
#0001BXP_2_1:                          HW DATE   : 20121108
#0001BXP_2_1:                          HW serial : C826572002
#0001BXP_2_1:        Restart Information:
#0001BXP_2_1:        Restart ordered due to Link timeout
#=============================================================================================
#$ lhsh 000100/BXP_3 llog -l
#0001BXP_3: ---------------------------------------------------
#0001BXP_3: No:       3
#0001BXP_3: Reason:   Ordered restart
#0001BXP_3: Time:     2019-09-25 04:03:18
#0001BXP_3: Program:  lh_supd
#0001BXP_3: Pid:      -
#0001BXP_3: Rank:     Cold
#0001BXP_3: Signal:   -
#0001BXP_3: PMD:      -
#0001BXP_3: Extra:    Restart ordered due to Link timeout
#0001BXP_3: ---------------------------------------------------
#0001BXP_3: No:       4
#0001BXP_3: Reason:   Ordered restart
#0001BXP_3: Time:     2019-09-25 04:09:58
#0001BXP_3: Program:  ngr2.elf
#0001BXP_3: Pid:      -
#0001BXP_3: Rank:     Cold
#0001BXP_3: Signal:   -
#0001BXP_3: PMD:      -
#0001BXP_3: Extra:    Application ordered restart, faultId: 0x998 (LogicalNameUndefined), faultDescription: Performing internal restart

