BEGIN{ printf("\n%s%s\n",(lhcom=="lh"?sprintf("%-11s  %-9s  ","Position","Board"):""),"Processor Load") }
mosdebug==1 { print "DEBUG: "$0 }
/commonjars\/connect[^ ]*: connection timed out|Timeout, server .* not responding|nc6[^ ]*: remote idle timed out/{errors=errors"\n"$0 ; next}
lhcom=="lh" && $1 !~ /^[^:]+:$/ { next }
$1 ~ /^[^:]+:$/ && lhcom=="lh" {
	currproc=$1
	match($1,/^([0-9][0-9][0-9][0-9])/,array)
	if (array[1] ~ /^[0-9][0-9][0-9][0-9]$/) 
	{
		#The XPs are treated as separate boards
		#0002BXP_2_1:
		#0012p8d9:
		if ($1 ~ /BXP|p[0-9]+d[0-9]+/) currboard=gensub(/:$/,"",1,$1)
		#These ones are all part of the same board
		#0014:
		#0019SP3:
		#0022D02:
		#0001gcpu01024:
		else 
		{
			#gcpus shall be on separate row than MP
			if ($1 ~ /gcpu/) currboard=array[1]"gcpu"
			else currboard=array[1] 
		}
	}
	#here we will see boards like gcpu01024 and BXP_0_1 (without 0001 in front)
	else currboard=gensub(/:$/,"",1,$1)
	
	if (lastboard=="") lastboard=currboard
	if (currboard != lastboard) 
	{
		dumpboard()
		lastboard=currboard
	}
	if (currproc != lastproc)
	{
		if (inbrack==1 && lastproc!="")
		{
			output=gensub(/ *$/,"",1,output)")  "
			inbrack=0
		}
		lastproc=$1
	}
	sub(/^[^:]+: /,"")
}
/(lhsh|rcmd): failed to connect|unable to hunt / { output="NOCONTACT";next }

#FORMAT ON EPB:
#0226:    Core 0     21  21  21  21  19  21  18  17  23  22
#0226D01: Core 0      8   9   7   7   7   7   8   7   7   8
#SHOULD GIVE :
#  0  26  EPB1       2.2  3.0  0.8  0.6  0.6  5.2  2.2  (2.3)    2.2  5.8  6.0  6.0  5.8  6.0  6.0  (4.3)

#FORMAT ON OTHER BOARDS  
#0001: Load (%)     2
#0222: CPU load report on Core 0
#0222: Load (%)     91  86  75  68  60  88  83  79  99  78
#0222: CPU load report on Core 1
#0222: Load (%)     87  91  94  86  77  74  61  66  81  74

#  0  14  GPB75          11.4 13.3 (12.2)
#  2  20  SPB4           7.9   19.9 19.5 (19.4)  16.4 18.2 (17.2)  18.0 20.0 (19.0) 
/CPU load report on Core 0/{
	output=output"("
	inbrack=1
}
($1=="Core" && $2 ~ /^[0-9]+$/ && $3 ~ /^[0-9]+$/)||($1=="Load" && $3 ~ /^[0-9]+$/) {
	if ($1=="Core" && $2==0) 
	{
		output=output"(" 
		inbrack=1
	}
	l=n=a=0
	for (i=3;i<=NF;i++) { l+=$i ; n++ }
	a=sprintf("%4.1f",l/n)
	output=output a" "
}
	

END{ dumpboard() ; print gensub(/^\n/,"",1,errors) }
function dumpboard()
{
	if (inbrack==1) 
	{
		output=gensub(/ *$/,"",1,output)")  "
		inbrack=0
	}
	bdtype=""
	if (lastboard ~ "BXP") bdtype=BoardType[gensub("BXP","00/BXP",1,lastboard)]
	else if (lastboard ~ /^[0-9]+p[0-9]+d[0-9]+/) bdtype=BoardType[gensub("p","00/port_",1,gensub("d","_dev_",1,lastboard))]
	else if (lastboard ~ /gcpu/) bdtype=BoardType[gensub("gcpu","00",1,lastboard)]
	else bdtype=BoardType[lastboard"00"]
	printf("%s%s\n",(lhcom=="lh"?sprintf("%-11s  %-9s  ",lastboard,bdtype):""),output) 
	output=""
}

