package Utils;

use strict;
use warnings;

use Constants;

sub calculateSubrackNumber {
	my ($self, $subrackName) = @_;
	die "This should be used as a static method" if ref $self;

	if (grep { $_ eq $subrackName } @Constants::mainSubracks) {
		return 0;
	} elsif ($subrackName =~ m/(\d+)/) {
		return int($1);
	} elsif (grep { $_ eq $subrackName } @Constants::caxSubracks) {
		return $Constants::assumedCaxSubrack;
	} else {
		return -1;
	}
}

sub isPortInCaxSubrack {
	my ($self, $port) = @_;
	die "This should be used as a static method" if ref $self;

	# Port is assumed to be in a CAX subrack if:
	# 1. It is located on a CCIB board
	# 2. It is a CMXB3 board in slot 3 or 6 (In EGEM2 the location would be 2 or 28)
	# 3. The subrack is the constant of the assumed CAX subrack (15)

	return ($port->getBoard() eq "CCIB" || ($port->getBoard() eq "CMXB3" && $port->getSlot() % 3 == 0) || $port->getSubrack() == $Constants::assumedCaxSubrack);
}

sub getCaxSubrackLabel {
	my ($self, $bridge) = @_;
	die "This should be used as a static method" if ref $self;

	my ($subrackName) = split("-", $bridge->getBridge());

	if (grep { $_ eq $subrackName } @Constants::caxSubracks) {
		return "CAX ". $bridge->getBridge();
	} else {
		my $slot = $bridge->getSlot();
		my $position;

		if ($slot == 3) {
			$position = "A";
		} else {
			$position = "B";
		}
		return "CAX ". $position ." (". $slot .")";
	}
}

1;
