#!/usr/bin/python

from mo import trace
import mo, mo_parsing
import mo_input as mo_io
import sys,os

def createIurDeletionScripts(working_path,rinpmjson,rncId):
    #get rncId of both cluster members
    for cm in ("CM1","CM2"):
        if not os.path.exists(working_path+cm +"/iur" ):
            os.makedirs(working_path+cm +"/iur")
    #create scripts for getting name of Iur Link between two cluster members
    mo_io.writeMos(working_path + "CM1/" + rinpmjson["iur"]["scripts"]["get_iur"], mo.getIur(working_path+"CM1/"+rinpmjson["iur"]["logs"]["iur"],rncId["CM2"]))
    mo_io.writeMos(working_path + "CM2/" + rinpmjson["iur"]["scripts"]["get_iur"], mo.getIur(working_path+"CM2/"+rinpmjson["iur"]["logs"]["iur"],rncId["CM1"]))
    
    for cm in ("CM1","CM2"):         #for both cluster members
        #cm =  "CM"+i
        mo_io.deleteFile(working_path + cm + "/" + rinpmjson["iur"]["logs"]["iur"])
        
        #run script to get name of Iur Link between twho cluster members
        mo_io.run_moshell_session(rinpmjson[cm]["credentials"], working_path + cm +"/" + rinpmjson["iur"]["scripts"]["get_iur"])
        
        #parse moshell output
        cmIurLink = mo_parsing.getIurLink(working_path + cm + "/" + rinpmjson["iur"]["logs"]["iur"])
        
        #prepare and run scripts for simulated deletion of external utran relation on this iur link
        mo_io.writeMos(working_path + cm + "/" + rinpmjson["iur"]["scripts"]["iur_sim_del1"], mo.simulatedDeleteIur(working_path + cm + "/" + rinpmjson["iur"]["scripts"]["iur_restore1"], cmIurLink))
        mo_io.writeMos(working_path + cm + "/" + rinpmjson["iur"]["scripts"]["iur_sim_del2"], mo.simulatedDeleteIur2(working_path + cm + "/" + rinpmjson["iur"]["scripts"]["iur_restore2"], cmIurLink))
        
        mo_io.run_moshell_session(rinpmjson[cm]["credentials"], working_path + cm + "/" + rinpmjson["iur"]["scripts"]["iur_sim_del1"])
        mo_io.run_moshell_session(rinpmjson[cm]["credentials"], working_path + cm + "/" + rinpmjson["iur"]["scripts"]["iur_sim_del2"])
        
        #prepare script for deleting iur
        mo_io.writeMos(working_path + cm + "/" + rinpmjson["iur"]["scripts"]["iur_del"], mo.deleteIur(cmIurLink)) 

        mo_parsing.changeExternalToRemoteUtranCell( working_path + cm + "/" + rinpmjson["iur"]["scripts"]["iur_restore1"]+ ".mo")
        mo_parsing.changeExternalToRemoteUtranCell2(working_path + cm + "/" + rinpmjson["iur"]["scripts"]["iur_restore2"]+ ".mo")
        
        script = """lt all
confb+
run {0}
truni {1}
truni {2}
cvms iLNM_UtranRelationUpdated
""".format(working_path + cm + "/" + rinpmjson["iur"]["scripts"]["iur_del"],working_path + cm + "/" + rinpmjson["iur"]["scripts"]["iur_restore1"] + ".mo",  working_path + cm + "/" + rinpmjson["iur"]["scripts"]["iur_restore2"] + ".mo")
        mo_io.writeMos(working_path + cm + rinpmjson["iur"]["scripts"]["change_utran"],script)       
        
def deleteIurLink(working_path,rinpmjson):
    for cm in ("CM1","CM2"):
        mo_io.run_moshell_session(rinpmjson[cm]["credentials"], working_path + cm + "/" + rinpmjson["iur"]["scripts"]["change_utran"])
def clean(working_path):
    None