/* Copyright (C) 2007 Ericsson AB 
 */

#include "wrapper.h"

#include <dlfcn.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <errno.h>

wrapper_ctx_t  wrapper_ctx;

void __attribute__ ((constructor)) 
lib_init(void) 
{
  const char*  port_str = getenv("TIME_PORT");
  const char*  log_str  = getenv("TIME_LOG");

  wrapper_ctx.active = 1;
  wrapper_ctx.thread = pthread_self();

  wrapper_ctx.log_level = 0;
  if (log_str) {
    wrapper_ctx.log_level = atoi(log_str);
  }

  GET_REAL_FUNC(select);
  GET_REAL_FUNC(time);
  GET_REAL_FUNC(nanosleep);
  GET_REAL_FUNC(gettimeofday);
  GET_REAL_FUNC(clock_gettime);
  GET_REAL_FUNC(clock_settime);
  GET_REAL_FUNC(clock_getres);

  wrapper_ctx.port = 8123;
  if (port_str) {
    wrapper_ctx.port = atoi(port_str);
  }

  wrapper_ctx.host   = getenv("TIME_SERVER");
  if (!wrapper_ctx.host) {
    wrapper_ctx.host = "localhost";
  }

  wrapper_log(5, "init called\n");
  wrapper_log(5, "Using socket: %s:%d\n", 
	      wrapper_ctx.host,
	      wrapper_ctx.port);

  simics_connect(wrapper_ctx.host, wrapper_ctx.port);

  if (!wrapper_ctx.simics_ctx) {
    wrapper_log(0, "*** Could not connect to emulator, resolve problem and\n");
    wrapper_log(0, "*** restart if you want to use virtual time as time base.\n");
    wrapper_log(0, "*** Using real functions\n");
  } else {
    wrapper_log(1, "*** Connected to time server\n");
  }
}

void
wrapper_log_(
  const char*   file, 
  int           line, 
  const char*   func, 
  int           level,
  const char*   format, ...)
{
  if (wrapper_ctx.log_level < level) {
    return;
  }

  fprintf(stderr, "wrapper %d: %s:%i in function '%s'\n",
	  pthread_self(), file, line, func);
  
  if (format && *format) { 
    fprintf(stderr, "\t");
    va_list ap;
    va_start(ap, format);
    vfprintf(stderr, format, ap);
    va_end(ap);

    fprintf(stderr, "\n");
  }
}
