package Bridge;

use strict;
use warnings;

use Utils;

sub new {
	my $class = shift;
	my $input = shift;
	shift(@$input);
	my $self = {
		_bridge => shift(@$input),
		_remoteBridge => shift(@$input),
		_state => shift(@$input),
		_priority => shift(@$input),
		_type => shift(@$input),
		_noNeighbours => 0,
		_external => 0,
		_position => { x => undef, y => undef }
	};

	$self->{_ports} = ();
	$self->{_neighbours} = {};

	$self->{_label} = undef;

	my ($_subrack) = split("-", $self->{_bridge});

	if ($self->{_bridge} =~ m/^EXT-(.*?)-(\d+)/) {
		$self->{_subrack} = $1;
	} else {
		$self->{_subrack} = Utils->calculateSubrackNumber($_subrack);

		if ($self->{_subrack} < 0) {
			print STDERR "Unknown subrack: $_subrack\n";
		}
	}
	undef $_subrack;

	if ($self->{_bridge} =~ m/^EXT-(\d+)-(.*)/) {
		$self->{_bridge} = "EXT-$2";
		$self->{_slot} = int($1);
	} else {
		$self->{_bridge} = substr($self->{_bridge}, 0, rindex($self->{_bridge}, "-"));
		my ($null, $_slot) = split("-", $self->{_bridge});
		$self->{_slot} = int($_slot);
		undef $_slot;
	}

	bless $self, $class;

	return $self;
}

sub setLabel {
	my ($self, $label) = @_;
	$self->{_label} = $label if defined($label);
}

sub getLabel {
	my ($self) = @_;
	return $self->{_label};
}

sub setExternal {
	my ($self, $external) = @_;
	$self->{_external} = $external;
}

sub getExternal {
	my ($self) = @_;
	return $self->{_external};
}

sub setPosition {
	my ($self, $x, $y) = @_;
	$self->{_position}{x} = $x if defined($x);
	$self->{_position}{y} = $y if defined($y);
}

sub getX {
	my ($self) = @_;

	return $self->{_position}{x};
}

sub getY {
	my ($self) = @_;

	return $self->{_position}{y};
}

sub getSubrack {
	my ($self) = @_;
	return $self->{_subrack};
}

sub setSubrack {
	my ($self, $subrack) = @_;
	$self->{_subrack} = $subrack if defined($subrack);
}

sub getSlot {
	my ($self) = @_;
	return $self->{_slot};
}

sub getBridge {
	my ($self) = @_;
	return $self->{_bridge};
}

sub setBridge {
	my ($self, $bridge) = @_;
	$self->{_bridge} = $bridge if defined($bridge);

	return $self->{_bridge};
}

sub getRemoteBridge {
	my ($self) = @_;
	return $self->{_remoteBridge};
}

sub setRemoteBridge {
	my ($self, $remoteBridge) = @_;
	$self->{_remoteBridge} = $remoteBridge if defined($remoteBridge);

	return $self->{_remoteBridge};
}

sub getType {
	my ($self) = @_;

	return $self->{_type};
}

sub setType {
	my ($self, $type) = @_;
	$self->{_type} = $type if defined($type);

	return $self->{_type};
}

sub getPriority {
	my ($self) = @_;
	return $self->{_priority};
}

sub setPriority {
	my ($self, $priority) = @_;
	$self->{_priority} = $priority if defined($priority);

	return $self->{_priority};
}

sub getState {
	my ($self) = @_;
	return $self->{_state};
}

sub setState {
	my ($self, $state) = @_;
	$self->{_state} = $state if defined($state);

	return $self->{_state};
}

sub getPorts {
	my ($self) = @_;

	return @{$self->{_ports}};
}

sub getNeighbours {
	my ($self) = @_;

	return %{$self->{_neighbours}};
}

sub addPort {
	my ($self, $port) = @_;
	push(@{$self->{_ports}}, $port);
}

sub getNoNeighbours {
	my ($self) = @_;
	return $self->{_noNeighbours};
}

sub addNeighbour {
	my ($self, $_bridge, $_port) = @_;
	my $subrack = $_bridge->getSubrack();
	my $slot = $_bridge->getSlot();
	my $port = $_port->getPortNumber();
	$self->{_neighbours}{$subrack} =  {} unless $self->{_neighbours}{$subrack};
	$self->{_neighbours}{$subrack}{$slot} =  () unless $self->{_neighbours}{$subrack}{$slot};

	push(@{$self->{_neighbours}{$subrack}{$slot}}, [ ($_bridge, $_port) ]);

	$self->{_noNeighbours}++;
}

1;
