/*
 * timeclient.h
 *
  Copyright 1998-2006 Virtutech AB
  
  This file is part of the Virtutech Simics, which is distributed
  under the Virtutech Simics Software License Agreement.
 *
 */
#ifndef __TIMECLIENT_H__
#define __TIMECLIENT_H__

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/select.h>
#include <netdb.h>
#include <unistd.h>

typedef enum {
        Simtime_No_Error,
        Simtime_Socket_Error,         /* errno contains last error */
        Simtime_Timeout,              /* global timeout (as specified in
                                         simtime_connect) */
        Simtime_Receive_Buffer_Full,  /* the received message did not fit in
                                         the buffer. It's probably a bug in
                                         the time client library if it
                                         happens */
        Simtime_Parse_Error           /* received message could not be parsed*/
} simtime_error_t;

/* You should never have to access this struct yourself */
typedef struct {
        int socket;
        int timeout;

        struct {
                unsigned int pos;
                size_t size;
                char *tag_start;  /* Points into buf */
                char buf[4096];
        } recv;
} simtime_context_t;

/* Callback for periodic pings. Seq_no is the sequence number of the received
   ping message. Time is the virtual time when the ping message was sent */
typedef int (*simtime_callback_t)(void *data, simtime_context_t *ctx,
                                  int seq_no, double t);

simtime_context_t *simtime_connect(const char *host, int port,
                                   int global_timeout);
void simtime_disconnect(simtime_context_t *ctx);

simtime_error_t simtime_query_time(simtime_context_t *ctx, double *t);
simtime_error_t simtime_sleep(simtime_context_t *ctx, double seconds,
                              double *t);
simtime_error_t simtime_periodic_ping(simtime_context_t *ctx, double interval,
                                      double how_long, simtime_callback_t cb,
                                      void *user_data);

#endif /* __TIMECLIENT_H__ */
