#!/usr/bin/env bash
#-----------------------------------------------------------
# This is an example script to use the timelib-wrapper in CPPemu
# Scripts executed through this wrapper will get the virtual
# time from CPPemu rather than the real time when executing system
# calls like gettime, sleep etc.
#-----------------------------------------------------------
# Settings
#
# SCRIPT: The test-script that needs virtual time
# TIME_SERVER: The machine running CPPemu
# PORT: The port that the time-server in CPPemu is listening to.
#-----------------------------------------------------------
SCRIPT="date -u"
TIME_SERVER="localhost"
TIME_PORT="8123"

#-----------------------------------------------------------
#You probably don't need to change anything below.
#-----------------------------------------------------------
if [ ${CPPEMU_TOOLS_LIST:--} == "-" ]; then
    CPPEMU_TOOLS_LIST=`cppemugetfile cppemu-tools-list.sh`
fi

source $CPPEMU_TOOLS_LIST
HOST_TYPE=`$SIMICS_BASE_PATH/scripts/host-type.sh`

case $HOST_TYPE in
    x86-linux)
        SUFFIX=x86-linux-32
      ;;
    amd64-linux)
        SUFFIX=x86-linux-64
      ;;
    sparc64-solaris)
        SUFFIX=v9-sol10-64
      ;;
esac

LD_PRELOAD=`cppemugetfile util/timelib-$SUFFIX.so`
export LD_PRELOAD
export TIME_SERVER
export TIME_PORT

#execute script.
exec ${SCRIPT}
