#!/usr/bin/env perl
$| = 1;    #don't buffer output
use strict;
use Getopt::Long;
use Data::Dumper;
use POSIX qw(strftime);
use POSIX;
use Time::Local;
####
#Syntax: cat <pmrlog> | pmSummary.pl -html <dir> 
####


my $USERX;
my $BASE;
BEGIN
{
	use Cwd 'abs_path';
	($BASE) =  ( abs_path($0) =~ /\// ? substr( abs_path($0), 0, rindex( abs_path($0), "/" ) ) : "." ); 
	$BASE =~ s/bin\/?$//;
	unshift( @INC, "$BASE/" );
	unshift( @INC, "$BASE/lib/" );
	#unshift( @INC, "/vobs/iov/wcdma/lib/" );
	my $OS = `uname -a`;
	if ( $OS =~ /linux/i ) 
	{
		unshift( @INC, "/app/perl-expect/1.21/lib/5.8.1" );
		unshift( @INC, "/app/perl-expect/1.21/lib/site_perl/5.8.1/i686-linux-thread-multi/"	);
		unshift( @INC, "/app/perl-expect/1.21/lib/site_perl/5.8.1" );
	}
	$USERX = $ENV{USER};
}

use config;
use flot;
use generate_json;
use print_func;
use formula;

#################################################################################
#Author Martin Aldrin, Henrik Schller
#V.1.0   2010-09-30    Martin Aldrin, Henrik Schller   First Release.
#V.1.1   2010-10-11    Henrik Schller      		    New web layout.
#V.1.2	 2010-11-01    Martin Aldrin			        correction to support pmx.
#V.1.3	 2010-12-17    Martin Aldrin			        updated pmGraphs.js
#V.2.0	 2013-08-20    Martin Aldrin			        updated to new rewritten graph.js
#                                                           changed to json.
#V.2.1	 2013-11-07    Martin Aldrin			        Added support for Thresholds.
#V.2.2	 2013-11-12    Martin Aldrin			        Bug corrections for thresholds.
#2.3     2014-04-09    Martin Aldrin                    Minor bug correction.
#2.4     2014-05-21    Andreas Nordvall                 Updated eGraphs.js to newest version. 
#                                                           Also changed how number of error is 
#                                                           presented in terminal when script finish.
#2.5     2015-09-14    Martin Aldrin                        Correction for links on html page, correction for mark tables green that passed threshold on main page.
#2.6     2015-09-14    Martin Aldrin                       Correction for negative limits.        
#2.7     2015-09-22    Martin Aldrin                       Correction for negative limits for operand ][                                             
#################################################################################

my $confighash;
$confighash->{version} = '2.7';

$confighash->{BASE} = $BASE;
$confighash->{formulafile} = undef;
$confighash->{configfile} = undef;
$confighash->{thresholdfile} = undef;
my $pwd = `pwd`;
	$confighash->{fileToCopy} = 
	{
		'js/graphs.js' 					=> $BASE . 'www/' . 'eGraphs.js',
		'js/jquery.js' 					=> $BASE . 'www/' . 'jquery-1.10.2.js',
		
		'js/jquery.flot.canvas.js' 		=> $BASE . 'www/' . 'jquery.flot.canvas.js',
		'js/jquery.flot.orderBars.js' 	=> $BASE . 'www/' . 'jquery.flot.orderBars.js',
		'js/jquery.flot.resize.js' 		=> $BASE . 'www/' . 'jquery.flot.resize.js',
		'js/jquery.flot.selection.js' 	=> $BASE . 'www/' . 'jquery.flot.selection.js',
		'js/jquery.flot.symbol.js' 		=> $BASE . 'www/' . 'jquery.flot.symbol.js',
		'js/jquery.flot.time.js' 		=> $BASE . 'www/' . 'jquery.flot.time.js',
		'js/jquery.flot.tooltip.min.js' => $BASE . 'www/' . 'jquery.flot.tooltip.min.js',
		'js/utilities.js' 				=> $BASE . 'www/' . 'utilities.js',
		
		'js/jquery.flot.js' 		    => $BASE . 'www/' . 'jquery.flot.js',
		'js/jquery.flot.selection.js' 	=> $BASE . 'www/' . 'jquery.flot.selection.js',
		'js/jquery.tablesorter.js'		=> $BASE . 'www/' . 'jquery.tablesorter.pager.js',
	
		'license.txt'					=> $BASE . 'www/' . 'license.txt',
		'page_header_fade.jpg'			=> $BASE . 'www/' . 'page_header_fade.jpg',
		'ericsson_logo.gif'				=> $BASE . 'www/' . 'ericsson_logo.gif',
		'css/newStyle.css' 				=> $BASE . 'www/' . 'newStyle.css',
		'css/style.css' 				=> $BASE . 'www/' . 'style.css',

		'formula.txt' 					=> \$confighash->{formulafile},
		'configfile.txt'				=> \$confighash->{configfile},	
		'thresholdfile.txt'				=> \$confighash->{thresholdfile},
	};
GetOptions
(
	'html=s'		=> \$confighash->{html},
	'force'			=> \$confighash->{force},
	'amos'			=> \$confighash->{amos},
	'event|e=s'		=> \$confighash->{event},
	'y2=s'			=> \$confighash->{y2},
	'help'			=> \$confighash->{help},
);

if(defined $confighash->{help})
{
	print "No help information supported, waiting for updated!\n";
	exit;
}
my $nrMajorAlert = 0;
my $nrMinorAlert = 0;
$confighash->{trend} = 1 if defined $confighash->{html};
$confighash->{y2} = $BASE .(-e $BASE.'/lib/y2.txt'?'/lib':'').'/y2.txt' . (defined $confighash->{y2}?','.$confighash->{y2}:'');
$confighash->{major} =0;
$confighash->{minor} =0;
$confighash->{ok} =0;
config::check_input($confighash);
parse_line();

sub parse_header
{
	my ($obj,$lineref,$twice) = @_;
	@{$obj->{header}} = split(/;/,$$lineref);
	foreach my $elm (@{$obj->{header}})
	{
		$elm =~ s/^\s+|\s+$//g;
		$elm= "-" if $elm =~/^\s*$/;
		$elm =~s/\s/,/g;
	}
	push(@{$obj->{headerName}},shift(@{$obj->{header}}));
	push(@{$obj->{headerName}},shift(@{$obj->{header}})) if $twice; 
}

sub parse_line
{
	my ($obj,$data);
	my $stop = 1;
	open INPUT, "> " . $confighash->{flotpath} . "input.txt";
	my $nameMappingTable;
	@{$confighash->{exception}} = ();
	while(my $line = <STDIN>)
	{	
		print $line;
		print INPUT $line;
		$line =~ s/\e//g;
		chomp $line;
		$line =~ s/^\s+|\s+$//g;
		my @columns = split(/;/,$line);

		if (defined $line && $line =~ /^\s*(\d+)\)\s+(.+?)\s*$/)
		{
			push(@$data,$obj);
			$obj = {};
			$obj->{hasThreshold} = 0;
			@{$obj->{object}} = ();
			@{$obj->{elements}} = ();
			@{$obj->{threshold}} = ();
			$line =~ s/\///;
			$obj->{table} = $line;
			$stop = undef;
		}
		elsif(defined $line && $line =~ /Granularity:\s+(.+)\s*$/)
		{
			$obj->{Granularity} = $1;
		}
		elsif( $line =~ /^\s*;?\s*Counter/ )
		{
			$obj->{counterHeader} = 0;
			parse_header($obj,\$line,1);
		}
		elsif( $line =~ /^\s*;?\s*Object\s*;\s*Counter/ )
		{
			$obj->{counterHeader} = 0;
			parse_header($obj,\$line,1);
		}
		elsif( $line =~ /^\s*;?\s*Object/ )
		{
			$obj->{counterHeader} = 1;
			parse_header($obj,\$line,0);
		}
		elsif( $line =~ /^\s*;?\s*(Date\/Time)\s*;\s*Counter/)
		{
			$obj->{counterHeader} = 0;
			parse_header($obj,\$line,1);
		}
		elsif( $line =~ /^\s*;?\s*(Date\/Time)\s*;\s*Object/)
		{
			$obj->{counterHeader} = 1;
			parse_header($obj,\$line,1);
		}
		elsif($line =~ /^\s*Log close/)
		{
			next;
		}
		elsif($line =~ /^\s*gzip/)
		{
			next;
		}
		elsif(defined $obj->{header} && defined $obj->{table} && @columns > @{$obj->{header}})
		{	
			my $elements = ();
			my $object = ();
			$line =~ s/\[\d+m|\[\d;\d+m//g;
			my $threshold;
			if(!defined $obj->{hasThreshold}){
				$obj->{hasThreshold} = 0;
			}
			
			if( $line =~ /(.+?)((Minor|Major)Alert:.+)/ ){
				$line = $1;
				$threshold = $2;
				$nrMajorAlert++ if $3 eq "Major";
				$nrMinorAlert++ if $3 eq "Minor";
			}
			elsif( $line =~ /(.+?)(Alert:.+)/ ){
				$line = $1;
				$threshold = "Major".$2;
				$nrMajorAlert++ ;
			}
			@$elements = split(/;/,$line);
			$obj->{date} = 1 if ( $line =~ /^\s*(\d{4})\-(\d{2})\-(\d{2})\s*(\d{2}):(\d{2})/ );
			foreach my $elm (@$elements)
			{
				$elm =~ s/^\s+|\s+$//g;
			}
			for(@{$obj->{headerName}})
			{
				push(@$object,shift(@$elements));
			}
			foreach my $form (@$object){
				if(defined $confighash->{thresholdmap}->{lc$form}){
					$obj->{hasThreshold} = 1;
				}
			}
			push(@{$obj->{object}},$object);
			push(@{$obj->{elements}},$elements);
			push(@{$obj->{threshold}},$threshold);
		}
		elsif($line =~ /^\s*(Report from.+)\s*$/)
		{
			$confighash->{ReportTime} = $1;
		}
		elsif($line =~ /^\s*Using formulafile\s+(\S+)/)
		{
			$confighash->{formulafile} = $1;
		}
		elsif($line =~ /^\s*Using configfile\s+(\S+)/)
		{
			$confighash->{configfile} = $1;
		}
		elsif($line =~ /^\s*Using thresholdfile\s+(\S+)/)
		{
			$confighash->{thresholdfile} = $1;
			open THRESHOLDFILE, "<$confighash->{thresholdfile}";
			while( my $line = <THRESHOLDFILE> ){
				$line =~ s/#.*//;
				if( $line =~ /^\s*(\S+)\s+([<=>\[\]~!]+)\s+([0-9.-]+)\s*([0-9.-]+)?/ ){
					$confighash->{thresholdmap}->{lc$1}->{name} = $1;
					$confighash->{thresholdmap}->{lc$1}->{operand} = $2;
					if( $4 ){
						$confighash->{thresholdmap}->{lc$1}->{minor} = $3;
						$confighash->{thresholdmap}->{lc$1}->{major} = $4;
					}
					else{
						$confighash->{thresholdmap}->{lc$1}->{major} = $3;
					}
					#print "add thresholdmap " . lc$1 . "\n";
					#print Dumper($confighash->{thresholdmap}->{lc$1});
				}
		}
		close THRESHOLDFILE;

		}
		elsif(defined $confighash->{nodename} && defined $stop && $line !~ /^\s*$/)
		{
			push(@{$confighash->{exception}},$line);
		}
		elsif($line =~/^(\S+?)>\s*pm[rx]/)
		{
			$confighash->{nodename} = $1;
		}
	}
	close INPUT;
	push(@$data,$obj);
	
	$obj = {};
	
	if (defined $confighash->{exception})
	{
		open EXCEPTION, ">> $confighash->{exceptionfile}";
		my $startflag;
		foreach my $line (@{$confighash->{exception}})
		{
			$startflag = 1 if !defined $startflag && $line =~ /\S+/;
			print EXCEPTION $line."\n" if defined $startflag;
		}
		close EXCEPTION;
		$confighash->{exception} = undef if !defined $startflag;
	}
	
	
	
	print_func::generate_header($confighash);
	$confighash->{nameCnt} = 0;
	foreach my $obj (@$data)
	{
		next if !defined $obj->{table};
		next if !defined $obj->{headerName};
		next if !defined $obj->{header};		
		
		#$obj->{table} =~ s/\(|\)|\%//g;
		my $c = 0;
		my $s = "%s;" x (@{$obj->{headerName}} + @{$obj->{header}});
		$confighash->{obj} = $obj;
		my ($flotname,$namekey) = print_func::head($confighash, $obj->{table}, sprintf("$s\n",@{$obj->{headerName}},@{$obj->{header}}),( $obj->{Granularity} =~ /ROP|Hour|day/i?undef:1 ));
		my $check;
		my $cnt=0;
		#print Dumper($obj);
		foreach my $elm (@{$obj->{elements}})
		{
			print_func::print_func($confighash,sprintf("$s\n", @{${$obj->{object}}[$cnt]},@$elm),@{$obj->{threshold}}[$cnt]);
			$cnt++;
		}	
		print_func::print_table_end($confighash);
		if ( $obj->{Granularity} =~ /ROP|Hour|day/i)
		{
			my @elements = @{$obj->{elements}};
			for(my $j=0; $j < @elements; $j++)
			{
				my $object = @{$obj->{object}}[$j];
				for(my $i=0; $i <= @{$obj->{header}}; $i++)
				{	
			
					if (!defined $obj->{date} && defined @{$obj->{header}}[$i] && @{$obj->{header}}[$i] =~ /(\d{4})\-(\d{2})\-(\d{2}),(\d{2}):(\d{2})/)
					{
						my $time = convertTime_to_milli($1, $2, $3, $4, $5, 0, 0);
						my $string ="";
						foreach my $name (@$object){
							$string .= $name . "_";
						}
						$string =~ s/_$//;
						$string =~ s/^-_//;
						$check->{$string} = 0 if  !defined $check->{$string};
						push(@{$confighash->{flothash}->{$namekey}->{$string}},$time . ',' . ($elements[$j][$i] =~ /^[0-9\-\.]+$/?$elements[$j][$i]:'') );	
						$check->{$string} = 1 if $elements[$j][$i] !~ /N\/A/;
					}
					elsif( defined $obj->{date} && defined @{$obj->{header}}[$i] && @$object[0] =~ /(\d{4})\-(\d{2})\-(\d{2}) (\d{2}):(\d{2})/)
					{
						my $time = convertTime_to_milli($1, $2, $3, $4, $5, 0, 0);
						my $string = @$object[1] . '_' . @{$obj->{header}}[$i];
						$string =~ s/^-_//;
						$check->{$string} = 0 if  !defined $check->{$string};
						push(@{$confighash->{flothash}->{$namekey}->{$string}},$time . ',' . ($elements[$j][$i] =~ /^[0-9\-\.]+$/?$elements[$j][$i]:'') );
						$check->{$string} = 1 if $elements[$j][$i] !~ /N\/A/;
					}	
					elsif( !defined $obj->{date} && defined @{$obj->{header}}[$i] &&  @{$obj->{header}}[$i] =~ /(\d{4})\-(\d{2})\-(\d{2})/)
					{
						my $time = convertTime_to_milli($1, $2, $3, 0, 0, 0, 0);
						my $string = @$object[1] . '_' . @{$obj->{header}}[$i];
						$string =~ s/^-_//;
						$check->{$string} = 0 if  !defined $check->{$string};
						push(@{$confighash->{flothash}->{$namekey}->{$string}},$time . ',' . ($elements[$j][$i] =~ /^[0-9\-\.]+$/?$elements[$j][$i]:'') );
						$check->{$string} = 1 if $elements[$j][$i] !~ /N\/A/;
					}	
				}
			}
		}
		foreach my $string (keys %$check)
		{
			if ($check->{$string} == 0)
			{
				delete $confighash->{flothash}->{$namekey}->{$string} ;
			}
		}
	}
	print_func::generate_footer($confighash);
	copy_files($confighash);
	flot::generate_flot($confighash);
	generate_json::generate_json($confighash);	
}

print "".(-e $confighash->{html}?"Web report has been generated successfully and stored under ":"Could not generate Web report under: ") .'[' . $confighash->{htmlpath} . "]\n";
print "Result: MajorAlerts: $nrMajorAlert , MinorAlerts: $nrMinorAlert, Thresholds passed: " . int($confighash->{minor}+$confighash->{major}) . "\n" if defined $confighash->{thresholdfile};
print "\n";
exit;

sub convertTime_to_milli 
{
        my($year, $mon, $day, $hour, $min, $sec, $msecond) = @_; 
        return (timegm($sec, $min, $hour, $day, $mon -1, $year -1900, 0, 0, 0))*1000;
}
sub copy_files
{
	my $confighash = shift;
	while ( my ($filename,$path) = each %{$confighash->{fileToCopy}} )
	{
		my $toPath = $confighash->{htmlpath};
		if ( $filename =~ /\.(png|gif|jpg)$/ )
		{
			$toPath = $confighash->{imagespath};
		}
		if ( defined $path && -e $path )
		{
			copy( $path, $toPath . $filename );
		}
		elsif ( defined $$path && -e $$path )
		{
			copy( $$path, $toPath . $filename );
		}
		else
		{
			#print "not possible to copy $filename, (" . $path . ") -> $toPath\n";
		}
	}
	#$confighash->{formulafile} = $confighash->{htmlpath} .'/formula.txt'  if defined $confighash->{formulafile};
	#$confighash->{formulafile} = $confighash->{htmlpath} .'/formula.txt' if defined $confighash->{configfile};
	#$confighash->{formulafile} = $confighash->{htmlpath} .'/formula.txt' if defined $confighash->{thresholdfile}
	formula::parse_formula($confighash);
	#no File::Copy;
}

sub copy
{
	my $file = shift;
	my $path = shift;
	`cp $file $path`;

}
