#Execute with: bash -v lttng-build-script.sh 32|64

#IMPORTANT: Run these three commands from the tcsh , they dont work from bash
module add bison/2.4
module add autoconf/2.69
module add automake/1.15

sleep 5

if   [[ $1 = 32 ]] ; then os="linux" ; mflag="-m32" ; xhost="x86"
elif [[ $1 = 64 ]] ; then os="lin64" ; mflag=""     ; xhost="x86_64"
else echo "" ; echo "Syntax: bash -v $0 32|64" ; exit 1 
fi
      
rm -rf /tmp/lttng
mkdir /tmp/lttng
cp -R ~/lttng/patches /tmp/lttng
cp  ~/lttng/userspace-rcu-0.8.6.tar.gz       /tmp/lttng
cp  ~/lttng/popt-1.16.tar.gz                 /tmp/lttng
cp  ~/lttng/xz-5.2.1.tar.gz                  /tmp/lttng
cp  ~/lttng/zlib-1.2.3.tar.gz                /tmp/lttng
cp  ~/lttng/libxml2-sources-2.9.7.tar.gz     /tmp/lttng
cp  ~/lttng/libuuid-1.0.2.tar.gz             /tmp/lttng
cp  ~/lttng/glib-2.25.13.tar.gz              /tmp/lttng
cp  ~/lttng/lttng-tools-2.9.9-RNC8300-stable-2.9.9-backport-rev7.tar.gz         /tmp/lttng
cp  ~/lttng/babeltrace-1.5.8.tar.gz          /tmp/lttng

cd /tmp/lttng
rm -rf glib-2.25.13/
rm -rf libuuid-1.0.2/
rm -rf libxml2-2.9.7/
rm -rf popt-1.16/
rm -rf userspace-rcu-0.8.6/
rm -rf xz-5.2.1/
rm -rf zlib-1.2.3/
rm -rf lttng-tools-2.9.10/
rm -rf babeltrace-1.5.8/

set -e

sleep 5

tar -xf userspace-rcu-0.8.6.tar.gz
cd userspace-rcu-0.8.6/
cp ../patches/0001-urcu-reduce-glibc-sym-dep.patch .
patch -p1 -i 0001-urcu-reduce-glibc-sym-dep.patch
env CFLAGS="$mflag -g -O2" ./configure
make
cd ..

tar -xf popt-1.16.tar.gz
cd popt-1.16/
env CFLAGS="$mflag -g -O2" ./configure
make
cd ..

tar -xf xz-5.2.1.tar.gz
cd xz-5.2.1/
env CFLAGS="$mflag -g -O2" ./configure
make
cd ..

tar -xf zlib-1.2.3.tar.gz
cd zlib-1.2.3/
env CFLAGS="$mflag -g -O2 -fPIC" LDSHARED="gcc $mflag" ./configure 
make
cd ..

tar -xf libxml2-sources-2.9.7.tar.gz
cd libxml2-2.9.7/
env CFLAGS="$mflag -g -O2 -D_GNU_SOURCE -I$PWD/../zlib-1.2.3/" LDFLAGS="-L$PWD/../xz-5.2.1/src/liblzma/.libs/ -L$PWD/../zlib-1.2.3/" ./configure --without-python
make
cd ..

tar -xf libuuid-1.0.2.tar.gz
cd libuuid-1.0.2/
env CFLAGS="$mflag -g -O2" ./configure
make
cd ..

tar -xf glib-2.25.13.tar.gz
cd glib-2.25.13/
cp ../patches/0001-glib2-reduce-glibc-sym-dep.patch .
patch -p1 -i 0001-glib2-reduce-glibc-sym-dep.patch
env CFLAGS="$mflag -g -O2 -D_GNU_SOURCE" ./configure --host=$xhost --disable-xattr --disable-selinux
make
cd ..

#module add bison/2.4
#module add autoconf/2.68
tar -xf lttng-tools-2.9.9-RNC8300-stable-2.9.9-backport-rev7.tar.gz
cd lttng-tools-2.9.10/
cp ../patches/0001-lttng-reduce-glibc-sym-dep.patch .
patch -p1 -i 0001-lttng-reduce-glibc-sym-dep.patch
env CFLAGS="$mflag -g -O2 -D_GNU_SOURCE -I$PWD/../userspace-rcu-0.8.6 -I$PWD/../popt-1.16/ -I$PWD/../libxml2-2.9.7/ -I$PWD/../libuuid-1.0.2/" LDFLAGS="-L$PWD/../userspace-rcu-0.8.6/.libs -L$PWD/../popt-1.16/.libs -L$PWD/../libxml2-2.9.7/.libs -L$PWD/../libuuid-1.0.2/.libs -L$PWD/../zlib-1.2.3/ -static" ./configure --without-lttng-ust --disable-man-pages
make
cd ..

tar -xf babeltrace-1.5.8.tar.gz
cd babeltrace-1.5.8
cp ../patches/babeltrace_static.patch .
cp ../patches/0001-Handle-_PC_NAME_MAX-limit-not-set.patch .
patch -p1 -i babeltrace_static.patch
patch -p1 -i 0001-Handle-_PC_NAME_MAX-limit-not-set.patch
env PKG_CONFIG_PATH="../glib-2.25.13:$PKG_CONFIG_PATH" CFLAGS="$mflag -g -O2 -D_GNU_SOURCE -I$PWD/../popt-1.16/ -I$PWD/../libuuid-1.0.2/ -I$PWD/../glib-2.25.13/ -I$PWD/../glib-2.25.13/glib/" LDFLAGS="-L$PWD/../popt-1.16/.libs -L$PWD/../libuuid-1.0.2/.libs -L$PWD/../glib-2.25.13/glib/.libs/ -L$PWD/../glib-2.25.13/gmodule/.libs/ -static" ./configure --disable-debug-info
make
cd .. 

cp /tmp/lttng/lttng-tools-2.9.10/src/bin/lttng-relayd/lttng-relayd /afs/.sunrise.ericsson.se/app/moshell/latest/moshell/commonjars/lttng-relayd.$os
cp /tmp/lttng/lttng-tools-2.9.10/src/bin/lttng-relayd/lttng-relayd /afs/.sunrise.ericsson.se/app/moshell/lttng/unstripped/lttng-relayd.$os
cp /tmp/lttng/lttng-tools-2.9.10/src/bin/lttng-relayd/lttng-relayd /afs/.sunrise.ericsson.se/app/moshell/lttng/stripped/lttng-relayd.$os
strip /afs/.sunrise.ericsson.se/app/moshell/lttng/stripped/lttng-relayd.$os

cp /tmp/lttng/babeltrace-1.5.8/converter/babeltrace /afs/.sunrise.ericsson.se/app/moshell/latest/moshell/commonjars/babeltrace.$os
cp /tmp/lttng/babeltrace-1.5.8/converter/babeltrace /afs/.sunrise.ericsson.se/app/moshell/lttng/unstripped/babeltrace.$os
cp /tmp/lttng/babeltrace-1.5.8/converter/babeltrace /afs/.sunrise.ericsson.se/app/moshell/lttng/stripped/babeltrace.$os
strip /afs/.sunrise.ericsson.se/app/moshell/lttng/stripped/babeltrace.$os

touch /env/releaseVolumes/app.TB_moshell
