######################################################################################
#                                                                                    #
#  Ericsson AB 2001-2021    - All Rights Reserved                                   #
#                                                                                    #
# The copyright to the computer program(s) herein is the property   of Ericsson AB,  #
# Sweden. The programs may be used and/or copied only with the written permission    #
# from Ericsson AB or in accordance with the terms and  conditions stipulated in the #
# agreement/contract under which the program(s) have been supplied.                  #
#                                                                                    #
######################################################################################

##########################  AMOS FUNCTIONALITY##############################

# Public method that may be used to check if moshell is operating in amos mode
# a value of 1 is returned from the method if this is the case.
function in_amos_mode()
{
	if (moshelldir ~/^\/+opt\/+ericsson\/+amos\/+moshell/) return 1
	else return 0
}


# Private method that is used to check if during execution amos suffered any
# failures this method is mostly used to ensure that we do not attempt
# to cleanup unacquired resources.
function is_amos_in_error()
{
	return AMOSInError == 1
}


# Public method that is used to start amos running for this moshell instance.
# This method should only be called once during the startup of the moshell.
function start_amos(what,    array,amos_sec_jars,i)
{
	amos_last_flush=systime()
	os=check_os()
	if (os=="linux") amos_rootlogdir="/ericsson/log/amos/moshell_logfiles"
	else amos_rootlogdir="/var/opt/ericsson/amos/moshell_logfiles"
	ossRevision=""
	gawk_pid=PROCINFO["pid"]
	amos_heart_beat=113
	amos_cache_sweep=3600
	amos_host=ENVIRON["NameServiceHost"]":"ENVIRON["NameServicePortGB"]
	amos_license_server=ENVIRON["HOSTNAME"]
	amos_database_name="ONRM_CS"
	amos_env_flags=ENVIRON["JAVAFLAGS"]
	#necessary jar files required for amos, some can be found from the following environment variables:
	#NSA_CLASSPATH=/opt/ericsson/nms_cif_nsa/lib/nms_cif_nsa.jar
	#PAS_CLASSPATH=/opt/ericsson/nms_cif_pas/lib/nms_cif_pas.jar
	#PORTAL_CLASSPATH=/opt/ericsson/nms_cif_portal/lib/nms_cif_portal.jar
	#SECURITY_CLASSPATH=:/opt/ericsson/secpf/ssuj/lib/ssu.jar:/opt/ericsson/secpf/csuj/lib/csu.jar
	#SENTINEL_CLASSPATH=:/opt/Sentinel/Java/
	#TSS_CLASSPATH=/opt/ericsson/nms_tss_client/classes/tss.jar:/opt/ericsson/nms_tss_client/classes/tsscli.jar
	#BORLAND_HOME=/opt/borland/bes

	maxAmosJar=0
	maxTbacJar=0
	amos_jar_files[++maxAmosJar] = "/opt/ericsson/amos/lib/amos.jar"
	if (os!="linux")
	{
		amos_jar_files[++maxAmosJar] = ENVIRON["NSA_CLASSPATH"] #"/opt/ericsson/nms_cif_nsa/lib/nms_cif_nsa.jar"
		amos_jar_files[++maxAmosJar] = "/opt/ericsson/nms_cif_sm/lib/nms_cif_sm.jar"
		amos_jar_files[++maxAmosJar] = ENVIRON["BORLAND_HOME"]"/lib/vbjorb.jar" #"/opt/ericsson/nms_cif_security/lib/vbjorb.jar"
		amos_jar_files[++maxAmosJar] = ENVIRON["PORTAL_CLASSPATH"] #"/opt/ericsson/nms_cif_portal/lib/nms_cif_portal.jar"
		amos_jar_files[++maxAmosJar] = "/opt/ericsson/nms_cif_cs/lib/nms_cif_cs.jar"
		amos_jar_files[++maxAmosJar] = gensub(/^.*:/,"",1,ENVIRON["SENTINEL_CLASSPATH"]) # "/opt/Sentinel/Java/"
		sub(/^:/,"",ENVIRON["SECURITY_CLASSPATH"]) ; split(ENVIRON["SECURITY_CLASSPATH"],array,":") #SECURITY_CLASSPATH=:/opt/ericsson/secpf/ssuj/lib/ssu.jar:/opt/ericsson/secpf/jsu/lib/jsu.jar:/opt/ericsson/secpf/csuj/lib/csu.jar
		for (i in array) amos_sec_jars[array[i]]=1
		split(ENVIRON["TSS_CLASSPATH"],array,":")
		for (i in array) if (array[i]~"tss.jar") amos_sec_jars[array[i]]=1
		for (i in amos_sec_jars) amos_jar_files[++maxAmosJar]=i
		amos_jar_files[++maxAmosJar] = ENVIRON["BORLAND_HOME"] "/lib/vbsec.jar" #"/opt/ericsson/nms_cif_security/lib/vbsec.jar"
		amos_jar_files[++maxAmosJar] = ENVIRON["PAS_CLASSPATH"]  #"/opt/ericsson/nms_cif_pas/lib/nms_cif_pas.jar"

		#/ossrc/3pp/opt/misc3pp/spring/spring.jar
		#/opt/ericsson/nms_cex_client/bin/plugins/org.springframework.beans_2.5.6.A.jar
		#/opt/ericsson/nms_cif_osgifwk/osgi/plugins/com.springsource.org.apache.commons.logging-1.1.1.jar
		#/opt/ericsson/nms_cif_osgifwk/osgi/plugins/org.springframework.context-2.5.6.A.jar
		#/opt/ericsson/nms_cxp_us_accesscontrol/lib/com.ericsson.oss.utilities.accesscontrol.shared.acs.jar
		tbac_jar_files[++maxTbacJar]="/opt/misc3pp/spring/spring.jar"
		tbac_jar_files[++maxTbacJar]="/opt/misc3pp/spring/modules/org.springframework.beans.jar"
		tbac_jar_files[++maxTbacJar]="/opt/misc3pp/spring/modules/org.springframework.context.jar"
		tbac_jar_files[++maxTbacJar]="/opt/ericsson/nms_cxp_us_accesscontrol/lib/com.ericsson.oss.utilities.accesscontrol.shared.acs.jar"
		tbac_jar_files[++maxTbacJar]="/opt/ericsson/nms_cif_osgifwk/osgi/plugins/com.springsource.org.apache.commons.logging-1.1.1.jar"
		tbac_jar_files[++maxTbacJar]="/opt/ericsson/nms_one/client/lib/nms_one_server.jar"
		tbac_jar_files[++maxTbacJar]="/opt/ericsson/amos/lib/com.ericsson.oss.services.common.cm.service.rmi-CXP9018624-R98Y01.jar"
		tbac_jar_files[++maxTbacJar]="/opt/ericsson/amos/lib/com.ericsson.oss.services.common.cm.shared-CXP9018624-R98Y02.jar"
		tbac_jar_files[++maxTbacJar]="/opt/ericsson/amos/lib/com.ericsson.oss.shared.commontypes_3.3.1.jar"
	}

	check_amos_jars(amos_jar_files,maxAmosJar)
	check_amos_jars(tbac_jar_files,maxTbacJar,"soft")
	check_amos_java()

	if (tempknownhostfile=="") tempknownhostfile=sprintf("%s/knownhost%s",tempdir,gawk_pid)
	if (tempsshzfile=="")      tempsshzfile     =sprintf("%s/sshz%s",      tempdir,gawk_pid)


	AMOSRequestBroker = make_amos_command(amos_jar_files)

	if (what=="rb") return

	if (amos_ssu(AMOSRequestBroker) == 1)
	{
		customPrint("!!! Unable to download ssucredentials.xml from SLS.")
		exit_with_error("","AMOS error")
	}

	amos_hostname=check_hostname()
	amos_ps_logfile=sprintf("/var/opt/ericsson/amos/sessions_%s.log",amos_hostname)
	start_amos_command(AMOSRequestBroker)
	command_props()
	make_amosvarfile()
}
function amos_rb(thefile,resultTable,   ok,buffer,nok)
{
	delete amos_ip  #global table
	if (fileOps("test -s "thefile)!=0)
	{
		customPrint("ERROR: cannot read file "thefile)
		exit_with_error()
	}
	ok=nok=0
	while ((getline < thefile)>0)
	{
		if (/OSS Framework for MoShell/) ok=1
		else if (/^---- Node translations ----$/) ok=0
		else if (/^AMOS error, exiting/) { nok=1 ; break }
		else if (ok==1)
		{
			gsub("\r",""); gsub("\x00","")
			buffer=buffer"\n"$0
		}
		else if (ok==0 && $1=="translate") amos_ip[$2]=$4
	}
	close(thefile)
	if (nok==1)
	{
		customPrint(buffer)
		AMOSInError=1
		exit_with_error("","AMOS error")
	}

	start_amos("rb")
	amos_hostname=check_hostname()
	amos_ps_logfile=sprintf("/var/opt/ericsson/amos/sessions_%s.log",amos_hostname)
	command_props("rb",thefile)
	make_amosvarfile()

}
function make_amosvarfile()
{
	templastamoscmd    = sprintf("%s/amoslastcmd",tempdir)
	tempamosvarfile    = sprintf("%s/amosvarfile",tempdir)
	printf("\
BEGIN{\n\
moshell_pid=%s\n\
moshelldir=\"%s\"\n\
logdir=\"%s\"\n\
tempdir=\"%s\"\n\
vobsinstallation=\"%s\"\n\
jarxmldir=\"%s\"\n\
mosdebug=\"%s\"\n\
use_netcatlib=%s\n\
ip_connection_timeout=%s\n\
ip_inactivity_timeout=%s\n\
http_timeout=%s\n\
ftp_timeout=%s\n\
fast_timeout=%s\n\
amos_debug=\"%s\"\n\
AMOSRequestBroker=\"%s\"\n\
nm_folder=\"%s\"\n\
nm_credential=\"%s\"\n\
bash=\"%s\"\n\
gawk_pid=\"%s\"\n\
amos_java=\"%s\"\n\
java=\"%s\"\n\
amospermcommand=\"%s\"\n\
gawk=\"%s\"\n\
moshellUSER=\"%s\"\n\
amos_perm_list=\"%s\"\n\
node_address=\"%s\"\n\
node=\"%s\"\n\
jarxmldir=\"%s\"\n\
commonjardir=\"%s\"\n\
corba_timeout=\"%s\"\n\
corba_connection_timeout=\"%s\"\n\
transaction_timeout=\"%s\"\n\
sls_timeout=\"%s\"\n\
sls_username=\"%s\"\n\
sls_password=\"%s\"\n\
templastamoscmd=\"%s\"\n\
amosopt=\"%s\"\n\
}\n",\
moshell_pid,moshelldir,logdir,tempdir,vobsinstallation,jarxmldir,mosdebug,use_netcatlib,ip_connection_timeout,ip_inactivity_timeout,\
http_timeout,ftp_timeout,fast_timeout,amos_debug,gensub(/"/,"\\\\\"","g",AMOSRequestBroker),nm_folder,nm_credential,bash,gawk_pid,\
amos_java,java,amospermcommand,gawk,setUSER(),amos_perm_list,node_address,node,jarxmldir,commonjardir,corba_timeout,corba_connection_timeout,\
transaction_timeout,sls_timeout,sls_username,sls_password,templastamoscmd,amosopt) > tempamosvarfile
	close(tempamosvarfile)
	#gensub(/["]/,"\\"","g",AMOSRequestBroker)
}
function amos_readanswer()
{
	readanswer=sprintf("%s/readanswer%s",tempdir,gawk_pid)
	#if (fileOps("test -s "readanswer)!=0) printf("#!%s -fp\nread %s -t %s\nif [[ `set | grep ^REPLY=` = REPLY=* ]] ; then echo \"$REPLY\" ; else echo TIMEOUT ; fi\n",bash,(mosdebug~/^999?$/?"-n 2048":"-e"),inactivity_timeout) > readanswer
	if (fileOps("test -s "readanswer)!=0) make_readanswer()
}
function amos_ssu(AMOSRequestBroker,   last,i,array,sls,OfflineBrowser,line,oldUserVariables)
{
	if (AMOSRequestBroker !~ /se.ericsson.security.ssu.authenticationenabled=true/) return 0
	if (amos_check_ssucred() == 0) return 0
	oldUserVariables["sls_urls"]=sls_urls
	oldUserVariables["corba_class"]=corba_class
	oldUserVariables["iorfile"]=iorfile
	oldUserVariables["node"]=node
	oldUserVariables["nm_folder"]=nm_folder
	oldUserVariables["nm_credential"]=nm_credential
	oldUserVariables["mosdebug"]=mosdebug
	amos_readanswer()
	last=split(AMOSRequestBroker,array," ")
	for (i=1;i<=last;i++)
	{
		if (array[i] ~ /^-Dse.ericsson.security.ssu.slsurls=/) sls_urls=gensub(/^[^=]+=/,"",1,array[i])
	}
	corba_class=4
	iorfile="/opt/ericsson/amos/moshell/moshell"
	node="dummy"
	#nm_folder=ENVIRON["HOME"]"/Ericsson/OMSec"
	if (amos_debug>=1) mosdebug=1
	nm_folder=tempdir
	nm_credential=tempdir"/ssucredentials.xml"
	OfflineBrowser=make_java_command("mobrowser","silent")
	while (OfflineBrowser |& getline line)
	{
		if (mosdebug==1) customPrint(line)
	}
	close(OfflineBrowser)
	if (fileOps("test -s "nm_credential) != 0) return 1
	amos_clean_ssu(nm_credential)
	fileOps("mv "nm_credential" "ENVIRON["HOME"]"/Ericsson/OMSec")
	chmod(00600,ENVIRON["HOME"]"/Ericsson/OMSec/ssucredentials.xml")
	sls_urls=oldUserVariables["sls_urls"]
	corba_class=oldUserVariables["corba_class"]
	node=oldUserVariables["node"]
	iorfile=oldUserVariables["iorfile"]
	nm_folder=oldUserVariables["nm_folder"]
	nm_credential=oldUserVariables["nm_credential"]
	mosdebug=oldUserVariables["mosdebug"]
	#AMOSRequestBroker = make_amos_command(amos_jar_files)
	return 0
}
function amos_clean_ssu(file)
{
	fileOps("rm "file".dos2unix.temporary.xml")
	if (fileOps("test -s "file) != 0) return
	while ((getline < file)>0)
	{
		sub(/\r$/,"")
		if (NF>0) print $0 >> file".dos2unix.temporary.xml"
	}
	close(file)
	close(file".dos2unix.temporary.xml")
	fileOps("mv "file".dos2unix.temporary.xml "file)
}
function amos_check_ssucred(    sslcommand,res,line,endDate,array,mm,tz,currDate,datecmd)
{
	mm["Jan"]=1;mm["Feb"]=2;mm["Mar"]=3;mm["Apr"]=4;mm["May"]=5;mm["Jun"]=6
	mm["Jul"]=7;mm["Aug"]=8;mm["Sep"]=9;mm["Oct"]=10;mm["Nov"]=11;mm["Dec"]=12

	res=1  #ssu is not ok
	if (fileOps("test -s "nm_credential) != 0)
	{
		if (amos_debug>=1) customPrint("Credential file not found: "nm_credential)
		return res
	}
	#sslcommand="/usr/sfw/bin/openssl x509 -in "nm_credential" -enddate -noout 2>&1"
	sslcommand=sprintf("%s '{gsub(/<[^>]+>/,\"\");print}' %s | %s x509 -enddate -noout 2>&1",gawk,nm_credential,openssl)
	while (sslcommand |& getline line)
	{
		#notAfter=Nov 24 15:25:15 2011 GMT
		if (line !~ /^notAfter=/) continue
		sub(/^[^=]+=/,"",line)
		split(line,array," ")
		endDate=make_timestamp(sprintf("%s-%s-%s",array[4],mm[array[1]],array[2]),array[3])
		tz=array[5]
	}
	close(sslcommand)
	datecmd="TZ="tz" date +\"%Y %m %d %H %M %S\""
	datecmd |& getline currDate ; close(datecmd)
	if (mymktime(currDate) < endDate) res=0
	if (amos_debug>=1)
	{
		restrans[0]="Valid" ; restrans[1]="Not valid"
		customPrint("\nChecking credential validity of "nm_credential": \n    currDate: "mystrftime("%Y-%m-%d %H:%M:%S",mymktime(currDate))" "tz"\n    endDate:  "mystrftime("%Y-%m-%d %H:%M:%S",endDate)" "tz"\n     => "restrans[res]"\n")
	}
	return res
}

function amos_process_log(pid,nochmod,   line,array,currtime,pstool_session,nch,nSess,nProc)
{
	if (!(in_amos_mode()==1 && amos_process_logging=="true")) return
	currtime=mystrftime("%Y-%m-%d-%H-%M-%S",systime())
	if (pid ~ /^[0-9]+$/)
	{
		#we substract the session with this pid and its children from the result
		pstool_session=sprintf("%s/pstool "pid,moshelldir)
		while ((pstool_session |& getline line)>0)
		{
			#NCh=1 %CPU=0.0 %MEM=0.1 RSS=40.5M VSZ=43.0M
			split(line,array," ")
			if (array[1]~/^NCh=/) nch=gensub(/^.*=/,"",1,array[1])+1
		}
		close(pstool_session)
	}
	pstool_session=sprintf("%s/pstool list",moshelldir)
	while ((pstool_session |& getline line)>0)
	{
		#Moshell Sessions: 2, Spawned Processes: 9
		split(line,array," ")
		if (array[1]=="Moshell" && array[2]=="Sessions:")
		{
			if (nch > 0)
			{
				nSess=array[3]-1 ; nProc=array[6]-nch
				res="Moshell Sessions: "(nSess>0?nSess:0)", Spawned Processes: "(nProc>0?nProc:0)
			}
			else res=line
		}
	}
	close(pstool_session)
	close(amos_ps_logfile)
	printf("%s,%s\n",currtime,res) >> amos_ps_logfile
	close(amos_ps_logfile)
	if (nochmod=="") chmod(00666,amos_ps_logfile)
	else system("(chmod 666 "amos_ps_logfile") 2>/dev/null")
}

# Public method that is used to stop amos for this moshell instance. This
# method should only be called once during the shutdown of the moshell.
function stop_amos(  line)
{
	#check that amos is not in error when we are shutting down
	if (in_amos_mode() && !is_amos_in_error())
	{
		#check that we have a resource
		if (AMOSStarted == 1 && is_process_there(customVar["$amosrb_pid"])==0)
		{
			#print "Stopping amos"
			#this should bring down the amos process
			print "stop" |& AMOSRequestBroker
			while (AMOSRequestBroker |& getline line){ if (amos_debug>=1) print line }
			#no need to close the process it will terminate
			close(AMOSRequestBroker)
			tid(5)
			AMOSStarted=0
		}
	}
}
# Private method which ensures that a 'java' runtime environment is
# available to run the 'AMOSRequestBroker' process and it also checks that
# the java version is greater than '1.4.1_09'.
function check_amos_java(   version,jcom)
{
	if (fileOps("test -f " amos_java) != 0)
	{
		exit_amos_error("error : amos misconfigured - path to java not found (amos_java="amos_java")")
	}

	jcom=sprintf("%s -version 2>&1",amos_java)
	if (amos_debug>0) print "DEBUG: checking java version with "jcom
	while ((jcom |& getline)>0)
	{
		gsub("\r","") ; gsub("\x00","")
		if (amos_debug>0) print "DEBUG: "$0
		if (/(java|openjdk) version "/) version=gensub(/^[^"]*"|"/,"","g",$0)
	}
	close(jcom)

	if (version < "1.4.1_09")
	{
		exit_amos_error("error : amos misconfigured - java version must be 1.4.1_09 or greater")
	}
}


# Private method which ensures that all the necessary jar files
# required to successfully start the 'AMOSRequestBroker' process are
# available on the system.
function check_amos_jars(jarTable,maxIndex,soft,   i)
{
	# loop over each jar file and test that the file exists
	for (i=1; i<=maxIndex; i++)
	{
		if (amos_debug>=2) print i"/"maxIndex": "jarTable[i]
		if (fileOps("test -f " jarTable[i]) != 0)
		{
			if (fileOps("test -d " jarTable[i]) != 0)
			{
				if (soft=="soft") jarTable[i]="/FILE_NOT_FOUND/"gensub(/^.*\//,"",1,jarTable[i])
				else exit_amos_error("error : amos misconfigured - jar file not found " jarTable[i])
			}
		}
	}
}

# Private method that is used to build the 'java' command that will
# be used to start the 'AMOSRequestBroker' process.
function make_amos_command(amos_jar_files,   fullcommand,flags,classpath,mainclass,unwritableflags,writableflags,i,log4j)
{
	os=check_os()
	#the fullcommand is what is returned once the command is build successfully
	fullcommand = amos_java" -client "
	fullcommand = fullcommand" -Djava.security.egd=file:/dev/./urandom "
	#unwritable, unmodifiable flags i.e. we will always be using visibroker
	unwritableflags = " " amos_env_flags

	if (os=="linux")
	{
		mainclass = " com.ericsson.oss.services.amos.requestbroker.AMOSRequestBroker"
		#writabale, modifiable flags whose values depend on the current environment
		writableflags = sprintf(" \
-Damos.debug.mode=%s \
-Damos.cache.sweep.interval=%s -Damos.license.heart.beat.interval=%s",\
"true", amos_cache_sweep,amos_heart_beat)
		classpath = " -classpath /opt/ericsson/amos/lib/amos.jar:/opt/ericsson/amos/lib/*"
	}
	else
	{
		#the class that is the starting point of the AMOSRequestBroker process
		mainclass = " com.ericsson.nms.umts.ranos.amos.AMOSRequestBroker"
		#writabale, modifiable flags whose values depend on the current environment
		writableflags = sprintf(" \
-DORBInitRef=NameService=iioploc://%s/NameService -Damos.debug.mode=%s \
-Dvbroker.qos.defaultRRTTimeout=12000 \
-Damos.database.name=%s -DSentinel.licenseServer=%s -Damos.cache.sweep.interval=%s -Damos.license.heart.beat.interval=%s ",\
amos_host,"true",amos_database_name, amos_license_server, amos_cache_sweep,amos_heart_beat)
		#old:
		#-DORBInitRef=NameService=iioploc://%s/NameService -Damos.feature.name=%s -Damos.feature.version=%s -Damos.debug.mode=%s \
		#-Damos.database.name=%s -DSentinel.licenseServer=%s -Damos.cache.sweep.interval=%s -Damos.license.heart.beat.interval=%s ",\
		#amos_host,amos_feature,amos_version,amos_debug,amos_database_name,amos_license_server,amos_cache_sweep,amos_heart_beat)

		#put all the jars we know about on the classpath
		classpath = " -classpath "amos_jar_files[1]
		for (i=2; i<=maxAmosJar; i++) classpath = classpath ":" amos_jar_files[i]
		for (i=1; i<=maxTbacJar; i++) classpath = classpath ":" tbac_jar_files[i]
	}



	#-Dse.ericsson.security.ssu.authenticationenabled=true

	#firsly build all the -D flag parameters
	flags = unwritableflags writableflags

	#with amos_debug=3 or higher we can get more info in the logfile /var/tmp/name_Visibroker_log.txt

	#TR HU22533 (http://jira-nam.lmera.ericsson.se/browse/OSS-94606)
	if (os!="linux")
	{
		log4j="/opt/ERICddc/util/lib/log4j.jar"
		if (fileOps("test -s "log4j)==0)
		{
			#fileOps("mkdir -p /var/opt/ericsson/log/AMOS")
			classpath = classpath ":"log4j
			flags = flags " -Dse.ericsson.security.debug=true -Dvbroker.log.enable=true -Dvbroker.log.logLevel=debug -Dvbroker.security.logLevel=LEVEL_DEBUG -Dvbroker.log.default.appenders=rolling -Dvbroker.log.default.appender.rolling.appenderType=rolling -Dvbroker.log.default.appender.rolling.logDir=/var/opt/ericsson/log/AMOS -Dvbroker.log.default.appender.rolling.fileName=AMOS_Visibroker_log.txt -Dvbroker.log.default.appender.rolling.maxFileSize=50 -Dvbroker.log.default.appender.rolling.maxBackupIndex=1000 -Dlog4j.configuration=file:///opt/ericsson/nms_cif_ist/etc/log4j.properties "
		}
	}

	#put all the command together
	fullcommand = fullcommand flags classpath mainclass " 2>&1"

	if (amos_debug>=1) print fullcommand
	return fullcommand
}

# Private method that is used to start the 'AMOSRequestBroker' process,
# this method first runs the process and begins reading the process
# output via the 'getline' command, once the initial prompt is recieved
# it breaks out of the loop and continues execution.
function start_amos_command(AMOSRequestBroker,   line)
{
	if (amos_debug>=1) last_amos_error=""
	else last_amos_error=AMOSRequestBroker"\n"
	system("") #forcefully flush output
	AMOSStarted=0
	#getline will block if there is no more input
	tid(1)
	while (AMOSRequestBroker |& getline line)
	{
		#print $0
		gsub("\r","",line)
		if (line ~ /AMOSRequestBroker Enter Command : /)
		{
			tid(2)
			AMOSStarted = 1
			break
		}
		else if (amos_debug>=1) print line
		else last_amos_error=last_amos_error"\n"line
	}
	tid(3)
	if (AMOSStarted==1) find_javaprocess(gawk_pid,"amosrb")
	tid(4)
}

# Private method that is used internally to write a command to the
# 'AMOSRequestBroker' process and to read the 'AMOSRequestBroker' process's
# response. This method will return the output from the 'AMOSRequestBroker'
function run_translation_command(theCommand,   result,line,array)
{
	if (amos_debug>=1) print "AMOSRequestCommand : "theCommand
	print theCommand |& AMOSRequestBroker
	while (AMOSRequestBroker |& getline line)
	{
		#AMOSRequestResponse : true a.b.c.d
		#AMOSRequestResponse : true null
		gsub("\r","",line)
		if (amos_debug>=1) print line
		split(line,array," ")
		if (line ~ /AMOSRequestBroker Enter Command : /) break
		if (array[1]=="AMOSRequestResponse" && array[3]=="true" && tolower(array[4]) !~ /error|null/)
		{
			result=array[4]
		}
		else
		{
			#TR HK76139, hide the error message from the translation command, confusing
		}
	}
	return result
}

# Private method that is used internally to write a command to the
# 'AMOSRequestBroker' process and to read the 'AMOSRequestBroker' process's
# response. This method will return the output from the 'AMOSRequestBroker'
function run_request_command(theCommand,internal,what,   result,line,array)
{
	if (in_amos_sim()) return 1
	if (amos_debug>=1) last_amos_error=""
	else last_amos_error=AMOSRequestBroker"\n\nAMOSRequestCommand : "theCommand
	if (amos_debug>=1) print "AMOSRequestCommand : "theCommand
	print theCommand |& AMOSRequestBroker
	while (AMOSRequestBroker |& getline line)
	{
		gsub("\r","",line)
		if (amos_debug>=1) print line
		else last_amos_error=last_amos_error"\n"line
		split(line,array," ")
		if (line ~ /AMOSRequestBroker Enter Command : /) break
		if (array[1]=="AMOSRequestResponse")
		{
			if (array[3]=="true")
			{
				result=1
			}
			else
			{
				result=0
			}
		}
		else
		{
			if (line ~ /Major revisi?on is : O[0-9]+/) ossRevision=gensub(/^.*: /,"",1,line)
			#debug : isDBCAuthorized->true
			if (line ~ "isDBCAuthorized->true") amos_status["dbc"]=1
			if (internal=="internal")
			{
				if (line !~ /^[ \t]*debug[ \t:]/ || theCommand ~ /^(analyze|permission) get/) result=result"\n"line
				if (line ~ /error : programming error - unexpected failure encountered/ && amos_env_flags ~ /se.ericsson.security.type=client/ && amos_env_flags ~ /se.ericsson.security.ssu.authenticationenabled=true/ && moshellUSER=="root")
				{
					print "\n        error : Cannot run AMOS as root from Application Server when Corba Security is turned on in MasterServer"
				}
				else if (theCommand == "permission get" && line ~ /error : request error - invalid moshell communication/) result=2
			}
			else customPrint(line)
		}
	}
	return result
}

# Public method that is used to ask the 'AMOSRequestBroker' process to
# analyze an moshell command from the 'OSS' point of view. This method will
# return a value of 1 if the 'OSS' is happy to allow the moshell
# command to proceed.
function amos_request(moShellCommand,fullCommand,nodeIPAddress,nodeName,   result)
{
	result=1
	if (in_amos_mode())
	{
		if (is_dangerous_command(moShellCommand))
		{
			result = analyze_command(moShellCommand)
		}
		#amosLog[++amosCount]=sprintf("%s was executed on %s (%s). Result=%s",fullCommand,nodeIPAddress,nodeName,(result==1?"OK":"Fail"))
	}
	return result
}

# This method returns true i.e. a value of 1 if the moshell command that is
# is about to be run is considered dangerous by the OSS.
function is_dangerous_command(co,    i)
{
	if (co ~ /^(h|l|!.*|m|n|o|p|q|q|q!!|exit|quit|bye*|uv|pv|upid[cm]*)$/) return 0
	for (i in SearchString)
	{
		if (co ~ SearchString[i]) return 1
	}
	if (co ~ /^reload$/) return 1
        return 0
}

# Public method that is used to ask the 'AMOSRequestBroker' process to
# translate a well known name i.e. 'RNC12' to an ip address
# i.e a.b.c.d. This method will return an ip address back to its
# client.
function amos_translate(nodeName,resultTable,what,   amosTranslateResponse,t_nodeName)
{
	if (what=="rb")
	{
		t_nodeName=tolower(nodeName)
		if (t_nodeName in amos_ip && amos_ip[t_nodeName]!="") amosTranslateResponse=amos_ip[t_nodeName]
		delete amos_ip  #save memory, this table not needed anymore
	}
	else amosTranslateResponse = run_translation_command("translate " nodeName)
	resultTable["node_name"]= nodeName
	if (amosTranslateResponse == "")
	{
		#TR HK76139, hide the translation error message, confusing
		#customPrint("WARNING: amos translate failed. Node name will not be translated")
		return nodeName
	}
	else return amosTranslateResponse
}

#TBAC target based access control
#New feature in O13.0.7 applicable for LTE nodes only, to check if the user has permission to access this particular node
function amos_tbac(nodeName,nodeAddress,   result,line,array,theCommand,last)
{
	result=0  #=Ok : node is allowed by default
	if (ossRevision < "O13")
	{
		if (amos_debug>=1) print "\n        debug : TBAC not applicable, OSS revision is lower than O13: "ossRevision
		return result
	}
	if (node_address ~ /^OFFLINE_/) return result
	theCommand="tbac "node_address
	if (amos_debug>=1) print "AMOSRequestCommand : "theCommand
	print theCommand |& AMOSRequestBroker
	while (AMOSRequestBroker |& getline line)
	{
		gsub("\r","",line)
		if (amos_debug>=1) print line
		last=split(line,array," ")
		if (line ~ /AMOSRequestBroker Enter Command : /) break
		#debug : isAuthorized->false
		if (line ~ /error : tbac control - unauthorised network element/) result=line
	}
	return result
}
#Node Type
function amos_nodetype(   result,line,array,theCommand,last)
{
	#5GRadioNode
	#BGF
	#BSP
	#CSCF
	#Controller6610
	#DSC
	#ERBS
	#HSS-FE
	#IPWorks
	#MGW
	#MRF
	#MRS
	#MSRBS_V1
	#MTAS
	#RBS
	#RNC
	#RVNFM
	#RadioNode
	#RadioTNode
	#SBG
	#SIU02
	#TCU02
	#VTFRadioNode
	#vBGF
	#vCSCF
	#vDSC
	#vHSS-FE
	#vIPWorks
	#vMRF
	#vMTAS
	#vPP
	#vRC
	#vRM
	#vSBG
	#vSD
	#vTIF
	result=0  #unknown
	if (in_amos_mode()!=1) return result
	if (os!="linux") return result
	#if (ssh_server_type ~ /Erlang|Tectia|dropbear|for OSE/) return result #dont need to do the check on OSE, Netsim or AXE
	close(AMOSRequestBroker)
	theCommand="nodeType "node_address
	if (amos_debug>=1) print "AMOSRequestCommand : "theCommand
	print theCommand"\nstop" |& AMOSRequestBroker
	while (AMOSRequestBroker |& getline line)
	{
		#AMOSRequestResponse : true RadioNode
		#AMOSRequestResponse : true ERBS HTTPS
		gsub("\r","",line)
		if (amos_debug>=1) print line
		if (line ~ /AMOSRequestResponse : true /)
		{
			last=split(line,array," ")
			if (array[last]!="") result=array[last]
		}
	}
	close(AMOSRequestBroker)
	#RCS : 5GRadioNode, RadioNode, RadioTNode, Controller6610
	#vRAN 1.0: vPP,vRC,vSD,vTIF,RVNFM
	#pico: MSRBS_V1

	if (result~/^(5G|VTF)?RadioT?Node|^Controller6/) result=1  #rcs
	else if (result~/^(vPP|vRC|vSD|vTIF|RVNFM)$/) result=2  #vran 1.0
	else if (result=="MSRBS_V1") result=3  #pico
	else if (result=="HTTPS") result=4 #CPP with HTTPS
	else result=0  #other node types are not yet considered
	return result+0
}

# Private method used to exit the moshell if amos has encountered severe
# problems during execution
function exit_amos_error(msg)
{
	print msg
	if (in_amos_sim()) return
	AMOSInError=1
	exit_with_error("","AMOS error")
}
function command_props(what,thefile,    n,i,thecom,a,amosperm,theperm)
{
	if (what=="rb")
	{
		amosperm["set"]="write"
		amosperm["fro"]="telnet"
		amosperm["fset"]="blocked"
		amos_status["read"]=1
		amos_status["write"]=amos_status["telnet"]=amos_status["blocked"]=amos_status["dbc"]=0
		while ((getline < thefile)>0)
		{
			#AMOSRequestBroker Enter Command :
			#AMOSRequestCommand : permission get was executed on -
			#AMOSRequestResponse : true
			if (/AMOSRequestBroker Enter Command/) theperm=""
			else if ($1=="AMOSRequestCommand" && $0~/(analyze|permission) (fro|set|fset) was executed on /)
			{
				match($0,/(analyze|permission) (fro|set|fset) was executed on /,a)
				amospermcommand=a[1]
				thecom=a[2]
				theperm=amosperm[thecom]
			}
			else if ($1=="AMOSRequestResponse" && theperm!="") amos_status[theperm]=($3=="true"?1:0)
			else if (/Major revisi?on is : O[0-9]+/) ossRevision=gensub(/^.*: /,"",1,$0)
			else if (/isDBCAuthorized->true/) amos_status["dbc"]=1
			else if (theperm!="" && $0!~/^[ \t]*debug[ \t:]/) amos_status[theperm]=amos_status[theperm]"\n"$0
		}
		close(thefile)
	}
	else
	{
		#if (in_amos_mode() != 1 || is_amos_in_error()) return
		if (!(AMOSStarted == 1 && is_process_there(customVar["$amosrb_pid"])==0)) exit_amos_error(last_amos_error)
		amospermcommand="permission"
		if (run_request_command("permission get","internal") ~ /^2/) amospermcommand="analyze"
		if (!(AMOSStarted == 1 && is_process_there(customVar["$amosrb_pid"])==0)) exit_amos_error(last_amos_error)
		amos_status["read"]   = run_request_command(amospermcommand" get was executed on -","internal")
		if (amos_status["read"] !~ /^1/) exit_amos_error(gensub(/^0?/,"",1,amos_status["read"]))
		amos_status["telnet"] = run_request_command(amospermcommand" fro was executed on -","internal")
		amos_status["write"]  = run_request_command(amospermcommand" set was executed on -","internal")
		amos_status["blocked"]= run_request_command(amospermcommand" fset was executed on -","internal")
	}
	#TR correction HQ79170 is removed:
	#amos_status["blocked"]= "0\n        error : access control - user not authorized to execute command"
	#stop_amos()
	for (i in amos_status)
	{
		if (amos_status[i] ~ /^1/) { amos_status[i]=1 ; amos_perm[i]=i }
		else sub(/^0/,"",amos_status[i])
	}
	n=asort(amos_perm)
	amos_perm_list=""
	for (i=1;i<=n;i++) amos_perm_list=amos_perm_list","amos_perm[i]
	sub(/^,/,"",amos_perm_list)
	#amos_blocked["fget"]=amos_blocked["lfget"]=amos_blocked["facc"]=amos_blocked["lfacc"]=1
	#amos_blocked["pbl"]=amos_blocked["pdeb"]=1
	#amos_blocked["pset"]=1
	amos_blocked["fset"]=amos_blocked["lfset"]=1
	#TR HR71889, must allow pcr/pdel
	#amos_blocked["pcr"]=amos_blocked["pcrf"]=amos_blocked["lpcr"]=amos_blocked["lpcrf"]=1
	#amos_blocked["pdel"]=1
	amos_write["set"]=amos_write["setm"]=amos_write["setc"]=amos_write["lset"]=amos_write["lsetm"]=amos_write["lsetc"]=1
	amos_write["set1"]=amos_write["lset1"]=1
	amos_write["eset"]=amos_write["leset"]=amos_write["esetc"]=amos_write["lesetc"]=amos_write["eset1"]=amos_write["leset1"]=1
	amos_write["del"]=amos_write["ldel"]=amos_write["rdel"]=amos_write["lrdel"]=amos_write["rset"]=amos_write["lrset"]=1
	amos_write["fdel"]=amos_write["lfdel"]=1
	amos_write["resub"]=amos_write["remod"]=amos_write["remod2"]=amos_write["remodu"]=amos_write["cr"]=amos_write["cre"]=1
	amos_write["bl"]=amos_write["bls"]=amos_write["lbl"]=amos_write["lbls"]=amos_write["deb"]=amos_write["ldeb"]=1
	amos_write["acc"]=amos_write["acce"]=amos_write["lacc"]=amos_write["lacce"]=amos_write["actc"]=amos_write["accn"]=amos_write["laccn"]=1
	amos_write["facc"]=amos_write["lfacc"]=amos_write["pbl"]=amos_write["pdeb"]=1
	amos_write["cvmk"]=amos_write["cvms"]=amos_write["cvset"]=amos_write["cvrm"]=amos_write["cvput"]=1
	amos_write["trun"]=amos_write["truni"]=amos_write["trun1"]=amos_write["trun1c"]=amos_write["trun1r"]=1
	amos_write["cvre"]=amos_write["cvrbrm"]=amos_write["cvfa"]=amos_write["cvfd"]=amos_write["cvfda"]=amos_write["cvfdc"]=1
	amos_write["scw"]=amos_write["scd"]=1
	amos_write["irp"]=amos_write["irs"]=amos_write["ird"]=amos_write["irm"]=amos_write["rinpm"]=1
	amos_write["pgu"]=amos_write["pguc"]=amos_write["pgur"]=amos_write["pguf"]=1
	amos_write["pcrp"]=amos_write["pdelp"]=1
	amos_telnet["fclean"]=amos_telnet["fcleana"]=amos_telnet["fcleane"]=1
	amos_telnet["fro"]=amos_telnet["from"]=amos_telnet["lfro"]=amos_telnet["lfrom"]=amos_telnet["sql+"]=amos_telnet["sql-"]=1
	amos_telnet["tg"]=amos_telnet["tgc"]=amos_telnet["tgd"]=amos_telnet["tgr"]=amos_telnet["tgcr"]=amos_telnet["tgdr"]=1
	amos_telnet["edit"]=amos_telnet["fcleand"]=amos_telnet["fcleanf"]=amos_telnet["fcleanff"]=1
	amos_telnet["sql+"]=amos_telnet["sql-"]=1
	amos_telnet["reload"]=1
}
function analyze_command(co,  result)
{
	result=0
	if (co in amos_blocked)
	{
		if (amos_status["blocked"] != 1) customPrint(amos_status["blocked"])
		else result=1
	}
	else if (co in amos_write)
	{
		if (amos_status["write"] != 1) customPrint(amos_status["write"])
		else result=1
	}
	else if (co in amos_telnet)
	{
		if (amos_status["telnet"] != 1) customPrint(amos_status["telnet"])
		else result=1
	}
	else
	{
		if (amos_status["read"] != 1) customPrint(amos_status["read"])
		else result=1
	}
	return result
}
function make_amosLog_table()
{
	empty_amoscomlog_buffer()
	if (fileOps("test -s "tempamoscomlog)!=0) return
	while ((getline < tempamoscomlog)>0)
	{
		amosLog[++amosCount]=$0
	}
	close(tempamoscomlog)
	fileOps("rm "tempamoscomlog)
}
function empty_amoscomlog_buffer(   i)
{
	tempamoscomlog=tempdir"/amoscomlog"
	for (i=1;i<=amosCount;i++) print amosLog[i] >> tempamoscomlog
	close(tempamoscomlog)
	delete amosLog
	amosCount=0
}
function log_amos(what,    i,theCommand,array,shortResult,longResult,line,resField,brray,dateTime)
{
	amosCount=0
	if (in_amos_mode() != 1) return
	if (amospermcommand!="permission") return
	make_amosLog_table()
	if (fileOps("test -s "templastamoscmd)==0)
	{
		getline line < templastamoscmd
		close(templastamoscmd)
		fileOps("rm "templastamoscmd)
		amosLog[++amosCount]=line
		if (what=="") amosLog[++amosCount]="Abnormal Exit"
	}
	if (amosCount < 1) return
	if (in_amos_sim())
	{
		print ""
		for (i=1;i<=amosCount;i++)
		{
			split(amosLog[i],array," ; <@%>Result=")
			shortResult=longResult=""
			#amos request broker does not like the brackets in the result info so we replace by curly brackets
			if (array[2] != "") { shortResult=gensub(/ *\(.*$/,"",1,array[2]) ; longResult=" ; Result="gensub(/\(/,"{","g",gensub(/\)/,"}","g",array[2])) }
			else
			{
				#if there is no result field
				if (amosLog[amosCount]=="Abnormal Exit" && (i==amosCount || i==(amosCount-1))) shortResult="?"
			}
			if (shortResult=="?") resField=""
			else if (shortResult!="") resField="Result="shortResult
			else resField="Result=OK"
			theCommand=sprintf("log %s%s was executed on %s (%s). %s",array[1],longResult,node_address,node,resField)
			#theCommand=sprintf("log %s was executed on %s (%s). Result=%s",amosLog[i],nodeIPAddress,nodeName,(result==1?"OK":"Fail"))
			if (amos_debug>=2) print "\nAMOSRequestCommand : "theCommand
		}
		return
	}
	if (amos_debug>=2) print "\n"AMOSRequestBroker
	if (amos_ssu(AMOSRequestBroker) == 1)
	{
		return
	}
	tid(1)
	while (AMOSRequestBroker |& getline)
	{
		gsub("\r","")
		if (amos_debug>=2 && NF>0) print $0
		if (/AMOSRequestBroker Enter Command : /)
		{
			tid(2)
			AMOSStarted = 1
			break
		}
	}
	if (AMOSStarted != 1)
	{
		close(AMOSRequestBroker)
		return
	}
	theCommand="log User "moshellUSER" has permission "amos_perm_list
	if (amos_debug>=2) print "\nAMOSRequestCommand : "theCommand
	print theCommand |& AMOSRequestBroker
	while (AMOSRequestBroker |& getline)
	{
		if (amos_debug>=2 && NF>0) print $0
		if (/AMOSRequestBroker Enter Command : /)
		{
			AMOSStarted = 2
			break
		}
	}
	if (AMOSStarted != 2)
	{
		close(AMOSRequestBroker)
		return
	}
	for (i=1;i<=amosCount;i++)
	{
		#if (amos_debug==2) print "DEBUG: amosLog["i"]="amosLog[i]
		match(amosLog[i],/ ; <@%>DateTime=([^ ]+)/,brray)
		if (brray[1]!="")
		{
			dateTime=" ; DateTime="brray[1]
			sub(/ ; <@%>DateTime=[^ ]+/,"",amosLog[i])
		}
		split(amosLog[i],array," ; <@%>Result=")
		shortResult=longResult=""
		#amos request broker does not like the brackets in the result info so we replace by curly brackets
		if (array[2] != "") { shortResult=gensub(/ *\(.*$/,"",1,array[2]) ; longResult=" ; Result="gensub(/\(/,"{","g",gensub(/\)/,"}","g",array[2])) }
		theCommand=sprintf("log %s%s%s was executed on %s (%s). Result=%s",array[1],dateTime,longResult,node_address,node,(shortResult!=""?shortResult:"OK"))
		#theCommand=sprintf("log %s was executed on %s (%s). Result=%s",amosLog[i],nodeIPAddress,nodeName,(result==1?"OK":"Fail"))
		#HV54965 : remove nbsp spaces
		gsub("\xa0"," ",theCommand)
		if (amos_debug>=2) print "\nAMOSRequestCommand : "theCommand
		print theCommand |& AMOSRequestBroker
		while (AMOSRequestBroker |& getline)
		{
			if (amos_debug>=2 && NF>0) print $0
			if (/AMOSRequestBroker Enter Command : /) break
		}
	}
	theCommand="stop"
	if (amos_debug>=2) print "\nAMOSRequestCommand : "theCommand
	print theCommand |& AMOSRequestBroker
	while (AMOSRequestBroker |& getline) { if (amos_debug>=2 && NF>0) print $0 }
	close(AMOSRequestBroker)
	AMOSStarted=0
}
function in_amos_sim()
{
	if (amos_debug==999 && os=="cygwin") return 1
	else return 0
}
function find_listme(   lme,i,j)
{
	if (listme!="") return
	lme[++i]="/opt/ERICddc/util/bin/listme"
	lme[++i]="/opt/ericsson/ddc/util/bin/listme"
	lme[++i]="/opt/ericsson/doss/util/bin/listme"
	for (j=1;j<=i;j++)
	{
		if (fileOps("test -s "lme[j])==0)
		{
			listme=lme[j]
			return
		}
	}
}
function amos_flush_logs(   old_dollar0)
{
	if (amos_log_interval==0) return
	if ((systime() - amos_last_flush) < (amos_log_interval*60)) return
	old_dollar0=$0
	log_amos("flush")
	$0=old_dollar0
	amos_last_flush=systime()
	delete amosLog
	amosCount=0
}
#######################  END OF AMOS FUNCTIONALITY ########################
function make_fullbd(shortbd,   res)
{
	#0005: => 000500
	#0005D01: => 000500/d00001
	res=shortbd
	sub(/D01:$/,"00/d00001",res)
	sub(/:$/,"00",res)
	return res
}
function check_sa_validity(what,nmfile,   ssl_session,ssl_info,array,endDate,tz,datecmd,currDate,restrans,res)
{
	if (what=="nm")
	{
		if (nmfile=="") nmfile=nm_credential
		ssl_session=sprintf("(%s '{gsub(/<[^>]+>/,\"\");print}' %s | %s x509 -enddate -noout) 2>&1",gawk,nmfile,openssl)
	}
	else ssl_session="("openssl" pkcs12 -nokeys -nomacver -clcerts -in "sa_credential" -password pass:"sa_password" | "openssl" x509 -noout -subject -dates) 2>&1"
	while ((ssl_session |& getline)>0)
	{
		ssl_info=ssl_info" "$0
		#notAfter=Feb 27 09:58:34 2015 GMT
		if (/notAfter=/)
		{
			sub(/^[^=]+=/,"",$0)
			split($0,array," ")
			endDate=make_timestamp(sprintf("%s-%s-%s",array[4],mm[array[1]],array[2]),array[3])
			tz=array[5]
		}
	}
	close(ssl_session)
	if (endDate=="") ssl_info=ssl_info"\nERROR: unable to decode the credential"
	else
	{
		res=1
		datecmd="TZ="tz" date +\"%Y %m %d %H %M %S\""
		datecmd |& getline currDate ; close(datecmd)
		#print "currDate: "mystrftime("%Y-%m-%d %H:%M:%S",mymktime(currDate))" "tz" - endDate:  "mystrftime("%Y-%m-%d %H:%M:%S",endDate)" "tz
		if (mymktime(currDate) > endDate)
		{
			ssl_info=ssl_info"\nERROR: the credential is expired " #(currDate: "mystrftime("%Y-%m-%d %H:%M:%S",mymktime(currDate))" "tz" - endDate:  "mystrftime("%Y-%m-%d %H:%M:%S",endDate)" "tz")
		}
	}
	return ssl_info
}
function check_openssl_version(    res,ssl_session)
{
	res=0
	ssl_session=sprintf("%s version 2>&1",openssl)
	while ((ssl_session |& getline)>0)
	{
		gsub("\r","") ; gsub("\x00","")
		#OpenSSL 0.9.7d 17 Mar 2004 (+ security fixes for: CVE-2005-2969 CVE-2006-2937 CVE-2006-2940 CVE-2006-3738 CVE-2006-4339 CVE-2006-4343 CVE-2006-7250 CVE-2007-5135 CVE-2007-3108 CVE-2008-5077 CVE-2008-7270 CVE-2009-0590 CVE-2009-2409 CVE-2009-3555 CVE-2010-4180 CVE-2011-4576 CVE-2011-4619 CVE-2012-0884 CVE-2012-1165 CVE-2012-2110 CVE-2012-2131 CVE-2012-2333 CVE-2013-0166 CVE-2013-0169)
		#OpenSSL 1.0.1g 7 Apr 2014
		if ($1=="OpenSSL") res=$2
	}
	close(ssl_session)
	return res
}
function makeColiMap(  k,i,sudocmd)
{
	delete coliMapList
	delete coliMapTable
	coliMapFilter=""
	coliMapN=0

	#in coliMapList table we put the commands that can be automatically translated by cmd() and lh()
	coliMapList[++k]="shell -f"
	coliMapList[++k]="ls -al"
	coliMapList[++k]="ls -la"
	coliMapList[++k]="ls -l"
	#coliMapList[++k]="readclock"
	if (node !~ /^OFFLINE/) coliMapList[++k]="?"
	coliMapList[++k]="rmdir -f"
	coliMapList[++k]="vols"
	coliMapList[++k]="rcmd"
	coliMapList[++k]="ifconfig -X"
	coliMapList[++k]="ps -w"
	coliMapList[++k]="cat"
	coliMapList[++k]="listloaded"
	coliMapList[++k]="ts"
	coliMapList[++k]="xbsh"
	coliMapList[++k]="journalctl"
	coliMapList[++k]="rm -f"
	coliMapList[++k]="rm"
	coliMapList[++k]="who"

	coliMapN=k

	coliMapFilter="^("
	for (i=1;i<=k;i++) coliMapFilter=coliMapFilter coliMapList[i] "|"
	coliMapFilter=gensub(/\|$/,"",1,coliMapFilter)")( |$)"

	#Allowed OAM user commands for sudo: who, formathd, listloaded, tcpdump, ts, bootping, ping, psql, ifconfig, route
	sudocmd="sudo "
	if (is_oam_user==1 || no_access_to_os==1) sudocmd=""

	#handling of backslash: when sending the command directly to core MP there is no need for backslash in front of quotes
	#but when sending the command via lhsh there must be a backslash in front of quotes
	#therefore we put by default a backslash in front of the quote and it will be removed if the command is sent directly without lhsh
	coliMapTable["shell -f"]=(no_access_to_os==1?"shell -f":"bash -l") #"sh -f"
	#coliMapTable["readclock"]="date -u +\\\"Date: %Y-%m-%d Time: %H:%M:%S\\\""
	coliMapTable["ls -l"]="ls -lGg --time-style=\\\"+%d %b %Y %H:%M:%S\\\""
	coliMapTable["ls -al"]=coliMapTable["ls -la"]="ls -alGg --time-style=\\\"+%d %b %Y %H:%M:%S\\\""
	if (have_sqlc==1)
	{
		coliMapTable["sql"]=coliMapTable["sqlc"]="sqlc"
		coliMapTable["exit;"]="exit;"
	}
	else
	{
		coliMapTable["sql"]=coliMapTable["sqlc"]="sudo psql -U postgres --pset pager=off -q"
		coliMapTable["exit;"]="\\q"
	}
	coliMapTable["include"]="\\i"
	coliMapTable["select * from tables"]=coliMapTable["select name from tables where persistence=TRUE"]="\\dt"
	if (node !~ /^OFFLINE/) coliMapTable["?"]="clihelp"
	coliMapTable["rmdir -f"]=sudocmd "rmdir"
	coliMapTable["vols"]="df -h"
	coliMapTable["rcmd"]="lhsh"
	coliMapTable["ifconfig -X"]="ifconfig"
	coliMapTable["ps -w"]="ps -ef"
	coliMapTable["cat"]=sudocmd "cat"
	coliMapTable["listloaded"]="sudo listloaded"
	coliMapTable["ts"]="sudo ts"
	coliMapTable["xbsh"]=sudocmd "xbsh"
	coliMapTable["journalctl"]="sudo journalctl"
	coliMapTable["rm -f"]=sudocmd "rm -f"
	coliMapTable["rm"]=sudocmd "rm -f"
	coliMapTable["who"]="sudo who"
}
function replaceColi(command,bdtype,direct,   j,a,pref,n)
{
	if (cpplinux!=1) return command
	#if (bdtype !~ /^($|EPB2)/) return command
	if (bdtype ~ "XB") return command  #SMXB
	#makeColiMap()  -> not needed, done at the beginning of prog.awk
	if (command ~ /^lhsh /)
	{
		n=split(command,a," ")
		if (n<3) return command
		pref=a[1]" "a[2]
		sub(/^[ \t]*[^ \t]+[ \t]+[^ \t]+[ \t]+/,"",command)
	}
 	if (command ~ coliMapFilter)
	{
		for (j=1;j<=coliMapN;j++)
		{
			if (command == coliMapList[j] || command ~ sprintf("^%s( |$)",coliMapList[j]))
			{
				sub(coliMapList[j],coliMapTable[coliMapList[j]],command)
				if (direct=="direct" || node_address ~ /^OFFLINE_/) gsub(/[\\]["]/,"\"",command)   #if the command will be sent directly to central MP then no need to put backslash in front of quotes
				break
			}
		}
	}
	#if (command ~ /^(cat|listloaded|ts|xbsh)( |$)/) command="sudo "command
	if (command ~ /^(sudo[ \t]+)?(te|ts)[ \t]+(save|default|enable|disable|e|d)[ \t]+[*]/) sub(/[*]/,(direct==""?"\\\\*":"\\*"),command)
	if (pref!="") command=pref" "command
	return command
}

function coliMap(command,direct,   res)
{
	makeColiMap()
	res=command
	if (cpplinux==1 && command in coliMapTable && coliMapTable[command]!="")
	{
		res=coliMapTable[command]
		if (direct==1) gsub(/[\\]/,"",res)  #needed when we are not running the command via lhsh and the command contains some backslash signs , eg ls / readclock
		if (mosdebug==1) print "coliMap "bdtype" "command" -> "res
	}
	return res
}
function load_file(what,file)
{
	if (file=="")
	{
		Display_help("lf")
		return
	}
	if (fileOps("test -s "file)!=0)
	{
		customPrint("ERROR: file "file" not found.")
		return
	}
	if (what ~ "c") load_coli_file(file)
	else parse_user_variables(file)
}
function make_readanswer()
{
	if (readanswer=="") readanswer=sprintf("%s/readanswer%s",tempdir,gawk_pid)
	close(readanswer)
	printf("#!%s -fp\nTERM=xterm\nINPUTRC=%s\nread %s -r -t %s\nif [[ ${REPLY+x} && $? = 0 ]] ; then echo \"$REPLY\" ; else echo TIMEOUT ; fi\n",bash,inputrc,(mosdebug~/^999?$/?"-n 2048":"-e"),inactivity_timeout) > readanswer
	close(readanswer)
	chmod(00755,readanswer)
	return readanswer
}
function make_readsilent()
{
	if (readsilent=="") readsilent=sprintf("%s/readsilent%s",tempdir,gawk_pid)
	close(readsilent)
	printf("#!%s -fp\nTERM=xterm\nINPUTRC=%s\nread %s -r -s -t %s\nif [[ ${REPLY+x} && $? = 0 ]] ; then echo \"$REPLY\" ; else echo TIMEOUT ; fi\n",bash,inputrc,(mosdebug~/^999?$/?"-n 2048":"-e"),inactivity_timeout) > readsilent
	close(readsilent)
	chmod(00755,readsilent)
	return readsilent
}
function make_readprompt(theprompt,thetimeout,theinputrc)
{
	thetimeout+=0
	if (thetimeout==0) thetimeout=inactivity_timeout
	if (theprompt ~ /\\n/) theprompt=sprintf("`echo -e '%s'`",theprompt)
	if (readprompt=="") readprompt=sprintf("%s/readprompt%s",tempdir,gawk_pid)
	close(readprompt)
	printf("#!%s -fp\nTERM=xterm\n%sread %s -r -t %s -p \"%s\"\nif [[ ${REPLY+x} && $? = 0 ]] ; then echo \"$REPLY\" ; else echo TIMEOUT ; fi\n",bash,\
(theinputrc!=""?sprintf("INPUTRC=%s\n",inputrc):"INPUTRC=xYZaBcDe12\n"),(mosdebug~/^999?$/?"-n 2048":"-e"),thetimeout,theprompt) > readprompt
	close(readprompt)
	chmod(00755,readprompt)
	return readprompt
}
function make_readpromptsilent(theprompt,thetimeout)
{
	thetimeout+=0
	if (thetimeout==0) thetimeout=inactivity_timeout
	if (theprompt ~ /\\n/) theprompt=sprintf("`echo -e '%s'`",theprompt)
	if (readpromptsilent=="") readpromptsilent=sprintf("%s/readpromptsilent%s",tempdir,gawk_pid)
	close(readpromptsilent)
	printf("#!%s -fp\nTERM=xterm\nINPUTRC=%s\nread %s -r -s -t %s -p \"%s\"\nif [[ ${REPLY+x} && $? = 0 ]] ; then echo \"$REPLY\" ; else echo TIMEOUT ; fi\n",bash,inputrc,(mosdebug~/^999?$/?"-n 2048":"-e"),thetimeout,theprompt) > readpromptsilent
	close(readpromptsilent)
	chmod(00755,readpromptsilent)
	return readpromptsilent
}
function sortportdev(port_dev_list,sorted_port_dev_list,    buffer_port_list,i,j,array,n)
{
	#port_xcu_dev_10
	#port_xcu_dev_10/port_0_dev_12
	#port_xcu_dev_10/port_2_dev_14
	#port_xcu_dev_10/port_4_dev_16
	#port_xcu_dev_11
	#port_xcu_dev_11/port_0_dev_13
	#port_xcu_dev_11/port_2_dev_15
	#port_xcu_dev_11/port_4_dev_17
	delete sorted_port_dev_list
	delete buffer_port_list
	delete array
	for (i in port_dev_list)
	{
		if (i ~ /port_[0-9]+_dev_[0-9]+$/)
		{
			split(gensub(/^.*port_/,"",1,i),array,"_")
			j=sprintf("%s_%09d_dev_%09d",gensub(/_[0-9]+_dev_[0-9]+$/,"",1,i),array[1]+0,array[3]+0)
		}
		else j=i
		buffer_port_list[j]=j
	}
	n=asort(buffer_port_list)
	for (i=1;i<=n;i++)
	{
		if (buffer_port_list[i] ~ /port_00000/)
		{
			sub(/port_000000+_dev_/,"port_0_dev_",buffer_port_list[i])
			sub(/_dev_000000+$/,"_dev_0",buffer_port_list[i])
			sub(/port_00000+/,"port_",buffer_port_list[i])
			sub(/dev_00000+/,"dev_",buffer_port_list[i])
		}
		sorted_port_dev_list[i]=buffer_port_list[i]
	}
	return n
}
function size_to_h(size,precision, unit)
{
	#convert bytes to KB, MB, GB, TB
	unit="B"
	if (size >= 1024) { size=size/1024 ; unit="K" }
	if (size >= 1024) { size=size/1024 ; unit="M" }
	if (size >= 1024) { size=size/1024 ; unit="G" }
	if (size >= 1024) { size=size/1024 ; unit="T" }
	if (precision=="int") return sprintf("%.0f%1s",size,unit)
	else return sprintf("%5.1f%1s",size,unit)
}
function h_to_size(size)
{
	if (size ~ /^[0-9]+B?$/) return size
	if (size ~ /^[0-9]+K$/) return gensub(/K/,"",1,size)*1024
	if (size ~ /^[0-9]+M$/) return gensub(/M/,"",1,size)*1024*1024
	if (size ~ /^[0-9]+G$/) return gensub(/G/,"",1,size)*1024*1024*1024
	if (size ~ /^[0-9]+T$/) return gensub(/T/,"",1,size)*1024*1024*1024*1024
}
function gv(what,    command,i,j,nr_scalar_vars,nr_hashtables,nr_elems,Filter,neg,symtabName,isymtabName,iFilter,ok,tot_nr_elems,output,scalar_size,scalar_line,last,array,Value,tab,ind,varName,tableName,tot_hash_size,hash_size)
{
	#gv[stoi] [<filter>]
	#-> filter: print only variables that match the filter
	#t: print only hashtables
	#s: print only scalar variables
	#o: print only overview -> number of variables that match the filter
	#i: case insensitive matching
	#m: modify a variable  : gvm <var> <value>
	#                        gvm myvar myval
	#                        gvm table[i]  myval
	#d: delete a table

	#it is possible to save a scalar variable to a moshell scripting variable, eg:
	# gvs ^logging$ > $logging

	#gvc <command>
	#to show the global variables created after the command has been run - does not work yet

	if (what=="d")
	{
		tableName=$2
		for (i in SYMTAB)
		{
			if (isarray(SYMTAB[i]))
			{
				if (tableName==sprintf("%s",i))
				{
					del_array(SYMTAB[i])
					break
				}
			}
		}
		return
	}

	if ($3 == ">" && NF == 4 && $4 ~ /^\$/) varName = $4;

	if (what=="c")
	{
		sub(/^[ \t]*/,"") ; command=gensub($1,"",1,$0) ; sub(/^[ \t]*/,"",command)
		$0=command
		Run_command()
		return
	}

	nr_hashtables=0
	nr_scalar_vars=0
	neg=0
	nr_elems=0
	tot_nr_elems=0
	hash_size=0
	tot_hash_size=0
	scalar_size=0
	Filter=$2
	if (NF>2) Value=gensub(/^[ \t]*[^ \t]+[ \t]+[^ \t]+[ \t]+|[ \t]+$/,"","g",$0) ; else Value=""
	if (what~"m")
	{
		if (Filter !~ /\[/) 
		{
			if (Filter in SYMTAB) SYMTAB[Filter]=Value  #scalar variable
			else { customPrint("\nNo such variable: "Filter) ; return }
		}
		else
		{
			#table entry
			split(Filter,array,/\[/)
			tab=array[1]
			ind=gensub(/.$/,"",1,array[2])
			#print tab,ind,Value,SYMTAB[tab][ind]
			SYMTAB[tab][ind]=Value
		}
		customPrint(sprintf("\nThe variable %s has been set to: %s",Filter,Value))
		return
	}
	iFilter=tolower(Filter)
	if (Filter ~ /^!/) { neg=1 ; sub(/^!/,"",Filter) }
	if (what!~"t" && what!~"s") what=what "ts"
	#First print the hashtables
	if (what~"t")
	{
		if (what~"o") customPrint(sprintf("%15s  %10s  %10s  %s","Bytes","NrEntries","Size","TableName"))
		for (i in SYMTAB)
		{
			if (isarray(SYMTAB[i]))
			{
				ok=0
				symtabName=sprintf("%s",i)
				isymtabName=tolower(symtabName)
				if ((what~"i")&&((neg==0 && isymtabName~iFilter) || (neg==1 && isymtabName!~iFilter)))ok=1
				if ((what!~"i")&&((neg==0 && symtabName~Filter) || (neg==1 && symtabName!~Filter)))ok=1
				if (ok==1)
				{
					nr_elems=0
					hash_size=0
					for (j in SYMTAB[i])
					{
						nr_elems++
						tot_nr_elems++
						if (!(isarray(SYMTAB[i][j])))
						{
							hash_size+=length(j)+length(SYMTAB[i][j])+256   #+128
						}
					}
					tot_hash_size+=hash_size
					nr_hashtables++
					if (what~"o") output=(sprintf("%s\n%15d  %10s  %10s  %s",output,hash_size,nr_elems,size_to_h(hash_size),symtabName))
					else walk_array(SYMTAB[i],symtabName)
				}
			}
		}
	}
	if (what~"s")
	{
		#Then the scalar variables.
		#Note: if there are some unitialised global hashtables they will be printed here as scalar, then gawk will crash later when they are used as hashtables
		#Therefore all global hashtables should be initialised at the beginning of gawk execution
		for (i in SYMTAB)
		{
			if (!(isarray(SYMTAB[i])))
			{
				ok=0
				symtabName=sprintf("%s",i)
				isymtabName=tolower(symtabName)
				if ((what~"i")&&((neg==0 && isymtabName~iFilter) || (neg==1 && isymtabName!~iFilter)))ok=1
				if ((what!~"i")&&((neg==0 && symtabName~Filter) || (neg==1 && symtabName!~Filter)))ok=1
				if (ok==1)
				{
					#WARNING: this line can cause subsequent commands to crash if the commands calls an array that has been printed as a scalar here
					if (what!~"o") customPrint(sprintf("%s = %s",i,SYMTAB[i]))
					if (varName != "")
					{
						assignCustomVar(varName,sprintf("%s",SYMTAB[i]),"print")
						return
					}
					nr_scalar_vars++
					scalar_size+=length(i)+length(SYMTAB[i])+128
				}
			}
		}
		scalar_line="\nTotal: "nr_scalar_vars" scalar variables, "size_to_h(scalar_size)" in size."
	}
	if (what~"s" && what!~"o") customPrint(scalar_line)
	if (what~"t")
	{
		if (what~"o")
		{
			last=split(gensub(/^\n/,"",1,output),array,"\n")
			last=asort(array)
			for(i=1;i<=last;i++) customPrint(array[i])
		}
		customPrint("\nTotal: "nr_hashtables" hash tables, "tot_nr_elems" entries, "size_to_h(tot_hash_size)" in size.")
	}
	if (what~"s" && what~"o") customPrint(scalar_line)
}
function walk_array(arr,name,      i)
{
	for (i in arr)
	{
		if (isarray(arr[i])) walk_array(arr[i],(name"["i"]"))
		else customPrint(sprintf("%s[%s] = %s",name,gensub(SUBSEP,",","g",i),gensub(/\n/,"<CR>","g",arr[i])))
	}
}
function del_array(arr)
{
	delete arr
}
function mysort(inputTable,destinationTable,hasDestinationTable,   res,tabIndex)
{
	#use this when the table is not properly sorted by alphabetical order.
	#Can happen for tables that contain a mix of numbers and strings, it may try to sort numerically
	#this function every element to be a string first, then does the sort
	#the problem with "asort()" has started to happen with gawk 4.
	#Compare with sorting order in gawk 3.1.7 (moshell 9.0c) for reference to see how it should be
	for (tabIndex in inputTable) inputTable[tabIndex]=inputTable[tabIndex] ""
	if (hasDestinationTable!="") res=asort(inputTable,destinationTable)
	else res=asort(inputTable)
	return res
}
function mystrftime(arg1,arg2,arg3)
{
	#needed due to change in gawk 4.0.1, strftime now returns a fatal error when arg2 is negative
	#now in gawk 4.1.1 negative arg2 is allowed again
	#if (arg2 < 0) arg2=0
	return strftime(arg1,arg2,arg3)
}
function mymktime(arg,    array)
{
	#needed for cygwin version 1.7.19 and above where the mymktime function hangs for 30 seconds if the year is 0
	split(arg,array," ")
	if ((array[1]+0)==0) arg="1970 01 01 00 00 00"
	return mktime(arg)
}

function setUSER(  result)
{
	if ("USER" in ENVIRON && ENVIRON["USER"]!="") return ENVIRON["USER"]
	"whoami" | getline result ; close("whoami")
	if (result ~ /^[^ ]+$/)
	{
		sub("\r","",result)
		ENVIRON["USER"]=result
		return result
	}
	return "unknownuser"
}
function setUID(  result,idprog,idsession)
{
	if ("UID" in ENVIRON && ENVIRON["UID"]!="") return ENVIRON["UID"]
	if (os ~ /^sun/) idprog="/usr/xpg4/bin/id"
	else idprog="id"
	idsession=idprog" -u "ENVIRON["USER"]
	idsession | getline result ; close(idsession)
	if (result ~ /^[^ ]+$/)
	{
		sub("\r","",result)
		ENVIRON["UID"]=result
		return result
	}
	return "unknownuser"
}
function loadFilefuncs()
{
	os=check_os()

	#gawk 4.1.0 limitations
	#use_netcatlib=0
	if (os=="sunsparc") use_scandir=0

	#remove the dot sign at the end of moshelldir. Gets there if we start moshell with ./moshell
	#otherwise the limited version (unr=3) does not work well
	if (moshelldir ~ /\/\.($|\/)/) sub(/\/\.($|\/)/,"/",moshelldir)
	if (unr == 3) commonjardir="/moshellroot/commonjars" ; else commonjardir=moshelldir"/commonjars"
	#if (os == "cygwin")
	#{
	#	filefuncs=make_cygpath(commonjardir"/lib/file.dll")
	#	netcatlib=make_cygpath(commonjardir"/lib/netcat.dll")
	#}
	#else if (os == "linux")
	#{
	#	filefuncs=commonjardir"/lib/file.so.linux"
	#	netcatlib=commonjardir"/lib/netcat.so.linux"
	#}
	#else if (os == "sunsparc")
	#{
	#	filefuncs=commonjardir"/lib/file.so.solaris"
	#	netcatlib=commonjardir"/lib/netcat.so.solaris"
	#}
	#else if (os == "sun86")
	#{
	#	filefuncs=commonjardir"/lib/file.so.sol86"
	#	netcatlib=commonjardir"/lib/netcat.so.sol86"
	#}
 	#extension(filefuncs, "dlload")
 	#extension(netcatlib, "dlload")
	moshell=make_cygpath(moshelldir"/moshell")
	sitefiledir=moshelldir"/sitefiles"
}
function customPrint(output,undomode,force,noLF,logOnly,   tempoutput)
{
	if (logOnly=="")
	{
		if (muteLog != "mute" || force != "")
		{
			if (noLF != "" && output !~ "%") printf output   #the % sign together with certain letters/numbers crashes the printf command but not the print command
			else print output
		}
		else if (muteFactor > 100) #(muteFactor <0) #
		{
			muteCount++
			if ((100*muteCount-muteFactor) >= 0)
			{
				printf "."
				muteCount=0
			}
		}
		else if (muteFactor > 1)
		{
			muteCount++
			if (muteCount%muteFactor==0)
			{
				printf "."
				muteCount=0
			}
		}
		else printf "."
	}
	if (logging == 1)
	{
		tempoutput=gensub(/\33\[(1;)?(3.|0)m|\(lmid: .*$/,"","g",output)
		if (noLF != "" && output !~ "%") printf tempoutput >> logfile #the % sign together with certain letters/numbers crashes the printf command but not the print command
		else print tempoutput >> logfile
		#close(logfile)   #Becomes very slow if the logfile is closed all the time
	}
	if (undomode >= 1)
	{
		print output >> undoLogfile
		#close(undoLogfile) #Becomes very slow if the logfile is closed all the time
	}
}
function show_progress(howoften,nodots)
{
	if (mosdebug==1) { print "DEBUG: "$0 ; return }
	if (nodots=="nodots") return
	progressCounter++
	if (progressCounter % howoften == 0) printf "."
}
function getTodayUTC(   date,result,datecmd)
{
	#to get todays date in UTC time
	datecmd="date -u +\"%Y %m %d %H %M %S\""
	datecmd | getline date
	close (datecmd)
	result=mymktime(date)
	if (mosdebug==1) print "getTodayUTC: "date,"result="result" ("strftime("%Y%m%d %H:%M:%S",result)")"
	return result
}
function assignCustomVar(var,value,printvar,varOption,  origval)
{
	if (var=="$password" && value != "")
	{
		origval=value
		value=b64Dec(value)
		preliminary_node_password=value
	}
	customVar[var]=value
	makeSortedVarTable()
	if (var ~ /\[/) customVarTableList[gensub(/\[.*$/,"",1,var)]=1
	if (printvar=="print") customPrint(sprintf("\n%s = %s",var,(var=="$password"?origval:customVar[var])))
	if      (varOption=="system") systemVar[var]=1
	else if (varOption=="global") globalVar[var]=1
}
function makeSortedVarTable(   j,max,last,i,k,lengthTable,array)
{
	#reinitialise the table
	delete sortedVar
	#Put the variable names in a table in order from the longest to the shortest to help the check_for_var function
	for (j in customVar)
	{
		lengthTable[length(j)]=sprintf("%s%s%s",lengthTable[length(j)],j,SUBSEP)
	}
	#lengthTable[4]=$var@$xyz@$t[2] #all variables containing 4 characters
	for (j in lengthTable)
	{
		if (j+0 > max) max=j+0    #otherwise it doesnt realize that j is an integer
	}
	for (j=max;j>1;j--)
	{
		last=split(lengthTable[j],array,SUBSEP)
		for (i=1;i<last;i++)
		{
			sortedVar[++k]=array[i]
		}
	}
	sortedVarMax=k
	#for (i=1;i<=k;i++) print sortedVar[i],customVar[sortedVar[i]]
}
function printDir(thisDir,thisDirProps,lnh,showlmid,filesOnly,norecursive,reverse,viasftp,dirsOnly,filePrefix,viaftps,errList,    dirList,line,output,outputTable,i,n,array,timestamp,date,dd,mo,yy,tt,size,ok,notok,currmd,l,lineCount,b)
{
	lineCount=0
	if (filesOnly=="") customPrint("")
	if (cpplinux==1) thisDir=thisDir"/"
	gsub(/[/]+/,"/",thisDir) #always replace multiple consecutive slashes with only one
	delete outputTable
	#if (thisDir ~ /^\/c\/pmd$/ && filesOnly != "") { dumplista() ; return }
	if (lnh ~ /^[0-9]+00$/) print "lhsh "lnh" "coliMap("ls -al")" "thisDir |& ftree_session
	#we use option "-na" instead of "-la" otherwise it hangs sftp on large listings
	#also we go inside the directory in order to reduce the amount of text produced by the printout since otherwise some text can get discarded or printout hanging
	else if (viaftps==1){}
	else if (viasftp==1)
	{
		#print "ls -nar "thisDir |& ftree_session
		print "cd "thisDir"\npwd" |& ftree_session
		while ((ftree_session |& getline line)>0)
		{
			$0=line
			gsub("\r","") ; gsub("\x00","")
			if (comcli>0) remove_colors()
			if (mosdebug==1) print "DEBUG: "$0
			if (/Connection closed by foreign host.|Connection to [^ ]* closed/ || (/(^|[^"])EndOfPrint/)) break
			if (/Couldn.t canonicalize: No such file or directory/) notok=1
			if (/Remote working directory: /)
			{
				#this check removed because on pico, when we do "cd" to the directory, the pwd can show a different directory name
				#if ($NF==thisDir) ok=1
				#DEBUG: sftp> cd /opt/com/comea/internalFiles/PerformanceManagementReportFiles
				#DEBUG: sftp> pwd
				#DEBUG: Remote working directory: /mnt/app/persistent/log/oss/pm/PerformanceManagementReportFiles
				if (notok!=1) ok=1
				break
			}
		}
	}
	else print coliMap("ls -al",1)" " thisDir |& ftree_session
	if (mosdebug==1) print "DEBUG: viasftp="viasftp
	if (viaftps==1){}
	else if (viasftp==1)
	{
		if (ok==1) print "ls -nar" |& ftree_session
		#print "lpwd" |& ftree_session
		print "hello" |& ftree_session
	}
	else
	{
		#delay needed to avoid spurious characters in printout due to echo command
		if (secure_shell==0) usleep(400000) ; else usleep(300000)
		print "echo \"EndOfPrint\"" |& ftree_session
	}
	output=sprintf("%-42s  %s%s",thisDirProps,filePrefix,gensub(/[/]+/,"/","g",thisDir"/"))
	if (showlmid != "") output=appendCXCtranslation(output,90)
	if (filesOnly == "") customPrint(output)
	if (viaftps==1)
	{
		old_ftree_session=ftree_session
		ftree_session=ftree_session gensub(/[/]+$/,"","g",thisDir) "/"
	}
	while ((ftree_session |& getline line)>0)
	{
		#we do a getline to "line" because otherwise, this part was crashing sometimes
		$0=line
		gsub("\r","") ; gsub("\x00","")
		if (comcli>0) remove_colors()

		#CPP:
		#drw-rw-rw-   2   512       5 Mar 2004 10:00:01 baseline
		#-rw-rw-rw-   0   1047765   4 Mar 2004 09:04:55 00002syslog

		#SFTP (comcli)
		#sftp> ls -na /var/permanent/log/oss
		#-rw-r--r--    0 0        0            4169 Nov 22 18:04 /var/persistent/log/oss/pm/PerformanceManagementReportFiles/A20131122.1645+0000-1700+0000_1.xml
		#NETSIM PICO:
		#-rw-r--r--    0 1000     1000        62255 May 20 14:00 /c/pm_data/A20140520.1400+0100-1415+0100_RNC108PRBS01.xml

		#Netsim sometimes has soft links , we ignore them
		#lrwxrwxrwx    0 1000     1000           53 Mar 15 00:15 A20170315.0015-0030_CellTrace_DUL1_3.bin.gz


		if (mosdebug==1) print
		if (/illegal command 'ls', status: Command not allowed/) errList[$0]=1
		if (/Connection closed by foreign host.|Connection to [^ ]* closed/ || (/(^|[^"])EndOfPrint/)) break
		if (viasftp==1)
		{
			if (/Local working directory: /) break
			if (/sftp> hello/) break
			#workaround for PICO folder causes hanging to the printout after about 270 files
			if (mom_version ~ /PRBS_NODE_MODEL_/) # && thisDir ~ /PerformanceManagementReportFiles/
			{
				lineCount++
				if (lineCount > 201) break
			}
			sub(/^\/.*\//,"",$NF)  #remove folder path in front of file name in sftp "ls -na" printout
		}
		if (/Timeout, server .* not responding./) { customPrint($0) ; break }
		if ($NF=="." || $NF=="..") continue
		if (!($1~/^[-dl]/&&NF>=8)) continue
		if (viasftp==1)
		{
			#the 8th word can be the year or the time
			mo=$6 ; dd=$7
			if ($8~/^[0-9][0-9][0-9][0-9]$/) { yy=$8 ; tt="00:00:00" }
			else
			{
				#-rw-r--r-- 1 1000 100 54597 Apr 26 9:45 A20180426.0930-0945_KISTP5169.xml.gz
				#-rw-r--r-- 1 1000 100 54592 Apr 26 10:0 A20180426.0945-1000_KISTP5169.xml.gz
				split($8,b,":")
				tt=sprintf("%02d:%02d:00",b[1],b[2])
				#need to guess the year
				currmd=strftime("%m-%d %H%M%S",systime()+3600)
				if (currmd >= sprintf("%02d-%02d %s",mm[mo],dd,tt)) yy=strftime("%Y",systime())
				else yy=strftime("%Y",systime())-1
			}
			date=sprintf("%s %s %s %s",dd,mo,yy,tt)
			timestamp=make_timestamp(sprintf("%s-%s-%s",yy,mm[mo],dd),tt)
			size=$5
		}
		else
		{
			#cpp
			date=sprintf("%s %s %s %s",$4,$5,$6,$7)
			timestamp=make_timestamp(sprintf("%s-%s-%s",$6,mm[$5],$4),$7)
			size=$3
		}
		if ((/^d/)||(/^l/ && comcli>0 && viasftp==1 && is_netsim!=1))  #follow links on COM nodes (but not NETSIM), in particular PICO where /oss folder contains links to other folders
		{
			sub(/\/$/,"")
			dirList[sprintf("%s/%s",thisDir,$NF)]=sprintf("%s/%s",thisDir,$NF)
			dirProps[sprintf("%s/%s",thisDir,$NF)]=sprintf("%-10s  %8s  %20s",$1,size,date)
			if (norecursive=="norecursive" && dirsOnly=="d") outputTable[++i]=sprintf("%-10s  %8s  %20s  %s%s/%s/",$1,size,date,filePrefix,thisDir,$NF)
		}
		else if (/^-/)
		{
			ftreeTotal["size"]+=size
			ftreeTotal["file"]++
			output=sprintf("%-10s  %8s  %20s  %-s",$1,size,date,sprintf("%s%s%s",filePrefix,gensub(/[/]+/,"/","g",thisDir"/"),$NF))
			if (comcli==0 && showlmid != "") output=appendCXCtranslation(output,90)
			outputTable[++i]=sprintf("%030s%s%s",timestamp,SUBSEP,output)
		}
	}
	ftreeTotal["dir"]++
	n=asort(outputTable)
	if (reverse=="reverse")
	{
		for (i=n;i>=1;i--)
		{
			split(outputTable[i],array,SUBSEP)
			if (dirsOnly=="" || norecursive=="norecursive") customPrint(array[2])   #files only printed with ftree/ftree1/ftreed
		}
	}
	else
	{
		for (i=1;i<=n;i++)
		{
			split(outputTable[i],array,SUBSEP)
			if (dirsOnly=="" || norecursive=="norecursive") customPrint(array[2])   #files only printed with ftree/ftree1/ftreed
		}
	}
	if (viaftps==1)
	{
		close(ftree_session)
		ftree_session=old_ftree_session
	}
	if (norecursive=="norecursive") return
	for (nextDir in dirList) printDir(nextDir,dirProps[nextDir],lnh,showlmid,filesOnly,norecursive,reverse,viasftp,dirsOnly,filePrefix,viaftps,errList)
}
function dumplista(    line,pmdfilelist,tmplhcmd,templocalfile,tmp_timestamp,n,i,nrOfPmdFiles,array,k,last,pmdDirs,ftree_session)
{
	templhcmd=sprintf("%s/lhCmd%s",tempdir,gawk_pid)
	fileOps("rm "templhcmd)
	ftree_session=enter_telnet_login(node_address,node_password)
	if (ftree_session ~ /Unable to connect|Wrong Password/)
	{
		customPrint(ftree_session)
		return
	}
	print "dump list -a" |& ftree_session
	#delay needed to avoid spurious characters in printout due to echo command
	if (secure_shell==0) usleep(400000) ; else usleep(300000)
	print "echo \"EndOfPrint\"" |& ftree_session
	while ((ftree_session |& getline line)>0)
	{
		#we do a getline to "line" because otherwise, this part was crashing sometimes
		$0=line
		gsub("\r","") ; gsub("\x00","")
		if (mosdebug==1) print "DEBUG: "$0

		#        0x8e   62736 2006-12-12  21:35:56.605771 appl    f0f0f0f2  /c/pmd/325/001200/0x0000008e.pmd
		#  0xa5a5a63a   66536 2007-04-13  08:18:01.968099 kernel  03000113  /c/pmd/672/011500/0xa5a5a63a.pmd
		#         0x4   53368 2009-05-05  01:39:12.334040 kernel  80000021  /c/pmd/430/120618/0x00000004.pmd
		#  0x80000026  217228 2013-07-18  12:17:34.228993 appl    f0f0f0f2  /rmd/work/rmd_2147483686_0x000103c5.pmd

		if (/(^|[^"])EndOfPrint$/) break
		if ($NF ~ /^\/c\/pmd\/|^\/rmd\/.*\.pmd$/)
		{
			tmp_timestamp=sprintf("%s%s",make_timestamp($3,gensub(/\..*$/,"",1,$4)),gensub(/^[^\.]+\./,".",1,$4))
			if (tmp_timestamp in pmdfilelist)
			{
				while (tmp_timestamp in pmdfilelist) tmp_timestamp=sprintf("%f",tmp_timestamp+0.01)
			}
			pmdfilelist[tmp_timestamp]=$NF
			pmdstamplist[tmp_timestamp]=tmp_timestamp
			nrOfPmdFiles++
		}
	}
	print "ls -l /c/pmd" |& ftree_session
	#delay needed to avoid spurious characters in printout due to echo command
	if (secure_shell==0) usleep(400000) ; else usleep(300000)
	print "echo \"EndOfPrint\"" |& ftree_session
	while ((ftree_session |& getline line)>0)
	{
		#we do a getline to "line" because otherwise, this part was crashing sometimes
		$0=line
		gsub("\r","") ; gsub("\x00","")
		if (mosdebug==1) print "DEBUG: "$0

		#-rw-rw-rw-   0     36364  14 May 2016 08:45:11 DataDump50Du01_160514_084510.bin
		if (/(^|[^"])EndOfPrint$/) break
		if ($1~/^-r/)
		{
			date=sprintf("%s %s %s %s",$4,$5,$6,$7)
			tmp_timestamp=sprintf("%s",make_timestamp(sprintf("%s-%s-%s",$6,mm[$5],$4),$7))  #,gensub(/^[^\.]+\./,"",1,$4)
			if (tmp_timestamp in pmdfilelist)
			{
				while (tmp_timestamp in pmdfilelist) tmp_timestamp=sprintf("%f",tmp_timestamp+0.01)
			}
			pmdfilelist[tmp_timestamp]="/c/pmd/"$NF
			pmdstamplist[tmp_timestamp]=tmp_timestamp
			nrOfPmdFiles++
		}
	}
	print "exit" |& ftree_session
	while ((ftree_session |& getline line)>0) {}
	close(ftree_session)
	n=asort(pmdstamplist)
	for (i=1;i<=n;i++)
	{
		#print "DEBUG:"i,pmdstamplist[i],pmdfilelist[pmdstamplist[i]]
		print coliMap("ls -al",1)" " pmdfilelist[pmdstamplist[i]] >> templhcmd
	}
	print "echo \"EndOfPrint\"" >> templhcmd
	close(templhcmd)
	if (n != nrOfPmdFiles) customPrint("WARNING: there are more PMD files than actually printed, report this bug to moshell support!")
	templocalfile=sprintf("%s/%s",nodetempdir,gensub(/^.*\//,"","g",templhcmd))
	if (ftpclient(node_address,node_password,sprintf("put %s %s",templhcmd,templocalfile),"","silent")==0)
	{
		ftree_session=enter_telnet_login(node_address,node_password)
		if (ftree_session ~ /Unable to connect|Wrong Password/)
		{
			customPrint(ftree_session)
			return
		}
		print coliMap("shell -f")" "templocalfile |& ftree_session
		while ((ftree_session |& getline line)>0)
		{
			#$ -rw-rw-rw-   0    118304  12 Jan 2018 11:55:21 /c/pmd/4/000100/0x00000062.pmd
			#-rw-rw-rw-   0    125880  15 Jun 2007 09:19:48 /c/pmd/390/001400/0x4b7a2cdc.pmd
			$0=line
			gsub("\r","") ; gsub("\x00","") ; gsub(/^([$] )+/,"") #;print
			if (mosdebug==1) print "DEBUG: "$0
			if (/(^|[^"])EndOfPrint$/) break
			else if (/[nN]ot enough credentials|[iI]llegal command 'shell'/)
			{
				#illegal command 'shell', status: Not enough credentials
				customPrint($0)
				break
			}
			else if (/^-/)
			{
				output=sprintf("%-10s  %-8s  %20s  %-s",$1,$3,sprintf("%s %s %s %s",$4,$5,$6,$7),$NF)
				customPrint(output)
				ftreeTotal["size"]+=$3
				ftreeTotal["file"]++
				split($NF,array,"/")
				pmdDirs[array[4]]=1
				pmdDirs[array[4]"/"array[5]]=1
			}
		}
		print "rm "templocalfile |& ftree_session
		print "exit" |& ftree_session
		while ((ftree_session |& getline line)>0) {}#print line}
		close(ftree_session)
	}
	ftreeTotal["dir"]=1
	for (k in pmdDirs) ftreeTotal["dir"]++
}
function empty_file(file)
{
	close(file)
	printf "" > file
	close(file)
}
function striplastchar(file,   last,i)
{
	while ((getline < file)>0) { last++ } ; close(file)
	while ((getline < file)>0)
	{
		i++
		if (i==1) print $0 > file".tmp"
		else if (i<last) print $0 >> file".tmp"
		else printf("%s",$0) >> file".tmp"
	}
	close(file) ; close(file".tmp")
	fileOps("mv "file".tmp "file)
}
function make_tlsflags(   tlsflags)
{
	tlsflags=""
	if (tls_debug==1) tlsflags="-msg -state -showcerts "
	else if (tls_debug==2) tlsflags="-msg -state -showcerts -debug "
	return tlsflags
}
function httpget(httpserver,srcfile,destfile,ior,silent,infotext,timeout,htport,htsec,htretry,    httpRetryCount,old_http_port,old_s_http_port,old_secure_http)
{
	if (htretry=="") htretry=http_retry
	#htsec can be: "http" or "https"
	if (htport~/^[1-9][0-9]+$/)
	{
		old_http_port=http_port
		old_s_http_port=s_http_port
		http_port=htport
		s_http_port=htport
	}
	if (htsec!="")
	{
		old_secure_http=secure_http
		if (htsec ~ "s") secure_http=1
		else secure_http=0
	}
	while (1)
	{
		httpRetryCount++
		result=sub_httpget(httpserver,srcfile,destfile,ior,silent,infotext,timeout)
		if ((result==0) || (httpRetryCount > htretry)) break
		#customPrint("HTTP connection failed, retrying in 1 s...")
		if (mosdebug==1) print "DEBUG: httpRetryCount="httpRetryCount", htretry="htretry
		wait_http(httpRetryCount)
	}
	if (old_http_port!="")
	{
		http_port=old_http_port
		s_http_port=old_s_http_port
	}
	if (old_secure_http!="") secure_http=old_secure_http
	return result
}
function sub_httpget(httpserver,srcfile,destfile,ior,silent,infotext,timeout,    start_printing,file_notfound,count,ht_error,line,ior_found,inheader,htcommand,hb,a,dd,theport,http_service,theserver,printTheInfo,tcurl)
{
	if (timeout == "") timeout=http_timeout
	#returns 0 for success and 1 for failure

	if (silent=="")
	{
		if (ior == "ior")
		{
			if (multi) customPrint(sprintf("Fetching IOR file from %s%s%s...",infotext,httpserver,(httpserver in nodeName?" ("nodeName[httpserver]")":"")),"","","noLF")
			else customPrint("Fetching IOR file...","","","noLF")
		}
		else customPrint(sprintf("Downloading File from http%s://%s%s to %s ...",(secure_http==1?"s":""),httpserver,srcfile,destfile),"","","noLF")
	}
	theport=http_port
	if (secure_http==1) theport=s_http_port
	if (check_ip_contact(httpserver,theport)!=0)
	{
		if (smart_http==1 && multi==1 && secure_http==0 && theport==http_port && infotext!="" && check_ip_contact(httpserver,s_http_port)==0 && check_ip_contact(httpserver,2023)!=0 && check_ip_contact(httpserver,9830)!=0 && check_ip_contact(httpserver,830)!=0)
		{
			#Special case when fetching IOR files in multimode, if one of nodes uses HTTPS we switch to HTTPS for the whole session
	 		declare_user_variable("secure_http=1",2)
	 		printTheInfo=1
	 	}
		else
		{
			customPrint(sprintf("Failed! Unable to connect to %s:%s.%s",httpserver,theport,(multi?"":"\n")))
			return 1
		}
	}
	if (secure_http==1)
	{
		tcurl=""
		if (use_curl>0 && is_rcs()==1) tcurl=find_curl()
		if (use_curl>0 && tcurl!="") http_service=sprintf("%s -k --silent --show-error --connect-timeout %d --max-time %d -o %s --noproxy %s https://%s:%d%s 2>&1",tcurl,timeout,timeout,destfile,httpserver,put_brackets(httpserver),s_http_port,srcfile)
		else http_service=sprintf("%s s_client %s-quiet -connect %s:%s -time_connection %s -time_session %s 2>&1 > \"%s\"",openssl,make_tlsflags(),put_brackets(httpserver),s_http_port,timeout,timeout,destfile)
	}
	else if (ipv6==1) http_service=sprintf("%s -t %s %s %s 2>&1 > \"%s\"",netcat,timeout,httpserver,http_port,destfile)
	else http_service=sprintf("%s -t %s -w \"%s\" %s:%s 2>&1",connect,timeout,destfile,httpserver,http_port)
	if (use_curl>0 && tcurl!="")
	{
		if (mosdebug>=1) print "time="strftime("%H:%M:%S",systime()),"http_service="http_service
		while ((http_service |& getline line)>0)
		{
			if (mosdebug==2) print "DEBUG: "line
			if (line != "") { ht_error=line ; file_notfound=1}
		}
		close(http_service) ; close(destfile)
		while ((getline line < destfile)>0)
		{
			if (line ~ /<H1>.*Not Found.*H1>/)
			{
				file_notfound=1
				break
			}
		}
		close(destfile)
		if (file_notfound==1 || fileOps("test -s "destfile)!=0)
		{
			if (silent=="")
			{
				if (file_notfound==1) customPrint("Failed! File not found on server.\n"ht_error)
				else customPrint("Failed!")
			}
			fileOps("rm "destfile)
			return 1
		}
		if (silent=="") customPrint("Done.")
		return 0
	}
	theserver=httpserver
	if (is_ip_addr(theserver)==2) theserver="["theserver"]"
	if (http_version==1) htcommand="GET "srcfile" HTTP/1.1\r\nHost: "theserver"\r\nConnection: close\r\n\r\n"
	else
	{
		#only use http/1.0 on non-ior files with linux/solaris. on cygwin we don't yet have a way to remove the http header from binary files, eg jarfiles from RBS (RBS MOM)
		#but, to skip http/1.0 does not work with RBS gen2, where http/1.0 must be specified. So therefore on comcli we must put http/1.0 always
		if (os == "cygwin" && comcli==0 && cpplinux!=1) htcommand=sprintf("GET %s%s\r\n\r\n",srcfile,(ior=="ior"?" HTTP/1.0":""))
		else htcommand=sprintf("GET %s HTTP/1.0\r\n\r\n",srcfile)
	}
	if (mosdebug>=1) print "time="strftime("%H:%M:%S",systime()),"os="os,"ior="ior,"http_service="http_service,"command="htcommand
	printf htcommand |& http_service
	while ((http_service |& getline line)>0)
	{
		if (mosdebug==2) print "DEBUG: "line
		if (line ~ /commonjars\/connect[^ ]*: connection timed out|nc6[^ ]*: remote idle timed out/) { ht_error=line ; file_notfound=1}
	}
	close(http_service) ; close(destfile)
	#on G2 nodes, the http transfer of MOM file sometimes hangs on the last line and gives a timeout at the end but the transfer is ok anyway
	if (file_notfound==1 && comcli>0 && srcfile ~ /\.xml$/ && fileOps("grep </models> "destfile)==0) file_notfound=0

	if (mosdebug>=1 && ior=="ior") { print "ls -l "destfile ; system("ls -l "destfile) ; system("cat "destfile) ; print "END"}
	if (fileOps("test -s "destfile)==0 && (os != "cygwin" || ior=="ior" || comcli>0 || destfile ~ /\.(xml|txt)$/))
	{
		#remove the http header from the fetched file, only works on linux/solaris currently, and on COM nodes
		#Date: Thu, 07 May 2009 06:49:22 GMT\r$
		#Server: WEBS - OSE web server\r$
		#Connection: close\r$
		#Last-Modified: Thu, 09 Apr 2009 09:16:43 GMT\r$
		#Content-Type: application/xml\r$
		#Content-Encoding: xml\r$
		#\r$
		empty_file(destfile".tmp")
		inheader=0
		while ((getline < destfile)>0)
		{
			#if (mosdebug==2) print
			if (inheader==0 && tolower($1)=="content-type:") inheader=1
			else if (inheader==1 && /^[\r]*$/) inheader=2 #we skip the empty line that comes after "Content-Type:". Sometimes there is an extra line with "Content-encoding" but not always
			else if (ior=="ior" && /^IOR:/)
			{
				ior_found=1
				print $0 > destfile".tmp"
			}
			else if (/(BODY|TITLE>).*Not Found|<TITLE>301 Moved Permanently|URL.*not found|404 - Not Found/)
			{
				gsub("&#47;","/")
				#possible errors:
				#1st line: <TITLE>301 Moved Permanently</TITLE>
				#2nd line: The document has moved <A HREF="http://a.b.c.d:80/cello/oe/xml/">here</A>.<P>
				#1st line: <TITLE>404 Not Found</TITLE>  or <TITLE>404 URL Not Found</TITLE>
				#2nd line: <BODY><H1>Not Found</H1>Request failed.<P></BODY>
				#          <BODY><H1>Not Found</H1>The requested URL /crap was not found on this server.<P></BODY>
				#RBS G2
				#           <TITLE>Object Not Found</TITLE>
				#      <H1>Object Not Found</H1>
				#The requested URL &#47;x was not found on this server.
				#CPP Linux
				#  <h1>404 - Not Found</h1>
				#  <title>404 - Not Found</title>

				ht_error=$0
				file_notfound=1
			}
			else if (inheader==2 && ior!="ior") print $0 >> destfile".tmp"
		}
		close(destfile)
		close(destfile".tmp")
		fileOps("mv "destfile".tmp "destfile)
		#an extra line feed is always added at the end of the file, this affects the jarfiles integrity. we remove it now
		if (destfile ~ /\.(jar|gz)$/ && fileOps("test -s "destfile)==0) striplastchar(destfile)
	}
	else if (fileOps("test -s "destfile)==0 && os=="cygwin" && comcli==0 && http_version==1 && destfile ~ /\.(jar|gz)$/)
	{
		#a way to strip the http header from binary files fetched with http/1.1 in cygwin
		empty_file(destfile".tmp")
		inheader=0
		hb=0
		while ((getline < destfile)>0)
		{
			if (inheader==0 && tolower($1)=="content-type:") inheader=1
			else if (inheader==1 && /^[\r]*$/) { hb+=split($0,a,"")+2 ; inheader=2 ; if (mosdebug==2) print hb,$0 }
			if (inheader < 2) { hb+=split($0,a,"")+2 ; if (mosdebug==2) print hb,$0 }
		}
		close(destfile)
		dd="dd bs="hb" skip=1 if="destfile" of="destfile".tmp 2>&1"
		while (dd |& getline)
		{
			if (mosdebug==2) print
			if (/command not found/) customPrint("ERROR: dd utility not found. Please install cygwin coreutils package.")
		}
		close(dd)
		fileOps("mv "destfile".tmp "destfile)
	}
	if (file_notfound==1 || fileOps("test -s "destfile)!=0 || (ior == "ior" && ior_found!=1))
	{
		if (silent=="")
		{
			if (file_notfound==1) customPrint("Failed! File not found on server.\n"ht_error)
			else if (ior == "ior" && ior_found!=1) customPrint("Failed! IOR file may be corrupted.")
			else customPrint("Failed!")
		}
		fileOps("rm "destfile)
		return 1
	}
	#in multimode we check the corba security first
	if (multi==1 && ior=="ior") check_corba_security("silent")

	if (silent=="") customPrint("Done."(multi==1&&ior=="ior"?decode_ior(destfile):""))

	#in online mode we check the corba security after the ior fetching because it may print a line about changing the corba_class
	if (multi!=1 && ior=="ior") check_corba_security("silent")

	if (printTheInfo==1) customPrint("INFO: One or more nodes are using HTTPS, switching to secure_http=1")

	return 0
}
function CheckJarFiles(what,     jarfile)
{
	#we check both for the file presence and the file integrity
	if (what=="nealmob")
	{
		jarVersion[nealjar]=check_jar_version(nealjar)
		if (jarVersion[nealjar] ~ "R[56]") fileOps("rm "nealjar)  #Neal version must be R7 or higher
		if (fileOps(sprintf("test -s %s",nealjar))==1)
		{
			if (httpget(node_address,"/cello/emas/neal_c.jar",nealjar)==0)
			{
				chmod(00666,nealjar)
				jarVersion[nealjar]=check_jar_version(nealjar)
				if (jarVersion[nealjar] ~ "R[56]") fileOps("rm "nealjar) #Neal version must be R7 or higher
			}
		}
	}
	jarVersion[jacorb]=check_jar_version(jacorb)
	jarVersion[jacsec]=check_jar_version(jacsec)
	jarVersion[jacoms]=check_jar_version(jacoms)
	if (subCheckJarFiles()==1) return
	checkJavaPathes()
	for (jarfile in missingJar) FetchJarFile(jarfile)
	parse_common_variables()
	subCheckJarFiles()
	jarVersion[jacorb]=check_jar_version(jacorb)
	jarVersion[jacsec]=check_jar_version(jacsec)
	jarVersion[jacoms]=check_jar_version(jacoms)
	#must do one more check in case jarfiles have just been downloaded.
	#done to solve problem where moshell sets corba_class to 1 after downloading jarfiles on CPP8 (no jacsec), leads to first connection fails, must do a second attempt to succeed
	subCheckJarFiles()
	parse_common_variables()
}
function subCheckJarFiles(      fetch_jar,result)
{
	delete fetch_jar
	delete missingJar
	result=0
	if (fileOps(sprintf("test -s %s",oms))==1)    { missingJar["oms.jar"]=sprintf("%s/oms.jar",jarxmldir) ; fetch_jar["vbjorb"]=1 }
	if (fileOps(sprintf("test -s %s",vbjorb))==1) { missingJar["vbjorb.jar"]=sprintf("%s/vbjorb.jar",jarxmldir) ; fetch_jar["vbjorb"]=1 }
	if (fileOps(sprintf("test -s %s",iaik))==1)   { missingJar["iaik_jce_full_us.jar"]=sprintf("%s/iaik_jce_full_us.jar",jarxmldir) ; fetch_jar["vbjorb"]=1 }
	if (fileOps(sprintf("test -s %s",jacoms))==1) { missingJar["jacoms.jar"]=sprintf("%s/jacoms.jar",jarxmldir) ; fetch_jar["jacorb"]=1 }
	if (fileOps(sprintf("test -s %s",jacorb))==1) { missingJar["jacorb.jar"]=sprintf("%s/jacorb.jar",jarxmldir) ; fetch_jar["jacorb"]=1 }
	if (fileOps(sprintf("test -s %s",jacsec))==1)
	{
		if (fileOps(sprintf("test -s %s",jacorb))==0)# && jarVersion[jacorb]>="R71AL02")
		{
			#if jacorb version is R71AL02 or higher (CPP7 LSV34.6) then jacsec is not needed because its classes already merged in jacorb
			#no jacsec will be found on the node on CPP >= CPP7 LSV34.6
			#this check not done anymore as all nodes should have at least CPP7
			#the check was causing issues with nodes where the revision is not called something like Rxxxx
		}
		else
		{
			missingJar["jacsec.jar"]=sprintf("%s/jacsec.jar",jarxmldir) ; fetch_jar["jacorb"]=1
		}
	}
	if (corba_class==1 && fetch_jar["vbjorb"]!=1) result=1
	else if (corba_class>=2 && fetch_jar["jacorb"]!=1) result=1
	else if (corba_class==1 && fetch_jar["vbjorb"]==1 && fetch_jar["jacorb"]!=1)
	{
		if (security_method==1) corba_class=2
		else if (security_method==2) corba_class=3
		result=1
	}
	else if (fetch_jar["jacorb"]==1 && fetch_jar["vbjorb"]!=1)
	{
		if (corba_class==2) { corba_class=1 ; security_method=1 ; result=1}
		else if (corba_class==3) { corba_class=1 ; security_method=2 ; result=1}
	}
	if (mosdebug==1) print "DEBUG: corba_class="corba_class" ,fetchvbjorb="fetch_jar["vbjorb"]" ,fetchjacorb="fetch_jar["jacorb"]" ,result="result
	return result
}
function checkJavaPathes(    telnet_session,jartime,tmp_timestamp)
{
	customPrint("Some jar files are missing. Downloading now...")
	#if (fileOps("test -s "readanswer)!=0)
	#{
	#	printf("#!%s -fp\nread -e\necho $REPLY\n",bash) > readanswer
	#	close(readanswer)
	#	chmod(00755,readanswer)
	#}
	check_node_password()
	if (node_password == "") exit_with_error()
	telnet_session=enter_telnet_login(node_address,node_password)
	if (telnet_session ~ /Unable to connect|Wrong Password/)
	{
		customPrint(telnet_session)
		exit_with_error()
	}
	print coliMap("ls -al",1)" /c/java\nexit" |& telnet_session
	while ((telnet_session |& getline)>0)
	{
		gsub("\r","") ; gsub("\x00","")
		#-rw-rw-rw-   0   1509748  22 Dec 2005 08:25:26 CXC1320960_R50HK01.jar
		#-rw-rw-rw-   0   3242722   1 Jan 1970 00:07:23 CXC1721558_R60AG03.jar  (in this case tmp_timestamp would be < 0)
		if ($1 !~ /^-r/) continue
		if ($NF ~ /.jar.sm$/) continue
		tmp_timestamp=make_timestamp(sprintf("%s-%s-%s",$6,mm[$5],$4),$7)
		if ($NF ~ /^CXC1320960_.*jar$/)
		{
			#if ($NF >= "CXC1320960_R51")  --> cannot use this because sometimes called CXC1320960_IDLxxx.jar
			if (1)  #always true because since CPP5.1 we use jacoms and nowadays all users should have at least CPP5.1
			{
				#has to be a separate if, do not use &&
				if (tmp_timestamp > jartime["jacoms.jar"] || jartime["jacoms.jar"]=="")
				{
					nodePath["jacoms.jar"]=$NF
					jartime["jacoms.jar"]=tmp_timestamp
				}
			}
			#oms for vbjorb, not used anymore
			else if (tmp_timestamp > jartime["oms.jar"] || jartime["oms.jar"]=="")
			{
				nodePath["oms.jar"]=$NF
				jartime["oms.jar"]=tmp_timestamp
			}
		}
		else if ($NF ~ /^CXC1321689_.*jar$/ && (tmp_timestamp > jartime["vbjorb.jar"] || jartime["vbjorb.jar"]==""))
		{
			nodePath["vbjorb.jar"]=$NF
			jartime["vbjorb.jar"]=tmp_timestamp
		}
		else if ($NF ~ /^CXC132(6165|9315)_.*jar$/ && (tmp_timestamp > jartime["iaik_jce_full_us.jar"] || jartime["iaik_jce_full_us.jar"]==""))
		{
			nodePath["iaik_jce_full_us.jar"]=$NF
			jartime["iaik_jce_full_us.jar"]=tmp_timestamp
		}
		else if ($NF ~ /^CXC172(0452|1558)_.*jar$/ && (tmp_timestamp > jartime["jacorb.jar"] || jartime["jacorb.jar"]==""))
		{
			nodePath["jacorb.jar"]=$NF
			jartime["jacorb.jar"]=tmp_timestamp
		}
		else if ($NF ~ /^CXC172(0453|1559)_.*jar$/ && (tmp_timestamp > jartime["jacsec.jar"] || jartime["jacsec.jar"]==""))
		{
			nodePath["jacsec.jar"]=$NF
			jartime["jacsec.jar"]=tmp_timestamp
		}
	}
	close(telnet_session)
}
function FetchJarFile(jarfile,  result,tmpjar)
{
	result=0
	if (nodePath[jarfile]=="")
	{
		#not necessary to print the error message on the old jarfiles, not existing anymore on CPP5.1 and above (CPP7 for jacsec)
		if (jarfile !~ /^(oms.jar|vbjorb.jar|iaik_jce_full_us.jar|jacsec.jar)$/) customPrint(sprintf("File %s not found on this node.",jarfile))
		return 1
	}
	tmpjar=gensub(/^.*\//,tempdir"/",1,missingJar[jarfile])
	if (ftpclient(node_address,node_password,"get /c/java/"nodePath[jarfile]" "tmpjar)==0)
	{
		chmod(00666,tmpjar)
		customPrint("Moving file to "missingJar[jarfile]" ...Done.")
		fileOps("mv "tmpjar" "missingJar[jarfile])
		chmod(00666,missingJar[jarfile])
	}
	else result=1
	return result
}

function parse_commandlineOptions(userVariables,  last,array,i,varList,tempvar,lastVar)
{
	if (nocs==1) nocorba=1  #if the user had used the option "-l"
	#moshell -v xmlmomlist="rncmom.xml,rbsmom.xml",secure_shell=1,http_port=8080 rnc2
	last=split(userVariables,array,",")
	for (i=1;i<=last;i++)
	{
		#array[1]=xmlmomlist="rncmom.xml
		#array[2]=rbsmom.xml"
		#array[3]=secure_shell=1
		#array[4]=http_port=8080
		if (array[i] == "") continue
		if (array[i] ~ "=") { varList[i]=array[i] ; lastVar=i }
		else if (varList[lastVar] ~ "=") varList[lastVar]=varList[lastVar]","array[i]
	}
	#we sort the varList to make sure that secure_shell is before telnet_port otherwise there can be mismatch, see info in the declare_uservariable function
	last=asort(varList)
	for (i=1;i<=last;i++) if (varList[i] != "") declare_user_variable(varList[i],2)
}
function parse_securityOptions(securityOptions,  last,array)
{
	if (securityOptions == "") return
	# moshell -c ~/host.p12 RNC1
	# moshell -c ~/sam.pbe,oemas a.b.c.d
	last=split(securityOptions,array,",")
	if (last==1)
	{
		security_method=1
		credential=securityOptions
		if (os == "cygwin") credential=make_cygpath(credential)
	}
	else if (last==2)
	{
		security_method=2
		sa_credential=array[1]
		sa_password=array[2]
		if (os == "cygwin") sa_credential=make_cygpath(sa_credential)
	}
}
function handleSpaceInFile(file,noslash)
{
	gsub(/\\/,"",file)
	gsub(/^ +| +$/,"",file)
	gsub(/ +/," ",file)
	if (noslash=="") gsub(" ","\\ ",file)
	return file
}
function check_corba_security(silent,   remotefile,ok)
{
	CorbaSecurity="?"
	remotefile=sprintf("%s/corbasecurity%s",(tempdir==""?"/tmp":tempdir),PROCINFO["pid"])
	if (node ~ /^OFFLINE/) return CorbaSecurity
	if (httpget(node_address,"/cello/corbasecurity",remotefile,"",silent,"",fast_timeout)==0 && fileOps("test -f "remotefile)==0)
	{
		while ((getline < remotefile)>0)
		{
			if ($1 ~ /CorbaSecurity=/)
			{
				CorbaSecurity=gensub(/^.*=/,"",1,$1)
			}
		}
		close(remotefile)
	}
	if (remotefile ~ /^\/tmp\/corbasecurity/) fileOps("rm "remotefile)
	if (multi) return
	#the switching of corba_class will not be done in multimode as different nodes can have different security settings
	#TR HQ35529/HQ45452 the default value of corba_class in AMOS should be 5 except when corba security is OFF and when the user has not explicitely changed the corba_class setting
	if (in_amos_mode() && corba_class==5 && CorbaSecurity=="OFF" && amos_corba_modified_from_default!=1) corba_class=2
	if (smart_corba==1)
	{
		if (CorbaSecurity=="OFF" && corba_class > 2) { declare_user_variable("corba_class=2",2) ; ok=1 }
		else if (CorbaSecurity=="ON" && corba_class == 2) { declare_user_variable("corba_class=4",2) ; ok=1 }
		if (ok==1) customPrint("INFO: Corba Security is "CorbaSecurity", switching to corba_class="corba_class)
	}
	#if (corba_class==2 && CorbaSecurity=="ON")
	#{
	#	corba_class=6
	#	customPrint("INFO: Corba Security is ON, switching to corba_class=6")
	#}
}
function find_sls_urls(   remotefile)
{
	remotefile=sprintf("%s/sls_address.cfg%s",(tempdir==""?"/tmp":tempdir),PROCINFO["pid"])
	if (httpget(node_address,"/configuration/sls_address.cfg",remotefile,"","","",fast_timeout)==0 && fileOps("test -f "remotefile)==0)
	{
		while ((getline < remotefile)>0)
		{
			if (/http/)
			{
				sls_urls=$0
				customPrint("Setting sls_urls to: "sls_urls)
			}
		}
		close(remotefile)
	}
	else
	{
		#we check if corba security is off, this would explain why the file /configuration/sls_address.cfg was missing
		check_corba_security("silent")
		#we only turn off corba security if not in multimode since different nodes can use different security settings
		if (multi!=1 && CorbaSecurity ~ /^(OFF|\?)$/)
		{
			corba_class=2
			customPrint("INFO: Corba Security is "CorbaSecurity", switching to corba_class=2")
		}
	}
	if (corba_class==4 && sls_urls !~ "http")
	{
		customPrint("Invalid SLS URL!\nSLS URL can be set in the attribute ManagedElementData:logonServerAddress and/or in the moshell uservariable sls_urls.")
		exit_with_error()
	}
}
function decode_ior(file,   tmp,array,last,i,line,iorstring,ior_ipaddress,ior_tcpport,l)
{
	#print "debug:"node,node_address,iorfile
	if (node ~ /^OFFLINE/)
	{
		ior_ipaddress=file
		ior_tcpport=0
	}
	else
	{
		close(file)
		while (getline line < file) { if (line ~ /^IOR:/) iorstring=line }
		close(file)
		match(tolower(iorstring),/(3[0-9])+2e(3[0-9])+2e(3[0-9])+2e(3[0-9])+/)
		temp=substr(iorstring,RSTART,RLENGTH)
		last=split(tolower(temp),array,"")
		ior_ipaddress=""
		for (i=2;i<=last;i=i+2) ior_ipaddress=ior_ipaddress array[i]
		ior_ipaddress=gensub("e",".","g",ior_ipaddress)
		if (is_ip_addr(ior_ipaddress) != 1)
		{
			#ipv6
			l[1]="a";l[2]="b";l[3]="c";l[4]="d";l[5]="e";l[6]="f"
			#match(tolower(iorstring),/(3[0-9]|[46][1-6])+3a(3[0-9]|[46][1-6])+3a(3[0-9]|[46][1-6])+3a(3[0-9]|[46][1-6])+3a(3[0-9]|[46][1-6])+3a(3[0-9]|[46][1-6])+3a(3[0-9]|[46][1-6])+3a(3[0-9]|[46][1-6])+00/)
			match(tolower(iorstring),/(3[0-9]|[46][1-6])+3a(3[0-9]|[46][1-6])+3a(3[0-9]|[46][1-6])*3a(3a|3[0-9]|[46][1-6])+00/)
			temp=substr(iorstring,RSTART,RLENGTH-2)
			last=split(tolower(temp),array,"")
			ior_ipaddress=""
			for (i=1;i<last;i+=2)
			{
				if (array[i]==3)
				{
					#ior_ipaddress=ior_ipaddress array[i+1]
					if(array[i+1] == "a") ior_ipaddress=ior_ipaddress":"
					else ior_ipaddress=ior_ipaddress array[i+1]
				}
				else if (array[i]==4 || array[i]==6) ior_ipaddress=ior_ipaddress l[array[i+1]]
			}
			#ior_ipaddress=gensub("a",":","g",ior_ipaddress)
		}
		temp=gensub(/0*$/,"",1,substr(iorstring,RSTART+RLENGTH,8))
		ior_tcpport=sprintf("%d",strtonum("0x"temp))
		if (tolower(iorstring) ~ /de02.*de04/) ior_tcpport="56836"
		if (ior_tcpport==0 && tolower(iorstring) ~ /de04/) ior_tcpport="56836"
		if (CorbaSecurity=="") check_corba_security("silent")
	}
	if (multi)
	{
		if (CorbaSecurity=="ON") thereIsASecureNode=1
		return sprintf(" (CorbaPort=%s, CorbaSecurity=%s)",ior_tcpport,CorbaSecurity)
	}
	theCorbaPort=ior_tcpport
	return sprintf("%s:%s (CorbaSecurity=%s, corba_class=%s, java=%s%s)",ior_ipaddress,ior_tcpport,CorbaSecurity,\
corba_class (corba_class==1?"/"security_method:""),javaVersion,\
(corba_class>=2?sprintf(", jacoms=%s, jacorb=%s%s",jarVersion[jacoms],jarVersion[jacorb],\
(jarVersion[jacsec]!=""?", jacsec="jarVersion[jacsec]:"")):""))
}
function closeLogFiles()
{
	if (logging == 1) close(logfile)
	if (undomode == 1) close(undoLogfile)
}
function get_password(what)
{
	closeLogFiles()
	if (reading_script == 0)
	{
		if (what=="username")
		{
			make_readprompt("Please enter Username: ")
			readprompt | getline username ; close(readprompt)
			gsub(/^[ \t]*|[ \t]*$/,"",username)
			if (username == "") username="moshelluser"
			if (username == "TIMEOUT")
			{
				customPrint("TIMEOUT")
				exit
			}
		}
		else
		{
			if (sl3==1 || sl3Status>=3 || comcli>0 || cpplinux==1 || cppAA==1 || yangcli>0) make_readpromptsilent("Please enter "username"'s Node Password: ")
			else make_readpromptsilent("Please enter Node Password: ")
			readpromptsilent | getline node_password ; close(readpromptsilent)
			gsub(/^[ \t]*|[ \t]*$/,"",node_password)
			if (node_password == "TIMEOUT") { customPrint("TIMEOUT") ; exit }
			print ""
		}
	}
	else
	{
		if (what=="username")
		{
			customPrint(sprintf("Trying username from script file: %s...",Current_ScriptFile))
			getline username < Current_ScriptFile
			gsub(/^[ \t]*|[ \t]*$/,"",username)
		}
		else
		{
			customPrint(sprintf("Trying password from script file: %s...",Current_ScriptFile))
			getline node_password < Current_ScriptFile
			gsub(/^[ \t]*|[ \t]*$/,"",node_password)
		}
	}
	if (what=="username")
	{
		if (username=="q!!")
		{
			customPrint("!!!!Wrong Password or Username!!!!")
			exit
		}
		return username
	}
	else
	{
		if (node_password == "q!!")
		{
			customPrint("!!!!Wrong Password or Username!!!!")
			exit
		}
		node_password=b64Dec(node_password)
		return node_password
	}
}
function find_amos_export_login()
{
	if ((in_amos_mode()!=1)||(amos_enm_accountlookup==0)||(os!="linux")||(export_password!="")) return 0
	if (export_method==2 && amos_enm_accountlookup==2) {}
	else if (export_method!=1) return 0
	customPrint("INFO: Using amos lookupAccount credentials for the export login")
	if (username~/^temporary_amos_/)
	{
		export_username=username
		export_password=node_password
	}
	else amos_exportaccount_lookup()
	if (export_method==1 && export_username~/^temporary_amos_/)
	{
		#TORF-403689 , TORF-404015
		flex_export=1  #exports the logs to a temporary folder read and writeable by all users
	}
}
function get_sls_password(what,   thepassword,thereadcommand)
{
	#what = "" ---> to read sls_password
	#what = userid  ---> to read some other password like export_password or linux_password
	#what = sampassword  ---> to read the samp12 password
	#what = samfile ---> to read the path of sam.p12 file
	#what = nmfile  ---> to read the path of the ssucredentials.xml file
	#what = encpw   ---> to read the password from the encpw command
	#what = encpwf  ---> to read the password from the encpwf command
	closeLogFiles()
	if (reading_script == 0)
	{
		if (what=="")
		{
			make_readpromptsilent("Please enter "sls_username"'s SLS Password: ")
			thereadcommand=readpromptsilent
		}
		else if (what=="sampassword")
		{
			make_readpromptsilent("Please enter the credential's passphrase: ")
			thereadcommand=readpromptsilent
		}
		else if (what=="samfile")
		{
			make_readprompt("Please enter sam.p12 file (<TAB> for path completion): ","","inputrc")
			thereadcommand=readprompt
		}
		else if (what=="nmfile")
		{
			make_readprompt("Please enter ssucredentials.xml file (<TAB> for path completion): ","","inputrc")
			thereadcommand=readprompt
		}
		else if (what=="encpw")
		{
			make_readpromptsilent("Please enter the password to be encrypted: ")
			thereadcommand=readpromptsilent
		}
		else if (what=="encpwf")
		{
			make_readpromptsilent("Please enter the password to be used for the encrypted file: ")
			thereadcommand=readpromptsilent
		}
		else
		{
			make_readpromptsilent("Please enter "what"'s password: ")
			thereadcommand=readpromptsilent
		}
		thereadcommand | getline thepassword ; close(thereadcommand)
		gsub(/^[ \t]*|[ \t]*$/,"",thepassword)
		if (thepassword == "TIMEOUT")
		{
			customPrint("TIMEOUT")
			exit
		}
		if (what=="samfile") sub(/^~\//,ENVIRON["HOME"]"/",thepassword)
		else print ""
		if (what=="") sls_password_was_read_from_prompt=1  #global variable
	}
	else
	{
		if (what=="") customPrint(sprintf("Trying SLS password from script file: %s...",Current_ScriptFile))
		else if (what=="sampassword") customPrint(sprintf("Trying sam.p12 password from script file: %s...",Current_ScriptFile))
		else if (what=="samfile") customPrint(sprintf("Trying path to sam.p12 from script file: %s...",Current_ScriptFile))
		else if (what=="nmfile") customPrint(sprintf("Trying path to ssucredentials.xml from script file: %s...",Current_ScriptFile))
		else customPrint(sprintf("Trying "what"'s password from script file: %s...",Current_ScriptFile))
		#customPrint(sprintf("Trying password from script file: %s...",Current_ScriptFile))
		getline thepassword < Current_ScriptFile
	}
	if (thepassword == "q!!") exit
	return b64Dec(thepassword)
}
function make_java_command(what,silent,forceior,tempfile,alarm_time,   sep,classpath,java_settings,command,tmpcwd,flags,corbajar,secjar,asmjar,omsjar,\
javalib,java_verbose_command,version_found,java_error_text,pmclass,pmfix,jarcommand,tmpext,javaprog)
{
#	#what = "mobrowser", "alarmclient", "pmtester", "pmtester_with_fix", or "nealmob"
	if (corba_class !~ /^[1-5]$/)
	{
		customPrint("Invalid corba_class value, must be 1 to 5.")
		exit_with_error()
	}
	if (fileOps("test -s "iorfile) != 0 || forceior=="forceior")
	{
		httpget(node_address,"/cello/ior_files/nameroot.ior",iorfile,"ior","","",medium_timeout)
		if (fileOps("test -s "iorfile) != 0)
		{
			if (exit_with_error("conditional")==1) return 99
		}
	}
	if (os == "cygwin") iorfile=make_cygpath(iorfile)
	if (corba_class==4 && sls_urls !~ "http") find_sls_urls()

	if (corba_class==1 && what=="nealmob")
	{
		#neal mobrowser only works with jacorb
		if (security_method==1) corba_class=2
		else if (security_method==2) corba_class=3
	}

	CheckJarFiles(what)

	if (corba_class==1 && what=="nealmob")
	{
		#neal mobrowser only works with jacorb
		if (security_method==1) corba_class=2
		else if (security_method==2) corba_class=3
	}

	if (fileOps("test -f SecurityManagement.prp")==0)
	{
		"pwd" | getline tmpcwd ; close("pwd")
		customPrint("The directory "tmpcwd" contains a SecurityManagement.prp file which will interfere with running Java.")
		customPrint("Please cd to another directory or remove this file.")
		exit_with_error()
	}
	java=handleSpaceInFile(java)
	javaprog=java (java_options!=""?" "gensub(/,/," ","g",java_options):"")

	while (sprintf("%s -version 2>&1",javaprog) |& getline)
	{
		gsub("\r","") ; gsub("\x00","")
		if (/(java|openjdk) version "/)
		{
			javaVersion=gensub(/^[^"]*"|"/,"","g",$0)
			version_found=1
		}
		#Error occurred during initialization of VM
		#Could not reserve enough space for object heap
		else java_error_text=java_error_text"\n"$0
	}
	close(sprintf("%s -version 2>&1",javaprog))

	if (version_found!=1)
	{
		customPrint("Unable to execute "java" : "java_error_text"\n")
		if (java=="") customPrint("Please set the appropriate java path in one of the files moshell/moshell or ~/.moshellrc.")
		else customPrint("Please correct the java installation or check that the correct java path has been specified in one of the files moshell/moshell or ~/.moshellrc.")
		exit_with_error()
	}

	if (os == "cygwin") sep=";" ; else sep=":"

	bootjar="xyZa"  #cannot have an empty entry in the classpath otherwise it takes any jarfiles or zip files from the home directory
	if (corba_class==1)
	{
		corbajar=vbjorb
		secjar=iaik
		omsjar=oms
		mobjar=mobrowser
		if (security_method==2) bootjar=bootstrap
		if (what ~ /^(csnotif|alarmnotif)$/) asmjar=asms_stubbed
		else asmjar=asms_secure
	}
	else
	{
		corbajar=jacorb
		secjar=jacsec
		if (what=="nealmob")
		{
			#for nealmob, only the following files are needed: bouncyjar,jacorb,jacsec,nealjar,csu,jacmobn
			mobjar=sprintf("%s%s%s",jacmobn,sep,nealjar)
			omsjar="xyZa"
			#omsjar=bouncyjar
		}
		else
		{
			mobjar=jacmob
			omsjar=jacoms
		}
		if (corba_class==2)
		{
			if (what ~ /^(csnotif|alarmnotif)$/) asmjar=csu".jar"
			else asmjar=find_csu()
		}
		#for jacorb < R7, samssu.jar and csuc.jar must be used
		#for jacorb >= R7 :
		#  - samssu.jar and samcsus.jar must be used for corba_class 3. These files work for all corba_class and with jacorb >= R7
		#  - ssu.jar and csus.jar must be used for corba_class >= 4 . These files only work for corba_class >=4 and with jacorb >= R7
		else if (corba_class==3)
		{
			bootjar=samssu
			if (jarVersion[jacorb]!~"R[56]") asmjar=samcsu  #jarfiles of version CPP7 and above
			else asmjar=csu"c.jar"                          #jarfiles of version CPP5/6
		}
		else if (corba_class<=5)
		{
			asmjar=find_csu()
			if (jarVersion[jacorb]!~"R[56]") bootjar=ssu    #jarfiles of version CPP7 and above
			else bootjar=samssu                             #jarfiles of version CPP5/6
		}
		else
		{
			#corba_class 6 , not supported yet
			asmjar=find_csu()
		}
	}

	if (corba_class==1 && security_method==1 && javaVersion < "1.2.2")
	{
		customPrint(sprintf("Incorrect Java version, must be 1.2.2 or greater (Current versions: java=%s, corba_class=%s, jacorb=%s)",javaVersion,corba_class,jarVersion[jacorb]))
		exit_with_error()
	}
	else if (javaVersion < "1.3.1" && ((corba_class==1 && security_method==2)||(corba_class==2 && jarVersion[jacorb]~"R[56]")))  #jarfiles of version CPP5/6
	{
		customPrint(sprintf("Incorrect Java version, must be 1.3.1 or greater (Current versions: java=%s, corba_class=%s, jacorb=%s)",javaVersion,corba_class,jarVersion[jacorb]))
		exit_with_error()
	}
	#else if (javaVersion < "1.5.0_02" && corba_class>=2 && jarVersion[jacorb] >= "R7")
	#{
	#	#CPP7 jar files do not support older java, causes very high CPU load on java 1.3.1_xxx, 1.4.2_xxx and 1.5.0
	#	#---> NOT a problem anymore, the issue was with the fact that corba_class 2 was using host.p12 and affected all jacorb versions
	#	#after changing corba_class 2 to make it use unsecure connection, no CPU load issue anymore
	#	customPrint(sprintf("Incorrect Java version, must be 1.5.0_02 or greater (Current versions: java=%s, corba_class=%s, jacorb=%s)",javaVersion,corba_class,jarVersion[jacorb]))
	#	exit_with_error()
	#}
	else if (corba_class >=3 && javaVersion < "1.4.2_05")
	{
		customPrint(sprintf("Incorrect Java version, must be 1.4.2_05 or greater (Current versions: java=%s, corba_class=%s, jacorb=%s)",javaVersion,corba_class,jarVersion[jacorb]))
		exit_with_error()
	}
	else if (corba_class == 2 && javaVersion < "1.4" && jarVersion[jacorb] !~ "R[56]")  #jarfiles of version CPP7 and above
	{
		#java 1.3 not support with jacorb >= R7
		customPrint(sprintf("Incorrect Java version, must be 1.4 or greater (Current versions: java=%s, corba_class=%s, jacorb=%s)",javaVersion,corba_class,jarVersion[jacorb]))
		exit_with_error()
	}
	else if (javaVersion >= "1.4" && corba_class==1)
	{
		# we can workout the path to rt.jar by running "java -verbose"
		#note: in java 1.6 on cygwin, the path of rt.jar is not printed automatically when running java -verbose, we have to use the option -Xshare:off
		if (javaVersion >= "1.6") java_verbose_command=sprintf("%s -Xshare:off -verbose 2>&1",javaprog)
		else java_verbose_command=sprintf("%s -verbose 2>&1",javaprog)
		while (java_verbose_command |& getline)
		{
			gsub("\r","") ; gsub("\x00","")
			if (/^\[Opened .*rt\.jar/) rt_jar_tmp=gensub(/\\/,"/","g",gensub(/\[Opened |\]/,"","g",$0))
		}
		close(java_verbose_command)

		#if rt_jar_tmp OK - use it, else use rt_jar variable given to moshell...

		if (fileOps("test -f "rt_jar_tmp) == 0)
		{
			rt_jar = rt_jar_tmp;
		}
		else if (fileOps("test -f "rt_jar) != 0)
		{
			customPrint("Path to rt.jar not found. This is required when corba_class==1 and java 1.4 or greater.")
          		exit_with_error()
          	}
          	javalib=gensub(/\/[^\/]+$/,"/",1,rt_jar)
		classpath=sprintf("-Xbootclasspath:\"%s%s%s%s%s%s%s",corbajar,sep,secjar,sep,rt_jar,sep,javalib"jsse.jar")
	}
        else
        {
        	classpath=sprintf("-classpath \"%s%s%s",corbajar,sep,secjar)
        }
	if (javaVersion < "1.3")
	{
		java_settings="-mx512M -ms4M"
		if (tolower(mom_version) ~ "rnc") java_settings="-mx512M -ms8M"
	}

	classpath=sprintf("%s%s%s%s%s%s%s%s%s%s%s\"",classpath,sep,omsjar,sep,asmjar,sep,bootjar,sep,foundation,sep,mobjar)

	if (javaVersion >= "1.4") flags="-client "
	if (corba_class>=3)
	{
		if (mom_version ~ /^RBS_NODE_MODEL_S/)
		{
			#nodes running JVM lower than J9 (C13A) , eg RBS3000
			if (javaVersion >= "1.7") flags=flags"-Djacorb.security.ssl.client.cipher_suites=SSL_RSA_WITH_RC4_128_SHA,TLS_EMPTY_RENEGOTIATION_INFO_SCSV "
		}
		else if (use_jacorb_ciphers==1)
		{
			if (javaVersion >= "1.7" && CelloVersion~/^9-C1[3-7]/ && CelloVersion!~/^9-C17.Q4/) flags=flags"-Djacorb.security.ssl.client.cipher_suites=TLS_RSA_WITH_AES_128_CBC_SHA,TLS_EMPTY_RENEGOTIATION_INFO_SCSV "
		}
		else if (use_jacorb_ciphers==2)
		{
			if (jacorb_ciphers!="") flags=flags"-Djacorb.security.ssl.client.cipher_suites="jacorb_ciphers",TLS_EMPTY_RENEGOTIATION_INFO_SCSV "
		}
	}
	flags=sprintf("%s-Xverify:none -DSPARC -DHOST -DTRANSACTION_TIMEOUT=%s",flags,transaction_timeout)
	flags=flags" -Djava.security.egd=file:/dev/./urandom"
	flags=sprintf("%s -Dse.ericsson.security.ssu.slstimeout=%u",flags,sls_timeout)
	if (corba_class==1)
	{
		flags=flags" -Dorg.omg.CORBA.ORBClass=com.inprise.vbroker.orb.ORB -Dorg.omg.CORBA.ORBSingletonClass=com.inprise.vbroker.orb.ORBSingleton"
		if (security_method==1) flags=sprintf("%s -Dse.ericsson.security.hostCredentials=%s",flags,credential)
		else if (security_method==2) flags=sprintf("%s -Dvbroker.orb.dynamicLibs=com.inprise.security.Init,se.ericsson.security.corba.samlogin.BSSInit,se.ericsson.security.corba.interceptor.CSUInit -Dse.ericsson.security.sam.samfilename=%s -Duser.password=%s",flags,sa_credential,sa_password)
	}
	else
	{
		#flags=sprintf("%s -DORBInitRef.NameService=http://%s/cello/ior_files/nameroot.ior",flags,node_address)
		flags=sprintf("%s -DUSE_JACORB=true -Dorg.omg.CORBA.ORBClass=org.jacorb.orb.ORB \
-Dorg.omg.CORBA.ORBSingletonClass=org.jacorb.orb.ORBSingleton -Djacorb.connection.client.connect_timeout=%s",flags,corba_connection_timeout*1000)
		if (mosdebug==3) flags=flags" -Djacorb.log.default.verbosity=4 -Dse.ericsson.security.debug=true"
		if (corba_debug>=1) flags=flags" -Dse.ericsson.security.debug=true -Djacorb.log.default.log_pattern=\"[%.20{category}] %.7{priority} [%{time:d/MMM/yyyy HH:mm:ss:SSSS}] : %{message}\\n%{throwable}\" -Djacorb.log.default.verbosity=4"
		if (corba_debug==2) flags=flags" -Djavax.net.debug=ssl -Dse.ericsson.security.ssu.debug=true -Dse.ericsson.security.ssu.autologindebug=true"
		if (what=="mobrowser" || what=="nealmob") flags=sprintf("%s -Djacorb.connection.client.pending_reply_timeout=%s",flags,corba_timeout*1000)
		#Line below is commented out so that corba_class 2 will actually start in unsecure mode, otherwise it generates a huge CPU load on java < 1.5.0_02
		#if (corba_class==2 && what !~ /^(csnotif|alarmnotif)$/) flags=sprintf("%s -DCelloSecurityState=ON -DOASSLPort=0 -Dse.ericsson.security.hostCredentials=\"%s\"",flags,hostp12)
		if (corba_class ~ /^[3-5]$/) flags=sprintf("%s -DCelloSecurityState=ON -DOASSLPort=0 \
-Dse.ericsson.security.ssu.authenticationenabled=true -Dse.ericsson.security.ssu.autologin=true \
-Dse.ericsson.security.ssu.autologindebug=%s",flags,(mosdebug==1?"true":"false"))
		if (corba_class==3)
		{
			flags=sprintf("%s -Dse.ericsson.security.ssu.samcredentialfile=\"%s\" \
-Dse.ericsson.security.ssu.sampassword=%s",flags,sa_credential,sa_password)
		}
		else if (corba_class==4)
		{
			#we put the sls password in quotes because it may contain the & sign
			if (sls_password=="") sls_password=get_sls_password()
			flags=sprintf("%s -Dse.ericsson.security.ssu.slsurls=\"%s\" \
-Dse.ericsson.security.ssu.slsusername=%s -Dse.ericsson.security.ssu.slspassword='%s' \
-Dse.ericsson.security.ssu.credsdir=\"%s\"",flags,sls_urls,sls_username,sls_password,nm_folder)
		}
		else if (corba_class==5) flags=sprintf("%s -Dse.ericsson.security.ssu.ssucredentialfile=\"%s\"",flags,nm_credential)
		#else if (corba_class==6) flags=sprintf("%s -DCelloSecurityState=ON -DOASSLPort=0 -Dse.ericsson.security.hostCredentials=\"%s\"",flags,credential)
	}

	if (what=="nealmob")
	{
		flags=sprintf("%s -Xmx256m -DHttpPort=%s",flags,http_port)
		if (os != "cygwin") flags=sprintf("%s -DNameRootIORDir=\"%s\"",flags,tempdir)
	}
	else
	{
		if (corba_orbinit==0) flags=sprintf("%s -DNameRootIORPath=\"%s\"",flags,iorfile)
		else
		{
			if (corba_class>=3) flags=sprintf("%s -DORBInitRef.NameService=\"corbaloc:ssliop:1.2@[%s]:%s/StandardImplName/",flags,node_address,s_corba_port)
			else                flags=sprintf("%s -DORBInitRef.NameService=\"corbaloc::@[%s]:%s/StandardImplName/",      flags,node_address,corba_port)
			if (is_ip_addr(node_address)==2) flags=flags"IPv6-NameServer-POA/_root\""
			else flags=flags"NameServer-POA/_root\""
		}
	}
	if (node ~ /^OFFLINE/) flags=sprintf("%s -DMOSHELL_OFFLINE",flags)

	if (what=="mobrowser") command=sprintf("%s %s %s %s se.ericsson.cello.configtestclient.SimpleMoBrowser 2>&1",javaprog,java_settings,classpath,flags)
	else if (what=="nealmob") command=sprintf("%s %s %s %s se.ericsson.cello.configtestclient.SimpleMoBrowser %s 2>&1",javaprog,java_settings,classpath,flags,node_address_list)
	else if (what=="alarmclient")
	{
		flags=sprintf("%s -DAlarmTimeFormat=%s",flags,(alarm_time==1?"UTC":"Local"))
		if (os == "cygwin") tempfile=make_cygpath(tempfile)
		command=sprintf("%s %s %s se.ericsson.cello.alarm.ActiveAlarm %s 2>&1",javaprog,classpath,flags,tempfile)
	}
	else if (what=="acknowledgealarm")  command=sprintf("%s %s %s se.ericsson.cello.alarm.AcknowledgeAlarm %s ",javaprog,classpath,flags,ack_parameters)
	else if (what ~ /^pmtester/)
	{
		pmclass="se.ericsson.cello.pmtest.PmTester" ; pmfix=""
		if (what=="pmtester_with_fix") pmfix="-DALL_PM_FIX=true"
		if (corba_class>=2)
		{
			#We check if this version of jacoms fully supports the PM extended operations introduced in IRP 2:3 WRNae44277
			jarcommand="unzip -l "jacoms
			while (jarcommand |& getline) { if ($NF~/^PmServiceExtended\//) { tmpext[gensub(/^PmServiceExtended\/|\.class$/,"","g",$NF)]=1 }}
			close(jarcommand)
			if ("PerformanceMonitoringExtendedOperations" in tmpext && "PerformanceMonitoringExtendedHelper" in tmpext && \
			    "OutputMode" in tmpext && "DestinationAddress" in tmpext && "OutputModeHolder" in tmpext && \
			    "DestinationAddressHolder" in tmpext)
			{
				pmclass="se.ericsson.cello.pmtest.PmTesterExt"
			}
		}
		command=sprintf("%s %s %s %s %s 2>&1",javaprog,classpath,flags,pmfix,pmclass)
	}
	else if (what~ "csnotif")  command=sprintf("%s %s %s se.ericsson.cello.configtestclient.CSNotificationClient 2>&1",javaprog,classpath,flags)
	else if (what~ "alarmnotif")command=sprintf("%s %s %s -DALARM_OUTPUT_FILE=/dev/stdout se.ericsson.cello.alarm.AlarmClient 2>&1",javaprog,classpath,flags)

	java=handleSpaceInFile(java,"noslash")  #remove the backslash otherwise an error message comes when running lh command
	javaprog=java (java_options!=""?" "gensub(/,/," ","g",java_options):"")

	if (multi)
	{
		customPrint(sprintf("\nStarting NealBrowser with corba_class=%s, java=%s, neal=%s, jarcorb=%s%s",corba_class,\
javaVersion,jarVersion[nealjar],jarVersion[jacorb],(jarVersion[jacsec]!=""?", jacsec="jarVersion[jacsec]:"")))
		if (jarVersion[jacorb]~"R[56]" || jarVersion[nealjar]~"R[56]")
		{
			customPrint("\nERROR: neal/jacorb version is too old for NealBrowser, must be R7 or above. \n\
Remove the jarfiles from the folder "jarxmldir" and fetch them from a node running CPP7 or above, \n\
or download them from http://newtran01.au.ao.ericsson.se/moshell/downloads/jacorb_cpp7.zip\n")
			exit_with_error()
		}
	}
	else if (silent=="" || amos_debug>=1) customPrint("Connecting to "decode_ior(iorfile))
	if (mosdebug==1) print command
	return command
}
function make_yang_client(tdir,   command,javaVersion,version_found,java_error_text)
{
	if (tdir=="") tdir=tempdir
	system("rm -rf "tdir"/yanglogs")
	system("rm -rf "tdir"/yangmom")
	system("rm -rf "tdir"/keystore")
	system("rm -rf "tdir"/truststore")
	system("mkdir "tdir"/yanglogs")
	system("mkdir "tdir"/yangmom")
	system("mkdir "tdir"/keystore")
	system("mkdir "tdir"/truststore")
	java=handleSpaceInFile(java)
	while ((sprintf("%s -version 2>&1",java) |& getline)>0)
	{
		gsub("\r","") ; gsub("\x00","")
		if (/(java|openjdk) version "/)
		{
			javaVersion=gensub(/^[^"]*"|"/,"","g",$0)
			version_found=1
		}
		#Error occurred during initialization of VM
		#Could not reserve enough space for object heap
		else java_error_text=java_error_text"\n"$0
	}
	close(sprintf("%s -version 2>&1",java))
	sub(/^\n/,"",java_error_text)

	if (version_found!=1)
	{
		customPrint("Unable to execute java: "java_error_text"\n")
		if (java=="") customPrint("Please set the appropriate java path in one of the files moshell/moshell or ~/.moshellrc.")
		else customPrint("Please correct the java installation or check that the correct java path has been specified in one of the files moshell/moshell or ~/.moshellrc.")
		exit_with_error()
	}
	
	customPrint(sprintf("Starting YangBrowser with java=%s",javaVersion))  #-DprePrompt='EndOfPrint' 
	command=sprintf("%s -Dcli.prompt='EndOfPrint $mode\n>' -Ddebug.log=TRACE -Dnetconf.log=TRACE -Dcli.log=TRACE -DinactivityTimeout=%s -DlogDir=%s -DmodelPath=%s -DkeystorePath=%s -DtruststorePath=%s -jar %s 2>&1",java,yang_timeout,make_cygpath(tdir"/yanglogs"),make_cygpath(tdir"/yangmom"),make_cygpath(tdir"/keystore"),make_cygpath(tdir"/truststore"),make_cygpath(commonjardir"/yangbrowser.jar"))
	if (mosdebug==1) print command
	return command
}
function exit_with_error(conditional,cause)
{
	if (os=="linux" && lin64MissingLibs!="") customPrint(lin64MissingLibs)
	if (CorbaSecurity=="ON" && corba_class==2) customPrint("INFO: Unsecure client cannot connect to secure node! Try again with a different corba_class setting.")
	if (conditional=="conditional" && noninteractive!=1)
	{
		return 1
	}
	else
	{
		if (cause!="") customPrint(cause", exiting...")
		else customPrint("Cannot connect to MO service, exiting...")
		NoBye=1
		exit 1
	}
}
function check_os(   res,array)
{
	if (os ~ /^(cygwin|linux|sunsparc|sun86)$/)
	{
		if (os=="linux" && linarch=="")
		{
			if (check_full_os()~"x86_64") linarch="64" ; else linarch="32"
		}
		if (os=="sun86" && sunarch=="")
		{
			if (check_full_os()~" 5.11 ") sunarch="11" ; else sunarch="10"
		}
		return os
	}
	res=check_full_os()
	split(res,array," ")
	if (tolower(array[1]) ~ "cygwin") return "cygwin"
	if (tolower(array[1]) ~ "linux")
	{
		if (res ~ "x86_64") linarch="64" ; else linarch="32"
		return "linux"
	}
	if (tolower(array[1]) ~ "sunos")
	{
		if (tolower(res) ~ "sparc")
		{
			#if (array[3] ~ /^5\.[89]/) return "sunsparc8"
			return "sunsparc"
		}
		if (tolower(res) ~ /i86pc|i386/)
		{
			#SunOS atrcxb1290 5.10 Generic_150401-31 i86pc i386 i86pc
			#SunOS ossmaster 5.11 11.3 i86pc i386 i86pc
			if (res ~ / 5\.11 /) sunarch="11" ; else sunarch="10"
			return "sun86"
		}
	}
	return res
}
function check_full_os(  res)
{
	"uname -a" | getline res
	close("uname -a")
	return res
}
function check_hostname(   res)
{
	"hostname" | getline res
	close("hostname")
	return res
}
function make_cygdir(dir,    result)
{
	if (os != "cygwin") return dir
	if (dir in cygpath_saved_path) return cygpath_saved_path[dir]
	#old code:
	#result=dir
	#if (dir ~ /^\//)
	#{
	#	if (CygRoot=="") find_CygRoot()
	#	result=concat_cyg(dir)
	#}
	sprintf("cygpath -m "dir) | getline result
	close("cygpath -m "dir)
	return result
}
function make_cygpath(file,force,touchfile,   cygfile)
{
	if (os != "cygwin") return file
	force="force"  #always use force, the faster method with find_CygRoot and concat_cyg does not work with soft links
	if (file ~ /commonjars\/lib\/(file|netcat).dll$|neal_c.jar$/)
	{
		#workaround to handle the filefuncs library because the file ops functions are not yet loaded at this stage
		if (gensub(/\/[^\/]*$/,"",1,file) in cygpath_saved_path)
		{
			cygfile = cygpath_saved_path[gensub(/\/[^\/]*$/,"",1,file)] "/" gensub(/^.*\//,"",1,file)
	        }
	        else
	        {
			sprintf("cygpath -m %s",file) | getline cygfile ; close("cygpath -m "file)
			cygpath_saved_path[gensub(/\/[^\/]*$/,"",1,file)]=gensub(/\/[^\/]*$/,"",1,cygfile)
			#print "DEBUG0: cygpath -m "file" -> "cygfile
		}
		return cygfile
	}
	if (touchfile=="touchfile" && fileOps("test -f "file)!=0) system("touch "file)
	if (file == "" || (fileOps("test -f "file) != 0 && fileOps("test -d "file) != 0)) return "File_not_found"
	if (file !~ /^\//) return file    #only need to run cygpath if it is an absolute path
	if (gensub(/\/[^\/]*$/,"",1,file) in cygpath_saved_path)
	{
		cygfile = cygpath_saved_path[gensub(/\/[^\/]*$/,"",1,file)] "/" gensub(/^.*\//,"",1,file)
        }
        else if (force=="force")
        {
		sprintf("cygpath -m %s",file) | getline cygfile
		close("cygpath -m "file)
		#print "DEBUG0: cygpath -m "file" -> "cygfile
		cygpath_saved_path[gensub(/\/[^\/]*$/,"",1,file)]=gensub(/\/[^\/]*$/,"",1,cygfile)
	}
	else
	{
		if (CygRoot=="") find_CygRoot()
		if (file ~ /^[/]+cygdrive[/]+/)
		{
			cygfile=file
			sub(/^[/]+cygdrive[/]+/,"",cygfile)
			sub(/[/]+/,":/",cygfile)
		}
		else
		{
			cygfile=concat_cyg(file)
		}
		#print "DEBUG1: fastcygpath "file" -> "cygfile
		cygpath_saved_path[gensub(/\/[^\/]*$/,"",1,file)]=gensub(/\/[^\/]*$/,"",1,cygfile)
	}
	#print "debug:"cygfile
	return cygfile
}
function concat_cyg(path,  res)
{
	res=CygRoot path
	if (CygHome !~ sprintf("^%s",CygRoot) && path ~ sprintf("^%s",ENVIRON["HOME"])) res=gensub(ENVIRON["HOME"],CygHome,1,path)
	return res
}
function check_ip_contact(ip_address,port,force,timeout,what,   extraSwitch,command,result,nc_session,n,line,array,error,lin64err,kexalgopt,macsopt,hcom,nok,x_opt)
{
	if (timeout=="") timeout=ip_connection_timeout
	if (check_numeric_hostname==1 && ip_address ~ /^[0-9]+$/)
	{
		nok=0
		hcom="host "ip_address
		while ((hcom |& getline line)>0) { if (line ~ /not found/) nok=1 }
		close(hcom)
		if (nok==1) return 1
	}
	#the force parameter has two purposes
	# - on secure_port, it forces to check the connectivity, otherwise connectivity check is skipped on secure_port as it is already built in ssh
	# - on other ports, it forces to use the external utility nc6, useful when we don't know if the address might be ipv6
	if (comcli>0 && force!="force" && what!="startup" && ip_address!~/^((utran01|newtran01).au.ao.ericsson.se|main-csdp.internal.ericsson.com)$/)
	{
		if ((port==http_port && secure_http==0)||(port==s_http_port && secure_http==1))
		{
			if (use_tls>0) port=s_comcli_port
			else port=comcli_port
		}
	}
	if (port == secure_port || what=="port22")
	{
		if (force == "force")
		{
			#reset these two global variables
			if (port==22) checkIpContactPort22Refused=0
			lin64MissingLibs=""
			#on cygwin 1.7 a file is missing which breaks ssh
			if (os == "cygwin" && fileOps("test -s /bin/cygminires.dll")!=0)
			{
				print "\nInstalling missing file /bin/cygminires.dll ... Done."
				fileOps("cp "moshelldir"/commonjars/cygminires.dll /bin/cygminires.dll")
				chmod(00777,"/bin/cygminires.dll")
			}
			if (ENVIRON["TIME_SERVER"] != "") timeout*=3   #Eriemu
			kexalgopt=""
			macsopt=""
			if (comcli==0 && lincli>0 && ssh_kexalg!="") kexalgopt="-o KexAlgorithms="ssh_kexalg" "   #used for quicker connection on SIU/ESC
			if (comcli==0 && ssh_macs!="") macsopt="-o MACs="ssh_macs" "   #may be needed for some old CPP nodes
	 		command=sprintf("%s -p %s -v -l %s -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null -o NumberOfPasswordPrompts=0 -o HostKeyAlgorithms=\"ssh-dss,ssh-rsa\" \
-o ConnectTimeout=%s -o PreferredAuthentications=password,keyboard-interactive -o ServerAliveInterval=%s -o ServerAliveCountMax=0 -o TCPKeepAlive=no -o ConnectionAttempts=%s %s%s%s 2>&1",\
ssh,port,username,timeout,timeout,connection_attempts,kexalgopt,macsopt,ip_address)
			result=1
			while (command |& getline)
			{
				gsub("\r","");gsub("\x00","")#; if (mosdebug==1) print "DEBUG: "$0
				if (/Permission denied \([^ ]*)./) result=0
				#CPP/LINUX:   debug1: Remote protocol version 2.0, remote software version dropbear_2013.58
				#CPP/OSE:     debug1: Remote protocol version 2.0, remote software version OpenSSH based Ericsson SSH Server for OSE
				#CPP/OSE new: debug1: Remote protocol version 2.0, remote software version OSE SSH based on OpenSSH_6.9
				#RCS:         debug1: Remote protocol version 2.0, remote software version OpenSSH_6.0
				#PICO/APG43L/TSP/PGM/BBSC: debug1: Remote protocol version 2.0, remote software version OpenSSH_6.2
				#NETSIM:      debug1: Remote protocol version 2.0, remote software version Erlang
				#NETSIM NEW:  debug1: Remote protocol version 2.0, remote software version Erlang/4.2.2
				#APG          debug1: Remote protocol version 2.0, remote software version 6.0.17.18 SSH Tectia Server
				#SIU02Linux:  debug1: Remote protocol version 2.0, remote software version OpenSSH_5.4
				#ESC:         debug1: Remote protocol version 2.0, remote software version OpenSSH_5.9
				#Commercial RCS node with port 22 closed: ssh: connect to host a.b.c.d port 22: Connection refused
				else if ($1=="debug1:" && $2=="Remote" && /remote software version/) ssh_server_type=gensub(/^.*remote software version +/,"",1,$0)
				else if (/: connect to host .* port 22: Connection refused/) checkIpContactPort22Refused=1
				#linux 64bit with missing 32bit libs:
				else if (/: (not found|No such file or directory)/) lin64err=$0
			}
			close(command)
			#move the below part later to not risk setting cpplinux=1 on COM node
			#if (comcli==0 && rcli==0 && ssh_server_type ~ /dropbear|^OpenSSH_[7-9]\./)
			#{
			#	#dropbear: Evo8300
			#	#OpenSSH_7.1 : virtual RNC
			#	cpplinux=1
			#	use_lhz=1   #use_lhz is supported on cpp linux but currently it seems slower . Maybe it will be faster when there are more boards
			#}
			if (result==1 && os=="linux" && lin64err!="") lin64MissingLibs=lin64err
			if (mosdebug==1) print "DEBUG: "command" --> "result
			return result
		}
		else if (force == "fast")
		{
			#using nc6
			if (is_ip_addr(ip_address)>0) extraSwitch="-n" ; else extraSwitch=""
			nc_session=sprintf("%s -w %s %s -z %s %s >/dev/null 2>&1",netcat,timeout,extraSwitch,ip_address,port)
			if (mosdebug==1 || mosdebug==999) printf "DEBUG: "nc_session"---> "
			result=system(nc_session)
			if (mosdebug==1 || mosdebug==999) print result
			return result
		}
		else
		{
			#We dont do an ip contact check on secure_port to save time and limit the number of printouts in the te log
			#The ip contact check is not needed anyway on secure port thanks to the connecttimeout variable in ssh
			return 0
		}
	}
	if (what=="port22") return ""
	#if (use_netcatlib==1 && is_ip_addr(ip_address)!=2 && force!="force")
	#{
	#	#using built in netcat library, only supports ipv4
	#	#Currently causes sort: write failed: Broken pipe with pmr reports using -pipe option
	#	#ncfunc (char* address, int port, int timeout, int use_dns_lookup)
	#	if (is_ip_addr(ip_address)==1) extraSwitch="0" ; else extraSwitch=1   #if numeric ip address, skip the dns lookup
	#	if (mosdebug==1) printf "DEBUG: ncfunc("ip_address","port","timeout","extraSwitch") --> "
	#	result=ncfunc(ip_address,port,timeout,extraSwitch)
	#	if (mosdebug==1) print result
	#}
	#### use_netcatlib=0
	if (use_netcatlib==1 && is_ip_addr(ip_address)>0 && force!="force")
	{
		#using built in netcat library
		if (mosdebug==1 || mosdebug==999) printf "DEBUG: ncfunc("ip_address","port","timeout") --> "
		result=ncfunc(ip_address,port,timeout)
		if (mosdebug==1 || mosdebug==999) print result
	}
	else
	{
		#using external utility nc6. slower than netcatlib but supports ipv6
		if (is_ip_addr(ip_address)>0) extraSwitch="-n" ; else extraSwitch=""
		nc_session=sprintf("%s -w %s %s -z %s %s >/dev/null 2>&1",netcat,timeout,extraSwitch,ip_address,port)
		if (mosdebug==1 || mosdebug==999) printf "DEBUG: "nc_session"---> "
		result=system(nc_session)
		if (mosdebug==1 || mosdebug==999) print result
		if ((what=="startup" && result==0 && is_ip_addr(ip_address)>0 && (!(os=="cygwin" && is_ip_addr(ip_address)==2)))||\
		    (what=="startup" && result==0 && os=="linux" && ip_address~/^[0-9]+$/))
		{
			#only do this for the ip contact check at startup
			#dont do this for ipv6 on cygwin since connect6 on cygwin currently only works with option "-l <sourceip>"
			#nc6 sometimes returns ok even though the ip address is not reachable.
			#eg :
			# - with ipv6 addresses where the network is unreachable it says ok anyway
			# - with ipv4 addresses that start with 0 (e.g 0.74.59.147) it says ok if there is a http/telnet server on the users own machine
			# - with an address that only consists of numbers (eg 1234) it says ok on linux
			#So if the nc6 check succeeded we do a secondary check here
			if (connect~/\.lin64$/) x_opt="-y" ; else x_opt="-x"
			if (is_ip_addr(ip_address)==2) command=sprintf("%s %s -t 1 %s@%s 2>&1",connect6,x_opt,ip_address,port)
			else if (is_ip_addr(ip_address)==1) command=sprintf("%s %s -t 1 %s:%s 2>&1",connect,x_opt,ip_address,port)
			else if (is_ip_addr(ip_address)==0) command=sprintf("%s %s -t 1 %s:%s 2>&1",connect,x_opt,ip_address,port)
			#result=0

			if (mosdebug==1 || mosdebug==999) printf "DEBUG: "command"---> "
			print "exit" |& command
			while (command |& getline line)
			{
				gsub("\r","",line)
				#If contact is ok, the first line of the printout will be a ip address
				#2001:1b70:828a:158::220:52373
				#or
				#a.b.c.d:56217

				#If the contact is not ok the first line will be like:
				#/home/eanzmagn/moshell/commonjars/connect6: can't connect to 2001:1b70:8292:26::51:80, error= Network is unreachable
				#/home/eanzmagn/moshell/commonjars/connect.linux: can't connect to 0.74.59.147:80, error= Invalid argument
				n++
				if (n==1)
				{
					#if the first word is not an ipaddress:port then the contact failed
					split(line,array," ")
					if (array[1] !~ /:[0-9]+$/)
					{
						result=1
						error=line
					}
				}
			}
			close(command)
			if (mosdebug==1 || mosdebug==999)
			{
				print result
				if (error != "") print error
			}
		}
	}

	return result
}
function validate_nc(    nc_session,line,ok,buff)
{
	#returns 0 for ok, 2 for missing nc6, 1 otherwise (eg missing libs)
	ok=1
	nc_session=netcat" --help 2>&1"
	while ((nc_session |& getline line)>0)
	{
		#Ok
		#Recognized options are:

		#missing 32 bit libc:
		#/opt/ericsson/amos/moshell/commonjars/nc6: error while loading shared libraries: libc.so.6: cannot open shared object file: No such file or directory

		#missing nc6
		#sh: /opt/ericsson/amos/moshell/commonjars/nc6: No such file or directory

		gsub("\r","",line)
		buff=buff line "\n"
		if (line ~ /Recognized options are/) ok=0
		else if (line ~ /moshell\/commonjars\/nc6[^:]*: No such file/) ok=2
	}
	close(nc_session)
	if (ok==0) return 0
	return ok SUBSEP buff
	#if (ok==1) return buff
	#else return 0
}
function find_ipv4_addr(v6addr,   command,currif,ifList,ipList,i,res)
{
	res=v6addr
	if (os ~ /^sun/) command="/sbin/ifconfig -a"
	else command=getif
	while (command |& getline)
	{
		if (os ~ /^sun/)
		{
			#bge1177000: flags=201000843<UP,BROADCAST,RUNNING,MULTICAST,IPv4,CoS> mtu 1500 index 3
			#        inet a.b.c.d netmask fffffe00 broadcast a.b.c.d
			#bge1177000: flags=202004841<UP,RUNNING,MULTICAST,DHCP,IPv6,CoS> mtu 1500 index 3
			#        inet6 fe80::214:4fff:fead:3a4a/10
			if (/^[^ \t]/) { sub(/:.*$/,"",$1) ;currIf=$1 ; ifList[$1]=$1 }
			if ($1~/^inet6?$/)
			{
				sub(/[/%].*$/,"",$2)
				if ($1 == "inet") ipList[currIf]=$2
				else ipList[currIf,$2]=1
			}
		}
		else
		{
			#cygwin
			#{846EE342-7039-11DE-9D20-806E6F6E6963} family:  2 (AF_INET)  address: 127.0.0.1
			#{846EE342-7039-11DE-9D20-806E6F6E6963} family: 23 (AF_INET6) address: ::1
			#eth2   family:  2 (AF_INET)  address: a.b.c.d
			#eth2   family: 10 (AF_INET6) address: 2001:1:1:1::150
			#eth2   family: 10 (AF_INET6) address: 2001:1:1:1:6a05:caff:fe01:56af
			#eth2   family: 10 (AF_INET6) address: fe80::6a05:caff:fe01:56af%eth2
			$4=tolower(gensub(/^\(AF_|\)$/,"","g",$4))
			sub(/[/%].*$/,"",$6)
			ipList[$1,$4]=$6
			ifList[$1]=$1
			if ($4 == "inet") ipList[$1]=$6
			else ipList[$1,$6]=1
		}
	}
	close(command)
	for (i in ifList)
	{
		#print i,ipList[i],v6addr,ipList[i,v6addr]
		if (ipList[i,v6addr]==1 && ipList[i]!="") res=ipList[i]
	}
	return v6addr (res!=v6addr?" ("res")":"")
}

function process_ipv6_special(theip,   res,a)
{
	res=theip
	if (theip ~ /^::[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+$/)
	{
		split(gensub(/^::/,"",1,theip),a,/\./)
		res=sprintf("::%s%s:%s%s",hexpad(a[1]),hexpad(a[2]),hexpad(a[3]),hexpad(a[4]))
	}
	return res
}
function hexpad(nr,   res)
{
	res=sprintf("%x",strtonum(nr))
	if (length(res)<2) res="0"res
	return res
}
function is_ip_addr(string,   res)
{
	res=0
	string=tolower(string)
	if (string ~ /^[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+$/) res=1
	else if (string ~ /^(\[)?[0-9a-f:]*:[0-9a-f:]*:[0-9a-f:]*(\])?$/) res=2
	else if (string ~ /^::[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+$/) res=2   #eg, sometimes ::5859:a0f could be written as ::88.89.10.15
	return res
}
function find_ws_ip(ip_address,port,what,   command,res,n,ipver,i,a,p,x_opt)
{
	#for comcli, siu/tcu, we must use secure_port since http_port not used
	if (comcli>0 && use_tls>0) port=s_secure_port
	else if (comcli>0 || rcli>0) port=secure_port
	if (mosdebug==1 || mosdebug==999) print "DEBUG: find_ws_ip "ip_address" "port" "what
	ipver=is_ip_addr(ip_address)
	if (mosdebug==1 || mosdebug==999) print "Debug: node_address="node_address", isip="is_ip_addr(node_address)", ipv6="ipv6", smart_ipv6="smart_ipv6
	if (ipver==2 || (ipver==0 && ipv6==1) || (ipver==0 && smart_ipv6==1))
	{
		#if the ip version of this address is ipv6 or unknown then we use the utility connect6
		#but first we must check ip connectivity because connect/connect6 does not do that and hangs forever when no connectivity
		if (check_ip_contact(ip_address,port,"force",fast_timeout)!=0) return ""   #we use the force parameter to force using nc6 instead of netcatlib
		if (connect~/\.lin64$/) x_opt="-y" ; else x_opt="-x"
		res=run_connect(what,sprintf("%s %s -t 1 %s@%s 2>&1",connect6,x_opt,ip_address,port))
		if (res=="" && os=="cygwin")
		{
			p=split(run_getif(),a,"@")
			for (i=1;i<=p;i++)
			{
				if (a[i]=="") continue
				res=run_connect(what,sprintf("%s/connect6a.exe -x -t 1 -l %s %s@%s 2>&1",commonjardir,a[i],ip_address,port))
				if (res!="") break
			}
		}
		if (is_ip_addr(res)==2)
		{
			if (ipv6==0 && smart_ipv6==1)
			{
				if (mosdebug==1 || mosdebug==999) print "Debug: switching to ipv6=1"
				declare_user_variable("ipv6=1",2)
			}
			if (what=="") return find_ipv4_addr(res)
			else return process_ipv6_special(res)
		}
	}

	if (ipver==2)
	{
		if (ipv6==0 && smart_ipv6==1)
		{
			#this one is needed in case we had connected with a ipv6 ior file
			if (mosdebug==1) print "Debug: switching to ipv6=1"
			declare_user_variable("ipv6=1",2)
		}
		return "" #don't try the below with a ipv6 host otherwise it can hang
	}
	if (check_ip_contact(ip_address,port,"force",fast_timeout)!=0)
	{
		#if (mosdebug==1) print "DEBUG: comcli="comcli" port="port" checkIpContactPort22Refused="checkIpContactPort22Refused
		if (comcli>0 && port==22 && checkIpContactPort22Refused==1)
		{
			#a Commercial RCS node with port 22 closed, use the https port, unless secure_http is 0 and port 8080 is reachable
			port=443
			#skip the below, port 8080 is not applicable anymore
			#if (secure_http==0 && check_ip_contact(ip_address,8080,"force",fast_timeout)==0) port=8080
		}
		else return ""  #don't try the below with a unreachable ip address otherwise it hangs
	}
	n=0
	if (connect~/\.lin64$/) x_opt="-y" ; else x_opt="-x"
	command=sprintf("%s %s -t 1 %s:%s 2>&1",connect,x_opt,ip_address,port)
	if (mosdebug==1) print "DEBUG: "command
	print "exit" |& command
	while (command |& getline)
	{
		gsub("\r","")
		#if (mosdebug==1) print "DEBUG: "$0
		#**:ws7085@~> /home/eanzmagn/moshell/commonjars/connect.linux  -x a.b.c.d:80
		#a.b.c.d:45275
		#a.b.c.d:80
		#exit
		#<HTML><HEAD>
		#<TITLE>400 Bad Request</TITLE>
		#</HEAD>
		#<BODY><H1>Bad Request</H1>Request failed.<P></BODY>
		#</HTML>
		n++
		if (n==1 && what=="") res=gensub(/:.*$/,"",1,$1)
		else if (what=="node" && n==2) res=gensub(/:.*$/,"",1,$1)
	}
	close(command)
	#if (mosdebug==1) print "DEBUG: ws_ip="res
	return process_ipv6_special(res)
}
function run_getif(      resList,res,n,i,command)
{
	if (os!="cygwin") return ""
	res=""
	delete resList
	command=getif
	while (command |& getline)
	{
		#{EEAF4CA1-7DE0-4133-B496-1FB98FFF02DF} family: 23 (AF_INET6) address: 2001:1b70:82a8:90:649:64:0:1
		#{EEAF4CA1-7DE0-4133-B496-1FB98FFF02DF} family: 23 (AF_INET6) address: fe80::4114:4ca3:3aa3:cad3%11
		#{846EE342-7039-11DE-9D20-806E6F6E6963} family: 23 (AF_INET6) address: ::1
		if ($4!="(AF_INET6)") continue
		if ($6~/^(fe|:)/) continue
		sub(/[/%].*$/,"",$6)
		resList[$6]=$6
	}
	close(command)
	n=asort(resList)
	for (i=1;i<=n;i++) res=res "@" resList[i]
	sub(/^@/,"",res)
	if (mosdebug==1) print "DEBUG: getif -> "res
	return res
}
function run_connect(what,command,   n,res)
{
	res=""
	n=0
	print "exit" |& command
	while (command |& getline)
	{
		gsub("\r","")
		#On port 80:
		#**:ws5798@~> moshell/commonjars/connect6.solaris -x -t 10 2001:1b70:828a:1::15@80
		#2001:1b70:828a:158::220:52373
		#2001:1b70:828a:1::15:80
		#exit
		#<HTML><HEAD>
		#<TITLE>400 Bad Request</TITLE>
		#</HEAD>
		#<BODY><H1>Bad Request</H1>Request failed.<P></BODY>
		#</HTML>

		#On port 22:
		#2001:1b70:828a:158::220:52389
		#2001:1b70:828a:1::15:22
		#SSH-2.0-OpenSSH based Ericsson SSH Server for OSE
		#Protocol mismatch.

		#with ipv4 host:
		#moshell/commonjars/connect6.solaris: can't resolve a.b.c.d, error= Error 0
		n++
		if ($1!~/:[0-9]+$/) continue
		if (n==1 && what=="") res=gensub(/:[0-9]+$/,"",1,$1)
		else if (what=="node" && n==2) res=gensub(/:[0-9]+$/,"",1,$1)
	}
	close(command)
	if (mosdebug==1) print "DEBUG: "command" -> "res
	return res
}
function make_telnet_command(ipaddress,password,tmattach,idle_timeout,ssh_port,netconfcli_showcommand,validate_pw,   command,javaprog,temposeargfile,theMeId,pemfiles,extra,kexalgopt,macsopt)
{
	#Special settings for COM
	#idle_timeout is used for the ssh session used for MOCI towards COM.
	#ssh_port is used to specify the standard ssh port or a dedicated port for COMCLI as used in RBS G2 when linux_shell=0
	if (idle_timeout=="") idle_timeout=ip_inactivity_timeout
	if (ssh_port=="")
	{
		if (comcli==2 && linux_shell==0)
		{
			if (use_netconf>0)  ssh_port=netconf_port
			else if (use_tls>0) ssh_port=s_comcli_port
			else ssh_port=comcli_port
		}
		else
		{
			if (comcli>0 && use_tls>0) ssh_port=s_secure_port
			else ssh_port=secure_port
		}
	}
	else if (comcli>0 && linux_shell>=1)
	{
		#if the ssh_port was specified but linux shell is available we use secure_port, not comcli port
		ssh_port=secure_port
	}

	if (cpplinux==1 && secure_shell==1)
	{
		if (ssh_debug>0) sshdebug=" -vvv " ; else sshdebug=""
		command=sprintf("%s -p %s -z '%s' -l %s -t -t -e none -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null -o HostKeyAlgorithms=\"ssh-dss,ssh-rsa\" \
-o NumberOfPasswordPrompts=1 -o ConnectTimeout=%s -o ServerAliveInterval=%s -o ServerAliveCountMax=0 -o TCPKeepAlive=no -o PreferredAuthentications=%s -o ConnectionAttempts=%s %s%s%s 2>&1",\
ssh,secure_port,tempsshzfile,username,ip_connection_timeout,ip_inactivity_timeout,auth_method,connection_attempts,sshdebug,node_address,(1==1?"":" 'echo \"Wind River Linux\" && export COLUMNS="comcli_columns" && bash -l'"))
	}
	else if (comcli>0 && use_netconf>0 && ssh_port==netconf_port)
	{
		javaprog=java (java_options!=""?" "gensub(/,/," ","g",java_options):"")
		if (netconfcli_showcommand=="") netconfcli_showcommand=1
		if (validate_pw!="") theMeId=1  #for faster connection when validating password we dont care if the ME id is wrong
		else theMeId=gensub(/^.*ManagedElement=/,"",1,ComMe)
		command=sprintf("%s -cp %s -Dnetconfcli.ipAddress=%s -Dnetconfcli.port=%s -Dnetconfcli.username=%s -Dnetconfcli.password=%s \
-Dnetconfcli.operationTimeOut=%s -Dnetconfcli.idleTimeOut=%s -Dnetconfcli.momDirectory=\"%s\" -Dnetconfcli.showMessagesLog=/dev/stdout \
-Dnetconfcli.debug=%d -Dnetconfcli.showMessages=%d -Dnetconfcli.showCommand=%d -Dnetconfcli.managedElementId=\"%s\" -Dnetconfcli.getConfig=%d com.ericsson.netconfcli.NetconfCli 2>&1",\
javaprog,ecimcomjar,ipaddress,netconf_port,username,node_password,idle_timeout,idle_timeout,tempnetconfmomdir,corba_debug,corba_debug,netconfcli_showcommand,theMeId,netconf_getconfig)
	}
	else if (comcli>0 && use_tls>0 && (ssh_port==s_comcli_port || ssh_port==s_secure_port || ssh_port==s_netconf_port))
	{
		#openssl s_client -connect a.b.c.d:9830 -cert client.pem -CAfile ca.pem -quiet
		find_pemfiles(pemfiles)
		if (nc_validation(ipaddress,ssh_port)==1) command="999"
		else command=sprintf("%s s_client -connect %s:%s %s-cert %s -CAfile %s%s -quiet -time_connection %s -time_session %s 2>&1",openssl,put_brackets(ipaddress),ssh_port,make_tlsflags(),pemfiles["client"],pemfiles["ca"],(use_tls==21?" -key "keypem" -pass pass:"keypass:""),ip_connection_timeout,idle_timeout)
	}
	else if (secure_shell==0)
	{
		if (ipv6==1) command=sprintf("%s -t %s %s %s 2>&1",netcat,ip_inactivity_timeout,ipaddress,telnet_port)
		else command=sprintf("%s -t %s %s:%s 2>&1",connect,ip_inactivity_timeout,ipaddress,telnet_port)
	}
	else if (tmattach==1)
	{
		command=sprintf("%s -p %s -z '%s' -l %s %s -e none -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null -o HostKeyAlgorithms=\"ssh-dss,ssh-rsa\" -o \
NumberOfPasswordPrompts=1 -o ConnectTimeout=%s -o ServerAliveInterval=8 -o LogLevel=DEBUG1 -o ServerAliveCountMax=3 -o TCPKeepAlive=no \
-o PreferredAuthentications=%s -o ConnectionAttempts=%s %s%s 2>&1",\
ssh,ssh_port,tempsshzfile,username,((lincli>0||ssh_server_type~/OSE SSH /)?"-t -t":"-T"),ip_connection_timeout,auth_method,connection_attempts,ipaddress,(comcli>0&&node_login>0&&linux_shell==1?" bash":""))
	}
	else
	{
		if (comcli>0 || yangcli>0)
		{
			if (node_login>0&&linux_shell==1) extra=" bash"
			else if (ssh_subsystem!="") extra=" -s "ssh_subsystem
			if ((ssh_port+0)>22 && ssh_kexalg!="") kexalgopt="-o KexAlgorithms="ssh_kexalg" "
			#print "ssh_port="ssh_port,"ssh_kexalg="ssh_kexalg,"kexalgopt="kexalgopt
		}
		else if (comcli==0 && lincli>0 && ssh_kexalg!="") kexalgopt="-o KexAlgorithms="ssh_kexalg" "   #used for faster connection on SIU/TCU02/ESC
		if (comcli==0 && ssh_macs!="") macsopt="-o MACs="ssh_macs" "   #may be needed on some old CPP nodes
		if (ssh_debug>0) sshdebug=" -vvv " ; else sshdebug=""
 		command=sprintf("%s -p %s -z '%s' -l %s %s -e none -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null -o HostKeyAlgorithms=\"ssh-dss,ssh-rsa\" -o \
NumberOfPasswordPrompts=1 -o ConnectTimeout=%s -o ServerAliveInterval=%s -o ConnectionAttempts=%s -o ServerAliveCountMax=0 -o TCPKeepAlive=no -o PreferredAuthentications=%s %s%s%s%s%s 2>&1",\
ssh,ssh_port,tempsshzfile,(rcli==2?"cli":username),((lincli>0||ssh_server_type~/OSE SSH /)?"-t -t":"-T"),ip_connection_timeout,idle_timeout,connection_attempts,auth_method,sshdebug,kexalgopt,macsopt,ipaddress,extra)
		#if (axenode=="SIU")  #Nowadays we dont use a known host file anymore
		#{
		#	#the ssh key may change after a node restart in which case we cannot reconnect, with error message
		#	#Add correct host key in /home/labuser/moshell_logfiles/logs_moshell/tempfiles/20120423-151859_24264/knownhost24295 to get rid of this message.
		#	fileOps("rm "tempknownhostfile)
		#}
 	}

	if (mosdebug==1) print command > "/dev/stderr"
	return command
}
function find_pemfiles(pemfiles,    s1,s2,ok,line,s1d,s2d)
{
	pemfiles["client"]=tempdir"/client.pem"
	pemfiles["ca"]=tempdir"/ca.pem"
	if (use_tls==1)
	{
		s1=sprintf("%s pkcs12 -in %s -clcerts -out %s -nodes -password pass:%s 2>&1",openssl,sa_credential,pemfiles["client"],sa_password)
		s2=sprintf("%s pkcs12 -in %s -cacerts -out %s -nodes -password pass:%s -nokeys 2>&1",openssl,sa_credential,pemfiles["ca"],sa_password)
		s1d=gensub(/ pass:[^ ]+ /," pass:******* ",1,s1)
		s2d=gensub(/ pass:[^ ]+ /," pass:******* ",1,s2)
		if (mosdebug==1) print s1d
		close(s1) ; while (s1 |& getline) {if (mosdebug==1) print } ; close(s1)
		if (mosdebug==1) print s2d
		close(s2) ; while (s2 |& getline) {if (mosdebug==1) print } ; close(s2)
	}
	else if (use_tls==2 || use_tls==21)
	{
		pemfiles["client"]=clientpem
		pemfiles["ca"]=capem
	}
	else if (use_tls==3)
	{
		s1=sprintf("(%s '{gsub(/<[^>]+>|\r/,\"\");print}' %s | %s rsa -out %s -passin pass:%s) 2>&1",gawk,nm_credential,openssl,pemfiles["client"],the_info())
		close(s1) ; while (s1 |& getline) {if (mosdebug==1) print } ; close(s1)
		ok=0
		s1="cat "nm_credential
		close(s1)
		while (s1 |& getline)
		{
			gsub(/<[^>]+>|\r/,"")
			if (NF==0) continue
			if (ok==0 && $0=="-----BEGIN CERTIFICATE-----") ok=1
			if (ok==1)
			{
				print $0 >> pemfiles["client"]
				if ($0=="-----END CERTIFICATE-----") ok=2
			}
			else if (ok==2) print $0 >> pemfiles["ca"]
		}
		close(s1)
		close(pemfiles["client"])
		close(pemfiles["ca"])
	}
	if (fileOps("test -s "pemfiles["client"])!=0) return 1
	if (fileOps("test -s "pemfiles["ca"])!=0) return 1
	return 0
}
function is_rcs(   res)
{
	res=0
	if (comcli>0 && is_netsim!=1)  #Netsim for RBS G2 does not support RCS-COLI
	{
		if (mom_version ~ /^(CRBS|MSRBS|RCS)_NODE_MODEL/ || secure_port==4192 || comcli_portfile==1) res=1
	}
	return res
}
function is_pico(   res)
{
	res=0
	if (comcli>0 && mom_version ~ /PRBS_NODE_MODEL/) res=1
	return res
}
function is_router(   res)
{
	res=0
	if (comcli>0 && is_netsim!=1)
	{
		if ((mom_version ~ /^ROUTER_NODE_MODEL/) || (mom_version=="" && comcli_port==22 && epg_ssr==1)) res=1
	}
	return res
}
function remove_colors()
{
	#remove linux escape sequence eg: <ESC>[{attr};{fg};{bg}m
	#^[[m
	#^[[01;34m
	#^[[0m
	#^[[00m
	#^[[0m
	#^[[1m
	#^[[31m
	#^[(B^[[m
	gsub(/\033\[([0-4][0-9]?(;[3-4][0-9])?)?m|\033\(B/,"")
}
function refresh_enm_com_account(sshRetryCount,result,   tmpres)
{
	if ((in_amos_mode()!=1)||(username!~/^temporary_amos_/)||(os!="linux")||(sshRetryCount>1)||(result!~/Wrong Password or Username/)) return 0
	amos_account_delete(username)
	amos_account_lookup()
	customPrint(sprintf("Trying "username"'s password from amos lookupAccount ... "),"","","noLF")
	tmpres=validate_password("Not OK") #0=passwordOk , 1=noIpContact , 2=passwordNotOk
	if (tmpres==0) validatepw_printOK()
}
function validatepw_printOK(what)
{
	if (what=="") customPrint("OK")
	if (login_warning!="") customPrint(login_warning)
	login_warning=""
}
function enter_telnet_login(ipaddress,password,tmattach,idle_timeout,ssh_port,comcli_val,validate_pw,   result,sshRetryCount)
{
	if (mosdebug==1) print "ssh_port="ssh_port
	if (ssh_port=="")
	{
		if (comcli==2 && linux_shell==0)
		{
			if (use_netconf>0)  ssh_port=netconf_port
			else if (use_tls>0) ssh_port=s_comcli_port
			else ssh_port=comcli_port
		}
		else
		{
			if (comcli>0 && use_tls>0) ssh_port=s_secure_port
			else ssh_port=secure_port
		}
	}
	else if (comcli>0 && linux_shell>=1)
	{
		#if the ssh_port was specified but linux shell is available we use secure_port, not comcli port
		ssh_port=secure_port
	}
	if (mosdebug==1) print "ssh_port="ssh_port
	while (1)
	{
		sshRetryCount++
		result=sub_enter_telnet_login(ipaddress,password,tmattach,idle_timeout,ssh_port,comcli_val,validate_pw)
		#refresh_enm_com_account(sshRetryCount,result)   #skip this , else goes into endless loop when password fail
		if (!(comcli==0 && secure_shell==1)) break
		if (sshRetryCount > ssh_retry || result !~ /ssh_exchange_identification: Connection closed by remote host|Connection timed out during banner exchange/) break
		customPrint("SSH connection failed, retrying...")
		if (mosdebug==1) print "DEBUG: sshRetryCount="sshRetryCount", ssh_retry="ssh_retry
		usleep(1000000)
	}
	return result
}
function tsleep(s)
{
	s+=0
	if (s==0) s=1
	if (ENVIRON["TIME_SERVER"] != "") system("sleep "s)  #For Eriemu we must use system sleep, since gawk sleep not impacted by the time server lib
	else sleep(s)
}
function sub_enter_telnet_login(ipaddress,password,tmattach,idle_timeout,ssh_port,comcli_val,validate_pw,   telnet_session,wrong_password,error_text,twait,theport,nok)
{
	#possible return values:
	#  * telnet_session command if login ok
	#  * unable to connect to ...
	#  * wrong password
	if (comcli_val=="") comcli_val=comcli
	if (secure_shell==1 && ssh_port!="") theport=ssh_port ; else theport=telnet_port
	if (is_rcs()==1 && use_netconf>0 && theport==830 && haveCheckedNetconfRcsPort!=1 && check_ip_contact(ipaddress,theport)!=0)
	{
		#on lab RCS nodes the netconf port is 2022, not 830
		theport=2022
		netconf_port=2022
		ssh_port=2022
		haveCheckedNetconfRcsPort=1
	}
	if (check_ip_contact(ipaddress,theport) != 0)
	{
		return sprintf("Unable to connect to %s:%s",ipaddress,theport)
	}

	telnet_session=make_telnet_command(ipaddress,password,tmattach,idle_timeout,ssh_port,"",validate_pw)
	if (telnet_session=="999") return sprintf("Unable to connect to %s:%s",ipaddress,theport)

	if ((secure_shell==0 && node_login==1 && cpplinux!=1)||(rcli==2)) printf("%s\n%s\n",username,password) |& telnet_session
	else if (comcli_val>0)
	{
		if (node_login==0 || linux_shell==2)
		{
			telnet_session |& getline
			if (mosdebug==1) print "Debug: "$0
			#ssh: connect to host a.b.c.d port 20: Connection timed out
			#ssh: connect to host a.b.c.d port 22: Connection refused
			if (/ssh: connect to host.*: Connection /)
			{
				#customPrint($0)
				close(telnet_session)
				return sprintf("Unable to connect to %s:%s",ipaddress,theport)
			}
			login_wait+=0
			if (mosdebug==1) print "Debug: login_wait="login_wait
			if (login_wait>0)
			{
				twait=login_wait * 1000
				usleep(twait)  #setting for pico which is slower, must wait until the ssh shell is ready, otherwise the command hangs
			}
		}
		if (linux_shell>0) print "stty cols "comcli_columns" && export COLUMNS="comcli_columns" && pwd" |& telnet_session
		else
		{
			if ((ssh_port!=comcli_port) && (ssh_port!=netconf_port) && (comcli_val==1 || ssh_port==secure_port))
			{
				print "/misc/prompt -s EndOfPrint\\ncoli>" |& telnet_session
				while ((telnet_session |& getline)>0)
				{
					gsub("\r","")
					if ($1=="EndOfPrint") break
				}
				print "/misc/authlevel disabled" |& telnet_session
			}
			else if (comcli_val==2 || ssh_port==comcli_port || ssh_port==netconf_port)
			{
				if (epg_ssr==1)
				{
					while ((telnet_session |& getline)>0)
					{
						#Welcome to Ericsson IPOS
						#Copyright (c) 2011 Ericsson AB.
						#All rights reserved.
						#Hello from Router 6274
						if (mosdebug==1) print "Debug: "$0
						if (/Welcome|Copyright|reserved|Hello from Router/) break
						else if (/Permission denied \([^ ]*\).|Login failed\.|Permission denied$|Login incorrect|Authentication with COM failed|Authentication failed/)
						{
							close(telnet_session)
							return "!!!!Wrong Password or Username!!!!"
						}
					}
					if (comcli_val==2)
					{
						nok=0
						print "start oam-cli"    |& telnet_session
						while ((telnet_session |& getline)>0)
						{
							gsub("\r","") ; gsub("\x00","")
							if (mosdebug==1) print "Debug: "$0
							if ($1=="(exec)") break
							if (/IF YOU ARE NOT AN AUTHORIZED USER/) break
							if (/Connection to COM failed|Connection refused/) { nok=1 ; break }
						}
						if (nok==1)
						{
							print "exit" |& telnet_session
							while ((telnet_session |& getline)>0) {}
							close(telnet_session)
							return "!!!!Wrong Password or Username!!!!"
						}
						print "width "comcli_columns |& telnet_session
						print "length"    |& telnet_session
					}
					else return telnet_session
				}
				else
				{
					print "width "comcli_columns |& telnet_session
					print "length"    |& telnet_session
				}
				com_noprint=1
			}
		}
	}
	else if (lincli==3) print "\r\n\r\nmml\r" |& telnet_session
	if (mosdebug==1) print "Debug: "telnet_session > "/dev/stderr"
	while ((telnet_session |& getline)>0)
	{
		gsub("\r","") ; gsub("\x00","")
		if (comcli_val>0) remove_colors()
		if (mosdebug==1) print "Debug: "$0 > "/dev/stderr"
		#if (ssh_debug>0 && $1~/^debug[1-3]:$/) continue
		if (cpplinux==1 && /Wind River Linux|Welcome to Shell on Evo8300/)
		{
			if (secure_shell==0)
			{
				tsleep(1)
				print username |& telnet_session
				tsleep(1)
				print node_password |& telnet_session
				tsleep(1)
			}
			if (no_access_to_os!=1) print "export COLUMNS="comcli_columns" && export PS1=\"$ \" && export BASHOPTS" |& telnet_session
			print "echo \"Welcome to OSE Shell ose9.0\"" |& telnet_session
			continue
		}
		if (/Welcome to OSE/)
		{
			if (cpplinux==1 && /echo "Welcome to OSE/) continue
			#Welcome to OSE Shell OSE4.6.1.
			#Welcome to OSE Shell ose5.3.
			#Welcome to OSE Shell OSE4.4.1 for simulated NE RNC14
			ose_version=gensub(/^.*welcome to ose shell ose|\.[^0-9]*$/,"","g",tolower($0))
			return telnet_session
		}
		else if (comcli_val>0 && /^(\/|ok$|>?length [0-9]|EndOfPrint$)/)  #removed this:    Last login: |All rights reserved.|
		{
			#When linux_shell > 0 (pico and stand-alone COM) we use the current working directory shown by pwd command, eg: /home/comuser
			#when linux_shell = 0 and comcli=2 (G2 and APG) we use the length command
			#when linux_shell = 0 and comcli=1 (G2) we use the EndOfPrint prompt of RCS COLI
			if (linux_shell==0 && $0 !~ /length [0-9]/ && (comcli_val==2 || ssh_port==comcli_port)) continue # in this case we had run the length command so we have to wait for that line
			if (comcli_val==2) axenode="SIU"
			#print telnet_session
			return telnet_session
		}
		else if (NF > 2 && $(NF-1) == "PAGE")
		{
			axenode=gensub(/^[^A-Z]+/,"",1,$0)
			if (lincli==3) sub(/^.*>/,"",axenode)
			return telnet_session
		}
		#else if (rcli==3)
		#{
		#	if ($0~/connected from .* using ssh on/)
		#	{
		#		#EPG
		#		#cnom connected from a.b.c.d using ssh on EPG91
		#		usleep(1000000)
		#		print "paginate false" |& telnet_session
		#		return telnet_session
		#	}
		#}
		else if ($0~/STN CLI - ready|Console - monitor connection ready/ || (rcli>0 && $0~/IF YOU ARE NOT AN AUTHORIZED USER, PLEASE EXIT IMMEDIATELY|All rights reserved|^Previous login was at/))
		{
			#SIU/TCU: STN CLI - ready
			#ESC: IF YOU ARE NOT AN AUTHORIZED USER, PLEASE EXIT IMMEDIATELY
			#Router6000: All rights reserved
			#Mini-link: Previous login was at:
			axenode="SIU"
			return telnet_session
		}
		else if (/ssh_exchange_identification: Connection closed by remote host|Connection timed out during banner exchange/)
		{
			close(telnet_session)
			return sprintf("%s\nUnable to connect to %s:%s",$0,ipaddress,theport)
		}
		else if (/Offending key|you have requested strict checking|Add correct host key in|ssh: fatal|Connection closed by |version .* not found /)
		{
			customPrint($0)
			close(telnet_session)
			return sprintf("Unable to connect to %s:%s",ipaddress,theport)
		}
		else if (/PRNG is not seeded/)
		{
			customPrint($0)
			close(telnet_session)
			if (os ~ /^sun/) customPrint(sprintf("\
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\
The device /dev/random is probably missing. Please install the patch 112438-03. Instructions:\n\
 - download the file http://newtran01.au.ao.ericsson.se/moshell/112438-03.zip to /tmp\n\
 - cd /tmp\n\
 - unzip 112438-03.zip\n\
 - su -     #(login as root)\n\
 - cd /tmp\n\
 - /usr/sbin/patchadd 112438-03  \n\
 - /usr/sbin/shutdown -i6   #(to reboot the system)\n\
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"))
			return sprintf("Unable to connect to %s:%s",ipaddress,theport)
		}
		else if (/Permission denied \([^ ]*\).|Login failed\.|Permission denied$|Login incorrect|Authentication with COM failed|Authentication failed|Your account has expired.*contact your /)
		{
			close(telnet_session)
			if (/Your account has expired.*contact your /) customPrint($0)
			#if (/Authentication with COM failed/) customPrint($0)
			return "!!!!Wrong Password"((comcli>0||cpplinux==1||cppAA==1)?" or Username":"")"!!!!"
		}
		else if (/failed|ssh: connect to host [^ \t]+ port [0-9]+: /)
		{
			#ssh: connect to host a.b.c.d port 20: Connection timed out
			#ssh: connect to host a.b.c.d port 22: Connection refused
			customPrint($0)
			close(telnet_session)
			return sprintf("Unable to connect to %s:%s",ipaddress,theport)
		}
		else if (validate_pw=="validate_pw" && $0~/WARNING: The password could be compromised|Warning: Please change your password./) login_warning=$0
		else if (validate_pw=="validate_pw" && cpplinux==1 && $0~/^You must change your password now and login again!/)
		{
			LoginFailedError="The password is expired. Please change your password from a ssh session."
			close(telnet_session)
			return "!!!!Wrong Password!!!!"
		}
		else if (NF > 0) error_text=error_text $0 "\n"
	}
	customPrint(error_text)
	close(telnet_session)
	return sprintf("Unable to connect to %s:%s",ipaddress,theport)
}
function nc_validation(theip,theport,  command,thefile,res,line,fileList,n,i,tfile)
{
	res=0
	if (!(comcli>0 && use_tls>0 && nc_validate==1 && (theport==s_comcli_port || theport==s_secure_port))) return 0
	if (ncValidated[theip,theport]==1) return 0
	if (check_openssl_version() !~ /^[1-9]/)
	{
		customPrint("ERROR: Node Credential validation not supported on openssl version lower than 1.0.0")
		return nc_validation_error()
	}
	thefile=sprintf("%s/allrootcafiles.pem",tempdir)
	fileOps("rm "thefile)
	#system(sprintf("cat %s/* > %s 2>&1",ca_folder,thefile))
	if (fileOps("test -d "ca_folder)!=0)
	{
		customPrint("ERROR: invalid ca_folder "ca_folder)
		return nc_validation_error()
	}
	n=fileOps("ls "ca_folder,fileList)
	for (i=1;i<=n;i++)
	{
		tfile=ca_folder"/"fileList[i]
		if (tfile!~/\.pem$/) continue
		if (fileOps("test -s "tfile)!=0) continue
		while (getline line < tfile)
		{
			gsub("\r","",line)
			print line >> thefile
		}
		close(tfile)
		close(thefile)
	}
	#if (mosdebug==1) system("cat "thefile)
	command=sprintf("%s s_client %s-connect %s:%s -CAfile %s -time_connection %s -time_session %s 2>&1",openssl,make_tlsflags(),put_brackets(theip),theport,thefile,ip_connection_timeout,ip_inactivity_timeout)
	if (mosdebug==1) print command
	while (command |& getline line)
	{
		#if (mosdebug==1) print line
		if (line ~ /Verify return code: 0/) res=1
	}
	close(command)
	ncValidated[theip,theport]=res
	if (res==1)
	{
		customPrint(sprintf("Node Credential validated ok.",theport))
		return 0
	}
	else
	{
		customPrint("Node Credential validation failure!")
		return nc_validation_error()
	}
}
function nc_validation_error()
{
	nr_login_attempts++
	if (max_login_attempts>0 && nr_login_attempts>=max_login_attempts) exit_with_error()
	return 1
}
function parse_user_variables(file,tvar,   temp_logdir,check_log_dir,array)
{
	if (fileOps("test -f "file)!=0)
	{
		customPrint("ERROR: file "file" not found.")
		return
	}
	os=check_os()
	if (tvar!="") assignCustomVar(tvar,file,"","system")
	while ((getline < file)>0)
	{
		gsub("\r","") ; gsub("\x00","") ; gsub(/(^| |\t)#.*$/,"") ; gsub(/[ \t]*$/,"")
		if (/^[ \t]*[$a-zA-Z_][ \t]*=/) gsub(/[ \t]/,"")
		$0=replace_path_variables($0)
		if ($1 == "alias" && NF>2)
		{
			if (tolower($2)=="uer") continue #forbidden to use this alias since there is already a command with this name
			aliasTable[$2]=gensub(/^[ \t]*[^ \t]+[ \t]+[^ \t]+[ \t]+/,"",1,$0)
			if (file==moshell) gsub(/ *>.*$/,"",aliasTable[$2])
			make_sortedAliasTable()
		}
		else if ($1=="lf" && NF==2) load_file("",$2)
		else if (split($0,array,"=") < 2 || $1 ~ /^#/) continue
		else declare_user_variable($0,3,file)
	}
	close(file)

	#Adaptations of the default values:
	if (file==moshell)
	{
		#On cygwin the default value of secure_ftp should be 1, ftp client (connect) does not work well at the moment, leaves hanging ftp sessions on the node, not closes properly
		#In amos the default value of secure_ftp should also be 1, TR HL89356 (security reasons)
		#In amos the default value of nm_folder should be $HOME/Ericsson/OMSec and nm_credential should be $HOME/Ericsson/OMSec/ssucredentials.xml, TR HP22281
		#Default value of secure_ftp is now changed to 1 (introduced 9.0y)
		#if (os=="cygwin" || in_amos_mode()==1) secure_ftp=1
		#On AMOS set_check should be 2 , polu_confirmupgrade should be 0, and decoder path should be /opt/ericsson/amos/decoder/decoder.pl
		if (in_amos_mode())
		{
			set_check=2
			polu_confirmupgrade=0
			decoder="/opt/ericsson/amos/decoder/decoder.pl"
			nm_folder=ENVIRON["HOME"]"/Ericsson/OMSec"
			nm_credential=ENVIRON["HOME"]"/Ericsson/OMSec/ssucredentials.xml"
			sa_credential=ENVIRON["HOME"]"/Ericsson/OMSec/sam.p12"
			#TR HQ35529
			secure_shell=1
			corba_class=5
			#CR for free disk space with df -k and ram check with vmstat
			disk_check=4
			ram_check=2
			#moshell version check is disabled on amos because usually there will be no contact to utran01 server from a OSS in customer network
			moshellversion_check=0
			#in amos the firewall may block export_method=0
			if (export_method==0) export_method=1
			os=check_os()
			if (os=="linux") amos_java="/usr/bin/java"
			#use the same path for java as amos_java -> to solve issue on OSSRC where java is older than amos_java and causes creation of small files when starting the mobrowser/alarmclient : https://wcdma-jira.rnd.ki.sw.ericsson.se/browse/WMRSUP-15455
			java=amos_java
			#TR HY22018 https://jira-oss.seli.wh.rnd.internal.ericsson.com/browse/TORF-403189
			if (os=="linux")
			{
				#In ENM, the script moshell_install is run without "-a" option so the default jarxmldir is $moshelldir/jarxml, so we change here to $HOME/jarxml
				if (ENVIRON["HOME"]!="" && system("test -d "ENVIRON["HOME"])==0) jarxmldir=ENVIRON["HOME"]"/jarxml"
			}
		}
		else
		{
			#default value of jarxmldir in moshell is $HOME/jarxml since 10.0h
			if (ENVIRON["HOME"]!="" && system("test -d "ENVIRON["HOME"])==0) jarxmldir=ENVIRON["HOME"]"/jarxml"
			secure_shell=1
		}
		#In multimode, timeout values should be shorter
		if (multi>0 && yangcli==0)
		{
			ip_connection_timeout=1
			corba_connection_timeout=3
			corba_timeout=30
		}
		if (os=="cygwin")
		{
			disk_check=0
			ram_check=0
		}
	}
	if (mosdebug==1) { print "DEBUG: processing "file ; print_user_variables() }
}
function make_sortedAliasTable(    i)
{
	delete sortedAliasTable
	for (i in aliasTable) sortedAliasTable[i]=i
	maxAlias=asort(sortedAliasTable)
}
function set_ipv6_dependencies()
{
	#currently the netcatlib only supports ipv4
	#use_netcatlib=0
	#monitor6054 only supports ipv4, use netcat for ipv6
	monclient6054=netcat
	#currently only sftp supported, not ftp
	secure_ftp=1
}
function declare_user_variable(line,command,file,   varname,varvalue,i,last,array,j,customFileList,customFileName,cat_command,n,customFiles,unixcommand,unixline,part,unixCmd,unixLine)
{
	#command is when we define a variable .
	# it can take the value 1, when we are defining a uservar from the command line
	# it can take the value 2, when we are defining a customvar from the -v option in moshell
	compulsoryRsetMoList["Aal2PathDistributionUnit"]=compulsoryRsetMoList["Program"]=1
	gsub("\r","",line) ; gsub(/(^| |\t)#.*$/,"") #gsub(/#.*$/,"",line)
	#not needed: gsub(/[ \t]*$/,"",line) ; gsub(/^[ \t]*/,"",line) ;if (/^[ \t]*[a-zA-Z_][ \t]*=/) gsub(/[ \t]/,"")
	line=replace_path_variables(line)
	split(line,array,"=")
	varname=gensub(/[ \t]*/,"","g",array[1])
	varvalue=gensub(/^[ \t]*|[ \t]*$/,"","g",gensub(/^[^=]+=/,"",1,line)) #cannot use array[2] in case the value contains "=" sign
	gsub(/^"|"$/,"",varvalue)
	if (file==moshell)
	{
		#some uservariables are not listed in the moshell file or commented out , define and set to type string
		uvName["custom_param_file"]="custom_param_file"              ; custom_param_file=custom_param_file""
		uvName["custom_upid_file"]="custom_upid_file"                ; custom_upid_file=custom_upid_file""
		uvName["dbd_exclude_attributes"]="dbd_exclude_attributes"    ; dbd_exclude_attributes=dbd_exclude_attributes""
		uvName["dbd_exclude_moclasses"]="dbd_exclude_moclasses"      ; dbd_exclude_moclasses=dbd_exclude_moclasses""
		uvName["dbd_only_moclasses"]="dbd_only_moclasses"            ; dbd_only_moclasses=dbd_only_moclasses""
		uvName["diffo_exclude_moclasses"]="diffo_exclude_moclasses"  ; diffo_exclude_moclasses=diffo_exclude_moclasses""
		uvName["moscommanddir"]="moscommanddir"                      ; moscommanddir=moscommanddir""
		uvName["pm_logdir"]="pm_logdir"                              ; pm_logdir=pm_logdir""
		uvName["portbase"]="portbase"                                ; portbase=portbase""
		uvName["prompt"]="prompt"                                    ; prompt=prompt""
		uvName["pre_prompt"]="pre_prompt"                            ; pre_prompt=pre_prompt""
		uvName["sls_password"]="sls_password"                        ; sls_password=sls_password""
		uvName["com_password"]="com_password"                        ; com_password=com_password""
		uvName["cpplinux_password"]="cpplinux_password"              ; cpplinux_password=cpplinux_password""
		uvName["sls_urls"]="sls_urls"                                ; sls_urls=sls_urls""
		uvName["blocked_commands"]="blocked_commands"                ; blocked_commands=blocked_commands""
		uvName["bocachedir"]="bocachedir"                            ; bocachedir=bocachedir""
		uvName["bocachename"]="bocachename"                          ; bocachename=bocachename""
		uvName["export_password"]="export_password"                  ; export_password=export_password""
		uvName["export_server"]="export_server"                      ; export_server=export_server""
		uvName["export_dir"]="export_dir"                            ; export_dir=export_dir""
		uvName["uv_blacklist"]="uv_blacklist"                        ; uv_blacklist=uv_blacklist""
		uvName["uv_greylist"]="uv_greylist"                          ; uv_greylist=uv_greylist""
		uvName["cluster_members"]="cluster_members"                  ; cluster_members=cluster_members""
		uvName["sa_password"]="sa_password"                          ; sa_password=sa_password""
		uvName["ssh_subsystem"]="ssh_subsystem"                      ; ssh_subsystem=ssh_subsystem""
		uvName["ssh_kexalg"]="ssh_kexalg"                            ; ssh_kexalg=ssh_kexalg""
		uvName["sftp_kexalg"]="sftp_kexalg"                          ; sftp_kexalg=sftp_kexalg""
		uvName["ssh_macs"]="ssh_macs"                                ; ssh_macs=ssh_macs""
		uvName["sftp_macs"]="sftp_macs"                              ; sftp_macs=sftp_macs""
		uvName["bbte_dir"]="bbte_dir"                                ; bbte_dir=bbte_dir""
		uvName["lttng_dir"]="lttng_dir"                              ; lttng_dir=lttng_dir""
		uvName["lttng_relayd_options"]="lttng_relayd_options"        ; lttng_relayd_options=lttng_relayd_options""
		uvName["lttng_dest"]="lttng_dest"                            ; lttng_dest=lttng_dest""
		uvName["bbte_mode"]="bbte_mode"                              ; bbte_mode=bbte_mode""
		uvName["bbte_dscp"]="bbte_dscp"                              ; bbte_dscp=bbte_dscp""
		uvName["bbte_router"]="bbte_router"                          ; bbte_router=bbte_router""
		uvName["bbte_capture_duration"]="bbte_capture_duration"      ; bbte_capture_duration=bbte_capture_duration""
		uvName["bbte_capture_size"]="bbte_capture_size"              ; bbte_capture_size=bbte_capture_size""
		uvName["bbte_capture_rotate"]="bbte_capture_rotate"          ; bbte_capture_rotate=bbte_capture_rotate""
		uvName["udp_router"]="udp_router"                            ; udp_router=udp_router""
		uvName["postgres"]="postgres"                                ; postgres=postgres""
		uvName["jacorb_ciphers"]="jacorb_ciphers"                    ; jacorb_ciphers=jacorb_ciphers""
		uvName["com_usernames"]="com_usernames"                      ; com_usernames=com_usernames""
		uvName["com_passwords"]="com_passwords"                      ; com_passwords=com_passwords""
		uvName["cpplinux_usernames"]="cpplinux_usernames"            ; cpplinux_usernames=cpplinux_usernames""
		uvName["cpplinux_passwords"]="cpplinux_passwords"            ; cpplinux_passwords=cpplinux_passwords""
		uvName["cpp_usernames"]="cpp_usernames"                      ; cpp_usernames=cpp_usernames""
		uvName["cpp_passwords"]="cpp_passwords"                      ; cpp_passwords=cpp_passwords""
		uvName["csdp_password"]="csdp_password"                      ; csdp_password=csdp_password""
		uvName["file_password"]="file_password"                      ; file_password=file_password""
		uvName["banner_text"]="banner_text"                          ; banner_text=banner_text""
		uvName["keypem"]="keypem"                                    ; keypem=keypem""
		uvName["keypass"]="keypass"                                  ; keypass=keypass""
		uvName["hc_filter_file"]="hc_filter_file"                    ; hc_filter_file=hc_filter_file""
		uvName["noset_list"]="noset_list"                            ; noset_list=noset_list""
		uvName["comcli_ropdir"]="comcli_ropdir"                      ; comcli_ropdir=comcli_ropdir""
		uvName["tz_option"]="tz_option"                              ; tz_option=tz_option""
		if (varname == "uv_blacklist")          { set_uv_blacklist(varvalue)   ; return }  #uv_blacklist can only be set from the file moshell/moshell
	}
	if (file!=moshell && varname in forbiddenUv && forbiddenUv[varname]==1) return
	if ((file==moshell || file==globmoshellrc || file==userglobmoshellrc))
	{
		if (varname=="uv_greylist") set_uv_greylist(varvalue)
	}
	else
	{
		if (varname in restrictedUv && restrictedUv[varname]==1) return
	}
	if (in_amos_mode() && file==globmoshellrc && varname=="username") return # http://newtran01.au.ao.ericsson.se/moshell/forum_viewtopic.php?4.9890
	if (in_amos_mode() && file==globmoshellrc && varname=="disk_limit_warn") return
	#print varname,varvalue
	     if (varname == "java")                     { uvName[varname]=varname ; java=                     handleSpaceInFile(varvalue,"noslash") }
	else if (varname == "jarxmldir")                { uvName[varname]=varname ; jarxmldir=                varvalue                              }
	else if (varname == "ip_database")              { uvName[varname]=varname ; ip_database=              varvalue                              }
	else if (varname == "security_method")          { uvName[varname]=varname ; security_method=          varvalue+0                            }
	else if (varname == "corba_class")              { uvName[varname]=varname ; corba_class=              varvalue+0                            }
	else if (varname == "credential")               { uvName[varname]=varname ; credential=               make_cygpath(varvalue)                }
	else if (varname == "sa_credential")            { uvName[varname]=varname ; sa_credential=            make_cygpath(varvalue)                }
	else if (varname == "sa_password")              { uvName[varname]=varname ; sa_password=              b64Dec(varvalue)                      }
	else if (varname == "nm_credential")            { uvName[varname]=varname ; nm_credential=            make_cygpath(varvalue)                }
	else if (varname == "nm_folder")                { uvName[varname]=varname ; nm_folder=                make_cygdir(varvalue)                 }
	else if (varname == "sa_folder")                { uvName[varname]=varname ; sa_folder=                make_cygdir(varvalue)                 }
	else if (varname == "ca_folder")                { uvName[varname]=varname ; ca_folder=                make_cygdir(varvalue)                 }
	else if (varname == "nc_validate")              { uvName[varname]=varname ; nc_validate=              varvalue+0                            }
	else if (varname == "tls_menu")                 { uvName[varname]=varname ; tls_menu=                 varvalue+0                            }
	else if (varname == "default_mom")              { uvName[varname]=varname ; default_mom=              varvalue                              }
	else if (varname == "python")                   { uvName[varname]=varname ; python=                   varvalue                              }
	else if (varname == "python3")                  { uvName[varname]=varname ; python3=                  varvalue                              }
	else if (varname == "expect")                   { uvName[varname]=varname ; expect=                   varvalue                              }
	else if (varname == "perl")                     { uvName[varname]=varname ; perl=                     varvalue                              }
	else if (varname == "ipv6")                     { uvName[varname]=varname ; ipv6=                     varvalue+0                            }
	else if (varname == "disk_check")               { uvName[varname]=varname ; disk_check=               varvalue+0                            }
	else if (varname == "disk_limit")               { uvName[varname]=varname ; disk_limit=               varvalue                              }
	else if (varname == "disk_limit_warn")          { uvName[varname]=varname ; disk_limit_warn=          varvalue+0                            }
	else if (varname == "disk_limit_high")          { uvName[varname]=varname ; disk_limit_high=          varvalue+0                            }
	else if (varname == "ram_check")                { uvName[varname]=varname ; ram_check=                varvalue+0                            }
	else if (varname == "ram_limit")                { uvName[varname]=varname ; ram_limit=                varvalue                              }
	else if (varname == "moshellversion_check")     { uvName[varname]=varname ; moshellversion_check=     varvalue+0                            }
	else if (varname == "moshell_max_age")          { uvName[varname]=varname ; moshell_max_age=          varvalue+0                            }
	else if (varname == "max_sessions")             { uvName[varname]=varname ; max_sessions=             varvalue+0                            }
	else if (varname == "max_sessions_all")         { uvName[varname]=varname ; max_sessions_all=         varvalue+0                            }
	else if (varname == "prompt")                   { uvName[varname]=varname ; prompt=                   varvalue                              }
	else if (varname == "prompt_attribute")         { uvName[varname]=varname ; prompt_attribute=         varvalue                              }
	else if (varname == "prompt_highlight")         { uvName[varname]=varname ; prompt_highlight=         varvalue+0                            }
	else if (varname == "prompt_color")             { uvName[varname]=varname ; prompt_color=             varvalue+0                            }
	else if (varname == "prompt_rnc")               { uvName[varname]=varname ; prompt_rnc=               varvalue+0                            }
	else if (varname == "prompt_rbs")               { uvName[varname]=varname ; prompt_rbs=               varvalue+0                            }
	else if (varname == "prompt_mgw")               { uvName[varname]=varname ; prompt_mgw=               varvalue+0                            }
	else if (varname == "prompt_case")              { uvName[varname]=varname ; prompt_case=              varvalue+0                            }
	else if (varname == "pre_prompt")               { uvName[varname]=varname ; pre_prompt=               varvalue                              }
	else if (varname == "ltall_at_start")           { uvName[varname]=varname ; ltall_at_start=           varvalue+0                            }
	else if (varname == "ltroot_at_start")          { uvName[varname]=varname ; ltroot_at_start=          varvalue+0                            }
	else if (varname == "show_colors")              { uvName[varname]=varname ; show_colors=              varvalue+0                            }
	else if (varname == "show_updated_alarms")      { uvName[varname]=varname ; show_updated_alarms=      varvalue+0                            }
	else if (varname == "show_related_alarms")      { uvName[varname]=varname ; show_related_alarms=      varvalue+0                            }
	else if (varname == "show_notified")            { uvName[varname]=varname ; show_notified=            varvalue+0                            }
	else if (varname == "show_correlation_info")    { uvName[varname]=varname ; show_correlation_info=    varvalue+0                            }
	else if (varname == "show_alarm_userlabel")     { uvName[varname]=varname ; show_alarm_userlabel=     varvalue+0                            }
	else if (varname == "show_shortduration_alarms"){ uvName[varname]=varname ; show_shortduration_alarms=varvalue+0                            }
	else if (varname == "show_du_path")             { uvName[varname]=varname ; show_du_path=             varvalue+0                            }
	else if (varname == "al_retry")                 { uvName[varname]=varname ; al_retry=                 varvalue+0                            }
	else if (varname == "set_window_title")         { uvName[varname]=varname ; set_window_title=         varvalue+0                            }
	else if (varname == "nocorba")                  { uvName[varname]=varname ; nocorba=                  varvalue+0                            }
	else if (varname == "nomo")                     { uvName[varname]=varname ; nomo=                     varvalue+0                            }
	else if (varname == "exclude_deprecated")       { uvName[varname]=varname ; exclude_deprecated=       varvalue+0                            }
	else if (varname == "exclude_preliminary")      { uvName[varname]=varname ; exclude_preliminary=      varvalue+0                            }
	else if (varname == "username")                 { uvName[varname]=varname ; username=                 varvalue                              }
	else if (varname == "smart_ts")                 { uvName[varname]=varname ; smart_ts=                 varvalue+0                            }
	else if (varname == "smart_xbm")                { uvName[varname]=varname ; smart_xbm=                varvalue+0                            }
	else if (varname == "xbm_commands")             { uvName[varname]=varname ; xbm_commands=             varvalue                              }
	else if (varname == "smart_rcscoli")            { uvName[varname]=varname ; smart_rcscoli=            varvalue+0                            }
	else if (varname == "rcscoli_commands")         { uvName[varname]=varname ; rcscoli_commands=         varvalue                              }
	else if (varname == "smart_shell")              { uvName[varname]=varname ; smart_shell=              varvalue+0                            }
	else if (varname == "smart_action")             { uvName[varname]=varname ; smart_action=             varvalue+0                            }
	else if (varname == "action_poll_params")       { uvName[varname]=varname ; action_poll_params=       varvalue                              }
	else if (varname == "smart_password")           { uvName[varname]=varname ; smart_password=           varvalue+0                            }
	else if (varname == "smart_corba")              { uvName[varname]=varname ; smart_corba=              varvalue+0                            }
	else if (varname == "smart_ipv6")               { uvName[varname]=varname ; smart_ipv6=               varvalue+0                            }
	else if (varname == "smart_sl3")                { uvName[varname]=varname ; smart_sl3=                varvalue+0                            }
	else if (varname == "standard_passwords")       { uvName[varname]=varname ; standard_passwords=       varvalue                              }
	else if (varname == "secure_shell")             { uvName[varname]=varname ; secure_shell=             varvalue+0                            }
	else if (varname == "yangcli")                  { uvName[varname]=varname ; yangcli=                  varvalue+0                            }
	else if (varname == "use_yangltfilter")         { uvName[varname]=varname ; use_yangltfilter=         varvalue+0                            }
	else if (varname == "yangltfilter")             { uvName[varname]=varname ; yangltfilter=             varvalue                              }
	else if (varname == "comcli")                   { uvName[varname]=varname ; comcli=                   varvalue+0                            }
	else if (varname == "linux_shell")              { uvName[varname]=varname ; linux_shell=              varvalue+0                            }
	else if (varname == "cliss")                    { uvName[varname]=varname ; cliss=                    varvalue                              }
	else if (varname == "smart_refresh_esi")        { uvName[varname]=varname ; smart_refresh_esi=        varvalue+0                            }
	else if (varname == "comcli_rcs_top")           { uvName[varname]=varname ; comcli_rcs_top=           varvalue+0                            }
	else if (varname == "comcli_columns")           { uvName[varname]=varname ; comcli_columns=           varvalue+0                            }
	else if (varname == "comcli_timeout")           { uvName[varname]=varname ; comcli_timeout=           varvalue+0                            }
	else if (varname == "yang_timeout")             { uvName[varname]=varname ; yang_timeout=             varvalue+0                            }
	else if (varname == "comcli_cfg")               { uvName[varname]=varname ; comcli_cfg=               varvalue                              }
	else if (varname == "comcli_model")             { uvName[varname]=varname ; comcli_model=             varvalue                              }
	else if (varname == "comcli_mom")               { uvName[varname]=varname ; comcli_mom=               varvalue+0                            }
	else if (varname == "comcli_momversion_cache")  { uvName[varname]=varname ; comcli_momversion_cache=  varvalue+0                            }
	else if (varname == "comcli_momretry_maxtime")  { uvName[varname]=varname ; comcli_momretry_maxtime=  varvalue+0                            }
	else if (varname == "comcli_momretry_interval") { uvName[varname]=varname ; comcli_momretry_interval= varvalue+0                            }
	else if (varname == "comcli_retry_maxtime")     { uvName[varname]=varname ; comcli_retry_maxtime= varvalue+0                                }
	else if (varname == "comcli_retry_interval")    { uvName[varname]=varname ; comcli_retry_interval=varvalue+0                                }
	else if (varname == "comcli_port")              { uvName[varname]=varname ; comcli_port=              varvalue+0                            }
	else if (varname == "comcli_portfile")          { uvName[varname]=varname ; comcli_portfile=          varvalue+0                            }
	else if (varname == "login_retry_interval")     { uvName[varname]=varname ; login_retry_interval=     varvalue+0                            }
	else if (varname == "comcli_portfilepath")      { uvName[varname]=varname ; comcli_portfilepath=      varvalue                              }
	else if (varname == "lincli")                   { uvName[varname]=varname ; lincli=                   varvalue+0                            }
	else if (varname == "rcli")                     { uvName[varname]=varname ; rcli=                     varvalue+0                            }
	else if (varname == "alarm_format")             { uvName[varname]=varname ; alarm_format=             varvalue+0                            }
	else if (varname == "get_format")               { uvName[varname]=varname ; get_format=               varvalue+0                            }
	else if (varname == "secure_ftp")               { uvName[varname]=varname ; secure_ftp=               varvalue+0                            }
	else if (varname == "connection_attempts")      { uvName[varname]=varname ; connection_attempts=      varvalue+0                            }
	else if (varname == "ip_connection_timeout")    { uvName[varname]=varname ; ip_connection_timeout=    varvalue+0                            }
	else if (varname == "ip_inactivity_timeout")    { uvName[varname]=varname ; ip_inactivity_timeout=    varvalue+0                            }
	else if (varname == "ftp_timeout")              { uvName[varname]=varname ; ftp_timeout=              varvalue+0                            }
	else if (varname == "http_timeout")             { uvName[varname]=varname ; http_timeout=             varvalue+0                            }
	else if (varname == "fast_timeout")             { uvName[varname]=varname ; fast_timeout=             varvalue+0                            }
	else if (varname == "gpg_retry")                { uvName[varname]=varname ; gpg_retry=                varvalue+0                            }
	else if (varname == "ssh_retry")                { uvName[varname]=varname ; ssh_retry=                varvalue+0                            }
	else if (varname == "http_retry")               { uvName[varname]=varname ; http_retry=               varvalue+0                            }
	else if (varname == "medium_timeout")           { uvName[varname]=varname ; medium_timeout=           varvalue+0                            }
	else if (varname == "netconf_timeout")          { uvName[varname]=varname ; netconf_timeout=          varvalue+0                            }
	else if (varname == "corba_timeout")            { uvName[varname]=varname ; corba_timeout=            varvalue+0                            }
	else if (varname == "corba_connection_timeout") { uvName[varname]=varname ; corba_connection_timeout= varvalue+0                            }
	else if (varname == "inactivity_timeout")       { uvName[varname]=varname ; inactivity_timeout=       varvalue+0                            }
	else if (varname == "keepalive_interval")       { uvName[varname]=varname ; keepalive_interval=       varvalue+0                            }
	else if (varname == "http_port")                { uvName[varname]=varname ; http_port=                varvalue+0                            }
	else if (varname == "telnet_port")              { uvName[varname]=varname ; telnet_port=              varvalue+0                            }
	else if (varname == "portbase")                 { uvName[varname]=varname ; portbase=                 varvalue+0                            }
	else if (varname == "yangftp_port")             { uvName[varname]=varname ; yangftp_port=             varvalue+0                            }
	else if (varname == "s_yangftp_port")           { uvName[varname]=varname ; s_yangftp_port=           varvalue+0                            }
	else if (varname == "ftp_port")                 { uvName[varname]=varname ; ftp_port=                 varvalue+0                            }
	else if (varname == "s_ftp_port")               { uvName[varname]=varname ; s_ftp_port=               varvalue+0                            }
	else if (varname == "secure_port")              { uvName[varname]=varname ; secure_port=              varvalue+0                            }
	else if (varname == "node_login")               { uvName[varname]=varname ; node_login=               varvalue+0                            }
	else if (varname == "login_wait")               { uvName[varname]=varname ; login_wait=               varvalue+0                            }
	else if (varname == "keepLmList")               { uvName[varname]=varname ; keepLmList=               varvalue                              }
	else if (varname == "bldebset_confirmation")    { uvName[varname]=varname ; bldebset_confirmation=    varvalue+0                            }
	else if (varname == "lt_confirmation")          { uvName[varname]=varname ; lt_confirmation=          varvalue+0                            }
	else if (varname == "del_confirmation")         { uvName[varname]=varname ; del_confirmation=         varvalue+0                            }
	else if (varname == "restart_confirmation")     { uvName[varname]=varname ; restart_confirmation=     varvalue+0                            }
	else if (varname == "xmlmomlist")               { uvName[varname]=varname ; xmlmomlist=               varvalue                              }
	else if (varname == "csnotiflist")              { uvName[varname]=varname ; csnotiflist=              varvalue                              }
	else if (varname == "show_timestamp")           { uvName[varname]=varname ; show_timestamp=           varvalue+0                            }
	else if (varname == "show_nodeip")              { uvName[varname]=varname ; show_nodeip=              varvalue+0                            }
	else if (varname == "transaction_timeout")      { uvName[varname]=varname ; transaction_timeout=      varvalue+0                            }
	else if (varname == "transaction_size")         { uvName[varname]=varname ; transaction_size=         varvalue+0                            }
	else if (varname == "mibmgr_threshold")         { uvName[varname]=varname ; mibmgr_threshold=         varvalue+0                            }
	else if (varname == "use_core_timeout")         { uvName[varname]=varname ; use_core_timeout=         varvalue+0                            }
	else if (varname == "core_timeout")             { uvName[varname]=varname ; core_timeout=             varvalue+0                            }
	else if (varname == "use_dbdump")               { uvName[varname]=varname ; use_dbdump=               varvalue+0                            }
	else if (varname == "fast_lh_threshold")        { uvName[varname]=varname ; fast_lh_threshold=        varvalue+0                            }
	else if (varname == "fast_lhz_threshold")       { uvName[varname]=varname ; fast_lhz_threshold=       varvalue+0                            }
	else if (varname == "fast_cab_threshold")       { uvName[varname]=varname ; fast_cab_threshold=       varvalue+0                            }
	else if (varname == "fast_coli_threshold")      { uvName[varname]=varname ; fast_coli_threshold=      varvalue+0                            }
	else if (varname == "fast_sql_threshold")       { uvName[varname]=varname ; fast_sql_threshold=       varvalue+0                            }
	else if (varname == "fast_inv_threshold")       { uvName[varname]=varname ; fast_inv_threshold=       varvalue+0                            }
	else if (varname == "inv_have_sts")             { uvName[varname]=varname ; inv_have_sts=             varvalue+0                            }
	else if (varname == "inv_have_pget")            { uvName[varname]=varname ; inv_have_pget=            varvalue+0                            }
	else if (varname == "inv_cut_cellnames")        { uvName[varname]=varname ; inv_cut_cellnames=        varvalue+0                            }
	else if (varname == "dcg_name_utc")             { uvName[varname]=varname ; dcg_name_utc=             varvalue+0                            }
	else if (varname == "dcg_no_telog")             { uvName[varname]=varname ; dcg_no_telog=             varvalue+0                            }
	else if (varname == "dcg_no_coli")              { uvName[varname]=varname ; dcg_no_coli=              varvalue+0                            }
	else if (varname == "print_lmid")               { uvName[varname]=varname ; print_lmid=               varvalue+0                            }
	else if (varname == "loginfo_print")            { uvName[varname]=varname ; loginfo_print=            varvalue+0                            }
	else if (varname == "mospace_convert")          { uvName[varname]=varname ; mospace_convert=          varvalue+0                            }
	else if (varname == "banner_text")              { uvName[varname]=varname ; banner_text=              varvalue                              }
	else if (varname == "banner_color")             { uvName[varname]=varname ; banner_color=             varvalue+0                            }
	else if (varname == "use_pmvalidate")           { uvName[varname]=varname ; use_pmvalidate=           varvalue+0                            }
	else if (varname == "use_curl")                 { uvName[varname]=varname ; use_curl=                 varvalue+0                            }
	else if (varname == "use_market_name")          { uvName[varname]=varname ; use_market_name=          varvalue+0                            }
	else if (varname == "use_babel2")               { uvName[varname]=varname ; use_babel2=               varvalue+0                            }
	else if (varname == "use_banner")               { uvName[varname]=varname ; use_banner=               varvalue+0                            }
	else if (varname == "use_complete_mom")         { uvName[varname]=varname ; use_complete_mom=         varvalue+0                            }
	else if (varname == "use_extended_mom")         { uvName[varname]=varname ; use_extended_mom=         varvalue+0                            }
	else if (varname == "use_testmomdump")          { uvName[varname]=varname ; use_testmomdump=          varvalue+0                            }
	else if (varname == "use_sfpvalues")            { uvName[varname]=varname ; use_sfpvalues=            varvalue+0                            }
	else if (varname == "use_sfpdump")              { uvName[varname]=varname ; use_sfpdump=              varvalue+0                            }
	else if (varname == "use_lhlist_check")         { uvName[varname]=varname ; use_lhlist_check=         varvalue+0                            }
	else if (varname == "translate_sequence_enum")  { uvName[varname]=varname ; translate_sequence_enum=  varvalue+0                            }
	else if (varname == "encpw_type")               { uvName[varname]=varname ; encpw_type=               varvalue+0                            }
	else if (varname == "use_netcatlib")            { uvName[varname]=varname ; use_netcatlib=            varvalue+0                            }
	else if (varname == "use_monitor6054")          { uvName[varname]=varname ; use_monitor6054=          varvalue+0                            }
	else if (varname == "use_scandir")              { uvName[varname]=varname ; use_scandir=              varvalue+0                            }
	else if (varname == "use_lhz")                  { uvName[varname]=varname ; use_lhz=                  varvalue+0                            }
	else if (varname == "pm_logdir")                { uvName[varname]=varname ; pm_logdir=                varvalue                              }
	else if (varname == "decoder")                  { uvName[varname]=varname ; decoder=                  varvalue                              }
	else if (varname == "ltedecoder")               { uvName[varname]=varname ; ltedecoder=               varvalue                              }
	else if (varname == "muteFactor")               { uvName[varname]=varname ; muteFactor=               varvalue+0                            }
	else if (varname == "mosdebug")                 { uvName[varname]=varname ; mosdebug=                 varvalue+0                            }
	else if (varname == "corba_debug")              { uvName[varname]=varname ; corba_debug=              varvalue+0                            }
	else if (varname == "tls_debug")                { uvName[varname]=varname ; tls_debug=                varvalue+0                            }
	else if (varname == "ssh_debug")                { uvName[varname]=varname ; ssh_debug=                varvalue+0                            }
	else if (varname == "polu_confirmupgrade")      { uvName[varname]=varname ; polu_confirmupgrade=      varvalue+0                            }
	else if (varname == "pm_wait")                  { uvName[varname]=varname ; pm_wait=                  varvalue+0                            }
	else if (varname == "include_nonpm")            { uvName[varname]=varname ; include_nonpm=            varvalue+0                            }
	else if (varname == "editor")                   { uvName[varname]=varname ; editor=                   varvalue                              }
	else if (varname == "polyversion")              { uvName[varname]=varname ; polyversion=              varvalue+0                            }
	else if (varname == "moscommandlog")            { uvName[varname]=varname ; moscommandlog=            varvalue+0                            }
	else if (varname == "moscommanddir")            { uvName[varname]=varname ; moscommanddir=            varvalue                              }
	else if (varname == "moscommandsize")           { uvName[varname]=varname ; moscommandsize=           varvalue+0                            }
	else if (varname == "keep_history_lines")       { uvName[varname]=varname ; keep_history_lines=       varvalue+0                            }
	else if (varname == "set_check")                { uvName[varname]=varname ; set_check=                varvalue+0                            }
	else if (varname == "custom_param_file")        { uvName[varname]=varname ; custom_param_file=        varvalue ; orig_custom_param_file= "" }
	else if (varname == "custom_upid_file")         { uvName[varname]=varname ; custom_upid_file=         varvalue ; orig_custom_upid_file= ""  }
	else if (varname == "show_userlabel")           { uvName[varname]=varname ; show_userlabel=           varvalue+0                            }
	else if (varname == "safe_syntax")              { uvName[varname]=varname ; safe_syntax=              varvalue+0                            }
	else if (varname == "sort_proxy")               { uvName[varname]=varname ; sort_proxy=               varvalue+0                            }
	else if (varname == "sql_port")                 { uvName[varname]=varname ; sql_port=                 varvalue+0                            }
	else if (varname == "sql_range")                { uvName[varname]=varname ; sql_range=                varvalue+0                            }
	else if (varname == "sql_random")               { uvName[varname]=varname ; sql_random=               varvalue+0                            }
	else if (varname == "sl3")                      { uvName[varname]=varname ; sl3=                      varvalue+0                            }
	else if (varname == "sls_username")             { uvName[varname]=varname ; sls_username=             varvalue                              }
	else if (varname == "sls_password")             { uvName[varname]=varname ; sls_password=             b64Dec(varvalue)                      }
	else if (varname == "com_username")             { uvName[varname]=varname ; com_username=             varvalue                              }
	else if (varname == "com_password")             { uvName[varname]=varname ; com_password=             b64Dec(varvalue)                      }
	else if (varname == "yang_username")            { uvName[varname]=varname ; yang_username=            varvalue                              }
	else if (varname == "yang_password")            { uvName[varname]=varname ; yang_password=            b64Dec(varvalue)                      }
	else if (varname == "cpplinux_username")        { uvName[varname]=varname ; cpplinux_username=        varvalue                              }
	else if (varname == "cpplinux_password")        { uvName[varname]=varname ; cpplinux_password=        b64Dec(varvalue)                      }
	else if (varname == "com_usernames")            { uvName[varname]=varname ; com_usernames=            varvalue                              }
	else if (varname == "com_passwords")            { uvName[varname]=varname ; com_passwords=            varvalue                              }
	else if (varname == "cpplinux_usernames")       { uvName[varname]=varname ; cpplinux_usernames=       varvalue                              }
	else if (varname == "cpplinux_passwords")       { uvName[varname]=varname ; cpplinux_passwords=       varvalue                              }
	else if (varname == "cpp_usernames")            { uvName[varname]=varname ; cpp_usernames=            varvalue                              }
	else if (varname == "cpp_passwords")            { uvName[varname]=varname ; cpp_passwords=            varvalue                              }
	else if (varname == "sls_urls")                 { uvName[varname]=varname ; sls_urls=                 varvalue                              }
	else if (varname == "pmSummary")                { uvName[varname]=varname ; pmSummary=                varvalue                              }
	else if (varname == "diffm_exclude_moclasses")  { uvName[varname]=varname ; diffm_exclude_moclasses=  varvalue                              }
	else if (varname == "diffm_exclude_attributes") { uvName[varname]=varname ; diffm_exclude_attributes= varvalue                              }
	else if (varname == "diffm_exclude_structs")    { uvName[varname]=varname ; diffm_exclude_structs=    varvalue                              }
	else if (varname == "diffo_exclude_moclasses")  { uvName[varname]=varname ; diffo_exclude_moclasses=  varvalue                              }
	else if (varname == "diffo_exclude_attributes") { uvName[varname]=varname ; diffo_exclude_attributes= varvalue                              }
	else if (varname == "dbd_exclude_moclasses")    { uvName[varname]=varname ; dbd_exclude_moclasses=    varvalue                              }
	else if (varname == "dbd_only_moclasses")       { uvName[varname]=varname ; dbd_only_moclasses=       varvalue                              }
	else if (varname == "dbd_exclude_attributes")   { uvName[varname]=varname ; dbd_exclude_attributes=   varvalue                              }
	else if (varname == "amos_debug")               { uvName[varname]=varname ; amos_debug=               b2i(varvalue)                         }
	else if (varname == "amos_java")                { uvName[varname]=varname ; amos_java=                varvalue                              }
	else if (varname == "amos_process_logging")     { uvName[varname]=varname ; amos_process_logging=     varvalue                              }
	else if (varname == "amos_log_interval")        { uvName[varname]=varname ; amos_log_interval=        varvalue+0                            }
	else if (varname == "amos_enm_accountlookup")   { uvName[varname]=varname ; amos_enm_accountlookup=   varvalue+0                            }
	else if (varname == "sls_timeout")              { uvName[varname]=varname ; sls_timeout=              varvalue+0                            }
	else if (varname == "max_poll_time")            { uvName[varname]=varname ; max_poll_time=            varvalue+0                            }
	else if (varname == "emcli")                    { uvName[varname]=varname ; emcli=                    varvalue                              }
	else if (varname == "rop_period")               { uvName[varname]=varname ; rop_period=               varvalue+0                            }
	else if (varname == "sshd_port")                { uvName[varname]=varname ; sshd_port=                varvalue+0                            }
	else if (varname == "sshd_range")               { uvName[varname]=varname ; sshd_range=               varvalue+0                            }
	else if (varname == "sshd_random")              { uvName[varname]=varname ; sshd_random=              varvalue+0                            }
	else if (varname == "use_bocache")              { uvName[varname]=varname ; use_bocache=              varvalue+0                            }
	else if (varname == "bocachedir")               { uvName[varname]=varname ; bocachedir=               varvalue                              }
	else if (varname == "bocachename")              { uvName[varname]=varname ; bocachename=              varvalue                              }
	else if (varname == "command_restriction")      { uvName[varname]=varname ; command_restriction=      varvalue+0                            }
	else if (varname == "blocked_commands")         { uvName[varname]=varname ; blocked_commands=         varvalue                              }
	else if (varname == "mosalarm")                 { uvName[varname]=varname ; mosalarm=                 varvalue+0                            }
	else if (varname == "max_login_attempts")       { uvName[varname]=varname ; max_login_attempts=       varvalue+0                            }
	else if (varname == "netconf_port")             { uvName[varname]=varname ; netconf_port=             varvalue+0                            }
	else if (varname == "netconfyang_port")         { uvName[varname]=varname ; netconfyang_port=         varvalue+0                            }
	else if (varname == "use_netconf")              { uvName[varname]=varname ; use_netconf=              varvalue+0                            }
	else if (varname == "smart_export")             { uvName[varname]=varname ; smart_export=             varvalue+0                            }
	else if (varname == "flex_export")              { uvName[varname]=varname ; flex_export=              varvalue+0                            }
	else if (varname == "export_method")            { uvName[varname]=varname ; export_method=            varvalue+0                            }
	else if (varname == "export_username")          { uvName[varname]=varname ; export_username=          varvalue                              }
	else if (varname == "export_password")          { uvName[varname]=varname ; export_password=          b64Dec(varvalue)                      }
	else if (varname == "export_server")            { uvName[varname]=varname ; export_server=            varvalue                              }
	else if (varname == "export_protocol")          { uvName[varname]=varname ; export_protocol=          varvalue+0                            }
	else if (varname == "export_dir")               { uvName[varname]=varname ; export_dir=               varvalue                              }
	else if (varname == "export_timeout")           { uvName[varname]=varname ; export_timeout=           varvalue+0                            }
	else if (varname == "export_port")              { uvName[varname]=varname ; export_port=              varvalue+0                            }
	else if (varname == "export_wait")              { uvName[varname]=varname ; export_wait=              varvalue+0                            }
	#else if (varname == "export_s_port")            { uvName[varname]=varname ; export_s_port=            varvalue+0                            }
	else if (varname == "coli_shell")               { uvName[varname]=varname ; coli_shell=               varvalue+0                            }
	else if (varname == "linux_username")           { uvName[varname]=varname ; linux_username=           varvalue                              }
	else if (varname == "linux_password")           { uvName[varname]=varname ; linux_password=           b64Dec(varvalue)                      }
	#else if (varname == "smart_connect")            { uvName[varname]=varname ; smart_connect=            varvalue+0                            }
	#else if (varname == "coli_confirmation")        { uvName[varname]=varname ; coli_confirmation=        varvalue+0                            }
	else if (varname == "java_options")             { uvName[varname]=varname ; java_options=             varvalue                              }
	else if (varname == "smart_comcli")             { uvName[varname]=varname ; smart_comcli=             varvalue+0                            }
	else if (varname == "smart_secure")             { uvName[varname]=varname ; smart_secure=             varvalue+0                            }
	else if (varname == "smart_http")               { uvName[varname]=varname ; smart_http=               varvalue+0                            }
	else if (varname == "comcli_mompath")           { uvName[varname]=varname ; comcli_mompath=           varvalue                              }
	else if (varname == "ftp_preserveprops")        { uvName[varname]=varname ; ftp_preserveprops=        varvalue+0                            }
	else if (varname == "corba_port")               { uvName[varname]=varname ; corba_port=               varvalue+0                            }
	else if (varname == "s_corba_port")             { uvName[varname]=varname ; s_corba_port=             varvalue+0                            }
	else if (varname == "corba_orbinit")            { uvName[varname]=varname ; corba_orbinit=            varvalue+0                            }
	else if (varname == "s_comcli_port")            { uvName[varname]=varname ; s_comcli_port=            varvalue+0                            }
	else if (varname == "s_secure_port")            { uvName[varname]=varname ; s_secure_port=            varvalue+0                            }
	else if (varname == "s_netconf_port")           { uvName[varname]=varname ; s_netconf_port=           varvalue+0                            }
	else if (varname == "s_netconfyang_port")       { uvName[varname]=varname ; s_netconfyang_port=       varvalue+0                            }
	else if (varname == "use_tls")                  { uvName[varname]=varname ; use_tls=                  varvalue+0                            }
	else if (varname == "use_ftps")                 { uvName[varname]=varname ; use_ftps=                 varvalue+0                            }
	else if (varname == "clientpem")                { uvName[varname]=varname ; clientpem=                varvalue                              }
	else if (varname == "capem")                    { uvName[varname]=varname ; capem=                    varvalue                              }
	else if (varname == "keypem")                   { uvName[varname]=varname ; keypem=                   varvalue                              }
	else if (varname == "keypass")                  { uvName[varname]=varname ; keypass=                  varvalue                              }
	else if (varname == "use_crn")                  { uvName[varname]=varname ; use_crn=                  varvalue+0                            }
	else if (varname == "use_lhv")                  { uvName[varname]=varname ; use_lhv=                  varvalue+0                            }
	else if (varname == "show_takeseffect")         { uvName[varname]=varname ; show_takeseffect=         varvalue+0                            }
	else if (varname == "no_crn")                   { uvName[varname]=varname ; no_crn=                   varvalue                              }
	else if (varname == "s_http_port")              { uvName[varname]=varname ; s_http_port=              varvalue+0                            }
	else if (varname == "secure_http")              { uvName[varname]=varname ; secure_http=              varvalue+0                            }
	else if (varname == "cluster_members")          { uvName[varname]=varname ; cluster_members=          varvalue                              }
	else if (varname == "ir_nosync")                { uvName[varname]=varname ; ir_nosync=                varvalue                              }
	else if (varname == "readinput_timeout")        { uvName[varname]=varname ; readinput_timeout=        varvalue+0                            }
	else if (varname == "http_version")             { uvName[varname]=varname ; http_version=             varvalue+0                            }
	else if (varname == "anon_ue")                  { uvName[varname]=varname ; anon_ue=                  varvalue+0                            }
	else if (varname == "use_lin64")                { uvName[varname]=varname ; use_lin64=                varvalue+0                            }
	else if (varname == "esci")                     { uvName[varname]=varname ; esci=                     varvalue+0                            }
	else if (varname == "ssh_subsystem")            { uvName[varname]=varname ; ssh_subsystem=            varvalue                              }
	else if (varname == "ssh_kexalg")               { uvName[varname]=varname ; ssh_kexalg=               varvalue                              }
	else if (varname == "sftp_kexalg")              { uvName[varname]=varname ; sftp_kexalg=              varvalue                              }
	else if (varname == "ssh_macs")                 { uvName[varname]=varname ; ssh_macs=                 varvalue                              }
	else if (varname == "sftp_macs")                { uvName[varname]=varname ; sftp_macs=                varvalue                              }
	else if (varname == "bbte_dscp")                { uvName[varname]=varname ; bbte_dscp=                varvalue                              }
	else if (varname == "bbte_mode")                { uvName[varname]=varname ; bbte_mode=                varvalue                              }
	else if (varname == "bbte_capture_duration")    { uvName[varname]=varname ; bbte_capture_duration=    varvalue                              }
	else if (varname == "bbte_capture_size")        { uvName[varname]=varname ; bbte_capture_size=        varvalue                              }
	else if (varname == "bbte_capture_rotate")      { uvName[varname]=varname ; bbte_capture_rotate=      varvalue                              }
	else if (varname == "check_numeric_hostname")   { uvName[varname]=varname ; check_numeric_hostname=   varvalue+0                            }
	else if (varname == "lttng_localhost")          { uvName[varname]=varname ; lttng_localhost=          varvalue+0                            }
	else if (varname == "lttng_dest")               { uvName[varname]=varname ; lttng_dest=               varvalue                              }
	else if (varname == "lttng_relayd_options")     { uvName[varname]=varname ; lttng_relayd_options=     varvalue                              }
	else if (varname == "lttng_dir")                { uvName[varname]=varname ; lttng_dir=                varvalue                              }
	else if (varname == "bbte_dir")                 { uvName[varname]=varname ; bbte_dir=                 varvalue                              }
	else if (varname == "lttng_flush_cpp")          { uvName[varname]=varname ; lttng_flush_cpp=          varvalue+0                            }
	else if (varname == "lttng_flush_rcs")          { uvName[varname]=varname ; lttng_flush_rcs=          varvalue+0                            }
	else if (varname == "lttng_buff_cpp")           { uvName[varname]=varname ; lttng_buff_cpp=           varvalue                              }
	else if (varname == "lttng_buff_rcs")           { uvName[varname]=varname ; lttng_buff_rcs=           varvalue                              }
	else if (varname == "lttng_tracefilesize_cpp")  { uvName[varname]=varname ; lttng_tracefilesize_cpp=  varvalue+0                            }
	else if (varname == "lttng_tracefilesize_rcs")  { uvName[varname]=varname ; lttng_tracefilesize_rcs=  varvalue+0                            }
	else if (varname == "lttng_tracefilecount_cpp") { uvName[varname]=varname ; lttng_tracefilecount_cpp= varvalue+0                            }
	else if (varname == "lttng_tracefilecount_rcs") { uvName[varname]=varname ; lttng_tracefilecount_rcs= varvalue+0                            }
	else if (varname == "lttng_fdpoolsize_cpp")     { uvName[varname]=varname ; lttng_fdpoolsize_cpp=     varvalue+0                            }
	else if (varname == "lttng_fdpoolsize_rcs")     { uvName[varname]=varname ; lttng_fdpoolsize_rcs=     varvalue+0                            }
	else if (varname == "lttng_workingdir_cpp")     { uvName[varname]=varname ; lttng_workingdir_cpp=     varvalue                              }
	else if (varname == "lttng_workingdir_rcs")     { uvName[varname]=varname ; lttng_workingdir_rcs=     varvalue                              }
	else if (varname == "lttng_groupbysession_cpp") { uvName[varname]=varname ; lttng_groupbysession_cpp= varvalue+0                            }
	else if (varname == "lttng_groupbysession_rcs") { uvName[varname]=varname ; lttng_groupbysession_rcs= varvalue+0                            }
	else if (varname == "lttng_keepalive")          { uvName[varname]=varname ; lttng_keepalive=          varvalue+0                            }
	else if (varname == "lttng_keepalive_time")     { uvName[varname]=varname ; lttng_keepalive_time=     varvalue+0                            }
	else if (varname == "lttng_keepalive_probes")   { uvName[varname]=varname ; lttng_keepalive_probes=   varvalue+0                            }
	else if (varname == "lttng_keepalive_intvl")    { uvName[varname]=varname ; lttng_keepalive_intvl=    varvalue+0                            }
	else if (varname == "lttng_nwsocket_timeout")   { uvName[varname]=varname ; lttng_nwsocket_timeout=   varvalue+0                            }
	else if (varname == "udp_router")               { uvName[varname]=varname ; udp_router=               varvalue                              }
	else if (varname == "bbte_router")              { uvName[varname]=varname ; bbte_router=              varvalue                              }
	else if (varname == "bbte_buffer_rate")         { uvName[varname]=varname ; bbte_buffer_rate=         varvalue+0                            }
	else if (varname == "bbte_port")                { uvName[varname]=varname ; bbte_port=                varvalue+0                            }
	else if (varname == "search_listme")            { uvName[varname]=varname ; search_listme=            varvalue+0                            }
	else if (varname == "lttng_port")               { uvName[varname]=varname ; lttng_port=               varvalue+0                            }
	else if (varname == "lttng_range")              { uvName[varname]=varname ; lttng_range=              varvalue+0                            }
	else if (varname == "use_dbcv")                 { uvName[varname]=varname ; use_dbcv=                 varvalue+0                            }
	else if (varname == "epg_ssr")                  { uvName[varname]=varname ; epg_ssr=                  varvalue+0                            }
	else if (varname == "postgres")                 { uvName[varname]=varname ; postgres=                 varvalue                              }
	else if (varname == "comcli_netconf_set")       { uvName[varname]=varname ; comcli_netconf_set=       varvalue+0                            }
	else if (varname == "comcli_netconf_del")       { uvName[varname]=varname ; comcli_netconf_del=       varvalue+0                            }
	else if (varname == "comcli_netconf_cre")       { uvName[varname]=varname ; comcli_netconf_cre=       varvalue+0                            }
	else if (varname == "comcli_netconf_pcr")       { uvName[varname]=varname ; comcli_netconf_pcr=       varvalue+0                            }
	else if (varname == "comcli_netconf_acc")       { uvName[varname]=varname ; comcli_netconf_acc=       varvalue+0                            }
	else if (varname == "use_nosetmany")            { uvName[varname]=varname ; use_nosetmany=            varvalue+0                            }
	else if (varname == "nosetmany_list")           { uvName[varname]=varname ; nosetmany_list=           varvalue                              }
	else if (varname == "use_nodelete")             { uvName[varname]=varname ; use_nodelete=             varvalue+0                            }
	else if (varname == "use_nolock")               { uvName[varname]=varname ; use_nolock=               varvalue+0                            }
	else if (varname == "nodelete_list")            { uvName[varname]=varname ; nodelete_list=            varvalue                              }
	else if (varname == "nolock_list")              { uvName[varname]=varname ; nolock_list=              varvalue                              }
	else if (varname == "use_default_jacorb")       { uvName[varname]=varname ; use_default_jacorb=       varvalue+0                            }
	else if (varname == "jacorb_ciphers")           { uvName[varname]=varname ; jacorb_ciphers=           varvalue                              }
	else if (varname == "use_jacorb_ciphers")       { uvName[varname]=varname ; use_jacorb_ciphers=       varvalue+0                            }
	else if (varname == "is_netsim")                { uvName[varname]=varname ; is_netsim=                varvalue+0                            }
	else if (varname == "catch_ctrl_c")             { uvName[varname]=varname ; catch_ctrl_c=             varvalue+0                            }
	else if (varname == "csdp_username")            { uvName[varname]=varname ; csdp_username=            varvalue                              }
	else if (varname == "csdp_password")            { uvName[varname]=varname ; csdp_password=            b64Dec(varvalue)                      }
	else if (varname == "file_password")            { uvName[varname]=varname ; file_password=            b64Dec(varvalue)                      }
	else if (varname == "esi_nr_bbdumpkeep")        { uvName[varname]=varname ; esi_nr_bbdumpkeep=        varvalue+0                            }
	else if (varname == "hc_filter_file")           { uvName[varname]=varname ; hc_filter_file=           varvalue                              }
	else if (varname == "pm_format")                { uvName[varname]=varname ; pm_format=                varvalue+0                            }
	else if (varname == "gs_gsg")                   { uvName[varname]=varname ; gs_gsg=                   varvalue+0                            }
	else if (varname == "diagw_sa_ipv6")            { uvName[varname]=varname ; diagw_sa_ipv6=            varvalue                              }
	else if (varname == "diagw_sa_ipv4")            { uvName[varname]=varname ; diagw_sa_ipv4=            varvalue                              }
	else if (varname == "diagw_ca")                 { uvName[varname]=varname ; diagw_ca=                 varvalue                              }
	else if (varname == "diagw_rootca")             { uvName[varname]=varname ; diagw_rootca=             varvalue                              }
	else if (varname == "diagw_connection_service_port")      { uvName[varname]=varname ; diagw_connection_service_port=         varvalue+0     }
	else if (varname == "diagw_connection_service_num_ports") { uvName[varname]=varname ; diagw_connection_service_num_ports=    varvalue+0     }
	else if (varname == "diagw_port")               { uvName[varname]=varname ; diagw_port=               varvalue+0                            }
	else if (varname == "diagw_range")              { uvName[varname]=varname ; diagw_range=              varvalue+0                            }
	else if (varname == "diagw_cert")               { uvName[varname]=varname ; diagw_cert=               varvalue                              }
	else if (varname == "diagw_key")                { uvName[varname]=varname ; diagw_key=                varvalue                              }
	else if (varname == "diagw_binpath")            { uvName[varname]=varname ; diagw_binpath=            varvalue                              }
	else if (varname == "tz_option")                { uvName[varname]=varname ; tz_option=                varvalue                              }
	else if (varname == "trg_search_count")         { uvName[varname]=varname ; trg_search_count=         varvalue+0                            }
	else if (varname == "use_noset")                { uvName[varname]=varname ; use_noset=                varvalue+0                            }
	else if (varname == "noset_list")               { uvName[varname]=varname ; noset_list=               varvalue                              }
	else if (varname == "set_checkflag")            { uvName[varname]=varname ; set_checkflag=            varvalue+0                            }
	else if (varname == "mosdebug_special")         { uvName[varname]=varname ; mosdebug_special=         varvalue+0                            }
	else if (varname == "cpplaad")                  { uvName[varname]=varname ; cpplaad=                  varvalue+0                            }
	else if (varname == "smart_cpplaad")            { uvName[varname]=varname ; smart_cpplaad=            varvalue+0                            }
	else if (varname == "sdi_fibercheck_maxlength") { uvName[varname]=varname ; sdi_fibercheck_maxlength= varvalue+0                            }
	else if (varname == "sdi_fibercheck_maxloss")   { uvName[varname]=varname ; sdi_fibercheck_maxloss=   varvalue+0                            }
	else if (varname == "comcli_ropdir")            { uvName[varname]=varname ; comcli_ropdir=            varvalue                              }
	else if (varname == "comcli_ropdate")           { uvName[varname]=varname ; comcli_ropdate=           varvalue+0                            }
	else if (varname == "lgg_compress")             { uvName[varname]=varname ; lgg_compress=             varvalue+0                            }
	else if (varname == "lgg_showno")               { uvName[varname]=varname ; lgg_showno=               varvalue+0                            }
	else if (varname == "lgg_intervals")            { uvName[varname]=varname ; lgg_intervals=            varvalue                              }
	else if (varname == "sysconwrite")              { uvName[varname]=varname ; sysconwrite=              varvalue                              }
	else if (varname == "oran_poll")                { uvName[varname]=varname ; oran_poll=                varvalue+0                            }
	else if (varname == "use_hcrule_filter")        { uvName[varname]=varname ; use_hcrule_filter=        varvalue+0                            }
	else if (varname == "hcrule_filter_list")       { uvName[varname]=varname ; hcrule_filter_list=       varvalue                              }
	else if (varname == "use_keyboard_interactive") { uvName[varname]=varname ; use_keyboard_interactive= varvalue+0                            }
	else if (varname == "mobatch_max_p_option")     { uvName[varname]=varname ; mobatch_max_p_option=     varvalue+0                            }
	else if (varname == "mobatch_max_nodes")        { uvName[varname]=varname ; mobatch_max_nodes=        varvalue+0                            }
	else if (varname == "mobatch_max_processes")    { uvName[varname]=varname ; mobatch_max_processes=    varvalue+0                            }
	else if (varname == "mobatch_i_option")         { uvName[varname]=varname ; mobatch_i_option=         varvalue+0                            }
	#else if (varname == "pmrdebug")                 { uvName[varname]=varname ; pmrdebug=                 varvalue+0                            }
	else if (command==1)
	{
		customPrint("\nInvalid user variable. Check the moshell file to view the list of user variables.")
		return
	}
	else if (command==2)
	{
		if (varname=="password") assignCustomVar(sprintf("$%s",varname),varvalue,"","system")
		else assignCustomVar(sprintf("$%s",varname),varvalue)
	}
	else if (command==3 && varname ~ /^\$[a-zA-Z]/)
	{
		if (varname=="$password") assignCustomVar(sprintf("%s",varname),varvalue,"","system")
		else
		{
			if (varvalue ~ /^\x60/)
			{
				#$var=`date +%y%m%d-%H%M`
				unixCmd=varvalue
				gsub(/\x60/,"",unixCmd)
				varvalue=""
				while (unixCmd |& getline unixLine) varvalue=varvalue"\n"unixLine
				close(unixCmd)
				sub(/^\n/,"",varvalue)
			}
			assignCustomVar(sprintf("%s",varname),varvalue)
		}
	}
	if (yangcli>0 && node_address!~/^OFFLINE/) multi=1
	if (multiyang>0 && yangcli==0) yangcli=1


	if (command==1)
	{
		customPrint("\n"varname"="varvalue)
		if (varname ~ /^(prompt|prompt_highlight|prompt_color)$/) Set_prompt("",prompt)
		else if (varname == "jarxmldir") parse_common_variables()
	}

	if (varname == "get_format")
	{
		if (get_format==1) get_printoutformat="proxy"
		else get_printoutformat="noproxy"
	}
	if (varname == "gs_gsg")
	{
		if (gs_gsg==1) { gs=1 ; gsg=0 }
		else if (gs_gsg==2) { gs=0 ; gsg=1 }
		else gs=gsg=0
	}
	if (varname == "ssh_kexalg" && ssh_kexalg=="1") ssh_kexalg="ecdh-sha2-nistp256,diffie-hellman-group14-sha256"
	if (varname == "ssh_macs"   && ssh_macs=="1")   ssh_macs="hmac-sha1"

	if (varname == "rcli")
	{
		if (rcli>0)
		{
			lincli=1
			comcli=0
			smart_comcli=0
			ssh_kexalg="ecdh-sha2-nistp256,diffie-hellman-group14-sha256"
			smart_password=0
			http_port=22
		}
	}
	#comcli special values
	if (varname == "comcli")
	{
		is_netsim=0
		if (comcli==12 || comcli==30 || comcli==33) is_netsim=1
		if (is_netsim==1)
		{
			if (comcli_netconf_disabled["comcli_netconf_set"]!=1) comcli_netconf_set=1
			if (comcli_netconf_disabled["comcli_netconf_del"]!=1) comcli_netconf_del=1
			if (comcli_netconf_disabled["comcli_netconf_cre"]!=1) comcli_netconf_cre=1
			if (comcli_netconf_disabled["comcli_netconf_pcr"]!=1) comcli_netconf_pcr=1
			if (comcli_netconf_disabled["comcli_netconf_acc"]!=1) comcli_netconf_acc=1
		}

		if (comcli==10 || comcli==13)  #pico commercial
		{
			tls_menu=0 ; use_tls=0
			if (comcli==13) use_netconf=1 ; else use_netconf=0
			comcli=2 ; comcli_mom=1 ; linux_shell=0 ; comcli_port=9830 ; secure_port=9830 ; ftp_port=22 ; netconf_port=830
			ip_connection_timeout=20 #pico can be slow thus increase the timeout
			netconf_getconfig=0   #1 is quicker but may miss some MOs in the tree
			use_keyboard_interactive=0
		}
		else if (comcli==11) #pico RnD
		{
			tls_menu=0 ; use_tls=0
			comcli=1 ; cliss="/opt/com/bin/cliss,9892" ; comcli_cfg="/opt/com/etc/local/maf.cfg" ; netconf_port=830 ; use_netconf=0
			ip_connection_timeout=20 #pico can be slow thus increase the timeout
			netconf_getconfig=0
			#must also re-set the default settings in case the user has set comcli after startup with uv command
			comcli_port=9830 ; comcli_mom=-1 ; secure_port=22 ; telnet_port=22 ; linux_shell=2
			use_keyboard_interactive=0
		}
		else if (comcli==12) #NetSIM pico/BSP/DUAS/etc  (fetch MOM by sftp) and APG43L 1.x
		{
			tls_menu=0 ; use_tls=0
			comcli=2 ; comcli_mom=1 ; linux_shell=0 ; comcli_port=22 ; secure_port=22 ; ftp_port=22 ; use_netconf=0 ; comcli_mompath="/SysMMimSchemas"
			netconf_getconfig=0
			use_keyboard_interactive=1
		}
		else if (comcli==30 || comcli==33) #NetSIM pico/BSP/DUAS/etc (fetch MOM by export)
		{
			tls_menu=0 ; use_tls=0
			if (comcli==33) use_netconf=1  ; else use_netconf=0
			comcli=2 ; comcli_mom=3 ; linux_shell=0 ; comcli_port=22 ; secure_port=22 ; ftp_port=22 ; netconf_port=830
			netconf_getconfig=0
			if (export_method==0 && os!="cygwin") export_method=1
			use_keyboard_interactive=1
		}
		else if (comcli==34 || comcli==35) #APG43L 2.x or EPG/SSR/ROUTER6K
		{
			if (comcli==34) #APG
			{
				export_method=3
				export_dir="/audit_logs"
				epg_ssr=0
			}
			else if (comcli==35) #ROUTER
			{
				epg_ssr=1
				export_method=3
				comcli_ropdir="/md/ecim_pm"
			}
			tls_menu=0 ; use_tls=0
			comcli=2 ; comcli_mom=3 ; linux_shell=0 ; comcli_port=22 ; secure_port=22 ; ftp_port=22 ; netconf_port=830 ; use_netconf=0
			netconf_getconfig=0
			if (export_method==0 && os!="cygwin") export_method=1
			if (comcli==35) use_keyboard_interactive=1  #should stay at 0 on BSC/APG
		}
		else if (comcli~/^(3[6789]|4[0123])$/) #36=EMe  / 37=MRSv / 38=CBA Ref  / 39=SBG / 40=vEMe / 41=vBGF,vSBC / 42=MTAS,CSCF (with root user) / 43=HSSFE>1.31
		{
			ftp_port=22
			comcli_port=830
			if (comcli==37)      { ftp_port=115   ; comcli_port=830  }
			else if (comcli==38) { ftp_port=830   ; comcli_port=830  }
			else if (comcli==39) { ftp_port=2028  ; comcli_port=2022 }
			else if (comcli==40) { ftp_port=22    ; comcli_port=2022 }
			else if (comcli==41) { ftp_port=115   ; comcli_port=830  ; comcli_ropdate=1 ; comcli_ropdir="/var/filem/nbi_root/PerformanceManagementReportFiles" }
			else if (comcli==42) { ftp_port=830   ; comcli_port=830  ; comcli_ropdate=1 ; comcli_ropdir="/var/filem/nbi_root/PerformanceManagementReportFiles" }
			else if (comcli==43) { ftp_port=115   ; comcli_port=122  } 
			tls_menu=0 ; use_tls=0
			use_netconf=0
			comcli_mom=3 ; linux_shell=0 ; secure_port=830 ; netconf_port=830
			netconf_getconfig=0
			export_method=3
			export_dir=""
			ssh_subsystem="cli"
			use_keyboard_interactive=1
			if (comcli==41 || comcli==42) { linux_shell=1 ; secure_port=22 ; ssh_subsystem="" }  #based on comcli=37
			if (comcli==43) { secure_port=122 ; ssh_subsystem="" }
			comcli=2
		}
		else if (comcli==31) #Commercial BSP
		{
			tls_menu=0 ; use_tls=0
			comcli=2 ; comcli_mom=3 ; linux_shell=0 ; comcli_port=2024 ; secure_port=2024 ; ftp_port=3022 ; use_netconf=0
			netconf_getconfig=0
			if (export_method==0 && os!="cygwin") export_method=1
			#export_method=3
			#export_dir="/"
			use_keyboard_interactive=1
		}
		else if (comcli==32) #PGM with linux shell
		{
			tls_menu=0 ; use_tls=0
			comcli=2 ; secure_port=830 ; use_netconf=0
			netconf_getconfig=0
			use_keyboard_interactive=1
		}
		else if (comcli ~ /^[25][0123456789]$/) #G2
		{
			if (comcli!~/^2[34]$/)
			{
				if (comcli_netconf_disabled["comcli_netconf_set"]!=1) comcli_netconf_set=1
				if (comcli_netconf_disabled["comcli_netconf_del"]!=1) comcli_netconf_del=1
				if (comcli_netconf_disabled["comcli_netconf_cre"]!=1) comcli_netconf_cre=1
				if (comcli_netconf_disabled["comcli_netconf_pcr"]!=1) comcli_netconf_pcr=1
				if (comcli_netconf_disabled["comcli_netconf_acc"]!=1) comcli_netconf_acc=1
			}
			tls_menu=0
			use_tls=0
			use_netconf=0
			secure_http=1
			if (comcli~/^[25][14]$/) coli_shell=2  #G2 RnD
			if (comcli~/^[25][34]$/) use_netconf=1
			if (comcli~/^[25][5-8]$/ && comcli_netconf_disabled["use_ftps"]!=1) use_ftps=1
			if (comcli~/^[25]5$/) use_tls=1
			else if (comcli~/^[25]6$/) use_tls=2
			else if (comcli~/^[25]7$/) use_tls=3
			else if (comcli~/^[25]8$/) { use_tls=-1 ; tls_menu=1 }
			else if (comcli~/^[25]9$/) use_tls=21
			http_port=8080 ; secure_port=4192 ; ftp_port=2024 ; comcli_port=2023 ; netconf_port=830 ; s_comcli_port=9830 ; s_secure_port=9831 ; s_ftp_port=9921
			s_http_port=443
			if (comcli~/^5[0-9]$/) s_http_port=3443
			if (comcli==22)
			{
				comcli_portfile=1
				parse_comcli_portfile()
			}
			comcli=2 ; comcli_mom=2 ; linux_shell=0
			if (os=="cygwin") http_timeout=10  #on cygwin the http transfer of the MOM sometimes hangs
			netconf_getconfig=0
			if (node_password=="nopassword")  reset_password()   #in case switching back and forth between comcli=20 and comcli=25
			use_keyboard_interactive=0
		}
		#else if (comcli==22) #g2 RCSsim
		#{
		#	comcli_netconf_set=1
		#	tls_menu=0
		#	use_tls=0
		#	comcli=2 ; comcli_mom=2 ; linux_shell=0 ; comcli_portfile=1 ; use_netconf=0 ; parse_comcli_portfile()
		#	netconf_getconfig=0
		#	use_keyboard_interactive=0
		#}
	}

	# the following if-else is in case secure_shell is changed back and forth
	if (secure_shell==1 && secure_shell != old_secure_shell)
	{
		old_telnet_port=telnet_port
		old_secure_shell=secure_shell
		telnet_port=secure_port
	}
	else if (secure_shell==0 && secure_shell != old_secure_shell && old_telnet_port != "")
	{
		old_secure_shell=secure_shell
		telnet_port=old_telnet_port
		if (portbase > 0) telnet_port=portbase+23
	}
	else if (varname ~ /^rset_customlist$/)
	{
		last=split(rset_customlist,array,",")
		for (i=1;i<=last;i++)
		{
			for (j in compulsoryRsetMoList) if (tolower(array[i])==tolower(j)) compulsoryRsetMoList[j]=0
		}
		for (j in compulsoryRsetMoList)
		{
			if (compulsoryRsetMoList[j] != 0) rset_customlist=sprintf("%s,%s",rset_customlist,j)
		}
		rset_customfilter=""
		for (i=1;i<=last;i++) if (array[i]!="") rset_customfilter=sprintf("%s|%s",rset_customfilter,array[i])
		rset_customfilter=sprintf("^(%s)$",gensub(/^\|/,"",1,rset_customfilter))
	}
	#sl3 dependencies
	if (sl3==1 && varname ~ /^(sl3|sls_username|sls_password)$/)
	{
		username=sls_username
		if (sls_password!="") preliminary_node_password=sls_password
		secure_shell=1
		secure_ftp=1
	}

	if (editor=="$EDITOR")
	{
		if (ENVIRON["EDITOR"] != "") editor=ENVIRON["EDITOR"]
		else editor="vi" #use good old vi as default if it is not set via environment
	}
	if (varname=="portbase" && portbase > 0)
	{
		http_port=portbase+80
		ftp_port=portbase+21
		secure_port=portbase+22
		if (secure_shell==1) telnet_port=secure_port
		else telnet_port=portbase+23
		corba_port=portbase+834
		s_corba_port=portbase+836
		s_http_port=portbase+443
	}
	#The transaction timeout should be equal or higher than corba_timeout
	if (transaction_timeout < corba_timeout) transaction_timeout=corba_timeout
	#not supported to change transaction timeout on corba_class 1 otherwise cause issues with del upgradepackage: http://utran01.epa.ericsson.se/moshell/forum_viewtopic.php?4.3980
	if (corba_class==1) transaction_timeout=3600
	split(process_custom_file(custom_param_file,"custom_param_file"),customFiles,SUBSEP)
	custom_param_file=customFiles[1]
	orig_custom_param_file=customFiles[2]
	split(process_custom_file(custom_upid_file,"custom_upid_file"),customFiles,SUBSEP)
	custom_upid_file=customFiles[1]
	orig_custom_upid_file=customFiles[2]


	#dependencies associated with ipv6
	if (varname=="ipv6" && ipv6 > 0)
	{
		set_ipv6_dependencies()
	}
	if ((varname=="use_netcatlib" || varname=="secure_ftp") && ipv6>0)
	{
		secure_ftp=1
		#use_netcatlib=0
	}
	#if comcli>0 then lincli must be > 0
	if ((varname=="comcli" || varname=="lincli") && comcli>0) lincli=1
	if (varname=="comcli_portfile" && comcli_portfile==1) parse_comcli_portfile()

	if (varname=="emcli" && emcli!="")
	{
		if (emcli==0) emcli=""
		#emcli=ua:1,nv:9.0z,pn:CXP123456/7,pr:R10B,ec:42
		split(emcli,array,",")
		for (i in array)
		{
			split(array[i],part,":")
			EMCLI[part[1]]=part[2]
		}
		if (emcli!="")
		{
			moshellversion_check=0
			coli_shell=0
			max_login_attempts=3
			smart_shell=0
			esci=1
		}
	}
	if (varname == "use_default_jacorb")
	{
		if (use_default_jacorb==1)
		{
			jacorb=make_cygpath(commonjardir"/jacorb.jar")
			jacsec=make_cygpath(commonjardir"/jacsec.jar")
			jacoms=make_cygpath(commonjardir"/jacoms.jar")
		}
		else
		{
			jacorb=make_cygpath(jarxmldir"/jacorb.jar")
			jacsec=make_cygpath(jarxmldir"/jacsec.jar")
			jacoms=make_cygpath(jarxmldir"/jacoms.jar")
		}
	}

	if (comcli>0 || lincli==3 || yangcli>0)
	{
		use_complete_mom=0
		use_extended_mom=0
		secure_shell=1
		secure_ftp=1
		if (use_tls>0) telnet_port=s_secure_port
		else telnet_port=secure_port
		if (comcli>0 || yangcli>0)
		{
			lincli=1
			#the keyboard-interactive setting causes 3 more password prompts on RCS nodes but is needed for sftp to a unix server eg at export_method=2
			auth_method="publickey,password"
			if (use_keyboard_interactive==1) auth_method="publickey,password,keyboard-interactive"
			keepalive_interval=0
		}
	}
	if (in_amos_mode() && varname=="corba_class" && file!=moshell)
	{
		#corba_class has been modified from the default value
		amos_corba_modified_from_default=1
	}
	if (varname=="username" && file!=moshell) username_modified_from_default=1
	if (varname~/^comcli_netconf_(set|cre|del|pcr|acc)$|^use_ftps$/ && file!=moshell)
	{
		if (varvalue==0) comcli_netconf_disabled[varname]=1
		else delete comcli_netconf_disabled[varname]
	}

	if (varname=="use_netcatlib" || varname=="use_scandir")
	{
		#gawk 4.1.0 limitations, since moshell 10.0a
		os=check_os()
		#use_netcatlib=0
		if (os=="sunsparc") use_scandir=0
	}
	if (smart_comcli==1 && smart_secure!=1) smart_secure=1
	if (varname=="no_crn")
	{
		delete no_crn_mocs
		split(no_crn,array,",")
		for (i in array) no_crn_mocs[array[i]]=1
	}

	if (varname=="tls_menu" && tls_menu>0) use_tls=-1

	if (in_amos_mode()!=1) amos_log_interval=0
}
function set_uv_blacklist(val,   array,i)
{
	uv_blacklist=val
	split(val,array,",")
	for (i in array) forbiddenUv[array[i]]=1
}
function set_uv_greylist(val,   array,i)
{
	uv_greylist=val
	split(val,array,",")
	for (i in array) restrictedUv[array[i]]=1
}
function parse_comcli_portfile(    unixcommand,unixline,array)
{
	#must use a unix process to read the file since the file path may contain wildcard *, the unix process will do file name completion
	unixcommand="cat "comcli_portfilepath
	while (unixcommand |& getline unixline)
	{
		#{cli,21703}.
		#{sftp,21704}.
		#{coli,21705}.
		#{www,21717}.
		#{netconf,31303}.
		#{cli_tls,31313}.
		#{coli_tls,31314}.
		#{https,31326}.
		#{netconf_tls,28010}.

		split(unixline,array,/[},{]/)
		if (array[2]=="cli") comcli_port=secure_port=array[3]
		else if (array[2]=="sftp") ftp_port=array[3]
		else if (array[2]=="www") http_port=array[3]
		else if (array[2]=="coli") secure_port=array[3]
		else if (array[2]=="cli_tls") s_comcli_port=array[3]
		else if (array[2]=="coli_tls") s_secure_port=array[3]
		else if (array[2]=="https") s_http_port=array[3]
		else if (array[2]=="netconf") netconf_port=array[3]
		else if (array[2]=="netconf_tls") s_netconf_port=array[3]
	}
	close(unixcommand)
}
function process_custom_file(custom_file,filename,    orig_custom_file,varname,varvalue,i,last,array,j,customFileList,customFileName,cat_command,n)
{
	n=0
	if (custom_file ~ ",")
	{
		last=split(custom_file,array,",")
		for (i=1;i<=last;i++)
		{
			if (fileOps("test -s "array[i])==0)
			{
				n++
				customFileList[n]=array[i]
				customFileName=customFileName"_"gensub(/^.*\//,"",1,array[i])
				sub(/^_/,"",customFileName)
			}
		}
		if (n==0) return custom_file
		orig_custom_file=custom_file
		custom_file=tempdir"/"customFileName
		print sprintf("#%s=%s",filename,cust_process(orig_custom_file)) > custom_file
		for (i=1;i<=n;i++)
		{
			print sprintf("#%s",customFileList[i]) >> custom_file
			while ((getline < customFileList[i])>0)
			{
				gsub("\r","")
				if ($1 ~ /^#/ || NF < 3) continue
				print $0 >> custom_file
			}
			close(customFileList[i])
		}
		close(custom_file)
		assignCustomVar("$concatenated_"filename,custom_file,"","system")
	}
	return custom_file SUBSEP orig_custom_file
}
function the_info(   s1,s2,a,b,s,i)
{
	s1="0x66,0x75,0x6c,0x68,0x61,0x63,0x6b"
	s2="0x15,0x10,0x0F,0x05,0x06,0x0E,0x1f"
	split(s1,a,",")
	split(s2,b,",")
	for (i=1;i<=7;i++) s=s","xor(strtonum(a[i]),strtonum(b[i]))
	split(s,a,",")
	s=""
	for (i=2;i<=8;i++) s=sprintf("%s%c",s,a[i])
	return s
}
function cust_process(filelist,    i,array,last,result)
{
	result=""
	last=split(filelist,array,",")
	for (i=1;i<=last;i++)
	{
		if (fileOps("test -s "array[i])!=0) array[i]="FileNotFound:"array[i]
		result=result","array[i]
	}
	sub(/^,/,"",result)
	return result
}
function b2i(val,   res)
{
	res=val
	if (tolower(val)~"true") res=1
	return res+0
}
function sub_print_uv(uvname,filter,outvar,   uval,output)
{
	if (uvname ~ /^amos_/ && in_amos_mode()!=1) return
	uval=SYMTAB[uvname]
	if (uvname=="custom_param_file" && orig_custom_param_file!="") uval=cust_process(orig_custom_param_file)
	else if (uvname=="custom_upid_file" && orig_custom_upid_file!="") uval=cust_process(orig_custom_upid_file)
	else if (uvname=="pm_logdir" && pm_logdir=="") uval=logdir
	else if (uvname~/^([a-z]+)_passwords?$/ && uval!="" && uvname!="smart_password") uval="********"
	output=sprintf("%-25s = %s",uvname,uval)
	if (tolower(output) ~ tolower(filter))
	{
		customPrint(output)
		if (outvar != "") assignCustomVar(outvar,uval,"print")
	}
}
function print_user_variables(filter,outvar,   varname,n,i,uvList)
{
	#uvName["sls_password"]="sls_password"
	#print "sls_password="SYMTAB["sls_password"]
	customPrint("")
	n=asort(uvName,uvList)
	for (i=1;i<=n;i++) sub_print_uv(uvList[i],filter,outvar)
}
function replace_path_variables(line)
{
	if (line !~ /\$(moshelldir|commonjardir|jarxmldir|sitefiledir|HOME|USER|JAVA_HOME)/) return line
	gsub(/\$moshelldir/,moshelldir,line)
	gsub(/\$commonjardir/,commonjardir,line)
	gsub(/\$jarxmldir/,jarxmldir,line)
	gsub(/\$sitefiledir/,sitefiledir,line)
	gsub(/\$HOME/,ENVIRON["HOME"],line)
	gsub(/\$JAVA_HOME/,ENVIRON["JAVA_HOME"],line)
	if (line ~ /\$USER/ && ENVIRON["USER"]=="") ENVIRON["USER"]=setUSER()
	gsub(/\$USER/,ENVIRON["USER"],line)
	return line
}
function check_jar_version(jarfile,  unzip_session,found,result,corrupted)
{
	if (fileOps(sprintf("test -s %s",jarfile))==1) return ""
	unzip_session="unzip -c "jarfile" "(jarfile==jacoms?"markfile":"META-INF/MANIFEST.MF")" 2>&1"
	while ((unzip_session |& getline)>0)
	{
		if (found > 0) continue
		gsub("\r","")
		if (/End-of-central-directory signature not found/) corrupted=1
		if ($1=="Implementation-Version:" || $1=="CXC1320960")
		{
			#Implementation-Version: R71G05
			#Implementation-Version: R1B01
			result=$2
			found++
		}
	}
	close(unzip_session)
	if (result=="" && corrupted==1) fileOps("rm "jarfile)
	return result
}
function find_csu(   result)
{
	#up to CPP6, csuc must be used
	#from CPP7, csus must be used
	if (jarVersion[jacorb]!~"R[56]") result=csu"s.jar"
	else result=csu"c.jar"
	return result
}
function parse_common_variables(    polyext,polyver)
{
	os=check_os()
	moshell=       moshelldir"/moshell"
	mobatch=       moshelldir"/mobatch"
	funcs=         moshelldir"/funcs.awk"
	extern=        moshelldir"/extern.awk"
	readme=        moshelldir"/README"
	relhistory=    moshelldir"/ReleaseHistory.txt"
	zpm=           moshelldir"/zpm"
	monclient33077=moshelldir"/monitor33077"
	connect=       commonjardir"/connect"
	connect6=      commonjardir"/connect6"
	getif=         commonjardir"/getif"  #getif could not be compiled for solaris x86 and sparc, use /sbin/ifconfig -a instead
	netcat=        commonjardir"/nc6"
	monclient6054= moshelldir"/monitor6054"
	md5sum=        commonjardir"/md5sum"
	if (ipv6==1) monclient6054=netcat
	moscurl=       commonjardir"/curl"
	ssh=           commonjardir"/ssh"
	sftp=          commonjardir"/sftp"
	sshd=          commonjardir"/sshd"
	sftpserv=      commonjardir"/sftp-server"
	openssl=       commonjardir"/openssl"
	scp=           commonjardir"/scp"
	relayd=        commonjardir"/lttng-relayd"
	babeltrace=    commonjardir"/babeltrace"
	#mapping of LM name to LM product number. an initial file is also in commonjars, then it is automatically updated in jarxml
	lmiddb=        jarxmldir"/lmids.txt"
	#mapping UP number to MOM version. an initial file is also in commonjars, then it is automatically updated in jarxml
	uptomomdb=     jarxmldir"/uptomom.txt"
	#data from "hget upgrade admin", applicable to MGW. an initial file is also in commonjars, then it is automatically updated in jarxml
	updatadb=      jarxmldir"/updata.txt"
	cppdatadb=     jarxmldir"/cppdata.txt"
	updatadb2=     jarxmldir"/updata2.txt"
	#file containing the mapping UP number to release. manually updated at each moshell release, NOT automatically updated in jarxml
	upiddb=        commonjardir"/upids.txt"
	upiddb2=       commonjardir"/pm/upids.csv"
	completemomdb= jarxmldir"/completemomdb.txt"   # file containing the relationship between the complete mom path in vobs and the mim version
	standardmomdb= jarxmldir"/standardmomdb.txt"   # file containing the relationship between the standard mom path in vobs and the mim version
	mobrowser=     make_cygpath(commonjardir"/mobx.jar")
	jacmob=        make_cygpath(commonjardir"/jacmobx.jar")
	jacmobn=       make_cygpath(commonjardir"/jacmobn.jar")
	asms_secure=   make_cygpath(commonjardir"/asms_secure.jar")
	asms_stubbed=  make_cygpath(commonjardir"/asms_stubbed.jar")
	csu=           make_cygdir(commonjardir)"/csu"   #here we cannot use make_cygpath, otherwise it will say "file not found". We do not put the .jar extension on this one since there are several versions of the csu (csu, csus, csuc)
	bootstrap=     make_cygpath(commonjardir"/bootstrap.jar")
	#bouncyjar=     make_cygpath(commonjardir"/bcprov-jdk14-137.jar")
	foundation=    make_cygpath(commonjardir"/foundation.jar")
	ssu=           make_cygpath(commonjardir"/ssu.jar")
	samcsu=        make_cygpath(commonjardir"/samcsus.jar")
	samssu=        make_cygpath(commonjardir"/samssu.jar")
	hostp12=       make_cygpath(commonjardir"/host.p12")
	oms=           make_cygpath(jarxmldir"/oms.jar")
	vbjorb=        make_cygpath(jarxmldir"/vbjorb.jar")
	iaik=          make_cygpath(jarxmldir"/iaik_jce_full_us.jar")
	#jacorb=        make_cygpath(jarxmldir"/jacorb.jar")
	#jacsec=        make_cygpath(jarxmldir"/jacsec.jar")
	#jacoms=        make_cygpath(jarxmldir"/jacoms.jar")
	nealjar=       make_cygpath(jarxmldir"/neal_c.jar")
	ecimcomjar=    make_cygpath(jarxmldir"/NetconfCLI_R2A.jar")
	#jacbootstrap=  make_cygpath(commonjardir"/jacbootstrap.jar") Not needed

	if (vobsinstallation==0 && os=="linux" && use_lin64==1 && linarch=="64")
	{
		sftp=sftp".lin64"
		ssh=ssh".lin64"
		sshd=sshd".lin64"
		sftpserv=sftpserv".lin64"
		openssl=openssl".lin64"
		scp=scp".lin64"
		bash=gensub(/\.lin64$/,"",1,bash)".lin64"
		netcat=netcat".lin64"
		connect=connect".lin64"
		connect6=connect6".lin64"
		getif=getif".lin64"
		md5sum=md5sum".lin64"
		zpm=zpm".lin64"
		moscurl=moscurl".lin64"
		relayd=relayd".lin64"
		babeltrace=babeltrace".lin64"
	}
	else if (vobsinstallation==1)
	{
		#adaptation for the vobs installation to work on linux and solaris/x86 as well as solaris/sparc
		if (os == "linux")
		{
			monclient33077=monclient33077".linux"
			monclient6054=monclient6054".linux"
			if (use_lin64==1 && linarch=="64")
			{
				sftp=sftp".lin64"
				ssh=ssh".lin64"
				sshd=sshd".lin64"
				sftpserv=sftpserv".lin64"
				openssl=openssl".lin64"
				scp=scp".lin64"
				netcat=netcat".lin64"
				connect=connect".lin64"
				connect6=connect6".lin64"
				getif=getif".lin64"
				md5sum=md5sum".lin64"
				zpm=zpm".lin64"
				moscurl=moscurl".lin64"
				relayd=relayd".lin64"
				babeltrace=babeltrace".lin64"
			}
			else
			{
				getif=getif".linux"
				sftp=sftp".linux"
				ssh=ssh".linux"
				sshd=sshd".linux"
				sftpserv=sftpserv".linux"
				openssl=openssl".linux"
				scp=scp".linux"
				netcat=netcat".linux"
				connect=connect".linux"
				connect6=connect6".linux"
				md5sum=md5sum".linux"
				zpm=zpm".linux"
				moscurl=moscurl".linux"
				relayd=relayd".linux"
				babeltrace=babeltrace".linux"
			}
		}
		else if (os == "sun86")
		{
			connect=connect".sol86"
			connect6=connect6".sol86"
			netcat=netcat".sol86"
			sftp=sftp".sol86"
			ssh=ssh".sol86"
			sshd=sshd".sol86"
			sftpserv=sftpserv".sol86"
			openssl=openssl".sol86"
			scp=scp".sol86"
			zpm=zpm".sol86"
			monclient33077=monclient33077".sol86"
			monclient6054=monclient6054".sol86"
			md5sum=md5sum".sol86"
			relayd=relayd".sol86"
			babeltrace=babeltrace".sol86"
		}
		else if (os ~ /^sunsparc/)
		{
			connect=connect".solaris"
			connect6=connect6".solaris"
			netcat=netcat".solaris"
			sftp=sftp".solaris"
			ssh=ssh".solaris"
			sshd=sshd".solaris"
			sftpserv=sftpserv".solaris"
			openssl=openssl".solaris"
			scp=scp".solaris"
			zpm=zpm".solaris"
			monclient33077=monclient33077".solaris"
			monclient6054=monclient6054".solaris"
			md5sum=md5sum".solaris"
		}
	}
	if (in_amos_mode()==1 && polyversion==0 && dbdat==1)
	{
		customPrint("INFO: polyversion=0 is not supported in AMOS. Changing to polyversion=1.")
		polyversion=1
	}
	polyext=""
	if (os=="linux")  polyext=".linux"
	else if (os=="cygwin" || os=="sun86")
	{
		if (os=="cygwin") polyext=".exe"
		else if (os=="sun86")
		{
			polyext=".x"
			#if (sunarch=="11") polyext=".y"
		}
		if (polyversion==0 && dbdat==1)
		{
			customPrint("INFO: polyversion=0 is not supported on "os". Changing to polyversion=1.")
			polyversion=1
		}
	}
	if (polyversion==0) polyver=""
	else if (polyversion==1)
	{
		polyver=".94"
		#in amos if the latest polyversion is not there then we try the previous ones until .86
		if (in_amos_mode()==1 && fileOps(sprintf("test -s /opt/ericsson/amos/lib/rtrdb%s%s.gz",polyver,polyext))!=0)
		{
			for (i=94;i>=86;i--)
			{
				polyver="."i
				if (fileOps(sprintf("test -s /opt/ericsson/amos/lib/rtrdb%s%s.gz",polyver,polyext))==0) break
			}
		}
	}
	else polyver="."polyversion #it is possible to specify a polyversion in this uv, eg polyversion=84
	#ct co /vobs/iov/rnc/bin/polyview
	#cd /home/eanzmagn/poly88
	#cp *88* /vobs/iov/rnc/bin/polyview/
	#ct mkelem -nc /vobs/iov/rnc/bin/polyview/*88*
	#ct protect -chmod 777  /vobs/iov/rnc/bin/polyview/*88*
	#ct ci -nc  /vobs/iov/rnc/bin/polyview/*88*
	#ct ci -nc /vobs/iov/rnc/bin/polyview
	rtrdb=sprintf("%s/rtrdb%s%s",jarxmldir,polyver,polyext)
	sqlc=sprintf("%s/sqlc%s%s",jarxmldir,polyver,polyext)
        #if (mosdebug==1) print_common_variables()
}
function print_common_variables()
{
	printf("\n\
moshelldir=   "moshelldir   "$\n\
moshell=      "moshell      "$\n\
mobatch=      "mobatch      "$\n\
readme=       "readme       "$\n\
funcs=        "funcs        "$\n\
zpm=          "zpm          "$\n\
commonjardir= "commonjardir "$\n\
filefunc=     "filefunc     "$\n\
netcat=       "netcat       "$\n\
connect=      "connect      "$\n\
connect6=     "connect6     "$\n\
sftp=         "sftp         "$\n\
ssh=          "ssh          "$\n\
lmiddb=       "lmiddb       "$\n\
upiddb=       "upiddb       "$\n\
uptomomdb=    "uptomomdb    "$\n\
completemomdb="completemomdb"$\n\
standardmomdb="standardmomdb"$\n\
asms_secure=  "asms_secure  "$\n\
asms_stubbed= "asms_stubbed "$\n\
bootstrap=    "bootstrap    "$\n\
mobrowser=    "mobrowser    "$\n\
jacmob=       "jacmob       "$\n\
jacmobn=      "jacmobn      "$\n\
nealjar=      "nealjar      "$\n\
foundation=   "foundation   "$\n\
csu=          "csu          "$\n\
ssu=          "ssu          "$\n\
jarxmldir=    "jarxmldir    "$\n\
jacorb=       "jacorb       "$\n\
jacsec=       "jacsec       "$\n\
jacoms=       "jacoms       "$\n\
rtrdb=        "rtrdb        "$\n\
sqlc=         "sqlc         "$\n")
#jacbootstrap= "jacbootstrap "$\n\
}
function ftpcleanup()
{
	if (ftp_rmfile_command !~ "rm -f ") return
	#old_fast_coli_threshold=fast_coli_threshold
	#fast_coli_threshold=1
	$0=ftp_rmfile_command
	cmd("","noheader") #cmd("","noheader","","user")  #fast_coli not needed , does not go much quicker and is more verbose
	#fast_coli_threshold=old_fast_coli_threshold
}
function ftpclient(ftpserver,password,command,commandList,silent,ftpuser,theport,pwfile,nostop,ciphers,viaftps,    indexList,i,n,sftp_session,sftp_fail,array,errorCode,part,fileToRemove,bufferFile,tmpCommandList,cp_command,sftp_port,sftp_res,debug_output,nr_commands,keepOption,kexalgopt,macsopt,\
ftps_session,pemfiles,arr,buffDir,globDir)
{
	if (ftpuser=="") ftpuser=username
	if (pwfile=="") pwfile=tempsshzfile
	ftp_rmfile_command=""  #global variable
	cp_command=""
	delete tmpCommandList
	if (command!="")
	{
		if (mosdebug==1) print "DEBUG: ftp command: "command
		split(command,array," ")
		if (array[1]=="get" && array[2]~/[0-9][0-9][0-9][0-9]00!\//)
		{
			match(array[2],/([0-9][0-9][0-9][0-9]00!\/.*$)/,part)
			if (cpplinux==1)
			{
				buffDir="/d/usr/mosftp"gawk_pid strftime("%H%M%S",systime())
				bufferFile=buffDir "/" gensub(/^.*\//,"",1,part[1])
				#$0="lhcp "gensub(/!/,"\\\\!",1,part[1])" /d/usr"
				match(part[1],/([0-9][0-9][0-9][0-9]00)!(\/.*)$/,arr)
				if (arr[1]~/^00(03|25)00$/) globDir="/c/usr" ; else globDir="/p"arr[1]"/usr"
				$0="mkdir "buffDir";lhsh "arr[1]" cp "arr[2]" "globDir";mv "globDir"/"gensub(/^.*\//,"",1,arr[2])" "buffDir
			}
			else
			{
				bufferFile="/d/usr/"gensub(/^.*\//,"",1,part[1])
				$0="cp "part[1]" /d/usr"
			}
			cmd("","noheader")
			command="get "bufferFile" "array[3]
			ftp_rmfile_command="rm -f "bufferFile
			if (cpplinux==1) ftp_rmfile_command=ftp_rmfile_command";rmdir "buffDir
		}
	}
	else
	{
		debug_output="DEBUG: ftp commandList: "
		nr_commands=0
		for (i in commandList)
		{
			debug_output=debug_output" "commandList[i]
			nr_commands++
			split(commandList[i],array," ")
			if (array[1]=="get" && array[2]~/[0-9][0-9][0-9][0-9]00!\//)
			{
				match(array[2],/([0-9][0-9][0-9][0-9]00!\/.*$)/,part)
				if (cpplinux==1)
				{
					#cp_command=cp_command "lhcp "gensub(/!/,"\\\\!",1,part[1])" /d/usr;"
					match(part[1],/([0-9][0-9][0-9][0-9]00)!(\/.*)$/,arr)
					cp_command=cp_command "lhsh "arr[1]" cp "arr[2]" /p"arr[1]"/usr;mv /p"arr[1]"/usr/"gensub(/^.*\//,"",1,arr[2])" /d/usr;"
				}
				else cp_command=cp_command "cp "part[1]" /d/usr;"
				bufferFile="/d/usr/"gensub(/^.*\//,"",1,part[1])
				tmpCommandList[i]="get "bufferFile" "array[3]
				ftp_rmfile_command=ftp_rmfile_command "rm -f "bufferFile";"
			}
		}
		if (cp_command ~ "cp")
		{
			#old_fast_coli_threshold=fast_coli_threshold
			#fast_coli_threshold=1
			$0=cp_command ; cmd("","noheader") #cmd("","noheader","","user")  #fast_coli not needed , does not go much quicker and is more verbose
			#fast_coli_threshold=old_fast_coli_threshold
		}
		for (i in commandList)
		{
			if (i in tmpCommandList && tmpCommandList[i]!="") commandList[i]=tmpCommandList[i]
		}
		if (mosdebug==1) print debug_output
		if (nr_commands==0) return 0
	}


	if (secure_ftp==0)
	{
		#based on scripts from http://www.awk-scripting.de

		#The variable "connect" must indicate the path to the "connect" binary
		#returns 0 for success and 1 for failure

		if (check_ip_contact(ftpserver,ftp_port) != 0)
		{
			customPrint(sprintf("Unable to connect to %s:%s.",ftpserver,ftp_port),"","force")
			ftpcleanup()
			return 1
		}

		ftpserver=ftpserver ":" ftp_port
		FATALERROR=""
		delete ftpDataPortList

		#       Passive mode is not supported

		#	The following commands are supported:
		#	  CWD <dir>
		#	  PWD
		#	  LIST     [<dir>|<file>]
		#	  RETR/GET <remotefile> [<localfile>]
		#	  STOR/PUT <localfile>  [<remotefile>]
		#	  DELE <file>
		#	  RENAME <oldname> <newname>
		#	  MKD/MKDIR <dir>
		#	  RMD/RMDIR <dir>
		#	ftpclient does not support blanks in directory or filenames.
		STDERR  = "/dev/stderr";
		program = "ftpclient";

		# This hack works only for linux systems.  We need it for piping
		# data to and from the FTP server.
		REALSTDOUT = "/proc/" PROCINFO["pid"] "/fd/1";
		REALSTDIN  = "/proc/" PROCINFO["pid"] "/fd/0";

		#username is defined in moshell file and/or .moshellrc
		#if (username=="") username  = "ftp";

		# Connect to the FTP server, read the local interface information,
		# ignore peer information.
		#

		server = sprintf ("%s -t %s -x %s", connect, ftp_timeout, ftpserver);

		interface = cfgets(server);
		sub(/:.*$/, "", interface);
		if (mosdebug == 1) printf ("local interface is %s\n", interface);

		cfgets(server);		# peer information.

		# Read the server greeting ...
		#
		if (cfputc(server, "", "", 220)=="FATALERROR")
		{
			ftpcleanup()
			return ftpclose(1)
		}

		# ... and login.

		if (node_login==1)
		{
			if (cfputc(server, "USER", ftpuser, 331)=="FATALERROR")
			{
				ftpcleanup()
				return ftpclose(1)
			}
			if (cfputc(server, "PASS", password, 230)=="FATALERROR")
			{
				customPrint("Password has not been set correctly. Please run the \"passwd\" command to reset the node password.")
				ftpcleanup()
				return ftpclose(1)
			}
		}
		else
		{
			if (cfputc(server, "USER", ftpuser, 230)=="FATALERROR")
			{
				ftpcleanup()
				return ftpclose(1)
			}
		}

		if (command != "")
		{
			if (docmd(server,command,silent)=="FATALERROR")
			{
				customPrint("FAIL\n"FATALERROR,"","force")
				ftpcleanup()
				return ftpclose(1)
			}
			else if (testgz(command)!=0) customPrint("FAIL\nIncomplete gz file.","","force")
			else if (silent != "silent") customPrint("OK","","force")
		}
		else
		{
			for (i in commandList) indexList[i+0]=i+0
			n=asort(indexList)
			for (i=1;i<=n;i++)
			{
				if (indexList[i] in commandList && commandList[indexList[i]] != "")
				{
					if (docmd(server,commandList[indexList[i]],silent)=="FATALERROR")
					{
						customPrint("FAIL\n"FATALERROR,"","force")
						errorCode=1
						#return ftpclose(1) --> we want it to continue even if some file transfers failed.
					}
					else if (testgz(commandList[indexList[i]])!=0) customPrint("FAIL\nIncomplete gz file.","","force")
					else if (silent != "silent") customPrint("OK","","force")
				}
			}
		}
		if (cfputc(server, "QUIT", "", 221)=="FATALERROR")
		{
			ftpcleanup()
			return ftpclose(1)
		}
		if (errorCode==1)
		{
			ftpcleanup()
			return ftpclose(1);
		}
		else
		{
			ftpcleanup()
			return ftpclose(0);
		}
	}
	else if (viaftps>0)
	{

		if (is_ip_addr(ftpserver)==2 && ftpserver!~/^\[.*\]$/) ftpserver="["ftpserver"]"
		find_pemfiles(pemfiles)
		ftps_session=sprintf("%s --connect-timeout %s --max-time %s --insecure -s -S --ftp-method nocwd --ftp-ssl --cert %s --cacert %s%s ftp://USER@%s:%s",find_curl("silent"),ip_connection_timeout,ftp_timeout,pemfiles["client"],pemfiles["ca"],(use_tls==21?" --key "keypem" --pass "keypass:""),put_brackets(ftpserver),s_ftp_port)
		if (mosdebug==1) print "DEBUG: "ftps_session
		if (command != "")
		{
			return doftpscmd(ftps_session,command,silent)
		}
		else
		{
			errorCode=0
			for (i in commandList) indexList[i+0]=i+0
			n=asort(indexList)
			for (i=1;i<=n;i++)
			{
				if (indexList[i] in commandList && commandList[indexList[i]] != "")
				{
					errorCode+=doftpscmd(ftps_session,commandList[indexList[i]],silent)
				}
			}
			return errorCode
		}
	}
	else
	{
		if (theport != "") sftp_port=theport
		else if (comcli>0 && linux_shell==0) sftp_port=ftp_port
		else if (yangcli>0) sftp_port=yangftp_port
		else sftp_port=secure_port
		#The part below causes info traces in T&E log: INFO:Detected unsupported protocol, cleanup and terminating sshd_handler process
		#if (check_ip_contact(ftpserver,sftp_port,"fast") != 0)
		#{
		#	customPrint(sprintf("Unable to connect to %s:%s.",ftpserver,sftp_port),"","force")
		#	ftpcleanup()
		#	return 1
		#}
		if (sftp_kexalg!="") kexalgopt="-o KexAlgorithms="sftp_kexalg" "
		if (sftp_macs!="")   macsopt="-o MACs="sftp_macs" "
		sftp_session=sprintf("%s -S %s -o Port=%s -z '%s' -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null -o HostKeyAlgorithms=\"ssh-dss,ssh-rsa\" -o NumberOfPasswordPrompts=1 -o ConnectTimeout=%s -o ServerAliveInterval=%s -o ConnectionAttempts=%s -o ServerAliveCountMax=0 -o TCPKeepAlive=no -o PreferredAuthentications=%s %s %s%s-o User=%s %s 2>&1",sftp,ssh,sftp_port,pwfile,ip_connection_timeout,ftp_timeout,connection_attempts,auth_method,ciphers,kexalgopt,macsopt,ftpuser,put_brackets(ftpserver,1))
		#-o RekeyLimit=\"3.99G 24h\"
		if (mosdebug==1 || mosdebug==999) print "DEBUG: "sftp_session
		sftp_res=sftp_login(sftp_session)
		if (sftp_res>0)
		{
			if (sftp_res==1) customPrint("SFTP login failed.","","force")
			else customPrint(sprintf("Unable to connect to %s:%s.",ftpserver,sftp_port),"","force")
			close(sftp_session)
			ftpcleanup()
			return 1
		}
		if (command != "")
		{
			#on some SFTP servers (like netsim) , the double-slash can cause confusions
			gsub(/\/\//,"/",command)
			split(command,array," ")
			if (tolower(array[1])=="dele") array[1]="rm"  #the dele command is called "rm" in sftp
			if (tolower(array[1])=="get" && array[3] ~ /:/ && array[3] !~ /^.:/) gsub(/:/,".",array[3])  #windows cannot handle filenames containing a colon except after the drive letter
			command=sprintf("%s %s %s",array[1],array[2],array[3])
			if (silent != "silent") customPrint(sprintf("%s ... ",command),"","force","noLF")   #the -P option will not be shown in the printout for backward compatibility reason
			if (ftp_preserveprops==1 && array[1]~/^get/) keepOption=" -P"
			else if (ftp_preserveprops==2 && array[1]~/^put/) keepOption=" -P"
			else if (ftp_preserveprops==3 && array[1]~/^(get|put)/) keepOption=" -P"
			else keepOption=""
			command=sprintf("%s%s %s %s",array[1],keepOption,array[2],array[3])
			if (command ~ /^mkdir +[^/]/) print "pwd" |& sftp_session  #we created a directory with a relative path so we want to know where we made it
			print sprintf("%s\nexit",command) |& sftp_session
			while ((sftp_session |& getline)>0)
			{
				gsub("\r","") ; gsub("\x00","")
				if (mosdebug==1 && array[1]!="ls") print
				if (cpplinux==1 && ENVIRON["TIME_SERVER"]!="" && /select: Bad file descriptor|error [-0-9]+: query: Bad file descriptor/) continue
				# File names in command can contain regexp special characters, so escape these
				if ($0 ~ sprintf("^sftp> (%s|exit)$",gensub(/\+/,"\\\\+","g",command))) continue
				if ($0 == "sftp> "command) continue
				if ($0 == "sftp> pwd") continue
				if ($1 ~ /^debug[1-3]:$/) continue
				if (/Remote working directory: /) { sftpCurrentWorkingDirectory=$NF ; continue }
				if ($0 !~ /^(Connecting to |Warning: Permanently added |$|Removing |Fetching |Uploading |Connection to )/) sftp_fail=sprintf("%s. %s",sftp_fail,gensub(/sftp> |\r/,"","g",$0))
				#If the sftp session was used for running a "ls -an" command
				if (array[1]=="ls") customPrint($0)
			}
			close(sftp_session)
			wait_cpp_ssh(1,1)
			if (sftp_fail != "" && array[1]!="ls")
			{
				customPrint("FAIL","","force")
				customPrint(gensub(/^. /,"",1,sftp_fail),"","force")
				ftpcleanup()
				return 1
			}
			else
			{
				if (testgz(command)!=0) customPrint("FAIL\nIncomplete gz file.","","force")
				else if (silent != "silent") customPrint("OK","","force")
				ftpcleanup()
				return 0
			}
		}
		else
		{
			for (i in commandList) indexList[i+0]=i+0
			n=asort(indexList)
			for (i=1;i<=n;i++)
			{
				if (indexList[i] in commandList && commandList[indexList[i]] != "")
				{
					#on some SFTP servers (like netsim) , the double-slash can cause confusions
					gsub(/\/\//,"/",commandList[indexList[i]])
					#windows cannot handle filenames containing a colon
					split(commandList[indexList[i]],array," ")
					if (tolower(array[1])=="get" && array[3] ~ /:/ && array[3] !~ /^.:/) gsub(/:/,".",array[3])
					if (tolower(array[1])=="dele") array[1]="rm"  #the dele command is called "rm" in sftp
					commandList[indexList[i]]=sprintf("%s %s %s",array[1],array[2],array[3])
					if (silent != "silent") customPrint(sprintf("%s ... ",commandList[indexList[i]]),"","force","noLF")  #the -P option will not be shown in the printout
					if (ftp_preserveprops==1 && array[1]~/^get/) keepOption=" -P"
					else if (ftp_preserveprops==2 && array[1]~/^put/) keepOption=" -P"
					else if (ftp_preserveprops==3 && array[1]~/^(get|put)/) keepOption=" -P"
					else keepOption=""
					commandList[indexList[i]]=sprintf("%s%s %s %s",array[1],keepOption,array[2],array[3])
					print sprintf("%s\npwd",commandList[indexList[i]]) |& sftp_session
					while ((sftp_session |& getline)>0)
					{
						gsub("\r","") ; gsub("\x00","")
						if (mosdebug==1) print
						if (cpplinux==1 && ENVIRON["TIME_SERVER"]!="" && /select: Bad file descriptor|error [-0-9]+: query: Bad file descriptor/) continue
						# File names in commandList can contain regexp special characters, so escape these
						if ($0 ~ sprintf("^sftp> (%s|pwd)$",gensub(/\+/,"\\\\+","g",commandList[indexList[i]]))) continue
						if ($0 == "sftp> "commandList[indexList[i]]) continue
						if ($1 ~ /^debug[1-3]:$/) continue
						if ($0 !~ /^(Connecting to|Warning: Permanently added|Fetching|Uploading|Removing|Remote working directory:) /) sftp_fail=sprintf("%s. %s",sftp_fail,gensub(/sftp> |\r/,"","g",$0))
						if (/^Remote working directory:/) break
					}
					if (sftp_fail != "")
					{
						customPrint("FAIL","","force")
						customPrint(gensub(/^. /,"",1,sftp_fail),"","force")
						if (sftp_fail ~ /Connection closed|Connection reset by peer/)
						{
							close(sftp_session)
							wait_cpp_ssh(1,1)
							ftpcleanup()
							return 1
						}
						sftp_fail=""
						if (tolower(array[1])!="get" && nostop!="nostop") break  #only abort if put or delete , and if the nostop parameter is not set
					}
					else
					{
						if (testgz(commandList[indexList[i]])!=0) customPrint("FAIL\nIncomplete gz file.","","force")
						else if (silent != "silent") customPrint("OK","","force")
					}
				}
			}
			print "exit" |& sftp_session
			while ((sftp_session |& getline)>0) {}
			close(sftp_session)
			wait_cpp_ssh(1,1)
			if (errorCode==1)
			{
				ftpcleanup()
				return 1
			}
			else
			{
				ftpcleanup()
				return 0
			}
		}
	}
}
function doftpscmd(ftps_session,tcmd,silent,     array,res,errfile)
{
	errfile=tempdir"/ftpserrors.txt"
	#on some SFTP servers (like netsim) , the double-slash can cause confusions
	gsub(/\/\//,"/",tcmd)
	#windows cannot handle filenames containing a colon
	split(tcmd,array," ")
	if (tolower(array[1])=="get")
	{
		if (array[3] ~ /:/ && array[3] !~ /^.:/) gsub(/:/,".",array[3])
		ftps_session=ftps_session array[2] " -o "array[3]" 2>"errfile
	}
	else if (tolower(array[1])=="dele")
	{
		ftps_session=ftps_session array[2] " -Q \"-DELE "array[2]"\" -o /dev/null 2>"errfile
	}
	if (mosdebug==1) print "DEBUG: "ftps_session
	if (silent != "silent") customPrint(sprintf("%s ... ",tcmd),"","force","noLF")
	res=system(ftps_session)+0
	if (res!=0)
	{
		customPrint("FAIL","","force")
		while ((getline < errfile)>0) customPrint($0) ; close(errfile)
	}
	else
	{
		if (testgz(tcmd)!=0) { customPrint("FAIL\nIncomplete gz file.","","force") ; res=1 }
		else if (silent != "silent") customPrint("OK","","force")
	}
	return res
}
function testgz(command,   a,res,n)
{
	res=0
	n=split(command,a," ")
	#print "\n"command
	if (tolower(a[1])~/^get/ && tolower(a[n])~/\.gz$/)
	{
		if (a[n] ~ /:/ && a[n] !~ /^.:/) gsub(/:/,".",a[n])  #the colon in the filename will have been substituted by a .
		res=system("gzip -t \""a[n]"\" >/dev/null 2>&1")
		if (res!=0) fileOps("rm "a[n])
	}
	return res
}
function sftp_login(sftp_session,   result,array,sshRetryCount)
{
	while (1)
	{
		#wait 1 second before sftp login attempt, to make sure that previous ssh/sftp sessions are completed otherwise the login will fail if we are close to the maximum number SshTelnetSessions
		sshRetryCount++
		wait_cpp_ssh(sshRetryCount,1)
		result=sub_sftp_login(sftp_session)
		if (comcli!=0) break
		#ssh_exchange_identification: Connection closed by remote host
		if (sshRetryCount > ssh_retry || result !~ /ssh_exchange_identification: Connection closed by remote host|Connection timed out during banner exchange/) break
		customPrint("SFTP connection failed, retrying...")
		if (mosdebug==1) print "DEBUG: sshRetryCount="sshRetryCount", ssh_retry="ssh_retry
	}
	split(result,array,":")
	return array[1]+0
}
function sub_sftp_login(sftp_session,   result,error)
{
	result=0
	error=0
	#executing the "version" command is needed in case there is a file /c/security/banner.txt ? not used after 10.0a, seems enough to look for the line "Connected to <ipaddress>"
	#print "version" |& sftp_session
	while ((sftp_session |& getline)>0)
	{
		gsub("\r","") ; gsub("\x00","")
		if (mosdebug==1) print "DEBUG: "$0
		if (cpplinux==1 && ENVIRON["TIME_SERVER"]!="" && /select: Bad file descriptor|error [-0-9]+: query: Bad file descriptor/) continue
		if (/Connected to [^ ]+\.$/) { result=0 ; break }
		if (result==1) continue  #sometimes the message "Connection reset by peer" will come after the message "Permission denied", leading to wrong cause (no connection instead of wrong password)
		#Old code: /^Connected to /  ... replaced with :   /Connected to /
		#Because sometimes there could be some text before "Connected to". For instance:
		#This node is in fail-closed mode, please follow recovery instructions.Connected to a.b.c.d.
		#Connected to 2001:1b70:828a:1::15.
		#if (/SFTP protocol version/) { result=0 ; break }
		#No contact: result=2
		#ssh: connect to host a.b.c.d port 22: Connection timed out
		#ssh: connect to host a.b.c.d port 2024: Connection refused
		#ssh: Could not resolve hostname a: host/servname not known
		#Connection timed out during banner exchange
		#Couldn't read packet: Connection reset by peer
		#Authentication failed
		if (/^ssh: |Connection reset by peer/) result=2
		#SFTP login failed due to too many established ssh connections: result=1
		#ssh_exchange_identification: Connection closed by remote host
		if (result==0 && /Connection closed|Permission denied|Authentication failed/) result=1
		if (/ssh_exchange_identification: Connection closed by remote host|Connection timed out during banner exchange/) error=$0
	}
	if (result > 0) close(sftp_session)
	return result":"error
}
function ftpclose(result)
{
	close(server)
	close(portcmd)
	return result
}
function docmd(ftpd,cmd,silent)
{
	$0 = cmd;
	cmd = toupper($1);
	if (cmd == "GET" && $3 ~ /:/ && $3 !~ /^.:/) gsub(/:/,".",$3)   #windows cannot handle filenames containing a colon
	if (silent != "silent") customPrint(sprintf("%s ... ",$0),"","force","noLF")

	if (cmd == "CWD"  ||  cmd == "CD") { if (docwd(ftpd, $2)=="FATALERROR") return "FATALERROR" }
	else if (cmd == "PWD") dopwd(ftpd);
	else if (cmd == "LIST"  ||  cmd == "NLST"  ||  cmd == "LS") { if (dolist(ftpd, cmd, $2)=="FATALERROR") return "FATALERROR" }
	else if (cmd == "RETR"  ||  cmd == "GET") { if (doretr(ftpd, "I", $2, $3)=="FATALERROR") return "FATALERROR" }
	else if (cmd == "STOR"  ||  cmd == "PUT") { if (dostor(ftpd, "I", $2, $3)=="FATALERROR") return "FATALERROR" }
	else if (cmd == "DELE") { if (dodele(ftpd, $2)=="FATALERROR") return "FATALERROR" }
	else if (cmd ~  "MKD")  { if (domkd(ftpd, $2)=="FATALERROR")  return "FATALERROR" }
	else if (cmd ~  "RMD")  { if (dormd(ftpd, $2)=="FATALERROR")  return "FATALERROR" }
	else if (cmd == "RENAME") dorename(ftpd, $2, $3);
	else customPrint(sprintf("%s: unknown command: %s\n", program, cmd),"","force","noLF")

	return (0);
}

function noctrl(line)
{
	sub(/[ \t\r\n]+$/, "", line)
	return (line)
}

function cfgets(ftpd,   line)
{
	if (ftpd |& getline line > 0)
	{
		line = noctrl(line)
		if (mosdebug == 1)	printf (">>> %s\n", line) >>STDERR
		return (line)
	}
	return ("\001")
}

function cfputs(ftpd, line)
{
	line = noctrl(line)
	if (mosdebug == 1)	printf ("<<< %s\n", line) >>STDERR
	if (os == "cygwin") printf("%s\r\r\n",line) |& ftpd    #two <cr> needed on windows
	else printf("%s\r\n",line) |& ftpd                        #one <cr> only on solaris/linux otherwise not work with cppemu
	fflush()
	return (0)
}

function cfputc(ftpd, cmd, arg, result,   k, rc, line, fatal)
{
	if (cmd != "")
	{
		line = cmd
		if (arg != "")	line = cmd " " arg
		cfputs(ftpd, line)
	}
	line = cfgets(ftpd)
	if ((k = index(line, " ")) == 0) rc = line
	else rc = substr(line, 1, k-1)
	#Adaptation for Cello
	if (rc ~ /Welcome/)
	{
		line = cfgets(ftpd);
		if (line == "") line = cfgets(ftpd);  # for handling backup mode where there is an empty line
		if ((k = index(line, " ")) == 0) rc = line;
		else rc = substr(line, 1, k-1);
	}
	#End of Cello adaptation
	fatal = 1;
	if (result < 0)
	{
		result = -result
		fatal = 0
	}
	rc = toupper(rc);

	if (result != ""  &&  rc != result)
	{
		if (mosdebug == 1) printf ("%s: protocol error: %s\n", program, line) >>STDERR
		FATALERROR=sprintf("Protocol error %s", line)
		if (fatal == 1) return "FATALERROR"
	}
	return (line)
}

function doport(ftpd, options,   local, x, high, low,oldlocal)
{
	# Yes, this is difficult.  We open a second connect, this time
	# in FTP-DATA mode.  This returns information about the local
	# interface and port which is used to construct the FTP PORT
	# command.
	#

	portcmd = sprintf ("%s -t %s -a %s: %s", connect, ftp_timeout, interface, options);

	close(portcmd);
	portcmd |& getline local;
        if (os=="linux")
        {
        	#problem with linux which allocates ports randomly instead of sequentially like solaris/cygwin
        	#we check if the port has already been used
        	if (local in ftpDataPortList) { oldlocal=local ; close(portcmd) ; portcmd |& getline local ; if (mosdebug==1) print "Port "oldlocal" already used, 2nd attempt to find another one" }
		if (local in ftpDataPortList) { oldlocal=local ; close(portcmd) ; portcmd |& getline local ; if (mosdebug==1) print "Port "oldlocal" already used, 3rd attempt to find another one" }
		if (local in ftpDataPortList) { oldlocal=local ; close(portcmd) ; portcmd |& getline local ; if (mosdebug==1) print "Port "oldlocal" already used, 4th attempt to find another one" }
		if (local in ftpDataPortList) { oldlocal=local ; close(portcmd) ; portcmd |& getline local ; if (mosdebug==1) print "Port "oldlocal" already used, 5th attempt to find another one" }
		if (local in ftpDataPortList) { oldlocal=local ; close(portcmd) ; portcmd |& getline local ; if (mosdebug==1) print "Port "oldlocal" already used, 6th attempt to find another one" }
		if (local in ftpDataPortList) { oldlocal=local ; close(portcmd) ; portcmd |& getline local ; if (mosdebug==1) print "Port "oldlocal" already used, 7th attempt to find another one" }
		ftpDataPortList[local]=local
	}

	split(local, x, ":");
        if (mosdebug==1) print "DEBUG: data port = "local ", portcmd = "portcmd;
	#
	# Compute the PORT command's parameter ...
	# example: local=a.b.c.d:2308 ==> local=153,88,16,12,9,4


	high = int(x[2] / 256);
	low = x[2] - high * 256;

	local = x[1] "," high "," low;
	gsub(/\./, ",", local);

	#
	# ... and send it to the server.
	#
	if (cfputc(ftpd, "PORT", local, 200)=="FATALERROR")
	{
		#very important to close portcmd since ftpclose will not be able to close it since we replace portcmd with FATALERROR
		close(portcmd)
		return "FATALERROR"
	}

	#
	# Return the portcmd for the data transmission.
	#

	return (portcmd);
}

function dolist(ftpd,cmd,dir,   line)
{
	if (cfputc(ftpd, "TYPE", "A", 200)=="FATALERROR") return "FATALERROR"

	#
	# Allocate a local port for the data transmission, send the
	# data to the server (done by doport()).
	#

	portcmd = doport(ftpd, "");
	if (portcmd=="FATALERROR") return "FATALERROR"

	#
	# Send the LIST command, wait for the server to connect and
	# read the peer information from portcmd.
	#

	if (cfputc(ftpd, (cmd != "NLST")? "LIST": "NLST", dir, 150)=="FATALERROR") return "FATALERROR"
	portcmd |& getline line;

	#
	# Read directory listing till the end of file ...
	#
	print ""
	while (portcmd |& getline line)
	{
		noctrl(line);
		printf("%s\n", line);
	}

	#
	# ... close our data transmission channel and read the final
	# `transfer complete' message from the server.
	#

	close (portcmd);
	if (cfputc(ftpd, "", "", 226)=="FATALERROR") return "FATALERROR"

	return (0);
}


function doretr(ftpd,mode,remotename,localname,    line,localfilealreadythere)
{
	#if the remote filename contains a path to a directory, we change to that directory first, then we remove the path from the file name
	if (remotename ~ /\//)
	{
		#NOT needed
		#if we are running a commandlist we need to check the current directory, and change back to it at the end
		#if (command=="")
		#{
		#	currentDir=dopwd(ftpd,"silent")
		#}
		#
		if (docwd(ftpd,gensub(/(.*\/).*$/,"\\1",1,remotename))=="FATALERROR") return "FATALERROR"
		remotename=gensub(/^.*\//,"","g",remotename)
	}

	if (localname == "") localname = remotename;
	else if (localname == "-") localname = REALSTDOUT;

	#check if the local file was already there:
	# - if it was already there and the transfer fails then we leave it.
	# - if it was not already there and the transfer fails then we remove it.
	localfilealreadythere=fileOps("test -f "localname)

	# Retrieving files from the server is basically the same as
	# we do in dolist().  We have however to deal with binary files.
	#

	if (cfputc(ftpd, "TYPE", mode, 200)=="FATALERROR") return "FATALERROR"
	portcmd = doport(ftpd, mode == "A"? "": "-w " localname);
	if (portcmd=="FATALERROR") return "FATALERROR"
	line = cfputc(ftpd, "RETR", remotename, 150);
	if (line=="FATALERROR")
	{
		if (localfilealreadythere==1) fileOps("rm "localname)
		return "FATALERROR"
	}
	portcmd |& getline line;
	if (mode != "A")
	{
		# If we are doing a binary transfer our data channel
		# connect does all the work.  We read a line from connect
		# which will never appear.  But if we receive the EOF
		# we know that connect has finished.
		#

		portcmd |& getline line;
	}
	else
	{
		#
		# ASCII transfers are read line by line and written
		# manually to the local file.  But we could process text
		# files the same way as we handle binary files.
		#

		while (portcmd |& getline line)
		{
			noctrl(line);
			printf("%s\n", line) >localfile;
		}
	}

	close (portcmd);
	close (localfile);
	if (cfputc(ftpd, "", "", 226)=="FATALERROR") return "FATALERROR"

	#NOT needed
	#if (command=="" && currentDir !="")
	#{
	#	if (docwd(ftpd,currentDir)=="FATALERROR") return "FATALERROR"
	#}

	return (0);
}


function dostor(ftpd,mode,localname,remotename,   oldPwd,line)
{
	#if the remote filename contains a path to a directory, we change to that directory first, then we remove the path from the file name
	if (localname ~ /\//)
	{
		oldPwd=fileOps("pwd")
		if (chdir(gensub(/(.*\/).*$/,"\\1",1,localname)) != 0) return "FATALERROR"
		localname=gensub(/^.*\//,"","g",localname)
	}

	if (localname == "-") localname = REALSTDIN;
	else if (remotename == "") remotename = localname;

	#
	# We store files in a different way.  But we handle everything
	# as binary also.
	#

	if (cfputc(ftpd, "TYPE", mode, 200)=="FATALERROR")
	{
		if (oldPwd != "") chdir(oldPwd)
		return "FATALERROR"
	}
	portcmd = doport(ftpd, "-r " localname);
	if (portcmd=="FATALERROR")
	{
		if (oldPwd != "") chdir(oldPwd)
		return "FATALERROR"
	}

	if (cfputc(ftpd, "STOR", remotename, 150)=="FATALERROR")
	{
		if (oldPwd != "") chdir(oldPwd)
		return "FATALERROR"
	}
	portcmd |& getline line;

	#
	# Wait for connect to finish.
	#

	portcmd |& getline line;

	close (portcmd);
	if (cfputc(ftpd, "", "", 226)=="FATALERROR")
	{
		if (oldPwd != "") chdir(oldPwd)
		return "FATALERROR"
	}
	if (oldPwd != "") chdir(oldPwd)
	return (0);
}

function dorename(ftpd, oldname, newname)
{
	if (cfputc(ftpd, "RNFR", oldname, 350) + 0 == 350) cfputc(ftpd, "RNTO", newname, 250);

	return (0);
}


function dodele(ftpd, remotename)
{
	if (cfputc(ftpd, "DELE", remotename, 250)=="FATALERROR") return "FATALERROR"
	return (0);
}

function domkd(ftpd, dir)
{
	if (cfputc(ftpd, "MKD", dir, 257)=="FATALERROR") return "FATALERROR"
	return (0);
}

function dormd(ftpd, dir)
{
	if (cfputc(ftpd, "RMD", dir, 250)=="FATALERROR") return "FATALERROR"
	return (0);
}

function docwd(ftpd, dir)
{
	if (cfputc(ftpd, "CWD", dir, 250)=="FATALERROR") return "FATALERROR"
	return (0);
}

function dopwd(ftpd, silent, dir,   line)
{
	line = cfputc(ftpd, "PWD", "", 257);
	if (line + 0 == 257)
	{
		sub(/^[^ ]+ +/, "", line);
		if (substr(line, 1, 1) != "\"") sub(/ .*$/, "", line);
		else
		{
			line = substr(line, 2);
			sub(/".*$/, "", line);
		}

		if (silent == "") printf("%s\n", line);
	}

	if (silent != "") return line;
	else return (0);
}
function find_echo_command(   result)
{
	result="echo"
	if (test_echo_command("echo")==0) result="echo"
	else if (test_echo_command("echo -e")==0) result="echo -e"
	else if (test_echo_command("/bin/echo")==0) result="/bin/echo"
	else if (test_echo_command("/bin/echo -e")==0) result="/bin/echo -e"
	#print "echo_command="result
	return result
}
function test_echo_command(command,  result,line,thecommand)
{
	result=0
	thecommand=command" \x27\\n\x27"
	while (thecommand |& getline line)
	{
		if (line ~ /(-e|\\n)/) result=1
	}
	close(thecommand)
	return result
}
function Local_command(command,silent,what,     array,ret,newdir,cwd,last,bgpid)
{
	if (command ~ /^[ \t]*echo[ \t]/ && command !~ /^[ \t]*echo[ \t]+-e/)
	{
		if (echo_command=="") echo_command=find_echo_command()
		sub("echo",echo_command,command)
		#print "modified command: "command
	}
	if (silent=="") customPrint("")
	last=split(command,array," ")
	if (array[1] == "cd")
	{
		if (array[2] == "") newdir=ENVIRON["HOME"]
		else newdir=gensub(/^[ \t]*cd[ \t]+|[ \t]*$/,"","g",command)
		#else newdir=array[2]
		ret=chdir(newdir)
		if (ret < 0) customPrint(sprintf("Could not change to %s: %s",newdir, ERRNO))
		else if (ret == 0)
		{
			close("pwd") ; "pwd" | getline cwd ; close("pwd")
			if (silent=="") customPrint(sprintf("New directory: %s",cwd))
		}
	}
	else if (array[last] ~ /&$/)
	{
		#the command is being put in the background
		#we assign its PID to the scripting variable $background_pid
		empty_file(tempbgpidlog)
		system(sprintf("%s\necho $! > %s",command,tempbgpidlog))
		getline bgpid < tempbgpidlog
		close(tempbgpidlog)
		assignCustomVar("$background_pid",bgpid,"print")
	}
	else
	{
		#the unix command is only logged if it was called with "l", not if it was called with "!"
		#the unix command is only logged if it is not redirected to a logfile
		if (logging==1 && what=="l" && command !~ ">"){ command=command" | tee -a "logfile }
		#must pass the PERLLIB environment variable http://newtran01.au.ao.ericsson.se/moshell/forum_viewtopic.php?4.8851
		#dont put PERLLIB in front if the command is within brackets, such as $moncommand on EvoC8300/DUSg2
		if (perllib!="" && command!~/^[ \t]*\([^)]+\)/) command="PERLLIB="perllib" "command
		if (mosdebug==1) print command
		system(command)
	}
}
function checkPerm(file,what,   resTable,h2b_table,n,a,result)
{
	#h2b_table["0"]="0000";	h2b_table["1"]="0001";	h2b_table["2"]="0010";	h2b_table["3"]="0011"
	#h2b_table["4"]="0100";	h2b_table["5"]="0101";	h2b_table["6"]="0110";	h2b_table["7"]="0111"
	#h2b_table["8"]="1000";	h2b_table["9"]="1001";	h2b_table["A"]="1010";	h2b_table["B"]="1011"
	#h2b_table["C"]="1100";	h2b_table["D"]="1101";	h2b_table["E"]="1110";	h2b_table["F"]="1111"
	#b2h_table["000"]="0" ;	b2h_table["001"]="1" ;	b2h_table["010"]="2" ;	b2h_table["011"]="3"
	#b2h_table["100"]="4" ;	b2h_table["101"]="5" ;	b2h_table["110"]="6" ;	b2h_table["111"]="7"
	#b2h_table["0000"]="0";	b2h_table["0001"]="1";	b2h_table["0010"]="2";	b2h_table["0011"]="3"
	#b2h_table["0100"]="4";	b2h_table["0101"]="5";	b2h_table["0110"]="6";	b2h_table["0111"]="7"
	#b2h_table["1000"]="8";	b2h_table["1001"]="9";	b2h_table["1010"]="A";	b2h_table["1011"]="B"
	#b2h_table["1100"]="C";	b2h_table["1101"]="D";	b2h_table["1110"]="E";	b2h_table["1111"]="F"

	delete resTable
	stat(file,resTable)
	if (what=="short") return sprintf("%o",resTable["mode"])
	else return resTable["pmode"]":"sprintf("%o",resTable["mode"])
	#n=split(toupper(sprintf("%X",strtonum(resTable["mode"]))),a,"")
	#for (i=1;i<=n;i++)
	#{
	#	result=result h2b_table[a[i]]
	#}
	#split(result,a,"")
	#return resTable["pmode"]":"sprintf("%s%s%s%s%s",b2h_table[sprintf("%s%s%s%s",a[1],a[2],a[3],a[4])],b2h_table[sprintf("%s%s%s",a[5],a[6],a[7])],b2h_table[sprintf("%s%s%s",a[8],a[9],a[10])],b2h_table[sprintf("%s%s%s",a[11],a[12],a[13])],b2h_table[sprintf("%s%s%s",a[14],a[15],a[16])])
}
function chmodDir(perm,dir,    pwd,newpwd,flag,res,array,a,oldPerm,newPerm)
{
	oldPerm=checkPerm(dir,"short")
	newPerm=sprintf("%o",perm)"$"
	if (oldPerm ~ newPerm) return #dont attempt chmod if the permission is already according to expectation
	if (mosdebug==1) print "CHMOD: "sprintf("%o",perm),dir ". oldPerm: "oldPerm
	pwd=fileOps("pwd")
	Local_command("cd "dir,"silent")
	newpwd=fileOps("pwd")
	Local_command("cd "pwd,"silent")
	if (isHomeDir(newpwd)==1)
	{
		#if the directory is the home directory, check the old permissions in order to keep the old group and world permissions
		split(checkPerm(newpwd),a,"")  #drwxrwxrwx:40777
		oldPerm=sprintf("%s%s",a[15],a[16])
	}
	if (in_amos_mode())
	{
		if (isHomeDir(newpwd)==1)
		{
			if (oldPerm=="00") { chmod(01700,dir) ; res="01700" }
			else if (oldPerm~/0$/) { chmod(01750,dir) ; res="01750" }
			else { chmod(01755,dir) ; res="01755" }
		}
		else
		{
			chmod(01777,dir) #TR HL96864
			res="01777"
		}
	}
	else
	{
		if (isHomeDir(newpwd)==1)
		{
			if (oldPerm=="00") { chmod(00700,dir) ; res="00700" }
			else if (oldPerm~/0$/) { chmod(00750,dir) ; res="00750" }
			else { chmod(00755,dir) ; res="01755" }
		}
		else
		{
			chmod(perm,dir)
			res=perm
		}
	}
	if (mosdebug==1) print pwd,newpwd,dir,sprintf("%o",res)
}
function isHomeDir(dir,   res)
{
	res=0
	if (dir == ENVIRON["HOME"]) res=1
	#consider the case where the directory is /home/user but the $HOME is /local/home/user, or vice-versa
	else
	{
		#print ENVIRON["HOME"],dir,gensub(/^.*\/home\//,"/home/",1,dir),
		if (gensub(/^.*\/home\//,"/home/",1,dir)==ENVIRON["HOME"] || gensub(/^.*\/home\//,"/home/",1,ENVIRON["HOME"])==dir) res=1
	}
	return res
}
function fileOps(command,fileList,noscandir,start_date,end_date,nochmod,   \
array,result,fileProps,fileListTemp,n,tmpfile,i,last,testresult,dummy,thisisadirectory,cwd,dirtocreate,\
mkdirp,newdirtocreate,tmpresult,start,sbuf,ftree_session,tmp_timestamp,the_dir,report_time,res_time,grep_session,gzip_session,ls_session,line,j,z,ar,statres,statdata)
{
	#if (mosdebug==1) print command
	#examples of commands:
	# rm file1
	# mv file1 file2
	# cp file1 file2
	# test -s file1 --> the file exists and its size is not equal to 0
	# test -f file1 --> the file exists
	# test -d dir1  --> the directory exists
	# test -r file1 --> the file is readable
	# test -w file1 ---> the file or directory is writeable
	# "ls dir1",fileList  ---> the contents of dir1 is stored in the array fileList, indexes go from 1 to n where n is the returned value (-1 if dir cannot be listed)
	last=split(command,array," ")
	if (array[1]=="rm" && array[2] != "")
	{
		close(array[2])
		return unlink(array[2])
	}
	else if (array[1]=="pwd")
	{
		"pwd" | getline cwd ; close("pwd")
		return cwd
	}
	else if (array[1]=="gzip" && array[2]=="-t")
	{
		testresult=0
		command=command" 2>&1"
		while (command |& getline line)
		{
			gsub("\r","",line)
			if (line ~ /gzip:/) testresult=1
		}
		close(command)
		return testresult
	}
	else if (array[1]=="test")
	{
		if (last < 3 || array[3] ~ /\|/) return 1   #if the string contains a pipe, "test -f" would return 0. Since a filename cannot contain a pipe we return 1
		if (last > 3) #to cope for file names containing spaces
		{
			for (i=3;i<=last;i++) tmpfile=sprintf("%s %s",tmpfile,array[i])
			tmpfile=handleSpaceInFile(tmpfile,"noslash")
		}
		else tmpfile=array[3]

		#First check if it's a directory (otherwise it crashes getline if we do getline on a directory)
		thisisadirectory=0
		if (noscandir == "")
		{
			if (use_scandir==0)
			{
				if (system("test -d \""tmpfile"\"")==0) thisisadirectory=1
			}
			else
			{
				delete fileListTemp #always has to be initialised before running stat
				stat(tmpfile,fileListTemp)
				if (fileListTemp["type"]=="directory") thisisadirectory=1
				else if (fileListTemp["type"]=="symlink")
				{
					delete fileListTemp  #always has to be initialised before running scandir
					n=scandir(tmpfile,fileListTemp)
					if (n >= 2) thisisadirectory=1
				}
			}
		}
		if (thisisadirectory)
		{
			if (array[2]=="-d") return 0
			else return 1
		}

		#here we handle "-s" and "-f"

		if (os=="cygwin" && tmpfile=="File_not_found") return 1

		#return system(sprintf("test %s %s >/dev/null 2>&1",array[2],tmpfile))

		#Note: the code below is not a good idea to use getline because it opens and closes a file which may already be open for reading somewhere else in the same process
		#eg: make a file called "root" containing the line "lt root" and run it with "run": it goes into a loop due to the use of "test -s" in the "lt" function
		#also sometimes this hangs when the file is not existing, so we must check if the file exists first
		#### close(tmpfile) ; testresult=(getline dummy < tmpfile) ; close(tmpfile)
		#### if (array[2] ~ /^-[sr]$/ && testresult >0) return 0
		#### else if (array[2]=="-f" && testresult >=0) return 0
		#### else return 1

		#We now replaced the bad code above with this:
		delete statdata
		statres=stat(tmpfile,statdata)
		#for(i in statdata) print i,statdata[i]
		if (array[2] ~ /^-[sr]$/ && statres==0 && statdata["type"]=="file" && statdata["size"]>0) return 0
		else if (array[2]=="-f"  && statres==0 && statdata["type"]=="file") return 0
		else if (statres==0)
		{
			#now use the bad code, eg in case the file is a symbolic link, or a special file like /dev/null
			close(tmpfile) ; testresult=(getline dummy < tmpfile) ; close(tmpfile)
			if (array[2] ~ /^-[sr]$/ && testresult >0) return 0
			else if (array[2]=="-f" && testresult >=0) return 0
			else return 1
		}
		else return 1

		#This part doesn't work with symbolic links, use system call instead.
		#fileProps[0]=""  #initialization needed for the stat function
		#if (stat(array[3],fileProps) < 0) return 1
		#else
		#{
		#	result=0
		#	if (array[2] ~ "s" && (fileProps["size"] == 0 || fileProps["type"] != "file")) result=1
		#	if (array[2] ~ "f" && fileProps["type"] != "file") result=1
		#	if (array[2] ~ "d" && fileProps["type"] != "directory") result=1
		#}
		#return result
	}
	else if (array[1]=="ls")
	{
		if (array[2] == "") return(-1)
		if (use_scandir==1)
		{
			fileListTemp[0]==""
			n=scandir(array[2],fileListTemp)
			if (n < 0) return n
			# we dont count the two first files "." and ".."
			for (i=3;i<=n;i++) fileList[i-2]=fileListTemp[i]
			#for (i=1;i<=(n-2);i++) print i,fileList[i]
			return n-2
		}
		else
		{
			delete fileList
			i=0
			ls_session="ls -1 "array[2]
			while ((ls_session |& getline line)>0)
			{
				gsub("\r","",line)
				fileList[++i]=line
			}
			close(ls_session)
			n=i
			#for (i=1;i<=n;i++) print i,fileList[i]
			return n
		}
	}
	else if (array[1]=="mv" && array[3] != "")
	{
		#close the files first to avoid problems
		close(array[2]) ; close(array[3])
		#tmpresult = rename(array[2],array[3])   ---> this kernel function does not work when the files are on different file systems
		tmpresult = system(sprintf("mv -f \"%s\" \"%s\"",array[2],array[3]))
		if (tmpresult != 0) customPrint("ERROR: mv "array[2]" "array[3]" FAILED.")
		return tmpresult
	}
	else if (array[1]=="cp" && array[3] != "")
	{
		#close the files first to avoid problems
		close(array[2]) ; close(array[3])
		#on cygwin the copy function can corrupt the file, e.g. when copying a dll file
		#if (os=="cygwin") tmpresult=system(sprintf("cp \"%s\" \"%s\"",array[2],array[3]))
		#else tmpresult = copy(array[2],array[3])
		#always use the system call to the "cp" utility
		tmpresult=system(sprintf("cp \"%s\" \"%s\"",array[2],array[3]))
		if (tmpresult != 0) customPrint("ERROR: cp "array[2]" "array[3]" FAILED.")
		return tmpresult
		#old code: return system("cp "array[2]" "array[3])
	}
	else if (array[1]=="mkdir")
	{
		#if (mosdebug==1) print "MKDIR: "command
		if (array[2]=="-p")
		{
			dirtocreate=array[3]
			mkdirp=1
		}
		else dirtocreate=array[2]
		if (fileOps("test -d "dirtocreate)==0)
		{
			if (dirtocreate!~/[/]home[/]?$/ && in_amos_mode()!=1 && nochmod!="nochmod") chmodDir(00777,dirtocreate)
			return 0
		}
		if (mkdirp==1)
		{
			last=split(dirtocreate,array,"/")
			if (array[1]=="")
			{
				start=2 ; newdirtocreate="/"
			}
			else start=1
			for (i=start;i<=last;i++)
			{
				if (start==1) newdirtocreate="" ; else if (start==2) newdirtocreate="/"
				for (j=start;j<=i;j++) newdirtocreate=sprintf("%s%s/",newdirtocreate,array[j])
				tmpresult=fileOps("mkdir "newdirtocreate,"","","","","nochmod")
				if (tmpresult != 0)
				{
					customPrint("ERROR: mkdir -p "dirtocreate" FAILED.")
					return tmpresult
				}
			}
			if (in_amos_mode()!=1) chmodDir(00777,dirtocreate)
			return 0
		}
		tmpresult = mkdir(dirtocreate,0755)
		if (tmpresult != 0) customPrint("ERROR: mkdir "dirtocreate" FAILED.")
		else if (in_amos_mode()!=1) chmodDir(00777,dirtocreate)
		return tmpresult
		#return mkdir(array[2],
		#return system(command)
	}
	else if (array[1]=="touch")
	{
		if (touch(array[2]) < 0) return 1
		else return 0
	}
	else if (array[1]=="stat")
	{
		#example: fileOps("stat mtime /home/eanzmagn/textfile.txt")
		#return the value of the stat table or -1 in case of error
		if (array[3]=="") return -1
		tmpresult= "-1"
		if ((array[2]=="size" && array[3]~/\.xml\.gz$/)||(array[2]=="sizex" && array[3]~/\.log\.gz$/))
		{
			#we return the size of the uncompressed file
			gzip_session="gzip -l "array[3]
			while ((gzip_session |& getline line)>0)
			{
				#compressed  uncompr. ratio uncompressed_name
				#   289981   3515263  91.7% moshell/jarxml/RNC_NODE_MODEL_G_1_4_COMPLETE.xml
				gsub("\r","",line)
				z=split(line,ar," ")
				if (ar[z] ~ /\.(xml|log)$/) tmpresult=ar[2]
			}
			close(gzip_session)
			return tmpresult
		}
		if (array[2]=="sizex") array[2]="size"
		delete sbuf #variable must be initialised as an array
		stat(array[3],sbuf)
		return sbuf[array[2]]
	}
	else if (array[1]=="ftree")
	{
		#no error handling at all in this part, quick and dirty
		# 1.Recursive file listing
		#call the function with: n=fileOps("ftree "dirtocheck,fileList,["",startDate,endDate])
		#n is the number of files found,
		#fileList is the array containing all file names
		#if startDate and endDate are specified only the files last modified in this date range will be returned
		# 2.Finding the latest timestamp in a file tree: option -t
		#timestamp=fileOps("ftree -t "dirtocheck)

		#print "ftree:",mystrftime("%Y%m%d %H:%M:%S",start_date),mystrftime("%Y%m%d %H:%M:%S",end_date)

		delete fileList
		if (array[2]=="-t")
		{
			the_dir=array[3]
			report_time=1
		}
		else the_dir=array[2]
		ftree_session="find "the_dir" -type f"
		while ((ftree_session |& getline)>0)
		{
			#/home/eanzmagn/moshell_logfiles/logs_moshell/pmfiles/a.b.c.d/gpeh/p021700/A20060314.1645-1700_GPEH.lnk.gz
			#/home/eanzmagn/moshell_logfiles/logs_moshell/pmfiles/a.b.c.d/gpeh/pm_data/A20060314.1400-1415_gpehfile.2.lnk
			#/home/eanzmagn/moshell_logfiles/logs_moshell/pmfiles/a.b.c.d/uetr/pm_data/A20060308.0915-0930_UETR_10013.bin
			#/home/eanzmagn/moshell_logfiles/logs_moshell/pmfiles/a.b.c.d/gpeh/p001400_BJ4_A20090508.0400-0415_GPEH.lnk.gz
			#/home/eanzmagn/moshell_logfiles/logs_moshell/pmfiles/a.b.c.d/uetr/BJ4_A20090508.0400-0415_UETR_10000.bin.gz
			#New revision numbering from [A-Z][A-Z][0-9] to [A-Z] or can also be [A-Z][0-9][0-9]
			#/home/eanzmagn/moshell_logfiles/logs_moshell/pmfiles/a.b.c.d/gpeh/p011600_B_A20140924.1730-1745_GPEH.lnk.gz
			#/home/eanzmagn/moshell_logfiles/logs_moshell/pmfiles/a.b.c.d/gpeh/B_A20140924.1730-1745_gpehfile.2.lnk.gz
			#/proj/wcdmaiov/eanzmagn/moshell_logfiles/logs_moshell/pmfiles/a.b.c.d/gpeh/r002400_N11_A20170118.2200-2215_GPEH.lnk.gz
			#/proj/tfwlogs_wmr/robustness/eramakl/moshell_logfiles/logs_moshell/pmfiles/a.b.c.d/gpeh/r0008D01_U_A20171207.0730-0745_GPEH.lnk.gz
			#/proj/wcdmaiov/eanzmagn/moshell_logfiles/logs_moshell/pmfiles/a.b.c.d/uehException/p000300_132_detailed_20200515.csv.gz
			#G2 ROP files only have ".gz" at the end
			gsub("\r","")
			tmp_timestamp=make_file_timestamp($1,".(lnk|bin|xml|gz|csv)(.gz)*$")  #; print $1,mystrftime("%Y%m%d %H:%M:%S",tmp_timestamp)
			if (report_time==1 && tmp_timestamp > res_time) res_time=tmp_timestamp
			else if (tmp_timestamp >= start_date || start_date=="")
			{
				if (tmp_timestamp <= end_date || end_date=="") fileList[++i]=$1
			}
		}
		close(ftree_session)
		if (report_time==1) return res_time
		else return i
	}
	else if (array[1]=="grep" || array[1]=="grepc")
	{
		#grep <string> <file> ---> returns 0 if the string was found and 1 if not
		if (fileOps("test -s "array[3])!=0) return 1
		testresult=1
		if (array[3] ~ /.jar$/) grep_session="unzip -p "array[3]" \\*.xml"
		else if (array[3] ~ /.gz$/) grep_session="gzip -dc "array[3]
		else grep_session="cat "array[3]
		while ((grep_session |& getline line)>0)
		{
			if (array[1]=="grepc")
			{
				if (line ~ array[2]) testresult++
			}
			else
			{
				if (testresult==0) continue
				if (line ~ array[2]) testresult=0
			}
		}
		close(grep_session)
		return testresult
	}

	return 1   #for cases that failed
	#groff -man -Tascii file-1.0.0/awk.file.1
	#AWK.FILE.SO(1)                                                  AWK.FILE.SO(1)
	#
	#NAME
	#       awk.file.so - file system extension for gawk
	#
	#DESCRIPTION
	#       awk.file.so is an extension module for gawk, version 3.1.1 (compatibil-
	#       ity with other is not clear - it might work or not).  It provides func-
	#       tion for direct file system access level.
	#
	#       Before  the  functions contained in the library can be used from within
	#       gawk the module has to be loaded with gawk's extension function:
	#
	#            extension("/path/to/awk.file.so", "dlload");
	#
	#       After the extension has been loaded the additional function can be used
	#       a any other builtin function.
	#
	#   Temporary Files
	#       The  mktemp(dir, prefix) function returns the name of a temporary file.
	#       The filename is expected to be unique.   Furthermore  mktemp  tries  to
	#       unlink  the  file  if it already exists.  Temporary files are automati-
	#       cally removed when gawk terminates normally, that is with  a  non-fatal
	#       exception.
	#
	#   File Locking
	#       The  lock(lockfile)  function  can be used to create lockfiles.  lock()
	#       will fail if lockfile already exists.  lockfile() is created  using  an
	#       atomic  open(2)  call  so  the lock() is safe as long as processes with
	#       similiar locking schemes try to create the lock file.
	#
	#       unlock(filename) removes a previously created lock file.
	#
	#       Notice that lockfile is in no way related to the  locked  object.   The
	#       sleep()  function  may be of some help while waiting for processes that
	#       have already created a lock.
	#
	#       Lock files are, similiar to temporary files, automatically removed when
	#       gawk terminates normally.
	#
	#FUNCTIONS
	#       The following functions are implemented.
	#
	#       chdir(dir)
	#              makes dir the current directory.
	#
	#       copy(src, dst)
	#              copies file src to dst.  Both parameters have to be filenames.
	#
	#       lock(lockfile)
	#              creates the lock file lockfile if it does not already exist.
	#
	#       mkdir(dir, mode)
	#              creates the directory dir with the permissions in mode.  mode is
	#              interpreted as numeric argument.  If mode starts with a  leading
	#              zero `0' it is interpreted as octal number and as decimal other-
	#              wise.
	#
	#       mklink(oldname, newname)
	#              creates newname as a hard link to oldname.
	#
	#       mksymlink(oldname, newname)
	#              creates newname as a symbolic link to oldname.
	#
	#       mktemp([dir[, prefix]])
	#              returns the name of a temporary  file.   The  file  will  be  in
	#              directory  dir  (/tmp  is  the  default) and will have prefix as
	#              filename prefix (the default is awk-).
	#
	#       rename(src, dst)
	#              renames src to dst.  rename can be used to  move  files  between
	#              directories.
	#
	#       rmdir(dir)
	#              removes directoy dir.
	#
	#       scandir(dir, list)
	#              enumerates the files and directories in dir and stores  them  in
	#              the  array list.  scandir() returns the number n of files found,
	#              the indexes in list go from 1 to n.
	#
	#       setenv(var, val)
	#              assigns val to the environment variable var which is  accessable
	#              by  subprocesses  (for gawk by reading values from the ENVIRON[]
	#              array).
	#
	#       sleep(seconds)
	#              makes gawk sleep for seconds seconds.  sleep returns the  amount
	#              of  time left to sleep if it was interrupted and zero otherwise.
	#
	#       unlink(file)
	#              removes file.
	#
	#       unlock(lockfile)
	#              removes lockfile if it has been previously created by  the  run-
	#              ning process.
	#
	#   Error Codes
	#       Most  of  the function resemble system calls.  They return 0 on success
	#       and a negative value on error.  In the latter case gawk's  ERRNO  vari-
	#       able will be set.
	#
	#       unlock()  returns  1 if the given lock file was not created by the run-
	#       ning gawk process.
	#
	#       stat(file, sbuf)
	#              stores  file's  inode information in the associative array sbuf.
	#              sbuf must be initialised an array.
	#              returns 0 if file exists and -1 if not
	#              Content of the sbuf array:
	#         dev      1949407677           device number of filesystem
	#         ino      4.78507e+15		inode number
	#         mode     33279		file mode  (type and permissions)
	#         nlink    1			number of (hard) links to the file
	#         uid      544			numeric user ID of file's owner
	#         gid      4.29497e+09		numeric group ID of file's owner
	#         rdev     			the device identifier (special files only)
	#         size     3461055		total size of file, in bytes
	#         atime    1141632214		last access time since the epoch
	#         mtime    1141582196		last modify time since the epoch
	#         ctime    1141582196		inode change time (NOT creation time!) since the epoch
	#         blksize  1024			preferred block size for file system I/O
	#         blocks   3380			actual number of blocks allocated

	#         type file
	#         name moshell_logfiles/logs_moshell/RNC37_DUMPS/RNC37_getp.log
	#         pmode -rwxrwxrwx

}
function convert_gregorian_to_epoch(timestamp)
{
	#the gregorian time starts at 1582-10-15 , the epoch at 1970-01-01
	#there is a difference of 12219292800 seconds between both
	#the gregorian is given in 100 ns, must thus be divided by 10 000 000
	return int(timestamp/10000000)-12219292800
}
function make_file_timestamp(file,file_extension,  a,res,s,g)
{
	#BGF:      A20191130.2114+0000-2115+0000_1.xml.gz
	#YANG:     A20220208.2215+0000-2230+0000_1.xml.gz
	if (file ~ /(^|\/)A[1-2][0-9][0-9][0-9][0-9][0-9][0-9][0-9]\.[0-9][0-9][0-9][0-9][+][0-9][0-9][0-9][0-9]-[0-9][0-9][0-9][0-9][+][0-9][0-9][0-9][0-9]_[0-9]\.xml/) gsub(/[+][0-9][0-9][0-9][0-9]/,"",file)
	#return the timestamp of a ROP file
	#Eg: A20060314.1645-1700_GPEH.lnk.gz  --> timestamp will be 20060314 1700
	#Exception: if the ROP ends at midnight then we must give the date of the next day, eg: A20060314.2345-000 will be 20060315 0000
	res=""
	if (file ~ file_extension && file ~ /(^|\/)([pr][0-9][0-9][0-9][0-9](00|D01)_|c_)?([A-Z][A-Z]?[0-9]*_)?A[1-2][0-9][0-9][0-9][0-9][0-9][0-9][0-9]\.[0-9][0-9][0-9][0-9]([0-9][0-9])?-[0-9][0-9][0-9][0-9]([^-]|-[A-Za-z])/)
	{
		#5G Celltrace/Uetrace:
		# A20200128.0315-0330_CellTrace_CUCP0_3_1.gpb.gz
		# A20200309.1500-1515-DU1_uetrace_325476C10001.gpb.gz  : this one is the only one that has a dash after the time (-DU1) so that is why we have the regexp at the end "-[A-Za-z]"
		#Gen2: A20150924.120310-120320.xml.gz
		#      A20150924.1115-111510.xml.gz
		#      A20150924.123050-1231.xml.gz
		#A20050714.2330-2345:1.xml.gz
		#BJ4_A20090508.0400-0415_UETR_10000.bin.gz
		#p001600_BJ4_A20090508.0400-0415_GPEH.lnk.gz
		#r000500_CX1_A20130703.1400-1415_GPEH.lnk.gz
		#r002400_N11_A20170119.0030-0045_GPEH.lnk.gz
		#c_CG6_A20111107.1200-1215_GPEH.lnk.gz
		#Pico: A20160809.2215-2230_ENB413.Lrat_1_1.bin.gz
		#r0008D01_U_A20171207.0730-0745_GPEH.lnk.gz
		g=0
		s=16
		split(gensub(/^.*\/([pr][0-9][0-9][0-9][0-9](00|D01)_|c_)?([A-Z][A-Z]?[0-9]*_)?/,"",1,file),a,"")
		if (file ~ /A[1-2][0-9][0-9][0-9][0-9][0-9][0-9][0-9]\.[0-9][0-9][0-9][0-9]([0-9][0-9]|-[0-9][0-9][0-9][0-9][0-9])/)
		{
			#Gen2 with ROP less than 1 minute
			#A20150924.120310-120320.xml.gz
			#A20150924.1115-111510.xml.gz
			#A20150924.123050-1231.xml.gz
			if (file ~ /A[1-2][0-9][0-9][0-9][0-9][0-9][0-9][0-9]\.[0-9][0-9][0-9][0-9][0-9][0-9]-/) s=18
			if (file ~ /A[1-2][0-9][0-9][0-9][0-9][0-9][0-9][0-9]\.[0-9]+-[0-9][0-9][0-9][0-9][0-9][0-9]/) g=1
		}
		res=mymktime(sprintf("%s%s%s%s %s%s %s%s %s%s %s%s %s",a[2],a[3],a[4],a[5],a[6],a[7],a[8],a[9],a[s],a[s+1],a[s+2],a[s+3],(g==1?sprintf("%s%s",a[s+4]+0,a[s+5]+0):"00")))
	}
	else if (file ~ file_extension && file ~ /(^|\/)A[1-2][0-9][0-9][0-9][0-9][0-9][0-9][0-9]\.[0-9][0-9][0-9][0-9][-+][0-9][0-9][0-9][0-9]-/)
	{
		#A20070824.2345+0900-0000+0900_TKT_RootMo,1501_ernRNCost03,1501_ernRNCost03_statsfile.xml
		split(gensub(/^.*\//,"",1,file),a,"")
		res=mymktime(sprintf("%s%s%s%s %s%s %s%s %s%s %s%s 00",a[2],a[3],a[4],a[5],a[6],a[7],a[8],a[9],a[21],a[22],a[23],a[24]))
	}
	else if (file ~ file_extension && file ~ /(^|\/)[1-2][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]-[0-9][0-9][0-9][0-9]_/)
	{
		#201603191130-1145_exception_1.bin.gz
		#201603200415-0430_exception_1.bin.gz
		split(gensub(/^.*\//,"",1,file),a,"")
		res=mymktime(sprintf("%s%s%s%s %s%s %s%s %s%s %s%s 00",a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8],a[14],a[15],a[16],a[17]))
	}
	else if (file ~ file_extension && file ~ /(^|\/)kpi_gp[0-9]+_[1-2][0-9][0-9][0-9][0-9][0-9][0-9][0-9]_[0-9][0-9][0-9][0-9]-[0-9][0-9][0-9][0-9]\./)
	{
		#kpi_gp900_20180304_1715-1730.txt.gz
		split(gensub(/^.*kpi_gp[0-9]+_/,"",1,file),a,"")
		res=mymktime(sprintf("%s%s%s%s %s%s %s%s %s%s %s%s 00",a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8],a[15],a[16],a[17],a[18]))
	}
	#/proj/wcdmaiov/eanzmagn/moshell_logfiles/logs_moshell/pmfiles/a.b.c.d/uehException/p000300_132_detailed_20200515.csv.gz
	else if (file ~ file_extension && file ~ /(^|\/).+_(basic|detailed)_([0-9]){8}\.csv\.gz$/)
	{
		split(gensub(/^.*_/,"",1,file),a,"")
		res=mymktime(sprintf("%s%s%s%s %s%s %s%s 00 00 00",a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8]))
	}
	if (file ~ /\.23(00|45|55|59).*-0000/) res+=24*3600
	#if (mosdebug==1) print file,file_extension,res,mystrftime("%Y%m%d %H:%M:%S",res,1)
	return res
}
function node_in_ipdatabase(node_name,    last,array,i,file,result)
{
	#returns 0 if the node_name is stored in an ipdatabase file, otherwise 1
	result=1
	last=split(ip_database,array,",")
	for (i=1;i<=last;i++)
	{
		if (result==0) break
		file=array[i]
		if (fileOps("test -s "file)!=0) continue
		while ((getline < file)>0)
		{
			if (result==0) continue
			gsub("\r","") ; gsub("\x00","") ; gsub(/#.*$/,"")
			if (NF > 1 && tolower($1) == tolower(node_name)) result=0
		}
		close(file)
	}
	return result
}
function find_node_address(node_name,resultTable,what,   result,array,i,tmp_res,tmp_table,last,ok,line,a,haveNode,file,faultyLine)
{
	#returns the ip address if found in ip_database, else returns the node_name as was input into the function
	#also a table is created with the following field:
	#   * resultTable["node_name"]=node_name as input or as found in 1st field of ipdatabase
	result=node_name
	resultTable["node_name"]=node_name
	last=split(ip_database,array,",")

	#remove faulty lines, i.e. multiple lines with the same node name, eg:
	#rbs1 10.20.30.40
	#rbs1 10.20.30.41
	for (i=1;i<=last;i++)
	{
		file=array[i]
		if (fileOps("test -s "file)==0)
		{
			while ((getline < file)>0)
			{
				gsub("\r","") ; gsub("\x00","")
				if ($1 ~ /^#/) continue
				sub(/[ \t]+#.*$/,"")
				if (!(NF > 1 )) continue
				if (haveNode[tolower($1)]!="" && haveNode[tolower($1)]!=$2) faultyLine[$1,$2]=1  #if there is a multiple entries of the same node but pointing to a different ip
				haveNode[tolower($1)]=$2
			}
			close(file)
		}
	}
	#end remove faulty lines

	for (i=1;i<=last;i++)
	{
		if (find_node_address_from_file(array[i],node_name,tmp_table,faultyLine) == 1)
		{
			result=tmp_table["result"]
			resultTable["node_name"]=tmp_table["node_name"]
			resultTable["node_options"]=tmp_table["node_options"]
			ok=1
			break
		}
	}
	if (what=="listme" && ok!=1 && search_listme==1 && fileOps("test -d /opt/ericsson/amos/moshell")==0 && (!(is_ip_addr(node_name)>0 || node_name ~ /^OFFLINE/)))
	{
		find_listme()
		if (listme!="")
		{
			while (listme |& getline line)
			{
				#SubNetwork=ONRM_RootMo_R,SubNetwork=LTE27,MeContext=LTE27ERBS00115@a.b.c.d@@4@ON@1@4@ERBS_NODE_MODEL@-1@-1
				split(line,a,/@/)
				if (tolower(gensub(/^.*=/,"",1,a[1]))==tolower(node_name) && is_ip_addr(a[2])>0)
				{
					result=a[2]
					break
				}
			}
			close(listme)
		}
	}
	return result
}
function find_node_address_from_file(file,node_name,tmp_table,faultyLine,   found)
{
	found=0
	tmp_table["result"]=node_name
	tmp_table["node_name"]=node_name
	if (fileOps("test -s "file)!=0)
	{
		#On ENM the file /opt/ericsson/amos/moshell/sitefiles/ipdatabase is not there by default => only print warning for other paths
		if (fileOps("test -f "file)!=0 && file!="/opt/ericsson/amos/moshell/sitefiles/ipdatabase") customPrint("WARNING: could not open ipdatabase file "file)
		return found
	}
	while ((getline < file)>0)
	{
		gsub("\r","") ; gsub("\x00","")
		if ($1 ~ /^#/) continue
		sub(/[ \t]+#.*$/,"")
		if (!(NF > 1 )) continue
		if (faultyLine[$1,$2]==1) continue
		if (($1 == node_name)||($1 ~ "&" && gensub("&","","g",$1)==node_name))
		{
			#name to ip check
       			tmp_table["result"]=$2
       			if ($4 ~ "=") tmp_table["node_options"]=$4
       			found=1
			break
			#in case the node name contains & sign, mobatch would remove the & sign so we check without & sign as well
		}
		else if ($2 == node_name)
		{
			#ip to name check
			#we do a reverse lookup in the table to match the ipaddress to the node name
			tmp_table["node_name"]=$1
       			if ($4 ~ "=") tmp_table["node_options"]=$4
			found=1
			break
		}
	}
	close(file)
	if (found == 0)
	{
		#if no exact match do a case insensitive check, also on the ipaddress since ipv6 can contain letters
		while ((getline < file)>0)
		{
        		gsub("\r","") ; gsub("\x00","")
        		gsub(/#.*$/,"")
        		#if (NF > 1 && tolower($1) == tolower(node_name))
			#{
               		#	tmp_table["result"]=$2
               		#	if ($4 ~ "=") tmp_table["node_options"]=$4
               		#	found=1
			#	break
			#}
			if (!(NF > 1 )) continue
			if (faultyLine[$1,$2]==1) continue
			if ((tolower($1) == tolower(node_name))||($1 ~ "&" && gensub("&","","g",tolower($1))==tolower(node_name)))
			{
				#name to ip check
               			tmp_table["result"]=$2
               			if ($4 ~ "=") tmp_table["node_options"]=$4
               			found=1
				break
				#in case the node name contains & sign, mobatch would remove the & sign so we check without & sign as well
			}
			else if (tolower($2) == tolower(node_name))
			{
				#ip to name check
				#we do a reverse lookup in the table to match the ipaddress to the node name
				tmp_table["node_name"]=$1
               			if ($4 ~ "=") tmp_table["node_options"]=$4
				found=1
				break
			}
		}
		close(file)
	}
	return found
}
function find_pw_from_file(file)
{
	if (fileOps("test -s "file)!=0) return
	while ((getline < file)>0)
	{
		gsub("\r","") ; gsub("\x00","")
		#ignore comments. we only ignore lines where the # sign is at the beginning of the word since it could be found inside the word , e.g. part of the password
		if ($1 ~ /^#/ || $2 ~ /^#/ || $3 ~ /^#/) continue
		if ((NF > 2) && (node_address == $2 || dns_node_address == $2))
		{
			node_password=b64Dec($3)
			break
		}
	}
	close(file)
}
function make_sshzfile(thefile,thepw)
{
	if (thefile=="") thefile=tempsshzfile
	if (thepw=="") thepw=node_password
	fileOps("rm "thefile)
	if (os !~ /^sun/) print b64Enc(thepw) > thefile
	#if (os=="linux") print b64Enc(thepw) > thefile
	else print thepw > thefile
	close(thefile)
	chmod(00700,thefile)
}
function use_smart_pw()
{
	#only use smart_password with cpp OSE nodes and not with security level 3
	if (smart_password>0 && comcli==0 && lincli<=1 && sl3==0 && cpplinux!=1 && sl3Status<3 && cppAA!=1) return 1
	else return 0
}
function print_tls_menu(    n,fileList,i,answer,z,k,credList,ssh_status,tls_status,ageList,nmval)
{
	k=0
	z=0
	ssh_status=check_ip_contact(node_address,comcli_port,"force","","startup")
	tls_status=check_ip_contact(node_address,s_comcli_port,"force","","startup")
	if (ssh_status!=0 && tls_status!=0)
	{
		customPrint("ERROR: comcli port is unreachable on both SSH and TLS.")
		return 99
	}
	if (tls_status==0 && fileOps("test -d "nm_folder)==0)
	{
		n=fileOps("ls "nm_folder,fileList)
		for (i=1;i<=n;i++)
		{
			if (fileList[i]!~/\.xml$/) continue
			nmval=check_sa_validity("nm",nm_folder"/"fileList[i])
			if (nmval ~ /ERROR:/) continue
			credList[++k]=fileList[i]
			ageList[k]=" (valid until: "gensub(/^.*=/,"",1,nmval)")"
			z=k
		}
	}
	if (tls_status==0 && fileOps("test -d "sa_folder)==0)
	{
		n=fileOps("ls "sa_folder,fileList)
		for (i=1;i<=n;i++)
		{
			if (fileList[i]!~/\.p12$/) continue
			credList[++k]=fileList[i]
			ageList[k]=" (age: "convertSeconds(systime()-fileOps("stat mtime "sa_folder"/"fileList[i]),5)")"
		}
	}
	if (ssh_status==0) k++
	if (k==0)
	{
		customPrint("No valid credential found in nm_folder/sa_folder!")
		return 99
	}
	else if (k==1)
	{
		if (tls_status==0) customPrint("Connecting with "credList[1])
		answer=1
	}
	else
	{
		answer=0
		while (answer<=0 || answer>k)
		{
			customPrint("Please select connection method")
			for (i=1;i<=k;i++)
			{
				if (credList[i]!="") customPrint(sprintf("%2d.%s%s",i,credList[i],ageList[i]))
			}
			if (ssh_status==0) customPrint(sprintf("%2d.%s",k,"SSH username/password"))
			answer=Read_Answer("","","","","","","Your Choice: ")+0
			if (answer<=0 || answer>k)
			{
				customPrint("\nInvalid Choice!")
				return 99
			}
		}
	}
	if (answer<=z)
	{
		use_tls=3
		nm_credential=nm_folder"/"credList[answer]
	}
	else if (ssh_status==0 && answer==k) use_tls=0
	else
	{
		use_tls=1
		sa_credential=sa_folder"/"credList[answer]
		sa_password=""
	}
}
function try_many_logins(what,thenodetype,theusernames,thepasswords,theuservar,thepasswordvar,    n,i,a,b,p,res)
{
	res=1
	if (!(thenodetype>0 && theusernames!="" && thepasswords!="")) return 9
	n=split(theusernames,a,",")
	p=split(thepasswords,b,",")
	for (i=1;i<=n;i++)
	{
		tmpres=try_the_login(what,thenodetype,a[i], b64Dec(b[i]),theuservar,thepasswordvar,"noreset")
		if (tmpres==0)
		{
			res=0
			break
		}
		else if (tmpres==1) b[i]=""
		if (login_retry_interval>0) sleep(login_retry_interval)
	}
	thepasswords=""
	for (i=1;i<=p;i++) thepasswords=thepasswords b[i]","
	sub(/,$/,"",thepasswords)
	declare_user_variable(thepasswordvar"="thepasswords,2)
	return res
}

function try_the_login(what,thenodetype,theusername,thepassword,theuservar,thepasswordvar,noreset,   old_username,old_preliminary_node_password,tmpres)
{
	if (!(thenodetype>0 && theusername!="" && thepassword!="")) return 9
	customPrint("Trying "theusername"'s password from uservariable "thepasswordvar" ...","","","noLF")
	old_username=username
	old_preliminary_node_password=preliminary_node_password
	username=theusername
	node_password=thepassword
	tmpres=validate_password("Not OK",what) #0=passwordOk , 1=noIpContact , 2=passwordNotOk
	if (tmpres ~ /^(0|1)$/)
	{
		if (tmpres == 0)
		{
			preliminary_node_password=""
			validatepw_printOK()
		}
		return 0 #ie: password ok (0) or no Ip contact (1)
	}
	else
	{
		username=old_username
		preliminary_node_password=old_preliminary_node_password
		if (noreset=="") declare_user_variable(thepasswordvar"=",2)
		return 1
	}
}
function check_node_password(what,   result,array,file_used,i,last,tmpres,nodetype,nodename_done,lastPart,old_username,old_preliminary_node_password,n,a,b,nodenamepwlist)
{
	if (node ~ /^OFFLINE/)
	{
		if (OffOk==1 && node ~ /^OFFLINE_/) return
		customPrint("\nCommand unavailable in offline mode.")
		return
	}
	if (yangcli>0 && nrOfNodes>1) 
	{
		#customPrint("\nCommand unavailable in multi mode.")
		return
	}	
	if (comcli>0 && tls_menu>0 && use_tls==-1)
	{
		if (print_tls_menu()==99) return
	}
	if ((node_login==0)||(comcli>0 && use_tls>0 && what!="sftp")) { node_password="nopassword" ; return }
	if (what=="sftp") node_password=sftp_node_password
	if (node_password != "") return

	cppAA=check_useraapolicy("silent")

	#0) Try from the uservariables com_usernames, com_username, cpplinux_usernames, cpplinux_username, cpp_usernames
	if (try_many_logins(what,comcli,com_usernames,com_passwords,"com_usernames","com_passwords")==0) return

	if (try_the_login(what,comcli,com_username,com_password,"com_username","com_password")==0) return

	if (try_many_logins(what,cpplinux,cpplinux_usernames,cpplinux_passwords,"cpplinux_usernames","cpplinux_passwords")==0) return

	if (try_the_login(what,cpplinux,cpplinux_username,cpplinux_password,"cpplinux_username","cpplinux_password")==0) return

	if (try_many_logins(what,cppAA,cpp_usernames,cpp_passwords,"cpp_usernames","cpp_passwords")==0) return

	#1) Check if password defined as a scripting variable $password (e.g. -v password=xxx)
	#The password is checked first from $password because if we check first in ipdatabase and it is wrong password then the $password (preliminary_node_password) will get cleared
	if (preliminary_node_password != "")
	{
		if (comcli>0 || cpplinux==1 || cppAA==1)
		{
			if (username=="moshelluser") username = get_password("username")
		}
		customPrint(sprintf("Trying %spassword from variable $password ...",(comcli>0||cpplinux>0||cppAA>0?username"'s ":"")),"","",(use_smart_pw()==1?"noLF":""))
		node_password=preliminary_node_password
		tmpres=validate_password((use_smart_pw()==1?"Not OK":""),what) #0=passwordOk , 1=noIpContact , 2=passwordNotOk
		if (tmpres ~ /^(0|1)$/)
		{
			if (tmpres == 0) preliminary_node_password=""
			if (use_smart_pw()==1 && tmpres==0) validatepw_printOK() #since we had printed the message above with "noLF", we must put the carriage return now
			return #ie: password ok (0) or no Ip contact (1)
		}
	}
	if (comcli==0 && sl3==0 && cpplinux!=1 && cppAA!=1)
	{
		#2) Search password in ipdatabase
		last=split(ip_database,array,",")
		for (i=1;i<=last;i++)
		{
			file_used=find_pw_from_file(array[i])
			if (node_password != "")
			{
				customPrint(sprintf("Trying password from ipdatabase file: %s...",array[i]),"","",(use_smart_pw()==1?"noLF":""))
				tmpres=validate_password((use_smart_pw()==1?"Not OK":"")) #0=passwordOk , 1=noIpContact , 2=passwordNotOk
				if (tmpres ~ /^(0|1)$/)
				{
					if (use_smart_pw()==1 && tmpres==0) validatepw_printOK() #since we had printed the message above with "noLF", we must put the carriage return now
					return #ie: password ok (0) or no Ip contact (1)
				}
			}
		}
	}
	#3) Try some standard passwords, only supported for CPP nodes and not when sl3=1
	if (use_smart_pw()==1)
	{
		last=split(standard_passwords,array,",")
		for (i=1;i<=last;i++)
		{
			if (array[i]~/\$nodename/)
			{
				#save this for the end
				nodenamepwlist=nodenamepwlist","array[i]
				sub(/^,/,"",nodenamepwlist)
				continue
			}
			if (array[i]~/\$ip$/)
			{
				#take all the last digits of the ip address, eg: a.b.c.147 -> 147
				sub(/\$ip$/,gensub(/^.*\./,"",1,node_address),array[i])
			}
			if (array[i]~/\$ip2$/)
			{
				#take only the last 2 digits of the ipaddress, if it has 3 digits at the end, eg: a.b.c.147 -> 47
				lastPart=gensub(/^.*\./,"",1,node_address)
				if (lastPart ~ /^[0-9][0-9][0-9]$/) sub(/\$ip2$/,gensub(/^.*\.[0-9]/,"",1,node_address),array[i])
				else continue
			}
			if (array[i]~/\$nodetype/)
			{
				if (mom_version == "")
				{
					$0="" ; getmom()
					$0="" ; parsemom()
				}
				if (mom_version == "") continue  #in case fetching the MOM failed
				if (mom_version ~ "MGW") sub(/\$nodetype/,"mgw",array[i])
				else if (mom_version ~ "RBS") sub(/\$nodetype/,"rbs",array[i])
				else if (mom_version ~ "RNC")
				{
					sub(/\$nodetype/,"rnc",array[i])
					array[++last]=gensub(/rnc/,"tch",1,array[i])
				}
				else if (mom_version ~ "CPP")
				{
					sub(/\$nodetype/,"tgs",array[i])
					array[++last]=gensub(/tgs/,"tch",1,array[i])
				}
				else if (mom_version ~ "RANAG")
				{
					sub(/\$nodetype/,"rxi",array[i])
				}
			}
			if (array[i] == "sls_password")
			{
				if (sls_password == "") continue
				if (CorbaSecurity=="") check_corba_security("silent")
				if (CorbaSecurity=="ON" || corba_class>2) customPrint("Trying password from uservariable sls_password: ... ","","","noLF")
				else continue
				node_password=sls_password
			}
			else
			{
				customPrint("Trying standard passwords: "(smart_password==1?array[i]:"*********")" ... ","","","noLF")
				node_password=b64Dec(array[i])
			}
			tmpres=validate_password("Not OK") #0=passwordOk , 1=noIpContact , 2=passwordNotOk
			if (tmpres == 0) validatepw_printOK()
			if (mosdebug==1) print "Tried pw: username="username",node_password="node_password
			if (tmpres ~ /^(0|1)$/) return
		}
		#if nothing worked and the nodename was not tried we try the nodename
		if (nodenamepwlist ~ /\$nodename/)
		{
			#Check that the jarfiles exist first
			#if the jarfiles are not there then we don't try to start the MO service otherwise it keeps going through a loop
			jarVersion[jacorb]=check_jar_version(jacorb)
			jarVersion[jacsec]=check_jar_version(jacsec)
			jarVersion[jacoms]=check_jar_version(jacoms)
			if (subCheckJarFiles()==1 && Start_moMode()==0)
			{
				last=split(nodenamepwlist,array,",")
				for (i=1;i<=last;i++)
				{
					node_password=gensub(/\$nodename/,tolower(node),1,array[i])
					customPrint("Trying standard passwords: "(smart_password==1?node_password:"*********")" ... ","","","noLF")
					tmpres=validate_password("Not OK") #0=passwordOk , 1=noIpContact , 2=passwordNotOk
					if (tmpres == 0) validatepw_printOK()
					if (tmpres ~ /^(0|1)$/) return
				}
			}
		}
		#after trying all the passwords we set smart_password to 0 in order to not try them again
		smart_password=0
	}

	#4) Find password from ENM AMOS request broker
	if (os=="linux" && in_amos_mode()==1 && amos_enm_accountlookup>0)
	{
		old_username=username
		amos_account_lookup()
		if (node_password != "")
		{
			temporary_enm_username=username
			customPrint(sprintf("Trying "username"'s password from amos lookupAccount ... "),"","","noLF")
			tmpres=validate_password("Not OK") #0=passwordOk , 1=noIpContact , 2=passwordNotOk
			if (tmpres ~ /^(0|1)$/)
			{
				if (tmpres==0) validatepw_printOK()
				return
			}
			else
			{
				amos_account_delete(temporary_enm_username)
				usleep(1000000)
				amos_account_lookup()
				if (node_password != "")
				{
					temporary_enm_username=username
					customPrint(sprintf("Trying "username"'s password from amos lookupAccount ... "),"","","noLF")
					tmpres=validate_password("Not OK") #0=passwordOk , 1=noIpContact , 2=passwordNotOk
					if (tmpres ~ /^(0|1)$/)
					{
						if (tmpres==0) validatepw_printOK()
						return
					}
					else
					{
						amos_account_delete(temporary_enm_username)
						username=old_username
					}
				}
			}
		}
	}

	#5) Input password from prompt
	if (comcli>0 || cpplinux==1 || rcli>0 || cppAA==1)
	{
		if (username=="moshelluser") username = get_password("username")
	}
	node_password = get_password()
	if (node_password != "")
	{
		tmpres=validate_password("",what)
		if (tmpres==0) validatepw_printOK("silent")
	}
}
function check_yang_password(i,n,user,pw)
{
	if (n>1 && (user=="moshelluser" || pw=="")) 
	{
		customPrint("Requesting login for node "i"/"n)
		if (i==1) customPrint("Note: save the login in uservariables yang_username/yang_password in ipdatabase or moshellrc for automated input.")
	}
	if (user=="moshelluser") user = get_password("username")
	if (user=="moshelluser") return ""
	if (pw=="") pw=get_password()
	if (pw=="") return ""
	return user SUBSEP pw
}
function check_useraapolicy(silent,   remotefile,ok,res,line,aa)
{
	res=0
	if (node ~ /^OFFLINE/) return 0
	if (multi) return 0
	if (!(comcli==0 && sl3==0 && cpplinux!=1)) return 0
	if (smart_cpplaad>0 && mobrowserStarted==1 && Start_moMode()==0)
	{
		if (getMoAttribute("ManagedElement=1,SystemFunctions=1,Security=1","operationalSecurityLevel")+0 < 3)
		{
			if (getMoAttribute("ManagedElement=1,SystemFunctions=1,Security=1","userAuthenticationAndAuthorization")+0 > 0) res=1
			declare_user_variable("cpplaad="res,2)
			if (res != (cppAA+0)) reset_password()
		}
		return res
	}
	else return cpplaad

	#Below is not used as the file useraapolicy is not present anymore
	#/cello/useraapolicy
	#UserAAPolicy=BASIC
	#UserAAPolicy=ENHANCED_UNCONFIRMED
	#UserAAPolicy=ENHANCED
	remotefile=sprintf("%s/useraapolicy%s",(tempdir==""?"/tmp":tempdir),PROCINFO["pid"])
	if (httpget(node_address,"/cello/useraapolicy",remotefile,"",silent,"",fast_timeout)==0 && fileOps("test -f "remotefile)==0)
	{
		while ((getline line < remotefile)>0)
		{
			if (line ~ /UserAAPolicy=/)
			{
				aa=gensub(/^.*=/,"",1,line)
			}
		}
		close(remotefile)
	}
	if (remotefile ~ /^\/tmp\/useraapolicy/) fileOps("rm "remotefile)
	if (aa~/ENHANCED/) res=1
	if (res != (cppAA+0)) reset_password()
	return res
}
function amos_account_lookup(   ok,i,res)
{
	res="Failed."
	customPrint("Looking up temporary_amos account... ","","","noLF")
	close(AMOSRequestBroker)
	print "lookupAccountDetails "node_address"\nstop" |& AMOSRequestBroker
	while (AMOSRequestBroker |& getline)
	{
		#AMOSRequestBroker Enter Command :
		#AMOSRequestResponse : true
		# true netsim true netsim
		#        debug : running request : lookupAccountDetails a.b.c.d
		#        debug : request : lookupAccountDetails a.b.c.d took 401 m/s to process
		if (NF>0 && amos_debug>=1)
		{
			if (/AMOSRequestBroker Enter Command :/ && (++i)==1) print "AMOSRequestBroker Enter Command : lookupAccountDetails "node_address
			else print $0
		}
		if ($1=="AMOSRequestResponse" && $2==":" && $3=="true") ok=1
		else if (ok==1 && $1 ~/^(true|false)$/ && $3 ~ /^(true|false)$/)
		{
			if ($4!="null")
			{
				node_password=$4
				if ($2!="null") username=$2
				res="OK."
			}
		}
	}
	close(AMOSRequestBroker)
	customPrint(res)
}
function amos_exportaccount_lookup(   ok,i)
{
	close(AMOSRequestBroker)
	print "lookupAccountDetails "node_address"\nstop" |& AMOSRequestBroker
	while (AMOSRequestBroker |& getline)
	{
		#AMOSRequestBroker Enter Command :
		#AMOSRequestResponse : true
		# true netsim true netsim
		#        debug : running request : lookupAccountDetails a.b.c.d
		#        debug : request : lookupAccountDetails a.b.c.d took 401 m/s to process
		if (NF>0 && amos_debug>=1)
		{
			if (/AMOSRequestBroker Enter Command :/ && (++i)==1) print "AMOSRequestBroker Enter Command : lookupAccountDetails "node_address
			else print $0
		}
		if ($1=="AMOSRequestResponse" && $2==":" && $3=="true") ok=1
		else if (ok==1 && $1 ~/^(true|false)$/ && $3 ~ /^(true|false)$/)
		{
			if ($4!="null")
			{
				export_password=$4
				if ($2!="null") export_username=$2
			}
		}
	}
	close(AMOSRequestBroker)
}
function amos_account_delete(theaccount)
{
	if (in_amos_mode()!=1) return
	if (theaccount=="") return
	if (os!="linux") return #only applicable for ENM
	close(AMOSRequestBroker)
	print "deleteComAccount "theaccount"\nstop" |& AMOSRequestBroker
	while (AMOSRequestBroker |& getline)
	{
		if (NF>0 && amos_debug>=1)
		{
			if (/AMOSRequestBroker Enter Command :/ && (++i)==1) "AMOSRequestBroker Enter Command : deleteComAccount "theaccount
			else print $0
		}
	}
	close(AMOSRequestBroker)
}
function reset_password(what)
{
	node_password=""
	preliminary_node_password=""
	sftp_node_password=""
	if (comcli>0 || cpplinux==1 || cppAA==1) username="moshelluser"
	if (what!="novar") unassignCustomVar("$password")
}
function validate_password(message,what,  result,telnet_session,sftp_port,pwfile,ftpuser,ftpserver,sftp_res,sftp_session,kexalgopt,macsopt)
{
	#print nr_login_attempts,max_login_attempts
	nr_login_attempts++
	$0=""
	result=0
	make_sshzfile()
	if (what=="sftp")
	{
		if (yangcli>0) sftp_port=yangftp_port
		else sftp_port=ftp_port
		pwfile=tempsshzfile
		ftpuser=username
		ftpserver=node_address
		if (sftp_kexalg!="") kexalgopt="-o KexAlgorithms="sftp_kexalg" "
		if (sftp_macs!="")   macsopt="-o MACs="sftp_macs" "
		sftp_session=sprintf("%s -S %s -o Port=%s -z '%s' -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null -o HostKeyAlgorithms=\"ssh-dss,ssh-rsa\" -o NumberOfPasswordPrompts=1 -o ConnectTimeout=%s -o ServerAliveInterval=%s -o ConnectionAttempts=%s -o ServerAliveCountMax=0 -o TCPKeepAlive=no  -o PreferredAuthentications=%s %s%s-o User=%s %s 2>&1",sftp,ssh,sftp_port,pwfile,ip_connection_timeout,ip_inactivity_timeout,connection_attempts,auth_method,kexalgopt,macsopt,ftpuser,put_brackets(ftpserver,1))
		sftp_res=sftp_login(sftp_session)
		if (mosdebug==1 || mosdebug==999) print "DEBUG: "sftp_session" --> "sftp_res
		if (sftp_res>0)
		{
			if (sftp_res==1)
			{
				if (message!="") customPrint(message)
				else customPrint("SFTP login failed.","","force")
				result=2
			}
			else
			{
				if (message!="") customPrint("")
				customPrint(sprintf("Unable to connect to %s:%s.",ftpserver,sftp_port),"","force")
				result=1
			}
			reset_password()
		}
		else
		{
			print "exit" |& sftp_session
			while ((sftp_session |& getline)>0) {if(mosdebug==1) print "Debug: "$0}
			result=0
			sftp_node_password=node_password
		}
		close(sftp_session)
	}
	else
	{
		telnet_session=enter_telnet_login(node_address,node_password,"","","","","validate_pw")
		if (telnet_session ~ /Unable to connect/)
		{
			if (message!="") customPrint("") #because we had not put a carriage return in the "Trying password" line
			customPrint(telnet_session)
			result=1
		}
		else if (telnet_session ~ /Wrong Password/)
		{
			if (message!="") customPrint(message)
			else customPrint(telnet_session)
			result=2
		}
		if (result==0)
		{
			is_oam_user=0
			have_sqlc=0
			no_access_to_os=0
			if (lincli==0 && comcli==0) print "mkdir "nodetempdir (cpplinux==1?"\nwho\nwhoami\nclihelp sqlc":"") "\nexit" |& telnet_session  #On OSE node we create nodetempdir in case it was not already there.
			else if (lincli==3) print "exit;\r\n\r\n\r\n\r\nexit\r" |& telnet_session   #AXE node
			else if (epg_ssr==1) print "exit\nexit" |& telnet_session
			else if (rcli==2) print "quit" |& telnet_session
			else print "exit" |& telnet_session
			while ((telnet_session |& getline)>0)
			{
				gsub("\r","")
				if(mosdebug==1) print "Debug: "$0
				#|                               o|  OAM USER|
				#|                        oss-user|  OAM USER|
				#if (cpplinux==1 && $3=="OAM" && $2~sprintf("^%s.$",username)) is_oam_user=1
				#bash: /usr/bin/who: Permission denied
				if (cpplinux==1 && /who: Permission denied/) is_oam_user=1
				if (cpplinux==1 && /sql commands for node access/) have_sqlc=1
				if (cpplinux==1 && /illegal command 'who(ami)?', status: Not enough credentials/) no_access_to_os=have_sqlc=1
				if (cpplinux==1 && /^Not enough credentials$/) have_sqlc=0
			}
			if (cpplinux==1) makeColiMap()
		}
		else
		{
			reset_password()
		}
		close(telnet_session)
	}
	if (max_login_attempts>0 && nr_login_attempts>=max_login_attempts && node_password=="") exit_with_error()
	assignCustomVar("$password",node_password,"","system")
	make_sshzfile()
	#wait 1 sec after ssh logout on CPP node to make sure the ssh session is fully closed , otherwise, a subsequent ssh session may fail if initiated straight after and the total number of connected ssh sessions is close to the maximum allowed in SshTelnetSessions
	wait_cpp_ssh()
	if (comcli>0 && tls_menu>0 && node_password=="") use_tls=-1
	if (LoginFailedError!="")
	{
		customPrint(LoginFailedError)
		LoginFailedError=""
	}
	return result
	#if (reading_script==1) printf(" - enter password in command file, or:\n")
	# - type an OSE shell command to get prompted for the password, or:\n
	# - define password in ipdatabase (%s).\n",ip_database)
}

function make_inputvars(inputoptions,commandfile,currentDir,loggingOverride,logfileOverride,muteLogOverride,comLogType,xToday,   loggingOpt,logfileOpt,muteLogOpt)
{
	#commandfile is only used by "lh" and "cmd"
	#currentDir is only used by "cmd"
	#inputoptions is used by "lh", "cmd", "al", "lg", "cab"
	if (loggingOverride != "") loggingOpt=loggingOverride ; else loggingOpt=logging
	if (logfileOverride != "") logfileOpt=logfileOverride ; else logfileOpt=logfile
	if (muteLogOverride != "") muteLogOpt=muteLogOverride ; else muteLogOpt=muteLog
	return sprintf("%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s<@%>%s",\
node_address,handle_single_quote(node_password),inputoptions,commandfile,currentDir,loggingOpt,logfileOpt,show_colors,muteLogOpt,muteFactor,\
secure_shell,secure_ftp,telnet_port,http_port,ftp_port,secure_port,node_login,ip_inactivity_timeout,ip_connection_timeout,ftp_timeout,\
username,filefunc,moshelldir,os,iorfile,security_method,credential,sa_credential,sa_password,vobsinstallation,java,mosdebug,\
jarxmldir,commonjardir,corba_class,tempdir,print_lmid,logdir,readanswer,ip_database,node,tempknownhostfile,gawk,axenode,\
gawk_pid,sls_urls,sls_username,sls_password,nm_credential,nm_folder,nodetempdir,unr,CorbaSecurity,http_timeout,use_netcatlib,\
polyversion,alarm_format,ipv6,sls_timeout,comcli,lincli,tempsshzfile,cliss,comcli_columns,use_scandir,linux_shell,comcli_port,\
fast_timeout,sl3,login_wait,measuretimeStart,ssh_retry,command_restriction,comLogType,mom_version,cpplinux,java_options,xbLogFilter,\
corba_port,s_corba_port,corba_orbinit,use_tls,s_comcli_port,s_secure_port,openssl,clientpem,capem,sl3Status,use_lhv,http_retry,auth_method,\
anon_ue,use_lin64,linarch,ssh_subsystem,ssh_kexalg,is_netsim,show_updated_alarms,tls_debug,xToday,use_default_jacorb,jacorb,jacoms,jacsec,sunarch,\
epg_ssr,is_oam_user,use_jacorb_ciphers,jacorb_ciphers,CelloVersion,duString,ssh_server_type,s_ftp_port,al_retry,rcli,show_correlation_info,ssh_macs,sftp_macs,\
show_alarm_userlabel,show_shortduration_alarms,keypem,keypass,have_sqlc,lgg_showno,lgg_compress,lgg_intervals,show_notified,no_access_to_os,ssh_debug,\
show_related_alarms,connection_attempts,yangcli,yangftp_port,s_yangftp_port)
}
function handle_single_quote(thestring)
{
	if (thestring ~ "'") thestring=b64Enc(thestring)
	return thestring
}
function parse_inputvars(inputvariables,  array,last,i,a,b)
{
	last=split(inputvariables,array,"<@%>")
	node_address          = array[1]
	node_password         = b64Dec(array[2])
	inputoptions          = array[3]
	commandfile           = array[4]   #we also use this variable as xml_log in  parse_xmlsys_log
	currentDir            = array[5]   #we also use this variable as start_date in  parse_xmlsys_log
	logging               = array[6]+0
	logfile               = array[7]
	show_colors           = array[8]+0
	muteLog               = array[9]
	muteFactor            = array[10]+0
	secure_shell          = array[11]+0
	secure_ftp            = array[12]+0
	telnet_port           = array[13]+0
	http_port             = array[14]+0
	ftp_port              = array[15]+0
	secure_port           = array[16]+0
	node_login            = array[17]+0
	ip_inactivity_timeout = array[18]+0
	ip_connection_timeout = array[19]+0
	ftp_timeout           = array[20]+0
	username              = array[21]
	filefunc              = array[22]
	moshelldir            = array[23]
	os                    = array[24]
	iorfile               = array[25]
	security_method       = array[26]+0
	credential            = array[27]
	sa_credential         = array[28]
	sa_password           = array[29]
	vobsinstallation      = array[30]+0
	java                  = array[31]
	mosdebug              = array[32]+0
	jarxmldir             = array[33]
	commonjardir          = array[34]
	corba_class           = array[35]+0
	tempdir               = array[36]
	print_lmid            = array[37]+0
	logdir                = array[38]
	readanswer            = array[39]
	ip_database           = array[40]
	node                  = array[41]
	tempknownhostfile     = array[42]
	gawk                  = array[43]
	axenode               = array[44]
	gawk_pid              = array[45]+0
	sls_urls              = array[46]
	sls_username          = array[47]
	sls_password          = array[48]
	nm_credential         = array[49]
	nm_folder             = array[50]
	nodetempdir           = array[51]
	unr                   = array[52]+0
	CorbaSecurity         = array[53]
	http_timeout          = array[54]+0
	use_netcatlib         = array[55]+0
	polyversion           = array[56]+0
	alarm_format          = array[57]+0
	ipv6                  = array[58]+0
	sls_timeout           = array[59]+0
	comcli                = array[60]+0
	lincli                = array[61]+0
	tempsshzfile          = array[62]
	cliss                 = array[63]
	comcli_columns        = array[64]+0
	use_scandir           = array[65]+0
	linux_shell           = array[66]+0
	comcli_port           = array[67]+0
	fast_timeout          = array[68]+0
	sl3                   = array[69]+0
	login_wait            = array[70]+0
	measuretimeStart      = array[71]
	ssh_retry             = array[72]+0
	command_restriction   = array[73]+0
	comLogType            = array[74]
	mom_version           = array[75]
	cpplinux              = array[76]+0
	java_options          = array[77]
	xbLogFilter           = array[78]
	corba_port            = array[79]+0
	s_corba_port          = array[80]+0
	corba_orbinit         = array[81]+0
	use_tls               = array[82]+0
	s_comcli_port         = array[83]+0
	s_secure_port         = array[84]+0
	openssl               = array[85]
	clientpem             = array[86]
	capem                 = array[87]
	sl3Status             = array[88]
	use_lhv               = array[89]+0
	http_retry            = array[90]+0
	auth_method           = array[91]
	anon_ue               = array[92]+0
	use_lin64             = array[93]+0
	linarch               = array[94]
	ssh_subsystem         = array[95]
	ssh_kexalg            = array[96]
	is_netsim             = array[97]+0
	show_updated_alarms   = array[98]+0
	tls_debug             = array[99]+0
	xToday                = array[100]
	use_default_jacorb    = array[101]+0
	jacorb                = array[102]
	jacoms                = array[103]
	jacsec                = array[104]
	sunarch               = array[105]
	epg_ssr               = array[106]
	is_oam_user           = array[107]+0
	use_jacorb_ciphers    = array[108]+0
	jacorb_ciphers        = array[109]
	CelloVersion          = array[110]
	duString              = array[111]
	ssh_server_type       = array[112]
	s_ftp_port            = array[113]
	al_retry              = array[114]+0
	rcli                  = array[115]+0
	show_correlation_info = array[116]+0
	ssh_macs              = array[117]
	sftp_macs             = array[118]
	show_alarm_userlabel  = array[119]+0
	show_shortduration_alarms = array[120]+0
	keypem                = array[121]
	keypass               = array[122]
	have_sqlc             = array[123]+0
	lgg_showno            = array[124]+0
	lgg_compress          = array[125]+0
	lgg_intervals         = array[126]
	show_notified         = array[127]+0
	no_access_to_os       = array[128]+0
	ssh_debug             = array[129]+0
	show_related_alarms   = array[130]+0
	connection_attempts   = array[131]+0
	yangcli               = array[132]+0
	yangftp_port          = array[133]+0
	s_yangftp_port        = array[134]+0

	loadFilefuncs()
	parse_common_variables()
	Define_months()
	split(duString,a,":")
	for (i in a) { split(a[i],b,"/") ; duMo[b[1]"/"]=b[2] }

#	if (mosdebug==1) printf("Total of "last" variables:\n\
#node_address          = "node_address          "$\n\
#node_password         = "node_password         "$\n\
#inputoptions          = "inputoptions          "$\n\
#commandfile           = "commandfile           "$\n\
#currentDir            = "currentDir            "$\n\
#logging               = "logging               "$\n\
#logfile               = "logfile               "$\n\
#show_colors           = "show_colors           "$\n\
#muteLog               = "muteLog               "$\n\
#muteFactor            = "muteFactor            "$\n\
#secure_shell          = "secure_shell          "$\n\
#secure_ftp            = "secure_ftp            "$\n\
#telnet_port           = "telnet_port           "$\n\
#http_port             = "http_port             "$\n\
#ftp_port              = "ftp_port              "$\n\
#secure_port           = "secure_port           "$\n\
#comcli_port           = "comcli_port           "$\n\
#node_login            = "node_login            "$\n\
#ip_inactivity_timeout = "ip_inactivity_timeout "$\n\
#ip_connection_timeout = "ip_connection_timeout "$\n\
#ftp_timeout           = "ftp_timeout           "$\n\
#http_timeout          = "http_timeout          "$\n\
#fast_timeout          = "fast_timeout          "$\n\
#username              = "username              "$\n\
#filefunc              = "filefunc              "$\n\
#moshelldir            = "moshelldir            "$\n\
#os                    = "os                    "$\n\
#iorfile               = "iorfile               "$\n\
#security_method       = "security_method       "$\n\
#credential            = "credential            "$\n\
#sa_credential         = "sa_credential         "$\n\
#sa_password           = "sa_password           "$\n\
#vobsinstallation      = "vobsinstallation      "$\n\
#java                  = "java                  "$\n\
#mosdebug              = "mosdebug              "$\n\
#jarxmldir             = "jarxmldir             "$\n\
#commonjardir          = "commonjardir          "$\n\
#corba_class           = "corba_class           "$\n\
#tempdir               = "tempdir               "$\n\
#print_lmid            = "print_lmid            "$\n\
#logdir                = "logdir                "$\n\
#readanswer            = "readanswer            "$\n\
#ip_database           = "ip_database           "$\n\
#node                  = "node                  "$\n\
#tempknownhostfile     = "tempknownhostfile     "$\n\
#tempksshzfile         = "tempsshzfile          "$\n\
#gawk                  = "gawk                  "$\n\
#axenode               = "axenode               "$\n\
#gawk_pid              = "gawk_pid              "$\n\
#sls_urls              = "sls_urls              "$\n\
#sls_username          = "sls_username          "$\n\
#sls_password          = "sls_password          "$\n\
#nm_credential         = "nm_credential         "$\n\
#nm_folder             = "nm_folder             "$\n\
#use_netcatlib         = "use_netcatlib         "$\n\
#use_scandir           = "use_scandir           "$\n\
#polyversion           = "polyversion           "$\n\
#alarm_format          = "alarm_format          "$\n\
#ipv6                  = "ipv6                  "$\n\
#comcli                = "comcli                "$\n\
#linux_shell           = "linux_shell           "$\n\
#lincli                = "lincli                "$\n\
#cliss                 = "cliss                 "$\n\
#comcli_columns        = "comcli_columns        "$\n\
#sls_timeout           = "sls_timeout           "$\n\
#sl3                   = "sl3                   "$\n\
#login_wait            = "login_wait            "$\n\
#command_restriction   = "command_restriction   "$\n\
#comLogType            = "comLogType            "$\n\
#mom_version           = "mom_version           "$\n\
#cpplinux              = "cpplinux              "$\n\
#use_tls               = "use_tls               "$\n\
#s_comcli_port         = "s_comcli_port         "$\n\
#s_secure_port         = "s_secure_port         "$\n\
#openssl               = "openssl               "$\n\
#clientpem             = "clientpem             "$\n\
#capem                 = "capem                 "$\n\
#nodetempdir           = "nodetempdir           "$\n")

	#ip_address=array[1]
	#node_password=array[2]
	#commandfile=array[3]    # used by telnode_function. if commandfile is not a file then it is treated as a command
	#show_lnh=array[4]       # used by telnode_function
	#append=array[5]         # used by telnode_function
	#nr_of_cmds=array[6]     # used by telnode_function
	#currentDir=array[7]     # used by telnode_function
	#logging=array[8]
	#logfile=array[9]
	#show_colors=array[10]   # used by telnode_function
	#fast_lh=array[11]       # used by telnode_function
	#muteLog=array[12]
	#muteFactor=array[13]
        #
	#connect=array[14]
	#netcat=array[15]
	#secure_shell=array[16]
	#secure_ftp=array[17]
	#telnet_port=array[18]
	#node_login=array[19]
	#ssh=array[20]
	#sftp=array[21]
	#ip_inactivity_timeout=array[22]
	#ip_connection_timeout=array[23]
	#username=array[24]
	#filefunc=array[25]
	#moshelldir=array[26]
	#os=array[27]           # used by telnode_function
	#
	#logdir=array[28]            # used by cabview_function
	#inputoptions=array[29]      # used by cabview_function and alarm functions

}
function rtrdb_check(   thepid,theproc)
{
	if (dbc2) return
	if (cpplinux==1) { thepid=postgres_pid ; theproc="postgres" }
	else { thepid=rtrdb_pid ; theproc="rtrdb" }
	if (is_process_there(thepid)!=0)
	{
		customPrint("Fatal error: "theproc" process "thepid" not found.\n")
		exit_with_error()
	}
}
function moshell_parent_still_there(   theppid)
{
	if (os=="cygwin")
	{
		if (fileOps("test -d /proc/"moshell_parent_pid)!=0) return 1 SUBSEP "1" SUBSEP moshell_parent_pid
	}
	else
	{
		theppid=find_ppid(moshell_pid,"force")
		if (theppid!=moshell_parent_pid) return 1 SUBSEP theppid SUBSEP moshell_parent_pid
	}
	return 0
}
function is_process_there(pid,    res,ppid)
{
	#to avoid unnecessary system calls to the ps command, we use the built in library to check if the directory /proc/<pid> exists
	if (pid !~ /^[0-9]+$/) return 1
	res=fileOps("test -d /proc/"pid)
	if (res==0 && os!="cygwin" && comcli>0)
	{
		#check if the parent pid has changed.
		#For instance if the pid died a while ago it may happen that a new process got created with the same pid but in a different session
		#so we make sure that if the pid exists, it is the same pid that belongs to our own session and not a pid from another session
		#only do this on COM nodes due to the ssh pid changes more often (it times out after 2 minutes), and also only on solaris / linux since these use more pids than cygwin.
		ppid=find_ppid(pid)
		if (moshell_java_procparent[pid]!="" && ppid!="" && ppid!=moshell_java_procparent[pid]) res=1
	}
	if (res!=0)
	{
		delete moshell_java_proclist[pid]
		delete moshell_java_procparent[pid]
	}
	return res
}
function find_ppid(pid,force,   ppid,sfile)
{
	if (force=="")
	{
		#dont do this check on cygwin or CPP as it may slow things down and the chance of getting pid collision is lower in these cases
		#highest chances of pid collision is on COM nodes in solaris/linux due to the ssh process changes more often in COM and the solaris/linux use more pids than cygwin
		if (comcli==0 || os=="cygwin") return ""
	}
	if (os ~ /^sun/)
	{
		sfile="ps -fp "pid
		while (sfile |& getline)
		{
			if ($2==pid) ppid=$3
		}
		close(sfile)
	}
	else if (os == "linux")
	{
		sfile="/proc/"pid"/status"
		if (fileOps("test -f "sfile)!=0) return ""
		while ((getline < sfile)>0)
		{
			if ($1=="PPid:") ppid=$2
		}
		close(sfile)
	}
	#print "ppid="ppid
	return ppid
}
function find_CygRoot(   line,cygcom)
{
	cygcom="cygpath -m /"
	while (cygcom |& getline line)
	{
		#C:/cygwin
		sub("\r","")
		if (line ~ ":") CygRoot=line
	}
	close(cygcom)
	find_CygHome()
}
function find_CygHome(    line,cygcom)
{
	cygcom="cygpath -m $HOME"
	while (cygcom |& getline line)
	{
		#C:/cygwin/home/eanzmagn
		#or:
		#C:/Users/eanzmagn/Documents/CYGWIN/eanzmagn
		sub("\r","")
		if (line ~ ":") CygHome=line
	}
	close(cygcom)
}
function check_if_sql_is_running(    pscom,line,res)
{
	res=0
	pscom="ps -Ws"
	while (pscom |& getline line)
	{
		#   2260   ?  11:13:45 C:\cygwin\home\eanzmagn\tools\moshell\jarxml\sqlc.84.exe
		sub("\r","")
		if (line ~ /\\sqlc\.[0-9]+\.exe$/) res=1
	}
	close(pscom)
	return res
}
function run_sql_command(command,port,silent,norun,user,resultcsvfile,nocheck,  sqlcom,pipeCommand,sql_session,print_polyversion_info,result,sqcount,array,i,n,a)
{
	#print "COMMAND="command",port="port",silent="silent",norun="norun",user="user",resultcsvfile="resultcsvfile",nocheck="nocheck
	result=0
	if (nocheck=="") rtrdb_check()
	sub(/^[ \t]*sqlc*[ \t]+/,"",command)
	if (user=="user")
	{
		if (command ~ /[ \t]\|/)
		{
			pipeCommand=sprintf("| %s",gensub(/^[^\|]+\|/,"",1,command))
			sub(/\|.*$/,"",command)
		}
		if (command ~ /^select[ \t]+([^ \t]+)[ \t]+from[ \t]+([^ ;]+)/)
		{
			match(command,/^select[ \t]+([^ \t]+)[ \t]+from[ \t]+([^ ;]+)/,array)
			if ((!(array[2] in sqlUserFroTableList))&&(array[2] !~ /^(tables|motype_r[0-9]+|modata_r[0-9]+|attributes|mo_attribute_name_r[0-9])$/))
			{
				command=""
				for (i=1;i<=nrUserSqlFroTables;i++)
				{
					if (sortedSqlUserFroTableList[i] ~ tolower(array[2]))
					{
						command=command (cpplinux==1?"\\\\echo Error: unknown command: ":"") "echo select "array[1]" from "sortedSqlUserFroTableList[i]";select "array[1]" from "sortedSqlUserFroTableList[i]";"
					}
				}
				pipeCommand=sprintf("| %s \x27/^(SQL> )?Error: unknown command: echo /{sub(/^(SQL> )?Error: unknown command: echo /,\"\\nSQL> \")};{print}\x27 %s",usergawk,pipeCommand)
			}
		}
	}
	if (port=="") port=sqlport
	if (command !~ /;[ \t]*$/) command=command";"
	if (cpplinux==1)
	{
		sub(/^include /,"\\i ",command)
		sub(/exit;/,"\\q",command)
		if (command ~ / from tables/) command="\\dt"
		else if (command ~ /save +into +/)
		{
			sub(/^.*save +into +/,"",command)
			gsub(/[' ;]/,"",command)
			#if (command !~ /\.dat$/) command=command".dat"
			command=psqldir"/pg_dump -U postgres -Fc postgres -p "port" -b -C -f "command
			return system(command)
		}
	}
	if (os=="cygwin" && CygRoot=="") find_CygRoot()
	close(tempsqlcmd)
	if (resultcsvfile != "")
	{
		if (cpplinux==1) command=sprintf("\\copy (%s) to '%s' with CSV quote as '''' force quote data",gensub(/;+$/,"","g",command),resultcsvfile)
		else command = sprintf("writing \x27%s\x27 %s",(os=="cygwin"?concat_cyg(resultcsvfile):resultcsvfile),command)
	}
	if (cpplinux==1)
	{
		print "\\pset border 2" > tempsqlcmd
		n=split(command,a,";")
		for (i=1;i<=n;i++)
		{
			if (a[i]~/^ *$/) continue
			print a[i] (a[i]~/^\\/?"":";") >> tempsqlcmd
		}
	}
	else print command > tempsqlcmd
	close(tempsqlcmd)
	if (cpplinux==1) sqlcom=sprintf("%s -U postgres -p %s -d postgres --pset pager=off -q -f %s",psql,port,tempsqlcmd)
	else sqlcom=sprintf("%s -rdata_service=%s -rinclude_file=%s -rtype=sqlc SQL",sqlc,port,make_cygpath(tempsqlcmd))
	if (os=="cygwin" && cpplinux==0 && dbc2!=1)
	{
		sqlcom=sprintf("cygstart --hide %s \">%s/sqlcygwinoutput.txt\"",sqlcom,concat_cyg(tempdir))
		if (mosdebug==1) print "sqlcom: "sqlcom
		system(sqlcom)
		while (1)
		{
			usleep(1000000)
			if (check_if_sql_is_running()==0) break
			else
			{
				#if the commands is taking more than 3 seconds to execute, we put some progress indication
				sqcount++
				if (sqcount == 3) printf "Waiting for sqlc to complete..."
				else if (sqcount > 3) printf "."
			}
		}
		if (sqcount >= 3) print "Done."
		sqlcom="cat "tempdir"/sqlcygwinoutput.txt"
	}
	if (dbc2) sqlcom=sprintf("%s -v tempsqlcmd=%s -v dbdumpdir=%s -f %s/dbc2.awk --source 'BEGIN{dbc2func()}'",gawk,tempsqlcmd,tempdir"/dbdump",commonjardir)
	if (mosdebug==1) { print sqlcom"\n"command }
	if (norun=="norun") return sqlcom
	if (pipeCommand != "" && dbc2!=1)
	{
		if (logging==1)
		{
			pipeCommand=pipeCommand" | tee -a "logfile
			if (muteLog=="mute") pipeCommand=pipeCommand" | grep neverFindThisString"
		}
		if (cpplinux==1) sql_session=sprintf("%s -v cpplinux=%s -v moshelldir=%s -v postgres_pid=%s -v tempsqlcmd=%s -v psql=%s -v tempdir=%s -l %s -f %s --source \x27 BEGIN{ loadFilefuncs();run_sql_command(\"%s\",%s) } \x27 %s",gawk,cpplinux,moshelldir,postgres_pid,tempsqlcmd,psql,tempdir,filefunc,funcs,command,port,pipeCommand)
		else sql_session=sprintf("%s -v cpplinux=%s -v moshelldir=%s -v rtrdb_pid=%s -v CygRoot=\"%s\" -v CygHome=\"%s\" -v tempsqlcmd=%s -v sqlc=%s -v tempdir=%s -l %s -f %s --source \x27 BEGIN{ loadFilefuncs();run_sql_command(\"%s\",%s) } \x27 %s",gawk,cpplinux,moshelldir,rtrdb_pid,CygRoot,CygHome,tempsqlcmd,sqlc,tempdir,filefunc,funcs,command,port,pipeCommand)
		#sql_session=sprintf("%s -v moshelldir=%s -v rtrdb_pid=%s -v tempsqlcmd=%s -v sqlc=%s -v tempdir=%s -f %s --source \x27 BEGIN{ loadFilefuncs();run_sql_command(\"%s\",%s) } \x27 %s",gawk,moshelldir,rtrdb_pid,tempsqlcmd,sqlc,tempdir,funcs,command,port,pipeCommand)
		if (mosdebug==1) print "sql_session: "sql_session
		system(sql_session)
		return
	}
	#if (mosdebug==1) print "sqlcom: "sqlcom
	while (sqlcom |& getline)
	{
		#if (mosdebug==1) print
		if (silent!="silent")
		{
			customPrint($0)
			if (user=="user" && os != "cygwin" && $0 ~ /Error: This operation is not permitted on a read-only database./) print_polyversion_info=1
		}
		if (/Sorry, failed to connect to server|Could not find the Polyhedra db viewer|Failed to download Polyhedra db viewer|cannot be run on AMOS due to missing license.|The connection to the server was lost|server closed the connection/) result=1
	}
	close(sqlcom)
	if (print_polyversion_info==1) customPrint("\nFor write access to the database, run moshell with option \"-v polyversion=0\".")
	return result
}
function define_codes(   i)
{
	delete lmid_code_list
	#define the Cell error codes:
	defineErrorCodes()

	#AAL2 reject causes found in trace9 Ans_aal2ncc2_proc
	#CPP5
	#[2006-06-07 16:30:59.292] Ans_aal2ncc2_proc outPVfilter.c:417 TRACE9:rejectType = 1,rejectCause = 50331712
	#[2006-06-07 16:30:59.312] Ans_aal2ncc2_proc netconn.c:532 TRACE9:aal2NciRejCause = 3000040, rejectType = 1
	#CPP4
	#[2006-06-07 16:54:56.340] Ans_aal2ncc2_proc outPVfilter.c:410 TRACE9:rejectType = 1,rejectCause = 67108961
	#[2006-06-07 16:54:56.340] Ans_aal2ncc2_proc netconn.c:501 TRACE9:aal2NciRejCause = 4000061, rejectType = 1

	colour_string="ERROR:|reject|:Start of @|[rR]estart|lost contact|OMS initialized|:EMAN:"
	aal2RejCause[1]="LOCAL"
	aal2RejCause[2]="REMOTE"
	aal2RejCause["1000001"]=aal2RejCause["0x01"]=aal2RejCause[sprintf("%d",0x01000001)]="USAGE_FAULT_CLIENT_NOT_ATTACHED"
	aal2RejCause["1000002"]=aal2RejCause["0x02"]=aal2RejCause[sprintf("%d",0x01000002)]="USAGE_FAULT_CEP_CONNECT_REJECT"
	aal2RejCause["1000003"]=aal2RejCause["0x03"]=aal2RejCause[sprintf("%d",0x01000003)]="USAGE_FAULT_CEP_DISC_IND"
	aal2RejCause["1000005"]=aal2RejCause["0x05"]=aal2RejCause[sprintf("%d",0x01000005)]="USAGE_FAULT_SUGR_NOT_RESERVED"
	aal2RejCause["1000006"]=aal2RejCause["0x06"]=aal2RejCause[sprintf("%d",0x01000006)]="USAGE_FAULT_SUGR_MISMATCH"
	aal2RejCause["1000007"]=aal2RejCause["0x07"]=aal2RejCause[sprintf("%d",0x01000007)]="USAGE_FAULT_SUGR_ALREADY_IN_CONN"
	aal2RejCause["1000008"]=aal2RejCause["0x08"]=aal2RejCause[sprintf("%d",0x01000008)]="USAGE_FAULT_SUGR_OUT_OF_RANGE"
	aal2RejCause["1000009"]=aal2RejCause["0x09"]=aal2RejCause[sprintf("%d",0x01000009)]="USAGE_FAULT_UNREASONABLE_PAR"
	aal2RejCause["2000020"]=aal2RejCause["0x20"]=aal2RejCause[sprintf("%d",0x02000020)]="SERVER_FAULT_CPSRC_FAULT"
	aal2RejCause["2000021"]=aal2RejCause["0x21"]=aal2RejCause[sprintf("%d",0x02000021)]="SERVER_FAULT_AP_FAULT"
	aal2RejCause["2000022"]=aal2RejCause["0x22"]=aal2RejCause[sprintf("%d",0x02000022)]="SERVER_FAULT_CP_CONNECT_REJ"
	aal2RejCause["2000023"]=aal2RejCause["0x23"]=aal2RejCause[sprintf("%d",0x02000023)]="SERVER_FAULT_CP_DISC_IND"
	aal2RejCause["2000024"]=aal2RejCause["0x24"]=aal2RejCause[sprintf("%d",0x02000024)]="SERVER_FAULT_CEP_AUDITED"
	aal2RejCause["2000025"]=aal2RejCause["0x25"]=aal2RejCause[sprintf("%d",0x02000025)]="SERVER_FAULT_CP_AUDITED"
	aal2RejCause["2000026"]=aal2RejCause["0x26"]=aal2RejCause[sprintf("%d",0x02000026)]="SERVER_FAULT_CID_OUT_OF_RANGE"
	aal2RejCause["2000027"]=aal2RejCause["0x27"]=aal2RejCause[sprintf("%d",0x02000027)]="SERVER_FAULT_SIGNALING_MISMATCH"
	aal2RejCause["2000028"]=aal2RejCause["0x28"]=aal2RejCause[sprintf("%d",0x02000028)]="SERVER_FAULT_GRI_RES_UNAVAILABLE"
	aal2RejCause["2000029"]=aal2RejCause["0x29"]=aal2RejCause[sprintf("%d",0x02000029)]="SERVER_FAULT_GRI_MANG_IND"
	aal2RejCause["2000030"]=aal2RejCause["0x30"]=aal2RejCause[sprintf("%d",0x02000030)]="SERVER_FAULT_GRI_OTHER"
	aal2RejCause["2000031"]=aal2RejCause["0x31"]=aal2RejCause[sprintf("%d",0x02000031)]="SERVER_FAULT_GRI_PAR_NOT_SUPPORTED"
	aal2RejCause["3000040"]=aal2RejCause["0x40"]=aal2RejCause[sprintf("%d",0x03000040)]="CONFIGURATION_FAULT_NO_MATCH_FOR_AESA"
	aal2RejCause["3000041"]=aal2RejCause["0x41"]=aal2RejCause[sprintf("%d",0x03000041)]="CONFIGURATION_FAULT_NO_PATH"
	aal2RejCause["3000042"]=aal2RejCause["0x42"]=aal2RejCause[sprintf("%d",0x03000042)]="CONFIGURATION_FAULT_QOS_FORBIDDEN"
	aal2RejCause["3000043"]=aal2RejCause["0x43"]=aal2RejCause[sprintf("%d",0x03000043)]="CONFIGURATION_FAULT_PATH_NO_SUCH_ID"
	aal2RejCause["4000060"]=aal2RejCause["0x60"]=aal2RejCause[sprintf("%d",0x04000060)]="AMBIGUOUS_FAULT_EMPTY_ROUTING_TABLE"
	aal2RejCause["4000061"]=aal2RejCause["0x61"]=aal2RejCause[sprintf("%d",0x04000061)]="AMBIGUOUS_FAULT_SIGNALLING_LINK_DOWN"
	aal2RejCause["4000062"]=aal2RejCause["0x62"]=aal2RejCause[sprintf("%d",0x04000062)]="AMBIGUOUS_FAULT_NO_AP_PROGRAM"
	aal2RejCause["4000063"]=aal2RejCause["0x63"]=aal2RejCause[sprintf("%d",0x04000063)]="AMBIGUOUS_FAULT_NO_CPSRC_PROGRAM"
	aal2RejCause["4000064"]=aal2RejCause["0x64"]=aal2RejCause[sprintf("%d",0x04000064)]="AMBIGUOUS_FAULT_NO_SPAS_PROGRAM"
	aal2RejCause["4000065"]=aal2RejCause["0x65"]=aal2RejCause[sprintf("%d",0x04000065)]="AMBIGUOUS_FAULT_CPSRC_NOT_STARTED"
	aal2RejCause["4000066"]=aal2RejCause["0x66"]=aal2RejCause[sprintf("%d",0x04000066)]="AMBIGUOUS_FAULT_AP_OUTGOING_RESET"
	aal2RejCause["4000067"]=aal2RejCause["0x67"]=aal2RejCause[sprintf("%d",0x04000067)]="AMBIGUOUS_FAULT_AP_INCOMING_RESET"
	aal2RejCause["4000068"]=aal2RejCause["0x68"]=aal2RejCause[sprintf("%d",0x04000068)]="AMBIGUOUS_FAULT_CID_INCOMING_RESET"
	aal2RejCause["4000069"]=aal2RejCause["0x69"]=aal2RejCause[sprintf("%d",0x04000069)]="AMBIGUOUS_FAULT_PATH_NO_HW"
	aal2RejCause["4000070"]=aal2RejCause["0x70"]=aal2RejCause[sprintf("%d",0x04000070)]="AMBIGUOUS_FAULT_CID_REL_TMO"
	aal2RejCause["4000071"]=aal2RejCause["0x71"]=aal2RejCause[sprintf("%d",0x04000071)]="AMBIGUOUS_FAULT_CID_REQ_TMO"
	aal2RejCause["4000072"]=aal2RejCause["0x72"]=aal2RejCause[sprintf("%d",0x04000072)]="AMBIGUOUS_FAULT_PATH_OUTGOING_BLOCKED"
	aal2RejCause["4000073"]=aal2RejCause["0x73"]=aal2RejCause[sprintf("%d",0x04000073)]="AMBIGUOUS_FAULT_PATH_INCOMING_BLOCKED"
	aal2RejCause["400006a"]=aal2RejCause["0x6a"]=aal2RejCause[sprintf("%d",0x0400006a)]="AMBIGUOUS_FAULT_PATH_OUTGOING_RESET"
	aal2RejCause["400006b"]=aal2RejCause["0x6b"]=aal2RejCause[sprintf("%d",0x0400006b)]="AMBIGUOUS_FAULT_PATH_INCOMING_RESET"
	aal2RejCause["400006c"]=aal2RejCause["0x6c"]=aal2RejCause[sprintf("%d",0x0400006c)]="AMBIGUOUS_FAULT_DATA_TERMINATION_DOWN"
	aal2RejCause["400006d"]=aal2RejCause["0x6d"]=aal2RejCause[sprintf("%d",0x0400006d)]="AMBIGUOUS_FAULT_PORTID_UNKNOWN"
	aal2RejCause["400006e"]=aal2RejCause["0x6e"]=aal2RejCause[sprintf("%d",0x0400006e)]="AMBIGUOUS_FAULT_GRI_CLIENT_DOWN"
	aal2RejCause["400006f"]=aal2RejCause["0x6f"]=aal2RejCause[sprintf("%d",0x0400006f)]="AMBIGUOUS_FAULT_GRI_SERVER_DOWN"
	aal2RejCause["50000b0"]=aal2RejCause["0xb0"]=aal2RejCause[sprintf("%d",0x050000b0)]="CONGESTION_FAULT_TOO_MANY_CONNECTIONS"
	aal2RejCause["50000b1"]=aal2RejCause["0xb1"]=aal2RejCause[sprintf("%d",0x050000b1)]="CONGESTION_FAULT_CONG_C"
	aal2RejCause["50000b2"]=aal2RejCause["0xb2"]=aal2RejCause[sprintf("%d",0x050000b2)]="CONGESTION_FAULT_CONG_B"
	aal2RejCause["50000b3"]=aal2RejCause["0xb3"]=aal2RejCause[sprintf("%d",0x050000b3)]="CONGESTION_FAULT_CONG_C_B"
	aal2RejCause["50000b4"]=aal2RejCause["0xb4"]=aal2RejCause[sprintf("%d",0x050000b4)]="CONGESTION_FAULT_CONG_I"
	aal2RejCause["50000b5"]=aal2RejCause["0xb5"]=aal2RejCause[sprintf("%d",0x050000b5)]="CONGESTION_FAULT_CONG_I_C"
	aal2RejCause["50000b6"]=aal2RejCause["0xb6"]=aal2RejCause[sprintf("%d",0x050000b6)]="CONGESTION_FAULT_CONG_I_B"
	aal2RejCause["50000b7"]=aal2RejCause["0xb7"]=aal2RejCause[sprintf("%d",0x050000b7)]="CONGESTION_FAULT_CONG_I_B_C"
	aal2RejCause["50000b8"]=aal2RejCause["0xb8"]=aal2RejCause[sprintf("%d",0x050000b8)]="CONGESTION_FAULT_CONG_O"
	aal2RejCause["50000b9"]=aal2RejCause["0xb9"]=aal2RejCause[sprintf("%d",0x050000b9)]="CONGESTION_FAULT_CONG_O_C"
	aal2RejCause["50000ba"]=aal2RejCause["0xba"]=aal2RejCause[sprintf("%d",0x050000ba)]="CONGESTION_FAULT_CONG_O_B"
	aal2RejCause["50000bb"]=aal2RejCause["0xbb"]=aal2RejCause[sprintf("%d",0x050000bb)]="CONGESTION_FAULT_CONG_O_C_B"
	aal2RejCause["50000bc"]=aal2RejCause["0xbc"]=aal2RejCause[sprintf("%d",0x050000bc)]="CONGESTION_FAULT_CONG_O_I"
	aal2RejCause["50000bd"]=aal2RejCause["0xbd"]=aal2RejCause[sprintf("%d",0x050000bd)]="CONGESTION_FAULT_CONG_O_I_C"
	aal2RejCause["50000be"]=aal2RejCause["0xbe"]=aal2RejCause[sprintf("%d",0x050000be)]="CONGESTION_FAULT_CONG_O_I_B"
	aal2RejCause["50000bf"]=aal2RejCause["0xbf"]=aal2RejCause[sprintf("%d",0x050000bf)]="CONGESTION_FAULT_CONG_O_I_C_B"
	aal2RejCause["50000c0"]=aal2RejCause["0xc0"]=aal2RejCause[sprintf("%d",0x050000c0)]="CONGESTION_FAULT_CONG_D"
	aal2RejCause["50000c1"]=aal2RejCause["0xc1"]=aal2RejCause[sprintf("%d",0x050000c1)]="CONGESTION_FAULT_CONG_D_C"
	aal2RejCause["50000c2"]=aal2RejCause["0xc2"]=aal2RejCause[sprintf("%d",0x050000c2)]="CONGESTION_FAULT_CONG_D_B"
	aal2RejCause["50000c3"]=aal2RejCause["0xc3"]=aal2RejCause[sprintf("%d",0x050000c3)]="CONGESTION_FAULT_CONG_D_C_B"
	aal2RejCause["50000c4"]=aal2RejCause["0xc4"]=aal2RejCause[sprintf("%d",0x050000c4)]="CONGESTION_FAULT_CONG_D_I"
	aal2RejCause["50000c5"]=aal2RejCause["0xc5"]=aal2RejCause[sprintf("%d",0x050000c5)]="CONGESTION_FAULT_CONG_D_I_C"
	aal2RejCause["50000c6"]=aal2RejCause["0xc6"]=aal2RejCause[sprintf("%d",0x050000c6)]="CONGESTION_FAULT_CONG_D_I_B"
	aal2RejCause["50000c7"]=aal2RejCause["0xc7"]=aal2RejCause[sprintf("%d",0x050000c7)]="CONGESTION_FAULT_CONG_D_I_B_C"
	aal2RejCause["50000c8"]=aal2RejCause["0xc8"]=aal2RejCause[sprintf("%d",0x050000c8)]="CONGESTION_FAULT_CONG_D_O"
	aal2RejCause["50000c9"]=aal2RejCause["0xc9"]=aal2RejCause[sprintf("%d",0x050000c9)]="CONGESTION_FAULT_CONG_D_O_C"
	aal2RejCause["50000ca"]=aal2RejCause["0xca"]=aal2RejCause[sprintf("%d",0x050000ca)]="CONGESTION_FAULT_CONG_D_O_B"
	aal2RejCause["50000cb"]=aal2RejCause["0xcb"]=aal2RejCause[sprintf("%d",0x050000cb)]="CONGESTION_FAULT_CONG_D_O_C_B"
	aal2RejCause["50000cc"]=aal2RejCause["0xcc"]=aal2RejCause[sprintf("%d",0x050000cc)]="CONGESTION_FAULT_CONG_D_O_I"
	aal2RejCause["50000cd"]=aal2RejCause["0xcd"]=aal2RejCause[sprintf("%d",0x050000cd)]="CONGESTION_FAULT_CONG_D_O_I_C"
	aal2RejCause["50000ce"]=aal2RejCause["0xce"]=aal2RejCause[sprintf("%d",0x050000ce)]="CONGESTION_FAULT_CONG_D_O_I_B"
	aal2RejCause["50000cf"]=aal2RejCause["0xcf"]=aal2RejCause[sprintf("%d",0x050000cf)]="CONGESTION_FAULT_CONG_D_O_I_C_B"
	aal2RejCause["50000d0"]=aal2RejCause["0xd0"]=aal2RejCause[sprintf("%d",0x050000d0)]="CONGESTION_FAULT_SPAS_CONGESTION"
	aal2RejCause["50000d1"]=aal2RejCause["0xd1"]=aal2RejCause[sprintf("%d",0x050000d1)]="CONGESTION_FAULT_CONG_TRAF_CLASS"

	#aal2RejCause[1]  = "Q2630_1_UNALLOCATED_NUMBER"  #clashes with aal2rejcause "local"
	aal2RejCause[3]  = "Q2630_1_NO_ROUTE_TO_DESTINATION"
	aal2RejCause[31] = "Q2630_1_NORMAL_UNSPECIFIED"
	aal2RejCause[34] = "Q2630_1_NO_CHANNEL_AVAILABLE"
	aal2RejCause[38] = "Q2630_1_NETWORK_OUT_OF_ORDER"
	aal2RejCause[41] = "Q2630_1_TEMPORARY_FAILURE"
	aal2RejCause[42] = "Q2630_1_SWITCHING_EQUIPMENT_CONGESTION"
	aal2RejCause[44] = "Q2630_1_REQUESTED_CHANNEL_NOT_AVAILABLE"
	aal2RejCause[47] = "Q2630_1_RESOURCE_UNAVAILABLE"
	aal2RejCause[93] = "Q2630_1_AAL_PARAM_CAN_NOT_BE_SUPPORTED"
	aal2RejCause[95] = "Q2630_1_INVALID_MESSAGE"
	aal2RejCause[96] = "Q2630_1_MANDATORY_INFO_MISSING"
	aal2RejCause[97] = "Q2630_1_MESSAGE_TYPE_NOT_EXIST"
	aal2RejCause[99] = "Q2630_1_INFOELEM_PARAMETER_NOT_IMPLEMENTED"
	aal2RejCause[100]= "Q2630_1_INVALID_INFO_ELEM_CONTENTS"
	aal2RejCause[102]= "Q2630_1_RECOVERY_ON_TIMER_EXPIRY"
	aal2RejCause[110]= "Q2630_1_MSG_WITH_UNRECOGNIZED_PARAM_DISCARDED"

	for (i in aal2RejCause) lmid_code_list[sprintf("Aal2 Reject Cause: %10s = %s",i,aal2RejCause[i])]=sprintf("Aal2 Reject Cause %10s = %s",i,aal2RejCause[i])

	#MTP3 codes
	mtp3_state[0]  ="LINK_STATUS_S00_Init"
	mtp3_state[1]  ="LINK_STATUS_S01_OutOfService"
	mtp3_state[2]  ="LINK_STATUS_S02_WaitForT17"
	mtp3_state[3]  ="LINK_STATUS_S03_Aligning"
	mtp3_state[4]  ="LINK_STATUS_S035_AligningInMTP-l2"
	mtp3_state[5]  ="LINK_STATUS_S04_InService"
	mtp3_state[6]  ="LINK_STATUS_S05_RemoteProcOutageOrCongestion"
	mtp3_state[7]  ="LINK_STATUS_S06_WaitForBSNT"
	mtp3_state[8]  ="LINK_STATUS_S07_WaitForAck"
	mtp3_state[9]  ="LINK_STATUS_S08_Retriev"
	mtp3_state[10] ="LINK_STATUS_S09_WaitForBSNT"
	mtp3_state[11] ="LINK_STATUS_S10_TimerControlledCBD"
	mtp3_state[12] ="LINK_STATUS_S11_CBDFirst"
	mtp3_state[13] ="LINK_STATUS_S12_CBDSecond"

	for (i in mtp3_state) lmid_code_list[sprintf("MTP3 State: %10s = %s",i,mtp3_state[i])]=sprintf("MTP3 State: %10s = %s",i,mtp3_state[i])

	mtp3_event[10]="STOPALL_ID"
	mtp3_event[11]="STARTALL_ID"
	mtp3_event[12]="STARTEALL_ID"
	mtp3_event[13]="FRROUTING_ID"
	mtp3_event[14]="CRROUTING_ID"
	mtp3_event[15]="LSETNACT_ID"
	mtp3_event[16]="LSETDEACT_ID"
	mtp3_event[17]="LSETEACT_ID"
	mtp3_event[18]="LINKNACT_ID"
	mtp3_event[19]="LINKDEACT_ID"
	mtp3_event[20]="LINKEACT_ID"
	mtp3_event[21]="LINKSTATUS_ID"
	mtp3_event[22]="LINKSETSTATUS_ID"
	mtp3_event[23]="ROUTESETSTATUS_ID"
	mtp3_event[24]="DPCSTATUS_ID"
	mtp3_event[25]="STATUSOFLINKS_ID"
	mtp3_event[26]="LINKINHIBIT_ID"
	mtp3_event[27]="LINKUNINHIBIT_ID"
	mtp3_event[28]="TESTROUTE_ID"
	mtp3_event[29]="GETSTATE_ID"
	mtp3_event[30]="SETSTATE_ID"

	for (i in mtp3_event) lmid_code_list[sprintf("MTP3 Event: %10s = %s",i,mtp3_event[i])]=sprintf("MTP3 Event: %10s = %s",i,mtp3_event[i])

	mtp3_error[11000]="NO_ERROR"
	mtp3_error[11001]="SI_ERROR"
	mtp3_error[11002]="PARAM_NOT_VALID"
	mtp3_error[11003]="NO_SUCH_USER"
	mtp3_error[11004]="TIMERS_MISSING"
	mtp3_error[11005]="ACT_FAILED"
	mtp3_error[11006]="DEACT_FAILED"
	mtp3_error[11007]="BIND_TIMEOUT"
	mtp3_error[11008]="MSG_NONCONF_LINK"
	mtp3_error[11009]="MSG_FOR_ROUTING"
	mtp3_error[11010]="FILENAME_ERROR"
	mtp3_error[11011]="PARAM_MISSING"
	mtp3_error[11012]="ILLEGAL_NI_CONF"
	mtp3_error[11013]="ILLEGAL_NO_CCARDS"
	mtp3_error[11014]="ILLEGAL_NO_LINK_CARD"
	mtp3_error[11015]="ILLEGAL_OPC"
	mtp3_error[11016]="ILLEGAL_TIMER_TBIND"
	mtp3_error[11017]="ILLEGAL_TIMER_T1"
	mtp3_error[11018]="ILLEGAL_TIMER_T6"
	mtp3_error[11019]="ILLEGAL_TIMER_T17"
	mtp3_error[11020]="ILLEGAL_NO_SUBSETS"
	mtp3_error[11021]="SUBSET_SORT_ERROR"
	mtp3_error[11022]="ILLEGAL_NO_LINKS_SUBSET"
	mtp3_error[11023]="ILLEGAL_SLC"
	mtp3_error[11024]="ILLEGAL_HSN"
	mtp3_error[11025]="ILLEGAL_SDL"
	mtp3_error[11026]="ILLEGAL_ADJ_DPC"
	mtp3_error[11027]="PH_LINK_CONN_TWICE"
	mtp3_error[11028]="ILLEGAL_NO_ROUTES"
	mtp3_error[11029]="ROUTE_SORT_ERROR"
	mtp3_error[11030]="ILLEGAL_SUBSETA"
	mtp3_error[11031]="NONEXIST_SUBSET"
	mtp3_error[11032]="ILLEGAL_SUBSETB"
	mtp3_error[11033]="ILLEGAL_LOADSH_PARAM"
	mtp3_error[11034]="LOADSH_NOT_POSSIBLE"
	mtp3_error[11035]="ILLEGAL_NO_ROUTESETS"
	mtp3_error[11036]="ROUTESET_SORT_ERROR"
	mtp3_error[11037]="ILLEGAL_NO_ALT_ROUTES"
	mtp3_error[11038]="NO_ALT_ROUTES_MISMATCH"
	mtp3_error[11039]="NONEXIST_ALT_ROUTE"
	mtp3_error[11040]="NONEXIST_ROUTESET"
	mtp3_error[11041]="NO_ACTIVE_ROUTE"
	mtp3_error[11042]="NO_ACTIVE_LINKS_ROUTE"
	mtp3_error[11043]="TOOMANY_COO_IN_ROUTE"
	mtp3_error[11044]="ROUTESET_CONG"
	mtp3_error[11045]="MSG_UNSUP_NI"
	mtp3_error[11046]="UP_UNAVAILABLE"
	mtp3_error[11047]="UNDEF_EVENT_ERROR"
	mtp3_error[11048]="FRR_NOT_NEEDED"
	mtp3_error[11049]="MSG_FOR_DISTR"
	mtp3_error[11050]="FRR_NOT_POSSIBLE"
	mtp3_error[11051]="CRR_NOT_POSSIBLE"
	mtp3_error[11052]="UNSUP_SLTC_MSG_H0"
	mtp3_error[11053]="UNSUP_SLTC_MSG_H1"
	mtp3_error[11054]="INCORRECT_SLTM_LINKERR"
	mtp3_error[11055]="INCORRECT_SLTM_OPCERR"
	mtp3_error[11056]="UNSUP_NETW_HAND_MSG"
	mtp3_error[11057]="ECO_ATTEMPTED_TWICE"
	mtp3_error[11058]="FRR_AFTER_ECO"
	mtp3_error[11059]="LINK_SP_NULL_SUBSET"
	mtp3_error[11060]="CBD_FOR_NONEXIST_DPC"
	mtp3_error[11061]="CBD_FOR_NONEXIST_ROUTE"
	mtp3_error[11062]="CBD_FOR_NONEXIST_LINK"
	mtp3_error[11063]="TFC_FOR_NONEXIST_DPC"
	mtp3_error[11064]="UPU_FOR_NONEXIST_USER"
	mtp3_error[11065]="NO_LINKS_IN_SUBSET"
	mtp3_error[11066]="NO_ACT_LINKS_IN_SUBSET"
	mtp3_error[11067]="VIRTUAL_LINK_FOUND"
	mtp3_error[11068]="REDIRECTED_LINK_FOUND"
	mtp3_error[11069]="NOT_FOUND"
	mtp3_error[11070]="FOUND"
	mtp3_error[11071]="FILE_OPEN_ERROR"
	mtp3_error[11072]="FILE_READ_ERROR"
	mtp3_error[11073]="MEM_ALLOC_ERROR"
	mtp3_error[11074]="MSG_RECEIVE_ERROR"
	mtp3_error[11075]="QUEUE_OPEN_ERROR"
	mtp3_error[11076]="QUEUE_ERROR"
	mtp3_error[11077]="SEND_ERROR"
	mtp3_error[11078]="QUEUE_CLOSE_ERROR"
	mtp3_error[11079]="TIMER_REQ_ERROR"
	mtp3_error[11080]="EMERGENCY_CHANGEOVER_FOR_NONEXISTING_LINK"
	mtp3_error[11081]="BIND_ERROR"
	mtp3_error[11082]="TIMEXP_NONEXIST_ITEM"
	mtp3_error[11083]="WRONG_STATE_ERROR"
	mtp3_error[11084]="SYS_NOT_INIT"
	mtp3_error[11085]="OFFSET_OPERATION_FAILED"
	mtp3_error[11086]="FILE_CLOSE_ERROR"
	mtp3_error[11087]="MSG_INIT_ERROR"
	mtp3_error[11088]="UNSUP_CONF_FILE"
	mtp3_error[11089]="ILLEGAL_NO_SPS"
	mtp3_error[11090]="UNEXPECTED_CONGCEASE"
	mtp3_error[11091]="CONGCEASE_REC_RPO"
	mtp3_error[11092]="UNEXPECTED_RPOR"
	mtp3_error[11093]="RPOR_REC_CONGESTION"
	mtp3_error[11094]="ILLEGAL_OPC_INDEX"
	mtp3_error[11095]="LINK_OOS_ERROR"
	mtp3_error[11096]="LINK_INS_ERROR"
	mtp3_error[11097]="ILLEGAL_TIMER_T10"
	mtp3_error[11098]="ILLEGAL_TIMER_SLTM"
	mtp3_error[11099]="ILLEGAL_TIMER_SLTA"
	mtp3_error[11100]="NO_ANSWER_ON_START_REQ"
	mtp3_error[11101]="SLTA_1_TIME_OUT"
	mtp3_error[11102]="SLTA_2_TIME_OUT"
	mtp3_error[11103]="FAULTY_SLTA"
	mtp3_error[11104]="ILLEGAL_TIMER_START"
	mtp3_error[11105]="ILLEGAL_TFR_EQUAL_TFA"
	mtp3_error[11106]="ILLEGAL_TIMER_SLTM_LESS_THAN_SLTA"
	mtp3_error[11107]="LINK_NOT_FOUND"
	mtp3_error[11108]="NO_VALID_TIMER"
	mtp3_error[11109]="WRONG_LENGTH"
	mtp3_error[11110]="ILLEGAL_MTPL3"
	mtp3_error[11111]="ILLEGAL_TIMER_T2"
	mtp3_error[11112]="ILLEGAL_TIMER_T3"
	mtp3_error[11113]="ILLEGAL_TIMER_T4"
	mtp3_error[11114]="ILLEGAL_TIMER_T5"
	mtp3_error[11118]="ILLEGAL_TIMER_TLOCALINHIBITTEST"
	mtp3_error[11119]="ILLEGAL_TIMER_TREMOTEINHIBITTEST"
	mtp3_error[11120]="ILLEGAL_TIMER_BSNT"
	mtp3_error[11121]="ILLEGAL_TIMER_RETRIEVE"
	mtp3_error[11122]="ILLEGAL_TIMER_T12"
	mtp3_error[11123]="ILLEGAL_TIMER_T13"
	mtp3_error[11124]="ILLEGAL_TIMER_T14"
	mtp3_error[11125]="ILLEGAL_TIMER_TINITOWNSPRESTART"
	mtp3_error[11126]="ILLEGAL_TIMER_TMAXOWNSPRESTART"
	mtp3_error[11127]="NO_SUPPORT_FOR_24BIT_PC"
	mtp3_error[11128]="ILLEGAL_NO_ALLOWEDOPCS"
	mtp3_error[11129]="INCOMING_OPC_NOT_ALLOWED"
	mtp3_error[11130]="ILLEGAL_SLTM_OPTION"
	mtp3_error[11131]="ILLEGAL_PATTERN_FORMAT"
	mtp3_error[11132]="ILLEGAL_PATTERN_LEN"
	mtp3_error[11133]="NO_LINKS_IN_ROUTE"
	mtp3_error[11134]="NO_ACT_LINKS_IN_ROUTE"
	mtp3_error[11135]="INACTIVE_LINK_FOUND"
	mtp3_error[11136]="LINK_SP_NULL_ROUTE"
	mtp3_error[11137]="TRA_FOR_NONEXIST_LINK"
	mtp3_error[11138]="TREMOTEINHIBITTESTEXP_FOR_NONEXIST_ADJSP"
	mtp3_error[11139]="ILLEGAL_REROUTING_BUFFER_SIZE"
	mtp3_error[11140]="ILLEGAL_CHANGEOVER_BUFFER_SIZE"
	mtp3_error[11141]="ILLEGAL_PRI_SLTM"
	mtp3_error[11142]="ILLEGAL_PRI_COO"
	mtp3_error[11143]="ILLEGAL_PRI_CBD"
	mtp3_error[11144]="ILLEGAL_PRI_ECO"
	mtp3_error[11145]="ILLEGAL_PRI_RSP"
	mtp3_error[11146]="ILLEGAL_PRI_LIN"
	mtp3_error[11147]="ILLEGAL_PRI_TRA"
	mtp3_error[11148]="ILLEGAL_PRI_UPU"
	mtp3_error[11149]="ILLEGAL_CONGTREATMENT_NI2"
	mtp3_error[11150]="ILLEGAL_CONGTREATMENT_NI3"
	mtp3_error[11151]="ILLEGAL_STATUS_INTERVAL"
	mtp3_error[11152]="ILLEGAL_CONF_CONGPRI_ROUTE"
	mtp3_error[11153]="UNEXPECTED_LIA_RECEIVED"
	mtp3_error[11154]="UNEXPECTED_LUA_RECEIVED"
	mtp3_error[11155]="COO_BUFFER_FULL"
	mtp3_error[11156]="BUFFER_FOR_FOUND_LINK"
	mtp3_error[11157]="BUFFER_FOR_ROUTE"
	mtp3_error[11158]="LINK_INHIBITED"
	mtp3_error[11159]="LINK_REMOTELY_INHIBITED"
	mtp3_error[11160]="RECEIVED_LUA_WHILE_RPO"
	mtp3_error[11161]="RECEIVED_LUA_WHILE_CONGESTION"
	mtp3_error[11162]="RECEIVED_LUN_WHILE_RPO"
	mtp3_error[11163]="RECEIVED_LUN_WHILE_CONGESTION"
	mtp3_error[11164]="ROUTESET_LOST"
	mtp3_error[11165]="ILLEGAL_TIMER_TPERIODICTRW"
	mtp3_error[11166]="ILLEGAL_TIMER_TMINRESTARTOUTAGE"
	mtp3_error[11167]="ILLEGAL_TIMER_TINITADJACENTSPRESTART"
	mtp3_error[11168]="ILLEGAL_TIMER_TRESTARTRESPONSE"
	mtp3_error[11169]="ILLEGAL_TIMER_TMAXADJACENTSPRESTART"
	mtp3_error[11170]="BLOCKED_ROUTE"
	mtp3_error[11171]="EXCEEDED_AVAILABLE_LINKLICENSES"
	mtp3_error[11172]="ILLEGAL_LOWLINK_AVAIL"
	mtp3_error[11173]="ILLEGAL_NORMALLINK_AVAIL"
	mtp3_error[11174]="ILLEGAL_LINK_THRESHOLDS"
	mtp3_error[11175]="BLOCKING_ERROR"
	mtp3_error[11176]="ALLREADY_CONGESTED"
	mtp3_error[11177]="ILLEGAL_LINKCLASS"
	mtp3_error[11178]="UNSUPP_MSG_FOR_LINKCLASS"
	mtp3_error[11180]="EMPTY_CONFIG"
	mtp3_error[11181]="USER_BOUND"
	mtp3_error[11182]="NO_USER_BOUND"
	mtp3_error[11183]="ZERO_OPCS"
	mtp3_error[11184]="DPC_NOT_FOUND"
	mtp3_error[11185]="HALF_CONFIG"
	mtp3_error[11186]="ILLEGAL_TIMER_T8"
	mtp3_error[11187]="ILLEGAL_TIMER_T18"
	mtp3_error[11188]="INVALID_STP_ROUTE"
	mtp3_error[11189]="ILLEGAL_TIMER_TANSIUNEXPECTEDTRWTRA"
	mtp3_error[11190]="ILLEGAL_STP"
	mtp3_error[11191]="ILLEGAL_NO_PROHIBITED_STP"
	mtp3_error[11192]="PROHIBITED_STP"
	mtp3_error[11193]="ILLEGAL_PROHIB_NO"
	mtp3_error[11194]="MSU_LENGTH_TOO_LONG"
	mtp3_error[11202]="ILLEGAL_LINKSET_BEH_MASK"
	mtp3_error[11203]="RPO_RECVD"
	mtp3_error[11204]="RPOR_RECVD"
	mtp3_error[11206]="ILLEGAL_PRIORITY"
	mtp3_error[11208]="ILLEGAL_TIMER_TSRA"
	mtp3_error[11209]="ROUTESET_TESTED"
	mtp3_error[11210]="ILLEGAL_PRI_TFC"
	mtp3_error[11211]="ILLEGAL_PRI_SRT"
	mtp3_error[11212]="SRA_1_TIME_OUT"
	mtp3_error[11213]="SRA_2_TIME_OUT"
	mtp3_error[11215]="MISMATCH_ROUTE_TFP_ERROR"
	mtp3_error[11216]="SRT_STARTED"
	mtp3_error[11217]="MISMATCH_ROUTE_TFA_ERROR"
	mtp3_error[11218]="FAULTY_SRA"
	mtp3_error[11219]="UNSUP_SRT_MSG"
	mtp3_error[11220]="INCORRECT_SRT_LINKERR"
	mtp3_error[11223]="UNKNOWN_CBD_CODE"
	mtp3_error[11224]="ILLEGAL_ROUTE_PRIORITY"
	mtp3_error[11225]="LINK_ALREADY_ACTIVATED"
	mtp3_error[11226]="ILLEGAL_TIMER_TDLACK"
	mtp3_error[11227]="USER_NOT_BOUND"
	mtp3_error[11230]="NMM_MESSAGE"
	mtp3_error[11231]="NMM_T_MESSAGE"
	mtp3_error[11232]="NMM_U_MESSAGE"
	mtp3_error[11233]="BUFF_IN_S02"
	mtp3_error[11234]="ILLEGAL_NO_SECONDAR_PC"
	mtp3_error[11235]="SECONDARY_PC_SORT_ERROR"
	mtp3_error[11236]="ILLEGAL_PRI_TFP"
	mtp3_error[11237]="MSG_FOR_TRANSFER"
	#M3UA codes:
	mtp3_error[11238]="ILLEGAL_STANDARD"
	mtp3_error[11239]="ILLEGAL_NODE_BEHAVIOR"
	mtp3_error[11240]="ILLEGAL_NODE_BEHAVIOR_CHANGE"
	mtp3_error[11241]="ILLEGAL_TIMER_TACK"
	mtp3_error[11242]="ILLEGAL_TIMER_TAUD"
	mtp3_error[11243]="ILLEGAL_TIMER_T15"
	mtp3_error[11244]="ILLEGAL_TIMER_T16"
	mtp3_error[11245]="ILLEGAL_TIMER_T30"
	mtp3_error[11246]="ILLEGAL_TIMER_T31"
	mtp3_error[11247]="ILLEGAL_TIMER_T40"
	mtp3_error[11248]="ILLEGAL_TIMER_T41"
	mtp3_error[11249]="ILLEGAL_TIMER_T42"
	mtp3_error[11250]="ILLEGAL_LOCAL_INBOUND"
	mtp3_error[11251]="ILLEGAL_LOCAL_OUTBOUND"
	mtp3_error[11252]="ILLEGAL_PORT_NO"
	mtp3_error[11253]="ILLEGAL_NO_IP"
	mtp3_error[11254]="ILLEGAL_IP_TYPE"
	mtp3_error[11255]="ILLEGAL_IP_ADDRESS"
	mtp3_error[11256]="ILLEGAL_SCTP_DSCP"
	mtp3_error[11257]="ILLEGAL_NO_ASSOC"
	mtp3_error[11258]="ILLEGAL_SAID"
	mtp3_error[11259]="ILLEGAL_RPORT_NO"
	mtp3_error[11260]="ILLEGAL_NO_RIP"
	mtp3_error[11261]="ILLEGAL_RIP_TYPE"
	mtp3_error[11262]="ILLEGAL_RIP_ADDRESS"
	mtp3_error[11263]="ILLEGAL_REQ_OUTSTREAM"
	mtp3_error[11264]="ILLEGAL_AUTOSTART_CONF"
	mtp3_error[11265]="ROUTE_TYPE_ERROR"
	mtp3_error[11266]="NONEXIST_ASSOC"
	mtp3_error[11267]="ENCODE_ERROR"
	mtp3_error[11268]="ASSOCIATION_IS_BLOCKED"
	mtp3_error[11269]="ASSOC_THM_UNSUPPORTED"
	mtp3_error[11270]="ASSOC_INVALID_RC"
	mtp3_error[11271]="DECODED_PROTOCOL_LENGTH_ERROR"
	mtp3_error[11272]="DECODED_UNEXPTD_PARAM"
	mtp3_error[11273]="DECODED_UNSUPP_MSG_CLASS"
	mtp3_error[11274]="DECODED_INVALID_VERSION_FROM_PEER"
	mtp3_error[11275]="DECODED_INVALID_VERSION"
	mtp3_error[11276]="DECODED_DISCARD_MSG"
	mtp3_error[11277]="DECODED_ERROR_IN_ERROR_MSG"
	mtp3_error[11278]="DECODED_PROTOCOL_PARAM_VALUE_ERROR"
	mtp3_error[11279]="DECODED_PROTOCOL_PARAM_MISSING_ERROR"
	mtp3_error[11280]="DECODED_UNSUPP_MSG_TYPE"
	mtp3_error[11281]="DECODED_SYNTAX_ERROR"
	mtp3_error[11282]="DECODED_INVALID_STREAM_ID"
	mtp3_error[11283]="ASSOC_NOT_FOUND"
	mtp3_error[11284]="BAD_SAID"
	mtp3_error[11285]="BAD_SCTP_ORIGIN"
	mtp3_error[11286]="TABLE_NOT_FOUND"
	mtp3_error[11287]="ILLEGAL_NUMBER_OF_TABLES"
	mtp3_error[11288]="ILLEGAL_TABLE_ID"
	mtp3_error[11289]="ILLEGAL_ITU_VERSION"
	mtp3_error[11290]="ILLEGAL_MAX_ATTEMPTS"
	mtp3_error[11291]="RCVD_UNEXPECTED_MSG"
	mtp3_error[11292]="NO_SHUTDOWN_CONF_RCVD"
	mtp3_error[11293]="WRONG_BEARER_TYPE"
	mtp3_error[11294]="ASSOC_NOT_ACTIVE"
	mtp3_error[11295]="CURR_ROUTE_PTR_NULL"
	mtp3_error[11296]="NODEID_ERROR"
	mtp3_error[11297]="INTERFACE_VERSION_ERROR"
	mtp3_error[11298]="ASSOC_NO_CFG"
	mtp3_error[11299]="BAD_SCTP_INSTANCE"
	mtp3_error[11300]="ASSOC_CLOSE_PENDING"
	mtp3_error[11301]="SCTP_SHUTDOWN_ERROR"
	mtp3_error[11302]="INVALID_ASSOC_ID"
	mtp3_error[11303]="UNCONFIGURED_ADJACENT"
	mtp3_error[11304]="SCTP_STOP_SEND_ERROR"
	mtp3_error[11305]="SCTP_RESUME_SEND_ERROR"
	mtp3_error[11306]="BAD_SLS"
	mtp3_error[11307]="RCVD_SCTP_COMMLOST"
	mtp3_error[11308]="RCVD_M3UA_ERROR"
	mtp3_error[11309]="SENT_M3UA_ERROR"
	mtp3_error[11310]="RECONFIGURATION_NOT_ALLOWED"
	mtp3_error[11311]="SCTP_STOP_SEND_RECEIVED"
	mtp3_error[11312]="SCTP_RESUME_SEND_RECEIVED"
	mtp3_error[11313]="ASSOCIATION_STOPED_BY_SCTP"
	mtp3_error[11314]="BAD_NUMBER_OF_NODES"
	mtp3_error[11315]="ILLEGAL_LINK_DELETE"
	mtp3_error[11316]="ILLEGAL_ASSOC_DELETE"
	mtp3_error[11317]="MSG_DISCARDED"
	mtp3_error[11318]="WOULD_LOSE_ROUTESET"
	mtp3_error[11319]="DL_CONGESTED_IND_FORMAT_ERROR"
	mtp3_error[11320]="DUPLICATE_OPC_NOT_SUPPORTED"
	mtp3_error[11321]="IPLIST_NOT_FOUND"
	mtp3_error[11322]="INVALID_SCTP_INTIALIZE_CONF_IP_LIST_RECEIVED"
	mtp3_error[11323]="INVALID_SCTP_INITLIZE_CONF_RECEIVED"
	mtp3_error[11324]="COMM_LOST_SEND_NEW_ASSOCIATE"

	for (i in mtp3_error) lmid_code_list[sprintf("MTP3 Error: %10s = %s",i,mtp3_error[i])]=sprintf("MTP3 Error: %10s = %s",i,mtp3_error[i])

	#SCCP CODES
	sccp_state[0]="PS0_WAITMBC"
	sccp_state[1]="S1_IDLE"
	sccp_state[2]="S2_CONNPEND_OG"
	sccp_state[3]="S3_CONNPEND_IC"
	sccp_state[4]="S4_WAITCC"
	sccp_state[5]="S5_DATA"
	sccp_state[6]="S6_DISCPEND"

	for (i in sccp_state) lmid_code_list[sprintf("SCCP STATE: %10s = %s",i,sccp_state[i])]=sprintf("SCCP STATE: %10s = %s",i,sccp_state[i])

	sccp_event[18]="EVENT_TYPE_CR"
	sccp_event[19]="EVENT_TYPE_CC"
	sccp_event[20]="EVENT_TYPE_CREF"
	sccp_event[21]="EVENT_TYPE_RLSD"
	sccp_event[22]="EVENT_TYPE_RLC"
	sccp_event[23]="EVENT_TYPE_DT1"
	sccp_event[32]="EVENT_TYPE_ERR"
	sccp_event[33]="EVENT_TYPE_IT"
	sccp_event[26]="EVENT_TYPE_UDT"
	sccp_event[27]="EVENT_TYPE_UDTS"
	sccp_event[28]="EVENT_TYPE_XUDT"
	sccp_event[29]="EVENT_TYPE_XUDTS"
	sccp_event[30]="EVENT_TYPE_LUDT"
	sccp_event[31]="EVENT_TYPE_LUDTS"

	for (i in sccp_event) lmid_code_list[sprintf("SCCP Event: %10s = %s",i,sccp_event[i])]=sprintf("SCCP Event: %10s = %s",i,sccp_event[i])

	sccp_error[12001]="ERROR_INTERNAL_SCCP"
	sccp_error[12013]="ERROR_UNKNOWN_EVENT"
	sccp_error[12014]="ERROR_TOO_MANY_CONN"
	sccp_error[12015]="ERROR_UNKNOWN_TIMER"
	sccp_error[12021]="ERROR_IN_MEMCPY"
	sccp_error[12023]="ERROR_IN_MSG_SEND_NO_WAIT"
	sccp_error[12024]="ERROR_IN_SCCP_ERROR"
	sccp_error[12025]="ERROR_IN_SCCP_MSG_SEND"
	sccp_error[12026]="ERROR_IN_XFREE"
	sccp_error[12027]="ERROR_IN_XMALLOC"
	sccp_error[12028]="ERROR_IN_XMEM_INIT"
	sccp_error[12040]="ERROR_CONN_ID_NOT_NULL"
	sccp_error[12041]="ERROR_INVALID_CONN_ID"
	sccp_error[12042]="ERROR_REASON_NOT_NULL"
	sccp_error[12043]="ERROR_INVALID_REASON"
	sccp_error[12044]="ERROR_ORIGINATOR_NOT_NULL"
	sccp_error[12045]="ERROR_INVALID_ORIGINATOR"
	sccp_error[12046]="ERROR_SEQ_CTRL_NOT_NULL"
	sccp_error[12047]="ERROR_INVALID_SEQ_CTRL"
	sccp_error[12048]="ERROR_RET_OPTION_NOT_NULL"
	sccp_error[12049]="ERROR_INVALID_RET_OPTION"
	sccp_error[12050]="ERROR_REASON_FOR_RET_NOT_NULL"
	sccp_error[12051]="ERROR_INVALID_REASON_FOR_RET"
	sccp_error[12052]="ERROR_INVALID_OPTIONS"
	sccp_error[12053]="ERROR_INVALID_RETURN_CAUSE"
	sccp_error[12054]="ERROR_INVALID_REFUSAL_CAUSE"
	sccp_error[12055]="ERROR_INVALID_RELEASE_CAUSE"
	sccp_error[12056]="ERROR_INVALID_SEGM_REASS"
	sccp_error[12057]="ERROR_INVALID_PROT_CLASS"
	sccp_error[12058]="ERROR_UNASS_SOURCE_LRN"
	sccp_error[12059]="ERROR_INVALID_ERR_CAUSE"
	sccp_error[12070]="ERROR_INVALID_MSG_LEN"
	sccp_error[12072]="ERROR_INVALID_N_UNITD_REQ_LEN"
	sccp_error[12073]="ERROR_INVALID_UDT_LEN"
	sccp_error[12074]="ERROR_INVALID_UDTS_LEN"
	sccp_error[12075]="ERROR_INVALID_SCMG_LEN"
	sccp_error[12076]="ERROR_INVALID_N_CONN_REQ_LEN"
	sccp_error[12077]="ERROR_INVALID_N_CONN_RESP_LEN"
	sccp_error[12078]="ERROR_INVALID_N_DISC_REQ_LEN"
	sccp_error[12079]="ERROR_INVALID_N_DATA_REQ_LEN"
	sccp_error[12080]="ERROR_INVALID_CR_LEN"
	sccp_error[12081]="ERROR_INVALID_CC_LEN"
	sccp_error[12082]="ERROR_INVALID_CREF_LEN"
	sccp_error[12083]="ERROR_INVALID_RLSD_LEN"
	sccp_error[12084]="ERROR_INVALID_RLC_LEN"
	sccp_error[12085]="ERROR_INVALID_DT1_LEN"
	sccp_error[12086]="ERROR_INVALID_IT_LEN"
	sccp_error[12087]="ERROR_INVALID_MTP_BIND_CONF_LEN"
	sccp_error[12088]="ERROR_INVALID_MTP_PAUSE_IND_LEN"
	sccp_error[12089]="UNKNOWN_DPC"
	sccp_error[12090]="ERROR_INVALID_MTP_RESUME_LEN"
	sccp_error[12091]="ERROR_INVALID_MTP_STATUS_LEN"
	sccp_error[12092]="ERROR_MTP_STATUS_OWN_SP"
	sccp_error[12093]="ERROR_INVALID_ALARM_LEN"
	sccp_error[12094]="ERROR_INVALID_ERR_LEN"
	sccp_error[12095]="ERROR_SIZE_LEN_INCOMP"
	sccp_error[12099]="ERROR_INVALID_SIO"
	sccp_error[12100]="ERROR_INVALID_CALLED_ADDR"
	sccp_error[12101]="ERROR_INVALID_CALLING_ADDR"
	sccp_error[12102]="ERROR_INVALID_ADDR_LEN"
	sccp_error[12103]="ERROR_INVALID_USER_DATA"
	sccp_error[12104]="ERROR_INVALID_PARAM_NAME"
	sccp_error[12105]="ERROR_INVALID_PARAM_PTR_1"
	sccp_error[12106]="ERROR_INVALID_PARAM_PTR_2"
	sccp_error[12107]="ERROR_INVALID_PARAM_PTR_3"
	sccp_error[12108]="ERROR_INVALID_RESP_ADDR"
	sccp_error[12109]="LSS_UNBOUND"
	sccp_error[12110]="ERROR_ROUTING_FAILURE"
	sccp_error[12111]="ERROR_GT_MISSING"
	sccp_error[12112]="ERROR_SSN_MISSING"
	sccp_error[12113]="ERROR_ROUTING_FAILURE_1"
	sccp_error[12114]="ERROR_ROUTING_FAILURE_2"
	sccp_error[12115]="ERROR_ROUTING_FAILURE_3"
	sccp_error[12116]="ERROR_INVALID_SCMG_FORMAT_ID"
	sccp_error[12117]="ERROR_UNKNOWN_SPC"
	sccp_error[12118]="ERROR_SST_OWN_SP"
	sccp_error[12119]="ERROR_SS_CONG"
	sccp_error[12120]="ERROR_INVALID_SCM_SMI"
	sccp_error[12121]="ERROR_INVALID_SSN"
	sccp_error[12122]="ERROR_INVALID_LOCAL_SPC"
	sccp_error[12130]="ERROR_NO_TRANS_NATURE"
	sccp_error[12136]="ERROR_UNEQUIPPED_USER"
	sccp_error[12200]="ERROR_DISCARD_MSG_0"
	sccp_error[12201]="ERROR_DISCARD_MSG_1"
	sccp_error[12210]="ERROR_M70"
	sccp_error[12211]="ERROR_M71"
	sccp_error[12212]="ERROR_M72"
	sccp_error[12213]="ERROR_M73"
	sccp_error[12214]="ERROR_M74"
	sccp_error[12215]="ERROR_M75"
	sccp_error[12216]="ERROR_M76"
	sccp_error[12217]="ERROR_M77"
	sccp_error[12218]="ERROR_M82"
	sccp_error[12219]="ERROR_M83"
	sccp_error[12220]="ERROR_M87"
	sccp_error[12249]="ERROR_USER_ALREADY_BOUND"
	sccp_error[12250]="ERROR_USER_UNBOUND"
	sccp_error[12251]="ERROR_NOT_ENOUGH_TIMERS"
	sccp_error[12252]="ERROR_SSN_UNBOUND"
	sccp_error[12253]="BIND_TIMER_EXP"
	sccp_error[12254]="ERROR_MTP_BIND_FAILED"
	sccp_error[12255]="ERROR_INVALID_PRI"
	sccp_error[12256]="ERROR_PRI_NOT_NULL"
	sccp_error[12300]="CONFIGFILE_NOT_FOUND"
	sccp_error[12301]="OTHER_ERROR"
	sccp_error[12302]="BAD_SWAP_OPTION"
	sccp_error[12303]="BAD_SCOC_TIMER_NO - not used"
	sccp_error[12304]="BAD_SCMG_TIMER_NO - not used"
	sccp_error[12305]="BAD_TOTAL_TIMER_NO - not used"
	sccp_error[12306]="BAD_TIMEOUT_VALUES"
	sccp_error[12307]="BAD_SIO"
	sccp_error[12308]="BAD_SPC"
	sccp_error[12309]="BAD_N1"
	sccp_error[12310]="BAD_SEC1"
	sccp_error[12311]="COULD_NOT_READ_LINE"
	sccp_error[12312]="BAD_N2"
	sccp_error[12313]="BAD_SEC2"
	sccp_error[12314]="BAD_N3"
	sccp_error[12315]="BAD_SEC3"
	sccp_error[12316]="UNKNOWN_ADDR_ITEM"
	sccp_error[12317]="OFFSET_OPERATION_FAILED"
	sccp_error[12318]="BAD_PRI_VALUES"
	sccp_error[12319]="NO_MULTIPLE_LOCAL_SPC_SUPPORT"
	sccp_error[12320]="BAD_LOCAL_SPC"
	sccp_error[12321]="BAD_NO_OF_LOCAL_SPCS"
	sccp_error[12322]="BAD_GT"
	sccp_error[12323]="WRONG_VERSION"
	sccp_error[12324]="N1_BADLY_SORTED"
	sccp_error[12325]="BAD_S1"
	sccp_error[12326]="BAD_SSN_IN_S1"
	sccp_error[12327]="BAD_SSN_IN_S2"
	sccp_error[12328]="BAD_SSN_IN_S3"
	sccp_error[12329]="BAD_SSN_IN_S4"
	sccp_error[12330]="BAD_SSN_IN_SX"
	sccp_error[12331]="BAD_SX"
	sccp_error[12332]="BAD_S2"
	sccp_error[12333]="BAD_S3"
	sccp_error[12334]="BAD_S4"
	sccp_error[12335]="BAD_ADR_HANDLING_IN_S3"
	sccp_error[12336]="BAD_N4"
	sccp_error[12337]="BAD_SCCP_SCMG"
	sccp_error[12338]="BAD_OUT_SMI"
	sccp_error[12339]="BAD_SSN_IN_S5"
	sccp_error[12340]="BAD_S5"
	sccp_error[12341]="BAD_S4_S5_OPTIONS"
	sccp_error[12342]="BAD_S5_OPTIONS"
	sccp_error[12350]="SPC_UNAVAILABLE"
	sccp_error[12351]="SSN_UNAVAILABLE"
	sccp_error[12352]="SPC_CONGESTION"
	sccp_error[12400]="CHANGE_STATE"
	sccp_error[12401]="ERROR_USER_PROT_ERR"
	sccp_error[12402]="ERROR_INV_GTI_IN_CONFIG"
	sccp_error[12403]="ERROR_BAD_COMMA_SEP"
	sccp_error[12404]="ERROR_INV_CHRCTR_IN_GT"
	sccp_error[12405]="ERROR_TOO_MANY_DIGITS"
	sccp_error[12406]="ERROR_TOO_MANY_DIGITS_IN_GTI"
	sccp_error[12407]="ERROR_BAD_GTI"
	sccp_error[12408]="ERROR_GTI_NOT_SUPPORTED"
	sccp_error[12409]="ERROR_TOO_MANY_DIGITS_IN_TT"
	sccp_error[12410]="ERROR_BAD_TT"
	sccp_error[12411]="ERROR_TOO_MANY_DIGITS_IN_NP"
	sccp_error[12412]="ERROR_BAD_NP"
	sccp_error[12413]="ERROR_TOO_MANY_DIGITS_IN_NATOA"
	sccp_error[12414]="ERROR_BAD_NATOA"
	sccp_error[12415]="ERROR_BAD_NS_CHRCTR"
	sccp_error[12416]="ERROR_TOO_LONG_NS"
	sccp_error[12417]="ERROR_WCSTAR_MISPLACED"
	sccp_error[12418]="ERROR_WCQMARK_MISPLACED"
	sccp_error[12419]="ERROR_ST_IN_GT_MISPLACED"
	sccp_error[12420]="T_STAT_INFO_TIMEOUT"
	sccp_error[12421]="ERROR_INVALID_SSP_LEN"
	sccp_error[12422]="ERROR_INVALID_SSA_LEN"
	sccp_error[12423]="ERROR_INVALID_SST_LEN"
	sccp_error[12424]="ERROR_INTERNAL_SCMG_PROBLEM"
	sccp_error[12426]="ERROR_INVALID_XUDT_LEN"
	sccp_error[12427]="ERROR_INVALID_XUDTS_LEN"
	sccp_error[12428]="ERROR_SCLC_SEGM_MSG_TOO_LONG"
	sccp_error[12429]="ERROR_SCLC_SEGM_MEMORY_UNAVAILABLE"
	sccp_error[12430]="ERROR_SCLC_SEGM_DUPLICATE_MSG"
	sccp_error[12431]="ERROR_SCLC_SEGM_OUT_OF_SEQUENCE"
	sccp_error[12432]="ERROR_SCLC_SEGM_INVALID_MSG_TYPE"
	sccp_error[12433]="ERROR_SCLC_SEGM_INVALID_REFERENCE"
	sccp_error[12434]="BAD_HOP_COUNTER"
	sccp_error[12435]="BAD_SCLC_SEGM_MAX_LEN - not used"
	sccp_error[12436]="BAD_SCLC_SEGM_MAX_PAR_PROC - not used"
	sccp_error[12437]="BAD_MSG_PRIO"
	sccp_error[12438]="T_REASS_TIMEOUT"
	sccp_error[12439]="ERROR_IN_FREE_TEMP_CONF"
	sccp_error[12440]="ERROR_INVALID_SSN_SPC"
	sccp_error[12441]="ERROR_INVALID_SPC"
	sccp_error[12442]="ERROR_2ND_REASS_MEM_USED"
	sccp_error[12443]="ERROR_MSG_PRIO_NOT_NULL"
	sccp_error[12444]="ERROR_INVALID_MSG_PRIO"
	sccp_error[12445]="ERROR_HOP_COUNTER_USED_NOT_NULL"
	sccp_error[12446]="ERROR_TOO_LONG_MSG_FROM_USER"
	sccp_error[12447]="ERROR_INVALID_PARAM_PTR_4"
	sccp_error[12448]="ERROR_INVALID_OPT_PARAM"
	sccp_error[12449]="ERROR_INVALID_HOP_COUNT_USED"
	sccp_error[12450]="ERROR_BAD_MSB_OPTION"
	sccp_error[12351]="HOP_COUNTER"
	sccp_error[12352]="BAD_PRI"
	sccp_error[12353]="BAD_NI"
	sccp_error[12354]="BAD_HOP_COUNTER_SCLC"
	sccp_error[12355]="BAD_HOP_COUNTER_SCOC"
	sccp_error[12456]="BAD_NO_OF_LOCAL_SSNS"
	sccp_error[12457]="BAD_LOCAL_SSN"
	sccp_error[12458]="BAD_NUMBER_OF_CONN"
	sccp_error[12459]="ERROR_INVALID_IMPORTANCE"
	sccp_error[12460]="ERROR_INVALID_LUDT_LEN"
	sccp_error[12461]="BOUND_SSN_NOT_INCLUDED"
	sccp_error[12462]="T_GUARD_ACTIVE"
	sccp_error[12463]="BAD_CON_HWM"
	sccp_error[12464]="BAD_CON_LWM"
	sccp_error[12465]="ERROR_INVALID_SSC_LEN"
	sccp_error[12466]="INVALID_NETWORK_CAUSE"
	sccp_error[12467]="ERROR_UNKNOWN_REMOTE_DPC"
	sccp_error[12468]="ERROR_INVALID_NM_SSNAVAILABLE_IND_LEN"
	sccp_error[12469]="ERROR_INVALID_NM_SSNUNAVAILABLE_IND_LEN"
	sccp_error[12470]="ERROR_INVALID_NM_SSNCONGESTED_IND_LEN"
	sccp_error[12471]="ERROR_INVALID_SCCP_MODULE"
	sccp_error[12472]="ERROR_INVALID_LOWER_LAYER_ID"
	sccp_error[12473]="ERROR_SEC_ROUTE_MISSING"
	sccp_error[12474]="ERROR_INVALID_ISNI"
	sccp_error[12475]="ERROR_SEGM_NEEDED_IN_LUDT"

	for (i in sccp_error) lmid_code_list[sprintf("SCCP Error: %10s = %s",i,sccp_error[i])]=sprintf("SCCP Error: %10s = %s",i,sccp_error[i])

	#to generate the table below from the cause codes defined in 25.413 chapter 9.2.1.4.
	#[~]$ gawk '/[0-9]/{line=gensub(/(\([0-9]+\))/,":=" "\\1",1,$0);split(line,array,":=");print "IU_IF_code["gensub(/[^0-9]/,"","g",array[2])"]=\""array[1]"\""}' testlogs/iuif.txt
	IU_IF_code[1]="RAB pre-empted"
	IU_IF_code[2]="Trelocoverall Expiry"
	IU_IF_code[3]="Trelocprep Expiry"
	IU_IF_code[4]="Treloccomplete Expiry"
	IU_IF_code[5]="Tqueuing Expiry"
	IU_IF_code[6]="Relocation Triggered"
	IU_IF_code[8]="Unable to Establish During Relocation"
	IU_IF_code[9]="Unknown Target RNC"
	IU_IF_code[10]="Relocation Cancelled"
	IU_IF_code[11]="Successful Relocation"
	IU_IF_code[12]="Requested Ciphering and/or Integrity Protection Algorithms not Supported"
	IU_IF_code[13]="Conflict with already existing Integrity protection and/or Ciphering information "
	IU_IF_code[14]="Failure in the Radio Interface Procedure"
	IU_IF_code[15]="Release due to UTRAN Generated Reason"
	IU_IF_code[16]="User Inactivity"
	IU_IF_code[17]="Time Critical Relocation"
	IU_IF_code[18]="Requested Traffic Class not Available"
	IU_IF_code[19]="Invalid RAB Parameters Value"
	IU_IF_code[20]="Requested Maximum Bit Rate not Available"
	IU_IF_code[33]="Requested Maximum Bit Rate for DL not Available"
	IU_IF_code[34]="Requested Maximum Bit Rate for UL not Available"
	IU_IF_code[21]="Requested Guaranteed Bit Rate not Available"
	IU_IF_code[35]="Requested Guaranteed Bit Rate for DL not Available"
	IU_IF_code[36]="Requested Guaranteed Bit Rate for UL not Available"
	IU_IF_code[22]="Requested Transfer Delay not Achievable"
	IU_IF_code[23]="Invalid RAB Parameters Combination"
	IU_IF_code[24]="Condition Violation for SDU Parameters"
	IU_IF_code[25]="Condition Violation for Traffic Handling Priority"
	IU_IF_code[26]="Condition Violation for Guaranteed Bit Rate"
	IU_IF_code[27]="User Plane Versions not Supported"
	IU_IF_code[28]="Iu UP Failure"
	IU_IF_code[7]="TRELOCalloc Expiry "
	IU_IF_code[29]="Relocation Failure in Target CN/RNC or Target System "
	IU_IF_code[30]="Invalid RAB ID"
	IU_IF_code[31]="No remaining RAB"
	IU_IF_code[32]="Interaction with other procedure"
	IU_IF_code[37]="Repeated Integrity Checking Failure"
	IU_IF_code[38]="Requested Request Type not supported"
	IU_IF_code[39]="Request superseded"
	IU_IF_code[40]="Release due to UE generated signalling connection release"
	IU_IF_code[41]="Resource Optimisation Relocation"
	IU_IF_code[42]="Requested Information Not Available"
	IU_IF_code[43]="Relocation desirable for radio reasons "
	IU_IF_code[44]="Relocation not supported in Target RNC or Target system"
	IU_IF_code[45]="Directed Retry "
	IU_IF_code[46]="Radio Connection With UE Lost"
	IU_IF_code[47]="RNC unable to establish all RFCs  "
	IU_IF_code[48]="Deciphering Keys Not Available"
	IU_IF_code[49]="Dedicated Assistance data Not Available"
	IU_IF_code[50]="Relocation Target not allowed"
	IU_IF_code[51]="Location Reporting Congestion"
	IU_IF_code[52]="Reduce Load in Serving Cell "
	IU_IF_code[53]="No Radio Resources Available in Target cell "
	IU_IF_code[54]="GERAN Iu-mode failure "
	IU_IF_code[55]="Access Restricted Due to Shared Networks"
	IU_IF_code[56]="Incoming Relocation Not Supported Due To PUESBINE Feature"
	IU_IF_code[57]="Traffic Load In The Target Cell Higher Than In The Source Cell"
	IU_IF_code[58]="MBMS - No Multicast Service For This UE"
	IU_IF_code[59]="MBMS - Unknown UE ID"
	IU_IF_code[60]="Successful MBMS Session Start - No Data Bearer Necessary"
	IU_IF_code[61]="MBMS - Superseded Due To NNSF"
	IU_IF_code[62]="MBMS - UE Linking Already Done"
	IU_IF_code[63]="MBMS - UE De-Linking Failure - No Existing UE Linking"
	IU_IF_code[64]="TMGI Unknown"
	IU_IF_code[65]="Signalling Transport Resource Failure"
	IU_IF_code[66]="Iu Transport Connection Failed to Establish"
	IU_IF_code[81]="User Restriction Start Indication"
	IU_IF_code[82]="User Restriction End Indication"
	IU_IF_code[83]="Normal Release"
	IU_IF_code[97]="Transfer Syntax Error"
	IU_IF_code[98]="Semantic Error "
	IU_IF_code[99]="Message not compatible with receiver state "
	IU_IF_code[100]="Abstract Syntax Error (Reject) "
	IU_IF_code[101]="Abstract Syntax Error (Ignore and Notify) "
	IU_IF_code[102]="Abstract Syntax Error (Falsely Constructed Message) "
	IU_IF_code[113]="O&M Intervention"
	IU_IF_code[114]="No Resource Available"
	IU_IF_code[115]="Unspecified Failure"
	IU_IF_code[116]="Network Optimisation"
	IU_IF_code[257]="IP Multicast Address NO_ERROR And APN Not Valid"
	IU_IF_code[258]="MBMS De-Registration Rejected Due To Implicit Registration"
	IU_IF_code[259]="MBMS - Request Superseded"
	IU_IF_code[260]="MBMS De-Registration During Session Not Allowed"
	IU_IF_code[261]="MBMS - No Data Bearer Necessary"

	for (i in IU_IF_code) lmid_code_list[sprintf("IU_IF cause: %10s = %s",i,IU_IF_code[i])]=sprintf("IU_IF cause: %10s = %s",i,IU_IF_code[i])

	#always last:
	max_lmid_code=asort(lmid_code_list)
}

function buildHwidTable(force,   rbshwfile,line,array)
{
        # check the hwid "database" if we haven't parsed it yet
	if (gotHwiddb==1 && force!="force") return
	delete hwid2Table
	gotHwiddb = 1;
	parse_rbshw_file(commonjardir"/pm/HW_PRBS.csv",2,1)
	parse_rbshw_file(commonjardir"/pm/HW_RBS1.csv",1,2)
	parse_rbshw_file(commonjardir"/pm/HW_RBS2.csv",1,2,3)
	parse_rbshw_file(commonjardir"/pm/HW_RBS7.csv",1,2)
}
function parse_rbshw_file(rbshwfile,pname,pnr,ptype,    array,line,a,tpn,tpr)
{
	#print "\n\n"rbshwfile
	if (fileOps("test -s "rbshwfile) != 0) { customPrint("ERROR: file "rbshwfile" not found.") ; return }
       	while (getline line < rbshwfile)
       	{
       		if (line ~ /^[ \t]*#/) continue
       		gsub("\r","",line)
       		split(line,array,";")
       		gsub(/[ \t\xa0]/,"",array[pname])
       		gsub(/[ \t\xa0]/,"",array[pnr])
       		sub(/,.*$/,"",array[pnr]) #AIR 32 B4A/B2P;KRC 118 050/1, KRD 901 044/1
       		if (array[pnr] !~ /^(KR|KDU)|^[1-9]\/KR|^ROA1287145/) continue
       		if (array[pname]~/^Air/) sub(/Air/,"AIR",array[pname])
       		if (array[pname]!~/^AIR/) { if (match(array[pname],/B[0-9]+([a-z])$/,a)>0) sub(sprintf("%s$",a[1]),toupper(a[1]),array[pname]) }
       		sub(/(ODM$|8LOBE|2.5G8TX|2x40W$|\/TK$)/,"",array[pname])
       		#workaround for mRRU should be called RRUS12m
       		if (array[pname]~/^mRRUS61/) {} #leave the mRRUS61 as it is  #sub(/^mRRUS61/,"RRUS61m",array[pname])
       		else sub(/^mRRU/,"RRUS12m",array[pname])
       		if (ptype!="") sub(/Radio/,array[ptype],array[pname])
       		if (array[pnr] ~ /^KRC161444\/[12]$/) array[pname]="IRU2242"
       		#print array[pnr],array[pname]
       		if (array[pnr] in hwidLookupTable && hwidLookupTable[array[pnr]]!="") continue
		hwidTable[sprintf("%-14s %s",array[pnr],array[pname])]=1
		hwidLookupTable[array[pnr]]=array[pname]
		tpn=array[pname]
		if (tpn ~ /^(AIR|RRU|IRU|BB|RP|RANP)[0-9][0-9][0-9][0-9]|^RGR/)
		{
			tpn=substr(tpn,1,(tpn~/^RANP/?8:7))
			tpr=gensub(/\/.*/,"/*",1,array[pnr])
			hwid2Table[tpn]=hwid2Table[tpn]","array[pnr]
			hwid2Table[tpr]=hwid2Table[tpr]","array[pnr]
			hwid2Table[array[pnr]]=array[pnr]
			sub(/^,/,"",hwid2Table[tpn])
			sub(/^,/,"",hwid2Table[tpr])
		}
       	}
       	close(rbshwfile)
}
function translate_hw(prodnr,prodname,what,prodname2,   result,tt)
{
	buildHwidTable()
	sub(/x$/,"",prodname) #CTX simulated radios
	result=prodname
	#if (prodname ~ /^AIR/) return prodname  #keep original product on AIR
	if (prodnr in hwidLookupTable && hwidLookupTable[prodnr]!="") result=hwidLookupTable[prodnr]
	#print "translate_hw: "prodnr,prodname,prodname2,what,result
	if (what=="replace" && result!~/^AIR/) return result
	if (tolower(prodname2) ~ /radio/) return " ("prodname2")"
	if (result==prodname) return ""
	else if (tolower(prodname) ~ /baseband|radio|processor|streetmacro/) return " ("prodname")"
	else if (result~/^XMU03/ && prodname~/^XMU03/)
	{
		#prodname XMU0301 -> translation XMU03(BasebandR503)
		#prodname XMU0318 -> translation XMU03(BasebandR518)
		if (comcli>0)
		{
			if (prodname ~ /^XMU0318/) return " (BbR518)"
			else return " (BbR503)"
		}
		return ""
	}
	else if (result~/^(DUS32|BB5212)/) { if (prodname~/^DUS32/)   return " (Bb5212)" }
	else if (result~/^(DUS52|BB5216)/) { if (prodname~/^DUS52/)   return " (Bb5216)" }
	else if (result~/^(DUS33|BB6620)/) { if (prodname~/^DUS33/)   return " (Bb6620)" }
	else if (result~/^(DUS53|BB6630)/) { if (prodname~/^DUS53/)   return " (Bb6630)" }
	else if (result~/^(ODS63|BB6303)/) { if (prodname~/^ODS6303/) return " (Bb6303)" }
	else if (result~/^(ODS65|BB6502)/) { if (prodname~/^ODS6502/) return " (Bb6502)" }
	else if (result~/^(ODS64|BB6318)/) return " (Bb6318)"
	else return " ("result")"
}
function translate_marketname(prodnr,prodname,   tp)
{
	if (tolower(prodname)~/^indoorair/) sub(/^....../,"",prodname)
	if (tolower(prodname)!~/baseband|radio|processor|streetmacro/) return prodname
	buildHwidTable()
	if (prodnr in hwidLookupTable && hwidLookupTable[prodnr]!="")
	{
		if (hwidLookupTable[prodnr]=="PIMCU") return "BBP614"
		return hwidLookupTable[prodnr]
	}
	tp=tolower(prodname)
	     if (tp~/^basebandt5/)     return "TCU03"
	else if (tp~/^basebandt6/)     return "TCU04"
	else if (tp~/^basebandt/)      return "TCU"
	else if (tp~/^radiogateway/)   return gensub(/^............/,"RG",1,prodname)
	else if (tp~/^radioprocessor/) return gensub(/^............../,"RP",1,prodname)
	else if (tp~/^radio/)          return gensub(/^...../,"RRU",1,prodname)
	else if (tp~/^basebandr503/)   return "XMU0301"
	else if (tp~/^basebandr518/)   return "XMU0318"
	else if (tp~/^basebandr567/)   return "XMU0367"
	else if (tp~/^baseband/)       
	{
		if      (use_market_name==0 && tp~/^baseband5212/) return "DUS3201"
		else if (use_market_name==0 && tp~/^baseband5216/) return "DUS5201"
		else if (use_market_name==0 && tp~/^baseband6620/) return "DUS3301"
		else if (use_market_name==0 && tp~/^baseband6630/) return "DUS5301"
		else if (use_market_name==0 && tp~/^baseband6303/) return "ODS6303"
		else if (use_market_name==0 && tp~/^baseband6502/) return "ODS6502"
		return gensub(/^......../,"BB",1,prodname)
	}
	else if (tp~/processor/)       return gensub(/rocessor/,"",1,prodname)  #RAN Processor 6651
	else if (tp~/^streetmacro/)    
	{
		tt=gensub(/^.........../,(use_market_name==0?"RBU":"SM"),1,prodname) #Streetmacro
		if (use_market_name==0 && tt~/^RBU6701/) tt="RBU6701"
		return tt
	}
	else return prodname
}
function parse_sfp_file(sfpfile,    array,i,line)
{
	if (fileOps("test -s "sfpfile) != 0) { customPrint("ERROR: file "sfpfile" not found.") ; return }
	delete SfpEricssonTable
	while (getline line < sfpfile)
	{
		gsub("\r","",line)
		split(line,array,";")
		for (i in array) gsub(/^[ \t]+|[ \t]+$/,"",array[i])
		if (array[1]~/^#/) continue
		#SfpEricssonTable[array[1]]=array[2]
		SfpEricssonTable[ecut(array[1])]=array[2]
	}
	close(sfpfile)
}
function ecut(s)
{
	return gensub(/ |-/,"","g",s)
}
function parse_wl_file(wlfile,    a)
{
	if (fileOps("test -s "wlfile)!=0)
	{
		customPrint("ERROR: SFP WL definition file "wlfile" not found.")
		return
	}
	delete SfpWLTable
	while ((getline < wlfile)>0)
	{
		#1400858-0012;1310 (1270-1360)
		#RDH102406/14 R1A;191.4 THz
		#RDH102415/27 R1A;1271 cwdm
		gsub("\r","")
		if ($1~ /^#/) continue
		split($0,a,";")
		sub(/ +\(.*$/,"",a[2])
		sub(/ cwdm.*$/,"",a[2])
		if (a[2]~/THz/)
		{
			sub(/ THz/,"",a[2])
			a[2]=sprintf("%.2f",299792458/a[2]/1000)
			#print a[2]
		}
		gsub(/[ \t]/,"",a[2])
		SfpWLTable[a[1]]=sprintf("%.2f",a[2]+0)
	}
	close(wlfile)
}
#this function builds the lmidTable array using "lmiddb"
function buildLmidTable(force,   i,l)
{
        # check the lmid "database" if we haven't parsed it yet
	if (gotLmiddb==1 && force!="force") return
	make_uptorel_table()
       	parse_lmid_file(lmiddb)
       	parse_uptomom_file(uptomomdb)
       	parse_updata_file(updatadb,cppdatadb,updatadb2)
       	parse_upid_file(upiddb)
       	parse_upid_file2(upiddb2)
       	if (fileOps("test -s "custom_upid_file)==0) parse_upid_file(custom_upid_file)
	gotLmiddb = 1;
	#for (i in lmidTable) print i
	#for (i in upidTable) print i
}
function make_uptorel_table(   line)
{
	#taken from https://wcdma-rbs-ntp.rnd.ki.sw.ericsson.se/
	uptorelTable["CXP9011610"]="P5"        ; line="RBS;P5 (J);CXP9011610"    ; formatted_uptorel[line]=line
	uptorelTable["CXP9012073"]="P6"        ; line="RBS;P6 (K);CXP9012073"    ; formatted_uptorel[line]=line
	uptorelTable["CXP9012959"]="P7"        ; line="RBS;P7 (L);CXP9012959"    ; formatted_uptorel[line]=line
	uptorelTable["CXP9014346"]="P7.1/W10"  ; line="RBS;P7.1/W10 (M);CXP9014346" ; formatted_uptorel[line]=line
	uptorelTable["CXP9016141"]="P7.1/W10"  ; line="RBS;P7.1/W10 (M);CXP9016141" ; formatted_uptorel[line]=line
	uptorelTable["CXP9016868"]="W10/W11"   ; line="RBS;W10/W11 (M);CXP9016868"  ; formatted_uptorel[line]=line
	uptorelTable["CXP9016865"]="W11GPBCBU" ; line="RBS;W11GPBCBU (N);CXP9016865" ; formatted_uptorel[line]=line  #classic
	uptorelTable["CXP9017021"]="W11DUW"    ; line="RBS;W11DUW (N);CXP9017021"    ; formatted_uptorel[line]=line  #duw
	uptorelTable["CXP9018436"]="W11C"      ; line="RBS;W11C (N);CXP9018436"      ; formatted_uptorel[line]=line  #duw msmm
	uptorelTable["CXP9018733"]="W12GPBCBU" ; line="RBS;W12GPBCBU (S);CXP9018733" ; formatted_uptorel[line]=line  #classic
	uptorelTable["CXP9018350"]="W12DUW"    ; line="RBS;W12DUW (S);CXP9018350"    ; formatted_uptorel[line]=line  #duw
	uptorelTable["CXP9021719"]="W13DUW"    ; line="RBS;W13DUW (T);CXP9021719"    ; formatted_uptorel[line]=line  #duw
	uptorelTable["CXP9023078"]="CLASSIC"   ; line="RBS;CLASSIC (S2);CXP9023078"  ; formatted_uptorel[line]=line  #classic
	uptorelTable["CXP9023291"]="RBS_MT"    ; line="RBS;RBS_MT (U);CXP9023291"    ; formatted_uptorel[line]=line  #duw
	uptorelTable["CXP9023291/1"]="W14A"    ; line="RBS;W14A (U);CXP9023291/1"    ; formatted_uptorel[line]=line  #duw
	uptorelTable["CXP9023291/2"]="W14B"    ; line="RBS;W14B (U);CXP9023291/2"    ; formatted_uptorel[line]=line  #duw
	uptorelTable["CXP9023291/3"]="W15A"    ; line="RBS;W15A (U);CXP9023291/3"    ; formatted_uptorel[line]=line  #duw
	uptorelTable["CXP9023291/4"]="W15B"    ; line="RBS;W15B (U);CXP9023291/4"    ; formatted_uptorel[line]=line  #duw
	uptorelTable["CXP9023291/5"]="W16A"    ; line="RBS;W16A (U);CXP9023291/5"    ; formatted_uptorel[line]=line  #duw
	uptorelTable["CXP9023291/6"]="W16B"    ; line="RBS;W16B (U);CXP9023291/6"    ; formatted_uptorel[line]=line  #duw
	uptorelTable["CXP9023291/7"]="W17A"    ; line="RBS;W17A (U);CXP9023291/7"    ; formatted_uptorel[line]=line  #duw
	uptorelTable["CXP9023291/8"]="W17Q2"   ; line="RBS;W17Q2 (U);CXP9023291/8"   ; formatted_uptorel[line]=line  #duw
	uptorelTable["CXP9023291/9"]="W17Q3"   ; line="RBS;W17Q3 (U);CXP9023291/9"   ; formatted_uptorel[line]=line  #duw
	uptorelTable["CXP9023291/10"]="W17Q4"  ; line="RBS;W17Q4 (U);CXP9023291/10"  ; formatted_uptorel[line]=line  #duw
	uptorelTable["CXP9023291/11"]="W18Q1"  ; line="RBS;W18Q1 (U);CXP9023291/11"  ; formatted_uptorel[line]=line  #duw
	uptorelTable["CXP9023291/12"]="W18Q2"  ; line="RBS;W18Q2 (U);CXP9023291/12"  ; formatted_uptorel[line]=line  #duw
	uptorelTable["CXP9023291/13"]="W18Q3"  ; line="RBS;W18Q3 (U);CXP9023291/13"  ; formatted_uptorel[line]=line  #duw
	uptorelTable["CXP9023291/14"]="W18Q4"  ; line="RBS;W18Q4 (U);CXP9023291/14"  ; formatted_uptorel[line]=line  #duw
	uptorelTable["CXP9023291/15"]="W19Q1"  ; line="RBS;W19Q1 (U);CXP9023291/15"  ; formatted_uptorel[line]=line  #duw
	uptorelTable["CXP9023291/16"]="W19Q2"  ; line="RBS;W19Q2 (U);CXP9023291/16"  ; formatted_uptorel[line]=line  #duw
	uptorelTable["CXP9023291/17"]="W19Q3"  ; line="RBS;W19Q3 (U);CXP9023291/17"  ; formatted_uptorel[line]=line  #duw
	uptorelTable["CXP9023291/18"]="W19Q4"  ; line="RBS;W19Q4 (U);CXP9023291/18"  ; formatted_uptorel[line]=line  #duw
	uptorelTable["CXP9023291/19"]="W20Q1"  ; line="RBS;W20Q1 (U);CXP9023291/19"  ; formatted_uptorel[line]=line  #duw
	uptorelTable["CXP9023291/20"]="W20Q2"  ; line="RBS;W20Q2 (U);CXP9023291/20"  ; formatted_uptorel[line]=line  #duw
	uptorelTable["CXP9023291/21"]="W20Q3"  ; line="RBS;W20Q3 (U);CXP9023291/21"  ; formatted_uptorel[line]=line  #duw
	uptorelTable["CXP9023291/22"]="W20Q4"  ; line="RBS;W20Q4 (U);CXP9023291/22"  ; formatted_uptorel[line]=line  #duw
	uptorelTable["CXP9023291/23"]="W21Q1"  ; line="RBS;W21Q1 (U);CXP9023291/23"  ; formatted_uptorel[line]=line  #duw
	uptorelTable["CXP9023291/24"]="W21Q2"  ; line="RBS;W21Q2 (U);CXP9023291/24"  ; formatted_uptorel[line]=line  #duw
	uptorelTable["CXP9023291/25"]="W21Q3"  ; line="RBS;W21Q3 (U);CXP9023291/25"  ; formatted_uptorel[line]=line  #duw
	uptorelTable["CXP9023291/26"]="W21Q4"  ; line="RBS;W21Q4 (U);CXP9023291/26"  ; formatted_uptorel[line]=line  #duw
	uptorelTable["CXP9023291/27"]="W22Q1"  ; line="RBS;W21Q1 (U);CXP9023291/27"  ; formatted_uptorel[line]=line  #duw
	uptorelTable["CXP9023291/28"]="W22Q2"  ; line="RBS;W21Q2 (U);CXP9023291/28"  ; formatted_uptorel[line]=line  #duw
	uptorelTable["CXP9023291/29"]="W22Q3"  ; line="RBS;W21Q3 (U);CXP9023291/29"  ; formatted_uptorel[line]=line  #duw
	uptorelTable["CXP9023291/30"]="W22Q4"  ; line="RBS;W21Q4 (U);CXP9023291/30"  ; formatted_uptorel[line]=line  #duw

	#taken from ftp://a.b.c.d/TCM/UP and https://rnc-ntp.rnd.ki.sw.ericsson.se/ntp/
	uptorelTable["CXP9012014"]="P5"          ; line="RNC;P5 (G);CXP9012014"    ; formatted_uptorel[line]=line
	uptorelTable["CXP9012123"]="P6.0"        ; line="RNC;P6.0 (H);CXP9012123"  ; formatted_uptorel[line]=line
	uptorelTable["CXP9012842"]="P6.1"        ; line="RNC;P6.1 (J);CXP9012842"  ; formatted_uptorel[line]=line
	uptorelTable["CXP9012995"]="P7.0"        ; line="RNC;P7.0 (K);CXP9012995"  ; formatted_uptorel[line]=line
	uptorelTable["CXP9013831"]="P7.1"        ; line="RNC;P7.1 (K);CXP9013831"  ; formatted_uptorel[line]=line
	uptorelTable["CXP9014711/1"]="W10A"      ; line="RNC;W10A (L);CXP9014711/1"; formatted_uptorel[line]=line
	uptorelTable["CXP9014711/2"]="W10B"      ; line="RNC;W10B (L);CXP9014711/2"; formatted_uptorel[line]=line
	uptorelTable["CXP9014711/3"]="W11A"      ; line="RNC;W11A (M);CXP9014711/3"; formatted_uptorel[line]=line
	uptorelTable["CXP9014711/4"]="W11B/12A"  ; line="RNC;W11B/12A (M);CXP9014711/4"; formatted_uptorel[line]=line
	uptorelTable["CXP9014711/5"]="W11BEVO"   ; line="RNC;W11BEVO (M);CXP9014711/5"; formatted_uptorel[line]=line   #Evo
	#uptorelTable["CXP9014711/6"]="W12A"     ; line="RNC;W12A (N);CXP9014711/6"; formatted_uptorel[line]=line  --> same track as W11B
	uptorelTable["CXP9014711/7"]="W12B"      ; line="RNC;W12B (N);CXP9014711/7"; formatted_uptorel[line]=line
	uptorelTable["CXP9021775"]="W13"         ; line="RNC;W13 (S/T);CXP9021775"   ; formatted_uptorel[line]=line   #R1 is W13A , R2/R71/R88 is W13B
	uptorelTable["CXP9021776"]="MAIN"        ; line="RNC;MAIN (T/U/V);CXP9021776"  ; formatted_uptorel[line]=line
	uptorelTable["CXP9021776/1"]="W14A"      ; line="RNC;W14A (V2);CXP9021776/1"   ; formatted_uptorel[line]=line
	uptorelTable["CXP9021776/2"]="W14B"      ; line="RNC;W14B (V3);CXP9021776/2"   ; formatted_uptorel[line]=line
	uptorelTable["CXP9021776/3"]="W15A"      ; line="RNC;W15A (V4);CXP9021776/3"   ; formatted_uptorel[line]=line
	uptorelTable["CXP9021776/4"]="W15B"      ; line="RNC;W15B (V5);CXP9021776/4"   ; formatted_uptorel[line]=line
	uptorelTable["CXP9021776/5"]="W16A"      ; line="RNC;W16A (V6);CXP9021776/5"   ; formatted_uptorel[line]=line
	uptorelTable["CXP9021776/6"]="W16B"      ; line="RNC;W16B (V7);CXP9021776/6"   ; formatted_uptorel[line]=line
	uptorelTable["CXP9021776/7"]="W17A"      ; line="RNC;W17A (V8);CXP9021776/7"   ; formatted_uptorel[line]=line
	uptorelTable["CXP9021776/8"]="W17Q2"     ; line="RNC;W17Q2 (V9);CXP9021776/8"  ; formatted_uptorel[line]=line
	uptorelTable["CXP9021776/9"]="W17Q3"     ; line="RNC;W17Q3 (V10);CXP9021776/9" ; formatted_uptorel[line]=line
	uptorelTable["CXP9021776/10"]="W17Q4"    ; line="RNC;W17Q4 (V11);CXP9021776/10"; formatted_uptorel[line]=line
	uptorelTable["CXP9021776/11"]="W18Q1"    ; line="RNC;W18Q1 (V12);CXP9021776/11"; formatted_uptorel[line]=line
	uptorelTable["CXP9021776/12"]="W18Q2"    ; line="RNC;W18Q2 (V13);CXP9021776/12"; formatted_uptorel[line]=line
	uptorelTable["CXP9021776/13"]="W18Q3"    ; line="RNC;W18Q3 (V14);CXP9021776/13"; formatted_uptorel[line]=line
	uptorelTable["CXP9021776/14"]="W18Q4"    ; line="RNC;W18Q4 (V15);CXP9021776/14"; formatted_uptorel[line]=line
	uptorelTable["CXP9021776/15"]="W19Q1"    ; line="RNC;W19Q1 (V16);CXP9021776/15"; formatted_uptorel[line]=line
	uptorelTable["CXP9021776/16"]="W19Q2"    ; line="RNC;W19Q2 (V17);CXP9021776/16"; formatted_uptorel[line]=line
	uptorelTable["CXP9021776/17"]="W19Q3"    ; line="RNC;W19Q3 (V18);CXP9021776/17"; formatted_uptorel[line]=line
	uptorelTable["CXP9021776/18"]="W19Q4"    ; line="RNC;W19Q4 (V19);CXP9021776/18"; formatted_uptorel[line]=line
	uptorelTable["CXP9021776/19"]="W20Q1"    ; line="RNC;W20Q1 (V20);CXP9021776/19"; formatted_uptorel[line]=line
	uptorelTable["CXP9021776/20"]="W20Q2"    ; line="RNC;W20Q2 (V21);CXP9021776/20"; formatted_uptorel[line]=line
	uptorelTable["CXP9021776/21"]="W20Q3"    ; line="RNC;W20Q3 (V22);CXP9021776/21"; formatted_uptorel[line]=line
	uptorelTable["CXP9021776/22"]="W20Q4"    ; line="RNC;W20Q4 (V23);CXP9021776/22"; formatted_uptorel[line]=line
	uptorelTable["CXP9021776/23"]="W21Q1"    ; line="RNC;W21Q1 (V24);CXP9021776/23"; formatted_uptorel[line]=line
	uptorelTable["CXP9021776/24"]="W21Q2"    ; line="RNC;W21Q2 (V25);CXP9021776/24"; formatted_uptorel[line]=line
	uptorelTable["CXP9021776/25"]="W21Q3"    ; line="RNC;W21Q3 (V26);CXP9021776/25"; formatted_uptorel[line]=line
	uptorelTable["CXP9021776/26"]="W21Q4"    ; line="RNC;W21Q4 (V27);CXP9021776/26"; formatted_uptorel[line]=line
	uptorelTable["CXP9021776/27"]="W22Q1"    ; line="RNC;W22Q1 (V28);CXP9021776/27"; formatted_uptorel[line]=line
	uptorelTable["CXP9021776/28"]="W22Q2"    ; line="RNC;W22Q2 (V29);CXP9021776/28"; formatted_uptorel[line]=line
	uptorelTable["CXP9021776/29"]="W22Q3"    ; line="RNC;W22Q3 (V30);CXP9021776/29"; formatted_uptorel[line]=line
	uptorelTable["CXP9021776/30"]="W22Q4"    ; line="RNC;W22Q4 (V31);CXP9021776/30"; formatted_uptorel[line]=line

	uptorelTable["CXP9012221"]="R4.2"      ; line="MGW;R4.2;CXP9012221"      ; formatted_uptorel[line]=line
	uptorelTable["CXP9012342"]="R5.0"      ; line="MGW;R5.0;CXP9012342"      ; formatted_uptorel[line]=line
	uptorelTable["CXP9012698"]="R5.1"      ; line="MGW;R5.1;CXP9012698"      ; formatted_uptorel[line]=line
	uptorelTable["CXP9013522"]="R6.0"      ; line="MGW;R6.0;CXP9013522"      ; formatted_uptorel[line]=line

	uptorelTable["12/CXP9010029"]="P5"     ; line="RXI;P5 (F);12/CXP9010029" ; formatted_uptorel[line]=line
	uptorelTable["13/CXP9010029"]="P6"     ; line="RXI;P6 (G);13/CXP9010029" ; formatted_uptorel[line]=line
	uptorelTable["CXP9014021"]="P7"        ; line="RXI;P7 (H);CXP9014021"    ; formatted_uptorel[line]=line
	uptorelTable["CXP9016282"]="W10"       ; line="RXI;W10 (H);CXP9016282"   ; formatted_uptorel[line]=line
	uptorelTable["CXP9017182"]="W11"       ; line="RXI;W11 (J);CXP9017182"   ; formatted_uptorel[line]=line
	uptorelTable["CXP9018325"]="W12"       ; line="RXI;W12 (J);CXP9018325"   ; formatted_uptorel[line]=line

	#uptorelTable["CXP102051"]="L10"          ; line="ERBS;L10  (A);CXP102051" ; formatted_uptorel[line]=line
	uptorelTable["CXP102051/1"]="L10B"       ; line="ERBS;L10B (A);CXP102051/1"  ; formatted_uptorel[line]=line
	uptorelTable["CXP102051/10"]="L11A"      ; line="ERBS;L11A (A);CXP102051/10" ; formatted_uptorel[line]=line
	uptorelTable["CXP102051/11"]="L11B"      ; line="ERBS;L11B (B);CXP102051/11" ; formatted_uptorel[line]=line
	uptorelTable["CXP102051/12"]="L11B"      ; line="ERBS;L11B (B);CXP102051/12" ; formatted_uptorel[line]=line
	uptorelTable["CXP102051/13"]="L12A"      ; line="ERBS;L12A (B);CXP102051/13" ; formatted_uptorel[line]=line
	uptorelTable["CXP102051/14"]="L12A"      ; line="ERBS;L12A (C);CXP102051/14" ; formatted_uptorel[line]=line
	uptorelTable["CXP102051/15"]="L12B"      ; line="ERBS;L12B (C);CXP102051/15" ; formatted_uptorel[line]=line
	uptorelTable["CXP102051/16"]="L12B"      ; line="ERBS;L12B (C);CXP102051/16" ; formatted_uptorel[line]=line
	uptorelTable["CXP102051/17"]="L13A"      ; line="ERBS;L13A (C);CXP102051/17" ; formatted_uptorel[line]=line
	uptorelTable["CXP102051/18"]="L13A"      ; line="ERBS;L13A (D);CXP102051/18" ; formatted_uptorel[line]=line
	uptorelTable["CXP102051/19"]="L13B"      ; line="ERBS;L13B (D);CXP102051/19" ; formatted_uptorel[line]=line
	uptorelTable["CXP102051/20"]="L13B"      ; line="ERBS;L13B (D);CXP102051/20" ; formatted_uptorel[line]=line
	uptorelTable["CXP102051/21"]="L14A"      ; line="ERBS;L14A (E);CXP102051/21" ; formatted_uptorel[line]=line
	uptorelTable["CXP102051/22"]="L14B"      ; line="ERBS;L14B (E);CXP102051/22" ; formatted_uptorel[line]=line
	#uptorelTable["CXP102051/23"]="L15A"      ; line="ERBS;L15A (F);CXP102051/23" ; formatted_uptorel[line]=line  #-> no L15A release /23 will be L15B
	uptorelTable["CXP102051/23"]="L15B"      ; line="ERBS;L15B (F);CXP102051/23" ; formatted_uptorel[line]=line
	uptorelTable["CXP102051/24"]="L16A"      ; line="ERBS;L16A (G);CXP102051/24" ; formatted_uptorel[line]=line
	uptorelTable["CXP102051/25"]="L16B"      ; line="ERBS;L16B (G);CXP102051/25" ; formatted_uptorel[line]=line
	uptorelTable["CXP102051/26"]="L17A"      ; line="ERBS;L17A (H);CXP102051/26" ; formatted_uptorel[line]=line
	#uptorelTable["CXP102051/27"]="L17B"      ; line="ERBS;L17B (H);CXP102051/27" ; formatted_uptorel[line]=line
	#Basic packages:
	uptorelTable["M/CXP102051/13"]="L12A"
	uptorelTable["M/CXP102051/14"]="L12A"
	uptorelTable["M/CXP102051/15"]="L12B"
	uptorelTable["M/CXP102051/16"]="L12B"
	uptorelTable["M/CXP102051/17"]="L13A"
	uptorelTable["M/CXP102051/18"]="L13A"
	uptorelTable["M/CXP102051/19"]="L13B"
	uptorelTable["M/CXP102051/20"]="L13B"
	uptorelTable["M/CXP102051/21"]="L14A"
	uptorelTable["M/CXP102051/22"]="L14B"
	#uptorelTable["M/CXP102051/23"]="L15A"
	uptorelTable["M/CXP102051/23"]="L15B"

	uptorelTable["CXP9012374/1"]="3GSIM"     ; line="3GSIM;3GSIM;CXP9012374/1" ; formatted_uptorel[line]=line
	uptorelTable["CXP9012374%1"]="3GSIM"     ; line="3GSIM;3GSIM;CXP9012374/1" ; formatted_uptorel[line]=line
	uptorelTable["CXP9012374/2"]="3GSIM"     ; line="3GSIM;3GSIM;CXP9012374/2" ; formatted_uptorel[line]=line
	uptorelTable["CXP9012374%2"]="3GSIM"     ; line="3GSIM;3GSIM;CXP9012374/2" ; formatted_uptorel[line]=line

	#TCU03/TCU04
	uptorelTable["CXP9024419/1"]="14B"      ; line="TCU;14B;CXP9024419/1" ; formatted_uptorel[line]=line
	uptorelTable["CXP9024419/2"]="15B"      ; line="TCU;15B;CXP9024419/2" ; formatted_uptorel[line]=line
	uptorelTable["CXP9024419/3"]="16A"      ; line="TCU;16A;CXP9024419/3" ; formatted_uptorel[line]=line
	uptorelTable["CXP9024419/4"]="16B"      ; line="TCU;16B;CXP9024419/4" ; formatted_uptorel[line]=line
	uptorelTable["CXP9024419/5"]="17A"      ; line="TCU;17A;CXP9024419/5" ; formatted_uptorel[line]=line
	uptorelTable["CXP9024419/6"]="17B"      ; line="TCU;17B;CXP9024419/6" ; formatted_uptorel[line]=line

	#MSRBS_V1 (pico)
	uptorelTable["CXP9026658/1"]="L15B"      ; line="LPRBS;L15B;CXP9026658/1" ; formatted_uptorel[line]=line
	uptorelTable["CXP9026658/2"]="L16A"      ; line="LPRBS;L16A;CXP9026658/2" ; formatted_uptorel[line]=line
	uptorelTable["CXP9027025/1"]="W16A"      ; line="WPRBS;W16A;CXP9027025/1" ; formatted_uptorel[line]=line

	#MSRBS_V2
	uptorelTable["CXP9024418/1"]="16A"      ; line="MSRBS;15B;CXP9024418/1" ; formatted_uptorel[line]=line   #up to R14 is 15B, the distinction is handled in the function appendCXCtranslation
	uptorelTable["CXP9024418/2"]="16A"      ; line="MSRBS;16A;CXP9024418/2" ; formatted_uptorel[line]=line
	uptorelTable["CXP9024418/3"]="16B"      ; line="MSRBS;16B;CXP9024418/3" ; formatted_uptorel[line]=line
	uptorelTable["CXP9024418/4"]="16B"      ; line="MSRBS;16B;CXP9024418/4" ; formatted_uptorel[line]=line
	uptorelTable["CXP9024418/5"]="17A"      ; line="MSRBS;17A;CXP9024418/5" ; formatted_uptorel[line]=line
	#uptorelTable["CXP9024418/6"]="17B"      ; line="MSRBS;17B;CXP9024418/6" ; formatted_uptorel[line]=line
	uptorelTable["CXP9028754/1"]="UCT"      ; line="MSRBS;UCT;CXP9028754/1" ; formatted_uptorel[line]=line   #UCTOOL UP
	uptorelTable["CXP9028754/2"]="UCT"      ; line="MSRBS;UCT;CXP9028754/2" ; formatted_uptorel[line]=line   #UCTOOL UP
	uptorelTable["CXP9028754/3"]="UCT"      ; line="MSRBS;UCT;CXP9028754/3" ; formatted_uptorel[line]=line   #UCTOOL UP
	uptorelTable["CXP9028754/4"]="UCT"      ; line="MSRBS;UCT;CXP9028754/4" ; formatted_uptorel[line]=line   #UCTOOL UP
	uptorelTable["CXP9028754/5"]="UCT"      ; line="MSRBS;UCT;CXP9028754/5" ; formatted_uptorel[line]=line   #UCTOOL UP
	uptorelTable["CXP9028754/6"]="UCT"      ; line="MSRBS;UCT;CXP9028754/6" ; formatted_uptorel[line]=line   #UCTOOL UP

	#WPRBS
	#read from ManagedElement::release instead
	#uptorelTable["CXP9023306/1"]="W13B/W14A"    ; line="WPRBS;W13B/W14A;CXP9023306/1" ; formatted_uptorel[line]=line
	#uptorelTable["CXP9023306/2"]="W14B"    ; line="WPRBS;W14B;CXP9023306/2" ; formatted_uptorel[line]=line

}
function parse_updata_file(ufile,cfile,ufile2,   tmptable,n,i,array,dest,t_up,t_upi,line)
{
	#this file is self-updated and stored in jarxml but comes in commonjars when installing moshell, then gets transferred to jarxml and updated there.
	#This is due to clearcase installation which makes files read-only, therefore we cannot put it in jarxml from the beginning
	if (fileOps("test -s "ufile) != 0)
	{
		fileOps("cp "moshelldir"/commonjars/updata.txt "ufile)
		chmod(00666,ufile)
		if (fileOps("test -s "ufile) != 0) { customPrint("ERROR: file "ufile" not found.") ; return }
	}
	if (fileOps("test -s "cfile) != 0)
	{
		fileOps("cp "moshelldir"/commonjars/cppdata.txt "cfile)
		chmod(00666,cfile)
		if (fileOps("test -s "cfile) != 0) { customPrint("ERROR: file "cfile" not found.") ; return }
	}
	if (fileOps("test -s "ufile2) != 0)
	{
		fileOps("cp "moshelldir"/commonjars/updata2.txt "ufile2)
		chmod(00666,ufile2)
		if (fileOps("test -s "ufile2) != 0) { customPrint("ERROR: file "ufile2" not found.") ; return }
	}
	while ((getline < cfile)>0)
	{
		gsub("\r","")
		if ($1 ~ /^#/ || $0 !~ ";") continue
		#CXP9012221/1;R1B04;CPP5.1.2.11_EP2
		#CXP9012842;R3BE/6;EP10-CPP6.1.0.16
		split($0,array,";")
		cppidTable[array[1]"_"array[2]]=array[3]
	}
	close(cfile)
	while ((getline < ufile)>0)
	{
		gsub("r","")
		#CNPR4120;GMPV2_MGw_CNP_R4.1.2.0, CPP5.1.2.11_EP2;CXP9012221/1;R1B04;MGW
		if ($1 ~ /^#/ || $0 !~ ";") continue
		split($0,array,";")
		upidTable[array[3]"_"array[4]]=array[1]" ("array[2]")"
		upidTable[gensub(/\//,"%",1,array[3])"_"gensub(/\//,"%",1,array[4])]=array[1]" ("array[2]")"
		line=sprintf("%3s;;%-10s;%-20s;%s",array[5],array[1],array[3]"_"array[4],array[2])
		formattedUpid[line]=line
	}
	close(ufile)
	while ((getline < ufile2)>0)
	{
		#this is the file $jarxmldir/updata2.txt which is made dynamically on WCDMA nodes by reading the administrativeData attribute of the UP
		gsub("r","")
		#CXP9012221/1;R1B04;W13A;RNC
		if ($1 ~ /^#/ || $0 !~ ";") continue
		split($0,array,";")
		if (array[3]=="20.Q1" && array[1]=="CXP102051/27" && array[2]!~/^R8([3-4][A-Z]|5[A-G])/) continue
		t_up=array[1]"_"array[2]
		#if the name is not like Wx.y.z then it is most likely a generic release name like "MAIN" or W14A or W14.0 so we map it against the UP product number only and not the revision
		if (array[3] ~ /^(CLASSIC|RBS_MT|MAIN|W[0-9]+[A-Z](DUW)?)$/) t_upi=array[1]     #alternative code: if (array[3] !~ /[0-9]+\.[0-9]+\.[0-9]+/) t_upi=array[1]
		else t_upi=t_up
		upidTable[t_upi]=array[3] (t_up in cppidTable && cppidTable[t_up]!="" ? " ("cppidTable[t_up]")":"()")
		#upidTable[gensub(/\//,"%",1,array[3])"_"gensub(/\//,"%",1,array[4])]=array[1]" ("array[2]")"
		line=sprintf("%s;%s;%s;%s;%s",array[4],rel_to_nr(array[3]),array[3],t_upi,(t_up in cppidTable && cppidTable[t_up]!="" ? cppidTable[t_up]:""))
		formattedUpid[line]=line
	}
	close(ufile2)
}
function parse_uptomom_file(file,   tmptable,n,i,array,dest)
{
	#this file is self-updated and stored in jarxml but comes in commonjars when installing moshell, then gets transferred to jarxml and updated there.
	#This is due to clearcase installation which makes files read-only, therefore we cannot put it in jarxml from the beginning
	uptomomTable["CXP9012374/1"]="3GSIM"
	uptomomTable["CXP9012374%1"]="3GSIM"
	uptomomTable["CXC1123663/1"]="3GSIM"
	uptomomTable["CXC1123663%1"]="3GSIM"
	formatted_uptomomTable["3GSIM;CXP9012374/1"]="3GSIM;CXP9012374/1;3GSIM"
	uptomomTable["CXP9012374/1;3GSIM"]="CXP9012374/1;3GSIM"
	if (fileOps("test -s "file) != 0)
	{
		fileOps("cp "moshelldir"/commonjars/uptomom.txt "file)
		chmod(00666,file)
		if (fileOps("test -s "file) != 0) { customPrint("ERROR: file "file" not found.") ; return }
	}
	while ((getline < file)>0)
	{
		gsub("r","")
		#CXP9012014;RNC_G
		if ($1!~/^#/ && $1~";") tmptable[$1]=$1
	}
	close(file)
	n=asort(tmptable)
	for (i=1;i<=n;i++)
	{
		split(tmptable[i],array,";")
		uptomomTable[array[1]]=array[2]
		uptomomTable[tmptable[i]]=tmptable[i]
		formatted_uptomomTable[gensub(/_.*$/,"",1,array[2])";"array[1]]=gensub(/_.*$/,"",1,array[2])";"array[1]";"array[2]
	}
	#uptomomTable[CXP9012014]=RNC_G
	#uptomomTable[CXP9012014;RNC_G]=CXP9012014;RNC_G
}
function parse_upid_file(file,   last,array,line,tmpcpp,i)
{
	#this file is always in commonjars and manually updated for each moshell release
	if (fileOps("test -s "file) != 0)
	{
		customPrint("ERROR: file "file" not found.")
		return
	}
	while ((getline < file)>0)
	{
		gsub("\r","")
		#P5.0.25;5.1.2.36 EP2;CXP9012014;R10CD;RNC
		if ($1~/^#/) continue
		if (tolower($0) ~ /tbd|tbc|delivery|cxc|refer|binder|cnx|jar/) continue
		gsub(/ *; */,";")
		gsub(/–/,"-")
		last=split($0,array,";")
		gsub(/[ \t]/,"",array[1])
		if (last<5) continue
		if (last>5)
		{
			#sometimes the CPP version contains semicolons, this gives more than 5 fields, eg:
			#P7.0-AD53; AD_HM64286_EP22-CPP_7.0.1.11; EP22-CPP7.0.1.11; CXP9012995; R6EB/48; RNC
			array[2]=array[(last-3)]
			array[3]=array[(last-2)]
			array[4]=array[(last-1)]
			array[5]=array[last]
			last=5
		}
		#sometimes there is a comment after the release name
		#W10.1.0-1(issuedbyW10Bproject); EP13-CPP_8.0.0.3; CXP9014711/2; R1Y; RNC
		if (array[1]~/\(/) sub(/ *\(.*\) */,"",array[1])
		#sometimes the release name is missing "P" in front
		#7.0.2;7.0.1.8 EP2; CXP9012995; R6DB; RNC
		if (array[1]~/^ *7/) array[1]="P"gensub(/^ */,"",1,array[1])
		#sometimes the CPP version has a space after "CPP, replace with underscore
		if (array[2]~/CPP [0-9]/) sub(/CPP /,"CPP_",array[2])
		#sometimes the revision contains the product number, remove it now
		if (array[4]~"CXP") sub(sprintf("%s[-_]?",array[3]),"",array[4])
		if (array[4]~"CXP") sub(/CXP[^R]+R/,"R",array[4]) #if the rev still matches CXP
		if (array[5]=="RBS")
		{
			#in column L in W10.1 sheet the UP looks like this: CXP9014346(GPB/CBU)/CXP9016868(DUW)
			if (array[3] ~ /CXP9014346.*CXP9016868/) array[3]="CXP9014346"
			sub(/\((GPB.CBU|DUW)\)/,"",array[3])

		}
		#the table stores the product number/rev, both with / and with % since file system uses % instead of /
		if (array[4] ~ /^ *(N\/A)? *$/) continue
		#for RBS >= P7.1.3 the product number shows CXP9012959 but in fact it is CXP9014346 (P7.1.3 or 4) or CXP9016141 (P7.1.5 and above)
		if (array[1] ~ /^Pp/) sub("Pp","P",array[1])
		if (array[3]=="CXP9012959/1")
		{
			if (array[1] ~ /^P7\.1\.[3-4]/) array[3]="CXP9014346/1"
			else if (array[1] ~ /^P7\.1\.[5-9]/) array[3]="CXP9016141/1"
		}
		#first check if the cpp version exists in cppidtable, otherwise we take array[2] as cppversion, except for RXI because it gives the LSV instead of official CPP release
		if (array[5]!="RXI" && (array[3]"_"array[4]) in cppidTable) tmpcpp=cppidTable[array[3]"_"array[4]]
		else tmpcpp=array[2]
		upidTable[array[3]"_"array[4]]=array[1]" ("tmpcpp")"
		upidTable[gensub(/\//,"%",1,array[3])"_"gensub(/\//,"%",1,array[4])]=array[1]" ("tmpcpp")"
		line=sprintf("%3s;%10.3f;%-10s;%-20s;%s",array[5],rel_to_nr(array[1]),array[1],array[3]"_"array[4],tmpcpp)
		line=toupper(line)
		formattedUpid[line]=line
		if (array[5]=="RBS")
		{
			if (array[3]!~ /\/[0-9]+$/)
			{
				#the RBS UP product number on node always has /1 at the end
				#except some UPs like CXP9023291, CXP9018350, CXP9021719, CXP9023078
				array[3]=array[3]"/1"
				upidTable[array[3]"_"array[4]]=array[1]" ("tmpcpp")"
				upidTable[gensub(/\//,"%",1,array[3])"_"gensub(/\//,"%",1,array[4])]=array[1]" ("tmpcpp")"
				line=sprintf("%3s;%10.3f;%-10s;%-20s;%s",array[5],rel_to_nr(array[1]),array[1],array[3]"_"array[4],tmpcpp)
				line=toupper(line)
				formattedUpid[line]=line
			}
			if (array[4]~/\/[0-9]$/)
			{
				#the RBS UP revision on node sometimes has a 0 instead of /
				sub(/\//,"0",array[4])
				upidTable[array[3]"_"array[4]]=array[1]" ("tmpcpp")"
				upidTable[gensub(/\//,"%",1,array[3])"_"gensub(/\//,"%",1,array[4])]=array[1]" ("tmpcpp")"
				line=sprintf("%3s;%10.3f;%-10s;%-20s;%s",array[5],rel_to_nr(array[1]),array[1],array[3]"_"array[4],tmpcpp)
				line=toupper(line)
				formattedUpid[line]=line
			}
		}
	}
	close(file)
}
function parse_upid_file2(file,   n,a,line,i,b,pn,rev,rel,nt)
{
	#this file is always in commonjars and manually updated for each moshell release
	if (fileOps("test -s "file) != 0)
	{
		customPrint("ERROR: file "file" not found.")
		return
	}
	while ((getline < file)>0)
	{
		#19.Q2/2;;19.Q2/2.0;19.Q2/2.0-1;;;;;;;;;;;;;;
		#DU Radio Node;CXP 102 051/27;R69C18;R69C19;;;;;;;;;;;;;;
		#BB Radio Node;CXP 902 4418/6;R69C32;;;;;;;;;;;;;;;
		#BB Radio Node C2;CXP 902 4418/12;R41C38;;;;;;;;;;;;;;;
		#BB Radio Node NR C1;CXP 201 0045/1;R22C52;;;;;;;;;;;;;;;
		#BB Radio Node NR C2;CXP 201 0045/5;R22C60;;;;;;;;;;;;;;;
		gsub("\r","")
		if ($1~/^#/) continue
		gsub(/[ \t]/,"")
		n=split($0,a,";")
		if (a[2]~/^CXP/)
		{
			for (i=3;i<=n;i++)
			{
				if (a[i]!~/^R/) continue
				nt="MSRBS"
				pn=a[2] ; rev=a[i]
				if (pn=="CXP102051/27") nt="ERBS"
				rel=sprintf("%s%s",(nt=="ERBS"?"L":""),b[i])
				upidTable[pn"_"rev]=upidTable[gensub(/\//,"%",1,pn)"_"rev]=rel
				line=sprintf("%3s;%10.3f;%-10s;%-20s;",nt,rel_to_nr(rel),rel,pn"_"rev)
				formattedUpid[line]=line
			}
		}
		else if (n>0) n=split($0,b,";") #the header line with release names
	}
	close(file)
}
function rel_to_nr(rel,   array,n,i,j,k,pos,digit,array2)
{
	#P7.1.0-3   --> 7*1000000+1*10000+ 0*100+3*1
	#P7.0-AD27  --> 7*1000000+0*10000+ 0*100+0*1+27*0.001
	#P6.1.0     --> 6*1000000+1*10000+ 0*100+0*1
	#P5.0-AD137 --> 5*1000000+0*10000+ 0*100+0*1+137*0.001
	#P5.0.26-6  --> 5*1000000+0*10000+26*100+6*1
	#18.Q4.C4   --> 18*1000000+4*10000+4*100
	#16B.16     --> 16.5*1000000+16*10000
	#19.Q2/2.0
	gsub(/[ \t]/,"",rel)
	sub(/^[PWL]/,"",rel)
	sub(/\.Q/,".",rel)
	sub(/\.C/,".99.",rel)
	sub(/\//,".",rel)
	n=split(rel,array,".")
	if (array[1]~/[AB]$/)
	{
		sub(/A\./,".0.",rel)
		sub(/B\./,".1.",rel)
		n=split(rel,array,".")
	}
	for (i=1;i<=n;i++)
	{
		pos++
		k=split(array[i],array2,"-")
		digit[pos]=array2[1]
		if (k > 1)
		{
			if (array2[2]~/^AD/) digit[5]=gensub(/[A-Z]/,"","g",array2[2])+0
			else digit[++pos]=gensub(/[A-Z]/,"","g",array2[2])+0
		}
	}
	for (i=1;i<=5;i++) rel=digit[1]*1000000+digit[2]*10000+digit[3]*100+digit[4]*1+digit[5]*0.001+0
	return rel
}


function parse_lmid_file(file)
{
	#this file is self-updated and stored in jarxml but comes in commonjars when installing moshell, then gets transferred to jarxml and updated there.
	#This is due to clearcase installation which makes files read-only, therefore we cannot put it in jarxml from the beginning
	if (fileOps("test -s "file) != 0)
	{
		fileOps("cp "moshelldir"/commonjars/lmids.txt "file)
		chmod(00666,file)
		if (fileOps("test -s "file) != 0) { customPrint("ERROR: file "file" not found.") ; return }
	}
	while ((getline < file)>0)
	{
		gsub("\r","")
		#ignore entries not consisting of two words or where the second word is the date (has happened sometimes that productDate is printed instead of productName) or where the second word is the CXC number
		if (NF != 2) continue
		if ($2 ~ /^[0-9]+$/) continue
		if ($2 ~ /^CXC[0-9]/) continue
		lmidTable[sprintf("%-14s %s",$1,$2)]=1
		lmidLookupTable[$1]=$2
		lmidLookupTable[gensub(/%/,"/",1,$1)]=$2
		lmidRevLookupTable[$2]=lmidRevLookupTable[$2]";"$1
	}
	close(file)
}

function appendCXCtranslation(line,templength,nocolor,   cxcnum,translation,array,array1,array2,alreadyappended,s,tmpUp)
{
	if (print_lmid < 1) return line
	if (/Ans_aal2ncc2_proc.*[Cc]ause = [0-9a-f]+/)
	{
		#[2006-06-07 16:30:59.292] Ans_aal2ncc2_proc outPVfilter.c:417 TRACE9:rejectType = 1,rejectCause = 50331712
		#[2006-06-07 16:30:59.312] Ans_aal2ncc2_proc netconn.c:532 TRACE9:aal2NciRejCause = 3000040, rejectType = 1
		#flow.awk: 14:57:25.520] 001400/Ans_aal2ncc2_proc netconn.c:553 TRACE9:aal2NciRejCause = 1f, rejectType = 2
		#[2007-05-30 13:20:38.736] Ans_aal2ncc2_proc(AAL2REJECTS) netconntrans.c:469 TRACE1:localRejCause = 31; q2630_rejCause = 31; netconnId= 4239
		match($0,/[Cc]ause = ([0-9a-f]+)/,array)
		match($0,/Type = ([12])/,array1)
		match($0,/2630_rejCause = ([0-9]+)/,array2)
		translation=sprintf("(%s%s%s)",(1 in array1 ? aal2RejCause[array1[1]]"REJECT_" : ""),(array[1] in aal2RejCause ? aal2RejCause[array[1]] : "?"),(array2[1] != array[1] ? ", "aal2RejCause[array2[1]] : ""))
	}
	else if (($6=="MTPL3" || $8=="MTPL3")&& $NF ~ /^11[0-9][0-9][0-9]$/)
		#(($6=="MTPL3" && $14 >= 11000 && $10 ~ /^[0-9]+$/ && $11 ~ /^[0-9]+$/)||\
		 #($8=="MTPL3" && $17 >= 11000 && $12 ~ /^[0-9]+$/ && $13 ~ /^[0-9]+$/))
	{
		#[2006-06-14 12:31:42.120] Scc_ituServer_proc ss7log_Cello.c:205 INFO:****   MTPL3   8  m3_DLPrimitives.c    1915       2       8       9       0   11095
		#[2006-06-14 12:31:59.948] Scc_ituServer_proc ss7log_Cello.c:219 ERROR:****  MTPL3   8  m3_stp.c     177       2      14       6       0   11069
		#lineNr     linkstate   currentevent  hsn     sdl  errcode
		#177        2           14            6       0    11069
		#[2007-09-20 10:48:17.928] Scc_server_proc ss7log_Cello.c:486 INFO:  0:38 ****           MTPL3   9    M3LinkMxDL.c    1995       2       7       0       2     0  11096
		#[2010-08-24 05:09:52.508] Scc_server_proc ss7log_Cello.c:516 INFO:  0:309 ****          MTPL3   8    M3LinkMxDL.c    2716       2       7       1       2     0  11096
		#$11        $12         $13           $14   $15     $16     $17
		#lineNr     linkstate   currentevent  hsn   sdl     unused  errcode
		#2716       2           7             1     2       0       11096
		if (NF==14)      translation=sprintf("(HSN=%s SDL=%s STATE=%s:%s EVENT=%s:%s ERRCODE=%s:%s)",$12,$13,$10,mtp3_state[$10],$11,mtp3_event[$11],$14,mtp3_error[$14])
		else if (NF==17) translation=sprintf("(HSN=%s SDL=%s STATE=%s:%s EVENT=%s:%s ERRCODE=%s:%s)",$14,$15,$12,mtp3_state[$12],$13,mtp3_event[$13],$17,mtp3_error[$17])
	}
	else if (($6=="SCCP" || $8=="SCCP") && $NF ~ /^12[0-9][0-9][0-9]$/)
	         #(($6=="SCCP" && $14 >= 12000 && $10 ~ /^[0-9]+$/ && $11 ~ /^[0-9]+$/)||\
		 #($8=="SCCP" && $17 >= 12000 && $12 ~ /^[0-9]+$/ && $13 ~ /^[0-9]+$/))
	{
		#[2006-06-21 07:23:44.332] Scc_ituServer_proc ss7log_Cello.c:351 INFO:****            SCCP    8  mIATsccpsubr.c   14986       3       2       0       0   12350
		#[2008-01-09 15:44:25.328] Scc_server_proc ss7log_Cello.c:494 INFO:  0:404 ****       SCCP   8   sccp_decode.c     944       4       2     281     142     0  12043
		#line   state  event   connId   ssn    errCode
		#14986    3       2       0       0   12350
		if (NF==14)      translation=sprintf("(CONNID=%s SSN=%s STATE=%s:%s EVENT=%s:%s ERRCODE=%s:%s)",$12,$13,$10,sccp_state[$10],$11,sccp_event[$11],$14,sccp_error[$14])
		else if (NF==17) translation=sprintf("(CONNID=%s SSN=%s STATE=%s:%s EVENT=%s:%s ERRCODE=%s:%s)",$15,$16,$13,sccp_state[$13],$14,sccp_event[$14],$17,sccp_error[$17])
	}
	else if (NF > 5 && $NF in errTrans && $(NF-1) == "=" && $3 ~ /^rnhCellRoC/)
	{
		# [2006-06-28 09:50:15.892] rnhCellRoC[11] ../src/RnhCellRoC.cpp:6139 INFO:rnhCellRoC[cellFroId 11, iubLinkFroId 3] failed to unlock cell, reason : = 16002
		translation=sprintf("(%s)",errTrans[$NF])
	}
	else if ($5=="TRACE1:Exception" && $3 ~ /RncLmUePT\(UEH_EXCEPTION\)/ && tolower($0) ~ /causecode.*aal2 /)
	{
		#[2006-08-02 22:18:07.76] RncLmUePT(UEH_EXCEPTION) ../src/UehRabHandlingC.cpp:8099 TRACE1:Exception code 21; RRCConNotRel; UeRef = 257; IMSI = 310410070303939; cellId = 65521; cellFroId = 0, RLs in DRNC = 0, Best RL in DRNC: No; causecode = 67108961; ConnType: uehRrcConn; RabsToSetup: uehRabSpeech ; proc: rabEst; the clientConnId is 2; the cepId is 1414; the rejectType is 1; Aal2 Connection Request Rejected from Cello
		#[2007-07-05 08:29:49.664] RncLmUePT(UEH_EXCEPTION) ../src/UehSoftHoC.cpp:23708 TRACE1:Exception Code 28; RRCConRel; UeRef = 1888; IMSI = UNDEF; TMSI = 3c46cb89; cellId = 2233; cellFroId = UNDEF; causecode = 34; rejectType = 2;connType = uehRrcConn; c1 = 47201; c2 = 2233; c3 = UNDEF; c4 = UNDEF; AAL2 network connection setup failure on Iub interface
		#[2007-06-29 15:59:33.292] RncLmUePT(UEH_EXCEPTION) ../src/UehRrcConnSetupC.cpp:7176 TRACE1:Exception Code 13; RRCConNotRel; UeRef = 166; IMSI = UNDEF; TMSI = 88026e61; cellId = 19448; cellFroId = 306; causecode = 41; connType = uehNotValid; Cello AAL2 NCI connection reservation failure; rejectType = 2
		#[2007-06-29 15:49:11.512] RncLmUePT(UEH_EXCEPTION) ../src/UehUeCtxtC.cpp:6073 TRACE1:Exception Code 17; RRCConRel; UeRef = 1748; RNC Id: 1; cellId = 30410; cellFroId = -1, RLs in DRNC = 1, Best RL in DRNC: Yes, DRNC Id: 1; causecode = 67108972; disconnectType = 1; connType = uehSpeech; Aal2 Disconnect Ind,  :2
		match($0,/causecode = ([0-9]+);/,array)
		translation=sprintf("(%s)",aal2RejCause[array[1]])
	}
	else if (line ~ /[CB][OBXS][ACPXY][0-9%/]+/)
	{
		#[2007-06-15 09:23:58.524] main_thread_func ../src/target/Cello/MAIN/main.cc:457 INFO:***RoseRT: Adding rrt and rrt-CXC1329883_R4J05 shell command to Cello debugger
		#[2007-06-25 18:57:13.340] Cs_boardManager_proc osa_board_mgr.c:2439 INFO:Start of @(#)CXC1321447 R50HX06 2005-12-21 15:42:08 MET 868a2602-0b3c2640-1260
		#[2010-02-23 11:20:38.812] se.ericsson.wcdma.rnc.roam.roam_application:main RoamApplication:0 INFO:Starting RncLmMao [version=CXC1727677/3-P3F04, file name=/j/java/CXC1727677_3_P3F04.jar]
		#Name     : CXC1329852_R4J10
		#-rw-rw-rw-   0     23895  19 Jan 2006 07:12:25 CXC1329877%3_R1C01.jar
		if (line ~ /[0-9]%[CB][OBXS][ACPXY][0-9%/]+/)
		{
			#In EvoC, there are programs called like 5%CXC1727629%5
			match(line,/([0-9]%[CB][OBXS][ACPXY][0-9%/]+)/,array)
			cxcnum=array[1]
		}
		else
		{
			match(line,/([CB][OBXS][ACPXY][0-9%/]+)/,array)
			cxcnum = array[1]
		}
		#cxcnum = gensub(/(.*)([CB][OBXS][ACPXY][0-9%/]+)(.*)/,"\\2","1",line);
		buildLmidTable()
		if (!(cxcnum in lmidLookupTable))
		{
			#in case the product number is registered with underscore instead of % or / , eg RncLmMao
			sub(/[/%]/,"_",cxcnum)
		}
		if (cxcnum in lmidLookupTable)
		{
			translation=sprintf("(%s)",lmidLookupTable[cxcnum])
			if (show_colors==1 && (colour_string=="" || line !~ colour_string)) translation=sprintf("\33[35m%s\33[0m",translation)
			line=sprintf("%-"templength"s %s",line,translation)
			alreadyappended=1
		}
		else if (line ~ /CXP[0-9%/]+/)
		{
			if (line ~ /CXP[0-9%/]+.*[ _][RPBI][0-9A-Z%/]+/) match(line,/(CXP[0-9%/]+).*[ _]([RPBI][0-9A-Z%/]+)/,array)
			else if (line ~ /CXP[0-9%/]+/) match(line,/(CXP[0-9%/]+)/,array)
			#print "debug:" array[1],array[2]
			if (sprintf("%s_%s",array[1],array[2]) in upidTable) translation=upidTable[sprintf("%s_%s",array[1],array[2])]
			else if (array[2] ~ /R[0-9]+[A-Z]+[/]?[0-9]+$/ && sprintf("%s_%s",array[1],gensub(/[/]?[0-9]+$/,"",1,array[2])) in upidTable) translation=upidTable[sprintf("%s_%s",array[1],gensub(/[/]?[0-9]+$/,"",1,array[2]))]
			else if (gensub(/(%|\/)[0-9]+$/,"",1,array[1]) in uptorelTable)
			{
				tmpUp=gensub(/(%|\/)[0-9]+$/,"",1,array[1])
				translation=uptorelTable[tmpUp]
			}
			else if (gensub("%","/",1,array[1]) in uptorelTable)
			{
				tmpUp=gensub("%","/",1,array[1])
				translation=uptorelTable[tmpUp]
			}
			else if (gensub("%","/",1,array[1]) in uptomomTable)
			{
				tmpUp=gensub("%","/",1,array[1])
				translation=uptomomTable[tmpUp]
			}
			#special case for RNC W13, same product number for both tracks R1 for W13A and R2 for W13B
			if (tmpUp=="CXP9021775" && translation == "W13")
			{
				#print array[1],array[2]
				if (array[2] ~ "R1") translation="W13A"
				else if (array[2] ~ "R(2|3|4|5|71|88)") translation="W13B"
			}
			else if (array[1]=="CXP9024418/6" || array[1]=="CXP9024419/6") # C1
			{
				     if (array[2] ~ /R[1-4][A-Z]/)           translation="17B"
				else if (array[2] ~ /R5[A-Z]/)               translation="17.Q1"   # R5
				else if (array[2] ~ /R([6-9]|1[0-2])[A-Z]/)  translation="17.Q2"   # R6-R12
				else if (array[2] ~ /R(1[3-9]|2[0-1])[A-Z]/) translation="17.Q3"   # R13-R21
				else if (array[2] ~ /R2[2-8][A-Z]/)          translation="17.Q4"   # R22-R28
				else if (array[2] ~ /R(29|3[0-4])[A-Z]/)     translation="18.Q1"   # R29-R34
				else if (array[2] ~ /R(3[5-9]|4[0-2])[A-Z]/) translation="18.Q2"   # R35-R42
				else if (array[2] ~ /R4[3-8][A-Z]/)          translation="18.Q3"   # R43-R48
				else if (array[2] ~ /R49[A-Z]|R5[0-5][A-Z]/) translation="18.Q4"   # R49-R55
				else if (array[2] ~ /R(5[6-9]|60)[A-Z]/)     translation="19.Q1"   # R56-R60
				else if (array[2] ~ /R6[1-7][A-Z]/)          translation="19.Q2/1" # R60-R67
				else if (array[2] ~ /R6[8-9][A-Z]/)          translation="19.Q2/2" # R68-R69
				else if (array[2] ~ /R7[0-3][A-Z]/)          translation="19.Q3"   # R70-73
				else if (array[2] ~ /R(7[4-9]|8[0-2])[A-Z]/) translation="19.Q4"   # R74-82
				else if (array[2] ~ /R8[3-5][A-Z]/)          translation="20.Q1"   # R83-85
			}
			else if (array[1]=="CXP9024418/12") # G2 C2
			{
				     if (array[2] ~ /R1[2-7][A-Z]/)          translation="18.Q1"   #R12-R17
				else if (array[2] ~ /R(1[89]|2[01])[A-Z]/)   translation="18.Q2"   #R18-R21
				else if (array[2] ~ /R2[2-7][A-Z]/)          translation="18.Q3"   #R22-R27
				else if (array[2] ~ /R(2[89]|3[0-1])[A-Z]/)  translation="18.Q4"   #R28-R31
				else if (array[2] ~ /R32[A-Z]/)              translation="19.Q1"   #R32
				else if (array[2] ~ /R3[3-9][A-Z]/)          translation="19.Q2/1" #R33-R39
				else if (array[2] ~ /R4[0-1][A-Z]/)          translation="19.Q2/2" #R40-41
				else if (array[2] ~ /R4[2-5][A-Z]/)          translation="19.Q3"   #R42-45
				else if (array[2] ~ /R(4[6-9]|5[0-2])[A-Z]/) translation="19.Q4"   #R46-52
				else if (array[2] ~ /R5[3-7][A-Z]/)          translation="20.Q1"   #R53-57
				else if (array[2] ~ /R(5[8-9]|6[0-4])[A-Z]/) translation="20.Q2"   #R58-64
				else if (array[2] ~ /R(6[5-9]|70)[A-Z]/)     translation="20.Q3"   #R65-70
				else if (array[2] ~ /R7[1-7][A-Z]/)          translation="20.Q4"   #R71-77
				else if (array[2] ~ /R(7[89]|8[01])[A-Z]/)   translation="21.Q1"   #R78-81
				else if (array[2] ~ /R8[2-7][A-Z]/)          translation="21.Q2"   #R82-87
			}
			else if (array[1]=="CXP9024418/15" || array[1]=="CXP2010171/1" || array[1]=="CXP2010174/1" || array[1]=="CXP9024418/22") translation=translate_up_rel(array[1],array[2])
		}
	}
	else if ($3 ~ /IU_IF/ && ($6=="IuReleaseRequest" || $5=="TRACE1:IuReleaseCommand"))
	{
		#[2005-11-29 08:22:51.200] 021300/RncLmUePT(IU_IF) ../src/UehUeCtxtC.cpp:964 TRACE1:Sending IuReleaseRequest for circuit switched CN with cause 15, UeRef = 1889; IMSI =222995200206246f; cellId = 905; cellFroId = -1, RLs in DRNC = 2, Best RL in DRNC: Yes; connType = uehSpeech
		#[2007-03-30 01:15:09.756] RncLmUePT(IU_IF) ../src/UehUeCtxtC.cpp:7782 TRACE1:IuReleaseCommand received for circuit switched CN with nas cause 83, UeRef = 764; IMSI = 301001700000002; cellId = 1067; cellFroId = 66, RLs in DRNC = 0, Best RL in DRNC: No; connType = uehSpeech
		match($0,/ cause ([0-9]+)/,array)
		translation=sprintf("(%s)",(array[1] in IU_IF_code ? IU_IF_code[array[1]] : "?"))
	}
	else if (NF==6 && $2=="(" && $4==")" && $1 ~ /^[0-9]+$/ && $5 ~ /^[0-9]+$/ && $6 ~ /^[0-9]+$/)
	{
		#Rej cause nr   Local rej.cnt   Remote rej.cnt
		#------------   -------------   --------------
		#  1 ( 0x01 )   0               0
		translation=sprintf("(%s)",aal2RejCause[$3])
	}
	else if ($1=="Ipet_remoteIpAddress" && $2=="=" && $3 ~ /^[0-9]+$/)
	{
		#Ipet_remoteIpAddress = 174329861
		translation="("d2ip_function($3)")"
	}
	if (translation != "" && alreadyappended != 1)
	{
		if (show_colors==1 && nocolor != "nocolor")   translation=sprintf("\33[35m%s\33[0m",translation)
		line=sprintf("%s %s",line,translation)
	}
	return line

	#To test that this functionality is correctly working, put the following lines in a text file and pipe the file to the utility "parseline"
	#[2006-06-07 16:30:59.292] Ans_aal2ncc2_proc outPVfilter.c:417 TRACE9:rejectType = 1,rejectCause = 50331712
	#[2006-06-07 16:30:59.312] Ans_aal2ncc2_proc netconn.c:532 TRACE9:aal2NciRejCause = 3000040, rejectType = 1
	#14:57:25.520] 001400/Ans_aal2ncc2_proc netconn.c:553 TRACE9:aal2NciRejCause = 1f, rejectType = 2
	#[2007-05-30 13:20:38.736] Ans_aal2ncc2_proc(AAL2REJECTS) netconntrans.c:469 TRACE1:localRejCause = 32; q2630_rejCause = 31; netconnId= 4239
	#[2007-06-15 09:23:58.524] main_thread_func ../src/target/Cello/MAIN/main.cc:457 INFO:***RoseRT: Adding rrt and rrt-CXC1329883_R4J05 shell command to Cello debugger
	#[2007-06-25 18:57:13.340] Cs_boardManager_proc osa_board_mgr.c:2439 INFO:Start of @(#)CXC1321447 R50HX06 2005-12-21 15:42:08 MET 868a2602-0b3c2640-1260
	#Name     : CXC1329852_R4J10
	#-rw-rw-rw-   0     23895  19 Jan 2006 07:12:25 CXC1329877%3_R1C01.jar
	#[2006-08-02 22:18:07.76] RncLmUePT(UEH_EXCEPTION) ../src/UehRabHandlingC.cpp:8099 TRACE1:Exception code 21; RRCConNotRel; UeRef = 257; IMSI = 310410070303939; cellId = 65521; cellFroId = 0, RLs in DRNC = 0, Best RL in DRNC: No; causecode = 67108961; ConnType: uehRrcConn; RabsToSetup: uehRabSpeech ; proc: rabEst; the clientConnId is 2; the cepId is 1414; the rejectType is 1; Aal2 Connection Request Rejected from Cello
	#[2007-07-05 08:29:49.664] RncLmUePT(UEH_EXCEPTION) ../src/UehSoftHoC.cpp:23708 TRACE1:Exception Code 28; RRCConRel; UeRef = 1888; IMSI = UNDEF; TMSI = 3c46cb89; cellId = 2233; cellFroId = UNDEF; causecode = 34; rejectType = 2;connType = uehRrcConn; c1 = 47201; c2 = 2233; c3 = UNDEF; c4 = UNDEF; AAL2 network connection setup failure on Iub interface
	#[2007-06-29 15:59:33.292] RncLmUePT(UEH_EXCEPTION) ../src/UehRrcConnSetupC.cpp:7176 TRACE1:Exception Code 13; RRCConNotRel; UeRef = 166; IMSI = UNDEF; TMSI = 88026e61; cellId = 19448; cellFroId = 306; causecode = 41; connType = uehNotValid; Cello AAL2 NCI connection reservation failure; rejectType = 2
	#[2007-06-29 15:49:11.512] RncLmUePT(UEH_EXCEPTION) ../src/UehUeCtxtC.cpp:6073 TRACE1:Exception Code 17; RRCConRel; UeRef = 1748; RNC Id: 1; cellId = 30410; cellFroId = -1, RLs in DRNC = 1, Best RL in DRNC: Yes, DRNC Id: 1; causecode = 67108972; disconnectType = 1; connType = uehSpeech; Aal2 Disconnect Ind,  :2
	#[2006-06-28 09:50:15.892] rnhCellRoC[11] ../src/RnhCellRoC.cpp:6139 INFO:rnhCellRoC[cellFroId 11, iubLinkFroId 3] failed to unlock cell, reason : = 16002
	#[2006-06-21 07:23:44.332] Scc_ituServer_proc ss7log_Cello.c:351 INFO:****            SCCP    8  mIATsccpsubr.c   14986       3       2       0       0   12350
	#[2006-06-14 12:31:42.120] Scc_ituServer_proc ss7log_Cello.c:205 INFO:****   MTPL3   8  m3_DLPrimitives.c    1915       2       8       9       0   11095
	#[2006-06-14 12:31:59.948] Scc_ituServer_proc ss7log_Cello.c:219 ERROR:****  MTPL3   8  m3_stp.c     177       2      14       6       0   11069
	#[2005-11-29 08:22:51.200] 021300/RncLmUePT(IU_IF) ../src/UehUeCtxtC.cpp:964 TRACE1:Sending IuReleaseRequest for circuit switched CN with cause 15, UeRef = 1889; IMSI =222995200206246f; cellId = 905; cellFroId = -1, RLs in DRNC = 2, Best RL in DRNC: Yes; connType = uehSpeech
	#[2007-03-30 01:15:09.756] RncLmUePT(IU_IF) ../src/UehUeCtxtC.cpp:7782 TRACE1:IuReleaseCommand received for circuit switched CN with nas cause 83, UeRef = 764; IMSI = 301001700000002; cellId = 1067; cellFroId = 66, RLs in DRNC = 0, Best RL in DRNC: No; connType = uehSpeech
	#Rej cause nr   Local rej.cnt   Remote rej.cnt
	#------------   -------------   --------------
	#  1 ( 0x01 )   0               0
	#
}
function translate_up_rel(pn,string,    result)
{
	result=""
	if (pn=="CXP9024418/15") #G2 C1
	{
		     if (string ~ /R[1-3][A-Z]/)            result="20.Q1"   #R1-3
		else if (string ~ /R[4-7][A-Z]/)            result="20.Q2"   #R4-7
		else if (string ~ /R([8-9]|1[0-3])[A-Z]/)   result="20.Q3"   #R8-R13
		else if (string ~ /R(1[4-9]|20)[A-Z]/)      result="20.Q4"   #R14-R20
		else if (string ~ /R2[1-4][A-Z]/)           result="21.Q1"   #R21-24
		else if (string ~ /R(2[5-9]|30)[A-Z]/)      result="21.Q2"   #R25-30
		else if (string ~ /R3[1-7][A-Z]/)           result="21.Q3"   #R31-37
		else if (string ~ /R(3[8-9]|4[0-3])[A-Z]/)  result="21.Q4"   #R38-43
		else if (string ~ /R(4[4-8])[A-Z]/)         result="22.Q1"   #R44-48
	}
	else if (pn=="CXP9024418/22") #G2 C2
	{
		if (string ~ /R[1-5][A-Z]/)                 result="21.Q3"   #R1-5
		else if (string ~ /R([6-9]|1[0-1])[A-Z]/)   result="21.Q4"   #R6-11
		else if (string ~ /R(1[2-6])[A-Z]/)         result="22.Q1"   #R12-16
	}
	else if (pn=="CXP2010174/1") # G3 C1/C2
	{
		     if (string ~ /R[1-4][A-Z]/)            result="20.Q2"   #R1-4
		else if (string ~ /R([5-9]|10)[A-Z]/)       result="20.Q3"   #R5-10
		else if (string ~ /R1[1-7][A-Z]/)           result="20.Q4"   #R11-17
		else if (string ~ /R(1[89]|2[01])[A-Z]/)    result="21.Q1"   #R18-21
		else if (string ~ /R2[2-7][A-Z]/)           result="21.Q2"   #R22-27
		else if (string ~ /R(2[8-9]|3[0-3])[A-Z]/)  result="21.Q3"   #R28-33
		else if (string ~ /R(3[4-9]|40)[A-Z]/)      result="21.Q4"   #R34-40
		else if (string ~ /R(4[1-5])[A-Z]/)         result="22.Q1"   #R41-45
	}
	else if (pn=="CXP2010171/1") # G3 C1
	{
		     if (string ~ /R[1-9][A-Z]/)            result="20.Q3"   #R1-9
		else if (string ~ /R1[0-6][A-Z]/)           result="20.Q4"   #R10-16
	}
	return result
}
function d2ip_function(ip_dec,what,    ip_hex,ip_addr,i)
{
	if (ip_dec < 0 )#|| ip_dec > 2147483647)
	{
		ip_dec = 4294967295 + ip_dec + 1;
	}
	ip_hex = int2hex(ip_dec);
	#print ip_hex


	for (i=1;i<=8;i+=2) { ip_addr = ip_addr "." hex2int(substr(ip_hex,i,2)) }
	sub(/^\./,"",ip_addr);
	if (what=="brackets")
	{
		#if there is two consecutive dots then it is not a valid ip address, return nothing
		if (ip_addr ~ /\.\./) return ""
		#otherwise return in brackets because it is used in dbdat mode to translate ipaddresses
		return " ("ip_addr")"
	}
	return ip_addr
}
function int2hex(intval,   tempstr)
{
        tempstr = sprintf( "%lx", intval );
        #tempstr = sprintf("%X",strtonum(intval))
        return (length(tempstr) == 7 ? "0" tempstr : tempstr);
}
function hex2int(hexstr,    hexval,c,i)
{
        for(i=1;i<=length(hexstr);i++)
        {
                c = substr(hexstr,i,1);
                if ( c>=1 && c<=9 ) hexval+= c;
                else if ( c=="a" || c=="A" ) hexval += 10;
                else if ( c=="b" || c=="B" ) hexval += 11;
                else if ( c=="c" || c=="C" ) hexval += 12;
                else if ( c=="d" || c=="D" ) hexval += 13;
                else if ( c=="e" || c=="E" ) hexval += 14;
                else if ( c=="f" || c=="F" ) hexval += 15;
                else if ( c != "0" && c!= "x" && c!="X") customPrint("Bombed in gethex")
                if ( i!=length(hexstr) ) hexval = hexval*16;
        }
        return hexval;
}

function Define_months()
{
	mm["Jan"]=1;mm["Feb"]=2;mm["Mar"]=3;mm["Apr"]=4;mm["May"]=5;mm["Jun"]=6
	mm["Jul"]=7;mm["Aug"]=8;mm["Sep"]=9;mm["Oct"]=10;mm["Nov"]=11;mm["Dec"]=12
	wkday["Mon"]=1;wkday["Tue"]=2;wkday["Wed"]=3;wkday["Thu"]=4;wkday["Fri"]=5;wkday["Sat"]=6;wkday["Sun"]=7
	mm["jan"]=1;mm["feb"]=2;mm["mar"]=3;mm["apr"]=4;mm["may"]=5;mm["jun"]=6
	mm["jul"]=7;mm["aug"]=8;mm["sep"]=9;mm["oct"]=10;mm["nov"]=11;mm["dec"]=12
	mm["jan."]=1;mm["fev."]=2;mm["mars"]=3;mm["avr."]=4;mm["mai"]=5;mm["juin"]=6
	mm["jui."]=7;mm["aout"]=8;mm["sep."]=9;mm["oct."]=10;mm["nov."]=11;mm["dec."]=12
	wkday["mon"]=1;wkday["tue"]=2;wkday["wed"]=3;wkday["thu"]=4;wkday["fri"]=5;wkday["sat"]=6;wkday["sun"]=7
	translateCmd["CREATE"]="CRE" ; translateCmd["DELETE"]="DEL" ; translateCmd["SET"]="SET" ; translateCmd["ACTION"]="ACT"
}
function make_causeTable()
{
	causeTable[0]="Indeterminate"
	causeTable[1]="AlarmIndicationSignal"
	causeTable[2]="CallSetupFailure"
	causeTable[3]="DegradedSignal"
	causeTable[4]="FarEndReceiverFailure"
	causeTable[5]="FramingError"
	causeTable[6]="LossOfFrame"
	causeTable[7]="LossOfPointer"
	causeTable[8]="LossOfSignal"
	causeTable[9]="PayloadTypeMismatch"
	causeTable[10]="TransmissionError"
	causeTable[11]="RemoteAlarmInterface"
	causeTable[12]="ExcessiveBitErrorRate"
	causeTable[13]="PathTraceMismatch"
	causeTable[14]="Unavailable"
	causeTable[15]="SignalLabelMismatch"
	causeTable[16]="LossOfMultiFrame"
	causeTable[17]="receiveFailure"
	causeTable[18]="transmitFailure"
	causeTable[19]="modulationFailure"
	causeTable[20]="demodulationFailure"
	causeTable[21]="broadcastChannelFailure"
	causeTable[22]="connectionEstablishmentError"
	causeTable[23]="invalidMessageReceived"
	causeTable[24]="localNodeTransmissionError"
	causeTable[25]="remoteNodeTransmissionError"
	causeTable[26]="routingFailure"
	causeTable[51]="BackPlaneFailure"
	causeTable[52]="DataSetProblem"
	causeTable[53]="EquipmentIdentifierDuplication"
	causeTable[54]="ExternalIfDeviceProblem"
	causeTable[55]="LineCardProblem"
	causeTable[56]="MultiplexerProblem"
	causeTable[57]="NeIdentifierDuplication"
	causeTable[58]="PowerProblem"
	causeTable[59]="ProcessorProblem"
	causeTable[60]="ProtectionPathFailure"
	causeTable[61]="ReceiverFailure"
	causeTable[62]="ReplaceableUnitMissing"
	causeTable[63]="ReplaceableUnitTypeMismatch"
	causeTable[64]="SynchronisationSourceMismatch"
	causeTable[65]="TerminalProblem"
	causeTable[66]="TimingProblem"
	causeTable[67]="TransmitterFailure"
	causeTable[68]="TrunkCardProblem"
	causeTable[69]="ReplaceableUnitProblem"
	causeTable[70]="realTimeClockFailure"
	causeTable[71]="antennaFailure"
	causeTable[72]="batteryChargingFailure"
	causeTable[73]="diskFailure"
	causeTable[74]="frequencyHoppingFailure"
	causeTable[75]="iODeviceError"
	causeTable[76]="lossOfSynchronisation"
	causeTable[77]="lossOfRedundancy"
	causeTable[78]="powerSupplyFailure"
	causeTable[79]="signalQualityEvaluationFailure"
	causeTable[80]="tranceiverFailure"
	causeTable[81]="protectionMechanismFailure"
	causeTable[82]="protectingResourceFailure"
	causeTable[101]="AirCompressorFailure"
	causeTable[102]="AirConditioningFailure"
	causeTable[103]="AirDryerFailure"
	causeTable[104]="BatteryDischarging"
	causeTable[105]="BatteryFailure"
	causeTable[106]="CommercialPowerFailure"
	causeTable[107]="CoolingFanFailure"
	causeTable[108]="EngineFailure"
	causeTable[109]="FireDetectorFailure"
	causeTable[110]="FuseFailure"
	causeTable[111]="GeneratorFailure"
	causeTable[112]="LowBatteryThreshold"
	causeTable[113]="PumpFailure"
	causeTable[114]="RectifierFailure"
	causeTable[115]="RectifierHighVoltage"
	causeTable[116]="RectifierLowVoltage"
	causeTable[117]="VentilationSystemFailure"
	causeTable[118]="EnclosureDoorOpen"
	causeTable[119]="ExplosiveGas"
	causeTable[120]="Fire"
	causeTable[121]="Flood"
	causeTable[122]="HighHumidity"
	causeTable[123]="HighTemperature"
	causeTable[124]="HighWind"
	causeTable[125]="IceBuildUp"
	causeTable[127]="LowFuel"
	causeTable[128]="LowHumidity"
	causeTable[129]="LowCablePressure"
	causeTable[130]="LowTemperature"
	causeTable[131]="LowWater"
	causeTable[132]="Smoke"
	causeTable[133]="ToxicGas"
	causeTable[134]="CoolingSystemFailure"
	causeTable[135]="ExternalEquipmentFailure"
	causeTable[136]="ExternalPointFailure"
	causeTable[151]="StorageCapacityProblem"
	causeTable[152]="MemoryMismatch"
	causeTable[153]="CorruptData"
	causeTable[154]="OutOfCPUCycles"
	causeTable[155]="SoftwareEnvironmentProblem"
	causeTable[156]="SoftwareDownloadFailure"
	causeTable[157]="LossOfRealTimel"
	causeTable[158]="applicationSubsystemFailure"
	causeTable[159]="configurationOrCustomisationError"
	causeTable[160]="databaseInconsistency"
	causeTable[161]="fileError"
	causeTable[162]="outOfMemory"
	causeTable[163]="softwareError"
	causeTable[164]="timeoutExpired"
	causeTable[165]="underlayingResourceUnavailable"
	causeTable[166]="versionMismatch"
	causeTable[201]="bandwidthReduced"
	causeTable[202]="congestion"
	causeTable[203]="excessiveErrorRate"
	causeTable[204]="excessiveResponseTime"
	causeTable[205]="excessiveRetransmissionRate"
	causeTable[206]="reducedLoggingCapability"
	causeTable[207]="systemResourcesOverload"
	causeTable[301]="AdapterError"
	causeTable[302]="ApplicationSubsystemFailure"
	causeTable[303]="BandwidthReduced"
	causeTable[305]="CommunicationsProtocolError"
	causeTable[306]="CommunicationsSubsystemFailure"
	causeTable[307]="ConfigurationOrCustomizationError"
	causeTable[308]="Congestion"
	causeTable[310]="CpuCyclesLimitExceeded"
	causeTable[311]="DataSetOrModemError"
	causeTable[313]="DTEDCEInterfaceError"
	causeTable[315]="EquipmentMalfunction"
	causeTable[316]="ExcessiveVibration"
	causeTable[317]="FileError"
	causeTable[321]="HeatingOrVentilationOrCoolingSystemProblem"
	causeTable[322]="HumidityUnacceptable"
	causeTable[323]="InputOutputDeviceError"
	causeTable[324]="InputDeviceError"
	causeTable[325]="LANError"
	causeTable[326]="LeakDetected"
	causeTable[327]="LocalNodeTransmissionError"
	causeTable[330]="MaterialSupplyExhausted"
	causeTable[332]="OutOfMemory"
	causeTable[333]="OuputDeviceError"
	causeTable[334]="PerformanceDegraded"
	causeTable[336]="PressureUnacceptable"
	causeTable[339]="QueueSizeExceeded"
	causeTable[340]="ReceiveFailure"
	causeTable[342]="RemoteNodeTransmissionError"
	causeTable[343]="ResourceAtOrNearingCapacity"
	causeTable[344]="ResponseTimeExcessive"
	causeTable[345]="RetransmissionRateExcessive"
	causeTable[346]="SoftwareError"
	causeTable[347]="SoftwareProgramAbnormallyTerminated"
	causeTable[348]="SoftwareProgramError"
	causeTable[350]="TemperatureUnacceptable"
	causeTable[351]="ThresholdCrossed"
	causeTable[353]="ToxicLeakDetected"
	causeTable[354]="TransmitFailure"
	causeTable[356]="UnderlyingResourceUnavailable"
	causeTable[357]="VersionMismatch"
	causeTable[401]="AuthenticationFailure"
	causeTable[402]="BreachOfConfidentiality"
	causeTable[403]="CableTamper"
	causeTable[404]="DelayedInformation"
	causeTable[405]="DenialOfService"
	causeTable[406]="DuplicateInformation"
	causeTable[407]="InformationMissing"
	causeTable[408]="InformationModificationDetected"
	causeTable[409]="InformationOutOfSequence"
	causeTable[410]="IntrusionDetection"
	causeTable[411]="KeyExpired"
	causeTable[412]="NonRepudiationFailure"
	causeTable[413]="OutOfHoursActivity"
	causeTable[414]="OutOfService"
	causeTable[415]="ProceduralError"
	causeTable[416]="UnauthorizedAccessAttempt"
	causeTable[417]="UnexpectedInformation"
	causeTable[418]="UnspecifiedReason"
	causeTable[501]="AbisToBTSInterfaceFailure"
	causeTable[502]="AbisToTRXInterfaceFailure"
	causeTable[503]="AntennaProblem"
	causeTable[504]="BatteryBreakdown"
	causeTable[505]="BatteryChargingFault"
	causeTable[506]="ClockSynchronisationProblem"
	causeTable[507]="CombinerProblem"
	causeTable[508]="DiskProblem"
	causeTable[510]="ExcessiveReceiverTemperature"
	causeTable[511]="ExcessiveTransmitterOutputPower"
	causeTable[512]="ExcessiveTransmitterTemperature"
	causeTable[513]="FrequencyHoppingDegraded"
	causeTable[514]="FrequencyHoppingFailure"
	causeTable[515]="FrequencyRedefinitionFailed"
	causeTable[516]="LineInterfaceFailure"
	causeTable[517]="LinkFailure"
	causeTable[518]="LossOfSynchronisation"
	causeTable[519]="LostRedundancy"
	causeTable[520]="MainsBreakdownWithBatteryBackUp"
	causeTable[521]="MainsBreakdownWithoutBatteryBackUp"
	causeTable[522]="PowerSupplyFailure"
	causeTable[523]="ReceiverAntennaFault"
	causeTable[525]="ReceiverMulticouplerFailure"
	causeTable[526]="ReducedTransmitterOutputPower"
	causeTable[527]="SignalQualityEvaluationFault"
	causeTable[528]="TimeslotHardwareFailure"
	causeTable[529]="TransceiverProblem"
	causeTable[530]="TranscoderProblem"
	causeTable[531]="TranscoderOrRateAdapterProblem"
	causeTable[532]="TransmitterAntennaFailure"
	causeTable[533]="TransmitterAntennaNotAdjusted"
	causeTable[535]="TransmitterLowVoltageOrCurrent"
	causeTable[536]="TransmitterOffFrequency"
	causeTable[537]="DatabaseInconsistency"
	causeTable[538]="FileSystemCallUnsuccessful"
	causeTable[539]="InputParameterOutOfRange"
	causeTable[540]="InvalidParameter"
	causeTable[541]="InvalidPointer"
	causeTable[542]="MessageNotExpected"
	causeTable[543]="MessageNotInitialised"
	causeTable[544]="MessageOutOfSequence"
	causeTable[545]="SystemCallUnsuccessful"
	causeTable[546]="TimeoutExpired"
	causeTable[547]="VariableOutOfRange"
	causeTable[548]="WatchDogTimerExpired"
	causeTable[549]="CoolingSystemFailure"
	causeTable[550]="ExternalEquipmentFailure"
	causeTable[551]="ExternalPowerSupplyFailure"
	causeTable[552]="ExternalTransmissionDeviceFailure"
	causeTable[561]="ReducedAlarmReporting"
	causeTable[562]="ReducedEventReporting"
	causeTable[563]="ReducedLoggingCapability"
	causeTable[564]="SystemResourcesOverload"
	causeTable[565]="BroadcastChannelFailure"
	causeTable[566]="ConnectionEstablishmentError"
	causeTable[567]="InvalidMessageReceived"
	causeTable[568]="InvalidMSUReceived"
	causeTable[569]="LAPDLinkProtocolFailure"
	causeTable[570]="LocalAlarmIndication"
	causeTable[571]="RemoteAlarmIndication"
	causeTable[572]="RoutingFailure"
	causeTable[573]="SS7ProtocolFailure"
	causeTable[574]="TransmissionError"
	causeTable[600]="LocEndToEnd"
	causeTable[601]="AisEndToEnd"
	causeTable[602]="RdiEndToEnd"
	causeTable[603]="LocSegmentLinkSide"
	causeTable[604]="LocSegmentCoreSide"
	causeTable[605]="AisSegmentLinkSide"
	causeTable[606]="AisSegmentCoreSide"
	causeTable[607]="RdiSegmentLinkSide"
	causeTable[608]="RdiSegmentCoreSide"
	causeTable[1024]="other"
	causeTable[1600]="authenticationFailure"
	causeTable[1601]="breachOfConfidentiality"
	causeTable[1602]="cableTamper"
	causeTable[1603]="delayedInformation"
	causeTable[1604]="denialOfService"
	causeTable[1605]="duplicateInformation"
	causeTable[1606]="informationMissing"
	causeTable[1607]="informationModificationDetected"
	causeTable[1608]="informationOutOfSequence"
	causeTable[1609]="keyExpired"
	causeTable[1610]="nonRepudiationFailure"
	causeTable[1611]="outOfHoursActivity"
	causeTable[1612]="outOfService"
	causeTable[1613]="proceduralError"
	causeTable[1614]="unauthorizedAccessAttempt"
	causeTable[1615]="unexpectedInformation"
	causeTable[100500]="adapterError"
	causeTable[100501]="applicationSubsystemFailture"
	causeTable[100502]="bandwidthReduced"
	causeTable[100503]="callEstablishmentError"
	causeTable[100504]="communicationsProtocolError"
	causeTable[100505]="communicationsSubsystemFailure"
	causeTable[100506]="configurationOrCustomizationError"
	causeTable[100507]="congestion"
	causeTable[100508]="coruptData"
	causeTable[100509]="cpuCyclesLimitExceeded"
	causeTable[100510]="dataSetOrModemError"
	causeTable[100511]="degradedSignal"
	causeTable[100512]="dteDceInterfaceError"
	causeTable[100513]="enclosureDoorOpen"
	causeTable[100514]="equipmentMalfunction"
	causeTable[100515]="excessiveVibration"
	causeTable[100516]="fileError"
	causeTable[100517]="fireDetected"
	causeTable[100518]="framingError"
	causeTable[100519]="heatingVentCoolingSystemProblem"
	causeTable[100520]="humidityUnacceptable"
	causeTable[100521]="inputOutputDeviceError"
	causeTable[100522]="inputDeviceError"
	causeTable[100523]="lanError"
	causeTable[100524]="leakDetected"
	causeTable[100525]="localNodeTransmissionError"
	causeTable[100526]="lossOfFrame"
	causeTable[100527]="lossOfSignal"
	causeTable[100528]="materialSupplyExhausted"
	causeTable[100529]="multiplexerProblem"
	causeTable[100530]="outOfMemory"
	causeTable[100531]="ouputDeviceError"
	causeTable[100532]="performanceDegraded"
	causeTable[100533]="powerProblems"
	causeTable[100534]="pressureUnacceptable"
	causeTable[100535]="processorProblems"
	causeTable[100536]="pumpFailure"
	causeTable[100537]="queueSizeExceeded"
	causeTable[100538]="receiveFailure"
	causeTable[100539]="receiverFailure"
	causeTable[100540]="remoteNodeTransmissionError"
	causeTable[100541]="resourceAtOrNearingCapacity"
	causeTable[100542]="responseTimeExecessive"
	causeTable[100543]="retransmissionRateExcessive"
	causeTable[100544]="softwareError"
	causeTable[100545]="softwareProgramAbnormallyTerminated"
	causeTable[100546]="softwareProgramError"
	causeTable[100547]="storageCapacityProblem"
	causeTable[100548]="temperatureUnacceptable"
	causeTable[100549]="thresholdCrossed"
	causeTable[100550]="timingProblem"
	causeTable[100551]="toxicLeakDetected"
	causeTable[100552]="transmitFailure"
	causeTable[100553]="transmiterFailure"
	causeTable[100554]="underlyingResourceUnavailable"
	causeTable[100555]="versionMismatch"
	causeTable[999999999]="Moshell generated alarm"

	causeTableMade=1

	if (comcli==0)
	{
		causeTable[0]="indeterminate"
		causeTable[1]="alarm_indication_signal"
		causeTable[2]="call_setup_failure"
		causeTable[3]="degraded_signal"
		causeTable[4]="far_end_receiver_failure"
		causeTable[5]="framing_error"
		causeTable[6]="loss_of_frame"
		causeTable[7]="loss_of_pointer"
		causeTable[8]="loss_of_signal"
		causeTable[9]="payload_type_mismatch"
		causeTable[10]="transmission_error"
		causeTable[11]="remote_alarm_interface"
		causeTable[12]="excessive_bit_error_rate"
		causeTable[13]="path_trace_mismatch"
		causeTable[14]="unavailable"
		causeTable[15]="signal_label_mismatch"
		causeTable[16]="loss_of_multi_frame"
		causeTable[51]="back_plane_failure"
		causeTable[52]="data_set_problem"
		causeTable[53]="equipment_identifier_duplication"
		causeTable[54]="external_device_problem"
		causeTable[55]="line_card_problem"
		causeTable[56]="multiplexer_problem"
		causeTable[57]="ne_identifier_duplication"
		causeTable[58]="power_problem"
		causeTable[59]="processor_problem"
		causeTable[60]="protection_path_failure"
		causeTable[61]="receiver_failure"
		causeTable[62]="replaceable_unit_missing"
		causeTable[63]="replaceable_unit_type_mismatch"
		causeTable[64]="synchronisation_source_mismatch"
		causeTable[65]="terminal_problem"
		causeTable[66]="timing_problem"
		causeTable[67]="transmitter_failure"
		causeTable[68]="trunk_card_problem"
		causeTable[69]="replaceable_unit_problem"
		causeTable[101]="air_compressor_failure"
		causeTable[102]="air_conditioning_failure"
		causeTable[103]="air_dryer_failure"
		causeTable[104]="battery_discharging"
		causeTable[105]="battery_failure"
		causeTable[106]="commercial_power_failure"
		causeTable[107]="cooling_fan_failure"
		causeTable[108]="engine_failure"
		causeTable[109]="fire_detector_failure"
		causeTable[110]="fuse_failure"
		causeTable[111]="generator_failure"
		causeTable[112]="low_battery_threshold"
		causeTable[113]="pump_failure"
		causeTable[114]="rectifier_failure"
		causeTable[115]="rectifier_high_voltage"
		causeTable[116]="rectifier_low_f_voltage"
		causeTable[117]="ventilation_system_failure"
		causeTable[118]="enclosure_door_open"
		causeTable[119]="explosive_gas"
		causeTable[120]="fire"
		causeTable[121]="flood"
		causeTable[122]="high_humidity"
		causeTable[123]="high_temperature"
		causeTable[124]="high_wind"
		causeTable[125]="ice_build_up"
		causeTable[127]="low_fuel"
		causeTable[128]="low_humidity"
		causeTable[129]="low_cable_pressure"
		causeTable[130]="low_temperature"
		causeTable[131]="low_water"
		causeTable[132]="smoke"
		causeTable[133]="toxic_gas"
		causeTable[151]="storage_capacity_problem"
		causeTable[152]="memory_mismatch"
		causeTable[153]="corrupt_data"
		causeTable[154]="out_of_cpu_cycles"
		causeTable[155]="software_environment_problem"
		causeTable[156]="software_download_failure"
		causeTable[301]="adapter_error"
		causeTable[302]="application_subsystem_failure"
		causeTable[303]="bandwidth_reduction"
		causeTable[305]="communication_protocol_error"
		causeTable[306]="communication_subsystem_failure"
		causeTable[307]="configuration_or_customizing_error"
		causeTable[308]="congestion"
		causeTable[310]="cpu_cycles_limit_exceeded"
		causeTable[311]="data_set_or_modem_error"
		causeTable[313]="dte_dce_interface_error"
		causeTable[315]="equipment_malfunction"
		causeTable[316]="excessive_vibration"
		causeTable[317]="file_error"
		causeTable[321]="heating_or_ventilation_or_cooling_system"
		causeTable[322]="humidity_unacceptable"
		causeTable[323]="input_output_device_error"
		causeTable[324]="input_device_error"
		causeTable[325]="lan_error"
		causeTable[326]="leak_detection"
		causeTable[327]="local_node_transmission_error"
		causeTable[330]="material_supply_exhausted"
		causeTable[332]="out_of_memory"
		causeTable[333]="output_device_error"
		causeTable[334]="performance_degraded"
		causeTable[336]="pressure_unacceptable"
		causeTable[339]="queue_size_exceeded"
		causeTable[340]="receive_failure"
		causeTable[342]="remote_node_transmission_error"
		causeTable[343]="resource_at_or_nearing_capacity"
		causeTable[344]="response_time_excessive"
		causeTable[345]="retransmission_rate_excessive"
		causeTable[346]="software_error"
		causeTable[347]="software_program_abnormally_terminated"
		causeTable[348]="software_program_error"
		causeTable[350]="temperature_unacceptable"
		causeTable[351]="threshold_crossed"
		causeTable[353]="toxic_leak_detected"
		causeTable[354]="transmit_failure"
		causeTable[356]="underlying_resource_unavailable"
		causeTable[357]="version_mismatch"
		causeTable[401]="authentication_failure"
		causeTable[402]="breach_of_confidentiality"
		causeTable[403]="cable_tamper"
		causeTable[404]="delayed_information"
		causeTable[405]="denial_of_service"
		causeTable[406]="duplicate_information"
		causeTable[407]="information_missing"
		causeTable[408]="information_modification_detected"
		causeTable[409]="information_out_of_sequence"
		causeTable[410]="intrusion_detected"
		causeTable[411]="key_expired"
		causeTable[412]="non_repudiation_failure"
		causeTable[413]="out_of_hours_activity"
		causeTable[414]="out_of_service"
		causeTable[415]="procedural_error"
		causeTable[416]="unauthorized_access_attempt"
		causeTable[417]="unexpected_information"
		causeTable[418]="unspecified_reason"
		causeTable[501]="a_bis_to_bts_interface_failure"
		causeTable[502]="a_bis_to_trx_interface_failure"
		causeTable[503]="antenna_problem"
		causeTable[504]="battery_breakdown"
		causeTable[505]="battery_charging_fault"
		causeTable[506]="clock_synchronisation_problem"
		causeTable[507]="combiner_problem"
		causeTable[508]="disk_problem"
		causeTable[510]="excessive_receiver_temperature"
		causeTable[511]="excessive_transmitter_output_power"
		causeTable[512]="excessive_transmitter_temperature"
		causeTable[513]="frequency_hopping_degraded"
		causeTable[514]="frequency_hopping_failure"
		causeTable[515]="frequency_redefinition_failed"
		causeTable[516]="line_interface_failure"
		causeTable[517]="link_failure"
		causeTable[518]="loss_of_synchronisation"
		causeTable[519]="lost_redundancy"
		causeTable[520]="mains_breakdown_with_battery_backup"
		causeTable[521]="mains_breakdown_without_battery_backup"
		causeTable[522]="power_supply_failure"
		causeTable[523]="receiver_antenna_fault"
		causeTable[525]="receiver_multicoupler_failure"
		causeTable[526]="reduced_transmitter_output_power"
		causeTable[527]="signal_quality_evaluation_fault"
		causeTable[528]="timeslot_hardware_failure"
		causeTable[529]="transceiver_problem"
		causeTable[530]="transcoder_problem"
		causeTable[531]="transcoder_or_rate_adapter_problem"
		causeTable[532]="transmitter_antenna_failure"
		causeTable[533]="transmitter_antenna_not_adjusted"
		causeTable[535]="transmitter_low_voltage_or_current"
		causeTable[536]="transmitter_off_frequency"
		causeTable[537]="database_inconsistency"
		causeTable[538]="file_system_call_unsuccessful"
		causeTable[539]="input_parameter_out_of_range"
		causeTable[540]="invalid_parameter"
		causeTable[541]="invalid_pointer"
		causeTable[542]="message_not_expected"
		causeTable[543]="message_not_initialised"
		causeTable[544]="message_out_of_sequence"
		causeTable[545]="system_call_unsuccessful"
		causeTable[546]="timeout_expired"
		causeTable[547]="variable_out_of_range"
		causeTable[548]="watch_dog_timer_expired"
		causeTable[549]="cooling_system_failure"
		causeTable[550]="external_equipment_failure"
		causeTable[551]="external_power_supply_failure"
		causeTable[552]="external_transmission_device_failure"
		causeTable[561]="reduced_alarm_reporting"
		causeTable[562]="reduced_event_reporting"
		causeTable[563]="recuced_logging_capability"
		causeTable[564]="system_resources_overload"
		causeTable[565]="broadcast_channel_failure"
		causeTable[566]="call_establishment_error"
		causeTable[567]="invalid_message_received"
		causeTable[568]="invalid_msu_received"
		causeTable[569]="lapd_link_protocol_failure"
		causeTable[570]="local_alarm_indication"
		causeTable[571]="remote_alarm_indication"
		causeTable[572]="routing_failure"
		causeTable[573]="ss7_protocol_failure"
		causeTable[574]="transmission_failure"
	}
}
function make_short_ru(string,trdev,   array,last,i,res)
{
	#RbsSubrack=RU1,RbsSlot=2,AuxPlugInUnit=1
	#SectorAntenna=1,AuxPlugInUnit=RRUW-1
	#ManagedElement=1,Equipment=1,Subrack=2,Slot=10,PlugInUnit=1,TrxDeviceGroup=1,TrDeviceSet=1,TrDevice=1
	last=split(string,array,",")
	res=""
	for (i=1;i<=last;i++)
	{
		if ((trdev=="trdev"&&array[i]~/^TrDevice=/)||\
		    (array[i]~/^(SectorAntenna|RbsSubrack|RbsSlot|AuxPlugInUnit|Subrack|Slot|CuSubrack|McpaSubrack|PowerSupplySubrack|ExternalAntenna|FieldReplaceableUnit)=/))
		{
			res=res gensub(/^.*=/,"",1,array[i]) "/"
		}
	}
	sub(/\/$/,"",res)
	return res
}
function make_long_ru(string, a,n)
{
	if (comcli>0) res="Equipment=1,FieldReplaceableUnit="string
	else
	{
		n=split(string,a,"/")
		if (n==3) res="Equipment=1,RbsSubrack="a[1]",RbsSlot="a[2]",AuxPlugInUnit="a[3]
		else res="Equipment=1,AuxPlugInUnit="string
	}
	return res
}
function convert_modname_tonumber(modname,what,    result)
{
	#Old convention, used on single core GPB (GPB6 and less). (RncModule::programInstanceId=0)
	#MS-6-0    ---> 60 	ES-1-6-0  ---> 61
	#MS-12-0   ---> 120	ES-1-13-0 ---> 131
	#MS-17-0   ---> 170	ES-1-16-0 ---> 161
	#MS-20-0   ---> 200	ES-1-20-0 ---> 201
	#MS-23-0   ---> 230	ES-1-23-0 ---> 231
	#New convention, used on multiple core GPB (GPB7 and higher) (RncModule::programInstanceId>0)
	#MS-6-0    ---> 1060 	ES-1-6-0  ---> 2060
	#MS-6-1    ---> 1061 	ES-1-6-1  ---> 2061
	#MS-6-2    ---> 1062 	ES-1-6-2  ---> 2062
	#MS-12-0   ---> 1120	ES-1-13-0 ---> 2130
	#MS-12-1   ---> 1121	ES-1-13-1 ---> 2131
	#MS-12-2   ---> 1122	ES-1-13-2 ---> 2132
	#MS-17-0   ---> 1170	ES-1-16-0 ---> 2160
	#MS-17-1   ---> 1171	ES-1-16-1 ---> 2161
	#MS-17-2   ---> 1172	ES-1-16-2 ---> 2162
	#MS-20-0   ---> 1200	ES-1-20-0 ---> 2200
	#MS-20-1   ---> 1201	ES-1-20-1 ---> 2201
	#MS-20-2   ---> 1202	ES-1-20-2 ---> 2202
	#MS-23-0   ---> 1230	ES-1-23-0 ---> 2230
	#MS-23-1   ---> 1230	ES-1-23-1 ---> 2231
	#MS-23-2   ---> 1230	ES-1-23-2 ---> 2232
	#MS-5-4    ---> 1054
	sub(/^.*=/,"",modname)
	if ((modname+0) > 0) return modname   #Example: RncModule=13
	sub(/MS|ES-?/,"",modname)
	split(modname,array,"-")
	if (what=="" && array[3] > 0) what="new"
	if (what=="new") result=sprintf("%s%02d%s",array[1]+1,array[2],array[3])+0
	else result=sprintf("%s%s",array[2],array[1]+0)+0
	return result
}
function s2me(string)
{
	return "Me="gensub(/^..=|,.*$/,"","g",string)
}

function l2m(string,force,   array,last,i,dn,thisisaldn,me,tmoc)
{
	if (yangcli>0) return string
	if (string!~"=") return string   #could be a MO class
	#convert the string (ldn/fdn/mediummo) to a medium mo
	me=""
	if (multi || multioffline)
	{
		#should be able to convert any of the following formats, case insensitive
		#Me=rnc11,ManagedElement=1,TransportNetwork=1,Aal2PathVccTp=Iub-1-47
		#Me=rnc11,TransportNetwork=1,Aal2PathVccTp=Iub-1-47
		#Me=rnc11,Aal2PathVccTp=Iub-1-47
		#ManagedElement=1,TransportNetwork=1,Aal2PathVccTp=Iub-1-47
		#TransportNetwork=1,Aal2PathVccTp=Iub-1-47
		#Aal2PathVccTp=Iub-1-47
		if (tolower(string) ~ /^me=/) me=s2me(string)","
		sub(/^[Mm][Ee]=[^,]+,/,"",string)
	}
	if (string ~ /,[Mm]anaged[Ee]lement=[^,]+$/) sub(/^.*,/,"",string) #special case for the ManagedElement MO when it has a mib prefix
	if (string ~ /[Mm]anaged[Ee]lement=[^,]+,/) thisisaldn=1
	sub(/^.*[Mm]anaged[Ee]lement=[^,]+,/,"",string)
	last=split(string,array,",")
	tmoc=tolower(gensub(/=.*$/,"",1,array[last]))
	#print string,tmoc,ambiguousMO[tmoc]
	if (last <= 1) {} #return me string
	else if (momRats ~ "N" && ambiguousMOAll[tmoc]==1){}
	else
	{
		#only convert if it is not already a MediumMo
		if (tolower(string) ~ tolower(directMeChildrenString) || thisisaldn==1)
		{
			for (i=2;i<=last;i++)
			{
				dn=dn","array[i]
			}
			return me gensub(/^,/,"",1,dn)
		}
	}
	return me string
}
function m2l(string, rootclass)
{
	if (yangcli>0) return string
	#convert a mediumMo to a Mo
	#if the MO is in the proxy table
	if (string in MoProxy) return p2s("Mo",MoProxy[string])
	#else: eg. if we are not connected to the same node, eg in the function convertattribute: we use the sorted_parent_list
	rootclass=gensub(/=.*$/,"",1,string)
	if (comcli>0) rootclass=t2ecimt(rootclass)
	if (rootclass in sorted_parentList && sorted_parentList[rootclass] !~ ";" && sorted_parentList[rootclass] != "ManagedElement")
	{
		return cutmoc(sorted_parentList[rootclass])"=1,"string
	}
	#else just return the string untouched
	return string
}
function s2p(string,   l2m_string)
{
	#return the proxy id for a ldn/mediumMo (both lowercase and normal)
	#print "Searching FOR STRING:"string
	l2m_string=l2m(string)
	if (l2m_string in MoProxy && MoProxy[l2m_string] != "")
	{
		#print 1,l2m_string,MoProxy[l2m_string]
		return MoProxy[l2m_string]
	}
	else
	{
		#print 2,tolower(l2m_string),MoProxy[tolower(l2m_string)]
		return MoProxy[tolower(l2m_string)]
	}
}
function s2t(string,   last,array,res,tprox,tstring,i,part,a,n,tpath)
{
	#return the motype of a dn
	last=split(string,array,",")
	split(array[last],array,"=")
	gsub(" ","",array[1])
	res=array[1]
	#print "s2t: "comcli,string
	if (comcli>0)
	{
		#print "s2t0: "string,s2p(string),mimTable[s2p(string)]
		tprox=s2p(string)
		if (tprox in mimTable && mimTable[tprox]!="") res=mimTable[tprox]"."res
		else
		{
			if (string !~ "ManagedElement=") string="ManagedElement=1,"string
			last=split(string,part,",")
			for (i=1;i<=last;i++) tstring=tstring"."gensub(/=.*$/,"",1,part[i])
			#print tstring,mimMap[tstring]
			#mimTable[maxProxy]=mimMap[tstring]
			if (tstring in mimMap && mimMap[tstring]!="") res=mimMap[tstring]"."res
			else if (res in simpleMimMap && simpleMimMap[res]!="") res=simpleMimMap[res]"."res
			#tmpclass=tolower(mimTable[maxProxy]"."gensub(/=.*$/,"",1,array[last]))
		}
	}
	else if (yangcli>0)
	{
		n=split(string,a,",")
		for (i=2;i<=n;i++) tpath=tpath gensub(/=.*$/,"",1,a[i])","
		sub(/,$/,"",tpath)
		if (a[1]~/^Me=[^,]+$/) res=mom_path2moc[momVersion[a[1]]"."tpath]
		else res=gensub(/=.*$/,"",1,a[n])
		#print "s2t: "string,res
	}
	return res
}
function t2ecimt(string,what,resT,   res,i)
{
	#print "t2ecimt: "string
	#returns the complete ecim MO type with MOM fragment as prefix eg: ManagedElement -> ComTop.ManagedElement
	#note: this does not work if there is the same MO class in several MOM fragments so it should only be used on MO classes that we know dont exist in several MOM fragments
	if (comcli==0) return string
	res=string
	if (what=="lower")
	{
		string=tolower(string)
	 	if (string in com_moclass_list && com_moclass_list[string]!="") string=com_moclass_list[string]
	}
	for (i in mom_moclass_list)
	{
		if (i ~ sprintf("^.+\\.%s$",string))
		{
			res=i
			if (what=="toTable") resT[res]=1
		}
	}
	return res
}
function correct_moclass_case(string,   i)
{
	if (comcli>0) return string
	if (string in mom_moclass_list && mom_moclass_list[string]!="") return string
	if (tolower(string) in tolower_mom_moclass_list && tolower_mom_moclass_list[tolower(string)]!="")
	{
		for (i in mom_moclass_list)
		{
			if (tolower(i)==tolower(string)) return i
		}
	}
	return string
}
function mDiv(numerator,denominator)
{
	if (denominator+0 == 0) return "N/A"
	return numerator / denominator
}
function defineErrorCodes(   i)
{
	#for cellRoState:
	cellRoTrans["1"]="NotOK"
	cellRoTrans["2"]="OK"
	cellRoTrans["3"]="DepNotOK"
	#for celldata:errorstatus
	errTrans["16000"]="CellDeactivated"
	errTrans["16001"]="CellReconfFailed"
	errTrans["16002"]="CellNoDrhResources"
	errTrans["16003"]="CellNbapTimeout"
	errTrans["16004"]="CellNbapFailed"
	errTrans["16005"]="CellSpConfigureFailed"
	errTrans["16006"]="CellRncNotAbleToScheduleSibs"
	errTrans["16007"]="CellMaxNumberOfSystemInformationUpdateReattemptsReached"
	errTrans["16008"]="CellRbsMalfunction"
	errTrans["16009"]="CellSpNotAvailable"
	errTrans["16010"]="CellCongCtrlMeasFailed"
	errTrans["16011"]="CellAdmCtrlMeasFailed"
	errTrans["16012"]="CellRbsLocalCellNotAdded"
	errTrans["-1"]   ="CellServiceUnavailable"
	errTrans["16014"]="CellNbapReconfigurationFailed"
	errTrans["15"]   ="CellSize"

	for (i in errTrans) lmid_code_list[sprintf("UtranCell Error: %-10s = %s",i,errTrans[i])]=sprintf("UtranCell Error: %-10s = %s",i,errTrans[i])
}
function com_up_translate(string,theSwRelease,replace,    rel)
{
	rel=up_translate(string,"short",theSwRelease)
	if (rel=="" && string in savedUpTranslation && savedUpTranslation[string]!="") rel=savedUpTranslation[string]
	if (replace=="replace") return rel
	if (rel!="") rel=" ("rel")"
	else if (theSwRelease!="") rel=" ("theSwRelease")"
	return string rel
}
function up_translate(string,short,theSwRelease,    array,pn,result,stringfound,res)
{
	#printf "up_translate: "string
	buildLmidTable()
	result=""
	stringfound=""
	if (string in upidTable && upidTable[string]!="") stringfound=string
	else if (string ~ /_R[0-9]+[A-Z]+[/]?[0-9]+$/ && gensub(/[/]?[0-9]+$/,"",1,string) in upidTable && upidTable[gensub(/[/]?[0-9]+$/,"",1,string)] != "") stringfound=gensub(/[/]?[0-9]+$/,"",1,string)
	#print " "stringfound
	if (stringfound!="")
	{
		res=upidTable[stringfound]
		if ((short=="short")||(string in cppidTable && cppidTable[string]!=""))
		{
			sub(/ +\(.*$/,"",res)
			sub(/^ +/,"",res)
			if (string in cppidTable && cppidTable[string]!="" && short!="short") res=res" ("cppidTable[string]")"
		}
		return res
	}
	split(string,array,"_")
	#we try first with the whole product number, then without the suffix. first we look in uptorelTable, then uptomomTable
	result=sub_up_translate(string,short,uptorelTable,array[1],theSwRelease)
	if (result != "") return result
	result=sub_up_translate(string,short,uptorelTable,gensub(/(%|\/)[0-9]+$/,"",1,array[1]),theSwRelease)
	if (result != "") return result
	result=sub_up_translate(string,short,uptomomTable,array[1],theSwRelease)
	if (result != "") return result
	result=sub_up_translate(string,short,uptomomTable,gensub(/(%|\/)[0-9]+$/,"",1,array[1]),theSwRelease)
	if (result != "") return result
	return ""
}
function sub_up_translate(string,short,relationTable,pn,theSwRelease,    result)
{
	result=""
	if (pn in relationTable && relationTable[pn]!="")
	{
		if (short != "short" && string in cppidTable && cppidTable[string]!="") result= relationTable[pn]" ("cppidTable[string]")"
		else result=relationTable[pn]
	}
	#special case for RNC W13, same product number for both tracks R1 for W13A and R2/R71/R88 for W13B
	if (pn=="CXP9021775" && result ~ /^W13( |$)/)
	{
		if (string ~ "R1") sub(/^W13/,"W13A",result)
		else if (string ~ "R(2|3|4|5|71|88)") sub(/^W13/,"W13B",result)
	}
	#special case for MSRBSV2 15B, same product number for 15B and 16A but different revision, R16 and above is 16A
	else if (pn=="CXP9024418/1" && string ~ /R1[0-5]/) result="15B"
	#special case for MSRBSV2 17, same product number for 17B, 17Q1, 17Q2, etc but different revision
	#find the translation by doing: grep '<release>' /proj/wcdmaiov/gen2up/CXP9024418_6-R*/CXP9024418_6-up.xml
	else if (pn=="CXP9024418/6" || pn=="CXP102051/27" || pn=="CXP9024419/6")
	{
		#17.Q1 Maintenance Track UPs have nn = 5
		#17.Q2 Maintenance Track UPs have nn = 12
		#17.Q3 Maintenance Track UPs would get nn = 21
		#17.Q4 Maintenance Track UPs would get nn = 28
		#
		#18.Q1 Maintenance Track UPs would get nn = 34
		#18.Q2 Maintenance Track UPs would get nn = 42
		#18.Q3 Maintenance Track UPs would get nn = 47
		#18.Q4 Maintenance Track UPs would get nn = 54

		if (pn~/^(CXP902441[89]\/6)$/ && theSwRelease!="") result=theSwRelease
		else if (pn~/^(CXP902441[89]\/6)$/ && string in savedUpTranslation && savedUpTranslation[string]!="") result=savedUpTranslation[string]
		else if (string ~ /R[1-4][A-Z]/) result="17B"
		else if (string ~ /R5[A-Z]/) result="17.Q1"                 # R5
		else if (string ~ /R([6-9]|1[0-2])[A-Z]/)  result="17.Q2"   # R6-R12
		else if (string ~ /R(1[3-9]|2[0-1])[A-Z]/) result="17.Q3"   # R13-R21
		else if (string ~ /R2[2-8][A-Z]/)          result="17.Q4"   # R22-R28
		else if (string ~ /R(29|3[0-4])[A-Z]/)     result="18.Q1"   # R29-R34
		else if (string ~ /R(3[5-9]|4[0-2])[A-Z]/) result="18.Q2"   # R35-R42
		else if (string ~ /R4[3-8][A-Z]/)          result="18.Q3"   # R43-R48
		else if (string ~ /R49[A-Z]|R5[0-5][A-Z]/) result="18.Q4"   # R49-R55
		else if (string ~ /R(5[6-9]|60)[A-Z]/)     result="19.Q1"   # R56-R60
		else if (string ~ /R6[1-7][A-Z]/)          result="19.Q2/1" # R60-R67
		else if (string ~ /R6[8-9][A-Z]/)          result="19.Q2/2" # R68-R69
		else if (string ~ /R7[0-3][A-Z]/)          result="19.Q3"   # R70-73
		else if (string ~ /R(7[4-9]|8[0-2])[A-Z]/) result="19.Q4"   # R74-82
		else if (string ~ /R8([3-4][A-Z]|5[A-G])/) result="20.Q1"   # R83-85G
		else result="DUSMAINT" #R85H and above
		#else result="19.Q1"
		if (pn=="CXP102051/27" && result!~/^($|ERBS_)/)
		{
			if (result!~/^DUSMAINT/) result="L" result
			if (short != "short" && string in cppidTable && cppidTable[string]!="") result= result" ("cppidTable[string]")"
		}
	}
	else if (pn=="CXP9024418/12") # G2 C2
	{
		if (pn~/^(CXP9024418\/12)$/ && theSwRelease!="") result=theSwRelease
		else if (pn~/^(CXP9024418\/12)$/ && string in savedUpTranslation && savedUpTranslation[string]!="") result=savedUpTranslation[string]
		else if (string ~ /R1[2-7][A-Z]/)          result="18.Q1"   #R12-R17
		else if (string ~ /R(1[89]|2[01])[A-Z]/)   result="18.Q2"   #R18-R21
		else if (string ~ /R2[2-7][A-Z]/)          result="18.Q3"   #R22-R27
		else if (string ~ /R(2[89]|3[0-1])[A-Z]/)  result="18.Q4"   #R28-R31
		else if (string ~ /R32[A-Z]/)              result="19.Q1"   #R32
		else if (string ~ /R3[3-9][A-Z]/)          result="19.Q2/1" #R33-R39
		else if (string ~ /R4[0-1][A-Z]/)          result="19.Q2/2" #R40-41
		else if (string ~ /R4[2-5][A-Z]/)          result="19.Q3"   #R42-45
		else if (string ~ /R(4[6-9]|5[0-2])[A-Z]/) result="19.Q4"   #R46-52
		else if (string ~ /R5[3-7][A-Z]/)          result="20.Q1"   #R53-57
		else if (string ~ /R(5[8-9]|6[0-4])[A-Z]/) result="20.Q2"   #R58-64
		else if (string ~ /R(6[5-9]|70)[A-Z]/)     result="20.Q3"   #R65-70
		else if (string ~ /R7[1-7][A-Z]/)          result="20.Q4"   #R71-77
		else if (string ~ /R(7[89]|8[01])[A-Z]/)   result="21.Q1"   #R78-81
		else if (string ~ /R8[2-7][A-Z]/)          result="21.Q2"   #R82-87
	}
	else if (pn=="CXP9024418/15" || pn=="CXP2010171/1" || pn=="CXP2010174/1" || pn=="CXP9024418/22") result=translate_up_rel(pn,string)
	return result
}
function convertSeconds(string,format,   toWhat,result,nrOfDays,nrOfHours,nrOfMinutes,nrOfSeconds,totalNrOfSeconds,nr_of_mins)
{
	#format=="" ---> output is like: 100 seconds (1 minutes, 40 seconds)
	#format==1  ---> output is like: 100s (01m40s)
	#format==3  ---> output only shows the highest two fields, eg 5d3h instead of 5d3h04m15s
	#format==4  ---> output always like 0m43s or 3m21s or 67m42s
	#format==5  ----> output same like format 3 but does not put the seconds in front
	string=int(string+0)  #no float
	totalNrOfSeconds=string+0
	if (totalNrOfSeconds < 0) return ""
	if (string >= 86400)  toWhat="toDays"
	else if (string >= 3600)   toWhat="toHours"
	if (toWhat=="toDays")
	{
		nrOfDays=int(string/(3600*24))
		string=string%(3600*24)
		nrOfHours=int(string/(3600))
		string=string%3600
	}
	else if (toWhat=="toHours")
	{
		nrOfHours=int(string/(3600))
		string=string%3600
	}
	nrOfMinutes=int(string/60)
	nrOfSeconds=(string%(3600))%60
	if (format == "")
	{
		#if (string ~ /\./) result=sprintf("%s seconds",totalNrOfSeconds)
		result=sprintf("%s seconds",totalNrOfSeconds)
		if (totalNrOfSeconds < 60) return result
		else result=sprintf("%s (",result)
		if (toWhat=="toDays") result=sprintf("%s%s days, %s hours, ",result,nrOfDays,nrOfHours)
		else if (toWhat=="toHours") result=sprintf("%s%s hours, ",result,nrOfHours)
		result=sprintf("%s%s minutes, %s seconds)",result,nrOfMinutes,nrOfSeconds)
	}
	else if (format==3)
	{
		result=totalNrOfSeconds"s"
		if (totalNrOfSeconds < 60) return result
		if (nrOfDays != "") result=sprintf("%s (%sd%sh)",result,nrOfDays,nrOfHours)
		else if (nrOfHours != "") result=sprintf("%s (%sh%sm)",result,nrOfHours,nrOfMinutes)
		else if (nrOfMinutes != "") result=sprintf("%s (%sm%ss)",result,nrOfMinutes,nrOfSeconds)
	}
	else if (format==4)
	{
		nr_of_mins=int(totalNrOfSeconds/60)
		nr_of_secs=totalNrOfSeconds%60
		result=sprintf("%sm%02ds",nr_of_mins,nr_of_secs)
	}
	else if (format==5)
	{
		result=totalNrOfSeconds"s"
		if (totalNrOfSeconds < 60) return result
		if (nrOfDays != "") result=sprintf("%sd%sh",nrOfDays,nrOfHours)
		else if (nrOfHours != "") result=sprintf("%sh%sm",nrOfHours,nrOfMinutes)
		else if (nrOfMinutes != "") result=sprintf("%sm%ss",nrOfMinutes,nrOfSeconds)
	}
	else
	{
		if (format==1)
		{
			result=totalNrOfSeconds"s"
			if (totalNrOfSeconds < 60) return result
			else result=sprintf("%s (",result)
		}
		else if (format==2 && totalNrOfSeconds < 60) return sprintf("%ss",totalNrOfSeconds)
		if (nrOfDays != "") result=sprintf("%s%sd",result,nrOfDays)
		if (nrOfHours != "") result=sprintf("%s%sh",result,nrOfHours)
		if (nrOfMinutes != "") result=sprintf("%s%02dm",result,nrOfMinutes)
		result=sprintf("%s%02ds",result,nrOfSeconds)
		if (format==1) result=sprintf("%s)",result)
	}
	return result
}
function make_timestamp(date,time,   datearray,timearray,array)
{
	#if the first argument contains both the date and time, we extract the time
	if (date ~ /^[1-2][0-9][0-9][0-9]-?[0-1][0-9]-?[0-3][0-9].[0-2][0-9]/)
	{
		time=gensub(/^[1-2][0-9][0-9][0-9]-?[0-1][0-9]-?[0-3][0-9]./,"",1,date)
	}

	#possible formats (time is optional, seconds are optional, minutes are optional)
	# 2006-03-10 15:10:30
	# 2006-03-10 15:10
	# 20060310 151030
	# 20060310 1510
	if (date !~ "-")
	{
		split(date,array,"")
		datearray[1]=array[1] array[2] array[3] array[4]
		datearray[2]=array[5] array[6]
		datearray[3]=array[7] array[8]
		split(time,array,"")
		timearray[1]=array[1] array[2]
		timearray[2]=array[3] array[4]
		timearray[3]=array[5] (array[6]+0)
	}
	else
	{
		split(date,datearray,"-")
		split(time,timearray,":")
	}
	return mymktime(sprintf("%s %s %s %s %s %s",datearray[1],datearray[2],datearray[3],timearray[1]+0,timearray[2]+0,timearray[3]+0))
}
function wait_cpp_ssh(secs,what,   usecs)
{
	#wait 1 sec before ssh or sftp login on CPP node to make sure the previous ssh session is fully closed
	#otherwise, a subsequent ssh/sftp session may fail if initiated straight after and the total number of connected ssh sessions is close to the maximum allowed in SshTelnetSessions
	#also after sftp exit we wait 1 sec since very often a sftp session is followed (and/or preceded) by a ssh session, eg lh command
	#so in the case of sftp we wait 1 sec before and 1 sec after
	if (comcli!=0) return  #only applicable for cpp
	#normally we wait only if secure_shell==1, except in the case of sftp login we always wait 1 second in case a sftp had been done just before
	#the parameter what=1 is used at sftp login only
	if (secure_shell==1  || what==1)
	{
		if (secs=="") secs=1
		usecs=secs * 1000000
		if (mosdebug==1) print "DEBUG: wait "secs" seconds for ssh session close"
		usleep(usecs)
	}
}
function wait_http(secs,  usecs)
{
	if (secs=="") secs=1
	usecs=secs * 1000000
	if (mosdebug==1) print "DEBUG: wait "secs" seconds for next http retry attempt"
	usleep(usecs)
}
function tid(n,   a,b,d)
{
	if (mosdebug==1 || amos_debug>0)
	{
		if (n=="") n=0
		a=systime()
		b=strftime("%H%M%S",a)
		d=0
		if (tid_last_time>0) d = a - tid_last_time
		customPrint("DEBUG "n": Current time: "b". delta="d" seconds.")
		tid_last_time=a
	}
}
function charToAscii(c,asciiMapTable)
{
     return asciiMapTable[c]
}

# Takes a character as input, and returns the numerical index of that character
# in the bchars string
function getBcharIndex(c,bchars,   i)
{
     for( i = 1; i <= length(bchars); i++ )
     {
	  if( c == substr(bchars, i, 1) )
	       return i - 1
     }
     return -1
}

# This function takes a 24-bit integer as input, and returns a string of up to 4 characters
function getEncSubstr(s,bchars,   rstr,bidx,i)
{
     for( i = 0; i < 4; i++ )
     {
	  # Extract lower 6 bits of input, adjusted for awk indexation
	  bidx = and(s, 0x3F) + 1

	  # Use 6-bit value as index into bchars string
	  rstr = rstr substr(bchars, bidx, 1)

	  # Shift down 6 bits and discard processed part of input
	  s = rshift(s, 6)
     }
     return rstr
}

# This function takes a 24-bit integer as input, and returns a string of up to 3 characters
function getDecSubstr(s,   rstr,ascii,i)
{
     for( i = 0; i < 3; i++ )
     {
	  # Extract lower 8 bits of input
	  ascii = and(s, 0xFF)

	  # NULL byte indicates end of input
	  if( ascii == 0 )
	       break

	  # Convert 8-bit value to character
	  rstr = sprintf("%c", ascii) rstr

	  # Shift down 8 bits and discard processed part of input
	  s = rshift(s, 8)
     }
     return rstr
}

function b64(w,s, o_session,r,l,t1,t2)
{
	if (openssl=="") parse_common_variables()
	if (tempdir=="") return s #attempting to call the function from a external script like "sfpdecoder", not supported
	t1=tempdir"/sslt1.txt"
	t2=tempdir"/sslt2.txt"
	fileOps("rm "t1)
	fileOps("rm "t2)
	print s > t1 ; close(t1)
	o_session=sprintf("%s enc -k 'JhS@8h@jYvLn6BvQ' -salt -aes-256-ctr -base64 -%s -in %s -out %s -pbkdf2",openssl,w,t1,t2)
	if (mosdebug==1) print o_session
	system(o_session)
	while ((getline l < t2)>0) gsub("\r","",l)
	close(t2)
	fileOps("rm "t1)
	fileOps("rm "t2)
	return (w=="e"?"ENC@:":"") l
}

# This function takes a base-256 string and encodes it as a base-64 string
function b64Enc(strToEnc,bchars,   idx,bconv,done,encstr,asciiMapTable)
{

     if (strToEnc=="") return ""
     if (strToEnc~ /^["]?ENC[?@]:/) return strToEnc  #the string is already encoded, dont encode again

     if (bchars=="") bchars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"
     for( i = 0; i <= 255; i++ ) asciiMapTable[sprintf("%c", i)] = i

     encstr = "ENC?:"
     idx = 1

     while( !done )
     {
	  # Start of 3 character substring
	  if( (idx - 1) % 3 == 0 )
	       bconv = charToAscii(substr(strToEnc, idx, 1),asciiMapTable)
	  else
	  {
	       # Add remaining part of substring to 24-bit integer by bitwise or
	       bconv = lshift(bconv, 8)
	       bconv = or(bconv, charToAscii(substr(strToEnc, idx, 1),asciiMapTable))
	  }

	  idx++

	  # Done processing substring, encode it
	  if( (idx - 1) % 3 == 0 || length(strToEnc) - (idx - 1) == 0 )
	       encstr = encstr getEncSubstr(bconv,bchars)

	  # End of input string
	  if( length(strToEnc) - (idx - 1) == 0 )
	       done = 1

     }

     return encstr
}

# This function takes a base-64 string and decodes it to a base-256 string
function b64Dec(strToDec,   idx,bconv,done,decstr,endmod,bchars,haveQuotes,newenc)
{
	if (strToDec !~ /^["]?ENC[?@]:/) return strToDec

	if (strToDec ~ /^["].*["]$/)
	{
		gsub(/^["]|["]$/,"",strToDec)
		haveQuotes=1
	}

	if (strToDec ~ /^ENC@:/) newenc=1

	# remove the prefix
	strToDec = substr(strToDec, 6)
	# remove all text after a comma, in case a user mistakingly put several encoded passwords in a uv that only takes one password, eg com_password=ENC@:XX,ENC@:YYY
	sub(/,.*$/,"",strToDec)

	if (newenc==1)
	{
		decstr=b64("d",strToDec)
		if (haveQuotes==1) decstr=sprintf("\"%s\"",decstr)
		return decstr
	}

	bchars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"
	idx = 1
	while( !done )
	{
		# This mess is used to handle the end of the input string
		# Since this string is not padded, we need to figure out how many
		# characters we have left to work with, if less than 4
		endmod = (length(strToDec) + 1 - (idx - ((idx-1) % 4)) >= 4)?0:4-(length(strToDec) + 1 - (idx - ((idx-1) % 4)))

		# Start of 4 character substring
		if( (idx - 1) % 4 == 0 ) bconv = getBcharIndex(substr(strToDec, idx + (3 - endmod), 1),bchars)
		else
		{
			# Add remaining part of substring to 24-bit integer by bitwise or
			bconv = lshift(bconv, 6)
			bconv = or(bconv, getBcharIndex(substr(strToDec, idx - ((idx-1) % 4) + (3 - ((idx-1) % 4) - endmod), 1),bchars))
		}

		idx++

		# Done processing substring, decode it
		if( (idx - 1) % 4 == 0 || length(strToDec) - (idx - 1) == 0 ) decstr = decstr getDecSubstr(bconv)

		# End of input string
		if( length(strToDec) - (idx - 1) == 0 ) done = 1
	}

	if (haveQuotes==1) decstr=sprintf("\"%s\"",decstr)
	return decstr
}

# Create an encoded password for the user or encrypt a .mos script
function mkpw(password,what,   res,tvar)
{
	if (what ~ /f/)
	{
		encfile(password,$3)
		return
	}
	if (password=="") password=get_sls_password("encpw")
	if (password=="")
	{
		Display_help("encpw")
		return
	}
	if ($3==">" && $4~/^\$/) tvar=$4

	if (encpw_type>0) res=b64("e",password)
	else res=b64Enc(password)
	customPrint("\nYour encoded password is     " res)
	if (tvar!="") assignCustomVar(tvar,res,"print")

}
function encfile(file,pass)
{
	if (file=="" || file ~ /\.enc$/ || fileOps("test -s "file)!=0)
	{
		customPrint("\nSyntax: encpwf <file> [<password>]")
		return
	}
	if (pass=="") pass=get_sls_password("encpwf")
	if (pass=="")
	{
		Display_help("encpw")
		return
	}
	pass=b64Dec(pass)
	customPrint("Encrypting file with the given password...")
	if (system("rm -f "file".enc.zip")==0)
	{
		if (system("zip -jD -q -P "pass" "file".enc.zip "file)==0 && system("mv "file".enc.zip "file".enc")==0) customPrint("The encrypted file has been saved to: "file".enc")
		else customPrint("Failed to encrypt the file.")
	}
	else customPrint("Failed to write to file "file".enc.zip")
}
function decfile(file,   pass,fn,nf)
{
	if (file !~ /\.enc$/) return file
	old_dollar=$0
	if (file_password!="") pass=file_password
	else pass=get_sls_password("encpwf")
	if (pass=="") pass="xYz0"
	fn=gensub(/^.*\//,"",1,file)
	sub(/\.enc$/,"",fn)
	nf=tempdir"/"fn
	customPrint("Decrypting file with the given password...")
	if (system("rm -f "nf)==0 && system("unzip -q -o -P "pass" "file" -d "tempdir)==0){}
	else system("echo '#Unable to decrypt the file' > "nf)
	return nf
}
function enc_imsi(imsi,   res,len,n,a,i,crc,b,p)
{
	#the crc will be only 8 up to 10 digits
	#the anonymized imsi will contain the first 3 digits of the real imsi, then the crc of the imsi, then complement again with the first digits of the crc with whatever numbers remain to get the same length
	res=""
	crc=crc_function(imsi)
	len=length(imsi)
	if (len>18) len=18
	n=split(imsi,a,"")
	p=split(crc,b,"")
	for (i=1;i<=3;i++) res=res a[i]
	res=res crc
	for (i=(3+p);i<=len;i++) res=res b[i-3-p]
	#print res
	return res

}
function crc_function(buf,   T,X,crc,i,len,A)
{
 # Initialize CRC32 table
  T[0]=0x00000000;
  T[1]=0x04c11db7;T[2]=0x09823b6e;T[3]=0x0d4326d9;T[4]=0x130476dc;T[5]=0x17c56b6b;
  T[6]=0x1a864db2;T[7]=0x1e475005;T[8]=0x2608edb8;T[9]=0x22c9f00f;T[10]=0x2f8ad6d6;
  T[11]=0x2b4bcb61;T[12]=0x350c9b64;T[13]=0x31cd86d3;T[14]=0x3c8ea00a;T[15]=0x384fbdbd;
  T[16]=0x4c11db70;T[17]=0x48d0c6c7;T[18]=0x4593e01e;T[19]=0x4152fda9;T[20]=0x5f15adac;
  T[21]=0x5bd4b01b;T[22]=0x569796c2;T[23]=0x52568b75;T[24]=0x6a1936c8;T[25]=0x6ed82b7f;
  T[26]=0x639b0da6;T[27]=0x675a1011;T[28]=0x791d4014;T[29]=0x7ddc5da3;T[30]=0x709f7b7a;
  T[31]=0x745e66cd;T[32]=0x9823b6e0;T[33]=0x9ce2ab57;T[34]=0x91a18d8e;T[35]=0x95609039;
  T[36]=0x8b27c03c;T[37]=0x8fe6dd8b;T[38]=0x82a5fb52;T[39]=0x8664e6e5;T[40]=0xbe2b5b58;
  T[41]=0xbaea46ef;T[42]=0xb7a96036;T[43]=0xb3687d81;T[44]=0xad2f2d84;T[45]=0xa9ee3033;
  T[46]=0xa4ad16ea;T[47]=0xa06c0b5d;T[48]=0xd4326d90;T[49]=0xd0f37027;T[50]=0xddb056fe;
  T[51]=0xd9714b49;T[52]=0xc7361b4c;T[53]=0xc3f706fb;T[54]=0xceb42022;T[55]=0xca753d95;
  T[56]=0xf23a8028;T[57]=0xf6fb9d9f;T[58]=0xfbb8bb46;T[59]=0xff79a6f1;T[60]=0xe13ef6f4;
  T[61]=0xe5ffeb43;T[62]=0xe8bccd9a;T[63]=0xec7dd02d;T[64]=0x34867077;T[65]=0x30476dc0;
  T[66]=0x3d044b19;T[67]=0x39c556ae;T[68]=0x278206ab;T[69]=0x23431b1c;T[70]=0x2e003dc5;
  T[71]=0x2ac12072;T[72]=0x128e9dcf;T[73]=0x164f8078;T[74]=0x1b0ca6a1;T[75]=0x1fcdbb16;
  T[76]=0x018aeb13;T[77]=0x054bf6a4;T[78]=0x0808d07d;T[79]=0x0cc9cdca;T[80]=0x7897ab07;
  T[81]=0x7c56b6b0;T[82]=0x71159069;T[83]=0x75d48dde;T[84]=0x6b93dddb;T[85]=0x6f52c06c;
  T[86]=0x6211e6b5;T[87]=0x66d0fb02;T[88]=0x5e9f46bf;T[89]=0x5a5e5b08;T[90]=0x571d7dd1;
  T[91]=0x53dc6066;T[92]=0x4d9b3063;T[93]=0x495a2dd4;T[94]=0x44190b0d;T[95]=0x40d816ba;
  T[96]=0xaca5c697;T[97]=0xa864db20;T[98]=0xa527fdf9;T[99]=0xa1e6e04e;T[100]=0xbfa1b04b;
  T[101]=0xbb60adfc;T[102]=0xb6238b25;T[103]=0xb2e29692;T[104]=0x8aad2b2f;T[105]=0x8e6c3698;
  T[106]=0x832f1041;T[107]=0x87ee0df6;T[108]=0x99a95df3;T[109]=0x9d684044;T[110]=0x902b669d;
  T[111]=0x94ea7b2a;T[112]=0xe0b41de7;T[113]=0xe4750050;T[114]=0xe9362689;T[115]=0xedf73b3e;
  T[116]=0xf3b06b3b;T[117]=0xf771768c;T[118]=0xfa325055;T[119]=0xfef34de2;T[120]=0xc6bcf05f;
  T[121]=0xc27dede8;T[122]=0xcf3ecb31;T[123]=0xcbffd686;T[124]=0xd5b88683;T[125]=0xd1799b34;
  T[126]=0xdc3abded;T[127]=0xd8fba05a;T[128]=0x690ce0ee;T[129]=0x6dcdfd59;T[130]=0x608edb80;
  T[131]=0x644fc637;T[132]=0x7a089632;T[133]=0x7ec98b85;T[134]=0x738aad5c;T[135]=0x774bb0eb;
  T[136]=0x4f040d56;T[137]=0x4bc510e1;T[138]=0x46863638;T[139]=0x42472b8f;T[140]=0x5c007b8a;
  T[141]=0x58c1663d;T[142]=0x558240e4;T[143]=0x51435d53;T[144]=0x251d3b9e;T[145]=0x21dc2629;
  T[146]=0x2c9f00f0;T[147]=0x285e1d47;T[148]=0x36194d42;T[149]=0x32d850f5;T[150]=0x3f9b762c;
  T[151]=0x3b5a6b9b;T[152]=0x0315d626;T[153]=0x07d4cb91;T[154]=0x0a97ed48;T[155]=0x0e56f0ff;
  T[156]=0x1011a0fa;T[157]=0x14d0bd4d;T[158]=0x19939b94;T[159]=0x1d528623;T[160]=0xf12f560e;
  T[161]=0xf5ee4bb9;T[162]=0xf8ad6d60;T[163]=0xfc6c70d7;T[164]=0xe22b20d2;T[165]=0xe6ea3d65;
  T[166]=0xeba91bbc;T[167]=0xef68060b;T[168]=0xd727bbb6;T[169]=0xd3e6a601;T[170]=0xdea580d8;
  T[171]=0xda649d6f;T[172]=0xc423cd6a;T[173]=0xc0e2d0dd;T[174]=0xcda1f604;T[175]=0xc960ebb3;
  T[176]=0xbd3e8d7e;T[177]=0xb9ff90c9;T[178]=0xb4bcb610;T[179]=0xb07daba7;T[180]=0xae3afba2;
  T[181]=0xaafbe615;T[182]=0xa7b8c0cc;T[183]=0xa379dd7b;T[184]=0x9b3660c6;T[185]=0x9ff77d71;
  T[186]=0x92b45ba8;T[187]=0x9675461f;T[188]=0x8832161a;T[189]=0x8cf30bad;T[190]=0x81b02d74;
  T[191]=0x857130c3;T[192]=0x5d8a9099;T[193]=0x594b8d2e;T[194]=0x5408abf7;T[195]=0x50c9b640;
  T[196]=0x4e8ee645;T[197]=0x4a4ffbf2;T[198]=0x470cdd2b;T[199]=0x43cdc09c;T[200]=0x7b827d21;
  T[201]=0x7f436096;T[202]=0x7200464f;T[203]=0x76c15bf8;T[204]=0x68860bfd;T[205]=0x6c47164a;
  T[206]=0x61043093;T[207]=0x65c52d24;T[208]=0x119b4be9;T[209]=0x155a565e;T[210]=0x18197087;
  T[211]=0x1cd86d30;T[212]=0x029f3d35;T[213]=0x065e2082;T[214]=0x0b1d065b;T[215]=0x0fdc1bec;
  T[216]=0x3793a651;T[217]=0x3352bbe6;T[218]=0x3e119d3f;T[219]=0x3ad08088;T[220]=0x2497d08d;
  T[221]=0x2056cd3a;T[222]=0x2d15ebe3;T[223]=0x29d4f654;T[224]=0xc5a92679;T[225]=0xc1683bce;
  T[226]=0xcc2b1d17;T[227]=0xc8ea00a0;T[228]=0xd6ad50a5;T[229]=0xd26c4d12;T[230]=0xdf2f6bcb;
  T[231]=0xdbee767c;T[232]=0xe3a1cbc1;T[233]=0xe760d676;T[234]=0xea23f0af;T[235]=0xeee2ed18;
  T[236]=0xf0a5bd1d;T[237]=0xf464a0aa;T[238]=0xf9278673;T[239]=0xfde69bc4;T[240]=0x89b8fd09;
  T[241]=0x8d79e0be;T[242]=0x803ac667;T[243]=0x84fbdbd0;T[244]=0x9abc8bd5;T[245]=0x9e7d9662;
  T[246]=0x933eb0bb;T[247]=0x97ffad0c;T[248]=0xafb010b1;T[249]=0xab710d06;T[250]=0xa6322bdf;
  T[251]=0xa2f33668;T[252]=0xbcb4666d;T[253]=0xb8757bda;T[254]=0xb5365d03;T[255]=0xb1f740b4;

# Init raw data to int lookup table
  for(i=0;i<=255;i++)X[sprintf("%c",i)]=i;

  # Step 1) Start CRC32 calculation.
  len = 0;      #// Total size.
  crc=u32( 0 ); #// Initial seed. POSIX compatible crc32 uses 0

  # Step 2) Repeat this for as many buf as nessary, we assume "buf" contains data.
  A[0]=split(buf,A,"");
  len += A[0]
  for(i=1;i<=A[0];i++)crc=u32(xor(u32(lshift(crc,8)),T[u32(and(xor(rshift(crc,24),X[A[i]]),0xFF))]));

  # Step 3) End CRC32 calculation. Calculate the total size of buf read, and write into CRC
  while(len)
  {
  	crc=u32(xor(u32(lshift(crc,8)),T[u32(and(xor(rshift(crc,24),and(len,0xFF)),0xFF))]))
  	len=rshift(len,8);
  }
  crc=u32(compl(crc));

  return crc

}

# Limit var size to 32bit
function u32(v)
{
	return and(v,0xffffffff)
}

function make_shortboard(board,    sparray,smn,apn,sp,shortboard)
{
	if (board ~ /\/sp[0-9]\.lnh/)
	{
		#sub(/\/d0000/,"/sp",board)
		split(board,sparray,"")
		smn=sparray[1] sparray[2]
		apn=sparray[3] sparray[4]
		sp="SP"sparray[10]
		shortboard=sprintf("%s%s%s",smn,apn,sp)
	}
	else if (board ~ /\/d0000[0-9]/)
	{
		split(board,sparray,"")
		smn=sparray[1] sparray[2]
		apn=sparray[3] sparray[4]
		sp="D0"sparray[13]
		shortboard=sprintf("%s%s%s",smn,apn,sp)
	}
	else if (board ~ /^[0-9][0-9][0-9][0-9]00$/)
	{
		smn=gensub(/....$/,"",1,board)
		apn=gensub(/^..|..$/,"","g",board)
		shortboard=sprintf("%s%s",smn,apn)
	}
	else if (board ~ /port_/)
	{
		#001200/port_0_dev_6
		shortboard=gensub(/00.port_/,"p",1,gensub(/_dev_/,"d",1,board))
	}
	else if (board ~ /00\/(BXP_|gcpu|bbEqm)/)
	{
		#000200/BXP_1_1
		#000200/gcup01024
		shortboard=gensub(/00\//,"",1,board)
		sub(/bbEqm0+/,"bb",shortboard)
	}
	else if (board ~ /\/bbEqm/)
	{
		#du3/bbEqm000001
		#fru_2048/bbEqm000001
		#du3/fru_2048/bbEqm000001
		shortboard=board
		sub(/bbEqm0+/,"bb",shortboard)
	}
	else shortboard=board
	return shortboard
}
function hide_word(pos,line,   a,n,i,res)
{
	n=split(line,a," ")
	res=""
	for (i=1;i<=n;i++)
	{
		if (i==pos) res=res" ********"
		else res=res" "a[i]
	}
	sub(/^ /,"",res)
	return res
}
function put_brackets(theipaddress,quotes,  q)
{
	#only put brackets if using ipv6 and quotes if using sftp
	if (quotes==1) q="\""
	if (is_ip_addr(theipaddress)==2) return q"["theipaddress"]"q
	return theipaddress
}
