#Execute with:
# lh ru llog -l | $gawk -f /path/to/parse_llog.awk [-v int_crash=XXX -v int_reg=YYY -v int_prog=ZZZ]   (the -v are optional)
BEGIN{
	if (int_crash=="") int_crash=150
	if (int_reg=="")   int_reg=210
	if (int_prog=="")  int_prog=30
	n=split("No|Reason|Time|Program|Pid|Rank|Signal|PMD|Extra",a,/\|/)
	for (i in a) f[i]=a[i]":"
}
{gsub("\r","") ; gsub("\x00","") }
$2~/^(No|Reason|Time|Program|Pid|Rank|Signal|PMD|Extra):$/ {
	if ($2=="No:" && $3~/^[1-9][0-9]*$/) {e=$3;b=$1 }
	r[e,b,$2]=gensub(/^[^ \t]+[ \t]+[^ \t]+[ \t]+/,"",1,$0)
	if ($2=="Time:") r[e,b,"timestamp"]=make_timestamp($3,$4)
	next
}
$2~/^-----------------+$/{ next}
$1~/^=================+$/ || $1=="coli>" || $1=="$" { print_restarts() }
#$2=="lhsh" { bd=$2 }
#$1=="coli>/fruacc/lhsh" { bd=$2}
{print}
END { print print_restarts() }


function print_restarts()
{
	#First we populate the "faultId" field in the whole table
	#Also, for Kernel crashes we put the timestamp of the PMD file in case the timestamp is empty.
	#Also, remove entries where some fields are missing
	#---------------------------------------------------
	#No:       4336
	#Failed to retrieve information!
	#---------------------------------------------------
	for (i=1;i<=e;i++)
	{
		if (r[i,b,"Time:"]=="") 
		{ 
			r[i,b,"No:"]="" 
			continue 
		}
		if (r[i,b,"Extra:"]~/faultId: (0x998|0xf06e) /)
		{
			match(r[i,b,"Extra:"],/faultId: (0x998|0xf06e) /,fI)
			r[i,b,"faultId"]=fI[1]
		}
		#No:       48
		#Reason:   Kernel Crash
		#Time:     2000-01-01 00:00:11
		#Program:  -
		#Pid:      -
		#Rank:     Cold
		#Signal:   -
		#PMD:      /var/log/pmd/pmd-ramoops-pmd-60713-20210619-004852.tgz
		#Extra:    -
		if (strftime("%Y-%m-%d",r[i,b,"timestamp"])=="2000-01-01" && r[i,b,"PMD:"]~/-20[1-9][0-9][0-9][0-9][0-9][0-9]-/)
		{
			zz=split(r[i,b,"PMD:"],arr,"-")
			split(arr[zz-1],x,"") ; split(arr[zz],y,"")
			xx=sprintf("%d%d%d%d-%d%d-%d%d",x[1],x[2],x[3],x[4],x[5],x[6],x[7],x[8])
			yy=sprintf("%d%d:%d%d:%d%d",y[1],y[2],y[3],y[4],y[5],y[6])
			r[i,b,"Time:"]=xx" "yy
			r[i,b,"timestamp"]=make_timestamp(xx,yy)
		}
	}
	#Next do the combination of restarts
	for (i=e;i>=1;i--)
	{
		if (nocombine==1) continue #skip combination if nocombine=1
		if (r[i,b,"No:"]=="") continue
		if (b=="0001:" && r[i,b,"Rank:"]~/Cold/ && r[i,b,"Extra:"]~/Upgrade activate/) upA[r[i,b,"timestamp"]]=r[i,b,"timestamp"] #save the list of timestamps of all node restarts due to UP activate
		#print "DEBUG: "i,b,r[i,b,"Reason:"],int_prog,r[i,b,"No:"],r[i-1,b,"No:"],r[i,b,"Rank:"],r[i-1,b,"Rank:"],r[i,b,"timestamp"],r[i-1,b,"timestamp"],r[i,b,"Time:"],r[i-1,b,"Time:"] > "/dev/stderr"
		if ((strftime("%Y",r[i,b,"timestamp"])>="2020" && strftime("%Y",r[i-1,b,"timestamp"])>="2020" && r[i,b,"timestamp"]<=r[i-1,b,"timestamp"])||\
		    (strftime("%Y",r[i-1,b,"timestamp"])>="2020" && r[i,b,"Reason:"]=="Kernel Crash" && r[i-1,b,"faultId"]!=""))   #strftime("%Y",r[i,b,"timestamp"])=="2000" &&  => always do this combination regardless of the timestamp of the kernel crash
		{
			#Handle cases where timestamps for two consecutive restarts are valid but the latter restart has a earlier timestamp than the previous one due to we had changed it in the above step. Typically should happen with kernel restart
			#No:       47
			#Reason:   Ordered restart
			#Time:     2021-06-19 00:50:57
			#Program:  bc-server
			#Pid:      -
			#Rank:     Cold
			#Signal:   -
			#PMD:      -
			#Extra:    Application ordered restart, faultId: 0xf06e (Restart), faultDescription: Application ordered restart
			#-------
			#No:       48
			#Reason:   Kernel Crash
			#Time:     2000-01-01 00:00:11 => this timestamp got changed above to same as PMD, eg 2021-06-19 00:48:52
			#Program:  -
			#Pid:      -
			#Rank:     Cold
			#Signal:   -
			#PMD:      /var/log/pmd/pmd-ramoops-pmd-60713-20210619-004852.tgz
			#Extra:    -
			
			#Here we should also include Kernel crashes where the correct timestamp could not be found out from the PMD. The kernel crash should be associated with Application Ordered Restart that occurred just before. Correction: always combine a kernel crash with the previous application restart, regardless of the timestamps of the kernel crash
			#No:       7
			#Reason:   Ordered restart
			#Time:     2021-11-16 16:35:27
			#Program:  bc-server
			#Pid:      -
			#Rank:     Cold
			#Signal:   -
			#PMD:      -
			#Extra:    Application ordered restart, faultId: 0xf06e (Restart), faultDescription: Application ordered restart
			#No:       8
			#Reason:   Kernel Crash
			#Time:     2000-01-01 00:00:20
			#Program:  -
			#Pid:      -
			#Rank:     Cold
			#Signal:   -
			#PMD:      /var/log/pmd/pmd-ramoops-pmd-15469-20000101-000115.tgz
			#Extra:    -
			
			if (r[i-1,b,"faultId"]!="")  #If the previous restart was with faultId then combine them
			{
				r[i,b,"No:"]=r[i-1,b,"No:"]","r[i,b,"No:"]
				if (r[i,b,"Reason:"]!="Kernel Crash")
				{
					if (r[i,b,"Program:"]~/^(-|)$/ && r[i-1,b,"Program:"]!~/^(-|)$/) r[i,b,"Program:"]=r[i-1,b,"Program:"]
					if (r[i,b,"Pid:"]~/^(-|)$/ && r[i-1,b,"Pid:"]!~/^(-|)$/) r[i,b,"Pid:"]=r[i-1,b,"Pid:"]
					if (r[i,b,"Signal:"]~/^(-|)$/ && r[i-1,b,"Signal:"]!~/^(-|)$/) r[i,b,"Signal:"]=r[i-1,b,"Signal:"]
					sub(/^-$/,"",r[i,b,"Extra:"])
					sub(/^-$/,"",r[i-1,b,"Extra:"])
					r[i,b,"Extra:"]="faultId: "r[i-1,b,"faultId"] " " r[i,b,"Extra:"]   #". "r[i-1,b,"Extra:"]
					sub(/^\. +/,"",r[i,b,"Extra:"])
				}
				r[i,b,"timestamp"]=r[i-1,b,"timestamp"]
				r[i,b,"Time:"]=r[i-1,b,"Time:"]
				r[i-1,b,"No:"]=""
			}
			else  #give new timestamp one second later than the previous restart so that the restarts will be in chronogical order
			{
				r[i,b,"timestamp"]=r[i-1,b,"timestamp"]+1
				r[i,b,"Time:"]=strftime("%Y-%m-%d %H:%M:%S",r[i,b,"timestamp"])
			}
		}
		else if ((r[i,b,"faultId"]!="")&&(((r[i,b,"timestamp"]-r[i-2,b,"timestamp"])<int_crash ||strftime("%Y-%m-%d",r[i-2,b,"timestamp"])=="2000-01-01")&&(r[i-2,b,"Reason:"]=="Program Crash")&&(r[i-1,b,"Extra:"]!~/faultId: (0x998|0xf06e) /)))
		{
			#BXP_2048: No:       66
			#BXP_2048: Reason:   Program Crash
			#BXP_2048: Time:     2019-10-23 17:32:36
			#BXP_2048: Program:  ngr2.elf
			#BXP_2048: Pid:      782
			#BXP_2048: Rank:     -
			#BXP_2048: Signal:   11
			#BXP_2048: PMD:      /var/log/pmd/pmd-PimDataService-782-20191023-173054.tgz
			#BXP_2048: Extra:    CXP9013268%15_R78LC
			#BXP_2048: ---------------------------------------------------
			#BXP_2048: No:       67
			#BXP_2048: Reason:   Program Crash
			#BXP_2048: Time:     2019-10-23 17:32:36
			#BXP_2048: Program:  -
			#BXP_2048: Pid:      -
			#BXP_2048: Rank:     Cold
			#BXP_2048: Signal:   -
			#BXP_2048: PMD:      -
			#BXP_2048: Extra:    -
			#BXP_2048: ---------------------------------------------------
			#BXP_2048: No:       68
			#BXP_2048: Reason:   Ordered restart
			#BXP_2048: Time:     2019-10-23 17:33:33
			#BXP_2048: Program:  ngr2.elf
			#BXP_2048: Pid:      -
			#BXP_2048: Rank:     Cold
			#BXP_2048: Signal:   -
			#BXP_2048: PMD:      -
			#BXP_2048: Extra:    Application ordered restart, faultId: 0xf06e (Restart), faultDescription: Application ordered restart
			
			#Same but with Extra in the middle restart, must be included
			#fru_2049: No:       90
			#fru_2049: Reason:   Program Crash
			#fru_2049: Time:     2000-01-01 00:00:30
			#fru_2049: Program:  sxpcmd.sh
			#fru_2049: Pid:      1231
			#fru_2049: Rank:     Cold
			#fru_2049: Signal:   -
			#fru_2049: PMD:      -
			#fru_2049: Extra:    CXP2030038%1_R63E15
			#fru_2049: ---------------------------------------------------
			#fru_2049: No:       91
			#fru_2049: Reason:   Ordered restart
			#fru_2049: Time:     2021-11-17 10:15:42
			#fru_2049: Program:  bc-server
			#fru_2049: Pid:      -
			#fru_2049: Rank:     Cold
			#fru_2049: Signal:   -
			#fru_2049: PMD:      -
			#fru_2049: Extra:    RADIO_RECOVERY_TIMEOUT RESET at 3600 sec
			#fru_2049: ---------------------------------------------------
			#fru_2049: No:       92
			#fru_2049: Reason:   Ordered restart
			#fru_2049: Time:     2021-11-17 10:16:34
			#fru_2049: Program:  bc-server
			#fru_2049: Pid:      -
			#fru_2049: Rank:     Cold
			#fru_2049: Signal:   -
			#fru_2049: PMD:      -
			#fru_2049: Extra:    Application ordered restart, faultId: 0xf06e (Restart), faultDescription: Application ordered restart
			
			r[i,b,"No:"]=r[i-2,b,"No:"]","r[i-1,b,"No:"]","r[i,b,"No:"]
			if (strftime("%Y-%m-%d",r[i-2,b,"timestamp"])!="2000-01-01") r[i,b,"Time:"]=r[i-2,b,"Time:"]
			r[i,b,"Program:"]=r[i-2,b,"Program:"]
			r[i,b,"Pid:"]=r[i-2,b,"Pid:"]
			r[i,b,"Signal:"]=r[i-2,b,"Signal:"]
			r[i,b,"PMD:"]=r[i-2,b,"PMD:"]
			r[i,b,"Extra:"]="faultId: "r[i,b,"faultId"] " "r[i-2,b,"Extra:"]" "r[i-1,b,"Extra:"]
			r[i,b,"Reason:"]=r[i-2,b,"Reason:"]
			r[i-1,b,"No:"]=""
			r[i-2,b,"No:"]=""
		}
		else if ((r[i,b,"faultId"]!="")&&(((r[i,b,"timestamp"]-r[i-1,b,"timestamp"])<int_reg)||strftime("%Y-%m-%d",r[i-1,b,"timestamp"])=="2000-01-01"||r[i-1,b,"Reason:"]=="Program Crash"))
		{
			#Scenario 1:
			#No:       300
			#Reason:   Ordered restart
			#Time:     2019-10-23 08:50:40
			#Program:  lh_supd
			#Pid:      -
			#Rank:     Cold
			#Signal:   -
			#PMD:      -
			#Extra:    Restart ordered due to Link timeout
			#---------------------------------------------------
			#No:       301
			#Reason:   Ordered restart
			#Time:     2019-10-23 08:51:33
			#Program:  ngr2.elf
			#Pid:      -
			#Rank:     Cold
			#Signal:   -
			#PMD:      -
			#Extra:    Application ordered restart, faultId: 0xf06e (Restart), faultDescription: Application ordered restart

			#Scenario 2:
			#No:       18469
			#Reason:   Program Crash
			#Time:     2021-04-28 19:44:18
			#Program:  -
			#Pid:      0
			#Rank:     Cold
			#Signal:   -
			#PMD:      -
			#Extra:    -
			#---------------------------------------------------
			#No:       18470
			#Reason:   Ordered restart
			#Time:     2021-04-28 19:44:47
			#Program:  radioapp
			#Pid:      0
			#Rank:     Cold
			#Signal:   -
			#PMD:      -
			#Extra:    Application ordered restart, faultId: 0xf06e (Restart), faultDescription: Application ordered restart

			#Scenario 2 with more populated fields, make sure to include all
			#No:       10
			#Reason:   Program Crash
			#Time:     2000-01-01 00:02:46
			#Program:  radioapp.elf
			#Pid:      4756
			#Rank:     Cold
			#Signal:   7
			#PMD:      /var/log/pmd/pmd-parallellJobRun-4756-20000101-000114.tgz
			#Extra:    CXP2030038%1_R63E15
			#---------------------------------------------------
			#No:       11
			#Reason:   Ordered restart
			#Time:     2021-11-16 16:41:43
			#Program:  bc-server
			#Pid:      -
			#Rank:     Cold
			#Signal:   -
			#PMD:      -
			#Extra:    Application ordered restart, faultId: 0xf06e (Restart), faultDescription: Application ordered restart
			
			#Scenario 3: even if the time between Program Crash and subsequent Application Order restart is greater than int_reg we should always combine them because Program Crash always followed by AOR
			#No:       123
			#Reason:   Program Crash
			#Time:     2021-11-24 08:46:14
			#Program:  -
			#Pid:      0
			#Rank:     Cold
			#Signal:   -
			#PMD:      -
			#Extra:    -
			#---------------------------------------------------
			#No:       124
			#Reason:   Ordered restart
			#Time:     2021-11-24 08:57:15
			#Program:  radioapp
			#Pid:      0
			#Rank:     Cold
			#Signal:   -
			#PMD:      -
			#Extra:    Application ordered restart, faultId: 0xf06e (Restart), faultDescription: Application ordered restart
			

			r[i,b,"No:"]=r[i-1,b,"No:"]","r[i,b,"No:"]
			if (r[i-1,b,"Program:"]!~/^(-|)$/) r[i,b,"Program:"]=r[i-1,b,"Program:"]
			if (r[i-1,b,"Pid:"]!~/^(-|)$/) r[i,b,"Pid:"]=r[i-1,b,"Pid:"]
			if (r[i-1,b,"Signal:"]!~/^(-|)$/) r[i,b,"Signal:"]=r[i-1,b,"Signal:"]
			if (r[i-1,b,"PMD:"]!~/^(-|)$/) r[i,b,"PMD:"]=r[i-1,b,"PMD:"]
			r[i,b,"Extra:"]="faultId: "r[i,b,"faultId"] " "r[i-1,b,"Extra:"]
			if ((strftime("%Y-%m-%d",r[i-1,b,"timestamp"])=="2000-01-01")||(r[i,b,"Reason:"]~/Ordered/ && r[i-1,b,"Reason:"]~/Crash/))
			{
				#Scenario 1: Power on, watchdog, etc
				#Scenario 2: there was a crash followed by ordered restart
				r[i,b,"Reason:"]=r[i-1,b,"Reason:"]
			}
			r[i-1,b,"No:"]=""
		}
		else if (((r[i,b,"timestamp"]-r[i-1,b,"timestamp"])<int_prog)&&r[i-1,b,"Rank:"]~/^(-|Program)$/&&r[i,b,"Rank:"]!~/^(-|Program)$/&&strftime("%Y-%m-%d",r[i-1,b,"timestamp"])!="2000-01-01")
		{
			#A program restart escalated to board restart
			#No:       9
			#Reason:   Program Crash
			#Time:     2019-06-24 11:29:16
			#Program:  babeltrace
			#Pid:      11461
			#Rank:     -
			#Signal:   11
			#PMD:      /var/log/pmd/pmd-babeltrace-11461-20190624-112911.tgz
			#Extra:    CXP2030006%1_R41A101
			#---------------------------------------------------
			#No:       10
			#Reason:   Program Crash
			#Time:     2019-06-24 11:29:16
			#Program:  -
			#Pid:      -
			#Rank:     Cold
			#Signal:   -
			#PMD:      -
			#Extra:    -
			r[i,b,"No:"]=r[i-1,b,"No:"]","r[i,b,"No:"]
			r[i,b,"Reason:"]=r[i-1,b,"Reason:"]
			r[i,b,"Program:"]=r[i-1,b,"Program:"]
			r[i,b,"Pid:"]=r[i-1,b,"Pid:"]
			r[i,b,"Signal:"]=r[i-1,b,"Signal:"]
			r[i,b,"PMD:"]=r[i-1,b,"PMD:"]
			sub(/^-$/,"",r[i,b,"Extra:"])
			sub(/^-$/,"",r[i-1,b,"Extra:"])
			r[i,b,"Extra:"]=r[i,b,"Extra:"]". "r[i-1,b,"Extra:"]
			sub(/^\. +/,"",r[i,b,"Extra:"])
			r[i-1,b,"No:"]=""
		}
		else if (b~/BXP_|fru_/ && r[i,b,"faultId"]=="0xf06e" && r[i,b,"Reason:"]~/Ordered restart/)
		{
			#For a FRU restart occurring less than 15 seconds before a "Upgrade activate" BB restart , we add the mention about upgrade
			#2021-05-13 04:15:34 LLOG  BXP_2051         No:  108. Board restart. Reason: Ordered restart. Program: ngr2.elf. Rank: Cold. Extra: Application ordered restart, faultId: 0xf06e (Restart), faultDescription: Application ordered restart
			#2021-05-13 04:15:46 LLOG  0001 BB6630      No:   19. Board restart. Reason: Ordered restart. Rank: Cold. Extra: 'Upgrade activate'
			z=asort(upA)
			for (k=1;k<=z;k++)
			{
				if (upA[k]<r[i,b,"timestamp"]) continue
				if (upA[k]>r[i,b,"timestamp"] && (upA[k]-15)<r[i,b,"timestamp"])
				{
					r[i,b,"Reason:"]="Upgrade "r[i,b,"Reason:"]
					break
				}
			}
		}
	}
	if (fix_2000==1)
	{
		sdate=edate=0
		for (i=1;i<=e;i++)
		{
			if (r[i,b,"No:"]=="") continue
			if (strftime("%Y-%m-%d",r[i,b,"timestamp"])>"2000-01-01") sdate=r[i,b,"timestamp"]+0
			if (sdate==0) continue
			if (strftime("%Y-%m-%d",r[i,b,"timestamp"])=="2000-01-01")
			{
				edate=0
				for (j=(i+1);j<=e;j++)
				{
					if (strftime("%Y-%m-%d",r[j,b,"timestamp"])=="2000-01-01") r[j,b,"No:"]=""  #all consecutive restarts marked with 2000-01-01 are replaced by only one
					if (r[j,b,"timestamp"]>sdate)
					{
						edate=r[j,b,"timestamp"]
						break
					}
				}
				if (edate>sdate)
				{
					r[i,b,"timestamp"]=sdate+(edate-sdate)/2
					r[i,b,"Time:"]=strftime("%Y-%m-%d %H:%M:%S",r[i,b,"timestamp"])
				}
			}
		}
		#TR HZ68121: if the last restart in the board has 2000-01-01 then it should have the same timestamp as the previous restart + 300 sec
		if (e>1 && strftime("%Y",r[e,b,"timestamp"])=="2000" && strftime("%Y",r[e-1,b,"timestamp"])>"2000") 
		{
			r[e,b,"timestamp"]=r[e-1,b,"timestamp"]+300
			r[e,b,"Time:"]=strftime("%Y-%m-%d %H:%M:%S",r[e,b,"timestamp"])
		}
		#print b,e,r[e,b,"No:"],r[e,b,"Time:"] > "/dev/stderr"
		
	}

	for (i=1;i<=e;i++)
	{
		if (r[i,b,"No:"]=="") continue
		print b" ---------------------------------------------------"
		for (j=1;j<=n;j++) printf("%s %-9s %s\n",b,f[j],r[i,b,f[j]])
	}
	e=0 ; b="" ; delete r
}


function make_timestamp(date,time,   datearray,timearray,array)
{
	#if the first argument contains both the date and time, we extract the time
	if (date ~ /^[1-2][0-9][0-9][0-9]-?[0-1][0-9]-?[0-3][0-9].[0-2][0-9]/)
	{
		time=gensub(/^[1-2][0-9][0-9][0-9]-?[0-1][0-9]-?[0-3][0-9]./,"",1,date)
	}

	#possible formats (time is optional, seconds are optional, minutes are optional)
	# 2006-03-10 15:10:30
	# 2006-03-10 15:10
	# 20060310 151030
	# 20060310 1510
	if (date !~ "-")
	{
		split(date,array,"")
		datearray[1]=array[1] array[2] array[3] array[4]
		datearray[2]=array[5] array[6]
		datearray[3]=array[7] array[8]
		split(time,array,"")
		timearray[1]=array[1] array[2]
		timearray[2]=array[3] array[4]
		timearray[3]=array[5] array[6]
	}
	else
	{
		split(date,datearray,"-")
		split(time,timearray,":")
	}
	return mymktime(sprintf("%s %s %s %s %s %s",datearray[1],datearray[2],datearray[3],timearray[1]+0,timearray[2]+0,timearray[3]+0))
}
function mymktime(arg,    array)
{
	#needed for cygwin version 1.7.19 and above where the mymktime function hangs for 30 seconds if the year is 0
	split(arg,array," ")
	if ((array[1]+0)==0) arg="1970 01 01 00 00 00"
	return mktime(arg)
}

#=============================================================================================
#coli>/fruacc/lhsh BXP_2048 llog -l
#BXP_2048: ---------------------------------------------------
#BXP_2048: No:       1
#BXP_2048: Reason:   Power on
#BXP_2048: Time:     2000-01-01 00:00:01
#BXP_2048: Program:  -
#BXP_2048: Pid:      -
#BXP_2048: Rank:     Cold
#BXP_2048: Signal:   -
#BXP_2048: PMD:      -
#BXP_2048: Extra:    -
#
#Gen1 DU with mix of OSE/Linux radios
#=============================================================================================
#$ lhsh 000100/BXP_2_1 llog -l
#0001BXP_2_1: ----------------------------------------------------------------------------
#0001BXP_2_1:  1.    Time           :  2019-05-14, 02:25:56
#0001BXP_2_1:        Error code     :             (Ordered restart)
#0001BXP_2_1:        Product info   :  LMC PID   : CXP9013268%9_R75MD
#0001BXP_2_1:                          XPP PID   : CXC1321797/3_R40Y
#0001BXP_2_1:                          XPL PID   : CXC1321812/1-R6A
#0001BXP_2_1:                          IBOOT PID : CXC1321302/3-R4K
#0001BXP_2_1:                          HW TYPE   : WARP3 Flash=64Mb RAM=128Mb HW-id=CXC10115111 HW-rev=R1A000000 OSE Delta PowerPC
#0001BXP_2_1:                          HW PID    : KRC 161 282/2
#0001BXP_2_1:                          HW REV    : R1E
#0001BXP_2_1:                          HW NAME   : RRUS 12 B3
#0001BXP_2_1:                          HW DATE   : 20121108
#0001BXP_2_1:                          HW serial : C826572002
#0001BXP_2_1:        Restart Information:
#0001BXP_2_1:        Restart ordered due to Link timeout
#=============================================================================================
#$ lhsh 000100/BXP_3 llog -l
#0001BXP_3: ---------------------------------------------------
#0001BXP_3: No:       3
#0001BXP_3: Reason:   Ordered restart
#0001BXP_3: Time:     2019-09-25 04:03:18
#0001BXP_3: Program:  lh_supd
#0001BXP_3: Pid:      -
#0001BXP_3: Rank:     Cold
#0001BXP_3: Signal:   -
#0001BXP_3: PMD:      -
#0001BXP_3: Extra:    Restart ordered due to Link timeout
#0001BXP_3: ---------------------------------------------------
#0001BXP_3: No:       4
#0001BXP_3: Reason:   Ordered restart
#0001BXP_3: Time:     2019-09-25 04:09:58
#0001BXP_3: Program:  ngr2.elf
#0001BXP_3: Pid:      -
#0001BXP_3: Rank:     Cold
#0001BXP_3: Signal:   -
#0001BXP_3: PMD:      -
#0001BXP_3: Extra:    Application ordered restart, faultId: 0x998 (LogicalNameUndefined), faultDescription: Performing internal restart

