#To check used or unused functions in moshell awk files
#gawk -v dir=<dir> -v files=<files> -v infile=<files> -v what=<used|unused> -f check_unused_functions.awk
#
#Example 1:
# Check that no functions of extern.awk are used in prog.awk/other.awk (except those that are skipped because called through external process)
# gawk -v dir=/home/eanzmagn/tools/moshell -v files=extern.awk -v infiles=prog.awk,other.awk -v what=used -f tools/moshell/commonjars/check_functions.awk

#Example 2:
# Check if there are any unused functions
# gawk -v dir=/home/eanzmagn/tools/moshell -v files=prog.awk,other.awk -v infiles=prog.awk,other.awk -v what=unused -f tools/moshell/commonjars/check_functions.awk

BEGIN{
if (dir=="" || files=="" || infiles=="" || what!~/^(used|unused)$/) print_syntax()
split(files,array,",")
for (i in array) { fileList[dir"/"array[i]]=1 }
split(infiles,array,",")
catprog="cat "
for (i in array) catprog=catprog dir"/"array[i]" "
for (i in fileList)
{
	while ((getline < i)>0)
	{
		if($1=="function")
		{
			f=gensub(/\(.*$/,"",1,$2)
			funclist[f]=1
		}
	}
	close(i)
}
while (catprog |& getline)
{
	if ($1=="function") continue
	for (i=1;i<=NF;i++) 
	{
		if ($i ~ /\(/)
		{
			split($i,array,/[,)(="?]/)
			for(j in array)
			{
				if (array[j] in funclist && funclist[array[j]]==1) 
				{
					#special case: if the function is called via external gawk process, skip it
					if (what=="used" && $0 ~ /gawk.*,extern/) { skipped[array[j]]++}
					else used[array[j]]++
				}
			}
		}
	}
}
close(catprog)
if (what=="unused")
{
	print "The following functions defined in "files" are not called in the files "infiles
	for (i in funclist)
	{
		if (funclist[i]==1)
		{
			if (!(used[i]>0)) { print i ; tot=tot"|"i }
		}
	}
}
else if (what=="used")
{
	print "The following functions defined in "files" are called in the files "infiles
	for (i in used)
	{
		if (used[i]>0)
		{
			printf("%3d %s\n",used[i],i)
			tot=tot"|"i 
		}
	}
	sub(/^\|/,"",tot)
	if (tot!="") print "Filter: ^function ("tot")"
	print "The following functions are used but skipped: "
	for (i in skipped) printf i" "
	print ""
	exit
}
sub(/^\|/,"",tot)
print "\n"
if (tot=="") exit
print "These functions are called in the following files: "
find_command="find "dir" -type f | xargs egrep \x27("tot")\\(\x27 | egrep -v '^[^: ]+:function'"
print find_command
system(find_command)

}


function print_syntax()
{
	print "Syntax: gawk -v dir=<dir> -v files=<files> -v infiles=<files> -v what=<used|unused> -f check_unused_functions.awk"
	print "Example1: gawk -v dir=/home/eanzmagn/tools/moshell -v files=prog.awk,other.awk -v infiles=prog.awk,other.awk -v what=unused -f tools/moshell/commonjars/check_functions.awk"
	print "Example2: gawk -v dir=/home/eanzmagn/tools/moshell -v files=extern.awk -v infiles=prog.awk,other.awk -v what=used -f tools/moshell/commonjars/check_functions.awk"
	exit
}
