#!/usr/bin/perl
# econkel Aug 2012
# Tired of looking up http\:\/\/niviuk.free.fr\/lte_band.php
# version 1.0

use strict;
#use warnings;
use Data::Dumper;


my %celldata;
my %sector;
my $usesector;

my %ChNo;
&makeChNo;
#print Dumper \%ChNo;


open FH, "<$ARGV[0]" or die "something did not go well\n\n";

while (<FH>) {
     if (/EUtranCell(TDD|FDD)\=(\S+)\s+earfcn\s+(\d+)/i) {
          $celldata{$2}{earfcn} = $3;
     }

     if (/EUtranCell(TDD|FDD)\=(\S+)\s+earfcndl\s+(\d+)/i) {
          $celldata{$2}{earfcndl} = $3;
     }


     if (/EUtranCell(TDD|FDD)\=(\S+)\s+earfcnul\s+(\d+)/i) {
          $celldata{$2}{earfcnul} = $3;
     }

   # assume same BW UL and DL for now
     if (/EUtranCell(TDD|FDD)\=(\S+)\s+.*channelBandwidth\s+(\d+)/i) {
          $celldata{$2}{bw} = $3 + 0;  # manke numeric
     }



     if (/SectorEquipmentFunction\=(\d+)\s+reservedBy.*\[1\]/) {
          $usesector = $1; 
     }
     if (/reservedBy.*ENodeBFunction.*\,EUtranCell(FDD|TDD)\=(.*)/) {
         if ($usesector) {
            $celldata{$2}{sectorEqFn} = $usesector;
            $sector{$usesector}{cell} = $2;
            $usesector = "";
         }
     }
     # look for 
     # SectorEquipmentFunction=2                               fqBand            3

     if (/SectorEquipmentFunction\=(\d+)\s+fqBand\s+(\d+)/) {
         $celldata{$sector{$1}{cell}}{fqBand} = $2;
     } 
}

my $FDDorTDD;

foreach my $key (keys %celldata) {
      if (exists  $celldata{$key}{earfcndl} ) {
             $FDDorTDD = "FDD";
          if (exists $ChNo{$celldata{$key}{fqBand}}{NoffDL} ) {
             $celldata{$key}{FC_DL} = $ChNo{$celldata{$key}{fqBand}}{FDLlow} + ($celldata{$key}{earfcndl} - $ChNo{$celldata{$key}{fqBand}}{NoffDL})/10;
          } else {
             $celldata{$key}{FC_DL} = "not known";
             print "\n\nCannot compute using  frequency band $celldata{$key}{fqBand} for cell $key\nPlease update script subroutine makeChNo or check data against specs 36.104\n";
          }
      }
      if (exists  $celldata{$key}{earfcn} ) {
          if (exists $ChNo{$celldata{$key}{fqBand}}{NoffDL} ) {
             $celldata{$key}{FC_DL} = $ChNo{$celldata{$key}{fqBand}}{FDLlow} + ($celldata{$key}{earfcn} - $ChNo{$celldata{$key}{fqBand}}{NoffDL})/10;
             $FDDorTDD = "TDD";
          } else {
             $celldata{$key}{FC_DL} = "not known";
             print "\n\nCannot compute using  frequency band $celldata{$key}{fqBand} for cell $key\nPlease update script subroutine makeChNo or check data against specs 36.104\n";
          }
      }
      if (exists  $celldata{$key}{earfcnul} ) {
             $celldata{$key}{FC_UL} = $ChNo{$celldata{$key}{fqBand}}{FULlow} + ($celldata{$key}{earfcnul} - $ChNo{$celldata{$key}{fqBand}}{NoffUL})/10;
      }
}

#print Dumper \%celldata;
#print Dumper \%sector;

my @ddinfo;

if ($FDDorTDD eq "FDD") {
format FDD =
@<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<@<<<<<<<<<<@<<<<<<<<<<<<@<<<<<<<<<<<
@ddinfo;
.

@ddinfo = ("Cell","DL CF MHz","UL CF MHz","BW","Fband");
$~ = 'FDD';
} else {

format TDD =
@<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<@<<<<<<<<<<<<@<<<<<<<<<<<
@ddinfo;
.

@ddinfo = ("Cell","CF MHz","BW","Fband");
$~ = 'TDD';
}


write;

if ($FDDorTDD eq "FDD") {

     foreach my $key (keys %celldata) {
        @ddinfo = ("$key","$celldata{$key}{FC_DL}","$celldata{$key}{FC_UL}","$celldata{$key}{bw}","$celldata{$key}{fqBand}");
        write;
     }

} else {

     foreach my $key (keys %celldata) {
        @ddinfo = ("$key","$celldata{$key}{FC_DL}","$celldata{$key}{bw}","$celldata{$key}{fqBand}");
        write;
     }

}

print "\nVerify on \n";
print "\nhttp\:\/\/niviuk.free.fr\/lte_band.php\n\n";
sub makeChNo {
$ChNo{1}{FDLlow} = 2110;
$ChNo{2}{FDLlow} = 1930;
$ChNo{3}{FDLlow} = 1805;
$ChNo{4}{FDLlow} = 2110;
$ChNo{5}{FDLlow} = 869;
$ChNo{6}{FDLlow} = 875;
$ChNo{7}{FDLlow} = 2620;
$ChNo{8}{FDLlow} = 925;
$ChNo{9}{FDLlow} = 1844.9;
$ChNo{10}{FDLlow} = 2110;
$ChNo{11}{FDLlow} = 1475.9;
$ChNo{12}{FDLlow} = 728;
$ChNo{13}{FDLlow} = 746;
$ChNo{14}{FDLlow} = 758;
$ChNo{17}{FDLlow} = 734;
$ChNo{33}{FDLlow} = 1900;
$ChNo{34}{FDLlow} = 2010;
$ChNo{35}{FDLlow} = 1850;
$ChNo{36}{FDLlow} = 1930;
$ChNo{37}{FDLlow} = 1910;
$ChNo{38}{FDLlow} = 2570;
$ChNo{39}{FDLlow} = 1880;
$ChNo{40}{FDLlow} = 2300;

$ChNo{1}{FULlow} = 1920;
$ChNo{2}{FULlow} = 1850;
$ChNo{3}{FULlow} = 1710;
$ChNo{4}{FULlow} = 1710;
$ChNo{5}{FULlow} = 824;
$ChNo{6}{FULlow} = 830;
$ChNo{7}{FULlow} = 2500;
$ChNo{8}{FULlow} = 880;
$ChNo{9}{FULlow} = 1749.9;
$ChNo{10}{FULlow} = 1710;
$ChNo{11}{FULlow} = 1427.9;
$ChNo{12}{FULlow} = 698;
$ChNo{13}{FULlow} = 777;
$ChNo{14}{FULlow} = 788;
$ChNo{17}{FULlow} = 704;
$ChNo{33}{FULlow} = 1900;
$ChNo{34}{FULlow} = 2010;
$ChNo{35}{FULlow} = 1850;
$ChNo{36}{FULlow} = 1930;
$ChNo{37}{FULlow} = 1910;
$ChNo{38}{FULlow} = 2570;
$ChNo{39}{FULlow} = 1880;
$ChNo{40}{FULlow} = 2300;

$ChNo{1}{NoffDL} =  0;
$ChNo{2}{NoffDL} =  600;
$ChNo{3}{NoffDL} =  1200;
$ChNo{4}{NoffDL} =  1950;
$ChNo{5}{NoffDL} =  2400;
$ChNo{6}{NoffDL} =  2650;
$ChNo{7}{NoffDL} =  2750;
$ChNo{8}{NoffDL} =  3450;
$ChNo{9}{NoffDL} =  3800;
$ChNo{10}{NoffDL} =  4150;
$ChNo{11}{NoffDL} =  4750;
$ChNo{12}{NoffDL} =  5000;
$ChNo{13}{NoffDL} =  5180;
$ChNo{14}{NoffDL} =  5280;
$ChNo{17}{NoffDL} =  5730;
$ChNo{33}{NoffDL} =  36000;
$ChNo{34}{NoffDL} =  36200;
$ChNo{35}{NoffDL} =  36350;
$ChNo{36}{NoffDL} =  36950;
$ChNo{37}{NoffDL} =  37550;
$ChNo{38}{NoffDL} =  37750;
$ChNo{39}{NoffDL} =  38250;
$ChNo{40}{NoffDL} =  38650;


$ChNo{1}{NoffUL} =  18000;
$ChNo{2}{NoffUL} =  18600;
$ChNo{3}{NoffUL} =  19200;
$ChNo{4}{NoffUL} =  19950;
$ChNo{5}{NoffUL} =  20400;
$ChNo{6}{NoffUL} =  20650;
$ChNo{7}{NoffUL} =  20750;
$ChNo{8}{NoffUL} =  21450;
$ChNo{9}{NoffUL} =  21800;
$ChNo{10}{NoffUL} =  22150;
$ChNo{11}{NoffUL} =  22750;
$ChNo{12}{NoffUL} =  23000;
$ChNo{13}{NoffUL} =  23180;
$ChNo{14}{NoffUL} =  23280;
$ChNo{17}{NoffUL} =  23730;
$ChNo{33}{NoffUL} =  36000;
$ChNo{34}{NoffUL} =  36200;
$ChNo{35}{NoffUL} =  36350;
$ChNo{36}{NoffUL} =  36950;

$ChNo{37}{NoffUL} =  37550;
$ChNo{38}{NoffUL} =  37750;
$ChNo{39}{NoffUL} =  38250;
$ChNo{40}{NoffUL} =  38650;

}


__END__

=================================================================================================================
SectorEquipmentFunction=1                               fqBand            3
=================================================================================================================
SectorEquipmentFunction=1                               reservedBy        [1] = 
 >>> reservedBy = ENodeBFunction=1,EUtranCellFDD=EOEBEBA
=================================================================================================================
EUtranCellFDD=EOEBEBA                                   earfcndl          1250
EUtranCellFDD=EOEBEBA                                   earfcnul          19250
Total: 1 MOs


VIC_EOEB15_818_BOURKE_ST_530139> get EUtranCell(FDD|TDD)=        earfcn         

120814-13:47:02 10.45.16.10 9.0g ERBS_NODE_MODEL_C_1_74_COMPLETE stopfile=/tmp/19985
=================================================================================================================
MO                                                      Attribute         Value
=================================================================================================================
EUtranCellFDD=EOEBEBA                                   earfcndl          1250
EUtranCellFDD=EOEBEBA                                   earfcnul          19250
=================================================================================================================
Total: 1 MOs
