use strict;
use warnings;
use lib qw(./lib/);
use Expect;
use Time::HiRes qw(usleep);

use constant {
        TIMEOUT         => 6,
};

sub usage {
        my ($quit) = @_;
        print "CLUSTER PERL\n";
        print "Usage: perl cluster.pl -cre\[dentials\] <username>:<password (file)> -host <node> \n";
        print "       \[-sshPath <path to ssh>\] \[-timeout <seconds>\] \[-debug\] \[command\] \n";
        print "Options:\n";
        print "\t-cre\t\t\t\tUsername and password\n";
        print "\t-sshPath\t\t\tPath to SSH\n";
        print "\t-host\t\t\t\tIP of host\n";
        print "\t-timeout\t\t\tThe time that we wait for connections to be established\n";
        print "\t-debug\t\t\t\tPrint debug info\n";
        print "\t-sshstricthostkeychecking\tEnable strict host key checking\n";
        print "\t-sshuserknownhostsfile\t\tPath to user known host files\n";
        print "\t-h\t\t\t\tShow this text\n";
        if(!defined($quit) || $quit){
                exit 1;
        }
}

# Parameters
my $user = "";
my $password = "";
my $ssh_path = "/usr/bin/ssh";
my $host = "";
my $usr_timeout = 10;
my $ssh_user_known_hosts_file = "/dev/null";
my $ssh_strict_host_key_checking = "no";
my $debug = 0;
my @commands;
my $actual_command="";


# Set parameters
if (@ARGV) {
        do {
                my $arg = shift(@ARGV);
                if ($arg =~ m/^-cre(dentials)?$/) {
                        ($user, $password) = split(":",shift(@ARGV));
                }
                elsif ($arg eq "-sshPath") {
                        $ssh_path = shift(@ARGV);
                }
                elsif ($arg eq "-host") {
                        $host = shift(@ARGV);
                }
                elsif ($arg eq "-debug") {
                        $debug = 1;
                }
                elsif ($arg eq "-sshstricthostkeychecking") {
                        $ssh_strict_host_key_checking = shift(@ARGV);
                }
                elsif ($arg eq "-sshuserknownhostsfile") {
                        $ssh_user_known_hosts_file = shift(@ARGV);
                }
                elsif ($arg eq "-timeout") {
                        $usr_timeout = shift(@ARGV);
                }
                elsif ($arg eq "-h") {
                        usage(0);
                }
                else{
                         push @commands, $arg;
                }
        } while(@ARGV > 0);
}

if (!($user || $password)) {
        print "No credentials specified.\n";
        usage(1);
}

if (!$host) {
        print "No host specified.\n";
        usage(1);
}

$actual_command = join(" ", @commands);
if ($debug) {
	print "\n";
	print "-- CLUSTER PERL --\n";
	print "Host: $host\n";
	print "Username: $user\n";
	print "Password: $password\n";
	print "Timeout: $usr_timeout\n";
	print "SSH-path: $ssh_path\n";
	print "UserKnownHostsFile: $ssh_user_known_hosts_file\n";
	print "StrictHostKeyChecking: $ssh_strict_host_key_checking\n";
	print "Actual Command: $actual_command";
	print "\n\n";
}
#The specified Password value is a path to a file containing the password
if($password =~ m/^\//){
	my $filepath = $password;
        open (my $fh, '<:encoding(UTF-8)', $filepath) or die "Could not open file: $filepath";
        $password = <$fh>;      # Fetch the first line of the file
        chomp $password;        # Remove '\n'
}

my $ssh_params = "-o UserKnownHostsFile=$ssh_user_known_hosts_file -o StrictHostKeyChecking=$ssh_strict_host_key_checking";
my $ssh_command = "$ssh_path $ssh_params $user\@$host";

# Debug of initial ssh connection
if ($debug) {
	print "spawn $ssh_command\n\n";
}
# Open connection
my $exp = Expect->spawn($ssh_command) or die "Cannot spawn ssh: $!\n";;
$exp->log_user($debug);

# Wait until the password has been passed and we have 
# reached the first prompt '$'--> (mrsv-admin@bgfv-mct4-0:~$)
$exp->expect($usr_timeout,
        ["continue",
        sub {
                $exp->send("yes\n");
        	exp_continue;
        }],
    	["assword:",
    	sub {
        	$exp->send("$password\n");
        	exp_continue;
    	}],
    	["timed out", sub { exit 1; }],
    	[timeout =>
    	sub {
        	print "\nERROR: Connection timeout.\n";
        	exit 1;
    	}],
        ['-re', '.+\@.+:', sub {}]
);

$exp->send("alias quit=''\n");
$exp->expect(TIMEOUT, '-re', '.+\@.+:'); # Wait for prompt
$exp->send("export TERM=xterm\n");
$exp->expect(TIMEOUT, '-re', '.+\@.+:'); # Wait for prompt
$exp->send("\n");
$exp->log_user(1);
$exp->expect(TIMEOUT, '-re', '.+\@.+:'); # Wait for prompt
$exp->send("$actual_command\n");
$exp->expect($usr_timeout,
        ["assword:",
        sub {
            $exp->send("$password\n");
            exp_continue;
        }],
        ["timed out", sub {exit 1;}],
        [timeout =>
        sub {
            print "\nERROR: Connection timeout.\n";
            exit 1;
         }],
        ['-re', '.+\@.+:', sub {}],
);

# close the connection
$exp->log_user($debug);
$exp->send("exit\n");
$exp->expect(TIMEOUT,
        ['-re', 'Connection to .* closed', sub{}]
);
print "\n";


