package read_config;
use strict;
use Data::Dumper;
sub parse_traffic_file
{
	my $confighash = shift;
	
	open TRAFFICFILE, "< $confighash->{traffic_file}";
	my $rabType;
	while (my $line = <TRAFFICFILE>)
	{
		if($line =~ /^\s*\*\s*print\s+(.+)$/)
		{
			$rabType = $1;	
		}
		elsif(defined $rabType && $line =~ /^\s*3gsim\s+\S+\s+\S+\s+(\d{12})/)
		{
				$confighash->{rabFilter}->{$1} = $rabType;			
		}
	}
}

sub read_config_file 
{
	my $confighash = shift;
	open CONFIG, "< $confighash->{config}";
	my $line;
	foreach $line (<CONFIG>) {
		if ( $line =~ /^\s*#/ ) {
			next;
		}
		next if $line =~ /^\s*$/;
		if ($line =~ /^\s*(\S+?)\s*=\s*(.+?)\s*$/)
		{
			$confighash->{$1} = $2 if !defined $confighash->{$1};
			next;
		}
		my @line = split( /\s+/, $line );
		if (@line == 5)
		{
			if ($line =~ /^\s*(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s*$/)
			{
				my ( $imsi, $uetyp, $ueno, $profile, $rutt ) = @line ;
				my $ccn =  substr $rutt, 0,5;
				$confighash->{configData}->{$imsi}->{uetype}  = $uetyp;
				$confighash->{configData}->{$imsi}->{ueno}    = $ueno;
				$confighash->{configData}->{$imsi}->{profile} = $profile;
				$confighash->{configData}->{$imsi}->{route}   = $rutt;
				push(@{$confighash->{configDataRoute}->{$ccn}->{$rutt}},$imsi);
			}
		}	
		else
		{
			print STDERR "teSummary wrong format in config file: $line\n";	
		}
	}
	close CONFIG;
}

1;

