#!/usr/bin/python

from mo import trace
import sys, os, mo

def checkRncType(rncfunc):
    rncType = ''
    boardType = ''
    for x in rncfunc[0:len(rncfunc)]:
        if  'RncFunction=1' in x:
            if  'RNC_8200' in x:
                rncType = 'RNC_8200'
                boardType = 'EPB'
                trace("RNC Type is EVO")
            elif  'RNC_3820' in x:
                rncType = 'RNC_3820'
                boardType = 'ET-IPG'
                trace("RNC Type is 3820")
            else:
                trace("Unsupported RNC type!!!")
                exit(0)
    return rncType, boardType

def getCab():
    subrackNo=[]
    slotNo=[]
    numberOfboards = 0
    nocontact_eps = 0
    rncId = ''
    for x in input_cab[0:len(input_cab)]:
        if  boardType in x:
            x=x.replace(' ','')
            subrack_no=[]
            if x[0] == '0':
                subrack_no = 'MS'
            if x[0] == '1':
                subrack_no = 'ES-1'
            if x[0] == '2':
                subrack_no = 'ES-2'
            subrackNo.append(subrack_no)
            num=x[1]
            if x[2].isdigit():
                num=x[1]+x[2]
            slotNo.append(num)
            numberOfboards = numberOfboards + 1
        if 'NOCONTACT' in x:
            nocontact_eps = nocontact_eps +1
        if  'RncFunction=1' in x:
                for y in x[len(x):0:-1]:
                    if y == ' ':
                        break
                    rncId = y + rncId
    trace('There are ' + str(numberOfboards) +' '+ boardType)
    if nocontact_eps>0:
        trace('NO CONTACT with '+str(nocontact_eps)+ ' ' +boardType)
        #exit(0)
        
def getId(filename):
    with open(filename) as file:
        for line in file:
            if "RncFunction=1" in line:
                rncId = line.split("rncId")[-1].strip()
                #trace('rncId='+rncId)
                return rncId
                
def getIurLink(filename):
    with open(filename) as file:
            for line in file:
                if "IurLink=" in line:
                    iurLink = line.split("rncId")[0].strip().split("=")[1]
                    
                    return iurLink
def changeExternalToRemoteUtranCell(filename):
    list_of_allowed_content = ["CREATE","(","parent", "identity","moType","exception","nrOfAttributes","agpsEnabled","cId","individualOffset","maxTxPowerUl","primaryCpichPower","primaryScramblingCode" ,"qQualMin" ,"qRxLevMin","reportingRange1a","reportingRange1b","timeToTrigger1a","timeToTrigger1b","transmissionScheme","uarfcnDl","uarfcnUl",")"]
    os.rename(filename,filename+".old")
    with open(filename+".old") as file:
        with open(filename,'w') as new_file:
            for line in file:
                if line.split()[0] in list_of_allowed_content:
                    if "parent" in line:
                        new_file.write("   parent \"ManagedElement=1,RncFunction=1\"\n")
                    elif "identity" in line:
                        new_file.write(line.replace("Ext","Rem"))
                    elif "moType" in line:
                        new_file.write(line.replace("External","Remote"))
                    elif "nrOfAttributes" in line:
                       new_file.write("   nrOfAttributes 15\n")
                    else:
                       new_file.write(line)
   
                       
def changeExternalToRemoteUtranCell2(filename):
    os.rename(filename,filename+".old")
    with open(filename+".old") as file:
        with open(filename,'w') as new_file:
            for line in file:
                if "identity" in line:
                    new_file.write(line.replace("Ext","Rem"))
                elif "utranCellRef" in line:
                    lin = line.split(",")
                    del lin[2]
                    lin = ",".join(lin)
                    lin = lin.replace("External","Remote")
                    lin = lin.replace("Ext","Rem")
                    new_file.write(lin)
                else:
                   new_file.write(line)       
                       
def parsingGPB(input_cab):
    subrackNoGpb, slotNoGpb = [], []
    noOfGpbs = 0
    for x in input_cab[0:len(input_cab)]:
        if 'GPB75' in x:
            x=x.replace(' ','')
            subrack_no=' '
            if x[0] == '0':
                subrack_no = 'MS'
            elif x[0] == '1':
                subrack_no = 'ES-1'
            elif x[0] == '2':
                subrack_no = 'ES-2'
            else:
                trace("none of above")
            subrackNoGpb.append(subrack_no)
            num=x[1]
            if x[2].isdigit():
                num=x[1]+x[2]
            slotNoGpb.append(num)
            noOfGpbs += 1
        if 'GPB65' in x:
            trace('GPB65 is not supported!!!')
            sys.exit()
    trace('Number of GPBs: ' + str(noOfGpbs))
    return (subrackNoGpb, slotNoGpb, noOfGpbs)

def isPingOk(path):
    with open(path) as file:
        for line in file:
            if "Return" in line and "no answer" in line:
                return False
            
    return True
def parseUserPlaneRouterIp(path):
    with open(path) as file:
        for line in file:
            if "IpInterface=" in line:
                return line.split("IpInterface=")[-1]
def parsingBoard(input_cab,boardType):
    subrackNo=[]
    slotNo=[]
    numberOfboards = 0
    nocontact_eps = 0
    #rncId = ''
    for x in input_cab[0:len(input_cab)]:
        if  boardType in x:
            x=x.replace(' ','')
            subrack_no=[]
            if x[0] == '0':
                subrack_no = 'MS'
            if x[0] == '1':
                subrack_no = 'ES-1'
            if x[0] == '2':
                subrack_no = 'ES-2'
            subrackNo.append(subrack_no)
            num=x[1]
            if x[2].isdigit():
                num=x[1]+x[2]
            slotNo.append(num)
            numberOfboards = numberOfboards + 1
        if 'NOCONTACT' in x:
            nocontact_eps = nocontact_eps +1
        #if  'RncFunction=1' in x:
        #        for y in x[len(x):0:-1]:
        #            if y == ' ':
        #                break
         #           rncId = y + rncId
	tupl = (subrackNo, slotNo, numberOfboards)
    return tupl
def getDestPointCodes(filename):
    destPointCodeDict = dict()
    
    with open(filename) as file:
        for line in file:
            if "destPointCode" in line:
                destPointCodeDict[line.split()[-1]] = line.split()[0]
    return destPointCodeDict             
                
def modifySs7Configuration(filename, originCM, replaceIdentity, setAutoStartAssociationToFalse, setScpToNull):
    os.rename(filename,filename+".old")
    with open(filename,'w') as newScriptFile:
        with open(filename + ".old") as oldScriptFile:
            for line in oldScriptFile:
                if setScpToNull and "sctpId" in line:
                    newScriptFile.write("   sctpId Ref \"null\"\n")
                elif ("identity" in line or "userLabel" in line or "linkSetM3uId" in line) and replaceIdentity:
                    newScriptFile.write(line[:-2]+"-"+originCM+"\"\n")  
                elif setAutoStartAssociationToFalse and "autoStartAssociation" in line:
                    newScriptFile.write("   autoStartAssociation Boolean false\n")
                else:
                    newScriptFile.write(line)
                    
def getCvCount(filename):
    with open(filename,'r') as file:
        for line in file:
            if ">>> Total:" in line:
                count = line.split()[2]
                return int(count)
                
def replaceMtp3bSrsId(filename, cm1DestPointCodeDict, cm2DestPointCodeDict):
    os.rename(filename,filename+".old")
    with open(filename,'w') as newScriptFile:
        with open(filename+".old") as oldScriptFile:
         
            buffer = oldScriptFile.read()
            for mo in buffer.split("CREATE"):
                moBuffer = mo
                for key in cm2DestPointCodeDict.keys():
                    if cm2DestPointCodeDict[key] in moBuffer:
                        if key in cm1DestPointCodeDict.keys():
                            moBuffer = moBuffer.replace(cm2DestPointCodeDict[key].split(',')[1],cm1DestPointCodeDict[key].split(',')[1])
                            moBuffer = moBuffer.replace(cm2DestPointCodeDict[key].split(',')[0],cm1DestPointCodeDict[key].split(',')[0])
                        else:
                            for cm1Key in cm1DestPointCodeDict:
                                if cm1Key not in cm2DestPointCodeDict.keys():
                                    moBuffer = moBuffer.replace(cm2DestPointCodeDict[key].split(',')[1],cm1DestPointCodeDict[cm1Key].split(',')[1])
                                    moBuffer = moBuffer.replace(cm2DestPointCodeDict[key].split(',')[0],cm1DestPointCodeDict[cm1Key].split(',')[0])
                                    break
                            
                        newScriptFile.write("CREATE {0}".format(moBuffer))                  
                
def replaceSs7Configuration(filename, mapping_table):
    os.rename(filename,filename+".old")
    with open(filename,'w') as newScriptFile:
        with open(filename+".old") as oldScriptFile:
            for line in oldScriptFile:
                buffer = line;
                if "parent" in buffer:
                    for pair in mapping_table:
                        buffer = buffer.replace(pair[0],pair[1])
                newScriptFile.write(buffer)                   
'''        
def setAutoStartAssociationToFalse(filename):
    with open(filename[:-3]+"_replaced.mo",'w') as newScriptFile:
        with open(filename) as oldScriptFile:
            for line in oldScriptFile:
                if "autoStartAssociation" in line:
                    newScriptFile.write("   autoStartAssociation Boolean false\n")
                else:
                    newScriptFile.write(line)   
'''



#reconfiguration sctp frontends scripts:
def changeSecondBoardToFirst(filename,board):
    os.rename(filename,filename+".old")
    with open(filename+".old") as file:
        with open(filename,'w') as new_file:
            if board == "C1":
                new_file.write(file.replace("MS-25","MS-3"))
            elif board == "C2":
                new_file.write(file.replace("MS-26","MS-4"))