use strict;
use warnings;
use lib qw(./lib/);

use Parser;

use constant VERSION => "undefined";

sub usage {
	print "Usage: $0 [-a FILE][-b PADDING][-d X_DISTxY_DIST][-p][-h][-v]\n\n";
	print "Options:\n";
	print "\t-a, --ascii\t\tProduce ASCII graph from inv output\n";
	print "\t-b, --box\t\tChange default horisontal padding in bridge boxes (default: 1, minimum: 1)\n";
	print "\t-d, --dist\t\tChange default distance between bridge boxes (default: 11x1, minimum: 7x0)\n";
	print "\t-p, --position\t\t Sets the label position of bridges vertical connections in the beginning. (default: middle)\n";
	print "\t-h, --help\t\tShow this text\n";
	print "\t-v, --version\t\tShow version\n";
	print "\t-c, --color\t\tShow colors\n";
	print "\nVariables:\n";
	print "\tFILE\t\t\tPath to a log file containing inv output\n";
	print "\tPADDING\t\t\tHorisontal padding in bridge boxes\n";
	print "\tX_DIST\t\t\tHorisontal distance between bridges\n";
	print "\tY_DIST\t\t\tVertical distance between bridges\n";
}

my @output;
my $input;
my $padding = 0;
my $distance_x = -1;
my $distance_y = -1;
my $draw_vertical_connection_labels_in_middle = 1; # default
my $show_colors = 0;

if (@ARGV) {
	do {
		my $arg = shift(@ARGV);
		if (grep(/$arg/, ("-a", "--ascii"))) {
			$input = shift(@ARGV);
		} elsif (grep(/$arg/, ("-h", "--help"))) {
			usage();
			exit 0;
		} elsif (grep(/$arg/, ("-v", "--version"))) {
			print "inv version ". VERSION ."\n";
			exit 0;
		} elsif (grep(/$arg/, ("-b", "--box"))) {
			$padding = shift(@ARGV);
		} elsif (grep(/$arg/, ("-d", "--dist"))) {
			($distance_x, $distance_y) = split("x",shift(@ARGV));
		} elsif (grep/$arg/, ("-p, --position")) {
			$draw_vertical_connection_labels_in_middle = 0; # they will be drawn in the beginning now.			
		} elsif (grep/$arg/, ("-c, --colors")) {
			$show_colors = 1; # they will be drawn in the beginning now.			
		}
	} while(@ARGV > 0);
}

if (!defined($input)) {
	usage();
	exit 1;
}

open(FILE, $input);
@output = <FILE>;
close(FILE);

my $parser = Parser->new(\@output, $padding, $distance_x, $distance_y, $draw_vertical_connection_labels_in_middle, $show_colors);
$parser->execute();
$parser->ascii();
