#!/usr/bin/python

from mo import trace
import os, json, sys, mo, mo_parsing

MOSHELL_PATH = ""
rinpmJson = []
program_path = ""

def checkGeneratedFiles():
    ignoredKeys = ("m3u","iuxup_ping","restore_backup","get_M3uAssociations","iuxup_ping") # preparation (temporary) files
    for cm in ("CM1","CM2"):
        for file in rinpmJson[cm]["migr_mos"]:
            if not os.path.isfile(program_path + cm + "/" + rinpmJson[cm]["migr_mos"][file]) and file not in ignoredKeys:
                trace(file)
                return False
            else:
                trace("File {0} already exists in directory {1}".format(file,cm))
    return True    
            
def checkUtranGeneratedFiles():
    for cm in ("CM1","CM2"):
        for file in rinpmJson["iur"]["scripts"]:
            if not os.path.isfile(program_path  + cm + "/" + rinpmJson["iur"]["scripts"][file]):
                return False
            else:
                trace("File {0} already exists in directory {1}".format(file,cm))
    return True
            
def setupMoshellPath(path):
    global MOSHELL_PATH
    MOSHELL_PATH = path

def deleteFile(fpath):
    try:
        os.remove(fpath)
        trace("file removed: " + fpath)
    except:
        pass
        
def deleteOldFiles(fpath,tempFiles):
    deleteFile(fpath + tempFiles["rncfunc"])
    deleteFile(fpath + "destPoint")
    deleteFile(fpath + "cvls")
    deleteFile(fpath + tempFiles["vlan"])
    deleteFile(fpath + tempFiles["cab"])
    deleteFile(fpath + tempFiles["iuxup"])
    deleteFile(fpath + tempFiles["iuxup"]+"s")
    deleteFile(fpath + tempFiles["iuxup"][:-3]+".log")
    deleteFile(fpath + tempFiles["iuxup"][:-3]+"_del.mos")
    deleteFile(fpath + "migration.log")

def writeMos(filename, text):
    try:
        with open(filename,'w') as f:
            f.write(text)
        trace("file ready: {0}".format(filename))
    except BaseException as e: 
        trace(e)
        trace("Error while writing to {0}".format(filename))
        sys.exit(0)
    

def get_program_path():
    global program_path
    program_path = path 
    return os.getcwd() + '/'

def readJson(filename):
    try:
        List = json.load(file(filename))
    except BaseException as e:        
        trace(e)
        trace('Error while reading JSON file: {0}'.format(filename))
        sys.exit(0)
    trace('{0} was loaded'.format(filename))
    global rinpmJson
    rinpmJson = List
    return List
    
def run_moshell_session(credentials, filename):
    global rinpmJson
    global program_path
    trace("moshell session {0} started".format(credentials["ip"]))
    trace("with {0}".format(filename))
    while 1:
        returnCode = moshell_session(credentials, filename)
        if returnCode == 0:
            trace("moshell session {0} finished".format(credentials["ip"]))
            break
        elif returnCode == -1:
            trace("moshell session {0} returnCode = -1, aborting script".format(credentials["ip"]))
            exit(program_path,rinpmJson)
          
def moshell_session(credentials, filename):
    cr = "password=" + credentials["pw"] + " " + credentials["ip"]
    global MOSHELL_PATH
    mos_session = os.popen(MOSHELL_PATH + " " + cr + " " + filename)
    response = ''
    try:
        while 1:
            line = mos_session.readline()
            if not line: 
			    break
            print '\033[94m' + line.rstrip('\n') + '\033[0m'
            if "!!!! Processing failure" in line and "cleanCvs" not in line:
                trace("A problem has been detected. Do you want to Ignore/Retry/Cancel? (i/r/c)\n")
                response = str(raw_input("")).lower()
                if response == 'c' or response == 'r':
                    mos_session.kill()
        return 0
        #os.system('moshell session')
    except:
        if response == 'c': 
            error = -1
        elif response == 'r': 
            error = -2
        trace("Error during mos_session")
        return error

def exit(path,json):
    trace("Do you want to revert changes made by script? (y/n)")
    if str(raw_input("")).lower() == 'y':
        for cm in ("CM1","CM2"):
            cmPath = path + cm + '/'
            cmJson = json[cm]
            writeMos(cmPath + "setStandaloneCv.mos " + mo.setStandaloneCv())
            writeMos(cmPath + "cleanCvs.mo " + mo.cleanCvs())
            run_moshell_session(cmJson["credentials"], cmPath + "setStandaloneCv.mos")
            trun_moshell_session(cmJson["credentials"], cmPath + "cleanCvs.mo")
    sys.exit()
    
def trun_moshell_session(credentials, filename):
    run_moshell_session(credentials,"\"truni " + filename + "\"")
    
def getRncId(working_path,cm,rinpmjson):
    writeMos(working_path + cm +"/" + rinpmjson["iur"]["scripts"]["get_rnc_id"], mo.getRncId(working_path + cm +"/",rinpmjson["iur"]["logs"]["rnc_id"]))
    run_moshell_session(rinpmjson[cm]["credentials"], working_path + cm + "/"  +  rinpmjson["iur"]["scripts"]["get_rnc_id"])
        
    rncId = mo_parsing.getId(working_path + cm +"/" + rinpmjson["iur"]["logs"]["rnc_id"])  
    deleteFile(working_path + cm +"/" + rinpmjson["iur"]["logs"]["rnc_id"])
    return rncId
    
def getInputFromFiles(fpath, tempFiles):
    # take info for CM
    
    d = {}
    for k in tempFiles.keys():
        with open(fpath + tempFiles[k]) as f:
            d[k] = f.readlines()
        
    return d
def createDirectories(working_path):
    #create directories if they do not exist
    if not os.path.exists(working_path+"CM1/"):
        os.makedirs(working_path+"CM1/")
    if not os.path.exists(working_path+"CM2/"):
        os.makedirs(working_path+"CM2/")  
        
def get_moshell_output(program_path, credentials, tempFiles):
    deleteOldFiles(program_path,tempFiles)  
    #for k in tempFiles.keys():
        #open(program_path + tempFiles[k],'w').close()  # create empty file if it doesn't exist yet
    # comlist is
    # printout for CMXB ports
    # printout for ipinterfaces and rncid
    # u+s for Iux User Plane (used IUB)
    # getting type of rnc 3820 and Evo only supported
    comlist = """lt all
mr vlanports 
ma vlanports EthernetSwitchModulePort administrativeState 1
ma vlanports EthernetBridgePort= 
l+ {0}{t[vlan]}
hget vlanports vlanref 
l-
l+ {0}destPoint
get Mtp3bSrs destPoint
l-
l+ {0}cvls
cvls
l-
l+ {0}{t[cab]}
cab
get RncFunction rncId
l-
ma pool ipaccesshostpool reservedBy IubLink 
u+s {0}{t[iuxup]}
del pool
u-
u! $undocommandfile
l+ {0}{t[rncfunc]}
get RncFunction rncType
l-
""".format(program_path,t = tempFiles)
    writeMos(program_path + "printout.mos", comlist)
    #Moshell sesion for getting printouts
    run_moshell_session(credentials, program_path+"printout.mos")
    os.unlink(program_path + "printout.mos")
    #os.unlink(tempFiles["iuxup"])
    #os.unlink(tempFiles["iuxup"]+".mos")
    #os.unlink(tempFiles["iuxup"]+"_del.mos")