#!/usr/bin/gawk -f


BEGIN {
  if ( ARGC < 2 ) {
    print "Syntax: pr_ipif.awk <interface> <address>";
    exit
      }
  mo_if = ARGV[1];
  mo_ip = ARGV[2];
  mo_vrrp = ARGV[3];
  mo_rt = ARGV[4];

  if_num = 0;
  ip_num = 0;
  vrrpi_num = 0;
  vrrpa_num = 0;
  vrrps_num = 0;
  rt_dn_num = 0;
  rt_sr_num = 0;
  rt_peer_num = 0;
  rt_bfd_num = 0;
  
# Read InterfaceIpv4 MO
  while (( getline < mo_if ) > 0 ) {
    if ( $1 ~ /^IpRouter=.*,InterfaceIpv4=.*/ ) {
      if ( $2 != "!!!!" ) {
	n = split($4,a,",");
	eth_ref[if_num] = a[n];
	n = split($1,a,",");
	router[if_num] = a[1];
	mtu[if_num] = $5;
	oper[if_num] = $6;
	avail[if_num] = $2;
	n = split($1,a,",");
	name[if_num] = a[n];
	if_num++;      
      }
      else {
	print "ERROR: Unable to read InterfaceIpv4, MO record is corrupted";
	if_num = 0;
	break;
      }      
    }
  }

# Read AddressIpv4 MO and store
 while (( getline < mo_ip ) > 0 ) {

   if ( $1 ~ /^IpRouter=.*,InterfaceIpv4=.*,AddressIpv4=.*/ ) {

    if ( $2 != "!!!!" ) {
      n = split($1,a,",");
      if_name = a[n-1];
      for( i=0 ; i<if_num ; i++ ) {
	if( if_name == name[i] ) {
	  ip[i] = $2;
	  break;
	}
      }
      
    } else {
	print "ERROR: Unable to read AddressIpv4, MO record is corrupted";
	ip_num = 0;
	break;
    }
   }
 }


# Read VRRP MOs and store
 while (( getline < mo_vrrp ) > 0 ) {
   if ( $1 ~ /^Vrrpv3Interface/ ) {
     
     if( $1 !~ /AddressIpv4/ ) {
       
       if ( $2 != "!!!!" ) {
	 n = split($1,a,",");
	 vrrpi_if[vrrpi_num] = a[1];
	 vrrpi_adv_int[vrrpi_num] = $3;
	 vrrpi_preemt[vrrpi_num] = $4;
	 vrrpi_id[vrrpi_num] = $5;
	 vrrpi_num++;
       } else {
	 print "ERROR: Unable to read Vrrpv3Interface, MO record is corrupted";
	 vrrpi_num = 0;
	 break;
       }
       
     } else {
       
       if ( $2 != "!!!!" ) {
	 n = split($1,a,",");
	 vrrpa_if[vrrpa_num] = a[1];
	 vrrpa_ip[vrrpa_num] = $2;
	 vrrpa_num++;
       } else {
	 print "ERROR: Unable to read AddressIpv4, MO record is corrupted";
	 vrrpa_num = 0;
	 break;
       }
     } 
   } else if( $1 ~ /^IpRouter.*,Vrrpv3Session/ ) {
     if ( $2 != "!!!!" ) {
       n = split($1,a,",");
       n = split(a[1],b,"=");
       vrrps_router[vrrps_num] = b[2];
       vrrps_ipif[vrrps_num] = a[2];
       vrrps_id[vrrps_num] = $2;
       vrrps_admin[vrrps_num] = $3;
       vrrps_prio[vrrps_num] = $5;
       vrrps_state[vrrps_num] = $6;
       if( $6 == 1 ) {
	 statename = "init";
       } else if ( $6 == 2) {
	 statename = "backup";
       } else if ( $6 == 3) {
	 statename = "master";
       }
       vrrps_statename[vrrps_num] = statename;
       vrrps_if[vrrps_num] = $8;       
       vrrps_num++;
     } else {
       print "ERROR: Unable to read Vrrpv3Interface, MO record is corrupted";
       vrrps_num = 0;
       break;
     }
       
   }
 }

# Read CAX Routing Table and store
 while( ( getline < mo_rt) > 0 ) {

   if( $1 ~ /^IpRouter=.*,Ipv4StaticRouteTable=.*,Ipv4DestNetwork=.*/ ) {
     if( $1 !~ /Ipv4StaticRoute=.*/ ) {
       # Destination Network
       if ( $2 != "!!!!" ) {
	 n = split($1,a,",");
	 rt_dn[rt_dn_num] = a[n];
	 rt_dn_prefix[rt_dn_num] = $3;
	 rt_dn_num++;
       } else {
	 print "ERROR: Unable to read Ipv4DestNetwork, MO record is corrupted";
	 rt_dn_num = 0;
	 break;
       }
     } else {
       # Static Route
       if( $2 != "!!!!" ) {
	 n = split($1,a,",");	 
	 rt_sr_dn[rt_sr_num] = a[3];
	 n = split(a[1],b,"=");	 
	 rt_sr_router[rt_sr_num] = b[2];
	 rt_sr_admin[rt_sr_num] = $3;
	 rt_sr_nh[rt_sr_num] = $5;
	 rt_sr_metric[rt_sr_num] = $6;
	 rt_sr_num++;	 
       } else {
	 print "ERROR: Unable to read Ipv4StaticRoute, MO record is corrupted";
	 rt_sr_num = 0;
	 break;
       }
     }      
   } else if( $1 ~ /^IpRouter=.*,Ipv4Peer=.*/ ) {
     if( $2 != "!!!!" ) {
       rt_peer[rt_peer_num] = $1;
       rt_peer_bfd[rt_peer_num] = $2;
       rt_peer_ip[rt_peer_num] = $3;
       rt_peer_num++;	 
     } else {
       print "ERROR: Unable to read Ipv4StaticRoute, MO record is corrupted";
       rt_peer_num = 0;
       break;
     }
   } else if( $1 ~ /^IpRouter=.*,Ipv4BfdSession=.*/ ) {
     if( $2 != "!!!!" ) {
       n = split($1,a,",");
       rt_bfd_session[rt_bfd_num] = a[n];
       rt_bfd_diag[rt_bfd_num] = $5;
       switch(rt_bfd_diag[rt_bfd_num]) {
       case 0:
	 rt_bfd_diagname[rt_bfd_num] = "";
	 break;
       case 1:
	 rt_bfd_diagname[rt_bfd_num] = "control detection time expired";
	 break;
       case 2:
	 rt_bfd_diagname[rt_bfd_num] = "echo function failed";
	 break;
       case 3:
	 rt_bfd_diagname[rt_bfd_num] = "neighbor signaled session down";
	 break;
       case 4:
	 rt_bfd_diagname[rt_bfd_num] = "forwarding plane reset";
	 break;
       case 5:
	 rt_bfd_diagname[rt_bfd_num] = "path down";
	 break;
       case 6:
	 rt_bfd_diagname[rt_bfd_num] = "concatenated path down";
	 break;
       case 7:
	 rt_bfd_diagname[rt_bfd_num] = "admin down";
	 break;
       case 8:
	 rt_bfd_diagname[rt_bfd_num] = "reverse concatenated path down";
	 break;
       case 32:
	 rt_bfd_diagname[rt_bfd_num] = "bfd session does not exist";
	 break;
       default:
	 rt_bfd_diagname[rt_bfd_num] = "null";
	 break;
       }
       rt_bfd_dstudp[rt_bfd_num] = $7;
       rt_bfd_peer[rt_bfd_num] = $8;
       rt_bfd_peer_ip[rt_bfd_num] = $11;
       n = split($12,a,"=");
       rt_bfd_if[rt_bfd_num] = a[n];
       rt_bfd_state[rt_bfd_num] = $13;
       switch( rt_bfd_state[rt_bfd_num] ){
       case 0:
	 rt_bfd_statename[rt_bfd_num] = "lock";
	 break;
       case 1:
	 rt_bfd_statename[rt_bfd_num] = "down";
	 break;
       case 2:
	 rt_bfd_statename[rt_bfd_num] = "init";
	 break;
       case 3:
	 rt_bfd_statename[rt_bfd_num] = "fail";
	 break;
       case 4:
	 rt_bfd_statename[rt_bfd_num] = "up";
	 break;
       default:
	 rt_bfd_statename[rt_bfd_num] = "null";
	 break;
       }

       rt_bfd_num++;
     } else {
       print "ERROR: Unable to read Ipv4BfdSession, MO record is corrupted";
       rt_bfd_num = 0;
       break;
     }
   }
 }


 printf("\nInterfaceIpv4");
 printf("\n%-20s   %-20s   %-20s   %-5s   %-5s   %-15s   %-5s   %-5s   %-s", 
	"router", 
	"if", 
	"ip", 
	"mtu", 
	"vlan", 
	"type", 
	"oper", 
	"avail",
	"active vip");

 for( i=0 ; i<if_num ; i++ ) {
   n = split(router[i],a,"=");
   router_name = a[n];
   n = split(name[i],a,"=");
   if_name = a[n];
   n = split(eth_ref[i],a,"=");
   vlan = a[n];
   vtype = a[n-1];

   vip = "";

   #### Find vip addresses that are active on this interface
   for(j=0 ; j<vrrps_num ; j++ ) {
     if(vrrps_ipif[j] ~ sprintf("%-s$",name[i]) && vrrps_state[j] == 3) {
       for(k=0 ; k<vrrpa_num ; k++) {
	 if(vrrpa_if[k] ~ sprintf("%-s$",vrrps_if[j])) {
	   vip = vip" "vrrpa_ip[k];
	   break;
	 }
       }
     }
   }


   printf("\n%-20s   %-20s   %-20s   %-5s   %-5s   %-15s   %-5s   %-5s   %-s", 
	  router_name, 
	  if_name, 
	  ip[i],
	  mtu[i],
	  vlan,
	  vtype,
	  oper[i], 
	  avail[i],
	  vip);
   
 }

 #### Go through vrrpv3interfaces and print each session connected to a certain interface
 printf("\n\nVrrp");
 printf("\n%-25s   %-20s   %-5s   %-20s   %-8s   %-5s   %-5s", 
	"name", 
	"router",
	"vrid",
	"vip",
	"state",
	"prio",
	"admin");
 
 for( i=0 ; i<vrrpi_num ; i++ ) {
   vrrpi_s1_idx = 0;
   vrrpi_s2_idx = 0;
   
   for( k=0 ; k<vrrps_num ; k++ ) {   

     if( vrrpi_if[i] ~ sprintf("%-s$",vrrps_if[k]) ) {
       if( vrrpi_s1_idx == 0 ) {
	 vrrpi_s1_idx = k;
       } else {
	 vrrpi_s2_idx = k;
	 break;
       }
     }
   }
   for( j=0 ; j<vrrpa_num ; j++ ) {
     if( vrrpi_if[i] ~ sprintf("%-s$",vrrpa_if[j]) ) {
       vip = vrrpa_ip[j];
     }
   }

   printf("\n%-25s   %-20s   %-5s   %-20s   %-8s   %-5s   %-5s", 
	  vrrps_id[vrrpi_s1_idx], 
	  vrrps_router[vrrpi_s1_idx], 
	  vrrpi_id[i],
	  vip,
	  vrrps_statename[vrrpi_s1_idx],
	  vrrps_prio[vrrpi_s1_idx],
	  vrrps_admin[vrrpi_s1_idx]);
   printf("\n%-25s   %-20s   %-5s   %-20s   %-8s   %-5s   %-5s", 
	  vrrps_id[vrrpi_s2_idx], 
	  vrrps_router[vrrpi_s2_idx], 
	  vrrpi_id[i],
	  vip,
	  vrrps_statename[vrrpi_s2_idx],
	  vrrps_prio[vrrpi_s2_idx],
	  vrrps_admin[vrrpi_s2_idx]);

 }

 #### Create and print Routing table
 printf("\n\nRouting Table");
 printf("\n%-20s   %-19s   %-16s   %-8s   %-6s   %-6s   %-20s",
	"router",
	"prefix",
	"next hop",
	"metric",
	"admin",
	"bfd",
	"if");

 for(i=0 ; i<rt_sr_num ; i++) {

   for(j=0 ; j<rt_dn_num ; j++) {
     if(rt_sr_dn[i] ~ sprintf("%-s$",rt_dn[j])) {
       rt_sr_prefix[i] = rt_dn_prefix[j];
       break;
     }
   }
     
   for(k=0 ; k<rt_peer_num ; k++) {
     if(rt_sr_nh[i] ~ sprintf("%-s$",rt_peer[k])) {
       rt_sr_peer_idx[i] = k;
       if(rt_peer_bfd[k] == "true") {
	 for(l=0 ; l<rt_bfd_num ; l++) {
	   if(rt_bfd_peer[l] == rt_peer[k]) {
	     rt_bfd_idx[i] = l; 
	     break;
	   }
	 }
       }
       break;
     }
   }

   printf("\n%-20s   %-19s   %-16s   %-8s   %-6s   %-6s   %-20s",
	  rt_sr_router[i],
	  rt_sr_prefix[i],
	  rt_peer_ip[rt_sr_peer_idx[i]],
	  rt_sr_metric[i],
	  rt_sr_admin[i],
	  rt_bfd_statename[rt_bfd_idx[i]],
	  rt_bfd_if[rt_bfd_idx[i]]);
 }

 printf("\n\nBFD Sessions");
 printf("\n%-18s   %-6s   %-6s   %-20s   %-6s   %-s",
	"peer",
	"state",
	"port",
	"if",
	"diag",
	"reason");
 for(i=0 ; i<rt_bfd_num ; i++) {
   for(j=0 ; j<rt_peer_num ; j++ ) {
     if( rt_peer[j] == rt_bfd_peer[i] ){
       peer_ip = rt_peer_ip[j];
       break;
     }
   }


   printf("\n%-18s   %-6s   %-6s   %-20s   %-6s   %-s",
	  peer_ip,
	  rt_bfd_statename[i],
	  rt_bfd_dstudp[i],
	  rt_bfd_if[i],
	  rt_bfd_diag[i],
	  rt_bfd_diagname[i]);  
 }
 print ""

}
