#For checking if some pmr KPIs are inconsistent between CONFIG and FORMULA file
#run with: gawk -v config=/path/to/config -v formula=/path/to/formula -f /path/to/validatepmrfiles.awk
#ex: gawk -v config=moshell/commonjars/pm/CONFIG_RNC_H_1_0.txt -v formula=moshell/commonjars/pm/FORMULA_RNC_H_1_0.txt -f moshell/commonjars/scripts/validatepmrfiles.awk
BEGIN{
	while (getline<formula)
	{
		if ($1 ~ /^#/) continue
		if ($1 ~ /=/) sub(/=/," = ")
		if ($2 == "=") formulalist[$1]=$1
		sub(/^.*=/,"")
		for(i=1;i<=NF;i++) 
		{
			if ($i !~ /[a-zA-Z]/) continue
			gsub(/[(-+/*)]/,"",$i)
			if ($i ~ /^(pm|sum_|WeightedAvera|WeightedPercen|log10)/) continue
			referencedformula[$i]=$i
		}
	}
	close(formula)
	
	while (getline<config)
	{
		if ($1 ~ /^#/) continue
		if ($2 != "counter") continue
		split($3,array,",")
		for (i in array) if (array[i] !~ /^pm/) configlist[array[i]]=array[i]
	}
	close(config)
	
	print "Undefined formulas referenced within formula file: "
	for (i in referencedformula) if (!(i in formulalist)) print "  "i
	print "\nUndefined formulas referenced within config file: "
	for (i in configlist) if (!(i in formulalist)) print "  "i
}
