#!/usr/bin/perl
#
#
#
#  v0.01 ecarnsa:	 plot in 3D the distribuction of the RSSI in the "pmr" command... need a proper CONFIG file.
# 
#
#
#  
# (this script require to install "gnuplot" under cygwin)
#

use strict;
use FileHandle;




my (@Object_array, @unique_object, @name_file, @title_plot);
my (@data, @temp, @ytics);
my %Kpi;
my $var;
my $xtics;
my $index = 0;
my @time;
my ($i,$k,$j,$title,$usage);
my ($date, $time, $Object, $value, $list, $time_object);
my $offset=0;
my $counter_index;
my ($license,$string);
my $flag="";
my (@file, @data, @temp);
my $index = 0;
my @time;
my ($i,$k,$j,$ytics,$usage);
my $folder=".";


@ARGV == 0 or @ARGV == 2 or die $usage;
if (defined $ARGV[1]) {
	if ($ARGV[0] eq "-out") { $folder = $ARGV[1]; } else { die(" argument not correct"); }
	}


while (<STDIN>) {
	$date = "";
	if (/^(\d\d\d\d-\d\d-\d\d) (\d\d:\d\d) (\S+) (.*)/) { $date=$1; $offset=1;} #set an offset in case there is also the date
	if (/(\d\d:\d\d) (\S+) (.*)/) { $time = $1; $Object= $2; $value=$3; print $date." ".$time." ".$Object." ".$value."\n";
		$time_object = $date." ".$time." ".$Object;
	$Kpi{$time_object} = $value;
	$Object_array[$index] = $Object; 
	$index ++;
	}
}


my %temp;
@unique_object = grep { ! $temp{$_}++ } @Object_array;
$list = @unique_object;

for ($i=0; $i<$list; $i++) {
	$name_file[$i]=$unique_object[$i];
	$title_plot[$i]=$unique_object[$i];
	$name_file[$i]=~s/,/_/g;
	$title_plot[$i]=~s/_/_-/g;
}


for ($j=0; $j<$list; $j++) {

$counter_index = 0;

open OUTPUTFILE, ">".$folder."/temp_RSSI.txt";

foreach $var (sort keys %Kpi) {
	if ($var =~ $unique_object[$j]) {

	$counter_index ++;
	#print "$var   $Kpi{$var} \n";
	if ($var=~ /(\d\d:\d\d) \S+/) {$time[$counter_index]=$1;}
	#print $Kpi{$var}." aaa\n";
	@data = split(',',$Kpi{$var});
	#print $time[$index]."  a  ".$file[$index]."\n";
	#print "@data\n\n\n";
	if (scalar(@data) > 0) {
		for ($i=0; $i<scalar(@data); $i++) {
			print OUTPUTFILE (($i+1)." ".$data[$i]."\n");
		}
		print OUTPUTFILE ("\n");
		for ($i=0; $i<scalar(@data); $i++) {
			print OUTPUTFILE (($i+1)." 0\n");
		}
		print OUTPUTFILE ("\n");
		}
	else {   ### to handle the cases when the ROP is empty.
		print OUTPUTFILE ("1 0\n\n");
		print OUTPUTFILE ("1 0\n\n");
		}
	}
}
#print $index;

$ytics = 'set ytics (';
for ($k=1; $k<scalar(@time); $k=$k+4) {
if ($k==1) { $ytics = $ytics.'"'.$time[$k].'"'.($k-1);}
else { $ytics = $ytics.',"'.$time[$k].'"'.($k-1);}
}
$ytics = $ytics.")";
#print $ytics;
close OUTPUTFILE;

#print "k= ".$k." counter_index= ".$counter_index."\n";

open (GP, "| gnuplot ") or die "no gnuplot";
GP->autoflush(1);
print GP "set terminal pngcairo size 1200,800 enhanced font 'Verdana,10'\n";
print GP "set output '",$folder,"/",$name_file[$j],"_pmAverageRSSI.png'\n";
print GP "unset key\n";
print GP "unset colorbox\n";
print GP "set tmargin 0\n";
print GP "set lmargin 0\n";
print GP "set bmargin 0\n";
print GP "set rmargin 0\n";
print GP "set pal defined (1 '#00008f', 8 '#0000ff', 24 '#00ffff', 40 '#ffff00', 56 '#ff0000', 64 '#800000')\n";
print GP "set ytics offset -0.9,-0.1\n";
print GP "set xtics offset -0.2,-0.1\n";
print GP "set ztics offset 1.6,0.3\n";
print GP "set ticslevel 0\n";
print GP "col = ",$k,"\n";
print GP "set xtics font 'Verdana,8'\n";
print GP "set ytics font 'Verdana,8'\n";
print GP "set ztics font 'Verdana,8'\n";

print GP "set xtics nomirror\n";
print GP "set ytics nomirror\n";

print GP 'set xtics ("-110" 1, "-107,5" 6, "-105" 11 , "-102,5" 16, "-100" 21, "-97,5" 26, "-95" 31, "-92,5" 36, "-90" 41, "-87,5" 46, "-85" 51, "-82,5" 56, "-80" 61, "-70" 63, "-65" 65)
';
print GP $ytics."\n";
print GP "set mytics 4\n";
print GP "set xlabel 'Power [dBm]' font 'Verdana,15'\n";
print GP "set ylabel 'Time' font 'Verdana,15'\n";
print GP "set zlabel rotate by 90 \n";
print GP "set zlabel offset 9,2 \n";
print GP "set zlabel 'Number of samples' font 'Verdana,15'\n";

print GP "set view 45,145\n";
print GP "set xyplane 0\n";
print GP "set multiplot;\n";
print GP "splot for [i=0:col-1] '".$folder."/temp_RSSI.txt' every :::(2*i)::(2*i+1) u 1:(i):2:(i+2) w pm3d\n";
print GP "unset border; unset xtics; unset ytics; unset key\n";
print GP "set xrange[0:10]; set yrange[0:10]\n";
print GP "set label 'pmAverageRssi' font 'Verdana,20' at 2,8.5\n";
print GP "set label '",$title_plot[$j],"' font 'Verdana,14' at 2,8\n";
print GP "plot 1/0\n";
print GP "unset multiplot;\n";
close GP;

}

#print "\n\n     ",$name_file,".png was created\n\n";

