#!/usr/bin/perl
#
#
#  v0.01 ecarnsa:	 plot the PmPropagationDelay counter under the "pmr" command... need a proper CONFIG file.
# 
#
#
#
# (this script require to install "gnuplot" under cygwin)
#

use strict;
use FileHandle;

$0=~/^(.+[\\\/])[^\\\/]+[\\\/]*$/;  #to find the path of this file.
my $dir= $1 || "./";

my (@Object_array, @unique_object, @name_file, @title_plot);
my (@data, @temp, @ytics);
my %Kpi;
my $var;
my $index = 0;
my @time;
my ($i,$k,$j,$usage);
my ($date, $time, $Object, $value, $list, $time_object);
my $offset=0;
my $counter_index;
my $distance;
my $folder=".";


@ARGV == 0 or @ARGV == 2 or die $usage;
if (defined $ARGV[1]) {
	if ($ARGV[0] eq "-out") { $folder = $ARGV[1]; } else { die(" argument not correct"); }
	}


while (<STDIN>) {
	$date = "";
	if (/^(\d\d\d\d-\d\d-\d\d) (\d\d:\d\d) (\S+) (.*)/) { $date=$1; $offset=1;} #set an offset of one in case there is also the date
	if (/(\d\d:\d\d) (\S+) (.*)/) { $time = $1; $Object= $2; $value=$3; print $date." ".$time." ".$Object." ".$value."\n";
		$time_object = $date." ".$time." ".$Object;
	$Kpi{$time_object} = $value;
	$Object_array[$index] = $Object; 
	$index ++;
	}
}


###  Find the unique elements of $Object_array
my %temp;
@unique_object = grep { ! $temp{$_}++ } @Object_array;
$list = @unique_object;

for ($i=0; $i<$list; $i++) {
	$name_file[$i]=$unique_object[$i];
	$title_plot[$i]=$unique_object[$i];
	$name_file[$i]=~s/,/_/g;
	$title_plot[$i]=~s/_/_-/g;
}



for ($j=0; $j<$list; $j++) {

$counter_index = 0;
open OUTPUTFILE, ">".$folder."/temp_propDelay.txt";
print OUTPUTFILE ("1 0 10\n 1 0 0\n");   			#to avoid a faulty plot file in case all the samples are 0 (sleeping cell)
foreach $var (sort keys %Kpi) {
	if ($var =~ $unique_object[$j]) {

	$counter_index ++;
	if ($var=~ /(\d\d:\d\d) \S+/) {$time[$counter_index]=$1;}
	@data = split(',',$Kpi{$var});
	  if (scalar(@data) > 0) {
		for ($i=1; $i<scalar(@data); $i++) {
			if ($data[$i] != 0) {
			print OUTPUTFILE (($i-1)." ".$counter_index." ".$data[$i]."\n");
			$distance = sprintf '%.4g',($data[0]*78.3/1000);
			}
		}	
	  }
	}
}
close OUTPUTFILE;

# define the x axis

for ($k=1; $k<scalar(@time); $k=$k+8) {
	$ytics[$k/8]=$time[$k];
}

open (GP, "| gnuplot ") or die "no gnuplot";
GP->autoflush(1);
print GP "set terminal pngcairo size 1200,800 enhanced font 'Verdana,14'\n";    #set the output to png file with size 1200x800
print GP "set output '",$folder,"/",$name_file[$j],"_pmpropagationdelay.png'\n";		    #Set name of the file output
print GP "unset border\n";														#hide the axis
print GP "set angles degrees\n";							
print GP "unset key\n";															#hide the legend
print GP "set parametric\n";													#use variable u and v
print GP "set view map\n";														#3d view from the top (become a 2d view)
print GP "set size ratio 0.5 1,1\n";
print GP "set rmargin 50\n";
print GP "set bmargin -2\n";
print GP "set style data lines\n";
print GP "set xtics scale 0\n";
printf GP 'set xtics ("0" 0.2, "%.1f" 0.29, "%.1f" 0.402, "%.1f" 0.563, "%.1f" 0.82) nomirror  offset graph 0, -0.005',($distance/7),($distance*2/7),($distance*4/7),$distance;
print GP "\n";
print GP "unset ytics\n";
print GP "set title 'pmPropagationDelay' offset -1.5,3.5 font 'Verdana,20'\n";
print GP "set xrange [ -0.6 : 1.2 ]\n";
print GP "set yrange [ 0 : 0.9 ]\n";
print GP "set pal defined (0 '#FFFFFF', 0.000001 '#FFFFFF', 0.000001 '#0000B8', 4 '#0000ff', 28 '#00f8f8', 40 '#08ffff', 60 '#00f8f8', 120 '#f8f800', 180 '#ffff08', 300 '#ff0f0f', 384 '#ff0000', 512 '#B00000')\n";
print GP "set multiplot\n";
print GP "splot '".$folder."/temp_propDelay.txt' u (cos(\$2*180/96)*((\$1/66)+0.2)):(sin(\$2*180/96)*((\$1/66)+0.2)):3 title 'pmPropagationDelay' w p pt 7 ps 1 lc palette\n";
print GP "unset parametric\n";
print GP "set polar\n";
print GP "set xrange [ -0.9 : 0.9 ]\n";
print GP "set yrange [ 0 : 0.9 ]\n";
print GP "set angles degrees\n";
print GP "set rmargin 26\n";
print GP "set bmargin 1\n";
print GP "set size ratio 0.5 1,1\n";
print GP "unset label\n";
print GP "unset title\n";
print GP "unset xtics\n";
print GP "set arrow from 0.2,0 to 1,0 lw 2.5\n";									# X axis 
print GP "set arrow from 0.05,0.8 to -0.15,0.8 lw 2.3\n";

print GP "set label '",$ytics[0],"' at 0.81,0 offset char 0,0.8\n";
for ($k=1; $k<scalar(@ytics); $k++) {print GP "set label '",$ytics[$k],"' at 0.81*cos(",(($k*15)+2),"),0.81*sin(",(($k*15)+2),") rotate by ",($k*15),"\n";}
print GP "set label 'Distance    [Km]' at 0.4,-0.11\n";
print GP "set label 'Time' at -0.2,0.85\n";
print GP "set label 'Number of Preambles' at 1.1 ,0.2 rotate by 90\n";
print GP "set arrow from 0.8*cos(17),0.8*sin(17) to 0,0 lw 1 linetype 0 lc rgbcolor '#000000'\n";
print GP "set arrow from 0.8*cos(32),0.8*sin(32) to 0,0 lw 1 linetype 0 lc rgbcolor '#000000'\n";
print GP "set arrow from 0.8*cos(47),0.8*sin(47) to 0,0 lw 1 linetype 0 lc rgbcolor '#000000'\n";
print GP "set arrow from 0.8*cos(62),0.8*sin(62) to 0,0 lw 1 linetype 0 lc rgbcolor '#000000'\n";
print GP "set arrow from 0.8*cos(77),0.8*sin(77) to 0,0 lw 1 linetype 0 lc rgbcolor '#000000'\n";
print GP "set arrow from 0.8*cos(92),0.8*sin(92) to 0,0 lw 1 linetype 0 lc rgbcolor '#000000'\n";
print GP "set arrow from 0.8*cos(107),0.8*sin(107) to 0,0 lw 1 linetype 0 lc rgbcolor '#000000'\n";
print GP "set arrow from 0.8*cos(122),0.8*sin(122) to 0,0 lw 1 linetype 0 lc rgbcolor '#000000'\n";
print GP "set arrow from 0.8*cos(137),0.8*sin(137) to 0,0 lw 1 linetype 0 lc rgbcolor '#000000'\n";
print GP "set arrow from 0.8*cos(152),0.8*sin(152) to 0,0 lw 1 linetype 0 lc rgbcolor '#000000'\n";
print GP "set arrow from 0.8*cos(167),0.8*sin(167) to 0,0 lw 1 linetype 0 lc rgbcolor '#000000'\n";
print GP "plot [2:90] 0.8005 notitle w l lw 3.5 lc rgbcolor '#000000'\n";
print GP "plot [0:180] 0.2 notitle w l lw 1 linetype 0 lc rgbcolor '#000000'\n";
print GP "plot [0:180] 0.285714 notitle w l lw 1 linetype 0 lc rgbcolor '#000000'\n";
print GP "plot [0:180] 0.371428 notitle w l lw 1 linetype 0 lc rgbcolor '#000000'\n";
print GP "plot [0:180] 0.542857 notitle w l lw 1 linetype 0 lc rgbcolor '#000000'\n";
print GP "plot [0:180] 0.8 notitle w l lw 1 linetype 0 lc rgbcolor '#000000'\n";
print GP "reset\n";
print GP "unset border\n";
print GP "unset xtics\n";
print GP "unset ytics\n";
print GP "set object 1 rect fc rgbcolor '#FFFFFF' fillstyle solid 1.0 noborder\n";
print GP "set object 1 rect from 165,-15 to 170,-30\n";
print GP "set label '1' at 166,-23 \n";
print GP "\n";
print GP "\n";
print GP "\n";
print GP "\n";
print GP "set label '".$title_plot[$j]."' at 25,150\n";
print GP "plot [-80:180][-80:180] '",$dir,"rbs.png' binary filetype=png origin=(8,-25)  dx=0.4 dy=0.4 with rgbimage notitle\n";
print GP "unset multiplot\n";

close GP;
}