/* Copyright (C) 2007 Ericsson AB 
 */

#include "wrapper.h"


time_t 
time(
  time_t*  t)
{
  if (wrapper_ctx.thread != pthread_self()) {
    lib_init();
  }

  if (!wrapper_ctx.active || getenv("TIME_DISABLE")) {
    return wrapper_ctx.real_funcs.time(t);
  }

  wrapper_log(1,0);

  TRY_CONNECT();

  if (!wrapper_ctx.simics_ctx) {
    wrapper_log(1, "*** Not connected to Simics, using real: %s\n", __FUNCTION__);
    return wrapper_ctx.real_funcs.time(t);
  }

  double sim_time = simics_get_time();

  if (t) {
    *t = (time_t) sim_time;
  }

  return (time_t) sim_time;
}

#if 0
#ifdef __sun__
int 
gettimeofday(
  struct timeval*   tv, 
  void*             tz)
#else
int 
gettimeofday (
  struct timeval *tv,
  __timezone_ptr_t tz)
#endif
{
  if (wrapper_ctx.thread != pthread_self()) {
    lib_init();
  }

  if (!wrapper_ctx.active || getenv("TIME_DISABLE")) {
    return wrapper_ctx.real_funcs.gettimeofday(tv, tz);
  }

  wrapper_log(1,0);

  TRY_CONNECT();

  if (!wrapper_ctx.simics_ctx) {
    wrapper_log(1, "*** Not connected to Simics, using real: %s\n", __FUNCTION__);
    return wrapper_ctx.real_funcs.gettimeofday(tv, tz);
  }

  // this is a small cheat to lett CPPemu run 
  struct timespec s = {0, 5000};
  wrapper_ctx.real_funcs.nanosleep(&s, 0);

  double   sim_time = simics_get_time();

  if (tv) {
    tv->tv_sec  = (time_t) sim_time;
    tv->tv_usec = (suseconds_t) ((sim_time - tv->tv_sec) * USEC_PER_SEC);
    tv->tv_sec += 1393689641;
  }

#ifdef __sun__ 
  (void) tz;
#else
  if (tz) {
    tz->tz_minuteswest = 0;
    tz->tz_dsttime     = 0;
  }
#endif

  wrapper_log(5, "*** %s: timeval %ld %ld\n", __FUNCTION__, tv->tv_sec, tv->tv_usec);

  return 0;
}
#endif
#ifdef __sun__
#define HANDLE_COMMON_CLOCK(func_)                               \
do {                                                             \
  if (wrapper_ctx.thread != pthread_self()) {                             \
    lib_init();                                                  \
  }                                                              \
                                                                 \
  if (!wrapper_ctx.active || getenv("TIME_DISABLE")) {           \
    return wrapper_ctx.real_funcs.clock_ ## func_(clk_id, tp);   \
  }                                                              \
                                                                 \
  wrapper_log(1,0);                                                \
                                                                 \
  switch (clk_id) {                                              \
    case CLOCK_REALTIME:                                         \
    case CLOCK_HIGHRES:                                          \
      break;                                                     \
                                                                 \
    default:                                                     \
      return wrapper_ctx.real_funcs.clock_ ## func_(clk_id, tp); \
  }                                                              \
                                                                 \
  TRY_CONNECT();                                                 \
                                                                 \
  if (!wrapper_ctx.simics_ctx) {                                 \
    wrapper_log(1, "*** Not connected to Simics, using real: %s\n", __FUNCTION__); \
    return wrapper_ctx.real_funcs.clock_ ## func_(clk_id, tp);   \
  }                                                              \
} while (0)
#else
#define HANDLE_COMMON_CLOCK(func_)                               \
do {                                                             \
  if (wrapper_ctx.thread != pthread_self()) {                             \
    lib_init();                                                  \
  }                                                              \
                                                                 \
  if (!wrapper_ctx.active || getenv("TIME_DISABLE")) {           \
    return wrapper_ctx.real_funcs.clock_ ## func_(clk_id, tp);   \
  }                                                              \
                                                                 \
  wrapper_log(1,0);                                              \
                                                                 \
  switch (clk_id) {                                              \
    case CLOCK_MONOTONIC:                                        \
    case CLOCK_REALTIME:                                         \
      break;                                                     \
                                                                 \
    case CLOCK_PROCESS_CPUTIME_ID:                               \
    case CLOCK_THREAD_CPUTIME_ID:                                \
    default:                                                     \
      return wrapper_ctx.real_funcs.clock_ ## func_(clk_id, tp); \
  }                                                              \
                                                                 \
  TRY_CONNECT();                                                 \
                                                                 \
  if (!wrapper_ctx.simics_ctx) {                                 \
    wrapper_log(1, "*** Not connected to Simics, using real: %s\n", __FUNCTION__); \
    return wrapper_ctx.real_funcs.clock_ ## func_(clk_id, tp);   \
  }                                                              \
} while (0)
#endif

int 
clock_gettime(
  clockid_t         clk_id, 
  struct timespec*  tp)
{
  HANDLE_COMMON_CLOCK(gettime);

  double   sim_time = simics_get_time();

  if (tp) {
    tp->tv_sec  = (time_t) sim_time;
    tp->tv_nsec = (suseconds_t) ((sim_time - tp->tv_sec) * NSEC_PER_SEC);
  }

  return 0;
}

int
clock_settime(
  clockid_t                clk_id, 
  const struct timespec *  tp)
{
  HANDLE_COMMON_CLOCK(settime);

  errno = EPERM;
  return -1;
}

int 
clock_getres(
  clockid_t         clk_id, 
  struct timespec * tp)
{
  HANDLE_COMMON_CLOCK(getres);

  if (tp) {
    tp->tv_sec  = 0;
    tp->tv_nsec = 500000000l;
  }

  return 0;
}

int 
nanosleep(
  const struct timespec* req, 
  struct timespec*       rem)
{
  if (wrapper_ctx.thread != pthread_self()) {
    lib_init();
  }

  if (!wrapper_ctx.active || getenv("TIME_DISABLE")) {
    return wrapper_ctx.real_funcs.nanosleep(req, rem);
  }

  wrapper_log(1,0);

  TRY_CONNECT();
                                                                 \
  if (!wrapper_ctx.simics_ctx) {
    wrapper_log(1, "*** Not connected to Simics, using real: %s\n", __FUNCTION__);
    return wrapper_ctx.real_funcs.nanosleep(req, rem);
  }

  double delay = req->tv_sec;

  delay += (double)req->tv_nsec / NSEC_PER_SEC;
  simics_delay(delay);

  if (rem) {
    rem->tv_sec  = 0;
    rem->tv_nsec = 0;
  }
  
  return 0;
}

#ifdef __sun__
#define POLL()                 \
do {                           \
  struct timeval  s = {0, 0};  \
  int ret = wrapper_ctx.real_funcs.select(n, readfds, writefds, exceptfds, &s); \
  if (ret) {                   \
    return ret;                \
  }                            \
} while (0)
#else
#define POLL()                 \
do {                           \
  struct timeval  s = {0, 0};  \
  if(readfds)   localRead   = *readfds;	  \
  if(writefds)  localWrite  = *writefds;  \
  if(exceptfds) localExcept = *exceptfds; \
  int ret = wrapper_ctx.real_funcs.select(n, (readfds==NULL) ? (NULL) : (&localRead), (writefds==NULL)?(NULL):(&localWrite), (exceptfds=NULL)?(NULL):(&localExcept), &s); \
  if (ret) {                   \
    *tv = t;                   \
    if(readfds)   *readfds   = localRead; \
    if(writefds)  *writefds  = localWrite; \
    if(exceptfds) *exceptfds = localExcept; \
    return ret;                \
  }                            \
} while (0)
#endif

int 
select(
  int              n, 
  fd_set*          readfds, 
  fd_set*          writefds,
  fd_set*          exceptfds,
  struct timeval*  tv)
{
     fd_set localRead;
     fd_set localWrite;
     fd_set localExcept;

  if (wrapper_ctx.thread != pthread_self()) {
    lib_init();
  }

  if (!wrapper_ctx.active || getenv("TIME_DISABLE")) {
    return wrapper_ctx.real_funcs.select(n, readfds, writefds, exceptfds, tv);
  }

  wrapper_log(1,0);

  TRY_CONNECT();
                                                                 \
  if (!wrapper_ctx.simics_ctx) {
    wrapper_log(1, "*** Not connected to Simics, using real: %s\n", __FUNCTION__);
    return wrapper_ctx.real_funcs.select(n, readfds, writefds, exceptfds, tv);
  }

  if (!tv) {
    wrapper_log(5, "*** timeval 0, using real: %s\n", __FUNCTION__);
    return wrapper_ctx.real_funcs.select(n, readfds, writefds, exceptfds, 0);
  }

  wrapper_log(5, "*** %s: timeval %ld %ld\n", __FUNCTION__, tv->tv_sec, tv->tv_usec);

  struct timeval  t = *tv;

  POLL();

  while (t.tv_sec || t.tv_usec) {
    if (t.tv_sec && t.tv_usec < (USEC_PER_SEC / 2)) {
      --t.tv_sec;
      t.tv_usec += USEC_PER_SEC;
    }

    double delay;

    if (t.tv_usec >= (USEC_PER_SEC / 2)) {
      delay = 0.5;
      t.tv_usec -= USEC_PER_SEC / 2;
    } else {
      delay = (double) t.tv_usec / USEC_PER_SEC;
      t.tv_usec = 0;
    }

    simics_delay(delay);

    POLL();
  }

  if(readfds)   *readfds = localRead;
  if(writefds)  *writefds = localWrite;
  if(exceptfds) *exceptfds = localExcept;

  return 0;
}
