#!/usr/bin/perl -w

#  v0.01 ecarnsa:	 plot for "pmr" command... need a proper CONFIG file.
#  v0.02 ecarnsa:	 when all the elements in a column are "N/A" gnuplot print an error;
#					 replace all the N/A with 0 
#  v0.03 ecarnsa:    avoid the Warning message: empty y range [0:0], adjusting to [-1:1]
#  v0.04 ecarnsa:	 introduced an ordering to avoid overlapping of graphs
#  v0.05 ecarnsa:	 exclude the ROP files when not all the counters/kpis are present
#  v0.06 ecarnsa:	 avoid the Warning message: empty y range [100:100], adjusting to [99:101]

#***************************************************************************************
#									                     >------------ Kpi position 1 ---------------------<  >------------- Kpi position 2 --------------------<  .....
# KPIgnuplot_diff1.pl [-out <directory>] <Kpi_1> <Kpi_2> <KpiName> <histogram>|<line> <left>|<right> <order>  <KpiName> <histogram>|<line> <left>|<right> <order> [<KpiName> <histogram>|<line> <left>|<right> <order>] [<KpiName> <histogram>|<line> <left>|<right> <order>] ... 
#***************************************************************************************

#The <Kpi_1> and <Kpi_2> are numbers that rappresent the position of the KPIs. they are part of the formula: <diff> = <Kpi_1> - <Kpi_2>;
#(below graph with 30% of the space)
#
#The <KpiName> (mandatory) indicates the name of the Kpi.
#
#The <histogram>|<line> (mandatory) indicates the type of graph: can be histogram or line.
#
#The <left>|<right> (mandatory) indicates where the y axis shold be rappresent
#
#The <order> take into account to plot order in "pmr" command: if you plot 2 histogram make sure to plot before the one with higher number otherwise you will not see it:
#   for example plot always the "Attempt" before the "Success".
#	Keep the "line" plot after the "histogram".
#
#
#
#Any further arguments must be a new set of the 4 arguments described above.

### NOTE: limited the number of histogram to 4 per plot... 
# with more than 2 histograms, the plot become unreadable!

use strict;
use FileHandle;


my (@Object_array, @unique_object, @name_file, @title_plot, @order_for_diff);
my $offset = 0;
my %Kpi;
my ($i,$k,$j);
my ($var,$kpi1,$kpi2,$string);
my $index=0;
my ($date, $time, $Object, $value, $list, $time_object);
my ($usage,$arg_index);
my (@type, @kpi_name, @position, @flagNA, @value_temp, @order ,@sorting, @kpi_name_diff);
my ($number_kpi,$flag0_y, $flag0_y2, $flag_diff0,$flag100_y, $flag100_y2);
my ($string1, $string2, $y1_label, $y2_label);
my $folder=".";
my %table_pointtype = (
0 => 5,
1 => 7,
2 => 9,
3 => 11,
4 => 13,
);
my %colour_histogram = (
1 => 5,
2 => 3,
3 => 6,
4 => 1,
);

####  need to add the usage and the die to exit in case of wrong ARGV entry!

if ($ARGV[0] eq "-out") { $folder = $ARGV[1]; shift(@ARGV); shift(@ARGV);}

$arg_index=0;

$kpi1=shift(@ARGV);
$kpi2=shift(@ARGV);

while (@ARGV > 0) { #while there are arguments left
	$kpi_name[$arg_index] = shift(@ARGV);
	$type[$arg_index] = shift(@ARGV);
	$position[$arg_index] = shift(@ARGV);
	$order[$arg_index] = shift(@ARGV);
	$sorting[$arg_index]=[$order[$arg_index],$kpi_name[$arg_index],$type[$arg_index],$position[$arg_index],$arg_index];
	$arg_index++;
}	

# define the name of the diff plot

$kpi_name_diff[0] = $kpi_name[$kpi1-1];
$kpi_name_diff[1] = $kpi_name[$kpi2-1];

# must map the right line before reordering....

$kpi1=$order[$kpi1-1];
$kpi2=$order[$kpi2-1];


### sort the 4 arrays base on $order to plot the KPIs in the right order ###

@sorting = sort { $$a[0] <=> $$b[0] } @sorting;
@order = map { $$_[4] } @sorting;
@kpi_name = map { $$_[1] } @sorting;
@type = map { $$_[2] } @sorting;
@position = map { $$_[3] } @sorting;


$number_kpi=@kpi_name;

while (<STDIN>) {
	$date = "";
	if (/^(\d\d\d\d-\d\d-\d\d) (\d\d:\d\d) (\S+) (.*)/) { $date=$1; $offset=1;} #set an offset of one in case there is also the date
	if (/(\d\d:\d\d) (\S+) (.*)/) { $time = $1; $Object= $2; $value=$3; print $date." ".$time." ".$Object." ".$value."\n";
		$time_object = $date." ".$time." ".$Object;
		@value_temp = split(/\s+/,$value);
		shift(@value_temp);
		if (scalar(@value_temp) eq ($number_kpi)) {   # avoid the ROPs where not all the values are present
			$string = "";
			foreach $i (@order) {
					$string = $string." ".$value_temp[$i];   #save the value already in the right order
			}
			$Kpi{$time_object} = $string;
			$Object_array[$index] = $Object; 
			$index ++;
		}	
	}
}

###  Find the unique elements of $Object_array to define the number of file to create -> $list
my %temp;
@unique_object = grep { ! $temp{$_}++ } @Object_array;
$list = @unique_object;

for ($i=0; $i<$list; $i++) {
	$name_file[$i]=$unique_object[$i];
	$title_plot[$i]=$unique_object[$i];
	$name_file[$i]=~s/,/_/g;
	$title_plot[$i]=~s/_/_-/g;
}

for ($j=0; $j<$list; $j++) {
	open (GP, "|gnuplot ") or die "no gnuplot";
	GP->autoflush(1);
	
	print GP "set terminal pngcairo size 1600,800 enhanced font 'Verdana,10'\n";
	print GP "set output '",$folder,"/",$name_file[$j],"_",$kpi_name[0],"_",localtime(time),".png'\n";
	print GP "set key outside center top horizontal box\n";
	print GP "set datafile missing 'N/A'\n";
	print GP "set xdata time\n";
		
	if ($offset == 1) { print GP "set timefmt '%Y-%m-%d %H:%M'\n";}
	else {print GP "set timefmt '%H:%M'\n";}
	
	print GP "set xtics format '%H:%M'\n";
	print GP "set xtic rotate by -90 scale 0\n";
	print GP "set lmargin 10\n";
	print GP "set rmargin 10\n"; 
	print GP "set xtics textcolor rgbcolor '#FFFFFF'\n";
	print GP "set multiplot\n";
	print GP "set size 1, 0.7\n";
	print GP "set origin 0, 0.3\n";
	print GP "set tmargin 4\n";
	print GP "set bmargin 0\n";
	print GP "set ytics nomirror\n";
	print GP "set y2tics\n";
	print GP "set ytics offset 0,0.5\n";
	print GP "set style fill solid border lc rgbcolor '#505050'\n";
	print GP "set grid front\n";
	print GP "set grid y2tics front\n";
	for ($k=0; $k < $number_kpi; $k++) { print GP "set style line ",($k+1)," lt ",($k+1)," lw 2 pt ", $table_pointtype{($k+1) % 5} ," ps 1\n"; }
	
	print GP " set title '", $title_plot[$j],"' font 'Verdana,14'\n";
	$string2="";

	my $histcolour=1;
	my $linecolour=1;
	$y1_label="";
	$y2_label="";
	for ($k=0; $k < $number_kpi; $k++) {
		if ($position[$k] eq "left") {$string1 = "x1y1 ";$y1_label=$y1_label.$kpi_name[$k].",  ";}
		if ($position[$k] eq "right") {$string1 = "x1y2 ";$y2_label=$y2_label.$kpi_name[$k].",  ";}

		if ($type[$k] eq "histogram") {$string1 = $string1."with boxes lc ".$colour_histogram{($histcolour)};$histcolour++;}
		if ($type[$k] eq "line") {$string1 = $string1."with lp ls ".($linecolour);$linecolour++;}
		$string2 = $string2." '-' u 1:".($k+3+$offset).":xtic(".($offset+1).") title '".$kpi_name[$k]."' axes ".$string1.",";
	}

	$string2= substr($string2,0,length($string2)-1);   #define the string to create the plot 
	
	print GP "set ylabel '".substr($y1_label,0,length($y1_label)-3)."'\n";
	print GP "set y2label '".substr($y2_label,0,length($y2_label)-3)."'\n";

	### if all the samples are N/A, gnuplot print a error message, 
####### from here to "END" 
	### fix for this problem replacing N/A with 0 for the column that has all the samples equal to N/A

	#### implemented the fix when all the sample are 0.
	#### implemented the fix when all the sample are 100.

	@flagNA = (1) x $number_kpi;    # inizialization of @flag to 1; @flag will set to 0 if at least 1 of the samples is different from "N/A"
	$flag0_y = 1;
	$flag0_y2 = 1;
	$flag_diff0 = 1;
	$flag100_y = 1;
	$flag100_y2 = 1;


	foreach $var (keys %Kpi) {
		if ($var =~ $unique_object[$j]) {
		@value_temp = split(/\s+/,$Kpi{$var});
		shift(@value_temp);
			for ($i=0; $i<$number_kpi; $i++) {
			 if (defined $value_temp[$i]) {
			   if ($value_temp[$i] ne "N/A") {$flagNA[$i]="0";}
			   if ($value_temp[$i] ne "0" && $value_temp[$i] ne "N/A") {
					if ($position[$i] eq "left") {$flag0_y=0;}
					if ($position[$i] eq "right") {$flag0_y2=0;}
				}
			   if ($value_temp[$i] ne "100" && $value_temp[$i] ne "N/A") {
					if ($position[$i] eq "left") {$flag100_y=0;}
					if ($position[$i] eq "right") {$flag100_y2=0;}
				}
			 }
			}
			if ($value_temp[$kpi1-1] ne $value_temp[$kpi2-1]) {$flag_diff0=0;}
		}
	}	
	
	foreach $var (keys %Kpi) {
		if ($var =~ $unique_object[$j]) {
		@value_temp = split(/\s+/,$Kpi{$var});
		shift(@value_temp);
			for ($i=0; $i<$number_kpi; $i++) {
			   if ($flagNA[$i] eq 1) {$value_temp[$i]=0;}
			}
			$Kpi{$var} = "";
			for ($i=0; $i<$number_kpi; $i++) {
				$Kpi{$var} = $Kpi{$var}." ".$value_temp[$i];
			}
		}
	}	
	
	
####### END

	if ($flag0_y == 1) {print GP "set yrange [0:1] \n";}
	if ($flag0_y2 == 1) {print GP "set y2range [0:1] \n";}
	if ($flag100_y == 1) {print GP "set yrange [99:100] \n";}
	if ($flag100_y2 == 1) {print GP "set y2range [99:100] \n";}
	
	print GP "plot ",$string2," \n";	#### plot first graph !!!!
	
	for ($i=0; $i<$number_kpi; $i++) {	# print the value in gnuplot.
	
		foreach $var (sort keys %Kpi) {
			if ($var =~ $unique_object[$j]) {
				print GP "$var   $Kpi{$var} \n"; 
			}
		}
		print GP "e\n";			### gnuplot end the graph when the letter e is printed
	}
	
	# end first graph plotting ################# !!!!!!!!!!!!!!!!!!!!!!!!!! #################### !!!!!!!!!!!!!!!!!!
	
	print GP "unset ylabel\n";
	print GP "unset y2label\n";
	print GP "unset title\n";
	print GP "set key outside center bottom horizontal box\n";
	print GP "set bmargin 5\n";
	print GP "set xdata time\n";
	if ($flag_diff0 == 0) {print GP "set yrange [0:1] \n";}
	if ($offset == 1) { print GP "set timefmt '%Y-%m-%d %H:%M'\n";}
	else {print GP "set timefmt '%H:%M'\n";}
	print GP "set xtics format '%H:%M'\n";
	print GP "set xtic rotate by -90 scale 0\n";
	print GP "set xtics textcolor rgbcolor '#000000'\n";
	print GP "unset y2tics\n";
	print GP "set ytics offset 0,0\n";
	print GP "set size 1, 0.3\n";
	print GP "set origin 0.0, 0.0\n";
	print GP "set tmargin 0.5\n";
	print GP "plot '-' u 1:(\$",($offset+2+$order[$kpi1-1]),"-\$",($offset+2+$order[$kpi2-1]),"):xtic(".($offset+1).") title '".$kpi_name_diff[0]."-".$kpi_name_diff[1]."' axes x1y1 with boxes lc 2\n";    #### plot second graph !!!!

	foreach $var (sort keys %Kpi) {
		if ($var =~ $unique_object[$j]) {
			print GP "$var   $Kpi{$var} \n"; 
		}
	}
	print GP "e\n";


print GP "unset multiplot\n";

	close GP;
}
