package html;
use strict;
use Data::Dumper;
sub generate_html_header 
{
	my $confighash = shift;
	my $fh_html =  $confighash->{FILEHANDLE}->{HTML};
	my $version = $confighash->{version};
	my $flot = $confighash->{flot};
	my @flot = split('/',$flot) if defined $flot;
	$flot = $flot[-1];
	$flot = "" if !defined $flot;
	$version = "" if !defined $version;
	my $flotScript = '<script type="text/javascript" src="jquery-1.3.2.js"></script>';
	my @formula = split('/',$confighash->{formulafile}) if defined $confighash->{formulafile};
	my $formulafile = $formula[-1];
	$formulafile = "" if !defined $formulafile;
	my @config = split('/',$confighash->{configfile}) if defined $confighash->{configfile};
	my $configfile = $config[-1];
	$configfile = "" if !defined $configfile;
	my @threshold = split('/',$confighash->{thresholdfile}) if defined $confighash->{thresholdfile};
	my $thresholdfile = $threshold[-1];
	$thresholdfile = "" if !defined $thresholdfile;
	my $welcome = "";
	if (!defined $confighash->{amos})
	{
		$welcome = 'Author: Martin Aldrin,Henrik Schller<a name="top"> </a>';
	}
	
	my $ReportTime = $confighash->{ReportTime};
	my $exception = "";
	my $nodename = (defined $confighash->{nodename}?$confighash->{nodename}:'');
	if (defined $confighash->{exception})
	{
	    $exception = "<li><a name='EXCEPTIONS FOUND' class='ropTableLink' href='dataseries/exception.txt'> EXCEPTIONS FOUND</a></li>";
	}
	$ReportTime = "" if !defined $ReportTime;
	$flotScript = '
	<link rel="stylesheet" type="text/css" href="css/style.css" />
	<link rel="stylesheet" type="text/css" href="css/newStyle.css" />
	<script type="text/javascript" src="js/jquery.js"></script>
	<script type="text/javascript" src="js/jquery.flot.js"></script>
	<!--<script type="text/javascript" src="https://wcdma-iov.rnd.ki.sw.ericsson.se/lib/jquery/jquery.flot-1.1.js"></script>-->
	<script type="text/javascript" src="js/jquery/jquery.tablesorter.js"></script>
	<script type="text/javascript" src="js/jquery.flot.selection.js"></script> <!--Do not change src to https://wcdma-iov.rnd.ki.sw.ericsson.se/lib/jquery-->
	<script type="text/javascript" src="js/jquery.flot.orderBars.js"></script>
	<script type="text/javascript" src="js/jquery.flot.time.js"></script>
	<!--<script type="text/javascript" src="js/jquery.flot.timeStack.js"></script>-->
	<script type="text/javascript" src="js/jquery.flot.symbol.js"></script>
	<script type="text/javascript" src="js/jquery.flot.resize.js"></script>
	<script type="text/javascript" src="js/jquery.flot.tooltip.min.js"></script>
	<script type="text/javascript" src="js/utilities.js"></script>
	<!--<script type="text/javascript" src="js/jquery.flot.events.js"></script>-->
	<script type="text/javascript" src="js/graphs.js"></script>
	';
	
	print $fh_html <<HTMLINFO;
	<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>



<head>
	 <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
	<title>pmSummary.pl html report</title>
	
	$flotScript
	
</head>
<body>
<div id="infobox"></div>
<div id="header">
<img style="float:left;" src="images/ericsson_logo.gif">
<div>
<font style="font-size: 14pt; font-weight: bold;">Node: $nodename</font><br>
Generated by pmSummary v$version<br>
$ReportTime
</div>
<p>$welcome</p>
</div>
<div id="headerlinks">
<lu>
  <li><a name="$formulafile" class="ropTableLink" href="formula.txt"> $formulafile</a></li>
  <li><a name="$configfile" class="ropTableLink" href="configfile.txt"> $configfile</a></li>
  <li><a name="$thresholdfile" class="ropTableLink" href="thresholdfile.txt"> $thresholdfile</a></li>
  <li><a name='INPUT DATA' class='ropTableLink' href='dataseries/input.txt'>INPUT DATA</a></li>
$exception
 

</lu></div>
<hr>


HTMLINFO
#<li><a href="javascript:void(0)" onclick="createReport();"> Create static HTML report</a></li>
}

sub html_table_head
{
	my $confighash = shift;
	my $name   = shift;
	my $filename = shift;
	my $header = shift;
	my $flotOK = shift;
	#my $type = shift;
	#my $border = shift;
	#my $addTR = shift;
	
	my $fh_html =  $confighash->{FILEHANDLE}->{HTML};
	#my $filtername = $name;
	
	$header =~ s/\s+$//;
	$header =~ s/^\s+//;
	my $flotname = $confighash->{rophash}->{$name}->{flotname} if defined $confighash->{rophash}->{$name};
	my $limit = "";
	if( defined $confighash->{thresholdmap} ){
	#print Dumper($confighash->{obj}->{threshold});
		if( defined $confighash->{obj}->{threshold} ){
			foreach my $threshold ( @{$confighash->{obj}->{threshold}} ){
				next if !defined $threshold;
				if ( $threshold =~ /Major/ ){
					$limit = "major";
				}
				elsif($limit ne "major" && $threshold =~ /Minor/ ){
					$limit = "minor";
				}
				
			}
		}
		
	}
	#print "name: $name, hasThreshold: $confighash->{obj}->{hasThreshold}\n";
		if(!$limit && $confighash->{obj}->{hasThreshold} == 1){
			$limit = "ok";
		}
		#print Dumper($confighash->{thresholdmap});
	if (defined $confighash->{obj}->{elements} && !defined $flotOK)
	{
		
		print $fh_html "\t" . '<table>' . "\n";
		print $fh_html "\t\t" . '<tr>'  . "\n";
		print $fh_html "\t\t\t" . "<td class='fixedW $limit'>" . $name . '</td>' . "\n";
		print $fh_html "\t\t\t" . '<td>' . "\n";
		print $fh_html "\t\t\t\t" .'<a name="' . $filename . '" class="ropTableLink " href="javascript:void(0)"' . '> Summary,</a>' . "\n";
		print $fh_html "\t\t\t\t" . '<a onclick="toggleChart(' . "'" . $flotname . "'" . ');return false;" href="javascript:void(0);"' . '> graph </a>' . "\n";
		print $fh_html "\t\t\t" . '</td>' . "\n";
		print $fh_html "\t" . '</table>' . "\n";
		
		print $fh_html "\t" . '<div id="wrapper_' . $flotname . '" style="display:none">' . '</div>' . "\n";

	}
	elsif(defined $confighash->{obj}->{elements})
	{
		print $fh_html "\t" . '<table>' . "\n";
		print $fh_html "\t\t" . '<tr>'  . "\n";
		print $fh_html "\t\t\t" . "<td class='fixedW $limit'>" . $name . '</td>' . "\n";
		print $fh_html "\t\t\t" . '<td>' . "\n";
		print $fh_html "\t\t\t\t" . '<a name="' . $filename . '" class="ropTableLink $limit" href="javascript:void(0)"' . '> Summary</a>' . "\n";
		print $fh_html "\t\t\t" . '</td>' . "\n";
		print $fh_html "\t" . '</table>' . "\n";
	}
	else
	{
		print $fh_html "\t" . '<table>' . "\n";
		print $fh_html "\t\t" . '<tr>' . "\n";
		print $fh_html "\t\t\t" . '<th>' . $name . ' <small>no data</small></th>' . "\n";
		print $fh_html "\t\t" . '</tr>' . "\n";           
		print $fh_html "\t" . '</table>' . "\n";
	}

				
	print $fh_html "\t" . '<div class="ropTable" id="table_' . $filename . '" style="display: none; ' . '"></div>' . "\n";
	my $fh = *HTMLHANDLE;
	open $fh, "> $confighash->{flotpath}/" . $filename . '.html';
	$confighash->{filternameHandle} = $fh;

	
	print $fh '<table class="sortable" id="'.$filename.'">' . "\n";
	
	print $fh "\t<thead>\n";
	my @values = split( ';', $header );
	print $fh "\t\t" . '<tr class="headrow">' . "\n";
	my $flag;
	#foreach my $head (@values)
	for(my $i=0; $i<@values; $i++)
	{
		my $head = $values[$i];
		$head =~s/(\d{4}\-\d{2}\-\d{2}),(\d{2}:\d{2})/$1<br>$2/;
		my $line = "\t\t\t" . '<th' . (defined $flag?" class='formula' id='$head'":'') . '>' . $head . '</th>' . "\n";
		print $fh $line;
		$flag = 1 if  $head eq "Object" && $values[$i+1] ne "Counter";
	}
	print $fh "\t\t" . '</tr>' . "\n";
	print $fh "</thead>\n";
	print $fh "<tbody>\n";
	
}
sub generate_html 
{
	my $confighash = shift;
	my $fh_html;
	my $string = shift;
	my $threshold = shift;
	my $noTD;
	my $noROP;
	
	if (defined  $confighash->{filternameHandle})
	{
		$fh_html = $confighash->{filternameHandle};
	}
	else
	{
		$fh_html = $confighash->{FILEHANDLE}->{HTML};
	}
	$threshold = "" if !defined $threshold;
	#chomp$string;
	my @array = split(';',$string);
#print "string: '$string', values: '@array' size: (" .@array . ")\n";
	print $fh_html "\t\t" . '<tr>' if !defined $noTD; 
	my @tmp;
	push(@tmp,@{$confighash->{obj}->{headerName}});
	push(@tmp,$confighash->{obj}->{header}[0]);
	
	#my $index = @array - @{$confighash->{obj}->{header}}-1;
	my $counterMap = {};
	
	my  $index = abs(@{$confighash->{obj}->{header}} - @array) -1 ;
	for(my $i=0; $i<@{$confighash->{obj}->{header}}; $i++){
		my $header = @{$confighash->{obj}->{header}}[$i];
		if ( defined $confighash->{thresholdmap} && defined $confighash->{thresholdmap}->{lc$header} ){
			$counterMap->{$i+$index} = cleanString($header); #This migt not be correct always who knows...... +1 might not always work?
			
		}
	}
	my $counter = $array[1]; #This migt not be correct always who knows......
	
	my $counterLimit="";
	my $counterThreshold="";
	if( defined $threshold && $threshold =~ /Major/i ){
		$counterLimit = "major";
	}
	elsif( defined $threshold && $threshold =~ /Minor/i ){
		$counterLimit = "minor";
	}
	elsif ( defined $confighash->{thresholdmap} && defined $confighash->{thresholdmap}->{lc$counter}){

			$counterLimit = "ok";
	}
	if ( defined $confighash->{thresholdmap} && defined $confighash->{thresholdmap}->{lc$counter}){
			$counterThreshold = "Threshold: (" . ($confighash->{thresholdmap}->{lc$counter}->{minor}?"Minor:$confighash->{thresholdmap}->{lc$counter}->{operand} $confighash->{thresholdmap}->{lc$counter}->{minor}, ":"") . "Major:$confighash->{thresholdmap}->{lc$counter}->{operand} $confighash->{thresholdmap}->{lc$counter}->{major})";
	}
	for(my $i=0; $i<@array; $i++)
	{
		my $td = cleanString($array[$i]);
		my $string="";
		if (defined $tmp[$i] && $tmp[$i] eq "Counter"){
			$string = " class='formula $counterLimit'  id='$td'";
		}
		elsif($i>1 ){
			my $limit = "";
			if ( defined $counterMap->{$i} ){
				$limit = getPeriodLimit($confighash,$counterMap->{$i},$td) ;
			}
			else{
				$limit = getPeriodLimit($confighash,$counter,$td) ;
			}
			$string = " class='$limit'  id='$td'";
		}
		print $fh_html '<td'."$string".'>' . $td . '</td>';	
		#print '<td'.$string.$threshold.'>' . $td . '</td>'. "\n";
		
	}
	print $fh_html '<td>'."$counterThreshold" . '</td>';
	print $fh_html '</tr>' . "\n" if !defined $noTD;
	
}

sub cleanString{
	my $string = shift;
	$string =~ s/\s+/ /;
	$string =~ s/\s+$//;
	$string =~ s/^\s+//;
	$string =~ s/\e//g;	
	$string =~ s/\[\d+m//g;
	return $string;
}

sub getPeriodLimit{
	my $confighash = shift;
	my $counter = shift;
	my $value = shift;
	my $limit = "";
	if ( defined $confighash->{thresholdmap} && defined $confighash->{thresholdmap}->{lc$counter} ){
		if ( $confighash->{thresholdmap}->{lc$counter}->{operand}  !~ /^[\[\]]+$/ ){
			if( $value =~ 'N/A' || eval( "$value $confighash->{thresholdmap}->{lc$counter}->{operand} $confighash->{thresholdmap}->{lc$counter}->{major}") ){
				$limit = "major";
			}
			elsif( defined $confighash->{thresholdmap}->{lc$counter}->{minor} && eval( "$value $confighash->{thresholdmap}->{lc$counter}->{operand} $confighash->{thresholdmap}->{lc$counter}->{minor}") ){
				$limit = "minor";
			}
			elsif( defined $confighash->{thresholdmap}->{lc$counter} ){
				$limit = "ok";
			}
		}
		elsif( $confighash->{thresholdmap}->{lc$counter}->{operand}  =~ /^\[\]$/ ){
			if( defined $confighash->{thresholdmap}->{lc$counter}->{major} && $confighash->{thresholdmap}->{lc$counter}->{major} =~ /(-?\d+(?:\.\d+)*)-(-?\d+(?:\.\d+)*)/ && ( $value =~ 'N/A' || ($value > $1 && $value < $2) ) ){
				$limit = "major";
			}
			elsif( defined $confighash->{thresholdmap}->{lc$counter}->{minor} && defined $confighash->{thresholdmap}->{lc$counter}->{minor} && $confighash->{thresholdmap}->{lc$counter}->{minor} =~ /(-?\d+(?:\.\d+)*)-(-?\d+(?:\.\d+)*)/ && ( $value > $1 && $value < $2 ) ){
				$limit = "minor";
			}
			else{
				$limit = "ok";
			}
		}
		elsif( $confighash->{thresholdmap}->{lc$counter}->{operand}  =~ /^\]\[$/ ){
			if( defined $confighash->{thresholdmap}->{lc$counter}->{major} && $confighash->{thresholdmap}->{lc$counter}->{major} =~ /(-?\d+(?:\.\d+)*)-(-?\d+(?:\.\d+)*)/ && ( $value =~ 'N/A' || $value < $1 || $value > $2  ) ){
				$limit = "major";
			}
			elsif( defined $confighash->{thresholdmap}->{lc$counter}->{minor} && defined $confighash->{thresholdmap}->{lc$counter}->{minor} && $confighash->{thresholdmap}->{lc$counter}->{minor} =~ /(-?\d+(?:\.\d+)*)-(-?\d+(?:\.\d+)*)/ && ( $value < $1 || $value > $2) ){
				$limit = "minor";
			}
			else{
				$limit = "ok";
			}
		}
	}
	$confighash->{$limit}++;
	return $limit;
}


sub html_table_end 
{
	my $confighash = shift;
	return if !defined $confighash->{html};
	#print {$confighash->{filternameHandle}} '</tr>' . "\n" if defined $addTR;
	print {$confighash->{filternameHandle}} "</tbody>\n";
	print {$confighash->{filternameHandle}} '</table>' . "\n";
	
	close $confighash->{filternameHandle};
	delete $confighash->{filternameHandle};
}
sub generate_html_foot 
{
	my $confighash = shift;
	my $fh_html =  $confighash->{FILEHANDLE}->{HTML};
	print $fh_html <<HTMLINFO;

</body>

</html>
HTMLINFO


}


1;
