/* Copyright (C) 2007 Ericsson AB 
 */

#include "wrapper.h"

#include <errno.h>
#include <string.h>

void
simics_connect(
  const char*  host,
  int          port)
{
  wrapper_log(3,0);

  wrapper_ctx.simics_ctx = simtime_connect(host, port, 0);
}

void
simics_handle_error(
  simtime_error_t ret)
{
  switch (ret) {
    case Simtime_No_Error:
      break;
      
    case Simtime_Socket_Error:
      fprintf(stderr, "error %d: query: %s\n", pthread_self(), strerror(errno));
      lib_init();
      break;

    case Simtime_Timeout:
      fprintf(stderr, "error %d: query: timed out\n", pthread_self());
      break;
		
    case Simtime_Receive_Buffer_Full:
      fprintf(stderr, "error: query: receive buffer full\n");
      break;
      
    case Simtime_Parse_Error:
      fprintf(stderr, "error: query: could not parse response\n");
      break;

    default:
      fprintf(stderr, "error %d: unknown: %d\n", pthread_self(), ret);
      break;
  }
}

void
simics_delay(
  double   delay)
{
  wrapper_log(3,0);

  double sim_time;

  simics_handle_error(simtime_sleep(wrapper_ctx.simics_ctx, delay, &sim_time));
}

double
simics_get_time(void)
{
  wrapper_log(3,0);

  double sim_time;

  simics_handle_error(simtime_query_time(wrapper_ctx.simics_ctx, &sim_time));

  return sim_time;
}

