#!/usr/bin/python

from mo import getLogs
from mo import trace
import mo, mo_parsing
import mo_input as mo_io
import os,sys,shutil
import iur
#todo - find place to hold names of scripts generated on CM1 to be run on CM2
clusterRncId = ''

#delete unneeded files
def clean(path,json):
    trace("cleanup")
    for cm in ("CM1","CM2"):
        mo_io.deleteFile(path + cm +'/' + json[cm]["iuxet_ping"])
        mo_io.deleteFile(path + cm +'/' + json[cm]["iuxup_ping"])
        mo_io.deleteFile(path + cm +'/' + json[cm]["iuxup_ip"])
        mo_io.deleteOldFiles(path + cm + '/',json[cm]["tempFiles"])
    CMjson = json["CM2"]
    mo_io.deleteFile(path + "CM2/" + CMjson["migr_mos"]["restore_backup"]+".old")
    mo_io.deleteFile(path + "CM2/" + CMjson["migr_mos"]["restore_backup"]+"s")
    mo_io.deleteFile(path + "CM2/" + CMjson["migr_mos"]["restore_backup"][:-3]+".log")
    mo_io.deleteFile(path + "CM2/" + CMjson["migr_mos"]["restore_backup"][:-3]+"_del.mo")
    mo_io.deleteFile(path + "CM2/" + CMjson["migr_mos"]["restore_backup"][:-3]+"_del.mos")
    mo_io.deleteFile(path + "CM2/" + CMjson["migr_mos"]["m3u"]+".old")
    mo_io.deleteFile(path + "CM2/" + CMjson["migr_mos"]["m3u"]+"s")
    mo_io.deleteFile(path + "CM2/" + CMjson["migr_mos"]["m3u"][:-3]+".log")
    mo_io.deleteFile(path + "CM2/" + CMjson["migr_mos"]["m3u"][:-3]+"_del.mo")
    mo_io.deleteFile(path + "CM2/" + CMjson["migr_mos"]["m3u"][:-3]+"_del.mos")
    mo_io.deleteFile(path + "CM2/" + CMjson["migr_mos"]["ss7"]+"s")
    mo_io.deleteFile(path + "CM2/" + CMjson["migr_mos"]["ss7"][:-3]+".log")
    mo_io.deleteFile(path + "CM2/" + CMjson["migr_mos"]["ss7"][:-3]+"_del.mo")
    mo_io.deleteFile(path + "CM2/" + CMjson["migr_mos"]["ss7"][:-3]+"_del.mos")
    
def prepareMigrationMos(nccId, clusterMember, fpath, json, rncId):
    trace("Start generating migration mos for CM{0}, rncId={1}".format(nccId,rncId))
    #=======================MOSHELL SESSION=========================================
    CMjson = json[str("CM"+nccId)]
    tempFiles = CMjson["tempFiles"]
    #collect needed data from nodes
    mo_io.get_moshell_output(fpath, CMjson["credentials"], tempFiles)
    rncPrintout = mo_io.getInputFromFiles(fpath, tempFiles)
    
    cvCount = mo_parsing.getCvCount(fpath + "cvls")
    
    if cvCount > 39:
        response = str(raw_input("The amount of CVs on CM{0} is {1}! It should be less than 40. Please delete some of them, and then press enter to continue.".format(nccId,cvCount)))
        
    #inputCM1
    migrMos = CMjson["migr_mos"]
    rinpmCmInput = CMjson["rinpm_input"]
    rinpmCmInput["nccId"] = nccId # memberId
    rinpmCmInput["clusterMember"] = clusterMember
    mo_io.writeMos(fpath + migrMos["vlan"], mo.createVlanMo(rinpmCmInput["vlan_for_iux"]))
    mo_io.writeMos(fpath + "getIuIur.mo",mo.getIuIurPlanes("iuiur"))
    #=====================Checking type of RNC======================================
    rncType, boardType = mo_parsing.checkRncType(rncPrintout["rncfunc"])
    if rncType == 'RNC_3820' and rinpmCmInput["nccId"] == "2":
        trace('CM2 cannot be 3820, but EVO')
        sys.exit()
    mo_io.writeMos(fpath + migrMos["vlan_cmxb"], mo.vlanCmxbMos(rncPrintout["vlan"], rinpmCmInput["vlan_for_iux"]))
    mo_io.writeMos(fpath + migrMos["iuxet_ping"], mo.createAndPingIuxEtGroup(rncType, rinpmCmInput["defaultRouter"], fpath, CMjson))
    mo_io.writeMos(fpath + migrMos["iuxup_ip"], mo.getUserPlaneRouterIp(fpath,CMjson))
    #parsing printout for EPBs(Evo)/ET-IPG(3820)
    
    subrackNo, slotNo, numberOfboards = mo_parsing.parsingBoard(rncPrintout["cab"], boardType)
    trace("subrackNo={0}, slotNo={1}, numberOfboards={2}, rncId={3}".format(subrackNo, slotNo, numberOfboards, rncId))

    global clusterRncId  # rncId is copied from CM1 and set to CM2
    #get id and SS7 stack from CM1
    if nccId == "1":
        pathCM2 = fpath.replace("CM1","CM2") # generating scripts for CM2
        ss7File = pathCM2 + json["CM2"]["migr_mos"]["ss7"]
        m3uaFile = pathCM2 + json["CM2"]["migr_mos"]["m3u"]
        
        #get rncId from CM1 to be used on CM2
        clusterRncId = rncId
        
        mo_io.writeMos(fpath + migrMos["get_ss7"],mo.get_ss7configuration(ss7File))
        mo_io.writeMos(fpath + migrMos["get_M3uAssociations"],mo.restore_ss7configuration(m3uaFile))
        
        mo_io.writeMos(fpath + migrMos["migrate"][:-4]+"-3.mos", mo.restoreM3uCM1(fpath,migrMos) )
        mo_io.run_moshell_session(CMjson["credentials"], fpath + migrMos["get_ss7"]) 
        mo_io.run_moshell_session(CMjson["credentials"], fpath + migrMos["get_M3uAssociations"]) 
        
        mo_io.deleteFile(fpath + migrMos["get_ss7"])
        mo_io.deleteFile(fpath + migrMos["get_M3uAssociations"])
        
        mo_parsing.replaceSs7Configuration(ss7File,json["mapping_table"])
        mo_parsing.modifySs7Configuration(m3uaFile,"CM1",False,False,True)
    elif nccId == "2":
        #create script for backing up frontends from CM2
        mo_io.writeMos(fpath + migrMos["backup_frontends"],mo.backup_frontends(fpath + migrMos["restore_backup"]))
        
        #backup frontends from CM2
        mo_io.run_moshell_session(CMjson["credentials"], fpath + migrMos["backup_frontends"])
        #delete unneded file 
        mo_io.deleteFile(fpath + migrMos["backup_frontends"])
        #change identity and set autoStartAssociation to false
        mo_parsing.modifySs7Configuration(fpath + migrMos["restore_backup"],"CM2",True,True,False)
        
        cm1DestPointCodeDict = mo_parsing.getDestPointCodes(fpath.replace("CM2","CM1") + "destPoint")
        cm2DestPointCodeDict = mo_parsing.getDestPointCodes(fpath + "destPoint")
        mo_parsing.replaceMtp3bSrsId(fpath + migrMos["restore_backup"],cm1DestPointCodeDict,cm2DestPointCodeDict)
        
        mo_io.writeMos(fpath + migrMos["delete_ss7"],mo.delete_ss7configuration())
        mo_io.writeMos(fpath + migrMos["set_rnc_id"],mo.setRncId(clusterRncId))
        mo_io.writeMos(fpath + migrMos["licensing"],mo.licensing())
        mo_io.writeMos(fpath + migrMos["save_cv_and_restart"],mo.saveCvAndRestart())
        mo_io.writeMos(fpath + migrMos["activate_signaling"],mo.activateSignaling("ACTIVATED_SIGNALING",fpath))
    else: 
        trace("Abort generating scripts. Wrong nccId={nccId}".format(nccId))
    
    #mo_io.run_moshell_session(CMjson["credentials"], fpath + migrMos["iuxup_ip"])    
    #defaultIpUP =  mo_parsing.parseUserPlaneRouterIp(fpath + CMjson["iuxup_ip"])
   
    #mo_io.writeMos(fpath + migrMos["iuxup_ping"], mo.pingUserPlaneRouterIp(defaultIpUP,fpath,CMjson))
    mo_io.writeMos(fpath + migrMos["ipinterfaces"], mo.createIpInterfacesMo(rinpmCmInput, subrackNo, slotNo))

    #Parsing GPB for 3820
    if rncType == 'RNC_3820':
        subrackNoGpb, slotNoGpb, noOfGpbs = mo_parsing.parsingGPB(rncPrintout["cab"])
        numberOfboards = noOfGpbs
        #print subrackNoGpb, slotNoGpb, noOfGpbs 
        mo_io.writeMos(fpath + migrMos["ipTermServ"], mo.createIpTermServ(noOfGpbs, subrackNoGpb, slotNoGpb, subrackNo, slotNo))
     
    #Create ip access host et. If there is only one address provided, script will assume that ip addresses change consecutively
    if (type(rinpmCmInput["first_address"]) == list and len(rinpmCmInput["first_address"])) > 1:  
        mo_io.writeMos(fpath + migrMos["ipaccesshostEt"], mo.createIpAccessHostEt(rinpmCmInput["first_address"], rinpmCmInput["defaultRouter"], subrackNo, slotNo))
    else:
        mo_io.writeMos(fpath + migrMos["ipaccesshostEt"], mo.createIpAccessHostEtFromSingleAddress(rinpmCmInput["first_address"], rinpmCmInput["defaultRouter"], subrackNo, slotNo))

    mo_io.writeMos(fpath + migrMos["ncc"], mo.createNccMo(rinpmCmInput["nccId"],rinpmCmInput["clusterMember"], clusterRncId, rinpmCmInput["firstMainServerAddresses"], str(numberOfboards),rncType, subrackNo, slotNo))
    mo_io.writeMos(fpath + migrMos["feature_activation"], mo.featureActivationMos(rinpmCmInput["nccId"],rinpmCmInput["clusterMember"]))
    mo_io.writeMos(fpath + migrMos["iuxup"], mo.createIuxUp(rinpmCmInput["nccId"],rinpmCmInput["clusterMember"],rncPrintout["iuxup"]))
    mo_io.writeMos(fpath + migrMos["migrate"],mo.migrationMos(fpath, rncType, migrMos,nccId))
    
    if nccId == "1":
        mo_io.writeMos(fpath + migrMos["migrate"][:-4]+"-2.mos",mo.migrationMos(fpath, rncType, migrMos,"1.1"))
    if nccId == "2":
        mo_io.writeMos(fpath + migrMos["migrate"][:-4]+"-2.mos",mo.migrationMos(fpath, rncType, migrMos,"2.1"))
        mo_io.writeMos(fpath + migrMos["migrate"][:-4]+"-3.mos",mo.migrationMos(fpath, rncType, migrMos,"2.2"))
    trace("migration mos for CM"+ str(nccId) +" are prepared")

def pinging(working_path,rinpmjson,cm,file):
    mo_io.run_moshell_session(rinpmjson[cm]["credentials"], working_path + cm + "/" + rinpmjson[cm]["migr_mos"][file])
    while not mo_parsing.isPingOk(working_path +cm + '/' + rinpmjson[cm][file]): #"iuxet_ping"
        response = str(raw_input("No response. Do you want to Retry, Skip or Abort(exit)? (r/s/a)"))
        if response.lower() == 'r': # retry
            trace("retrying")
            mo_io.run_moshell_session(rinpmjson[cm]["credentials"], working_path + cm + "/" + rinpmjson[cm]["migr_mos"][file])
        elif response.lower() == 's': # skip ping
            trace("skipping...")
            break
        elif response.lower() == 'a': # exit script
            trace("exiting...")
            mo_io.exit(working_path,rinpmjson)

def prepareUtranRelationScripts(working_path,rinpmjson,rncId):
    #prepare scripts for deleting Iur between CM1 and CM2 and change external utran cells to remote
    trace("Do you want to generate script for updating Utran Relations? It has to be done before migration (y/n)")
    if str(raw_input("")).lower()[0] == 'y':
        iur.createIurDeletionScripts(working_path,rinpmjson,rncId)
        trace("Generation of Utran Relations is completed")	
        return True
    else:
        return False 
    #if mo_io.checkUtranGeneratedFiles():
            #trace("Files for updating Utran Relations already exist. Do you want to update/regenerate them? (y/n)")
            #if str(raw_input("")).lower()[0] == 'y':
                #iur.createIurDeletionScripts(working_path,rinpmjson,rncId) 
        #else:
            #iur.createIurDeletionScripts(working_path,rinpmjson,rncId) 
        #return True

        
def getRncIds(working_path,rinpmjson):
    rncId = dict()
    rncId["CM1"] = mo_io.getRncId(working_path,"CM1",rinpmjson)
    rncId["CM2"] = mo_io.getRncId(working_path,"CM2",rinpmjson)
    return rncId

def main():
    #=======================INPUT FROM FILE=========================================
    if len(sys.argv) != 2 or sys.argv[1][-5:] != ".json":
        help()
        sys.exit()
    jsonPath = sys.argv[1]
    rinpmjson = mo_io.readJson(jsonPath)
    #Getting path of json file to store scipts there
    working_path = os.path.abspath(os.path.join(jsonPath,os.pardir)) + "/"
    mo_io.setupMoshellPath(rinpmjson["moshell_path"])
    trace("Migration scripts files will be now generated. Press enter key to continue...")
    raw_input("")
    
    #create directories if they do not exist
    mo_io.createDirectories(working_path)

    #if (type(rinpmjson["CM1"]["rinpm_input"]["first_address"]) == list)
    rncId = getRncIds(working_path,rinpmjson)
    
    #prepare scripts for deleting Iur between CM1 and CM2 and change external utran cells to remote
    isUtranRelationScriptPrepared = prepareUtranRelationScripts(working_path,rinpmjson,rncId)
    
    #delete unneeded files 
    clean(working_path,rinpmjson)
    
    isPrepared = False
    if mo_io.checkGeneratedFiles() == True: # files already prepared?
        trace("Preparation files for migrating already exist. Do you want to update/regenerate them? (y/n)")
        if str(raw_input("")).lower()[0] == 'n': # n - to skip them
            isPrepared = True
    if not isPrepared: 
        prepareMigrationMos(nccId="1", clusterMember="2", fpath = working_path + 'CM1/', json=rinpmjson,rncId = rncId["CM1"])
        prepareMigrationMos(nccId="2", clusterMember="1", fpath = working_path + 'CM2/', json=rinpmjson,rncId = rncId["CM2"])
        #copy backups from CM2 to be used in CM1
        shutil.copy2(working_path+ "CM2/" + rinpmjson["CM2"]["migr_mos"]["restore_backup"], working_path + "CM1/" + rinpmjson["CM1"]["migr_mos"]["m3u_cm2"])
        #change their identity, set autoStartAssociation to false and set sctpId ref to null
        mo_parsing.modifySs7Configuration(working_path + "CM1/" + rinpmjson["CM1"]["migr_mos"]["m3u_cm2"],"CM2",False,True,True)
    clean(working_path,rinpmjson)

    # The automatic migration disabled on purpose
    #
    #trace("Do you want start migrating RNC to RinP (y/n)?:")
    #migration_choice = raw_input("")

    migration_choice = 'n'
    
    if migration_choice == 'y':
        mo_io.run_moshell_session(rinpmjson["CM1"]["credentials"], working_path +"CM1/" + rinpmjson["CM1"]["migr_mos"]["migrate"])
        
        #check pinging result
        pinging(working_path,rinpmjson,"CM1","iuxet_ping")
        mo_io.run_moshell_session(rinpmjson["CM1"]["credentials"], working_path +"CM1/" + rinpmjson["CM1"]["migr_mos"]["migrate"][:-4]+"-2.mos")
        
        #parse output to get Ip for pinging 
        defaultIpUP =  mo_parsing.parseUserPlaneRouterIp(working_path+"CM1/" + rinpmjson["CM1"]["iuxup_ip"])
        #prepare script which will ping defalutipup
        mo_io.writeMos(working_path + "CM1/" + rinpmjson["CM1"]["migr_mos"]["iuxup_ping"], mo.pingUserPlaneRouterIp(defaultIpUP,working_path+"CM1/",rinpmjson["CM1"]))
        #run this script
        #mo_io.run_moshell_session(rinpmjson["CM1"]["credentials"], working_path +"CM1/" + rinpmjson["CM1"]["migr_mos"]["iuxup_ping"])
        
        #check pinging of CM1 iuxup
        pinging(working_path,rinpmjson,"CM1","iuxup_ping")
        mo_io.run_moshell_session(rinpmjson["CM2"]["credentials"], working_path +"CM2/" + rinpmjson["CM2"]["migr_mos"]["migrate"])
        trace("Perform required CoreNetwork changes if needed. Then press any key to continue")
        raw_input("")
        
        mo_io.run_moshell_session(rinpmjson["CM2"]["credentials"], working_path +"CM2/" + rinpmjson["CM2"]["migr_mos"]["migrate"][:-4]+"-2.mos")
        #check pinging of CM2 iuxup
        pinging(working_path,rinpmjson,"CM2","iuxet_ping")
            
        mo_io.run_moshell_session(rinpmjson["CM2"]["credentials"], working_path +"CM2/" + rinpmjson["CM2"]["migr_mos"]["migrate"][:-4]+"-3.mos")
        defaultIpUP =  mo_parsing.parseUserPlaneRouterIp(working_path+"CM2/" + rinpmjson["CM2"]["iuxup_ip"])
        
        mo_io.writeMos(working_path + "CM2/" + rinpmjson["CM2"]["migr_mos"]["iuxup_ping"], mo.pingUserPlaneRouterIp(defaultIpUP,working_path+"CM2/",rinpmjson["CM2"]))
        #mo_io.run_moshell_session(rinpmjson["CM2"]["credentials"], working_path +"CM2/" + rinpmjson["CM2"]["migr_mos"]["iuxup_ping"])
        
        #check pinging result
        pinging(working_path,rinpmjson,"CM2","iuxup_ping")   
        
        #for cm in ("CM1","CM2"): 
            #mo_io.writeMos(working_path + cm + '/' + "cleanCvs.mo", mo.cleanCvs())
        mo_io.run_moshell_session(rinpmjson["CM1"]["credentials"], working_path +"CM1/" + rinpmjson["CM1"]["migr_mos"]["migrate"][:-4]+"-3.mos")
        mo_io.run_moshell_session(rinpmjson["CM2"]["credentials"], working_path +"CM2/" + rinpmjson["CM2"]["migr_mos"]["activate_signaling"])
        
        #run script for deleting iur between CM1 and CM2 and recreate utran cells with external utran cells replaced with remote utran cells
        if isUtranRelationScriptPrepared and str(raw_input("RinP migration is finished. Do you want to update old UtranRealtion?(y/n)")).lower() == 'y':
            iur.deleteIurLink(working_path,rinpmjson)
    mo_io.writeMos(working_path + "rinpm.log", getLogs())

def help():
    trace("""***************************************************************************************
rinpm <configuration.json>
***************************************************************************************
Script for improved Live Node Migration. Generates and launches moshell scripts for 
migration of two RNCs into cluster: CM1 and CM2
""")
if __name__ == "__main__":
    main()
