package formatJSON;

use strict;
use locale;
use Data::Dumper;

use POSIX qw(strftime);
use POSIX;
use Time::Local;

use JSON;


sub formatJSON::new() {
  my $class = shift;
  my %self = @_;
  $self{format} = "FLOT";
  $self{ROP} = ();
  return bless \%self;
}

sub formatJSON::begin(){
    my $self = shift;
    my $path = shift;
    my $fileName = shift;
    $fileName =~ s/\s+/_/g;
    $fileName =~ s/\.//g;
    $fileName =~ s/\,//g;
    $fileName =~ s/\(//g;
    $fileName =~ s/\)//g;

    $self->{TABLEAME} = $fileName . '_flot';
    my $file = $path . $self->{TABLEAME} . '.json';
    my $fh;
    open $fh, ">$file" or print "couldn't open FileHandle for file: $file\n";
    $self->{OPENEDHANDLE} = $fh;
    #my $string = 'var ' . $self->{TABLEAME} . ' = [';
    #$self->printer( $string );

    #$self->printer( "BEGIN HEADER:$self->{TABLEAME}");
    @{$self->{ROP}} = ();
    #$$self{JSON}{TABLE} = $self->{TABLEAME};
    #$$self{JSON}{DATASERIES} = ();

}

sub formatJSON::header(){
    my $self = shift;
    my $string = shift;
    my $header = shift;
    if ( defined $self->{error} )
    {
        return;
    }
    my $period = (defined $self->{conf}->{period})?$self->{conf}->{period}:"15"; ## Rop period in minutes
    #@{$self->{ROP}} = ();
    foreach my $rop ( @$header )
    {
        ## midPoint option will put the dots in the graphs in the middle of the graphs. Can't be used with eJSON option.
        if ( $rop =~ /(\d{4})\-(\d{2})\-(\d{2}) (\d{2}):(\d{2})/ )
        {
            if ( defined $self->{conf}->{midPoint} && !defined $self->{conf}->{eJSON} )
            {
                my $periodEpoc = $period * 60 * 1000 / 2; ## period in Unix epoch seconds devided by two. So the points in the graph is put in the middle of periods.
                push( @{$self->{ROP}}, ((timegm( 0, $5, $4, $3, $2 -1, $1 -1900, 0, 0, 0))*1000)-$periodEpoc );
            }
            else
            {
                push( @{$self->{ROP}}, ((timegm( 0, $5, $4, $3, $2 -1, $1 -1900, 0, 0, 0))*1000)+0 );
            }
        }
    }
}

sub formatJSON::content(){
    my $self = shift;
    my ( $numberOf, $string, $rop ) = @_;
    if ( defined $self->{error} )
    {
        return;
    }
    $string =~ s/\s+/ /g;
    $string =~ s/\}|\{//g;
    $string =~ s/\]|\[//g;
    $string =~ s/\'//g;
    $rop =~ s/\s+//g;
    #$self->printer( "{" );
    #$self->printer( "\tlabel: '$string'," );
    #$self->printer(  "LABEL: $string");
    my $period = (defined $self->{conf}->{period})?$self->{conf}->{period}:"15"; ## Rop period in minutes
    my @rops = split( /;/, $rop );
    my $dataString = "";
    #$$self{JSON}{$self->{TABLEAME}}{label} = $string;

    #push(@{$$self{JSON}{$self->{TABLEAME}}{label}},$string);
    my $data;
    my $firstrop;
    my $lastrop;
    $$data{label} = $string;

    ## If completeROPs is defined first and last rop period will be removed since they don't cover a entire ROP period
    ## @rops and $self->{ROP} have been sorted earlier. Therefore it's possible to just shift and pop if option is used.
    if ( defined $self->{conf}->{completeROPs} && scalar @rops > 2 && scalar $self->{ROP} > 2 )
    {
        ## This needs to be a array. It wasn't once so check have been added
        if ( ref($self->{ROP}) eq 'ARRAY' )
        {
            shift @rops;
            pop @rops;
            shift @{$self->{ROP}};
            pop @{$self->{ROP}};
        }
        else
        {
            print "Warning: Failed removing uncomplete ROPs... $self->{ROP} is not an ARRAY!\n";
        }
    }

    ## Minutes are set to 0 so that the hour graphs will fit on the graph when setting x scale to the same value on all graphs.
    if ( $self->{conf}->{startTime} =~ /(\d{4})\-(\d{2})\-(\d{2}) (\d{2}):(\d{2})/ )
    {
      #  my $nextperiod = ($5 - ($5 % $period)) * 60 * 1000;
      #  $nextperiod = ($4 - ($4 % ($period/60))) * 60 * 60 * 1000 if $period > 60;
      # $firstrop = ((timegm( 0, 0, $4, $3, $2 -1, $1 -1900, 0, 0, 0))*1000)+$nextperiod; ## Calculate time for the first rop period in grapgh
        my $nextperiod;
        if ( $period > 60 )
        {
            $nextperiod = ($4 - ($4 % ($period/60))) * 60 * 60 * 1000;
            $firstrop = ((timegm( 0, 0, 0, $3, $2 -1, $1 -1900, 0, 0, 0))*1000)+$nextperiod;
        }
        else
        {
            $nextperiod = ($5 - ($5 % $period)) * 60 * 1000;
            $firstrop = ((timegm( 0, 0, $4, $3, $2 -1, $1 -1900, 0, 0, 0))*1000)+$nextperiod;
        }
        push( @{$$data{startTime}}, ((timegm( 0, 0, $4, $3, $2 -1, $1 -1900, 0, 0, 0))*1000)+0 ); ## Calculate time for the first hour in graph
    }

    ## Time is set to the next rop period so that the graph will fit on the graph when setting x scale to the same value on all graphs.
    if ( $self->{conf}->{endTime} =~ /(\d{4})\-(\d{2})\-(\d{2}) (\d{2}):(\d{2})/ )
    {
        my $nextperiod;
        if ( $period > 60 )
        {
            $nextperiod = ($4 - ($4 % ($period/60))) * 60 * 60 * 1000;
            $lastrop = ((timegm( 0, 0, 0, $3, $2 -1, $1 -1900, 0, 0, 0))*1000)+$nextperiod; ## calculate the final rop time
        }
        else
        {
            $nextperiod = ($period - ($5 % $period)) * 60 * 1000;
            $lastrop = ((timegm( 0, $5, $4, $3, $2 -1, $1 -1900, 0, 0, 0))*1000)+$nextperiod; ## calculate the final rop time
        }
        push( @{$$data{endTime}}, $lastrop );
    }
    ## If extend JSON (eJOSN option) is defined the JSON file will be expanded to include data for all rops.
    if ( defined $self->{conf}->{eJSON} && defined $firstrop && defined $lastrop)     {
        my $ropData;
        for ( my $i = 0; $i <@{$self->{ROP}}; $i++ ) ## Map existing data to a hash to use later.
        {
            $ropData->{@{$self->{ROP}}[$i]} = $rops[$i]?int($rops[$i]):0;
        }
        my $periodEpoc = $period * 60 * 1000; ## period in Unix epoch seconds
        for (my $epochtime = $firstrop; $epochtime <= $lastrop; $epochtime += $periodEpoc) ## Print data for all periods
        {
            push(@{$$data{data}},[  int($epochtime) , (defined $ropData->{$epochtime}?int($ropData->{$epochtime}):0) ] ); ## If data exists for the period insert it else set the data to zero
        }
    }
    else ## Else do as before
    {
        for ( my $i = 0; $i <@{$self->{ROP}}; $i++ )
        {
            #$dataString .= '[' . @{$self->{ROP}}[$i] . ',' . (defined $rops[$i]?$rops[$i]:0) . '],';
            push(@{$$data{data}},[  @{$self->{ROP}}[$i] , (defined $rops[$i]?int($rops[$i]):0) ] );
        }
    }
    push(@{$$self{JSON}{$self->{TABLEAME}}},$data);
    #$dataString =~ s/,$//;
    #$self->printer(  "data: $dataString\n");
    #$self->printer( "\tdata: [$dataString]" );
    #$self->printer( "}," );


}

sub formatJSON::end(){
    my $self = shift;
    my $fh = $self->{OPENEDHANDLE};
    #$self->printer( "]" );
    $self->printer();
    close $fh;
}

sub formatJSON::printer(){
    my $self = shift;
    my $string = shift;
    if ( defined $self->{error} )
    {
        return;
    }
    my $fg = $self->{OPENEDHANDLE};
    my $json = JSON->new->allow_nonref;
        my $jsonString = $json->encode($$self{JSON});
    print $fg $jsonString ;
    #print $fg  Dumper($$self{JSON}) ;
}
1;
