#!/usr/bin/env perl
#####################################################################################
#                                                                                   #
#  Ericsson AB 2011 - All Rights Reserved                                          #
#                                                                                   #
# The copyright to the computer program(s) herein is the property of Ericsson AB,   #
# Sweden. The programs may be used and/or copied only with the written permission   #
# from Ericsson AB or in accordance with the terms and conditions stipulated in the #
# agreement/contract under which the program(s) have been supplied.                 #
#                                                                                   #
#####################################################################################

use strict;
use ipc;
my $sleep = int( rand() * 5 + 5 );
print "sleep $sleep\n";
my $mgr = new ipc::manager;
if ( fork() )
{
    if ( fork() )
    {
        while (1)
        {
            my $i =
                $mgr->handle_message( $mgr->get_std_handlers() )->{numclients};
            last if ( $i == 0 );
        }
    }
    else
    {
        my $worker =
            new ipc::worker( name => "worker 2", port => $mgr->{port} );
        print "worker 2 sleeping for 10 seconds\n";
        sleep($sleep);
        print "worker 2 calling sync\n";
        $worker->sync();
        print "worker 2 sleeping for 10 seconds again\n";
        sleep($sleep);
        print "worker 2 calling sync again\n";
        $worker->sync();
        print "worker 2 all done\n";
        $worker->quit();
    }
}
else
{
    my $worker = new ipc::worker( name => "worker 1", port => $mgr->{port} );
    print "worker 1 calling sync\n";
    $worker->sync();
    print "worker 1 calling sync again\n";
    $worker->sync();
    print "worker 1 all done\n";
    $worker->quit();
}
