package ueStat;
use strict;

use Data::Dumper;
use formatTXT;
use formatCSV;
use formatHTML;
use timeparser;

use Type;
use Table;
use formatHTML;
sub ueStat::new() {
    my $class = shift;
    my $conf = shift;
    my $types = shift;
    my %self = @_;
    $self{UECONFIG} = {};
    $self{TABLES} = ();
    $self{TABLEAME} = ();
    $self{TEXTPRINTER} = new formatTXT();
    $self{CSVPRINTER} = new formatCSV();
    $self{HTMLPRINTER} = new formatHTML();
    foreach my $type ( @{$types} )
    {
        my $exp = $type->getRegexp();
        if ( $exp eq "IU_IF" )
        {
            $self{TYPE} = $type;
            $type->{required}->{IMSI} = 1;
              $type->{required}->{roamCounter} = 1;
            $type->{required}->{cellId} = 1;
            $type->{required}->{connType} = 1;
        }
    }


    parseConfig( \%self, $conf->{config} );
    parse_imsimap( \%self, $conf );
    my $type = new Type( matchString => 'ueStat' );
    $self{type} = $type;
    my @headers = ();
    my $table = {};

    @headers = ( 'Type','IMSI','Ue_Type','RabRel','RabDrop','SrbRel','SrbDrop','Last_occurred','Last_Rel' );
    $table->{'IMSI analysis'} = $type->addTable( name => 'IMSI analysis', outfile => $conf->{outfile}, silent => $conf->{silent}  );
    $table->{'IMSI analysis'}->{noTotal} =1;
    $table->{'IMSI analysis'}->{noCount} =1;
    $table->{'IMSI analysis'}->{sortMethod} = 1;

    foreach my $header ( @headers )
    {
        $table->{'IMSI analysis'}->addHeader( conf => $conf, name => $header );
    }

    @headers = ( 'Type','IMSI','Ue_Type' );
    $table->{'UEs with no RAB actions'} = $type->addTable( name => 'UEs with no RAB actions', outfile => $conf->{outfile}, silent => $conf->{silent}  );
    $table->{'UEs with no RAB actions'}->{noTotal} =1;
    $table->{'UEs with no RAB actions'}->{noCount} =1;
    $table->{'UEs with no RAB actions'}->{sortMethod} = 1;

    foreach my $header ( @headers )
    {
        $table->{'UEs with no RAB actions'}->addHeader( conf => $conf , name => $header );
    }

    @headers = ( 'Type', 'IMSI', 'Ue_Type', 'Total/UE', 'Contribution' );
    $table->{'worst UEs with RAB drop'} = $type->addTable( name => 'worst UEs with RAB drop', max => 20, outfile => $conf->{outfile}, silent => $conf->{silent}  );
    $table->{'worst UEs with RAB drop'}->{noTotal} =1;
    $table->{'worst UEs with RAB drop'}->{noCount} =1;
    foreach my $header ( @headers )
    {
        $table->{'worst UEs with RAB drop'}->addHeader( conf => $conf, name => $header );
    }

    @headers = ( 'Type', 'Ue_Type', 'RabRel', 'RabDrop', 'SrbRel', 'SrbDrop' );
    $table->{'UE Type analysis'} = $type->addTable( name => 'UE Type analysis', outfile => $conf->{outfile}, silent => $conf->{silent}  );
    $table->{'UE Type analysis'}->{noTotal} =1;
    $table->{'UE Type analysis'}->{noCount} =1;
    $table->{'UE Type analysis'}->{sortMethod} = 2;
    foreach my $header ( @headers )
    {
        $table->{'UE Type analysis'}->addHeader( conf => $conf, name => $header );
    }

    @headers = ( 'Type', 'Profile', 'RabRel', 'RabDrop', 'SrbRel', 'SrbDrop' );
    $table->{'Profile analysis'} = $type->addTable( name => 'Profile analysis', outfile => $conf->{outfile}, silent => $conf->{silent}  );
    $table->{'Profile analysis'}->{noTotal} =1;
    $table->{'Profile analysis'}->{noCount} =1;
    $table->{'Profile analysis'}->{sortMethod} = 2;
    foreach my $header ( @headers )
    {
        $table->{'Profile analysis'}->addHeader( conf => $conf, name => $header );
    }

    @headers = ( 'Type', 'Route', 'RabRel', 'RabDrop' );
    $table->{'CCN Route analysis'} = $type->addTable( name => 'CCN Route analysis', outfile => $conf->{outfile}, silent => $conf->{silent}  );
    $table->{'CCN Route analysis'}->{noTotal} =1;
    $table->{'CCN Route analysis'}->{noCount} =1;
    $table->{'CCN Route analysis'}->{sortMethod} = 2;
    foreach my $header ( @headers )
    {
        $table->{'CCN Route analysis'}->addHeader( conf => $conf, name => $header );
    }

    @headers = ( 'Type', 'Cell', 'RabRel', 'RabDrop', 'SrbRel', 'SrbDrop' );
    $table->{'Cell analysis'} = $type->addTable( name => 'Cell analysis', outfile => $conf->{outfile}, silent => $conf->{silent}  );
    $table->{'Cell analysis'}->{noTotal} =1;
    $table->{'Cell analysis'}->{noCount} =1;
    $table->{'Cell analysis'}->{sortMethod} = 1;
    foreach my $header ( @headers )
    {
        $table->{'Cell analysis'}->addHeader( conf => $conf, name => $header );
    }

    @headers = ( 'Type', 'Rabtype', 'RabRel', 'RabDrop' );
    $table->{'Rab analysis'} = $type->addTable( name => 'Rab analysis', outfile => $conf->{outfile}, silent => $conf->{silent}  );
    $table->{'Rab analysis'}->{noTotal} =1;
    $table->{'Rab analysis'}->{noCount} =1;
    $table->{'Rab analysis'}->{sortMethod} = 2;
    foreach my $header ( @headers )
    {
        $table->{'Rab analysis'}->addHeader( conf => $conf, name => $header );
    }

    @headers = ( 'Type', 'RRCcon', 'ConRel', 'ConDrop' );
    $table->{'RRC connection analysis'} = $type->addTable( name => 'RRC connection analysis', outfile => $conf->{outfile}, silent => $conf->{silent}  );
    $table->{'RRC connection analysis'}->{noTotal} =1;
    $table->{'RRC connection analysis'}->{noCount} =1;
    $table->{'RRC connection analysis'}->{sortMethod} = 2;
    foreach my $header ( @headers )
    {
        $table->{'RRC connection analysis'}->addHeader( conf => $conf,name => $header );
    }

    $self{table} = $table;
    return bless \%self;
}

sub ueStat::parser()
{
    my $self = shift;

    if  ( defined $self->{TYPE}->{obj}->{roamCounter} && $self->{TYPE}->{obj}->{IMSI} )
    {
        my $imsi = $self->{TYPE}->{obj}->{IMSI};
        my $mapname = "-";
        if ( $imsi ne "UNDEF" )
        {
            foreach my $imsimap ( sort keys %{$self->{imsimap}} )
            {
                if ( $imsi >= $imsimap && $imsi <= $self->{imsimap}->{$imsimap}->{range} )
                {
                    $mapname = $self->{imsimap}->{$imsimap}->{name};
                    last;
                }
            }
        }


        my $roamCounter;
        if ( $self->{TYPE}->{obj}->{roamCounter} =~ /PMNO(?:SYSTEM|NORMAL)(?:RABRELEASE|RELEASE|RBRELEASE)(\S+)/ )
        {
            $roamCounter = $1;
        }
        $roamCounter = $self->{TYPE}->{obj}->{roamCounter} if !defined $roamCounter;
        my $connType = '-';
        if ( defined $self->{TYPE}->{obj}->{connType} && $self->{TYPE}->{obj}->{connType} =~ /ueh(\S+)/ )
        {
            $connType = $1;
        }
        if ( defined $self->{UECONFIG}->{ $self->{TYPE}->{obj}->{IMSI} } && $self->{TYPE}->{obj}->{roamCounter} !~ /SRBONLY|IURLINK/ )
        {
            my ($type) = $self->{TYPE}->{obj}->{roamCounter} =~ /(SYSTEM|NORMAL)/;
            if ( defined $type )
            {
                $self->{UESTAT_IMSI}->{ $self->{TYPE}->{obj}->{IMSI} }->{RAB}->{$type}++;
                $self->{UESTAT_IMSI}->{ $self->{TYPE}->{obj}->{IMSI} }->{lastTime} = $self->{TYPE}->{obj}->{realTime};
                $self->{UESTAT_IMSI}->{ $self->{TYPE}->{obj}->{IMSI} }->{lastType} = $type;
                $self->{UESTAT_CELL}->{ $self->{TYPE}->{obj}->{cellId} }->{$mapname}->{RAB}->{$type}++;
                $self->{UESTAT_COUNTER}->{ $roamCounter }->{$mapname}->{RAB}->{$type}++;
                $self->{UESTAT_CONN}->{ $connType }->{$mapname}->{RAB}->{$type}++;
                $self->{UESTAT_IMSI}->{ $self->{TYPE}->{obj}->{IMSI} }->{TYPE} = $mapname;
                $self->{$mapname}->{lastRabAction} = $self->{TYPE}->{obj}->{realTime};
            }
        }
        elsif ( defined $self->{UECONFIG}->{ $self->{TYPE}->{obj}->{IMSI} } && $self->{TYPE}->{obj}->{roamCounter} =~ /SRBONLY/ && $self->{TYPE}->{obj}->{roamCounter} !~ /IURLINK/ )
        {
            my ($type) = $self->{TYPE}->{obj}->{roamCounter} =~ /(SYSTEM|NORMAL)/;
            if ( defined $type )
            {
                $self->{UESTAT_IMSI}->{ $self->{TYPE}->{obj}->{IMSI} }->{SRB}->{$type}++;
                $self->{UESTAT_IMSI}->{ $self->{TYPE}->{obj}->{IMSI} }->{lastTime} = $self->{TYPE}->{obj}->{realTime};
                $self->{UESTAT_IMSI}->{ $self->{TYPE}->{obj}->{IMSI} }->{lastType} = $type;
                $self->{UESTAT_CELL}->{ $self->{TYPE}->{obj}->{cellId} }->{$mapname}->{SRB}->{$type}++;
                $self->{UESTAT_COUNTER}->{ $roamCounter }->{$mapname}->{SRB}->{$type}++;
                $self->{UESTAT_CONN}->{ $connType }->{$mapname}->{SRB}->{$type}++;
                $self->{UESTAT_IMSI}->{ $self->{TYPE}->{obj}->{IMSI} }->{TYPE} = $mapname;
            }
        }
        elsif ( $self->{TYPE}->{obj}->{IMSI} =~/^(2359[14][12]00|2359400)\d+/ && $self->{TYPE}->{obj}->{roamCounter} !~ /SRBONLY|IURLINK/ )
        {
            my ($type) = $self->{TYPE}->{obj}->{roamCounter} =~ /(SYSTEM|NORMAL)/;
            if ( defined $type )
            {
                $self->{UESTAT_IMSI}->{ $self->{TYPE}->{obj}->{IMSI} }->{RAB}->{$type}++;
                $self->{UESTAT_IMSI}->{ $self->{TYPE}->{obj}->{IMSI} }->{lastTime} = $self->{TYPE}->{obj}->{realTime};
                $self->{UESTAT_IMSI}->{ $self->{TYPE}->{obj}->{IMSI} }->{lastType} = $type;
                $self->{UESTAT_CELL}->{ $self->{TYPE}->{obj}->{cellId} }->{$mapname}->{RAB}->{$type}++;
                $self->{UESTAT_COUNTER}->{ $roamCounter }->{$mapname}->{RAB}->{$type}++;
                $self->{UESTAT_CONN}->{ $connType }->{$mapname}->{RAB}->{$type}++;
                $self->{UESTAT_IMSI}->{ $self->{TYPE}->{obj}->{IMSI} }->{TYPE} = $mapname;
                $self->{$mapname}->{lastRabAction} = $self->{TYPE}->{obj}->{realTime};
            }
        }
        elsif ( $self->{TYPE}->{obj}->{IMSI} =~/^(2359[14][12]00|2359400)\d+/ && $self->{TYPE}->{obj}->{roamCounter} =~ /SRBONLY/ && $self->{TYPE}->{obj}->{roamCounter} !~ /IURLINK/ )
        {
            my ($type) = $self->{TYPE}->{obj}->{roamCounter} =~ /(SYSTEM|NORMAL)/;
            if ( defined $type )
            {
                $self->{UESTAT_IMSI}->{ $self->{TYPE}->{obj}->{IMSI} }->{SRB}->{$type}++;
                $self->{UESTAT_IMSI}->{ $self->{TYPE}->{obj}->{IMSI} }->{lastTime} = $self->{TYPE}->{obj}->{realTime};
                $self->{UESTAT_IMSI}->{ $self->{TYPE}->{obj}->{IMSI} }->{lastType} = $type;
                $self->{UESTAT_CELL}->{ $self->{TYPE}->{obj}->{cellId} }->{$mapname}->{SRB}->{$type}++;
                $self->{UESTAT_COUNTER}->{ $roamCounter }->{$mapname}->{SRB}->{$type}++;
                $self->{UESTAT_CONN}->{ $connType }->{$mapname}->{SRB}->{$type}++;
                $self->{UESTAT_IMSI}->{ $self->{TYPE}->{obj}->{IMSI} }->{TYPE} = $mapname;
            }
        }
        #elsif ( $self->{TYPE}->{obj}->{IMSI} =~ /^[0-9]+$/ && $self->{TYPE}->{obj}->{roamCounter} !~ /SRBONLY|IURLINK/ )
        #{
        #    my ($type) = $self->{TYPE}->{obj}->{roamCounter} =~ /(SYSTEM|NORMAL)/;
        #    if ( defined $type )
        #    {
        #        $self->{UESTAT_IMSI}->{ $self->{TYPE}->{obj}->{IMSI} }->{RAB}->{$type}++;
        #        $self->{UESTAT_IMSI}->{ $self->{TYPE}->{obj}->{IMSI} }->{lastTime} = $self->{TYPE}->{obj}->{realTime};
        #        $self->{UESTAT_IMSI}->{ $self->{TYPE}->{obj}->{IMSI} }->{lastType} = $type;
        #        $self->{UESTAT_CELL}->{ $self->{TYPE}->{obj}->{cellId} }->{"3GSIM"}->{RAB}->{$type}++;
        #        $self->{UESTAT_COUNTER}->{ $roamCounter }->{roamCounter}->{"3GSIM"}->{RAB}->{$type}++;
        #        $self->{UESTAT_CONN}->{ $connType }->{connType}->{"3GSIM"}->{RAB}->{$type}++;
        #        $self->{UESTAT_IMSI}->{ $self->{TYPE}->{obj}->{IMSI} }->{TYPE} = "3GSIM";
        #        $self->{"3GSIM"}->{lastRabAction} = $self->{TYPE}->{obj}->{realTime};
        #    }
        #}
        #elsif ( $self->{TYPE}->{obj}->{IMSI} =~ /^[0-9]+$/ && $self->{TYPE}->{obj}->{roamCounter} =~ /SRBONLY/ && $self->{TYPE}->{obj}->{roamCounter} !~ /IURLINK/ )
        #{
        #    my ($type) = $self->{TYPE}->{obj}->{roamCounter} =~ /(SYSTEM|NORMAL)/;
        #    if ( defined $type )
        #    {
        #        $self->{UESTAT_IMSI}->{ $self->{TYPE}->{obj}->{IMSI} }->{SRB}->{$type}++;
        #        $self->{UESTAT_IMSI}->{ $self->{TYPE}->{obj}->{IMSI} }->{lastTime} = $self->{TYPE}->{obj}->{realTime};
        #        $self->{UESTAT_IMSI}->{ $self->{TYPE}->{obj}->{IMSI} }->{lastType} = $type;
        #        $self->{UESTAT_CELL}->{ $self->{TYPE}->{obj}->{cellId} }->{"3GSIM"}->{SRB}->{$type}++;
        #        $self->{UESTAT_COUNTER}->{ $roamCounter }->{roamCounter}->{"3GSIM"}->{SRB}->{$type}++;
        #        $self->{UESTAT_CONN}->{ $connType }->{connType}->{"3GSIM"}->{SRB}->{$type}++;
        #        $self->{UESTAT_IMSI}->{ $self->{TYPE}->{obj}->{IMSI} }->{TYPE} = "3GSIM";
        #    }
        #}
        #elsif( $self->{TYPE}->{obj}->{roamCounter} !~ /IURLINK/ )
        #{
        #    #handle undef;
        #}
    }
    return undef;
}

sub ueStat::printer(){
    my $self = shift;
    my $conf = shift;
    my $printer = shift;
    my $format = shift;
    my @tablesToPrint = ();
    my $totalSystemDrop = 0;
    foreach my $imsi ( keys %{$self->{UESTAT_IMSI}} )
    {
        if ( defined $self->{UESTAT_IMSI}->{ $imsi } && defined $self->{UESTAT_IMSI}->{ $imsi }->{TYPE} && $self->{UESTAT_IMSI}->{ $imsi }->{TYPE} eq "REAL" )
        {
            if ( defined $self->{UESTAT_IMSI}->{$imsi}->{RAB}->{SYSTEM} )
            {
                $totalSystemDrop += $self->{UESTAT_IMSI}->{$imsi}->{RAB}->{SYSTEM};
            }
        }
    }
    foreach my $imsi ( keys %{$self->{UESTAT_IMSI}} )
    {
        if ( !defined $self->{UESTAT_IMSI}->{$imsi}->{RAB}->{NORMAL} )
        {
            $self->{UESTAT_IMSI}->{$imsi}->{RAB}->{NORMAL} = 0;
        }
        if ( !defined $self->{UESTAT_IMSI}->{$imsi}->{RAB}->{SYSTEM} )
        {
            $self->{UESTAT_IMSI}->{$imsi}->{RAB}->{SYSTEM} = 0;
        }
        if ( !defined $self->{UESTAT_IMSI}->{$imsi}->{SRB}->{NORMAL} )
        {
            $self->{UESTAT_IMSI}->{$imsi}->{SRB}->{NORMAL} = 0;
        }
        if ( !defined $self->{UESTAT_IMSI}->{$imsi}->{SRB}->{SYSTEM} )
        {
            $self->{UESTAT_IMSI}->{$imsi}->{SRB}->{SYSTEM} = 0;
        }
        #my $cellId = '-';
        #if ( defined $self->{UESTAT_IMSI}->{$imsi}->{cellId} )
        #{
        #    $cellId = $self->{UESTAT_IMSI}->{$imsi}->{cellId};
        #}
        #my $roamCounter = $self->{UESTAT_IMSI}->{$imsi}->{roamCounter};
        #$roamCounter = '-' if !defined $roamCounter;
        #my $connType = $self->{UESTAT_IMSI}->{$imsi}->{connType};
        my $system = $self->{UESTAT_IMSI}->{$imsi}->{RAB}->{SYSTEM};
        my $normal = $self->{UESTAT_IMSI}->{$imsi}->{RAB}->{NORMAL};
        my $SRBsystem = $self->{UESTAT_IMSI}->{$imsi}->{SRB}->{SYSTEM};
        my $SRBnormal = $self->{UESTAT_IMSI}->{$imsi}->{SRB}->{NORMAL};
        my $totalRAB = $self->{UESTAT_IMSI}->{$imsi}->{RAB}->{NORMAL} + $self->{UESTAT_IMSI}->{$imsi}->{RAB}->{SYSTEM};
        my $totalSRB = $self->{UESTAT_IMSI}->{$imsi}->{SRB}->{NORMAL} + $self->{UESTAT_IMSI}->{$imsi}->{SRB}->{SYSTEM};
        my $ueType;

        my $simVsReal = $self->{UESTAT_IMSI}->{ $imsi }->{TYPE};
        $simVsReal = '-' if !defined $simVsReal;
        if ( defined $self->{UECONFIG}->{$imsi}->{uetype} )
        {
            $ueType = $self->{UECONFIG}->{$imsi}->{uetype};
        }
        elsif( $simVsReal eq "REAL" )
        {
            $ueType = "UNKNOWN";
        }
        else
        {
            $ueType = "-";
        }
        my $profile = '-';
        if ( defined $self->{UECONFIG}->{$imsi}->{profile} )
        {
            $profile = $self->{UECONFIG}->{$imsi}->{profile};
        }
        my $route = '-';
        if ( defined $self->{UECONFIG}->{$imsi}->{route} )
        {
            $route = $self->{UECONFIG}->{$imsi}->{route};
        }
        my $rabDrop = '-';
        my $srbDrop = '-';
        if ( $totalRAB != 0 )
        {
            $rabDrop = sprintf( "%0.2f", ( $self->{UESTAT_IMSI}->{$imsi}->{RAB}->{SYSTEM} / $totalRAB ) * 100 );
        }
        if ( $totalSRB != 0 )
        {
            $srbDrop = sprintf( "%0.2f", ( $self->{UESTAT_IMSI}->{$imsi}->{SRB}->{SYSTEM} / $totalSRB ) * 100 );
        }
        my $rabDropSorter = $rabDrop;
        if ( $rabDropSorter eq '-' )
        {
            $rabDropSorter = 0;
        }
        my $lastTime = $self->{UESTAT_IMSI}->{$imsi}->{lastTime};
        $lastTime = '-' if !defined $lastTime;
        my $lastRelease = $self->{UESTAT_IMSI}->{$imsi}->{lastType};
        $lastRelease = '-' if !defined $lastRelease;


        my $timeParser = new timeparser( );
        my $dur = "";
        if ( defined  $self->{UESTAT_IMSI}->{$imsi}->{lastTime} && $self->{$simVsReal}->{lastRabAction} )
        {
            $dur = $timeParser->timeparser::modify_time( newtime=> $self->{UESTAT_IMSI}->{$imsi}->{lastTime}, time => $self->{$simVsReal}->{lastRabAction}, diff => 1 );
            if ( $dur =~ /0000-00-00 (\S+)/ )
            {
                $dur = $1;
            }
            if ( $dur =~ /^(\d+):(\d+):(\d+)$/ )
            {
                if ( $1 < 2 )
                {
                    $dur = "";
                }
            }
        }
        my $IMSI_analysis_string = $simVsReal . ';' . $imsi . ';' . $ueType . ';' . $totalRAB . '/' . $system . ';' . $rabDrop . ';' . $totalSRB . '/' . $SRBsystem . ';' . $srbDrop . ';' . $lastTime . ';' . $lastRelease. ';' . "$dur";
        $self->{table}->{'IMSI analysis'}->{TABLE}->{$IMSI_analysis_string} = $imsi;

        if ( $rabDrop ne '-' && $rabDrop ne '0.00' )
        {
            my $contribution = 0;

            if ( $totalSystemDrop > 0 )
            {
                $contribution = sprintf( "%0.2f", ( $system / $totalSystemDrop ) * 100 );
            }
            my $worst_imsi_string = $simVsReal . ';' . $imsi . ';' . $ueType . ';' . $totalSystemDrop . '/' . $system . ';' . $contribution . ';';
            $self->{table}->{'worst UEs with RAB drop'}->{TABLE}->{$worst_imsi_string} = $contribution;
        }
        $self->{reparese}->{'UE Type analysis'}->{$ueType}->{$simVsReal}->{RAB}->{NORMAL} += $normal;
        $self->{reparese}->{'UE Type analysis'}->{$ueType}->{$simVsReal}->{RAB}->{SYSTEM} += $system;
        $self->{reparese}->{'UE Type analysis'}->{$ueType}->{$simVsReal}->{RAB}->{TOTAL} += ( $normal + $system);
        $self->{reparese}->{'UE Type analysis'}->{$ueType}->{$simVsReal}->{SRB}->{NORMAL} += $SRBnormal;
        $self->{reparese}->{'UE Type analysis'}->{$ueType}->{$simVsReal}->{SRB}->{SYSTEM} += $SRBsystem;
        $self->{reparese}->{'UE Type analysis'}->{$ueType}->{$simVsReal}->{SRB}->{TOTAL} += ( $SRBnormal + $SRBsystem);

        $self->{reparese}->{'Profile analysis'}->{$profile}->{$simVsReal}->{RAB}->{NORMAL} += $normal;
        $self->{reparese}->{'Profile analysis'}->{$profile}->{$simVsReal}->{RAB}->{SYSTEM} += $system;
        $self->{reparese}->{'Profile analysis'}->{$profile}->{$simVsReal}->{RAB}->{TOTAL} += ( $normal + $system);
        $self->{reparese}->{'Profile analysis'}->{$profile}->{$simVsReal}->{SRB}->{NORMAL} += $SRBnormal;
        $self->{reparese}->{'Profile analysis'}->{$profile}->{$simVsReal}->{SRB}->{SYSTEM} += $SRBsystem;
        $self->{reparese}->{'Profile analysis'}->{$profile}->{$simVsReal}->{SRB}->{TOTAL} += ( $SRBnormal + $SRBsystem);

        $self->{reparese}->{'CCN Route analysis'}->{$route}->{$simVsReal}->{RAB}->{NORMAL} += $normal;
        $self->{reparese}->{'CCN Route analysis'}->{$route}->{$simVsReal}->{RAB}->{SYSTEM} += $system;
        $self->{reparese}->{'CCN Route analysis'}->{$route}->{$simVsReal}->{RAB}->{TOTAL} += ( $normal + $system);
        $self->{reparese}->{'CCN Route analysis'}->{noSRB} =1;
    }


    foreach my $cellId ( keys %{$self->{UESTAT_CELL}} )
    {
        foreach my $simVsReal ( keys %{$self->{UESTAT_CELL}->{$cellId}} )
        {
            my $normal         = $self->{UESTAT_CELL}->{$cellId}->{$simVsReal}->{RAB}->{"NORMAL"};
            my $system         = $self->{UESTAT_CELL}->{$cellId}->{$simVsReal}->{RAB}->{"SYSTEM"};
            my $SRBnormal     = $self->{UESTAT_CELL}->{$cellId}->{$simVsReal}->{SRB}->{"NORMAL"};
            my $SRBsystem     = $self->{UESTAT_CELL}->{$cellId}->{$simVsReal}->{SRB}->{"SYSTEM"};
            $normal = 0 if !defined $normal;
            $system = 0 if !defined $system;
            $SRBnormal = 0 if !defined $SRBnormal;
            $SRBsystem = 0 if !defined $SRBsystem;
            $self->{reparese}->{'Cell analysis'}->{$cellId}->{$simVsReal}->{RAB}->{NORMAL} += $normal;
            $self->{reparese}->{'Cell analysis'}->{$cellId}->{$simVsReal}->{RAB}->{SYSTEM} += $system;
            $self->{reparese}->{'Cell analysis'}->{$cellId}->{$simVsReal}->{RAB}->{TOTAL} += ( $normal + $system);

            $self->{reparese}->{'Cell analysis'}->{$cellId}->{$simVsReal}->{SRB}->{NORMAL} += $SRBnormal;
            $self->{reparese}->{'Cell analysis'}->{$cellId}->{$simVsReal}->{SRB}->{SYSTEM} += $SRBsystem;
            $self->{reparese}->{'Cell analysis'}->{$cellId}->{$simVsReal}->{SRB}->{TOTAL} += ( $SRBnormal + $SRBsystem);
        }
    }
    foreach my $counter ( keys %{$self->{UESTAT_COUNTER}} )
    {
        foreach my $simVsReal ( keys %{$self->{UESTAT_COUNTER}->{$counter}} )
        {
            my $normal = $self->{UESTAT_COUNTER}->{$counter}->{$simVsReal}->{RAB}->{"NORMAL"};
            my $system = $self->{UESTAT_COUNTER}->{$counter}->{$simVsReal}->{RAB}->{"SYSTEM"};
            $normal = 0 if !defined $normal;
            $system = 0 if !defined $system;
            $self->{reparese}->{'Rab analysis'}->{$counter}->{$simVsReal}->{RAB}->{NORMAL} += $normal;
            $self->{reparese}->{'Rab analysis'}->{$counter}->{$simVsReal}->{RAB}->{SYSTEM} += $system;
            $self->{reparese}->{'Rab analysis'}->{$counter}->{$simVsReal}->{RAB}->{TOTAL} += ( $normal + $system);
            $self->{reparese}->{'Rab analysis'}->{noSRB} =1;
        }
    }
    foreach my $connType ( keys %{$self->{UESTAT_CONN}} )
    {
        foreach my $simVsReal ( keys %{$self->{UESTAT_CONN}->{$connType}} )
        {
            my $normal = $self->{UESTAT_CONN}->{$connType}->{$simVsReal}->{RAB}->{"NORMAL"};
            my $system = $self->{UESTAT_CONN}->{$connType}->{$simVsReal}->{RAB}->{"SYSTEM"};
            $normal = 0 if !defined $normal;
            $system = 0 if !defined $system;
            $self->{reparese}->{'RRC connection analysis'}->{$connType}->{$simVsReal}->{RAB}->{NORMAL} += $normal;
            $self->{reparese}->{'RRC connection analysis'}->{$connType}->{$simVsReal}->{RAB}->{SYSTEM} += $system;
            $self->{reparese}->{'RRC connection analysis'}->{$connType}->{$simVsReal}->{RAB}->{TOTAL} += ( $normal + $system);
            $self->{reparese}->{'RRC connection analysis'}->{noSRB} =1;
        }
    }
    foreach my $imsi ( keys %{$self->{UECONFIG}} )
    {
        if ( !defined $self->{UESTAT_IMSI}->{$imsi} )
        {
            my $ueType = "-";

            if ( defined $self->{UECONFIG}->{$imsi}->{uetype} )
            {
                $ueType = $self->{UECONFIG}->{$imsi}->{uetype};
            }
            my $simVsReal;
            if ( defined  $self->{UECONFIG}->{$imsi} || $imsi =~/^2359[14][12]\d+/ )
            {
                $simVsReal = "REAL";
            }
            else
            {
                $simVsReal = "3GSIM";
            }
            $simVsReal = '-' if !defined $simVsReal;
            my $imsi_no_rab_action_string = $simVsReal . ';' . $imsi . ';' . $ueType . ';';
            $self->{table}->{'UEs with no RAB actions'}->{TABLE}->{$imsi_no_rab_action_string} = $imsi;
        }
    }
    foreach my $tableName ( keys %{$self->{'reparese'}} )
    {
        my $noSRB;
        foreach my $type ( keys %{$self->{reparese}->{$tableName}} )
        {
            if ( defined $self->{reparese}->{$tableName}->{noSRB} )
            {
                $noSRB = 1;
                delete $self->{reparese}->{$tableName}->{noSRB};
            }
            foreach my $simVsReal ( keys %{$self->{reparese}->{$tableName}->{$type}} )
            {
                my $system = $self->{reparese}->{$tableName}->{$type}->{$simVsReal}->{RAB}->{SYSTEM};
                my $normal = $self->{reparese}->{$tableName}->{$type}->{$simVsReal}->{RAB}->{NORMAL};
                my $totalRAB = $self->{reparese}->{$tableName}->{$type}->{$simVsReal}->{RAB}->{TOTAL};
                my $SRBnormal = $self->{reparese}->{$tableName}->{$type}->{$simVsReal}->{SRB}->{NORMAL};
                my $SRBsystem = $self->{reparese}->{$tableName}->{$type}->{$simVsReal}->{SRB}->{SYSTEM};
                my $totalSRB = $self->{reparese}->{$tableName}->{$type}->{$simVsReal}->{SRB}->{TOTAL};
                my $rabDrop = '-';
                my $srbDrop = '-';
                if ( $totalRAB != 0 )
                {
                    $rabDrop = sprintf( "%0.2f", ( $system / $totalRAB )*100);
                }
                if ( !defined $noSRB && $totalSRB != 0 )
                {
                    $srbDrop = sprintf( "%0.2f", ( $SRBsystem / $totalSRB )*100);
                }
                my $rabDropSorter = $rabDrop;
                if ( $rabDropSorter eq '-' )
                {
                    $rabDropSorter = 0;
                }
                my $string = $simVsReal . ';' . $type . ';' . $totalRAB . '/' . $system . ';' . $rabDrop . ';' ;
                if ( !defined $noSRB )
                {
                    $string .= $SRBnormal . '/' . $SRBsystem . ';' . $srbDrop . ';';
                }

                if ( defined $self->{table}->{$tableName}->{sortMethod} &&  ( $self->{table}->{$tableName}->{sortMethod} == 2 || $self->{table}->{$tableName}->{sortMethod} == 1 ) )
                {
                    $self->{table}->{$tableName}->{TABLE}->{$string} = $type;
                }
                else
                {
                    $self->{table}->{$tableName}->{TABLE}->{$string} = $rabDropSorter;
                }
            }
        }
    }

    my $tablePrinters = $self->{type}->getTablesPrinter();
    foreach my $tablePrinter ( @$tablePrinters )
    {
        if ( defined $conf->{csv} && $format eq 'CSVPRINTER' )
        {
            $tablePrinter->{PRINTER} = $tablePrinter->{CSVPRINTER};
            $tablePrinter->{fh} = $self->{fh};
            $tablePrinter->printTable( );
        }
        elsif( $format eq 'TEXTPRINTER' )
        {
            $tablePrinter->{PRINTER} = $tablePrinter->{TEXTPRINTER};
            $tablePrinter->{fh} = $self->{fh};
            $tablePrinter->printTable( );
        }
        elsif ( defined  $conf->{html} && $format eq 'HTMLPRINTER' )
        {
            $tablePrinter->{HTMLPATH} = $conf->{html};
            $tablePrinter->{PRINTER} = $tablePrinter->{HTMLPRINTER};
            $tablePrinter->printTable( );
            my $name = ( defined $tablePrinter->{max}?"Top $tablePrinter->{max} ":"") .  $tablePrinter->{name};
            #my $name = 'Top_' . $tablePrinter->{max} . '_' . $tablePrinter->{name};
            if ( defined $self->{table}->{$name} ) ##Check that there actually is a table to print for the name.
            {
                $name =~ s/\s+/_/g;
                push( @tablesToPrint, $name );
            }
        }
    }
    delete $self->{table};
    delete $self->{reparese};
    return @tablesToPrint;
}


sub ueStat::parseConfig(){
    my $self = shift;
    my $file = shift;
    return if !defined $file;
    open CONFIG, "< $file";
    foreach my $line ( <CONFIG> )
    {
        if ( $line =~ /^\s*#/ )
        {
            next;
        }
        next if $line =~ /^\s*$/;
        if ( $line =~ /^\s*(\S+?)\s*=\s*(.+?)\s*$/ )
        {
            next;
        }
        my @line = split( /\s+/, $line );
        if ( @line == 5 )
        {
            if ( $line =~ /^\s*(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+(Rack\S+)_(Route_\S+)\s*$/i )
            {
                my ( $imsi, $uetyp, $ueno, $profile, $ccn, $rutt ) = ( $1, $2, $3, $4, $5, $6 );
                $self->{UECONFIG}->{$imsi}->{uetype}  = $uetyp;
                $self->{UECONFIG}->{$imsi}->{ueno}    = $ueno;
                $self->{UECONFIG}->{$imsi}->{profile} = $profile;
                $self->{UECONFIG}->{$imsi}->{route}   = $rutt;
                $self->{UECONFIG}->{$imsi}->{ccn}   = $ccn;
                my $length = (length( $profile ));
                if ( !defined $self->{UECONFIG_LENGTH} )
                {
                    $self->{UECONFIG_LENGTH} = 0;
                }
                if ( $length > $self->{UECONFIG_LENGTH} )
                {
                    $self->{UECONFIG_LENGTH} = $length;
                }
                push( @{$self->{UEARRAY}->{$ccn}->{$rutt}}, $imsi );
            }
        }
        else
        {
            print STDERR "teSummary wrong format in config file: $line\n";
        }
    }
    close CONFIG;
}

sub ueStat::parse_imsimap
{
    my $self = shift;
    my $conf = shift;
    my $imsimap = $conf->{BASE} . "/etc/imsimap.txt";
    if ( -e $imsimap )
    {
        open IMSIMAP, "<$imsimap";
        while ( my $line = <IMSIMAP> )
        {
            chomp $line;
            if (  $line =~ /^\s*(\d{15})\s+(\d{15})\s+(.+?)\s*$/ )
            {
                $self->{imsimap}->{$1}->{range} = $2;
                $self->{imsimap}->{$1}->{name} = $3;
            }
        }
        close IMSIMAP;
    }

}


1;



1;
