///////////////////////////////////////////////////////////////////////////////////////
//                                                                                   //
//  Ericsson AB 2010 - All Rights Reserved                                          //
//                                                                                   //
// The copyright to the computer program(s) herein is the property of Ericsson AB,   //
// Sweden. The programs may be used and/or copied only with the written permission   //
// from Ericsson AB or in accordance with the terms and conditions stipulated in the //
// agreement/contract under which the program(s) have been supplied.                 //
//                                                                                   //
///////////////////////////////////////////////////////////////////////////////////////

//  Graph drawing script used in pmSummary (pmx, pmr in moshell), teSummary and gpbLoad

var previousPoint = null;
var i=0;

var plot;
var graph;
var overview;
var legend;

var pageVars = [];
	pageVars.infoOffset = 0;
    
$(document).ready(function()
{
	$('.ropTableLink').each(function()
	{
	    var name = $(this).attr('name');
	    $(this).click(function () 
	    {
		toggleStatusInd(this);
		loadContent(name);
	    });
    });
    init();
});
   
function toggleStatusInd(thisObj)
{
    var curStatus = $(thisObj).data('status');
    if( curStatus == undefined)
    {
	$(thisObj).prepend('<span name="status">-</span>');	
	$(thisObj).data('status',"-");
	
    }
    else 
    {
	if(curStatus == "+") curStatus = "-";
	else curStatus = "+";

	$('span',thisObj).html(curStatus);
	$(thisObj).data('status',curStatus);	    
    }

}


function is_int(value){
  if((parseFloat(value) == parseInt(value,10)) && !isNaN(parseInt(value,10))){
      return true;
 } else {
      return false;
 }
}

function info(text){
	if(text === "") 
	{ 
		$("#infobox").hide(0); 
	}
	else
	{
		//Get the window height and width  
		var winH = $("body").height();  
		var winW = $("body").width();  
		
		$("#infoboxcontent").html(text);
		$("#infobox").show();
		//Set the popup window to center  $("#infobox").css("top", $("#main").scrollTop());
		$("#infoboxcontent").css('top',  $("body").scrollTop()+$("body").height()*0.1);  
		$("#infoboxcontent").css('left', winW/2-$("#infoboxcontent").width()/2);  
	}
}
function resizeInfoBox()
{
	// triggered by window resize aswell as called by setupInfoBox
	
   //Get the screen height and width  
    var maskHeight = $("body").height();  
	var maskWidth = $("body").width();  

	//Set height and width to mask to fill up the whole screen  
    $('#mask').css({'width':maskWidth,'height':maskHeight});  
    $('#infoboxcontent').css({'max-width':maskWidth/2,  'max-height':maskHeight/2}); 
    
}
function setupInfoBox()
{
	
	var mask = '<div id="mask" style="position:fixed; opacity:0.5; z-index:1; background-color:#000; top:0px; left:0px;"></div>'; 
	$("#infobox").append(mask);
	
	var content = '<div id="infoboxcontent" style="background:white;position:absolute;   z-index:2; padding:20px;" ></div>';
	$("#infobox").append(content);
	
	resizeInfoBox();
	
}
function readDataSeriesInformation()
{
// we dont care about waiting or checking the result of this one
// we will do the check when trying to draw markings
    info("reading extra information ("+pageVars.graphType+")"); 
	if(pageVars.graphType == "teSummary")
	{
	    $.getScript("dataseries/lost_traces.js", function() {
		    info("");
		    window['lost_traces_hourly'] = [];
		    window['ranges_lost_traces'] = [];
		    window['ranges_lost_traces_hourly'] = [];
		    
		    var arrLen=window['lost_traces'].length;
		    for ( var i=0, len=arrLen; i<len; ++i ){
			var timestamp = window['lost_traces'][i];
			window['ranges_lost_traces'].push([timestamp-3000,timestamp+3000]);
			var full =  (timestamp / (1000*60*60) ) % 24;
			if(is_int(full))
			{	
				window['lost_traces_hourly'].push(timestamp); 
				window['ranges_lost_traces_hourly'].push([timestamp-3000,timestamp+3000]);
			}
			else
			{
				var nextFull = Math.ceil(full);
				var diff = nextFull - full;
				timestamp = timestamp+(diff*1000*60*60);
				
				// only push new ones
				if(!window['lost_traces_hourly'].inArray(timestamp)) { 
					window['lost_traces_hourly'].push(timestamp); 
					window['ranges_lost_traces_hourly'].push([timestamp-300000,timestamp+300000]);
				}
			}
			
		
		    }});
	} // This is of type teSummary
	else if(pageVars.graphType == "pmr")
	    {
		$.getScript("dataseries/formulas.js", function() {
			//console.dir(formulas['AvgSpeechErlang']);
			info("");
		    });	
		$.get("configfile.txt", function(data) {
			var lines = data.split("\n");
			var report = "";
			var options = "";
			
			$.each(lines,function(index,value){
				if(value.match(/reportName/i))
				    {
					report = value.match(/\s*reportName\s+(.*)$/)[1];
					report = report.replace(/ /g,"_");
					report = report.replace(/,/g,"");
					report = report.replace(/\(/g,"");
					report = report.replace(/\)/g,"");
					if(report == "somereallystrnagERBS_EUtranCellFDD_Random_Accessibility_ROP_by_ROP") { debug = 1; }
					else { debug = 0; }
					if(debug) { 	console.log(report); };
				    }
				if(value.match(/graphOptions/i))
				    {
					pageVars.graphOptions[report] = [];
					pageVars.graphOptions[report]['axes'] = [];

					if(debug) { console.log(value); }
					var items = value.match(/graphOptions\s*(.*)$/i)[1].split(",");
					var order = 0;
					var axisName;
					var axisPos;
					var axisnum;
					var axisDescription;
					var axisConf = {};
					var axisKeys = [];
					$.each(items,function(index,i)
					       {
						   if(debug) { console.log("'"+i+"'"); }
						   i=i.replace(/^\s+|\s+$/g, '');

						   var arr;
						   //y2:right:Success Rate,RrcSuc
						   arr = i.match(/^y(\d):(.*):(.*)$/);
						   if(arr) 
						       { // axis config
							   
							   axisName = parseInt(arr[1],10);
							   axisPos = arr[2];
							   axisDescription = arr[3];
							   axisConf[axisName] = axisPos;

							   axisKeys.push(axisName);
							   pageVars.graphOptions[report]['axes'][axisName] = [];
							   pageVars.graphOptions[report]['axes'][axisName]['pos'] = axisPos;
							   pageVars.graphOptions[report]['axes'][axisName]['description'] = axisDescription;
							   pageVars.graphOptions[report]['axes'][axisName]['series'] = [];
						       }
						   else
						       {
							   pageVars.graphOptions[report]['axes'][axisName]['series'].push(i);
						       }
					       });
					axisKeys = axisKeys.sort();
					// stoppa in y1 default
					pageVars.graphOptions[report]['axesConf'] = [{}];
					$.each(axisKeys,function(index,key){
						var o = { tickDecimals:2,position:   pageVars.graphOptions[report]['axes'][key]['pos']};
						pageVars.graphOptions[report]['axesConf'].push(o);
					    });
				    } // if /graphOptions/
			    }); //.each line in file
			//console.dir(pageVars.graphOptions);
		    }); // get
	    }
	else if(pageVars.graphType == "default")
	    {
		info("");
	    }
	else
	    {
		alert("Sorry, we havent implemented any support for this type of graph! yet..."+$('title').attr('text'));
	    }
	
} // readDataSeriesInformation
function init()
{
	pageVars.workingGraph = "";
	pageVars.graphs = [];
	pageVars.legendHighLights = [];
	pageVars.datapointsHighLights = [];
	pageVars.graphOptions = [];
	pageVars.graphType = "";
	if($('title').attr('text').match(/teSummary/)) { pageVars.graphType = "teSummary"; }
	if($('title').attr('text').match(/pmSummary/)) { pageVars.graphType = "pmr"; }
	if($('title').attr('text').match(/gpbLoad/)) { pageVars.graphType = "default"; }
	pageVars.setWorkingGraph = function(graphName) 
	{ 
		if(typeof graphName != "string") 
		{ 
			alert("ERROR: graphName was not a string in call of setGraphName()");
			return false;
		}		
		
		// point all vars to current graph
		pageVars.workingGraph = graphName;
		pageVars.wrapperDiv = "wrapper_"+graphName;
		pageVars.graphDiv = "graph_"+graphName;
		pageVars.overviewDiv = "overview_"+graphName;
		pageVars.legendDiv = "legend_"+graphName;
		pageVars.optionsDiv = "options_"+graphName;
		pageVars.reportName = graphName.match(/(.*)_flot/)[1];
		return true;
	};
	
	pageVars.getWorkingGraphName = function() { return this.workingGraph; };
	
	pageVars.getResolution = function() { return this.graphs[this.workingGraph].resolution; };
	pageVars.setResolutionRop = function() { this.graphs[this.workingGraph].resolution = "rop"; };
	pageVars.setResolutionHour = function() { this.graphs[this.workingGraph].resolution = "hour"; };

	pageVars.getDataSerie = function() 
	{
		if(pageVars.getResolution() == "hour") { return window[pageVars.workingGraph+'_hourly']; }
		else { return window[pageVars.workingGraph]; }
	
	};



	pageVars.buildYAxelInformation = function(label) 
	    { 
		window[pageVars.workingGraph].yaxel = [];	
	
		if(pageVars.reportName in pageVars.graphOptions)
		    {
			var allAxes = pageVars.graphOptions[pageVars.reportName]['axes'];
			var axisNum = 1;
			for( var key in allAxes) { 
			    if(typeof allAxes[key] == "function") { return false; }

			    var axes = key;
			    axisNum++;
			    $.each( pageVars.graphOptions[pageVars.reportName]['axes'][axes]['series'], function(seriesInd,series) {
				    $.each(window[pageVars.workingGraph], function (key,obj) { 
					    var lastpart = obj.label.match(/_(.*)$/)[1];
					    if(lastpart == series) 
						{
						    obj.yaxis = parseInt(axisNum,10);
						    obj.label = obj.label + " (y"+axes+")";
						    window[pageVars.workingGraph].yaxel[series] = axisNum;
						}
					});
				});
			}
		    }
	    };
	pageVars.gotYaxisConf = function(label) {
	    if(label in window[pageVars.workingGraph].yaxel) { return true; } 
	    else { return false; }
	}

	pageVars.getGraphOptions = function()
	{
	    var graphOptions = {
		lines: { show: true },
		points: { show: true },
		legend: {show:false},
		xaxes: [{ mode: "time" }],
		//yaxes: [{ },{ position: "right", tickFormatter: function (v, axis) { return v+"%" }}],
		yaxes: (pageVars.reportName in pageVars.graphOptions?pageVars.graphOptions[pageVars.reportName]['axesConf']:{}),
		selection: { mode: "xy" },
		grid: { hoverable: true, clickable: true ,markings: getMarkings(),  backgroundColor: { colors: ["#CCC", "#FFF"] }}
	    };

	    return graphOptions;
	}
	pageVars.getDataSerieAccordingToChoises = function()
	{
		var resultArray = [];

		var currentFullDataSerie;
		if(pageVars.getResolution() == "hour") { currentFullDataSerie =  window[pageVars.workingGraph+'_hourly']; }
		else { currentFullDataSerie =  window[pageVars.workingGraph]; }
	
		// get the checkers
		$("#"+pageVars.legendDiv).find("input").each(function () 
		{
			var obj = this;
			var key = $(obj).attr("name");
		
			if($(obj).is(':checked'))
			{	
				
				resultArray.push(currentFullDataSerie[key]);
			}
		}); // each
		return resultArray;
	};

	pageVars.calculateSelected = function()
	{
	    var dataseries = pageVars.getDataSerie(); //pageVars.getDataSerieAccordingToChoises();
	    var xaxes = getXRanges()[0];

	    $.each(dataseries,function(index)
	    {
		var label = this.label;
		
		var min = 9999999;
		var max = -9999999;
		var avg = 0;
		var points = 0;
		$.each(this.data,function(dataindex)
		{
		    if(this[0] >= xaxes.from &&  
		       this[0] <= xaxes.to)
		    {
			// skipping undefined values
			if(this[1] || this[1] == 0) {
				points++;
				if(this[1] > max) { max = this[1]; }
				if(this[1] < min) { min = this[1]; }
		
				avg += this[1];
			}
		    }
		});

		if(points) { avg = avg/points; }

		var arr =  [min,max,avg.toFixed(3),points];
		pageVars.graphs[pageVars.workingGraph].selectedData[label] = arr;
		//console.log("label:"+label+"=> min:"+min+"=> max:"+max+"=> points:"+points+"=> avg:"+avg);
	    });
	    //console.dir(pageVars.graphs[pageVars.workingGraph].selectedData);

	}
	pageVars.minmaxavg =  function (id)
	{
	    var html = "";
	    if(pageVars.graphs[pageVars.workingGraph].selectedData[id][3] == 0)
	    {
		html = "There are no datapoints in interval, cannot calculate min, max or average<br>";
	    }
	    else
	    {
		html = "min: "+pageVars.graphs[pageVars.workingGraph].selectedData[id][0]+"<br>"; 
		html += "max: "+pageVars.graphs[pageVars.workingGraph].selectedData[id][1]+"<br>";
		html += "avg: "+pageVars.graphs[pageVars.workingGraph].selectedData[id][2]+"<br>";
		html += "datapoints in interval: "+pageVars.graphs[pageVars.workingGraph].selectedData[id][3]+"<br>";
	    }
	    return html;

	}
	setupInfoBox();

	readDataSeriesInformation();

	if($.browser.msie)
	{
		alert("Be adviced, use firefox or chrome! Using IE will be painfully slow!");
	}
}

function checkCanvasTags(){
	// Check that we have created all div-tags and so on
	// we expect a canvas, overview canvas and a legend div
	// this is for debug purpose only. IF any of theese trigger we have a problem with teSummary
	
	if( ( $("#"+pageVars.graphDiv).length + $("#"+pageVars.overviewDiv).length + $("#"+pageVars.legendDiv).length ) != 3)
	{
		if(!$("#"+pageVars.graphDiv).length) { alert("graph har inte lngden 1"); }
		if(!$("#"+pageVars.legendDiv).length) { alert("legend har inte lngden 1"); }
		if(!$("#"+pageVars.overviewDiv).length) { alert("overview har inte lngden 1"); }
		 alert("Se till att det finns en graph_, overview_ och en legen_ tillhrande :'"+pageVars.workingGraph);
		return false;
	}
	return true;
}
function resizeCanvas(){
	//resize the graphs, overview and legend according to webbrowser
	
	// window
	var winH = $(window).height();
    var winW = $(window).width();  
	
	//overview
	var overViewW = 200;
	var overViewH = 150;
	$("#"+pageVars.overviewDiv).width(overViewW);
	$("#"+pageVars.overviewDiv).height(overViewH);
	
	
	// graph
	var canvasW = 0.6*winW;
	var canvasH = 0.75*canvasW;
	$("#"+pageVars.graphDiv).width(canvasW);
	$("#"+pageVars.graphDiv).height(canvasH);
	
	// legend
	var legendW = winW-canvasW-50;
	var legendH = canvasH-overViewH-20;
	$("#"+pageVars.legendDiv).width(legendW);
	$("#"+pageVars.legendDiv).height(legendH);
	
}

Array.prototype.inArray = function (value) {
	var i;
	for (i=0; i < this.length; i++) {
		if (this[i] === value) {
			return true;
		}
	}
	return false;
};

Array.prototype.remove = function(s) {
  var i = this.indexOf(s);
  if(i != -1) this.splice(i, 1);
}

var isCanvasSupported = {
        canvas_compatible : false,
        check_canvas : function() {
                try {
                        this.canvas_compatible = !!(document.createElement('canvas').getContext('2d')); // S60
                        } catch(e) {
                        this.canvas_compatible = !!(document.createElement('canvas').getContext); // IE
                } 
                return this.canvas_compatible;
        }
};



function info_old(text){
	if(text === "") { $("#infobox").hide(100); }
	else
	{
		var temp = pageVars.infoOffset+" : "+text;
		$("#infobox").css("top",pageVars.infoOffset);
		$("#infobox").html(temp);
		$("#infobox").show(0);
	}
}
	
function loadContent(target){
	divTarget = "table_"+target;
	pageVars.infoOffset = $("#"+divTarget).scrollTop();
		
	if ( $('#'+divTarget).is(':empty') ) {
		var contentFile = "dataseries/"+target+".html";
	
		$("body").ajaxError(function(event, request, settings){
				alert("Could not find the file :" + settings.url );
				return;
		});
		info("Loading "+target);
		$.get(contentFile, function(data) {
			$("#"+divTarget).html(data);
			$("#"+divTarget).show(500);
			$('html,body').animate({
				scrollTop: $("#"+divTarget).offset().top},
			    'slow');
	

			$("#"+target).tablesorter(); 
			 $("table").bind("sortStart",function() { 
				 info("sorting");
			     }).bind("sortEnd",function() { 
				     info("");
				 }); 
			 $("th.formula").hover(function () {
				 var html = '<div id="tooltip">';
				 $.each(formulas[this.id], function(index, value) { 
					 html += value+"<br>";
				     });
				 html += '</div>';
				 $(this).append(html);
				 
			     },
			     function() {
				 $("#tooltip").remove();
			     }
			     );

			info("");
		});
	} 
	else
	{
		$('#'+divTarget).toggle();
		$('html,body').animate({
			scrollTop: $("#"+divTarget).offset().top},
		    'slow');
	
			
	}

}
function closeCanvas(canvasName){
	$("#"+canvasName).toggle();
}

// takes an array with timestamps, sums it up per hour and return an array
function sumPerHour(dataArray){
	var hourlySum  = [];
	var sum=0;
	
	for ( var i in dataArray)
	{		
		var timestamp = dataArray[i][0];
		
		//accumulate until next full hour
		sum += dataArray[i][1];
		
		// check if this is a full hour
		var full =  (timestamp / (1000*60*60) ) % 24;
		if(is_int(full))
		{
			// full hour, store the accumulated sum for this hour
			hourlySum.push([timestamp,sum]);
			sum=0;
		}
	}
	return hourlySum;
}
function setHardCodedColors() {
	// hard-code color indices to prevent them from shifting as
    // countries are turned on/off
    var i = 0;
    $.each(window[pageVars.workingGraph], function(key, val) {
        val.color = i;
        ++i;
    });
	
    if(pageVars.graphType == "teSummary")
	{
	    var j = 0;
	    $.each(window[pageVars.workingGraph+'_hourly'], function(key, val) {
		    val.color = j;
		    ++j;
		});
	}
}
function recalcRopToHours(){
	// make a copy of the dataserie object
	//var graphData = eval ( window[pageVars.workingGraph].toSource());
        var graphData = $.extend(true, [], window[pageVars.workingGraph]);
	
	for ( var serie in graphData)
	{
		var dataArray = graphData[serie]['data'];
	
		// store hourly for this serie
		graphData[serie]['data'] = sumPerHour(dataArray);
	}
	
	// store hourly data for this graph in global
	var hourlyName = pageVars.workingGraph+'_hourly';
	window[hourlyName] = graphData; 


}

function filterDataSeries()
{
    var str = $("#regExpInput").attr('value');
    var regExp = new RegExp(str,"i");
    var tmp = [];

    $("#"+pageVars.legendDiv).find("input").each(function () 
	{
	    $(this).attr('checked',  '' );
	});


    var hits = 0;
    for ( var serie in window[pageVars.workingGraph])
	{
	    
	    if(!/\D/.test(serie))
		{
		    var label = window[pageVars.workingGraph][serie]['label'];
		    var serieid = window[pageVars.workingGraph][serie]['id'];
		    if(label.match(regExp))
			{
			    hits++;
			    $("#"+pageVars.legendDiv).find("#"+serieid).attr('checked','checked');
			}
		}
	}
    if(hits===0)
	{
	    alert("No series matched your filter, please try again\nMake sure you follow normal regular expression syntax");
	}
    else
	{
	    plotAccordingToChoices();
	}
}


function dynamicInitialResolution()
{
	if( window[pageVars.workingGraph][0]['data'].length < 16 || pageVars.workingGraph == 'HANDOVER_DELAY_flot')
	{
		pageVars.setResolutionRop();
		$('input[id="resolution_'+pageVars.workingGraph+'_hour"]').attr('checked', false);
		$('input[id="resolution_'+pageVars.workingGraph+'_rop"]').attr('checked', true);
	}
	
	
}
function insertDivTags()
{
    var name = pageVars.workingGraph; //RNC_Node_Traffic_Performance_ROP_by_ROP_flot
    var html = "";
    
    html += '<div id="graph_'+name+'" style="float:left;width:10px;height:10px"></div>\n';
    html += '<div id="miniature_'+name+'" style="float:left">';
    html += '      <div id="overview_'+name+'" style="float:left;width:10px;height:10px"></div>';
    html += '</div>\n';
    html += '<div id="options_'+name+'" style="float:left;border:1px solid #aaa;padding:5px;">';
    html += '   <input type="submit" id="zoomButton" onclick="resetZoom();return false;" value="Zoom out">';
    html += '</div>\n';
    html += '<div id="legend_'+name+'" style="width:10px;height:10px;float:left;overflow:scroll;"></div>\n';
    html += '<div style="clear:both;"></div>\n';

    $("#wrapper_"+pageVars.workingGraph).append(html);     


}

// assumptions:
// called from teSum, we got 1 div that we should fill up with the graph
// canvasName will be the container for canvas, overview, options, legends and so on

function setCanvas(canvasName){

	setWorkingGraph(canvasName);
	// init this graph.
	if(!initWorkingGraph()) 
	{ 	
		// we have already drawn this graph, toggle visibility and return without action
		$('#wrapper_'+canvasName).toggle();
		return false; 
	}
	info("Loading graph");
	var jsFile = "dataseries/"+canvasName+".js";
	
	if(!checkCanvasTags()) 
	{ 	
		return false;
	}

	// resize after current browser size
	resizeCanvas();

	// create ajax error handler. will only be called if the getScript fails
	$("body").ajaxError(function(event, request, settings){
			alert("Could not find the dataSerie " + settings.url );
			return;
	});
	
	// must be visible when calling drawgraph or plot will think size is zero
	$('#wrapper_'+canvasName).show();

	$.getScript(jsFile, function() {

		pageVars.buildYAxelInformation();
		if(pageVars.graphType == "teSummary") 
		    {
			recalcRopToHours();
			dynamicInitialResolution();
		    }
		setHardCodedColors();

		drawGraph();
		
		$("#"+pageVars.legendDiv).show();
		$("#"+pageVars.optionsDiv).show();
		info("");
	});

}

function plotAccordingToChoices() {

	//resett
	i = 0;
	plot = $.plot($("#"+pageVars.graphDiv), pageVars.getDataSerieAccordingToChoises(), $.extend(true, {}, pageVars.getGraphOptions(), {
		xaxes: getXMinMax(), 
		yaxes: getYMinMax() 
		})
	    );
	drawYaxisLabels(plot);
	pageVars.calculateSelected();
				
}

function selectAll(thisObj){
	setWorkingGraph(thisObj);
	$("#"+pageVars.legendDiv).find("input").each(function () 
	{
		$(this).attr('checked',  'checked' );
	});
	plotAccordingToChoices();
}
function deselectAll(thisObj){
	setWorkingGraph(thisObj);
	$("#"+pageVars.legendDiv).find("input").each(function () 
	{
		$(this).attr('checked',  '' );
	});
	plotAccordingToChoices();
}

// *********************
// invertSelection()
// invert the selection boxes and redraw graph
function invertSelection(thisObj){
	
	setWorkingGraph(thisObj);
	
	$("#"+pageVars.legendDiv).find("input").each(function () 
	{
		$(this).attr('checked', $( this ).is( ':checked' ) ? '' : 'checked' );
	});
	plotAccordingToChoices();
}

function resetZoom(thisObj){
	setWorkingGraph(thisObj);
	resetRanges();
	//pageVars.graphs[pageVars.workingGraph].xaxis = { min:  null, max: null };
	//pageVars.graphs[pageVars.workingGraph].yaxis = { min:  null, max: null };

	overview.clearSelection();
	
	plotAccordingToChoices();
	//special :/
	setRanges(null);
	pageVars.calculateSelected();	
	
    
}
// ***************************
// getMarkings()
// returns an array with x-axis markings for lost traces
function getMarkings()
{
	var markings = [];
	if(pageVars.graphType=="teSummary")
	{
	    var arr = ((pageVars.getResolution() == "hour")?window['lost_traces_hourly']:window['lost_traces']);
	    
	    var arrLen=arr.length;
	    
	    for ( var i=0, len=arrLen; i<len; ++i ){
		markings.push({ xaxis: { from: arr[i]-300000, to: arr[i] + 300000 }, color: "#FF9999" });
	    }
	}
	return markings;
}	

function drawGraph(){

	// setup overview
	drawOverview();
	var plot = $.plot($("#"+pageVars.graphDiv), pageVars.getDataSerieAccordingToChoises(), pageVars.getGraphOptions() );
	pageVars.graphs[pageVars.workingGraph].plot = plot;
	setRanges(null);

	drawYaxisLabels(plot);
	
	function showTooltip(x, y, contents) {
        $('<div id="tooltip">' + contents + '</div>').css( {
            position: 'absolute',
            display: 'none',
            top: y + 5,
            left: x + 5,
            border: '1px solid #fdd',
            padding: '2px',
            'background-color': '#fee',
            opacity: 0.80
        }).appendTo("body").fadeIn(200);
    }
 	
	
	if(!pageVars.workingGraph.initalbound)
	{
		
		pageVars.workingGraph.initalbound=1;
		
		// mouse over info
		$("#"+pageVars.graphDiv).bind("plothover", function (event, pos, item) {
				
			if (item) 
			{
			   if (previousPoint != item.datapoint) 
			   {
					previousPoint = item.datapoint;
					
					$("#tooltip").remove();
					var x = item.datapoint[0].toFixed(2),
						y = item.datapoint[1].toFixed(2);
					var tipTime = new Date(item.datapoint[0]);
					var HH = tipTime.getUTCHours();
					var MM = tipTime.getUTCMinutes();
					var SS = tipTime.getUTCSeconds();
					var MS = tipTime.getUTCMilliseconds();
					if(MM < 10) { MM = "0"+MM}
					if(SS < 10) { SS = "0"+SS}
					if(MS < 10) { MS = "00"+MS}
					else if(MS < 100) { MS = "0"+MS}
					var tipStr = HH+":"+MM+":"+SS+"."+MS;
					
					var yaxisInfo = "";
					if(pageVars.gotYaxisConf(item.series.label)) { yaxisInfo = ": "+ item.series.yaxis; }
					showTooltip(item.pageX, item.pageY,
								"# "+ item.series.label + " at " + tipStr + " = " + y + yaxisInfo);
			   }
			}
			else 
			{
				$("#tooltip").remove();
				
				 previousPoint = null;            
			}
		});  // bind mouse over

		
		//connect the zoom
		$("#"+pageVars.graphDiv).bind("plotselected", function (event, ranges) {
			info("redrawing with zoom");
			setWorkingGraph(this);
			setTimeout(function () {

				setRanges(ranges);


				// do the zooming
				plot = $.plot($("#"+pageVars.graphDiv),  pageVars.getDataSerieAccordingToChoises(),
					      $.extend(true, {}, pageVars.getGraphOptions(), {

						      xaxes: getXMinMax(),  //[ { min: ranges.xaxis.from, max: ranges.xaxis.to } ],
						      yaxes: getYMinMax(),

						      grid: { markings: getMarkings()}
						  }));
		   		drawYaxisLabels(plot);
				pageVars.calculateSelected();

				// don't fire event on the overview to prevent eternal loop
				overview.setSelection(ranges, true);
			},100); // settimeout
			info("");
		});

	    $("#"+pageVars.overviewDiv).bind("plotselected", function (event, ranges) {
			setWorkingGraph(this);
        	plot.setSelection(ranges);
		pageVars.calculateSelected();

	    });


	    $("#"+pageVars.graphDiv).bind("plotclick", function (event, pos, item) {	
		    setWorkingGraph(this);
		    if (item) {
			var pair = item.datapoint[0]+"_"+item.datapoint[1];
			if(pageVars.datapointsHighLights.inArray(pair)) 
			    {
				pageVars.datapointsHighLights.remove(pair);
				plot.unhighlight(item.series, item.datapoint);
				pageVars.legendHighLights[item.series.label] -= 1;
			    }

			else
			    {
				pageVars.datapointsHighLights.push(pair);
				plot.highlight(item.series, item.datapoint);
				if(!pageVars.legendHighLights[item.series.label])
				    { pageVars.legendHighLights[item.series.label] = 0}
				pageVars.legendHighLights[item.series.label] += 1;
			    }


		    $("#"+pageVars.legendDiv).find("span").each(function (index) 
			{
			    if($(this).text() == item.series.label)
			    {
				if(pageVars.legendHighLights[item.series.label]>0)
				    {
					$(this).css({'background-color': 'lightblue'});
				    }
				else
				    {
					$(this).css({'background-color': 'white'});
				    }
			    }
			});
// $("#clickdata").text("You clicked point " + item.dataIndex + " in " + item.series.label + ".");



		    }
		});

	    // min max and avg
	    pageVars.graphs[pageVars.workingGraph].selectedData = [];
	    pageVars.calculateSelected();
	    
	} // initialbound
}

function getYRanges()
{
	return pageVars.graphs[pageVars.workingGraph].yRanges;
}
function getXRanges()
{
	return pageVars.graphs[pageVars.workingGraph].xRanges;
}
function getYMinMax()
{
	return pageVars.graphs[pageVars.workingGraph].yMinMax;
}
function getXMinMax()
{
	return pageVars.graphs[pageVars.workingGraph].xMinMax;
}
function resetRanges()
{
	
	$.each(pageVars.graphs[pageVars.workingGraph].xRanges, function(index, item){
		 pageVars.graphs[pageVars.workingGraph].xRanges[index] = { to:  null, from: null };
		 pageVars.graphs[pageVars.workingGraph].xMinMax[index] = { min:  null, max: null };
	});
	$.each(pageVars.graphs[pageVars.workingGraph].yRanges, function(index, item){
		 pageVars.graphs[pageVars.workingGraph].yRanges[index] = { to:  null, from: null };
		 pageVars.graphs[pageVars.workingGraph].yMinMax[index] = { min:  null, max: null };
	});
	
}
function setRanges(ranges)
{
	var tmpYRanges = [];
	var tmpYMinMax = [];
	var tmpXRanges = [];
	var tmpXMinMax = [];

	// bygg upp yaxlarna
	var plotAxes = pageVars.graphs[pageVars.workingGraph].plot.getAxes();

	$.each(plotAxes,function(key, item){
		if(key.match(/y/)) 
		{	
			tmpYRanges.push({});
			tmpYMinMax.push({});
		}	
		else if(key.match(/x/)) 
		{	
			tmpXRanges.push({from: item.min,to: item.max});
			tmpXMinMax.push({min: item.min,max: item.max});
		}	
	});
	// om de inte r en zoom s r ranges null
	if(ranges != null)
	{
		// clamp the zooming to prevent eternal zoom
		$.each(ranges,function(key, item){
			if(item.to - item.from < 0.00001) { item.to = item.from + 0.00001; }
		     	if(key.match(/^y/)) 
			{
				var index;
				if(key.match(/yaxis/))	{ index=0;}
				else { index = key.match(/y(\d)/)[1]-1; }
				tmpYRanges[index] = { from: item.from, to: item.to };
				tmpYMinMax[index] = { min: item.from, max: item.to };
			}
			else if(key.match(/^x/))
			{
				var index;
				if(key.match(/xaxis/))	{ index=0;}
				else { index = key.match(/x(\d)/)[1]-1; }
				tmpXRanges[index] = { from: item.from, to: item.to };
				tmpXMinMax[index] = { min: item.from, max: item.to };
			}
		});
	}
	pageVars.graphs[pageVars.workingGraph].yRanges = tmpYRanges;
	pageVars.graphs[pageVars.workingGraph].xRanges = tmpXRanges;
	pageVars.graphs[pageVars.workingGraph].yMinMax = tmpYMinMax;
	pageVars.graphs[pageVars.workingGraph].xMinMax = tmpXMinMax;
}
function drawOverview()
{
     // used for indexing labels in labelformatter
    pageVars.graphs[pageVars.workingGraph].label_index =0;

	var overviewOptions = {
			        lines: { show: true },
			        points: { show: false },
				xaxis: {  ticks: [],mode: "time" },
				yaxis: {  ticks: [] },
				y2axis: {  ticks: [] },
				selection: { mode: "xy" },
			        legend: {	noColumns: 1,
						show: true , 
						labelFormatter: function(label, series) 
						{

						    var i =   pageVars.graphs[pageVars.workingGraph].label_index++;
						    var yaxisInfo = "";
						    if(pageVars.gotYaxisConf(label)) { yaxisInfo = " (y2)"; }
						    var res = '<span style="white-space: nowrap"';
						    if(pageVars.graphType == "teSummary")
						    {
							res += 'id="'+label+'" class="serieInfo"';
						    }
							if(pageVars.graphType == "default")
						    {
						   
							 }
						    if(pageVars.graphType == "pmr")
						    {
							res += 'id="'+label+'" class="formula"';
						    }
						    res += '>'+
						    '<input type="checkbox" name="' + (i) +
						    '" checked="checked" id="id' +(i) + '">'+label+yaxisInfo+
						    '</span>';
						    window[pageVars.workingGraph][i]['id'] = "id"+i;
						    return res;
						},

						container: $("#"+pageVars.legendDiv)
				},
				grid:  {backgroundColor: { colors: ["#CCC", "#FFF"] }}

	};  // overview options

	overview = $.plot($("#"+pageVars.overviewDiv), pageVars.getDataSerie(), overviewOptions);
	$("#"+pageVars.legendDiv).find("input").click( function () {
		setWorkingGraph(this);
		info("Redrawing graph with new set of dataseries");
		setTimeout(function() { plotAccordingToChoices(); info(""); },10);
	
	});

	$("span.formula").hover(function () {
		setWorkingGraph(this);
		var id = $(this).attr("id");
		var html = '<div id="tooltip">';
		var lastpart = id.match(/_(.*)$/)[1];

		var hit = "";
		
		$.each(formulas, function(index, value) { 
			if(index == id || index == lastpart)
			     {
				 hit =  formulas[index];
				 // break each
				 return false;
			     }
		     });
		if(hit == "")
		    {
			if(lastpart != id)
			    {
				hit = lastpart;
			    }
			else
			    {
				hit = id;
			    }
		    }
		html += hit+"<hr>";
		html += pageVars.minmaxavg(id)+"<br>";
		html += '</div>';
		$(this).append(html);

	    },
	    function() {
		$("#tooltip").remove();
	    }
	    );

	$(".serieInfo").hover(function () {

		var id = $(this).attr("id");
		var html = '<div id="tooltip">';
	
		html += pageVars.minmaxavg(id)+"<br>";
		html += '</div>';
		$(this).append(html);

	    },
	    function() {
		$("#tooltip").remove();
	    }
	    );

}
function drawOptionsDiv()
{
	// already set in html?
	$("#"+pageVars.optionsDiv).attr('style','display:none;float:left;border:1px solid #aaa;padding:5px;');

	var html = '<input type="submit" id="zoomButton" onclick="resetZoom(this);return false;" value="Zoom out"><br>';
	html += '<input type="submit" id="selector" onclick="invertSelection(this);return false;" value="Invert Selection">'; 
	html += '<input type="submit" id="selectAll" onclick="selectAll(this);return false;" value="Select All">';
	html += '<input type="submit" id="deselectAll" onclick="deselectAll(this);return false;" value="Deselect All">';
	//html += '<fieldset><legend>Resolution</legend>';

	if(pageVars.graphType=="teSummary")
	    {
		html += '<br>';
		html += '<input type="radio" id="resolution_'+pageVars.workingGraph+'_hour" name="resolution_'+pageVars.workingGraph+'" value="hour" checked="checked"> per Hour<br>';
		html += '<input type="radio" id="resolution_'+pageVars.workingGraph+'_rop" name="resolution_'+pageVars.workingGraph+'" value="rop"> per ROP';
	    }
	html += '<br><input type="text" id="regExpInput"><input type="button" onclick="filterDataSeries();" value="Filter">'; 
 
	//html += '<fieldset>';
	

	$("#"+pageVars.optionsDiv).html(html);

	// this code will be called when user changes the resolution.
	// trigger a redraw of graph with new resolution
	$("input[name='resolution_"+pageVars.workingGraph+"']").change(function(){
		setWorkingGraph(this);
		info("Changing resolution and redrawing graph");
	
		// reset zoom, otherwise its likely we will look in the wrong section of graph anyway
		resetRanges();	
		//pageVars.graphs[pageVars.workingGraph].xaxis = { min:  null, max: null };
		//pageVars.graphs[pageVars.workingGraph].yaxis = { min:  null, max: null };
	
		if($(this).val() == "rop")
		{
			pageVars.setResolutionRop();
		}
		else if($(this).val() == "hour")
		{		
			pageVars.setResolutionHour();
		}
			// settimeout just to get the info box to work :(
		setTimeout(function () { drawOverview();plotAccordingToChoices(); info(""); } ,10);
	});

	if(pageVars.reportName in  pageVars.graphOptions)
	    {	
		var allAxes = pageVars.graphOptions[pageVars.reportName]['axes'];
		var html = "<hr>Axis control:<br>";
		html += '<input type="checkbox" class="axiscontrol" id="axis1" checked="checked"> y1:Default';
		$("#"+pageVars.optionsDiv).append(html);
		for( var key in allAxes) { 
		    if(typeof allAxes[key] != "function") 
			{
	
			    var desc = pageVars.graphOptions[pageVars.reportName]['axes'][key]['description'];
			    html = '<input type="checkbox" class="axiscontrol" id="axis'+key+'" checked="checked"> y'+key+":"+desc;
			   if( key % 3 == 0) { html += '<br>'; }
			    $("#"+pageVars.optionsDiv).append(html);
			}
		}

		$(".axiscontrol").click(function (){
			var turnon = $(this).attr('checked');
			var id = $(this).attr('id').match(/axis(\d)/)[1];
			$("#"+pageVars.legendDiv).find(".formula").each(function ()  {
				var obj = this;
				var key = $(obj).attr("id");
				var m = key.match(/\(y(\d)/);
				if(m && m[1] == id)
				    {
					if(turnon)   { 	$(this).find("input").attr("checked","checked"); }
					else { $(this).find("input").attr("checked","");}
					
				    }
				else if(!m && id== 1)
				    {
					if(turnon) { $(this).find("input").attr("checked","checked");}
					else {	$(this).find("input").attr("checked",""); }
				    }
				
			    }); // find each
			plotAccordingToChoices();
		    }); //click

	    }
}


// *********************************
// getBoundingBoxForAxis(plot,axis)
// Ge positionerna fr "boxen" som en axel upptar

function getBoundingBoxForAxis(plot, axis) {

        var left = axis.box.left, top = axis.box.top,
       	    right = left + axis.box.width, bottom = top + axis.box.height;
	
       	// some ticks may stick out, enlarge the box to encompass all ticks
        var cls = axis.direction + axis.n + 'Axis';
       	plot.getPlaceholder().find('.' + cls + ' .tickLabel').each(function () {
     	   	var pos = $(this).position();
       		left = Math.min(pos.left, left);
       		top = Math.min(pos.top, top);
       		right = Math.max(Math.round(pos.left) + $(this).outerWidth(), right);
       		bottom = Math.max(Math.round(pos.top) + $(this).outerHeight(), bottom);
       	});
       
      	return { left: left, top: top, width: right - left, height: bottom - top };
}


function drawYaxisLabels(plot)
{
	var allAxes =  (pageVars.reportName in pageVars.graphOptions?pageVars.graphOptions[pageVars.reportName]['axes']:null);

	if(allAxes)
	{
		var axisLabel = "";
	        $.each(plot.getYAxes(), function (i, axis) {

			if(axis.used)	
			{
				if(axis.n in allAxes)
				{
					axisLabel = allAxes[axis.n].description;
				}

	        		var box = getBoundingBoxForAxis(plot, axis);
				$('<div class="axisTarget" style="position:absolute;left:' + box.left + 'px;top:' + parseInt(box.top-40,10) + 'px;width:' + box.width +  'px;height:' + box.height + 'px;">'+axisLabel+'</div>')   
				//.css({ backgroundColor: "yellow", opacity:'0.5' })
            			.appendTo(plot.getPlaceholder());
			}
		});
	}
}

// *********************************
// setWorkingGraph(object name)
// setWorkingGraph(string name)
function setWorkingGraph(htmlObj)
{
	if(!htmlObj) 
	{ 
		alert("ERROR: no object provided to setWorkingGraph()"); 
		return false;
	}
	if(!(typeof htmlObj === "object" || typeof htmlObj === "string")) { alert("ERROR: Unsupported use of setCWorkingGraph(). Type: "+typeof htmlObj); }
	if(typeof htmlObj === "string")
	{
		pageVars.setWorkingGraph(htmlObj);
		pageVars.infoOffset = $(window).scrollTop();
	}
	else
	{ // typeof obj
		var wrapperId = "";
		$(htmlObj).parents().each(function () 
		{ 
			var id = $(this).attr("id");
			if(id.match("wrapper_")) { wrapperId = id; }//TBD : Break?}
		});
		
		if(wrapperId === "") { alert("ERROR: Could not find a wrapper parent"); return false;}
		pageVars.setWorkingGraph(wrapperId.match("wrapper_(.*)")[1]);
		
		pageVars.infoOffset = $(window).scrollTop();
	
	}
}

function initWorkingGraph()
{
	if(!(pageVars.workingGraph in pageVars.graphs))
	{ 	// its new and uninitialized
		pageVars.graphs[pageVars.workingGraph] = [];
		pageVars.graphs[pageVars.workingGraph].initialbound = 0;
		if(pageVars.graphType == "teSummary")
		{
			pageVars.graphs[pageVars.workingGraph].resolution = "hour";
		}
		else
		{
			pageVars.graphs[pageVars.workingGraph].resolution = "rop";
		}
		// zoom
		pageVars.graphs[pageVars.workingGraph].xaxis = { min:  null, max: null };
		pageVars.graphs[pageVars.workingGraph].yaxis = { min:  null, max: null };
	
		if(pageVars.graphType == "teSummary")
		{
		    // add description for lost traces
		    var description = '<span style="background-color:#FF9999;border:1px solid;margin-left:70px">&nbsp;&nbsp;</span> A bar with this color means there were lost traces';
		    $("#"+pageVars.wrapperDiv).append(description);
		}

		// change wrapperdiv look?
		$("#"+pageVars.wrapperDiv).css({border:'1px solid',padding:'40px 5px 5px 5px'});
			
		// insert all tags
		insertDivTags();
		
		drawOptionsDiv();
		return true;
	}
	else 
	{ 
		// console.log(pageVars.workingGraph+" already initialized"); 
		return false;
	}
}

function createReport()
{

    var page = "<html>";  
    var tmpArr = $("html").html().split('\n');
    $.each(tmpArr,function(index,value)
	   {
	       if(value.match(/<title/)) 
	       {  // insert javascript
		   var scripts = value+'\n<script language=javascript type="text/javascript">\n';
		   scripts += 'if (navigator.appName=="Microsoft Internet Explorer") {  alert("Hi, This report will look weird in IE < 8. Please use other browser to view this report!"); }';
		   
		   
		   scripts += 'function hidediv(div) { if (document.getElementById) { document.getElementById(div).style.display = "none"; }}\n'; 
		   scripts += 'function showdiv(div) {if (document.getElementById) { document.getElementById(div).style.display = "block";}}\n';
		   scripts += 'function togglediv(div) {if (document.getElementById) { if(document.getElementById(div).style.display == "block"){ document.getElementById(div).style.display = "none"; } else { document.getElementById(div).style.display = "block";} }}\n';
		   scripts += '</script>\n';
		   
		   page += scripts;
		   return true;
	       } 
	       
	       //<link rel="stylesheet" type="text/css" href="style.css">
	       if(value.match(/<link rel=\"stylesheet\"/))
		{
		    // assume that its name is style.css
		    page += readCSSFile("style.css");
		    return true;
		}

	       if(value.match(/<script/)) { return true; }
	       if(value.match(/^\s*$/)) { return true; }
	       if(value.match(/<div id="infobox"/)) { return true; }
	       
	       // Links
	       if(value.match(/<li><a /))
		{
		    // formulas etc

		    if(value.match(/Create static HTML/)) { return true; }
		    var match = value.match(/<a .*href=\"(.+)\".*>\s*([^<]+)<\/a>/);
		    var newLink = '&nbsp;<a href="javascript:void(0);" onclick="togglediv(\''+match[1]+'\');">'+match[2]+'</a>';
		    newLink += "\n"+convertFileToDiv(match[1]);
		    page += value.replace(/<a .*<\/a>/,newLink);
		    return true;
		    
		}
	       // keep theese links
	       if(value.match(/<tr><th><a/)) { return true; }
	       
	       // remove all remaining links
	       if(value.match(/<a /)) 
		   { 
		       page += value.replace(/<a [^>]*>[^<]*<\/a>/g,"")+"\n";
		       return true;
		   }
	        // handle options
	       if(value.match(/<div id=\"options_/)) 
		   { 
		       return true;
		   }

	        // handle legend
	       if(value.match(/<div id=\"legend_/)) 
		   { 
		       //<input name="0" checked="checked" id="id0" type="checkbox">
		       page += value.replace(/<input name=\"\d+\" checked=\"\w+\" id=\"\w+\" type=\"checkbox\">/g,"");
		       return true;
		   }

	       // handle canvas
	       if(value.match(/<div id=\"(graph|overview)_(\w+)\"/)) 
		   {
		       var gTag = value.match(/<div id=\"(graph|overview)_(\w+)\"/);
		       var canvas = $("#"+gTag[1]+"_"+gTag[2]+" > canvas")[0];
		       var canvasdata = canvas.toDataURL("image/png");
		       canvasdata = canvasdata.replace("image/png", "image/octet-stream");
		       var newDiv = value.replace(/<canvas.*<\/canvas>.*<canvas.*<\/canvas>/,"<img src=\""+canvasdata+"\">");
		       page += newDiv;
		       return true;

		   } 
	       
	       page += value+"\n";
	   });
    page += "</html>";
 
    var now = new Date();

    var staticPage =  window.open('','PmSummary - Static ('+now.toLocaleTimeString()+')');
    
    staticPage.document.open();
    staticPage.document.write(page);
    staticPage.document.close();

}

function convertFileToDiv(file)
{
    // create the div and return. The get function is async and will do its work when the file is retrieved

    var div = '<div id="'+file+'" style="display:none;">\n';
    var txt = $.ajax({
		url: file,
		    async: false
	}).responseText;
   
    div += nl2br($('<div/>').text(txt).html()); 
    div += "</div>";
    return div;
}
function readCSSFile(file)
{

    var css = '<style type="text/css">';

    css += $.ajax({
		url: file,
		    async: false
		}).responseText;

    css += '</style>';
    return css;
}

function nl2br (str, is_xhtml) {   

return (str + '').replace(/([^>\r\n]?)(\r\n|\n\r|\r|\n)/g, '$1<br>$2');
}
