package abortIfAlredyRunning;
use strict;

sub abortIfAlredyRunning
{
    my $grepName = shift @_;
    my $stream   = shift @_;
    my $userName = shift @_;
    my $executing;
    if ( defined $userName )
    {
        $executing =
            `ps -ef | grep $userName | grep $grepName | grep -v 'grep'`;
    }
    else
    {
        $executing = `ps -ef | grep $grepName | grep -v 'grep'`;
    }
    $executing =~ s/^\s*(.*)\s*$/$1/;

    my @items = split( /\n/, $executing );
    my %pids;
    for my $item (@items)
    {
        $item =~ s/^\s*(.*)\s*$/$1/;
        my @line = split( /\s+/, $item );
        $pids{ $line[1] } = $line[2];
    }

    if ( defined( $pids{$$} ) )
    {
        my $pid = $$;
        while ( defined( $pids{$pid} ) )
        {
            $pid = delete $pids{$pid};
        }
        if ( scalar(%pids) > 0 )
        {
            print $stream "$grepName Already executing... $$\n";
            for my $key ( keys %pids )
            {
                print $stream "$key = $pids{$key}\n";
            }
            print $stream "result=\n'$executing'\n";
            return 1;
        }
    }
    else
    {
        print $stream "$grepName could not determine own pid... $$\n";
        for my $key ( keys %pids )
        {
            print $stream "$key = $pids{$key}\n";
        }
        print $stream "result=\n'$executing'\n";
        return 1;
    }
    return 0;
}

1;
