package attribFilter;
use strict;
sub attribFilter::new() {
    my $class = shift;
    my $conf = shift;
    my $types = shift;
    my %self = @_;
    foreach my $type ( @{$types} )
    {
        $self{TYPE} = $type;
        $type->{required}->{IMSI} = 1;
        $type->{required}->{cellId} = 1;
    }
    return bless \%self;
}

sub attribFilter::parser
{
    my $self = shift;
    my $type = shift;
    my $conf = shift;
    if ( defined $conf->{filterImsi} || defined $conf->{filterCell} || defined $conf->{excludeImsi} || defined $conf->{excludeCell} )
    {
        if( defined $conf->{filter_or} ){

            if( defined $type->{obj}->{IMSI} && $type->{obj}->{IMSI} =~ /$conf->{filterImsi}/ ){
                return undef;
            }
            elsif( defined $type->{obj}->{cellId} && $type->{obj}->{cellId} =~ /$conf->{filterCell}/ ){
                return undef;
            }
            else{
                return 1,
            }
        }
        elsif ( defined $conf->{filterImsi} && !defined $type->{obj}->{IMSI} )
        {
            return 1;
        }
        elsif ( defined $conf->{filterCell} && !defined $type->{obj}->{cellId} )
        {
            return 1;
        }
        elsif (defined $conf->{excludeImsi} && defined $type->{obj}->{IMSI} && $type->{obj}->{IMSI} =~ /$conf->{excludeImsi}/)
        {
            return 1;
        }
        elsif (defined $conf->{excludeCell} && defined $type->{obj}->{cellId} && $type->{obj}->{cellId} =~ /$conf->{excludeCell}/)
        {
            return 1;
        }
        elsif ( defined $conf->{filterImsi} && defined $type->{obj}->{IMSI} && $type->{obj}->{IMSI} !~ /$conf->{filterImsi}/)
        {
            return 1;
        }
        elsif ( defined $conf->{filterCell} && defined $type->{obj}->{cellId} && $type->{obj}->{cellId} !~ /$conf->{filterCell}/)
        {
            return 1;
        }
    }
    return undef;
}

sub attribFilter::printer(){
    my $self = shift;
    my $conf = shift;
    my $printer = shift;
    my $modulePrinter = shift;
    return ();
}


1;
