package csv;
use strict;
use Data::Dumper;

sub init
{
    my (%arg) = @_;
    open my $fh, '>', $arg{filename};
    return { file => $fh, level => 0 };
}

sub start
{
    my (%arg) = @_;
    $arg{handle}->{level}++;
    $arg{handle}->{string} = "" if $arg{handle}->{level} == 2;
}

sub data
{
    my (%arg) = @_;
    $arg{handle}->{string} .= $arg{output};
}

sub end
{
    my (%arg) = @_;
    $arg{handle}->{string} .= $arg{separator} if $arg{handle}->{level} == 3;
    $arg{handle}->{level}--;
    print { $arg{handle}->{file} } substr( $arg{handle}->{string}, 0, -1 )
        . "\n"
        if $arg{handle}->{level} == 1;
}

sub header { }

sub final
{
    my (%arg) = @_;
    close $arg{handle}->{file};
}

sub read
{
    my (%arg) = @_;
    open CSV, '<', $arg{filename};
    &{ $arg{start} }( name => 'document', ctx => $arg{ctx} );
    my @colnames;
    if ( defined $arg{colnames} )
    {
        my $line = <CSV>;
        chomp $line;
        @colnames = split $arg{separator}, $line;
    }
    while ( my $line = <CSV> )
    {
        chomp $line;
        my @line = split $arg{separator}, $line;
        my $name;
        &{ $arg{start} }(
                 name => ( $name = defined $arg{rownames} ? $line[0] : 'row' ),
                 ctx => $arg{ctx} );
        for ( ( defined $arg{rownames} ? 1 : 0 ) .. @line - 1 )
        {
            &{ $arg{start} }(
                       name => defined $arg{colnames} ? $colnames[$_] : 'data',
                       ctx => $arg{ctx} );
            &{ $arg{data} }( data => $line[$_], ctx => $arg{ctx} );
            &{ $arg{end} }(
                       name => defined $arg{colnames} ? $colnames[$_] : 'data',
                       ctx => $arg{ctx} );
        }
        &{ $arg{end} }( name => $name, ctx => $arg{ctx} );
    }
    &{ $arg{end} }( name => 'root', ctx => $arg{ctx} );
    close CSV;
}

sub events
{
    return ( \&init, \&start, \&data, \&end, \&final );
}

1;
