from amoshell import Amos
from amoshell import Open_Amos

node_ip = 'INSERT IP ADDRESS OF NODE'

# Original Version
# Calls on moshell() with IP of node, a set of commands for it to run, and **kwargs which could/should include username & password
# moshell() returns returncode, output and error
# Quits when done and prints the results.
# Amos() needs the bin_path to moshell declared. 
# For arg#2 commands, a single command should be in the format 'cmd' and multiple commands 'cmd1;cmd2;cmd3'. 

print("MOSHELL DEMO RUN")
mo = Amos(bin_path='/app/moshell/latest/moshell')
rval, out, err = mo.moshell(node_ip,'lt all; alt', username='expert', password='expert')
if rval:
    print(err)
else:
    print(out)

# New Open Session Version
# Opens a session for Open_Amos with IP of node, optional set of commands for it to run, and **kwargs which could/should include username & password
# Further commands can be entered with Open_Amos.send(cmd) which will return the output of the command and can be shutdown with Open_Amos.quit()

print("MOSHELL OPEN SESSION DEMO RUN")
mo = Open_Amos(node_ip,['lt all','alt'], bin_path='/app/moshell/latest/moshell', username='expert', password='expert')
cmd = ['get ManagedElement=1', 'alt']
# saves the output in log
for c in cmd: 
    print("SENDING COMMAND: "+c)
    cmd_output = mo.send(c)
    print(cmd_output)
print(mo.quit())

# Mobatch
# Calls on mobatch() with a list of IP of nodes or a path to a sitefile, a set of mobatch commands and **kwargs which could/should include username & password
# mobatch() returns a list with results.
# Quits when done and prints the results.
# Amos() needs the bin_path to mobatch declared and optional argument with the amount of parallel sessions(defaults to 10)

print("MOBATCH DEMO RUN")
mo = Amos(bin_path='/app/moshell/latest/moshell')
results = mo.mobatch([node_ip], 'lt all; get security', ip_database='/tmp/ipdb.dat', corba_class=5 )
for r in results:
    node, rval, logfile = r
    if not rval:
        print("node %s results found in log %s" % (node, logfile))

