######################################################################################
#                                                                                    #
#  Ericsson AB 2010    - All Rights Reserved                                        #
#                                                                                    #
# The copyright to the computer program(s) herein is the property   of Ericsson AB,  #
# Sweden. The programs may be used and/or copied only with the written permission    #
# from Ericsson AB or in accordance with the terms and  conditions stipulated in the #
# agreement/contract under which the program(s) have been supplied.                  #
#                                                                                    #
######################################################################################

BEGIN{ 
	TZ=""
	lscom="ls -l /etc/localtime 2>&1"
	while (lscom |& getline)
	{
		if ($1~/^-r/ && $NF=="/etc/localtime") ok=1
	}
	close(lscom)
	if (ok==1) 
	{
		#currently does not support when /etc/localtime is a soft link, only hard link
		printf("INFO: TZ is unknown. Looking up from /etc/localtime and /usr/share/zoneinfo... ")
		md5="md5sum /etc/localtime 2>&1" 
		while (md5 |& getline) 
		{ 
			if (NF==2 && $2=="/etc/localtime") md5s=$1
		}
		close(md5)
		if(md5s!="") 
		{
			f="find /usr/share/zoneinfo -type f -exec md5sum \\{\\} \\;"
			while (f|&getline) 
			{ 
				if ($1==md5s && $2!="") 
				{ 
					l=split($2,a,"/")
					TZ=a[l-1]"/"a[l]
				}
			}
			close(f)
		}
		if (TZ=="") print "Not found."
		else print TZ
	}
	print TZ > tzfile
}
