# v 1.0  26/02/2024 P. Ek   Initial Version
# v 1.1  29/02/2024 P. Ek   Fix for wrongly printed attributes. Fix for numbering of structs. Fix for struct ordering.
# v 1.2  01/03/2024 F. Magnusson Put double-quotes around attribute/struct value in certain cases, see new function "correct_value". Removed printing of "is struct sequence"
# v 1.3  01/03/2024 P. Ek	Removing commented and dead code.
# v 1.4  01/03/2024 P. Ek	Added IGNORECASE=1 in the beginning to ignore case in comparisons.
BEGIN {
	IGNORECASE=1

	#Format mos[<MO LDN>]=1
	delete mos;
	#Format attr_list[<MO LDN>][<attribute>]=<value>
	delete attr_list;
	#Format tmp_attrs_list[<attribute>]=<value>
	delete tmp_attr_list;
	#Format struct_attrs[<MO LDN>][<attribute>][<count>][<key>]=<value>
	delete struct_attrs;
	#Format tmp_struct_attrs[<attribute>][<count>][<key>]=<value>
	delete tmp_struct_attrs;
	delete stack;
	
	#Format ref_list[ref][count][key]=value1@@@value2@@@...
	delete ref_list;
	#Format ref_cnt[ref]=count
	delete ref_cnt;
	#Format seqences["moc,attribute"]=1, or seqences["moc,attribute"]=MocNS.StructObject
	delete sequences;
	#Format structs["moc,attribute"]=MocNS.StructObject
	delete structs;
	#Format structSequences[MocNS.StructObject,member]=1
	delete structSequences;

	curr_ldn_str="";
	reply_found=0;
	elemname="";
	elemId="";
	hasElemId=0;
	currentStruct="";
	is_multiline=0;
	multiline_elem="";
	value_buf="";
	if (loglevel<0) loglevel=0;
	if (ARGC == 1) {
		print "Missing NETCONF file.";
		exit 1;
	} else if (ARGC == 2) {
		print "Missing momd file.";
		exit 1;
	}
	file = ARGV[1];
	momdfile = ARGV[2]

	parse_momd();
	debug(1, "loglevel="loglevel);
	while ((getline line < file) > 0) {
		findStartOfReply(line);
		if (match(line, /<(.*)>(.*)</, m)) {
			if (hasElemId==0 && m[1] ~ elemId) {
				hasElemId=1;
				debug(2, "matched elemId "elemId);
				stack[length(stack)]=elemname"="m[2];
				if (length(curr_ldn_str) > 0) curr_ldn_str=curr_ldn_str",";
				curr_ldn_str=curr_ldn_str""stack[length(stack)];
				mos[curr_ldn_str]=1;
				debug(2, "current ldn = "curr_ldn_str);
				add_simple_attribute(m[1], m[2]);
				update_struct_refs(curr_ldn_str);

			} else if (length(currentStruct) > 0) {
				add_struct_attribute(currentStruct, m[1], m[2]);
			} else {
				add_simple_attribute(m[1], m[2]);
			}
			debug(1, m[1]" "m[2]); 
		} else if (match(line, "</("currentStruct")>", m)) {
			currentStruct="";
			debug(2, "end of struct "m[1]);
		} else if (is_multiline==1 && match(line, "(.*)</"multiline_elem">", m)) {
			debug(1, "End of multiline element "multiline_elem);
			add_simple_attribute(multline_elem,value_buf""m[1]);
			is_multiline=0;
			multiline_elem="";
			value_buf=0;
		} else if (match(line, /<\/(.*)>/, m)) {
			if (m[0] ~ /rpc-reply/) debug(1, "End of reply");
			else {
				gsub(",?"stack[length(stack)], "", curr_ldn_str);
				debug(3, "deleting element "stack[length(stack)]);
				delete stack[length(stack)];
				debug(1, "end of element "m[0]);
			}
		}
		else if (match(line, /<(.+)\/>/, m)){
			add_simple_attribute(m[1],"true");
		}
		else if (match(line, /<(.*)>(.+)/, m)) {
			#An element starting with "<name>text" is considered a multi-line element. Read until
			#receiving a termination tag.
			debug(1, "Start of multiline elem "m[1]);
			is_multiline=1;
			multiline_elem=m[1];
			value_buf=m[2]"\\n";
		} else if(match(line, /<(.*)>/, m)) {
			debug(1, "Start of "m[1]);
			if (match(m[1], /(\S+)\s*struct=(.*)/, n)) {
				debug(3, "struct elem: "n[1]);
				debug(2, "Struct "n[2]);
				currentStruct=n[1];
				add_struct(currentStruct);
			} else {
				#Find elem name
				match(m[1], /([^ ]+)/, n);
				elemname=n[1];
				elemId=tolower(substr(n[1],1,1))""substr(n[1],2)"Id";
				debug(2, n[1]" elemId="elemId);
				hasElemId=0;
				stack[length(stack)+1]=elemname"=";
				debug(2, "stack[length(stack)+1]="stack[length(stack)]);
				delete tmp_attr_list; #Remove rubbish from the hello message. 
			}
		} else if (is_multiline == 1){
			value_buf=value_buf""line"\\n";
		} 
	}
	
	if (reply_found == 0) {
		debug(0, "No <rpc-reply> in file");
		exit 2;
	}
	delete attr_list[""];
	size = asorti(attr_list, sorted);
	for (i=1; i<=size; i++) {
		debug(1, "sorted[i]="sorted[i]);
	}

	print_mos();

}
function correct_value(value)
{
	#put double-quotes around value if:
	# - a LDN, eg moRef/sequence:moRef
	# - contains a space sign, eg string/sequence:string
	# - empty value or just contains blank spaces
	# - ends with a equal sign
	if (value~/^(ManagedElement=[^,]+,.*[^"]|[^"].* .*[^"]|[ \t]*|[^"].*=)$/) value=sprintf("\"%s\"",value)
	return value
}
function add_simple_attribute(attribute,value,	idx) {
	value=correct_value(value)
	#current attribute is the MO Id
	if (hasElemId == 1 && length(tmp_attr_list) > 0) {
		for(idx in tmp_attr_list) {
			attr_list[curr_ldn_str][idx]=tmp_attr_list[idx];
		}
		attr_list[curr_ldn_str][attribute] = value;
		delete tmp_attr_list;
	#MO id is not yet red.
	} else if (hasElemId == 0) {
		if (attribute in tmp_attr_list) {
			tmp_attr_list[attribute]=tmp_attr_list[attribute]"@@@"value;
		} else {
			tmp_attr_list[attribute]=value;
		}
	#MO id is already red. Add the attribute to the attr_list array instead.
	} else {
		if (attribute in attr_list[curr_ldn_str]) {
			attr_list[curr_ldn_str][attribute]=attr_list[curr_ldn_str][attribute]"@@@"value;
		} else {
			attr_list[curr_ldn_str][attribute]=value;
		}
	}
}

function findStartOfReply(line) {
	if (reply_found == 0) {
		if (line ~ /<rpc-reply.*>/) {
			reply_found=1;
		}
	}
}

function add_struct(attribute) {
	#Format struct_attrs[<MO LDN>][<attribute>][<count>][<key>]=<value>
	#MO Id is known. Add to struct_attrs.
	if (hasElemId == 1) {
		#print "curr_ldn_str="curr_ldn_str;
		if (!(curr_ldn_str in struct_attrs)) struct_attrs[curr_ldn_str]
		if (attribute in struct_attrs[curr_ldn_str]) {
			#print "add count to "curr_ldn_str" "attribute;
			struct_attrs[curr_ldn_str][attribute][length(struct_attrs[curr_ldn_str][attribute])+1];
		} else {
			struct_attrs[curr_ldn_str][attribute][1];
		}
	#MO Id not yet known. Add to tmp_struct_attrs
	} else {
		if (attribute in tmp_struct_attrs) {
			tmp_struct_attrs[attribute][length(tmp_struct_attrs[attribute])+1];
		} else {
			tmp_struct_attrs[attribute][1]
		}
	}
}

function update_struct_refs(ldn,	a) {
	struct_attrs[ldn];
	for (a in tmp_struct_attrs) {
		for (c in tmp_struct_attrs[a]) {
			for (k in tmp_struct_attrs[a][c]) {
				struct_attrs[ldn][a][c][k]=tmp_struct_attrs[a][c][k];
			}
		}
	}
	delete tmp_struct_attrs;
}

function add_struct_attribute(attribute,key,value,	tmp_val,cnt) {
	value=correct_value(value)
	if (hasElemId == 1) {
		cnt=length(struct_attrs[curr_ldn_str][attribute]);
		if (key in struct_attrs[curr_ldn_str][attribute][cnt]){
			tmp_val=struct_attrs[curr_ldn_str][attribute][cnt][key];
			struct_attrs[curr_ldn_str][attribute][cnt][key]=tmp_val"@@@"value;
		} else {
			struct_attrs[curr_ldn_str][attribute][cnt][key]=value;
		}
	} else {
		cnt=length(tmp_struct_attrs[attribute]);
		if (key in tmp_struct_attrs[attribute][cnt]){
			tmp_val=tmp_struct_attrs[attribute][cnt][key];
			tmp_struct_attrs[attribute][cnt][key]=tmp_val"@@@"value;
		} else {
			tmp_struct_attrs[attribute][cnt][key]=value;
		}
	}
}

function debug(level,data) {
	if (loglevel >= level) print "DEBUG"level": "data;
}

function print_mos(	mos_sort,moi,attrsrt,attri,q,srct_attrsrt,m,is_struct_seq,type,cnt,key,keysrt) {
	asorti(mos,mos_sort);
	for (moi in mos_sort) {
		print mos_sort[moi];
		asorti(attr_list[mos_sort[moi]],attrsrt);
		for (attri in attrsrt) {
			#print "before spam: attri="attri;
			if (attr_list[mos_sort[moi]][attrsrt[attri]] ~ "ref:") q=1;#Do nothing, 
			else print_attribute(mos_sort[moi], attrsrt[attri], attr_list[mos_sort[moi]][attrsrt[attri]]);
		}
		#Print structs.
		asorti(struct_attrs[mos_sort[moi]],srct_attrsrt)
		match(mos_sort[moi], /.*,([^=]+).+$/, m);
		debug(3, "MOC="m[1]);
		
		for (attri in srct_attrsrt) {
			type = structs[m[1]","srct_attrsrt[attri]];
			#print "type="type", length(type)="length(type);
			if (length(type) > 0) {
				is_struct_seq=0;
				#print "MOC="m[1]", attribute="srct_attrsrt[attri]", classification struct";
			} else {
				type = sequences[m[1]","srct_attrsrt[attri]];
				#print "type="type", length(type)="length(type);
				if (length(type) == 0) {
					is_struct_seq=0;
					#print "MOC="m[1]", attribute="srct_attrsrt[attri]", no classification";
				} else {
					is_struct_seq=1
					#print "MOC="m[1]", attribute="srct_attrsrt[attri]", classification sequence:struct";
				}
			}
			for (cnt in struct_attrs[mos_sort[moi]][srct_attrsrt[attri]]) {
				if (is_struct_seq == 1) {
					print "  "srct_attrsrt[attri]"[@"cnt"]";
				} else {
					print "  "srct_attrsrt[attri];
				}
				asorti(struct_attrs[mos_sort[moi]][srct_attrsrt[attri]][cnt], keysrt)
				for (key in keysrt) {
					print_struct_attribute(type, keysrt[key], struct_attrs[mos_sort[moi]][srct_attrsrt[attri]][cnt][keysrt[key]])
				}
				#for (key in struct_attrs[mos_sort[moi]][srct_attrsrt[attri]][cnt]) {
				#	print_struct_attribute(type, key, struct_attrs[mos_sort[moi]][srct_attrsrt[attri]][cnt][key]);
				#}
			}
		}
	}
}

function print_ref(ref,	s_elem,keyi,m,keysize,srtkey) {
	#print "calling print_ref with ref="ref;
	debug(1,"ref="ref);
	match(ref, /.*,([^=]+).+,(.*)$/, m);
	type = structs[m[1]","m[2]];
	print "type="type
	print "  "m[2];
	for (s_elem in ref_list[ref]) {
		keysize = asorti(ref_list[ref][s_elem], srtkey);
		for (keyi in srtkey) {
			#print "s_elem="s_elem", keyi="keyi;
			#match(ref, /.*,([^=]+).+,(.*)$/, m);
			#type = structs[m[1]","m[2]];
			#print "m1="m[1]", m2="m[2];
			#print "HIHI: "keyi"="ref_list[ref][selem][keyi];
			print_struct_attribute(type,srtkey[keyi], ref_list[ref][s_elem][srtkey[keyi]]);
		}
		#for (keyi in ref_list[ref][s_elem]) {
		#	print "s_elem="s_elem", keyi="keyi;
		#	#match(ref, /.*,([^=]+).+,(.*)$/, m);
		#	#type = structs[m[1]","m[2]];
		#	#print "m1="m[1]", m2="m[2];
		#	#print "HIHI: "keyi"="ref_list[ref][selem][keyi];
		#	print_struct_attribute(type,keyi, ref_list[ref][s_elem][keyi]);
		#}
	}
}

function print_attribute(mo,attribute,value,	p,val,m) {
	match(mo, /.*,(.+)=/, m);
	#print "in print_attribute: MO="mo", "m[1];
	if (value ~ "@@@") {
		print "  "attribute;
		split(value, p, "@@@");
		for (val in p) {
			print "    "p[val];
		}
	} else if (sequences[m[1]","attribute] == 1) {
		#print "is sequence";
		print "  "attribute;
		print "    "value;
	} else {
		print "  "attribute"="value;
	}
}

function print_struct_attribute(type,attribute,value,	val,p) {
	#print "calling print_struct_attribute with type="type", attribute="attribute", value="value;
	#print "type="type", attribute="attribute;
	if (value ~ "@@@") {
		print "    "attribute;
		split(value, p, "@@@");
		for (val in p) {
			print "      "p[val];
		}
	} else if (structSequences[type","attribute] == 1) {
		#print "is struct sequence";
		print "    "attribute;
		print "      "value;
	} else {
		print "    "attribute"="value;
	}
}

function parse_momd(	inclass,instruct,line,attribute,moc,type,key,k,t) {
	inclass=0;
	instruct=0;
	while((getline < momdfile) > 0) {
		moc=$1;
		attribute=$2;
		type=$3;
		
		if (inclass==1 && type ~ /^structRef/) {
			key = substr(moc,index(moc, ".")+1)","attribute;
			match(type, /^structRef:(.*)/, t);
			structs[key]=t[1];
		} else if (inclass==1 && type ~ /^sequence:structRef/) {
			key = substr(moc,index(moc, ".")+1)","attribute;
			match(type, /^sequence:structRef-(.*)/, t);
			sequences[key]=t[1];
		} else if (inclass==1 && type ~ /^sequence:/) {
			key = substr(moc,index(moc, ".")+1)","attribute;
			sequences[key]=1;
		} else if (instruct == 1 && type ~ /^sequence:/) {
			key = moc","attribute;
			structSequences[key]=1;
		} else if (moc ~ /^MO$/) {
			inclass=1;
		} else if (moc ~ /^Struct$/) {
			inclass=0;
			instruct=1;
		}
	}
	for (k in sequences) debug(2,"seq-key="k", value="sequences[k]);
	for (k in structs) debug(2,"struct-key="k", value="structs[k]);
	for (k in structSequences) debug(2,"struct-seq-key="k", value="structSequences[k]);

}
