package print_func;
use strict;
#use File::Copy;
use html;
sub generate_header
{
	my $confighash = shift;
	
	if (defined $confighash->{html})
	{
		open( HTML,    "> $confighash->{html}" )   ;
		$confighash->{FILEHANDLE}->{HTML} = *HTML;
		html::generate_html_header($confighash);
	} 
}

sub generate_footer
{
	my $confighash = shift;
	my $fh_html =  $confighash->{FILEHANDLE}->{HTML} if defined $confighash->{html};
	my $fh_outfile =  $confighash->{FILEHANDLE}->{OUTFILE} if defined $confighash->{outfile};
	
	html::generate_html_foot($confighash) if defined $confighash->{html};
	
	close ($fh_outfile)        if defined $confighash->{outfile};
	close ($fh_html)          if defined $confighash->{html};
		
}

sub head 
{
	my $confighash = shift;
	my $name   = shift;
	my $header = shift;	
	my $flotOK = shift;

	my $namekeyflot;
	my $namekeyhtml;
	{
		$confighash->{nameCnt}++;
		$namekeyflot = 'graph_' . $confighash->{nameCnt} . '_flot'; 
		$namekeyhtml = 'sum_' . $confighash->{nameCnt}; 
		if ( defined $confighash->{nameMappingTable}->{$namekeyflot} )
		{
			redo;
		}
		else
		{
			$confighash->{nameMappingTable}->{$namekeyflot} = $name;
		}
	}
	$confighash->{rophash}->{$name}->{header} = $header;
	$confighash->{rophash}->{$name}->{flotname} = $namekeyflot;
	
	html::html_table_head($confighash,$name,$namekeyhtml,$header,$flotOK);
	
	return ($name,$namekeyflot);
}

sub print_table_end
{
	my $confighash = shift;
	html::html_table_end($confighash);
}

sub print_func 
{
	my $confighash = shift;
	my $string = shift;
	my $threshold = shift;
	#my $type = shift;
	#my $noTD = shift;
	#$type = "" if !defined $type;

	html::generate_html($confighash,$string,$threshold);
	#$string =~ s/;/ /g if !defined $confighash->{csv};
	#$string =~ s/\s*$//;

	#print "$string\n";
	
	
}

1;
