#!/bin/bash

if [ "$#" -ne 1 ]; then
    echo "Usage: $0 /home/egajash/moshell_logfiles/logs_moshell/pmfiles/10.136.72.253/web/20231114.0300_20231114.0459/index.html"
    exit 1
fi


HTML_PATH="$1"

# Define a file to store the chosen port

PORT_FILE="$HOME/.chosen_port"

#Function to find a free port

function find_free_port() {
        local port=8100
        while [[ $port -le 8110 ]]; do
         if ! nc -z -v -w5 localhost $port 2>/dev/null; then
          echo $port  
          return
         fi
         ((port++))
	done
}
#Try to read the port from the PORT_FILE

if [ -e "$PORT_FILE" ]; then
  PORT=$(cat "$PORT_FILE")
fi

#If the file doesn't exist or the port is in use, find a new one

if [ -z "$PORT" ] || nc -z -v -w5 localhost "$PORT" 2>/dev/null; then
 PORT=$(find_free_port)
 echo "$PORT" > "$PORT_FILE"
fi



#function to stop a running server on the given port

function stop_server() {
   local port="$1"
   local pid=$(lsof -t -i:$port)
   if [ -n "$pid" ]; then
     kill "$pid"
   fi
}

#Function to monitor the browser and close the script when the browser window is closed

function monitor_browser() {
  local browser_pid
  while true; do
   # Check if the browser process is running
   browser_pid=$(pgrep -f "firefox.*$PORT")
   if [ -z "$browser_pid" ]; then
   # The browser window is closed, exit the script
    echo "Web browser closed. Exiting..."
    stop_server "$PORT"
    exit
   fi
   sleep 1
  done
}

#Function to stop server and browser processes on script termination
function cleanup() {
  echo "Script terminated. Cleaning up..."
  stop_server "$PORT"
  exit 0
}

# Trap to handle script termination
trap cleanup SIGINT SIGTERM

# Call the function to stop the old server on the specified port
stop_server "$PORT"


if [[ -n $PORT ]]; then

	#Start a web server on the free port
        cd "$(dirname "$(realpath "$HTML_PATH")")"
	python3 -m http.server --bind 127.0.0.1 $PORT &

        #Open the HTML page in a web browser (Linux-specific)

	firefox "http://localhost:$PORT/$(basename "$HTML_PATH")" &
        echo "Server is running on port $PORT. This script will automatically close when the web browser is closed." 
        monitor_browser
else
	echo "No free port available."
fi


