#!/usr/bin/perl -w
$| = 1;

my $debug = 0;
my $debugtofile = 1;
my $debugdir = "/tmp";

use constant MAX_SHEET_NAME_LENGTH => 27;
use constant YSCALE => 4;
use constant XSCALE => 6;

#use Data::Dumper;
use POSIX;
use Excel::Writer::XLSX;
use Excel::Writer::XLSX::Utility;

#use Spreadsheet::WriteExcel;
#use Spreadsheet::WriteExcel::Utility;

use Spreadsheet::ParseExcel;
use Parse::RecDescent;
use List::Util qw(sum);
#use Math::NumberCruncher;
#use Statistics::PointEstimation;
use Statistics::TTest;
	
use English;
use strict;

use Time::Local;

use Getopt::Long;
my $version = "1.95";
#	1.0  2013xxyy	First version, included in moshell 10.0a
#	1.1  20130924	Converts pdf counters to weighted average, included last rop, added yellow colour for missing rops
#	1.1a 20130926	Added silver colour to pdf counters
#	1.1b 20130926	Added info sheet
#	1.1c 20131028	Added mom info, use -mom <momfile> where momfile is a gzipped mom file, same as moshell is using. Using compatibility mode to avoid corrupt xls file
#	1.1d 20131029	Tidied up script, added colours for all counter types, added description of counter types as comments
#	1.1e 20131030	Removed uninitialised variables causing corrupt xls file
#	1.1f 20131031	Handle long counter names better
#	1.2  20131111	Script is rewritten, Hopefully no corrupt xls files after this
#	1.2a 20131112	Changed colour of object and counter column
#	1.3  20131113	use of ttest, removed avgratio as selection criteria for changes sheet
#	1.3a 20131119	added avgratio as selection critera for changes sheet
#	1.3b 20131128	Fixed MOM problem, added classname to momhash, handle long descriptions and conditions better
#	1.4  20140108	Added bucket options and corrected MOM info for RBS.
#	1.4a 20140109	Added simple check of mom file. Exits program if found faulty
#	1.4b 20140109	Added simple check of s1 and e2 dates compared to first and last date in log file
#	1.4c 20140109	Fixed problem with standard MOM, fixed problem in find_class subroutine
#	1.4d 20140110	Removed e2 check with lastdate of log
#	1.4e 20140113	Added previously removed chart and time series
#	1.4f 20140113	Made MOM description more clear for eNodeB
#	1.4g 20140115	Fixed a problem with calculating number of sheets
#	1.5  20140128	Disabled debug and changed to xlsx format
#	1.51 20140618	Do not exit proram when MOM info is not found. This makes pxnl work
#	1.52 20140623	Guessing classname when can't find it in MOM (when using pmxnl)
#	1.53 20150112	added -form option to be able to create excel sheet with forulas (pmxel and pmxeln)
#	1.54 20150113	changed -form option to -formula (which is name of formula file) option and adds formula to comments
#	1.6  20150115	Handles formulas of formulas. Does not display counter info of these formulas as comments
#	1.61 20150116	Handles negative formula values, for exampel Rssi. $sum > 0 changed to $sum ne 0. Uncommented a line filling tabs with data. (it was commented by mistake in previous versions).
#	1.62 20150118	Adds subforumlas to formula comments
#	1.63 20150219	Removed check of counter name so the script works with pmxi command, Still printouts are complaing about missing classes
#	1.64 20150221	Removed warnings about MISSING class when there is no MOM file specified (pmxi)
#	1.65 20150428	Add formula file to info sheet when pmxel is used
#	1.7  20150603	Sparklines in column 3 for 'All counters' sheet and 'changes' sheet, Saves row of counter
#	1.71 20150901	Added same fix as Joakim Ostlund previously added to support perl 5.12
#	1.72 20150917	Added extra help when wrong period is specified. i.e e2 = 04:00 when last time in rop is 03:45
#	1.73 20150917	Fixed a coding error from 1.72, added warning when expected no of rops differes from actual no of rops
#	1.74 20150918	Slicing array when there are more rops in inout file than expected. Can happen when using 2 periods with a time gap in between.
#	1.75 20150919	Fixed graphs when there are 2 periods with a time gap in between.
#	1.8  20150925	pdf counters shown in column graph
#	1.81 20150928	Fixed bug with time columns for peg counters
#	1.82 20150929	Removed some warnings
#	1.83 20151029	Add second x-axis to graphs when 2 time periods are used and only one data serie is displayed, Removed special tag for peg counters
#	1.84 20151030	Fixed problem with spark lines
#	1.85 20151105	Added support for G2 nodes, requires pmom option as input. Fixed coloring problems
#	1.86 20151118	Removed a warning when mom is not present
#	1.87 20160511	Corrected regular expression for negative values in formulas
#   1.88 20160511   Prints perl version when staring pmxcel.pl
#	1.89 20160512	Removed non greedy operator from regular expressions (s1, e1, s2, e2) due to bug introduced in perl 5.20 https://rt.perl.org/Public/Bug/Display.html?id=125825. It is still not corrected in perl 5.22.2 as stated in TR. Hopefully this fix does not break anything else.
#	1.90 20220614	Added '-sinr' formatting and flag. (I. Einberg)
# 	1.91 20220615	Added '-all' flag, which displays all graphs in a single chart. (I. Einberg)
#	1.92 20220728	Fixed bug with extracting correct ROPs when using periods (s1, e1, s2, e2). (I. Einberg) 
# 	1.93 20220728	Automatically enable the '-bucket' option if arrays are present in input files, and removes counters with array values that do not end with '_X'. (I. Einberg)
#   1.94 20230504   
#	1.95 20231205	Fix problem with month of December

use constant USAGEMSG => <<USAGE;

Options:

pmxcel.pl creates an excel workbook from pmx output.
	pdf counters are weighted with bucket position.
	 
Syntax:	pmxcel.pl -f <logfile.log> -o <logfile.xlsx>

	-f									Input file (pmx output from moshell)
	-o									Output file (.xlsx)
	-r									Remove classname from mo name
	-s1									start time period 1 (20130612.1600 or 16:00)
	-e1									end time period 1	(20130612.2145 or 21:45)
	-s2									start time period 2	(20130612.2200 or 22:00)
	-e2									end time period2	(20130613.0400 or 04:00)
	-w									warning level
	-p									percentile level
	-m									minimum average
	-mom									mom file in gz format
	#-filter								apply lowpass filter
	-bucket									Treat buckets in PDF counters as separate counters
	-formula								pmx output consists of formulais instead of counters
	-pmom									pmom file
	
	-sinr									Use "sinr" formatting
	-all									Include a chart containing all graphs
		
	-help|h									Help.

Colour definition:
	Green								Counter is stepped
	White Italic							Counter is always 0
	Yellow								Counter is missing for some rop
	Purple								No counter values
	Silver								pdf counter which has stepped
	
Example:

l+ cellreknare.txt
pmx cell11211|cell11217|cell11212|cell11218|cell11221|cell11224|cell11231|cell11234 . -s 20130612.1600 -e 20130613.0400 -o csv
l-
pmxcel.pl -f cellreknare.txt -o cellreknare.xlsx -r
or
pmxl -s1 20130612.1600 -e1 20130612.2145 -s2 20130612.2200 -e2 20130613.0400 -w 25

pmxnl UtranCell pmNoRabEstablishAttemptPacketInteractiveHs|pmNoRabEstablishSuccessPacketInteractiveHs -m 4

pmxel cell=cell SpchDrop,PSDrop,HsDrop -m 12

pmxeln cell=cell SpchDrop,PSDrop,HsDrop -m 12
 
l+ nodereknare.txt
pmx Rncfunction=1$|UeRc|DchFrameSynch|SecurityHandling|Rcs|Paging|NodeSynch|IurLink|IuLink|Handover . -s 20130612.1600 -e 20130613.0400 -o csv
l-
pmxcel.pl -f nodeknare.txt -o nodereknare.xlsx -w 10

l+ rnc.txt
pmx cell=cell|Rncfunction=1$|UeRc|DchFrameSynch|SecurityHandling|Rcs|Paging|NodeSynch|IurLink|IuLink|Handover . -o csv -s 20131113.1200 -e 20131114.0600
l-
 
l+ rbsreknare.txt
pmx pool|radio|iub|carrier|resource|aich|antenna . -s 20130924.1200 -e 20130925.0600 -o csv
l-
pmxcel.pl -f rbsreknare.txt -bucket

When -o option is omitted the output name will be similar to input file name with the .xlsx extension.


USAGE

my ($s1,$e1,$s2,$e2,$numberofcolumns,$warninglevel,$percentilelevel,$percentile,$minAvg,$mom,$filter);
my ($help,$filename,$outputfile,$removeclassname,$denominator,$useperiods,$firstdate,$lastdate,$buckets,$formula_file,$pmom_file,$sinr,$all);
my (%formulainfo);
my $mode = 't';
my $ttest_unequal = 2;
my $number_of_xaxes;

GetOptions
(
		'filename|f=s'	=> \$filename,
		'output|o=s'	=> \$outputfile,
		'remove|r'		=> \$removeclassname,
		's1=s'			=> \$s1,
		'e1=s'			=> \$e1,
		's2=s'			=> \$s2,
		'e2=s'			=> \$e2,
		'w=i'			=> \$warninglevel,
		'p'			=> \$percentile,
		'm=i'			=> \$minAvg,
		'mom=s'			=> \$mom,
		'filter'		=> \$filter,
		'bucket|b'		=> \$buckets,
		'help|h'		=> \$help,
		'formula=s'		=> \$formula_file,
		'pmom=s'		=> \$pmom_file,
		'sinr'			=> \$sinr,
		'all'			=> \$all,
);
	my %colors = (
				'black' => 0x08,
				'blue' => 0x0C,
				'brown' => 0x10,
				'cyan' => 0x0F,
				'gray' => 0x17,
				'green' => 0x11,
				'lime' => 0x0B,
				'lightyellow' => 0x2B,
				'magenta' => 0x0E,
				'navy' => 0x12,
				'orange' => 0x35,
				'pink' => 0x21,
				'purple' => 0x14,
				'red' => 0x0A,
				'silver' => 0x16,
				'white' => 0x09,
				'yellow' => 0x0D,
				'orange' => 40,
				'lightred' => 41,
				'lightblue' => 42,
	);
print "pmxcel v$version,	perl v$]:\n";	
print "MOM=$mom\n" if (defined $mom);
print "Using 'sinr' formatting\n" if $sinr;
my %objecthash;
#$pmom_file = '/home/eraaldr/rbs506_pmom.txt';

#	undef $mom; # used to test pmxil
	
	
	
	if ($debugtofile){
		open DEBUG, ">", "$debugdir/pmxcel_debug.txt" or die $!;
		open STDERR, ">", "$debugdir/pmxcel_warnings.txt" or die $!;
#		open STDERR, ">>", "pmxcel_debug.txt" or die $!;
	}
	$warninglevel = 25 if (!defined $warninglevel);
	$percentilelevel = $warninglevel;
	if ($percentile){
		$percentilelevel = $warninglevel;
	}
#print "Formula file: $formula_file\n";
	my $noofexpectedrops = -1;
	my $timesize = -1;

	my %periods;
	$minAvg = 10 if (!defined $minAvg);
	if (defined $s1 && defined $e1 && defined $s2 && defined $s2) {
		$useperiods = 1;

		my @parts = $s1 =~ /^(\d{4})(\d{2})(\d{2})\.(\d{2})(\d{2})$/;
#debugprint ( __LINE__ .  "\n\nPARTS1 = " . $parts[1] . "\n\n" );
#debugprint ( __LINE__ .  "\n\nPARTS2 = " . $parts[2] . "\n\n" );
#debugprint ( __LINE__ .  "\n\nPARTS3 = " . $parts[3] . "\n\n" );
#debugprint ( __LINE__ .  "\n\nPARTS4 = " . $parts[4] . "\n\n" );
		# timegm month = 0-11, $parts[1] = 1-12
		my $start_secs += timegm(00,$parts[4],$parts[3],$parts[2],$parts[1]-1,$parts[0]);   
		@parts = $e1 =~ /^(\d{4})(\d{2})(\d{2})\.(\d{2})(\d{2})$/;
		my $end_secs += timegm(00,$parts[4],$parts[3],$parts[2],$parts[1]-1,$parts[0]);
		$periods{p1} = ($end_secs - $start_secs) / 60 / 15;
		$periods{s1} = 0;
		$periods{e1} = $periods{s1} + $periods{p1} -1;

		$start_secs = 0;
		$end_secs = 0;
		@parts = $s2 =~ /^(\d{4})(\d{2})(\d{2})\.(\d{2})(\d{2})$/;
		$start_secs += timegm(00,$parts[4],$parts[3],$parts[2],$parts[1]-1,$parts[0]);
		@parts = $e2 =~ /^(\d{4})(\d{2})(\d{2})\.(\d{2})(\d{2})$/;
		$end_secs += timegm(00,$parts[4],$parts[3],$parts[2],$parts[1]-1,$parts[0]);
		$periods{p2} = ($end_secs - $start_secs) / 60 / 15;

                $start_secs = 0;
                $end_secs = 0;
                @parts = $e1 =~ /^(\d{4})(\d{2})(\d{2})\.(\d{2})(\d{2})$/;
                $start_secs += timegm(00,$parts[4],$parts[3],$parts[2],$parts[1]-1,$parts[0]);
                @parts = $s2 =~ /^(\d{4})(\d{2})(\d{2})\.(\d{2})(\d{2})$/;
                $end_secs += timegm(00,$parts[4],$parts[3],$parts[2],$parts[1]-1,$parts[0]);
		my $gap = ($end_secs - $start_secs) / 60 / 15;
#print __LINE__ . ":	GAP = $gap\n";

		$periods{s2} = $periods{e1} + $gap;
                $periods{e2} = $periods{s2} + $periods{p2} -1;

#		if ($s1 =~ /\d{4}?/){
                if ($s1 =~ /\d{4}/){
 			$mode = 'c';
			$denominator = '17';
# Changed this due to perl bug: "Useless use of greediness modifier '?' in regex; marked by <-- HERE in m/\d{4}? <-- HERE / at /home/eraaldr/moshell/commonjars/pmxcel/pmxcel.pl line 255."
#			$s1 =~ s/(\d{4}?)(\d{2}?)(\d{2}?)\.(\d{2}?)(\d{2}?)/$1-$2-$3 $4:$5/;
#			$e1 =~ s/(\d{4}?)(\d{2}?)(\d{2}?)\.(\d{2}?)(\d{2}?)/$1-$2-$3 $4:$5/;
#			$s2 =~ s/(\d{4}?)(\d{2}?)(\d{2}?)\.(\d{2}?)(\d{2}?)/$1-$2-$3 $4:$5/;
#			$e2 =~ s/(\d{4}?)(\d{2}?)(\d{2}?)\.(\d{2}?)(\d{2}?)/$1-$2-$3 $4:$5/;
                       $s1 =~ s/(\d{4})(\d{2})(\d{2})\.(\d{2})(\d{2})/$1-$2-$3 $4:$5/; 
                       $e1 =~ s/(\d{4})(\d{2})(\d{2})\.(\d{2})(\d{2})/$1-$2-$3 $4:$5/;
                       $s2 =~ s/(\d{4})(\d{2})(\d{2})\.(\d{2})(\d{2})/$1-$2-$3 $4:$5/;
                       $e2 =~ s/(\d{4})(\d{2})(\d{2})\.(\d{2})(\d{2})/$1-$2-$3 $4:$5/;
		}else{
			$mode = 't';
			$denominator = '6';
		}
		print "s1=$s1,	e1=$e1,	s2=$s2,	e2=$e2,	warning level=$warninglevel%,	mode=$mode\n";

	}else{
#		$number_of_xaxes = 1;
		print "No periods defined,	warning level=$warninglevel%,	mode=$mode\n";
		$denominator = '6';
	}
	if ($help){
		print "pmxcel.pl v$version\n\n";
		print USAGEMSG;
		exit;
	}
	if (!$filename){
		print "Missing file name for input!!!\n\n";
		print USAGEMSG;
		exit;
	}
	if (!$outputfile){
		$outputfile = $filename;
		$outputfile =~ s/\.\w+$//;
		$outputfile .= ".xlsx";
		print "Output file name: $outputfile\n\n";
	}

#	$number_of_xaxes = 2 if (defined $useperiods);
	
	my %mominfo;
	my %mominfo2;
	if ($formula_file){
		print "Reading formula file: $formula_file\n";
		readformulas($formula_file,\%formulainfo);
		print "formulainfo=" . %formulainfo ."\n";
		if (%formulainfo eq 0){
			die "\nFAILURE: \'$formula_file\' is not a proper formula file, please specify another file.\n\n";
		}
#		foreach my $formulaname (sort keys %formulainfo) {
#			print __LINE__ . ":	Formulaname=$formulaname	=	$formulainfo{$formulaname}{INFO}\n";
#			foreach my $subformula (sort keys %{$formulainfo{$formulaname}{SUBFORMULA}}) {
#				print __LINE__ . ":		Subformula	=	$subformula\n";
#			}
#		}

	}
	if ($mom){
		readmom($mom,\%mominfo,\%mominfo2,$pmom_file);
		print "mominfo=" . %mominfo ."\n";
		if (%mominfo eq 0){
			die "\nFAILURE: \'$mom\' is not a proper mom file, please specify another file.\n\n";
		}
	}
	
	foreach my $class (sort keys %mominfo) {
#		print __LINE__ . ":	class=$class\n";
		foreach my $counter (sort keys %{$mominfo{$class}}) {
#			print __LINE__ . ":	c=$counter,		class=$class,	momhash=$mominfo{$class}{$counter}\n";
#			print __LINE__ . ":	c=$counter,		class=$class,	momhash=$mominfo{$class}{$counter},	TYPEnew=$mominfo{$class}{$counter}{TYPE},	TYPEold=$mominfo{$counter}{TYPE}\n";
		}
	}
	print "Reading log file.....\n";
	open INFILE,"$filename" or die $!;
	my @input = <INFILE>;
	my @time;
	my (%counterhash,%filteredhash,%counternamehash,%uniqsheet,%urkhash);
	my $objflag=0;
	my ($object,$sheetname,$counter,$values);
	my ($tmp,$rawtime,$pdf);
	my @x_values;
	
	# Stores the names of every counter which has values given in the form of an array.
	my %arrays;

	
	foreach (@input){
		# If data contains an array:
		if (/^[^=]+=\S+;\s+(\w+);.*,/){
			# 1 - Use the "bucket" option.
			$buckets = 1;
			# 2 - Store the name of the counter.
			$arrays{$1} = 1;
		}
	}

	foreach (@input){
#	print __LINE__ . ":	$_\n";
#                        if (/^Object.+?(\d{4}?-\d{2}?-\d{2}? \d{2}?:\d{2}?;.*)/){               #Andrade .+ -> .* for att fa med sista tiden
# Changed this due to perl bug
			if (/^Object.+?(\d{4}-\d{2}-\d{2} \d{2}:\d{2};.*)/ || ($sinr && /^Counter; (?:Object|MO);.+?(-?\d+\.\d+;.*)/)){		#Andrade .+ -> .* for att fa med sista tiden
				$objflag = 1;
				$mode = 'c';
				$rawtime = $1;
				@time = (@time, split (/;\s+/,$rawtime));
				@x_values = @time;
				$timesize=@time;
				print "Number of fetched rop files = $timesize\n";
#	print __LINE__ . ":	Object\n";
				if ( !defined $firstdate){
					$firstdate = $time[0];
					$lastdate = $time[@time-1];
					print "First time stamp in log file: $firstdate,	Last time stamp in log file: $lastdate\n";
					if ($useperiods){
						if ($firstdate gt $s1){
							print "\nFAILURE:	First date=$firstdate,	Start date period 1 = $s1\n";
							die "		Your start date is not found in log file, please specify another date.\n\n";
						}
						if ($lastdate lt $e2){
							print "\nFAILURE:	Last date=$lastdate,	End date period 2 = $e2. Ingnoring this!!!\n";
#							die "		Your end date is not found in log file, please specify another date.\n\n";
						}
					}
				}
#				print __LINE__ . ":	HEJ, det �r forsta else satsen. Vi har hittat tiden!\n";
			}
			elsif ($objflag && /^([^=]+=\S+);\s+(pm\w+);\s+(.+)/){	#Csv mode
				$object	= $1;
				$counter = $2;
				$mode = 'c';
				debugprint (__LINE__ . ":	obj=$object,	counter=$counter,	mode=$mode\n");
#				print __LINE__ . ":	HEJ, det �r andra else satsen\n";
				if ($object !~ /Dummy/){
					parse_logfile($1,$2,$3,$removeclassname,$mode,$buckets,\%urkhash,\%counterhash);
#					#anvand 2 x-axlar da det endast finns ett object
					my ($type) = $object =~ /(^[^=]+)=/;
					my $key1 = $type . '_' . $counter;
					if (defined $useperiods) {
						if (exists $objecthash{$key1}{series}) {
							$objecthash{$key1}{series}++;
							$objecthash{$key1}{axes} = 1;
							$number_of_xaxes = 1;
#							print __LINE__ . ":	Second time a counter is found => 2 axes\n";
						}else{
							$objecthash{$key1}{series} = 1;
							$objecthash{$key1}{axes} = 2;
							$number_of_xaxes = 2;
#							print __LINE__ . ":	First time a counter is found => 1 axes\n";
						}
					} # end if useperiods
				}
			}
			elsif ($objflag && /^([^=]+=\S+);\s+(\w+);\s+(.+)/ || ($sinr && /^(\w+\S+);\s+(\w+=\S+);\s+(.+)/)){	#Csv mode , pmxi command eller pmxel
#				print __LINE__ . ":	HEJ, det �r tredje else satsen\n";
				$object	= $1;
				$counter = $2;
				$mode = 'c';
				debugprint (__LINE__ . ":	obj=$object,	counter=$counter,	mode=$mode\n");
				if ($object !~ /Dummy/){
					parse_logfile($1,$2,$3,$removeclassname,$mode,$buckets,\%urkhash,\%counterhash);

#					#anvand 2 x-axlar da det endast finns ett object
					my ($type) = $sinr ? $object =~ /(^[^=]+)/ : $object =~ /(^[^=]+)=/;
					my $key1 = $type . '_' . $counter;
					if (defined $useperiods) {
						if (exists $objecthash{$key1}{series}) {
							$objecthash{$key1}{series}++;
							$objecthash{$key1}{axes} = 1;
							$number_of_xaxes = 1;
							print __LINE__ . ":	Second time a counter is found => 2 axes\n";
						}else{
							$objecthash{$key1}{series} = 1;
							$objecthash{$key1}{axes} = 2;
							$number_of_xaxes = 2;
							print __LINE__ . ":	First time a counter is found => 1 axes\n";
						}
					} # end if useperiods
				}
			}
			elsif (/^Object.+?(\d\d:\d\d.*)/){				#Andrade .+ -> .* for att fa med sista tiden
				$rawtime = $1;
				$objflag = 1;
				$mode = 't';
				@time = (@time, split (/\s+/,$rawtime));
#				print __LINE__ . ":	HEJ, det �r fjarde else satsen\n";
			}
			elsif ($objflag && /^([^=]+=\S+)\s+(pm\w+)\s+(.+)/){	#Text mode
				$object	= $1;
				$counter = $2;
				if ($object !~ /Dummy/){
					parse_logfile($1,$2,$3,$removeclassname,$mode,$buckets,\%urkhash,\%counterhash);
				}
			}
			elsif ($objflag && /^([^=]+=\S+)\s+(\w+)\s+(.+)/){	#Text mode, pmxi command
				$object	= $1;
				$counter = $2;
				if ($object !~ /Dummy/){
					parse_logfile($1,$2,$3,$removeclassname,$mode,$buckets,\%urkhash,\%counterhash);
				}
			}
			
		}
	print "Done.\n";

	my $index_of_0 = my $temp_index = 1;
	# Find index of 0 if it is present, else index of smallest negative value.
	foreach (@x_values){

		if ($_ > 0)
		{
			$index_of_0 = $temp_index;
			last;
		}
		elsif ($_ == 0){
			$index_of_0 = $temp_index + 0.5;
			last;
		} else {
			$temp_index++;
		}
		
	}

	#		$counterhash{$object}{$counter}{values} = [@{$counterhash{$object}{$counter}{values}},split (/\s+/,$values)];	#for txt

	if ($filter){
#		print "Applying Low Pass Filter...\n";
#		foreach my $object (sort keys %counterhash) {
#			foreach my $counter (sort keys %{$counterhash{$object}}) {
#				@{$counterhash{$object}{$counter}{values}} = bpfilter2($counterhash{$object}{$counter}{values},32,6);
#			}
#		}
#		print "Done\n";
	}
	
	if (@time < 1)
	{
		print "FAILURE:	Could not find any pmx output with time in log file!\n";
		print "		Check \"!cat \$logfile\"\n";
		die;
	}


	periods_check();
	if ($useperiods){
		if ($timesize != $noofexpectedrops) {
			print "\n***** WARNING ***** The number of fetched rop files differs from the expected number of rops, $timesize <> $noofexpectedrops. This will be taken care of. *****\n\n";
		}
	}
	
	my ($workbook,$parser,$infosheet,$worksheet);
	my %sheethash;

#	$parser   = Spreadsheet::ParseExcel->new();
	
	my @t2 = @time[$periods{s1}..$periods{e1}];
	my @t3 = @time[$periods{s2}..$periods{e2}];
	my @t1 = @time[0..($periods{s1}-1)];
	my @t4 = @time[($periods{e2}+1)..@time-1];

	print "Create excel sheets...\n";

	# Some common formats
	my %writeformat;
	my %charthash;
	my $changesheet;
	my %shapehash;
	my $shape_rect;
	
	create_book(\$workbook);
	create_formats(\$workbook,\%writeformat);
	create_sheets(\$workbook,\$worksheet,\%urkhash,\%sheethash,\%mominfo,$mom,$useperiods,$buckets,\@time,\%writeformat,\%charthash, $sinr);
	create_info_sheet(\$workbook,\$infosheet,$useperiods,$percentile,$mom,\%counterhash,\%sheethash,$formula_file);
	create_change_sheet(\$workbook,\$changesheet,$useperiods,\%writeformat);
	write_time(\$worksheet,\@time,$useperiods,\%writeformat);

	my $mainrow=1;
	my $arraylength=0;
	my $sum;

	print "Done.\n";

	my $changerow = 1;
	my $emptystring;
	my $missingrop;
	my ($lastrow,$lastcol);
	
	my $ttest = new Statistics::TTest;  
	my @tmp;
	my $classname;

	my $noofelements = 0;
	print "Counting counters...\n";
	foreach my $object (sort keys %counterhash) {
		foreach my $counter (sort keys %{$counterhash{$object}}) {
			$noofelements++;
		}
	}
	print "Done.\n";

	print "Filling datasheet with $noofelements counters....\n";
	my $currentelement=0;
	my ($percent,$oldpercent);
	$oldpercent=0;
	my $all_chart = $workbook->add_chart( type => 'line', embedded => 1);
	$all_chart->set_title(name => 'All graphs');
	$all_chart->set_y_axis(name => 'Number');
	if ($sinr){
				$all_chart->set_x_axis( name => 'dB', visible => 1, interval_unit => 1, crossing => $index_of_0);
	}
	# Save old 'from' and 'to' indices for period 2 (p2), since the space between p1 and p2 is "removed" if $userperiods
	$periods{old_s2} = $periods{s2};
	$periods{old_e2} = $periods{e2};
	foreach my $object (sort keys %counterhash) {
		$classname = $object;
		@tmp = split(/=|,/,$object);
		$classname = $tmp[@tmp-2];
		foreach my $counter (sort keys %{$counterhash{$object}}) {
			
			# Ignore counters with array values that do not end with _X.
			next if (defined $arrays{$counter} && ($counter !~ /_\d+$/));
			
			$percent = sprintf ("%3.0f",$currentelement/$noofelements*100);
			print "\r\e[K ($percent%)	$currentelement/$noofelements" if ($percent > $oldpercent);
#			print "\r\e[K ($percent%)	$currentelement/$noofelements	$object.$counter";
			$oldpercent = $percent;
			$currentelement++;
			
			$sheetname = $urkhash{$counter}{SHEET};

			my $formula = $formulainfo{$counter}{INFO} if (defined $formula_file);
#			debugprint (__LINE__ . ":	counter=$counter,	forumla=$formula,	info=formulainfo{$formula}{INFO}\n");

#			debugprint(__LINE__ . ":	object=$object	counter=$counter	shitname=$sheetname\n");

			$sum = 0;
#			$sum += $_ for @{${$counterhash{$object}}{$counter}{values}}; # denna rad funkar ej om räknarvärde saknas
			my $pos = 0;

			# Vi tar inte hansyn till att det kan vara for manga ropar i input filen. H�r g�r vi ett forsok att plocka bort onodiga ropar.
			if ($useperiods) {
				if (!exists $counterhash{$object}{$counter}{special}) {
					# print "Slizing array: array size before slize = " . @{${$counterhash{$object}}{$counter}{values}} . ", $periods{s1} -> $periods{e1} and $periods{s2} -> $periods{e2}\n" if ($debug);
					
					# Using 'old_s2' and 'old_e2' since 's2' and 'e2' may have been updated in a previous iteration.
					@{${$counterhash{$object}}{$counter}{values}} = @{${$counterhash{$object}}{$counter}{values}}[$periods{s1}..$periods{e1},$periods{old_s2}..$periods{old_e2}];
					my $p2 = $periods{old_e2} - $periods{old_s2};
					$periods{s2} = $periods{e1} + 1;
					$periods{e2} = $periods{s2} + $p2;
					
					# print "Slizing array: array size after slize = " . @{${$counterhash{$object}}{$counter}{values}} . "\n" if ($debug);
				}
			}
			for (@{${$counterhash{$object}}{$counter}{values}}) {
				if ($_ !~ /^$/) {
					if ($_ !~ /N\/A/){
						$sum += $_;
					}
				}else{
					$missingrop = 1;
				}
				$pos++;
			}
			if ("@{${$counterhash{$object}}{$counter}{values}}" =~ /^$/){
				$emptystring = 1;
#				print __LINE__ . ":	string is empty,	$object $counter	@{${$counterhash{$object}}{$counter}{values}}\n";
			}else {
				$emptystring = -1;
			}
#			print __LINE__ . ":	emptystring=$emptystring\n";
			
			# Nu kollar vi varje sheet
			if (exists $urkhash{$counter}{ROW}){
				$urkhash{$counter}{ROW}++ if ($sum ne 0);	#ny "sum >0" till "sum ne 0"
			}else{
				$urkhash{$counter}{ROW} = 0;	#ny, gor kontroll senare att den ej ar 0 nar vi skriver
			}
			if ($sum ne 0 && !defined $sheethash{$urkhash{$counter}{SHEET}}){ #andrade fran "> 0" till "ne 0" pga negativa RBS raknare
				print __LINE__ . ": Sheet is not defined. This should never happend!!!\n";
			}
			debugprint(__LINE__ . ":	urkhashROW_E=$urkhash{$counter}{ROW},	counter=$counter,	class=$classname,	obj=$object,	sheetname=$urkhash{$counter}{SHEET},	sum=$sum\n");

			my $writeformat = decide_writeformat(\%writeformat,$mom,$counter,$sum,$emptystring,$counterhash{$object}{$counter}{type},$missingrop,$pmom_file);


			my $originalcountername = $counter;
			if (defined $buckets){
				if ($originalcountername =~ /_\d+$/){
					$originalcountername =~ s/_\d+$//;
					$pdf = 1;
				}
			}

			#skriv till All sheet
			$worksheet->write( $mainrow,0, $object,$writeformat);
			
			
			my $link = "internal:$urkhash{$counter}{SHEET}!A1";
			my $row2=$mainrow+1;
			if ($sum ne 0){
				$urkhash{$counter}{ROW}++ if ($urkhash{$counter}{ROW} eq 0); #kontrollera att den ej är 0 for da blir det korrupt
				$worksheet->write( "B$row2",$link, $counter,$writeformat);
				if (exists $mominfo{$classname}{$originalcountername}{INFO}){
					$worksheet->write_comment( "B$row2", $mominfo{$classname}{$originalcountername}{INFO},x_scale => XSCALE,y_scale => YSCALE) if (defined $mom);
				}else{
					my $guessclass = find_class(\%mominfo,$originalcountername);
					#Detta kan inträffa om man kör pmxnl då byts MO ut mot ManagedElement, nu måste vi gissa klassen
					debugprint (__LINE__ . "\nOooooops...No mom information is available for counter=$classname.$originalcountername in allsheet, momfile=$mom,	guessclass=$guessclass\\n\n");
				}
				if (defined $mom and !exists $mominfo{$classname}{$originalcountername}{INFO}){
					my $guessclass = find_class(\%mominfo,$originalcountername);
					debugprint (__LINE__ . "\nOooooops...No mom information is available for counter=$classname.$originalcountername in allsheet, momfile=$mom,	Guessing class: guesed class=$guessclass\n\n");
				}
			}else{
				$worksheet->write( $mainrow,1, $counter,$writeformat);
			}
			$worksheet->write( $mainrow,3, [@{${$counterhash{$object}}{$counter}{values}}]);
			${$counterhash{$object}}{$counter}{allsheetrow}=$mainrow;
			if (defined $emptystring and $emptystring ne 1){
				my $cell = xl_rowcol_to_cell($mainrow, 2);
				my $range = xl_range($mainrow, $mainrow, 3, @{${$counterhash{$object}}{$counter}{values}}+2);
				$worksheet->add_sparkline({location=>"$cell", range=> "'All counters'!$range"});	# sheet!r1, r2, c1, c2
#				print __LINE__ . ":	sparkline in all counter sheet\n";
			}

			if ($all){
				my $val_range = xl_range($mainrow, $mainrow, 3, @{${$counterhash{$object}}{$counter}{values}}+2);
				my $cat_range = xl_range(0, 0, 3, 3+@x_values);
				$all_chart->add_series(
					name => "$object\n$counter",
					categories =>  "'All counters'!$cat_range",
					values => "'All counters'!$val_range"
				);
			}


			$missingrop = ();

#			my $region = [@{${$counterhash{$object}}{$counter}{values}}]->[2];
			$arraylength = @{${$counterhash{$object}}{$counter}{values}};
			debugprint(__LINE__ . ":	urkhashROW=$urkhash{$counter}{ROW},	counter=$counter,	class=$classname,	obj=$object,	sheet=$urkhash{$counter}{SHEET},	sum=$sum,	arraylength=$arraylength\n");
			if (($urkhash{$counter}{SUM} ne 0) and $sum ne 0){
				#Sheet should exist and we should write data to it when sum of this row is > 0
				# changed to "ne 0" due to negative RBS counter value like RSSI
				
				#write cell name and counter name to new sheet sheet
				$sheethash{$urkhash{$counter}{SHEET}}->write( $urkhash{$counter}{ROW} ,0, $object,$writeformat);
				$sheethash{$urkhash{$counter}{SHEET}}->write( $urkhash{$counter}{ROW} ,1, $counter,$writeformat);
				#write counter values to new sheet
				if (exists $counterhash{$object}{$counter}{special}){
					$sheethash{$urkhash{$counter}{SHEET}}->write( $urkhash{$counter}{ROW},2, [@{${$counterhash{$object}}{$counter}{values}}]);
				}else{
					$sheethash{$urkhash{$counter}{SHEET}}->write( $urkhash{$counter}{ROW},2, [@{${$counterhash{$object}}{$counter}{values}}]);
				}
				debugprint( __LINE__ . ":	Writing serie to $urkhash{$counter}{SHEET} for counter $counter, row=$urkhash{$counter}{ROW}: " . "@{${$counterhash{$object}}{$counter}{values}}" . "\n");
				
				if (exists $mominfo{$classname}{$originalcountername}{INFO}){
					if (exists $sheethash{$urkhash{$counter}}{MOM}){
						# do nothing
#						print "$counter MOM already exists in sheethash $urkhash{$counter}{SHEET}\n";						
					}else{ # Det kraschar om man kör följande rad
						$sheethash{$urkhash{$counter}{SHEET}}->write_comment( 1 ,1, $mominfo{$classname}{$originalcountername}{INFO},x_scale => XSCALE,y_scale => YSCALE) if (defined $mom);	# 0 = längst till vänster, $i = rad
						$sheethash{$urkhash{$counter}}{MOM} = 1;
					}
				}elsif (defined $mom) { #MOM does not exist
					# Vi hamnar h�r d� vi k�r pmxln eller pmxeln
					my $guessclass = find_class(\%mominfo,$originalcountername);
					debugprint (__LINE__ . "\nOooooops...No mom information is available for counter=$classname.$originalcountername in allsheet, momfile=$mom,	Guessing class: guesed class=$guessclass\n\n");
					if (exists $formulainfo{$counter}{INFO}){
						debugprint (__LINE__ . ":	$formula_file,	counter=$counter,	forumla=$formula,	info=$formulainfo{$counter}{INFO}\n");
						my $comment = "\n" . $counter . " = " . $formulainfo{$counter}{INFO} . "\n";

						if (exists $formulainfo{$counter}{COUNTERS}) {
							foreach my $reknare (sort keys %{$formulainfo{$counter}{COUNTERS}} ) {
								$guessclass = find_class(\%mominfo,$reknare);
								$comment .= $mominfo{$guessclass}{$reknare}{INFO};
								debugprint (__LINE__ . ":	formula counter=$counter,	guessclass=$guessclass,	comment=$comment\n\n");
							}
						}else{
							debugprint (__LINE__ . ":	formulainfo{counter}{COUNTERS} does not exists,	formula counter=$counter,	comment=$comment\n\n");
						}
						
						$worksheet->write_comment( "B$row2", $comment,x_scale => XSCALE,y_scale => YSCALE) if (defined $formula_file);
					}else{
						$worksheet->write_comment( "B$row2", $mominfo{$guessclass}{$originalcountername}{INFO},x_scale => XSCALE,y_scale => YSCALE) if (defined $mom);
					}
				} # end MOM does not exist
				update_change_sheet(\$changesheet,\%writeformat,\%filteredhash,\%counterhash,\%urkhash,\$object,\$counter,$useperiods,\$ttest);

				debugprint(__LINE__ . ":	Updating sheet $urkhash{$counter}{SHEET} with object=$object, counter=$counter and values,	urkhash{sheet}{row}=$urkhash{$counter}{ROW}\n");
				
				my $key1 = 'ManagedElement' . '_' . $counter;
				my ($class) = $object =~ /(^[^=]+)=/;
				if ($urkhash{$counter}{ROW} < 150) { # excel crashes when using more than 49 data series => does not seem to be a problem anymore, increased from 49 to 150
					debugprint(__LINE__ . ":	TATA using periods:	$object,	$counter,	$urkhash{$counter}{SHEET},	$urkhash{$counter}{ROW}\n");
					if (exists $counterhash{$object}{$counter}{special}){
						$counterhash{$class}{$counter}{noofgraphs} = 1;
							my $s1 = 2;                                                        
							my $e1 = 2 + $counterhash{$object}{$counter}{special_p1} - 1;
							$charthash{$urkhash{$counter}{SHEET} }->add_series(
								name => "$object",
								categories => xl_range_formula( $urkhash{$counter}{SHEET}, 0, 0, $s1,$e1 ), #C$1:OP$1
								values	=> xl_range_formula( $urkhash{$counter}{SHEET}, $urkhash{$counter}{ROW}, $urkhash{$counter}{ROW}, $s1,$e1 ), #  C = 2
						);
					}else{
#m print __LINE__ .":	Adding serie:	s1=$periods{s1},	e1=$periods{e1},	s2=$periods{s2},	e2=$periods{e2}\n";
						if (exists $counterhash{$object}{$counter}{special_p1}) { #Kanns helt onodigt
							$charthash{$urkhash{$counter}{SHEET} }->add_series(
								name => "$object",
								categories => xl_range_formula( $urkhash{$counter}{SHEET}, 0, 0, 2+$periods{s1}, 2+$periods{e2} ), #C$1:OP$1
								values	=> xl_range_formula( $urkhash{$counter}{SHEET}, $urkhash{$counter}{ROW}, $urkhash{$counter}{ROW}, 2+$counterhash{$object}{$counter}{special_p1}, 2+$counterhash{$object}{$counter}{special_p2} ), #  C = 2
							);
						}else{
#							$charthash{$urkhash{$counter}{SHEET} }->add_series(
#								name => "$object",
#								categories => xl_range_formula( $urkhash{$counter}{SHEET}, 0, 0, 2+$periods{s1}, 2+$periods{e2} ), #C$1:OP$1
#								values  => xl_range_formula( $urkhash{$counter}{SHEET}, $urkhash{$counter}{ROW}, $urkhash{$counter}{ROW}, 2+$periods{s1}, 2+$periods{e2} ), #  C = 2
#							);
#Har testar vi 2 x-axlar, vi maste anvanda 2 y-axlar for att den andra a-axeln skall synas
							if (exists $objecthash{$key1}{axes}){
								$key1 = 'ManagedElement' . '_' . $counter;
							} else{
								$key1 = $class . '_' . $counter;
							}
#							print __LINE__ . ":	key1=$key1,	object=$object	class=$class,	#axes=$objecthash{$key1}{axes}	number_of_xaxis=$number_of_xaxes\n";
							my $yxa = 'ManagedElement' . '_' . $counter;
#							print __LINE__ . ":	yxa=$yxa,	#axes=$objecthash{$yxa}{axes}\n";
							
							if ($number_of_xaxes == 2 ){
#							if ($objecthash{$key1}{axes} == 2 ){
								$charthash{$urkhash{$counter}{SHEET} }->add_series(
									name => "$object" . "_period1",
									categories => xl_range_formula( $urkhash{$counter}{SHEET}, 0, 0, 2+$periods{s1}, 2+$periods{e1} ), #C$1:OP$1
									values  => xl_range_formula( $urkhash{$counter}{SHEET}, $urkhash{$counter}{ROW}, $urkhash{$counter}{ROW}, 2+$periods{s1}, 2+$periods{e1} ), #  C = 2
								);
								$charthash{$urkhash{$counter}{SHEET} }->add_series(
									name => "$object" . "_period2",
									categories => xl_range_formula( $urkhash{$counter}{SHEET}, 0, 0, 2+$periods{s2}, 2+$periods{e2} ), #C$1:OP$1
									values  => xl_range_formula( $urkhash{$counter}{SHEET}, $urkhash{$counter}{ROW}, $urkhash{$counter}{ROW}, 2+$periods{s2}, 2+$periods{e2} ), #  C = 2
									y2_axis => 1,
								);
							}elsif (defined $useperiods) { # fler an ett MO skall skrivas ut, da skall vi ha endast en tidslinje
								$charthash{$urkhash{$counter}{SHEET} }->add_series(
									name => $object,
									categories => xl_range_formula( $urkhash{$counter}{SHEET}, 0, 0, 2+$periods{s1}, 2+$periods{e2} ), #C$1:OP$1
									values  => xl_range_formula( $urkhash{$counter}{SHEET}, $urkhash{$counter}{ROW}, $urkhash{$counter}{ROW}, 2+$periods{s1}, 2+$periods{e2} ), #  C = 2
								);
#								print __LINE__ . ":	fler an ett MO skall skrivas ut, da skall vi ha endast en tidslinje\n";
							}else {
								$charthash{$urkhash{$counter}{SHEET} }->add_series( #det ar bara en period specad
									name => $object,
									categories => xl_range_formula( $urkhash{$counter}{SHEET}, 0, 0, 2+$periods{s1}, 2+$periods{e1} ), #C$1:OP$1
									values  => xl_range_formula( $urkhash{$counter}{SHEET}, $urkhash{$counter}{ROW}, $urkhash{$counter}{ROW}, 2+$periods{s1}, 2+$periods{e1} ), #  C = 2
								);
#								print __LINE__ . ":	useperiods=$useperiods\n";
							}
#					 		print __LINE__ .":	PLONG,	adding series\n";
						}
					}
					debugprint(__LINE__ . ":	Adding series to sheet $urkhash{$counter}{SHEET} _2, arraylength=$arraylength,	urkhashrow=$urkhash{$counter}{ROW}\n");
					if ($useperiods) {
						# Hit skall vi bara komma om vi har 2 perioder och vi parsar en bucket raknare.
						if( exists $counterhash{$class}{$counter}{noofgraphs}) {
							$counterhash{$class}{$counter}{noofgraphs} = 2;
							my $s2 = 2 + $counterhash{$object}{$counter}{special_p1};
							my $e2 = 2 + $counterhash{$object}{$counter}{special_p1} + $counterhash{$object}{$counter}{special_p2} - 1;

							$charthash{$urkhash{$counter}{SHEET} }->add_series(
								name => "$object",
								categories => xl_range_formula( $urkhash{$counter}{SHEET}, 0, 0, $s2,$e2 ),
								values => xl_range_formula( $urkhash{$counter}{SHEET}, $urkhash{$counter}{ROW}, $urkhash{$counter}{ROW}, $s2,$e2 ), #C$1:OP$1
							 );
						}
					}else{
					}
				}	# less than 49 data series
				else {
					debugprint(__LINE__ . ":	Skipping data serie addition to graph to avoid Microsoft Excel crash\n");
				}
			}
			else {
 				# Hide row.
#				$worksheet->set_row($mainrow, undef, undef, 1);
#				$sheethash{$counter}->set_row($urkhash{$counter}{row}, undef, undef, 1);
			}
			$mainrow++;
		} # end foreach counter
	} # end foreach object
	print "\nDone.\n";
	
	
	if ($all) {
		$worksheet->insert_chart($mainrow+1, 2, $all_chart, 0, 0, 2, 2);
	}
	
	print "Autofitting main\n";
	autofit_columns($worksheet);
	autofit_columns($infosheet);
	autofit_columns($changesheet);
	print "Done.\n";

	if ($useperiods) {
		print "Calculating average for period1 and period2\n";
		calcAverage(\%filteredhash,\%urkhash,\%sheethash,\%periods,\$workbook,scalar(@time),$noofelements);
#		updateChangeSheet(\%sheethash);
		print "Done.\n";

		print "Filling change data sheet\n";
		print "Done.\n";
	}
	
#		foreach my $sheetname (sort keys %sheethash) {
#			print "++SHEETNAME=$sheetname\n";
#			print "++" . $sheethash{$sheetname} . "\n";
#		}

	print "Autofitting sheets\n";
	foreach my $object (sort keys %counterhash) {
		foreach my $counter (sort keys %{$counterhash{$object}}) {
			autofit_columns($sheethash{$urkhash{$counter}{SHEET}});
		}
	}

#	if ($mom){
#		print "MOM is used	" . %counternamehash . "\n";
#		foreach my $counter (sort keys %counternamehash) {
#			$sheetname = $counter;
#			if (length $sheetname > MAX_SHEET_NAME_LENGTH){
#				$sheetname = substr($sheetname,length ($sheetname) -MAX_SHEET_NAME_LENGTH,MAX_SHEET_NAME_LENGTH);
#			}
#			print "COUNTER=$counter,	SHEETNAME=$sheetname,	MOMINFO=$mominfo{$counter}\n";
#			if (exists $sheethash{$sheetname} and exists $mominfo{$counter}){
#				$sheethash{$sheetname}->write_comment( 1 ,1, $mominfo{$classname}{$counter}{INFO},x_scale => XSCALE,y_scale => YSCALE) if (defined $mom);	# 0 = längst till vänster, $i = rad
#			}
#		}
#	}
	
	$workbook->set_properties(
        title    => 'pmxcel spreadsheet',
        author   => 'Mathias Aldrin',
	company	=> 'Ericsson',
        comments => 'Created with pmxcel.pl v$version',
    );
	$workbook->close() or die "Error closing file: $!";
	print "Done!\n";
#    my $workbookread = $parser->parse($outputfile);
#	if ( !defined $workbookread ) {
#		die $parser->error(), ".\n";
#	}

#	my %changehash;
#	findChangedCounters(\%changehash,\$workbookread);
	if ($debugtofile){
		close (DEBUG);
		close (STDERR);
	}
	exit;

# SUBS
sub find_counters_in_formulas
{
	my $wanted_formula = shift;
	my $formularef = shift;

	foreach my $formula (sort keys %$formularef) {
		foreach my $subformula (sort keys %{$$formularef{$formula}{SUBFORMULA}}) {
			if (exists $$formularef{$formula}{INFO}) {
				if (exists  $$formularef{$subformula}{INFO}) {
					$$formularef{$formula}{INFO} .= "\n$subformula = " . $$formularef{$subformula}{INFO};
				}else{
					$$formularef{$formula}{INFO} .= "";
				}
			}else {
				$$formularef{$formula}{INFO} = "\n$subformula = " . $$formularef{$subformula}{INFO};
			}
			foreach my $reknare (sort keys %{$$formularef{$subformula}{COUNTERS}}){
				$$formularef{$formula}{COUNTERS}{$reknare} = 1;
			}
		}
	}
	
#	foreach my $formula (sort keys %$formularef) {
#		print __LINE__ . ":	Formulaname=$formula	=	$$formularef{$formula}{INFO}\n";
#		foreach my $subformula (sort keys %{$$formularef{$formula}{SUBFORMULA}}) {
#			$$formularef{$formula}{INFO} .= $$formularef{$subformula}{INFO};
#			print __LINE__ . ":		Subformula = $subformula	$$formularef{$subformula}{INFO}\n";
#		}
#	}
}


sub readformulas
{
	my $file = shift;
	my $formularef = shift;
	my ($formulaname,$formula);
	
	if (defined $file) {
		open(FORMULAFILE, $file) || die "can't open formula file: $file\n";
	}else{
		die "Formula file is missing!\n";
	}

	my @FORMULA = <FORMULAFILE>;
	close FORMULAFILE;
	my ($row,$percent,$oldpercent) = (0,0,0);
	foreach (@FORMULA){
		$percent = sprintf ("%3.0f",$row/@FORMULA*100);	$row++;
		print "\r\e[KParsing formulas: $percent%" if ($percent ne $oldpercent);
		$oldpercent = $percent;
		next if ($row =~ /\s*#/);
		if (/(\S+)\s*=\s*(.+)/){
			$formulaname = $1;
			$formula = $2;
		}
#		print __LINE__ . ":	name=$formulaname,	Formula=$formula\n";
		$$formularef{$formulaname}{INFO} = $formula;
		my @counters;
		if (defined $formula){
			@counters = split(/ |,/,$formula);
		}else{
			@counters = ();
		}
		foreach my $word (@counters){
			$word =~ s/\d+//g;
			$word =~ s/\+|\-|\*|\/|\=|\)|\(|\[|\]|\'|\.|log//g;
			chomp $word;
			if ($word =~ /(pm[a-z|A-Z]+)/){ 
				my $reknare = $1;
				#print "$_\n";
				if (exists $$formularef{$formulaname}{COUNTERS}){
					$$formularef{$formulaname}{COUNTERS}{$reknare} += 1;
				}else{
					$$formularef{$formulaname}{COUNTERS}{$reknare} = 1;
				}
			}
			elsif ($word =~ /(\S+)/){	# Har borde smaformler hamna
				my $subformula = $1;
				if (exists $$formularef{$formulaname}{SUBFORMULA}){
					$$formularef{$formulaname}{SUBFORMULA}{$subformula} += 1;
				}else{
					$$formularef{$formulaname}{SUBFORMULA}{$subformula} = 1;
				}
#				print __LINE__ . ":	subformula = $subformula\n";
			}else{
#				print __LINE__ . ":	Other match=$word\n" if ($word);
			}
		}
	}
	
	print "\n";
	find_counters_in_formulas("HEJ",$formularef);
}

sub readmom
{
	my $mom = shift;
	my $momref = shift;
	my $momref2 = shift;
	my $pmomfile = shift;
	print "Reading MOM file $mom\n";
	if (defined $pmomfile){
		readpmom($momref,$momref2,$pmomfile);
		return;
	}
	if ($mom){
		if ($mom =~ /\.gz$/) {
			open(MOM, "gunzip -c $mom |") || die "can't open pipe to $mom";
		}
		else {
			if ($mom =~ /\.xml/){
				open(MOM, "unzip -c $mom |") || die "can't open $mom";
			}else{
				die "\n\'$mom\' is not a proper mom file.\n\n";
			}
		}
	}

	my @MOM = <MOM>;
	my %mumin;
	my ($opentag,$closetag,$solotag,$taginfo,$complete,$cname,$condition,$condflag);
	my $row=0;
	my $percent = 1;
	my $oldpercent = $percent;
	my $separator = $/;
	my $wantedtag = "attribute";
	my $identifier = 'name=\"(pm\w+)';
	my %XML;
	my $classname;
	my $search;

	foreach (@MOM){
		$percent = sprintf ("%3.0f",$row/@MOM*100);	$row++;
		print "\r\e[KParsing mom: $percent%" if ($percent ne $oldpercent);
		$oldpercent = $percent;
		%XML = xmlparse($_);
		if (defined $XML{REST}){
			if ($XML{REST} !~ /^$/ and defined $cname){ 
#				print __LINE__ . ":	MORE REST: cname=$cname,	OPEN=$XML{OPENTAG}, INFO=$XML{TAGINFO},	CLOSE=$XML{CLOSETAG},	REST=\'$XML{REST}\'\n\n";
				$XML{TAGINFO} .= $XML{REST};
				$mumin{$cname}{OPENTAG} = $search;
				$XML{OPENTAG} = $search;
			}
		}
		if (defined $cname){
#			print "cname=$cname\n";
			if ( $cname =~ /pmTransmittedCarrierPowerW/){
#				print __LINE__ . ":	After Parse: cname=$cname,	OPEN=$XML{OPENTAG}, INFO=$XML{TAGINFO},	CLOSE=$XML{CLOSETAG},	REST=$XML{REST},\n\n";
			}
		}
		if (defined $XML{OPENTAG} and $XML{OPENTAG} !~ /^$/){
			if ($XML{OPENTAG} =~ /$wantedtag/){
#				print "Found opentag=$wantedtag\n";
				if ($XML{TAGINFO} =~ /$identifier/){
					$cname = $1;
#					print "Define cname=$cname, identifier=$identifier,\n";
					$mumin{$cname}{OPENTAG} = $XML{OPENTAG};
				}
			} # if xml opentag =~ wantedtag
			if (/class name=\"(\w+)\"/){
				$classname = $1;
			}
			if ($XML{OPENTAG} and !$XML{CLOSETAG}){
				$search = $XML{OPENTAG};
			}

			if (defined $cname) {
				if (defined $mumin{$cname}{OPENTAG}){
					if ($XML{OPENTAG} =~ /description/){
						if (! defined $mumin{$cname}{DESC}){
							$mumin{$cname}{DESC} = "Description:	" . $XML{TAGINFO};
						}else{
							$mumin{$cname}{DESC} .= $XML{TAGINFO};
#							print __LINE__ . ":	DESC=$mumin{$cname}{DESC}\n";
						}
#						$mumin{$cname}{DESC} = "Description:	" . $XML{TAGINFO};
						$mumin{$cname}{CLASSNAME} = $classname;
#						print "DESC=$XML{TAGINFO}\n";
					}elsif ($XML{OPENTAG} =~ /condition/){
						if (! defined $mumin{$cname}{COND}){
							$mumin{$cname}{COND} = "Condition:	" . $XML{TAGINFO};
						}else{
							$mumin{$cname}{COND} .= $XML{TAGINFO};
						}
#						print "$cname	COND=$XML{TAGINFO}\n";
					}elsif ($XML{OPENTAG} =~ /counterReset/){
						$mumin{$cname}{RESET} = "CounterReset:	" . $XML{TAGINFO};
#						print "RESET=$XML{TAGINFO}\n";
					}elsif ($XML{OPENTAG} =~ /counterContext/){
						$mumin{$cname}{CONTEXT} = "CounterContext:	" . $XML{TAGINFO};
#						print "CONTEXT=$XML{TAGINFO}\n";
					}elsif ($XML{OPENTAG} =~ /counterType/){
						$mumin{$cname}{TYPE} = "CounterType:	" . $XML{TAGINFO};
#						print "TYPE=$XML{TAGINFO}\n";
					}elsif ($XML{OPENTAG} =~ /unit/){
						$mumin{$cname}{UNIT} = "Unit:		" . $XML{TAGINFO};
#						print "UNIT=$XML{TAGINFO}\n";
					}
				} # defined XML{OMENTAG}
			} # end if defined $cname
#			print __LINE__ . ":	HEJ	$classname	open=$XML{OPENTAG}	close=$XML{CLOSETAG}	info=$XML{TAGINFO}	wanted=$wantedtag\n" if ($cname =~ /pmTransmittedCarrierPowerWNonHs/);

		} #endif $XML{OPENTAG} $XML{CLOSETAG}	$wantedtag!~ /^$/
		elsif (defined $cname and defined $classname and defined $XML{CLOSETAG} and $XML{CLOSETAG} =~ /$wantedtag/){
			if ($cname =~ /pmTransmittedCarrierPowerW$/){
#				print __LINE__ . ":	SPARA	cname=$cname	class=$classname	DESC=$mumin{$cname}{DESC}\n\n";
			}
			$$momref{$classname}{$cname}{INFO} = "\nCounter:	$classname.$cname\n";
#			$$momref{$cname}{CLASSNAME} = $mumin{$cname}{CLASSNAME};
			#RBS Specials
				if (defined $mumin{$cname}{DESC} and $mumin{$cname}{DESC} =~ /Counter type:\s+(\S+)/){
					$mumin{$cname}{TYPE} = $1;
#					print __LINE__ . ":	Found type in description for cname=$cname,	$mumin{$cname}{TYPE}\n";
				}
				if (defined $mumin{$cname}{UNIT} and $mumin{$cname}{UNIT} =~ /Unit:\s+(\S+)/){
					$mumin{$cname}{UNIT} = $1;
				}
				if (defined $mumin{$cname}{CONTEXT} and $mumin{$cname}{CONTEXT} =~ /CounterContext:\s+(\S+)/){
					$mumin{$cname}{CONTEXT} = $1;
				}
				if (defined $mumin{$cname}{RESET} and $mumin{$cname}{RESET} =~ /CounterReset:\s+(\S+)/){
					$mumin{$cname}{RESET} = $1;
				}
			if (exists $mumin{$cname}{TYPE}){
				$$momref{$classname}{$cname}{INFO} .= "Type:	$mumin{$cname}{TYPE}\n";
				$$momref{$classname}{$cname}{TYPE} = uc "$mumin{$cname}{TYPE}\n";
				$$momref2{$cname}{TYPE} = uc "$mumin{$cname}{TYPE}\n";
#				print __LINE__ . ":	cname=$cname,	class=$classname,	TYPE=$$momref{$classname}{$cname}{TYPE}\n";
			}
			if (exists $mumin{$cname}{UNIT}){
				$$momref{$classname}{$cname}{INFO} .= "Unit:		$mumin{$cname}{UNIT}\n";
				$$momref2{$cname}{UNIT} = "$mumin{$cname}{UNIT}\n";
			}
			if (exists $mumin{$cname}{CONTEXT}){
				$$momref{$classname}{$cname}{INFO} .= "$mumin{$cname}{CONTEXT}\n";
				$$momref2{$cname}{CONTEXT} = "$mumin{$cname}{CONTEXT}\n";
			}
			if (exists $mumin{$cname}{SCANNER}){
				$$momref{$classname}{$cname}{INFO} .= "$mumin{$cname}{SCANNER}\n";
				$$momref2{$cname}{SCANNER} = "$mumin{$cname}{SCANNER}\n";
			}
			if (exists $mumin{$cname}{RESET}){
				$$momref{$classname}{$cname}{INFO} .= "Reset:	$mumin{$cname}{RESET}\n";
				$$momref2{$cname}{RESET} = "$mumin{$cname}{RESET}\n";
			}
			if (exists $mumin{$cname}{DESC}){
				$$momref{$classname}{$cname}{INFO} .= "$mumin{$cname}{DESC}\n";
				$$momref2{$cname}{DESC} = "$mumin{$cname}{DESC}\n";
			}
			if (exists $mumin{$cname}{COND}){
				$$momref{$classname}{$cname}{INFO} .= "$mumin{$cname}{COND}\n";
				$$momref2{$cname}{COND} = "$mumin{$cname}{COND}\n";
#				print __LINE__ . ":	$cname COND: $$momref{$classname}{$cname}{INFO}\n";
			}
			undef %mumin;
			undef $cname;
			undef $search;
			
		} #endif (defined $cname and $XML{CLOSETAG} =~ /$wantedtag/)
		else{
		}
	} # end if foreach mom
	print "Done!\n";
#	print __LINE__ . ":	verifiering av mominfo: " . $$momref{'Ip'}{'pmNoOfIpAddrErrors'}{TYPE} . "\n";
#	print __LINE__ . ":	verifiering av mominfo: " . $$momref{'Ip'}{'pmNoOfIpAddrErrors'}{INFO} . "\n";
#	print __LINE__ . ":	verifiering av mominfo: " . $$momref{'Carrier'}{'pmAverageRssi'}{TYPE} . "\n";
#	print __LINE__ . ":	verifiering av mominfo: " . $$momref{'Carrier'}{'pmAverageRssi'}{INFO} . "\n";
#	print __LINE__ . ":	verifiering av mominfo: " . $$momref{'Carrier'}{'pmTransmittedCarrierPowerW'}{TYPE} . "\n";
#	print __LINE__ . ":	verifiering av mominfo: " . $$momref{'Carrier'}{'pmTransmittedCarrierPowerW'}{INFO} . "\n";
#	exit;
}
sub getTagInfoforTag {
	my $opentag = shift;
	my $closetag = shift;
	my $taginfo = shift;

}

sub xmlparse
{
	my $string = shift;

	my %retur;
	my @multitag;
	my ($opentag,$closetag,$taginfo,$solotag);
#	print "STRING=$string\n" if (!/^$|^s+$/);
	if ($string =~ /<([a-zA-Z]+)>(.*)<*\/*/){
		$opentag = $1;
		$taginfo = $2;
		$taginfo =~ s/<\/\w+[a-zA-Z]>//;
#		print __LINE__ . ":	OPENTAG1=$opentag	TAGINFO1=$taginfo\n";
		if(/<\/+([a-zA-Z]+)>/) {
			$closetag = $1;
#			print __LINE__ . ":	SAME LINE CLOSETAG1=$closetag,	TAGINFO1=$taginfo\n";
		}
#        <mim name="RNC_NODE_MODEL_V" version="1" release="1840" author="ewcdmaci" date="Wed Oct 16 16:16:52 CEST 2013" revision="A">
	}elsif (/<([a-zA-Z]+)\s+\/>/){								# <noNotification />
		$opentag = $1;
		$closetag = $1;
	}
	elsif (/<([a-zA-Z]+)\s+([a-zA-Z]+=\".+)>/){
		$opentag = $1;
		$taginfo = $2;
#		print __LINE__ . ":	OPENTAG2=$opentag,	TAGINFO2=$taginfo,	REPARSE\n";
		@multitag = xmlparse2($taginfo);
#		foreach my $tmp (@multitag) {
#			print "TMP=$tmp\n";
#		}
		$retur{MULTITAG} = 1;
	}elsif(/(.*?)<\/(\w+[a-zA-Z])>/) {
		$taginfo = $1;
		$closetag = $2;
#		print __LINE__ . ":TAGINFO3=$taginfo,	CLOSETAG3=$closetag\n";
	}elsif(/<(\w+\/+)>/) {
		$closetag = $1;
#		print "SOLOTAG=$solotag\n";
	}
	$retur{OPENTAG} = $opentag;
	$retur{CLOSETAG} = $closetag;
	$retur{TAGINFO} = $taginfo;
	if (!defined $opentag and !defined $closetag){
		$retur{REST} = $string;
	}
#	print __LINE__ . ":	RETUR: O=\'$retur{OPENTAG}\',	C=\'$retur{CLOSETAG}\',	I=\'$retur{TAGINFO}\',	R=\'$retur{REST}\'\n";
	return %retur;
}
sub xmlparse2{
	my $string = shift;
	my @retur;
	my @strangs = split(/\" /,$string);
	foreach my $element (@strangs){
		$element =~ s/\"//g;
		push (@retur,$element);
	}
	return @retur;
}

sub readpmom
{
	my $momref = shift;
	my $momref2 = shift;
	my $pmomfile = shift;
	print "Reading pmom file $pmomfile\n";

	if ($pmomfile =~ /\.gz$/) {
		open(MOM, "gunzip -c $pmomfile |") || die "can't open pipe to $pmomfile\n";
	}
	else {
		open(MOM, '<:encoding(UTF-8)', $pmomfile ) || die "can't open $pmomfile\n";
	}

	my @MOM = <MOM>;
	my $state = 0;
	my $info = '';
	my ($classname,$cname,$size,$type,$other,$reset);
	foreach (@MOM){
		if ($state == 0 and /^(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+(.+)/){	#pdf
			$classname = $1;
			$cname = $2;
			$size = $3 . ' ' . $4;
			$other = $5;
		}elsif ($state == 0 and /^(\S+)\s+(\S+)\s+(\S+)\s+(.+)/){	#no pdf
			$classname = $1;
			$cname = $2;
			$size = $3;
			$other = $4;
		}elsif (/^\*\*\*\*\*/){
			$state = 0;
			($reset) = $other =~ /(\w+Reset)(,|$)/;
			($type) = $other =~ /^(\w+),/;
			$info = "\nCOUNTER:	$classname.$cname\n\n" . $info;
			$$momref{$classname}{$cname}{INFO} = $info;
			$$momref{$classname}{$cname}{TYPE} = uc $type;
			$$momref2{$cname}{TYPE} = uc $type; # korkat, borde gora om och ta bort denna variabel
#			print __LINE__ . ":	type=$type,	other=$other,	size=$size,	reset=$reset\n";
		}elsif (/^-----/){
			$state = 1;
			$info = '';
		}elsif($state == 1) {
			$info .= $_;
		}
	}
	close MOM;
}

sub parse_logfile {
	my $object = shift;
	my $counter = shift;
	my $values = shift;
	my $removeclassname = shift;
	my $mode = shift;
	my $showbuckets = shift;
	my $hashref = shift;			#urkhash
	my $hashref2 = shift;			#counterhash
	my $pdflength = 0;
	my $noofrops = 0;
	my @ropvalues;
	my $bucketcounternames;
	my @doublearray;
#	print __LINE__ . ":	values=$values\n";		# values=-102.7; -102.7; -102.7; -102.7; -102.7; -102.7; -102.7; -102.7; -102.7; -102.7; -102.7; -102.7; -102.7; -102.7; -102.7; -102.7; -102.7; -102.7; -102.7; -102.7; -102.7; -102.7; -102.7; -102.7; 
	$object =~ s/[^=]+=// if ($removeclassname);
	if ($values =~ /,/){
		# pdf raknare, gor om till viktat medelvarde om buckets ej är definierat
		$pdflength = pdfLength($values,0);
		if (!defined $buckets) {
			$values = weightedAverage($values,0);
			parse_logfile2($object,$counter,$values,$removeclassname,$mode,$hashref,$hashref2);
		}else {
			$values =~ s/;//;
			@ropvalues = split(/ /,$values);
			$noofrops = @ropvalues;
			my $row=0;	# antal ropfiler =48 for 12h
			my @bucketsum;
			my @savedarray;
			foreach my $rop (@ropvalues) {
				my @buckets = split(/,/,$rop);
				if (($row < $periods{p1}) or ($row >= $periods{s2}) and $row <= $periods{e2}){
					
					if (!@bucketsum){
						@bucketsum = @buckets;
					}else {
						for (my $i=0;$i<scalar @bucketsum;$i++){
							$bucketsum[$i] += $buckets[$i];
						}
					}
				}
				for (my $column = 0; $column < @buckets; $column++) {
					$doublearray[$row][$column] = $buckets[$column];
				}
				$row++;
#print __LINE__ . ":	p1=$periods{p1}\n";
				if ($row == ($periods{p1} +1) ) {
					#skall bara goras pa dar vi visar kolumngraf
		                        my $sumvalues;
        		                foreach (@bucketsum) {
                        		        $sumvalues .= "$_; ";
                        		}
                        		parse_logfile2($object,$counter,$sumvalues,$removeclassname,$mode,$hashref,$hashref2);
#print __LINE__ . ":	P1 buckets=$buckets,	row=$row,	counter=$counter,	sumvalues=$sumvalues\n";
					
                        		$$hashref2{$object}{$counter}{special_p1} = @bucketsum;	#spara antalet element i array
					@savedarray = @bucketsum;
					@bucketsum = ();

				}

				$$hashref2{$object}{$counter}{special} = @bucketsum;

				if (defined $useperiods) {
	                        	if ($row == ($periods{s2} + $periods{p2} ) ){
						#kor endast en gang do vi har bucket raknare och 2 perioder
	                                	my $sumvalues;

	                                	foreach (@bucketsum) {
	                                        	$sumvalues .= "$_; ";
	                                	}
	                                	$$hashref2{$object}{$counter}{special_p2} = @bucketsum;
#print __LINE__ ."	$$hashref2{$object}{$counter}{special_p1};\n";
						my @p1array = @savedarray;	# {values}
						my @p2array = @{[split (/;\s*/,$sumvalues)]};
						@{$$hashref2{$object}{$counter}{values}} = (@p1array,@p2array);
#print __LINE__ . ":	P2 buckets=$buckets,	row=$row,	counter=$counter,	sumvalues=$sumvalues,	bucketsum=@bucketsum,	p1=@p1array,	p2=@p2array, hash=@{$$hashref2{$object}{$counter}{values}}\n";
					}
                        	}
                        }

			my $sumvalues;
			foreach (@bucketsum) {
				$sumvalues .= "$_; ";
			}
			# utan denna rad skapas inget sheet for columngraf
			parse_logfile2($object,$counter,$sumvalues,$removeclassname,$mode,$hashref,$hashref2);
			$$hashref2{$object}{$counter}{special} = @bucketsum; # denna rad kanske inte passar har

			my @transposed;
			for my $row (@doublearray) {#$row = antal MOn
				for my $column (0 .. $#{$row}) { #$column = antal buckets
					push(@{$transposed[$column]}, $row->[$column]);
				}
			}
			my $i=0;
			foreach(@doublearray){
				$i++;
			}
			
			my $newvalues;
			my $index=0;
			foreach my $row (@transposed) {
				for my $column (0 .. $#{$row}) {
					$row->[$column] =~ s/;//;		#Hajar inte riktigt var det extra semikolonet kommer ifrån
					$newvalues .= "$row->[$column]; ";
				}
				$newvalues =~ s/\s*$//;
				parse_logfile2($object,$counter . "_$index",$newvalues,$removeclassname,$mode,$hashref,$hashref2);
				$index++;
				$newvalues = "";
#print __LINE__ . ":SKIT	buckets=$buckets,	counter=$counter i=$index	newval=$newvalues\n";
			}
		}
		$pdf = 1;
	}else{
		# standard raknare
		$pdf = ();
		debugprint (__LINE__. ":PARSELOG:	obj=$object,	cnt=$counter,	mode=$mode,	val=$values\n");
		parse_logfile2($object,$counter,$values,$removeclassname,$mode,$hashref,$hashref2);
	}
}

sub parse_logfile2 {
	my $object = shift;
	my $counter = shift;
	my $values = shift;
	my $removeclassname = shift;
	my $mode = shift;
	my $hashref = shift;			#urkhash
	my $hashref2 = shift;			#counterhash
	my $pdflength = 0;
#	debugprint (__LINE__ . ":PARSELOG2:	obj=$object,	cnt=$counter,	mode=$mode,	val=$values\n");
	if (exists $counternamehash{$counter}{NUMBER}) {
		$counternamehash{$counter}{NUMBER}++;
		if ($counternamehash{$counter}{INDEX} =~ /^Z$/){
			$counternamehash{$counter}{INDEX} = "AA";
		}
	}else{
		$counternamehash{$counter}{NUMBER} = 1;
		$counternamehash{$counter}{INDEX} = "A";
	}
	my $sheetname = $counter;
	my $shortname = $counter;
#print __LINE__ . ":	sheetname=$sheetname,	shortname=$shortname\n";
	if (length $sheetname > MAX_SHEET_NAME_LENGTH){
		$shortname = substr($sheetname,length ($sheetname) - MAX_SHEET_NAME_LENGTH,MAX_SHEET_NAME_LENGTH);
		$sheetname = $shortname;
#		print "0.	counter=$counter,	sheetname=$sheetname,	short=$shortname,	uniq=$uniqsheet{SHEET}{$sheetname},	urk=$$hashref{$counter}{SHEET}	_\n";
		if (exists $uniqsheet{SHEET}{$shortname} ){
#			print "2.	counter=$counter,	sheet=$sheetname,	short=$shortname,	_sheetname exist\n";
			$uniqsheet{SHEET}{$shortname} += 1;
			if (exists $uniqsheet{COUNTER}{$counter}){
				$uniqsheet{COUNTER}{$counter} ++;
#print "=============================\n";
#		foreach my $key1 (sort keys %uniqsheet) {
#			foreach my $key2 (sort keys %{$uniqsheet{$key1}}) {
#				print "key1=$key1=$uniqsheet{SHEET}{$key2}	:		key2=$key2: $uniqsheet{COUNTER}{$key2}\n";
#			}
#			print "\n";
#		}
#print "=============================\n";
			}else{
				if  (!exists $counternamehash{$shortname}{INDEX}){
					$counternamehash{$shortname}{INDEX} = 'A';
				}
				$sheetname = $counternamehash{$shortname}{INDEX} . "_" . $shortname;
				$counternamehash{$counter}{INDEX}++;
				$counternamehash{$shortname}{INDEX}++;
				$uniqsheet{COUNTER}{$counter} ++;
				$uniqsheet{SHEET}{$shortname} ++;
			}
		}else{
			$uniqsheet{SHEET}{$shortname} = 1;
		}
		if (exists $$hashref{$counter}{SHEET}){
		}else{
			$$hashref{$counter}{SHEET} = $sheetname;
		}
	}
	
	if (exists $$hashref2{$object}{$counter}){	#hashref2 = counterhash
#print __LINE__ . ":	counter $counter exists in hashref2\n";
		if (defined $$hashref2{$object}{$counter}{values}){
		#plockade bort denna för den generarade för långa rader, jag vet ej varför jag lagt till den.
			if ($mode =~ /t/){	#txt
				$$hashref2{$object}{$counter}{values} = [@{$counterhash{$object}{$counter}{values}},split (/\s+/,$values)];	#for txt
			}
		}else{
			print __LINE__ . ":	$object.$counter exists but is not defined(has no data)\n";
		}
	}else{
#print __LINE__ . ":	counter $counter does not exist in hashref2. This could be a formula\n";
		if (defined $values) { # la till villkor för att undvika unitialized warningar
#print __LINE__ . ":     values exists.	values=$values\n";
			if ($mode =~ /c/){	#csv
				$$hashref2{$object}{$counter}{values} = [split (/;\s*/,$values)];
#print __LINE__ . ":     csv mode\n";
			}else{	#txt
#print __LINE__ . ":     txt mode\n"; 
				$$hashref2{$object}{$counter}{values} = [split (/\s+/,$values)];
			}
		}
	}
	if (!exists $$hashref{$counter}{SHEET}){
		$$hashref{$counter}{SHEET} = $counter;
#print __LINE__ . ":	adding sheet, $counter, to hashref\n";
	}

	$$hashref2{$object}{$counter}{type} = $pdf;
	my $sum=0;
	my $pos;
	for (@{${$counterhash{$object}}{$counter}{values}}) {
		if ($_ !~ /^$/) {
			if (/^-*\d+/){	# ta bort varning da sum = N/A, Maste hanter negativa varden i formler
				$sum += $_;
			}
		}else{
		}
	}
#print __LINE__ . ":	sum=$sum\n";
	$$hashref{$counter}{sum} += $sum;
	$$hashref{$counter}{SUM} += $sum;
}

sub periods_check {
	my ($s1b,$s2b,$e1b,$e2b);
	if ($useperiods) {
		$s1b = previous_rop($s1);
		$s2b = previous_rop($s2);
		$e1b = previous_rop($e1);
		$e2b = previous_rop($e2);
		my $index = index("@time", $s1)/$denominator;
		my @resttime = @time[$index..@time-1];
		if ($debug == 1) {
			debugprint ("time=" . @time . "\n");
			debugprint ("index=$index\n");
			debugprint ("s1 index($s1) = " . ceil(index("@time", $s1)) . "\n");
			debugprint ("e1 index($e1) = " . ceil(index("@resttime", $e1)) . "\n");
			debugprint ("s2 index($s2) = " . ceil(index("@resttime", $s2)) . "\n");
			debugprint ("e2 index($e2) = " . ceil(index("@resttime", $e2)) . "\n");
			debugprint ("resttime=@resttime	s1=$s1	index=$index\n");
		}
		$periods{s1} = ceil(index("@time", $s1)) / $denominator;
		$periods{s1b} = ceil(index("@time", $s1b)) / $denominator;
		$periods{e1} = $index + ceil(index("@resttime", $e1)) / $denominator;
		$periods{e1b} = $index + ceil(index("@resttime", $e1b)) / $denominator;
		$periods{s2} = $index + ceil(index("@resttime", $s2)) / $denominator;
		$periods{s2b} = $index + ceil(index("@resttime", $s2b)) / $denominator;
		$periods{e2} = $index + ceil(index("@resttime", $e2)) / $denominator;
		$periods{e2b} = $index + ceil(index("@resttime", $e2b)) / $denominator;

		$noofexpectedrops = $periods{e1} - $periods{s1} + 1 + $periods{e2} - $periods{s2} + 1;
		print "Number of expected rops: $periods{s1} -> $periods{e1} + $periods{s2} -> $periods{e2} = $noofexpectedrops\n";

		if ($debug == 1) {
			print "Previous rops:	s1b=$s1b,	e1b=$e1b,	s2b=$s2b,	e2b=$e2b\n";
			print "Previous rop indexes:	s1b=$periods{s1b},	e1b=$periods{e1b},	s2b=$periods{s2b},	e2b=$periods{e2b}\n";
		}
	} # end useperiods
	else {
		$periods{s1} = 0;
		$periods{e1} = @time -1;
		$periods{s2} = @time -1;
		$periods{e2} = @time -1;
	}

	print "periods_s1=$periods{s1}, periods_e1=$periods{e1}, periods_s2=$periods{s2}, periods_e2=$periods{e2}\n";
	if (($periods{s1} > $periods{e1}) || ($periods{s2} > $periods{e2}) || ($periods{s1} > $periods{s2}) || ($periods{e1} > $periods{s2})){
		print "Please check your syntax of s1,e1 s2,e2\n";
		print "s1>e1	" . ($periods{s1} > $periods{e1}) ."\n";
		print "s2>e2	" . ($periods{s2} > $periods{e2}) ."\n";
		print "s1>s2	" . ($periods{s1} > $periods{s2}) ."\n";
		print "e1>s2	" . ($periods{e1} > $periods{s2}) ."\n";
		print "s1 index = $periods{s1},	e1 index = $periods{e1},	s2 index = $periods{s2},	e2 index = $periods{e2}\n\n";
		print "s1=$s1,	e1=$e1,	s2=$s2,	e2=$e2\n";
		if ($periods{s1} < 1 and $periods{s1b} >= 1){
			print "s1 ($s1) is not found in input file but one rop before ($s1b) is found. Maybe you specified wrong e2. You could try $s1b.\n\n";
		}
		if ($periods{e1} < 1 and $periods{e1b} >= 1){
			print "e1 ($e1) is not found in input file but one rop before ($e1b) is found. Maybe you specified wrong e2. You could try $e1b.\n\n";
		}
		if ($periods{s2} < 1 and $periods{s2b} >= 1){
			print "s2 ($s2) is not found in input file but one rop before ($s2b) is found. Maybe you specified wrong e2. You could try $s2b.\n\n";
		}
		if ($periods{e2} < 1 and $periods{e2b} >= 1){
			print "e2 ($e2) is not found in input file but one rop before ($e2b) is found. Maybe you specified wrong e2. You could try $e2b.\n\n";
		}
		print "time=@time\n";
		print "EXITING THE PROGRAM DUE TO ERRORS!";
		exit;
	}
}

sub previous_rop
{
	my $currentrop = shift;
	my $previousrop = -1;
	my ($year,$month,$day,$hour,$minute) = $currentrop =~ /(\d{4})-(\d{2})-(\d{2}) (\d{2}):(\d{2})/;
	if ($minute == 45){
		$minute = 30;
	}elsif ($minute == 30){
		$minute = 15;
	}elsif ($minute == 15){
		$minute = "00";
	}elsif ($minute == 0){
		$minute = 45;
		if ($hour > 0){
			$hour--;
		}else{
			$hour = 23;
			if ($day > 1){
				$day--;
			}else{
				if ($month == 1){
					$day = 31;
					$month = 12;
					$year--;
				}elsif ($month == 2){
					$day = 31;
					$month = "01";
				}elsif ($month == 3){ # skiter i skott�r
					$day = 28;
					$month = "02";
				}elsif ($month == 4){
					$day = 31;
					$month = "03";
				}elsif ($month == 5){
					$day = 30;
					$month = "04";
				}elsif ($month == 6){
					$day = 31;
					$month = "05";
				}elsif ($month == 7){
					$day = 30;
					$month = "06";
				}elsif ($month == 8){
					$day = 31;
					$month = "07";
				}elsif ($month == 9){
					$day = 31;
					$month = "08";
				}elsif ($month == 10){
					$day = 30;
					$month = "09";
				}elsif ($month == 11){
					$day = 31;
					$month = "10";
				}elsif ($month == 12){
					$day = 30;
					$month = "11";
				}
			} # $day = 1
		} # $hour = 1
	} # $minute = 0;
	if ($hour < 10) {
		$hour = "0$hour";
	}
	$previousrop = "$year-$month-$day $hour:$minute";

	return $previousrop;
}

sub debugprint
{
	if ($debug) {
		my $textstring = shift;
		if ($debugtofile){
			print DEBUG __FILE__ . ": $textstring";
		}else{
			print __FILE__ . ": $textstring";
		}
	}
}

sub weightedAverage
{
	my $string = shift;
	my $type = shift;
	my @tmp;
	if ($type == 1){		# text
		 @tmp = split (/\s+/,$string);		#$values => $string, tryckfelsnisse var framme tror jag
	}elsif ($type == 0){	# csv
		@tmp = split (/;\s+/,$string);
	}else{
		print "Type is not correct: \$type = $type\n";
		exit;
	}
	my $result;
	foreach my $val (@tmp) {
		my @arr = split (/,/,$val);
		my $pos = 1;
		my $sum = 0;
		foreach (@arr) {
			$sum+= $pos++ * $_;
		}
		if ($type == 1){
			$result .= $sum . "	";
		}else{
			$result .= $sum . "; "
		}
#		print "$object,	$counter,	sum=$sum,	pos=$pos,	:	val=$val	: values=$values\n";
	}
	if (defined $result) {
		if ($type == 1){
			$result =~ s/\s+$//;		#text
		}else{
			$result =~ s/;\s+$//;		#csv
		}
	}
	return $result;
}

sub pdfLength
{
	my $string = shift;
	my $type = shift;
	my @tmp;
	if ($type == 1){		# text
		 @tmp = split (/\s+/,$string);		#$values => $string, tryckfelsnisse var framme tror jag
	}elsif ($type == 0){	# csv
		@tmp = split (/;\s+/,$string);
	}else{
		print "Type is not correct: \$type = $type\n";
		exit;
	}
	@tmp = split (/,/,$tmp[0]);
	return @tmp
}
				
# ********************* MATH FUNCTIONS ******************

	sub percentile
	{
		my $arrayref = shift;
		if (@$arrayref eq 0) {
			die("Empty array\n");
		}

		# Sort the data
		my @data_sorted = sort { $a <=> $b } @$arrayref;	# ger varning pga tomma räknarvärden, Use of uninitialized value in sort at /home/eraaldr/bin/pmxcel2.pl line 1059, <INFILE> line 3926
		
		# Calculate the position
		my $pos = round( scalar(@$arrayref) * ( $percentilelevel / 100 ) );
		
		# Print the data set
#		print "Data: " . join(",", @$arrayref) . "\n";
#		print "Sorted: " . join(",", @data_sorted) . "\n";

		# Print the Nth percentile
#		print $percentilelevel . "th Percentile: " . $data_sorted[$pos - 1] . "\n";
		return  $data_sorted[$pos - 1];
	}
	sub round {
		return int($_[0] + .5 * ($_[0] <=> 0));
	}

	sub mean {
		return sum(@_)/@_;
	}
	sub average{
		my $data = shift;
		if (not @$data) {
			die("Empty array\n");
		}
#		print "DATA=$data\n";
		my $total = 0;
		my $size = @$data;
#		print "size of array= $size\n";
		foreach (@$data) {
#			print "total=$total,	$_\n";
			$total += $_ if ($_);		#måste kolla så att arrayen ej saknar värden.
		}
		my $average = $total / @$data;
#		print "Average=$average\n";
		return $average;
	}
	sub mean2{
		my $arrayref = shift;
		if (@$arrayref eq 0) {
			die("Empty array\n");
		}
		my $result;
		foreach (@$arrayref) { $result += $_ if ($_) }	#måste kolla så att arrayen ej saknar värden.
		return $result / @$arrayref;
	}
	sub median
	{
		my $ref = shift;
		if (@$ref eq 0) {
			die("Empty array\n");
		}
		my @vals = sort {$a <=> $b} @$ref;	# ger varning pga tomma räknarvärden, Argument "" isn't numeric in sort at /home/eraaldr/bin/pmxcel.pl line 794
		my $len = @vals;
		if($len%2) #odd?
		{
			return $vals[int($len/2)];
		}else #even
		{
			return ($vals[int($len/2)-1] + $vals[int($len/2)])/2;
		}
	}
	sub stdev{
		my $data = shift;
		if(@$data == 1){
			return 0;
#			print "0000000000000000000\n";
		}
		my $average = &average($data);
		my $sqtotal = 0;
		foreach(@$data) {
			$sqtotal += ($average-$_) ** 2;
		}
		my $std = ($sqtotal / (@$data-1)) ** 0.5;
#		print "stddev=$std\n";
		return $std;
	}

# This is a band pass filter based on a Rats program by Eduard Pelz,
# itself based on the paper "The Band Pass Filter" by Lawrence
# J. Christiano and Terry J. Fitzgerald (1999).
# Inputs: ($pu,$pl,@x) all in one array, where
# @x  - series of data 
# $pu - maximum period of oscillation of desired component (2<=pl<pu<infinity).
# $pl - minimum period of oscillation of desired component
# Output: @fx, array with filtered data
# Recommended: for quarterly data, $pl=6, $pu=32 returns component 
# with periods between 1.5 and 8 yrs, or for monthly data: $pl=2, $pu=24 
# returns component with all periods less than 2 yrs.
# Note: When feasible, we recommend dropping 2 years of data from the beginning
# and end of the filtered data series.  These data are relatively poorly estimated.

sub bpfilter{
	my $arrayref = shift;
	my $pu = shift;
	my $pl = shift;
	my $arrayref2 = shift;
#	print "ref=$arrayref\n";
#	print "array=@$arrayref\n";
#	print "array[1]=$$arrayref[1]\n";
	my @x = @$arrayref;
#*******************************************************************
#*This section is designed to remove the drift from a time series using
#*the formula:  drift = [x(m) - x(startl)] / (m-1).
#*******************************************************************
	use constant PI => 4*atan2(1,1);
	my $m=$#x;
	my $undrift=1;
	my $drift=0;
	if($undrift==1) {$drift=($x[$m]-$x[1])/($m-1)}
	my @xun;
	for(my $i=1;$i<=$m;$i++) {$xun[$i]=$x[$i]-$drift*($i-1)}

#*******************************************************************
#*Create the ideal B's then construct the AA matrix.
#*******************************************************************

	my $b = 2*PI/$pl;
	my $a = 2*PI/$pu;
	my $bnot = ($b-$a)/PI;
	my $bhat = $bnot/2;
	my @bb;
	my @bb2;
	for(my $i=1;$i<=$m;$i++) {$bb[$i]=(sin($i*$b)-sin($i*$a))/($i*PI)}
	for(my $i=1;$i<$m;$i++) {$bb2[$i+1]=$bb[$i]}
	$bb2[1]=$bnot;
	my @AA;
	for(my $i=1;$i<=$m;$i++){
		my $k=1;
		for(my $j=$i;$j<=$m;$j++){
			$AA[$i][$j]=$bb2[$k];
			$AA[$j][$i]=$bb2[$k];
			$k++;
		}
	}
	$AA[1][1]=$bhat;
	$AA[$m][$m]=$bhat;
	for(my $i=1;$i<$m;$i++){
		$AA[$i+1][1]=$AA[$i][1]-$bb2[$i];
		$AA[$m-$i][$m]=$AA[$i][1]-$bb2[$i];
	}
	my @fx;
	for(my $i=1;$i<=$m;$i++){
		$fx[$i]=0;
		for(my $j=1;$j<=$m;$j++){
			$fx[$i]+=$AA[$i][$j]*$xun[$j];
		}
	}
	shift(@fx);
#	$fx[0]=sin(PI/2);
	return @fx;
}
	
# *************** END MATH FUNCTIONS *****************

sub arraysearch {
	my $ref = shift;
	my $patt = shift;
	if (not $ref) {
		die("Empty search array\n");
	}
	my $index = -1;
	foreach (@$ref) {
		if ($patt =~ $_){
			last;
		}else {
			$index++;
		}
	}
	return $index+1;
}

# ****************************************************
	sub findChangedCounters
	{
		my $hashref = shift;
		my $workbookref = shift;
		
		my @sheets = $$workbookref->worksheets();
		my ($name,$row_min,$row_max,$col_min,$col_max,$startcell,$slutcell,$ratio,$row,$cell,$value);
		foreach $worksheet (@sheets) {
			$name = $worksheet->get_name();
			$row = 1;
			if ($name !~ /(All|Changes)/){
				( $row_min, $row_max ) = $worksheet->row_range();
				( $col_min, $col_max ) = $worksheet->col_range();
				$startcell = xl_rowcol_to_cell($row_min,$col_min);
				$slutcell = xl_rowcol_to_cell($row_max,$col_max);
				while ($row <= $row_max){
					$cell = $worksheet->get_cell($row, $col_max);
					$value = $cell->unformatted();
#					print "$name	($row_min,$col_min)	($row_max,$col_max)	=	($startcell,$slutcell)	row=$row	value=$value\n";
					$row++;
				}
			}
		}
	}

    sub calcAverage
	{
		my $hashref = shift;	# %filteredhash
		my $hashref2 = shift;	# %urkhash
		my $sheetref = shift;	# %sheethash
		my $periodref = shift;	# %periods
		my $workbookref = shift;
		my $datasize = shift;
		my $noofelements = shift;

		my @sheets = $$workbookref->sheets();
#		foreach $worksheet (@sheets) {
#			print $worksheet->get_name() . "\n";
#		}
		my %hashrow;
		my ($percent,$oldpercent);
		my $currentelement = 0;
		foreach my $object (sort keys %$hashref) {
			foreach my $counter (sort keys %{${$hashref}{$object}}) {
				$percent = sprintf ("%3.0f",$currentelement/$noofelements*100);
				print "\r\e[K ($percent%)" if (defined $oldpercent and $percent > $oldpercent);
				$currentelement++;
				
				if (exists $hashrow{$counter}){
					$hashrow{$counter}++;
				}else{
					$hashrow{$counter} = 1;
				}

				if ($buckets and $counter =~ /_/) {
					my $sheetname = $urkhash{$counter}{SHEET};
					my $sheet = $$sheetref{$sheetname};
					my $startcell = xl_rowcol_to_cell($hashrow{$counter},2+$$periodref{s1});
					my $slutcell = xl_rowcol_to_cell($hashrow{$counter},2+$$periodref{e1});
					my $avgstring = "=AVERAGE($startcell:$slutcell)";
					my $medianstring = "=MEDIAN($startcell:$slutcell)";
					my $pp = $percentilelevel/100;
					my $percentilestring = "=PERCENTILE($startcell:$slutcell,$pp)";
					my $stdstring = "=STDEV($startcell:$slutcell)";

					$$sheetref{$sheetname}->write($hashrow{$counter},$datasize+3, $avgstring);
					$$sheetref{$sheetname}->write($hashrow{$counter},$datasize+6, $medianstring);
					$$sheetref{$sheetname}->write($hashrow{$counter},$datasize+9, $percentilestring);
					$$sheetref{$sheetname}->write($hashrow{$counter},$datasize+12, $stdstring);
				
					$startcell = xl_rowcol_to_cell($hashrow{$counter},2+$$periodref{s2});
					$slutcell = xl_rowcol_to_cell($hashrow{$counter},2+$$periodref{e2});
					$avgstring = "=AVERAGE($startcell:$slutcell)";
					$medianstring = "=MEDIAN($startcell:$slutcell)";
					$percentilestring = "=PERCENTILE($startcell:$slutcell,$pp)";
					$stdstring = "=STDEV($startcell:$slutcell)";
					$$sheetref{$sheetname}->write($hashrow{$counter},$datasize+4, $avgstring);
					$$sheetref{$sheetname}->write($hashrow{$counter},$datasize+7, $medianstring);
					$$sheetref{$sheetname}->write($hashrow{$counter},$datasize+10, $percentilestring);
					$$sheetref{$sheetname}->write($hashrow{$counter},$datasize+13, $stdstring);
				
					my ($avgformat,$medianformat,$percentileformat,$stdevformat);
					if (($filteredhash{$object}{$counter}{avgratio} > 100+$warninglevel) || ($filteredhash{$object}{$counter}{avgratio} < 100-$warninglevel)){
						$avgformat = $workbook->add_format( fg_color => $colors{red});
					}else{
						$avgformat = $workbook->add_format( fg_color => $colors{white});
					}
					if (($filteredhash{$object}{$counter}{medianratio} > 100+$warninglevel) || ($filteredhash{$object}{$counter}{medianratio} < 100-$warninglevel)){
						$medianformat = $workbook->add_format( fg_color => $colors{red});
					}else{
						$medianformat = $workbook->add_format( fg_color => $colors{white});
					}
					if (($filteredhash{$object}{$counter}{percentileratio} > 100+$warninglevel) || ($filteredhash{$object}{$counter}{percentileratio} < 100-$warninglevel)){
						$percentileformat = $workbook->add_format( fg_color => $colors{red});
					}else{
						$percentileformat = $workbook->add_format( fg_color => $colors{white});
					}
					if (($filteredhash{$object}{$counter}{stdevratio} > 100+$warninglevel) || ($filteredhash{$object}{$counter}{stdevratio} < 100-$warninglevel)){
						$stdevformat = $workbook->add_format( fg_color => $colors{red});
					}else{
						$stdevformat = $workbook->add_format( fg_color => $colors{white});
					}

					$startcell = xl_rowcol_to_cell($hashrow{$counter},$datasize+3);
					$slutcell = xl_rowcol_to_cell($hashrow{$counter},$datasize+4);
					$avgstring = "=(100*$startcell/$slutcell)";
					$$sheetref{$sheetname}->write($hashrow{$counter},$datasize+5, $avgstring,$avgformat);
				
					$startcell = xl_rowcol_to_cell($hashrow{$counter},$datasize+6);
					$slutcell = xl_rowcol_to_cell($hashrow{$counter},$datasize+7);
					$medianstring = "=(100*$startcell/$slutcell)";
					$$sheetref{$sheetname}->write($hashrow{$counter},$datasize+8, $medianstring,$medianformat);

					$startcell = xl_rowcol_to_cell($hashrow{$counter},$datasize+9);
					$slutcell = xl_rowcol_to_cell($hashrow{$counter},$datasize+10);
					$percentilestring = "=(100*$startcell/$slutcell)";
					$$sheetref{$sheetname}->write($hashrow{$counter},$datasize+11, $percentilestring,$percentileformat);

					$startcell = xl_rowcol_to_cell($hashrow{$counter},$datasize+12);
					$slutcell = xl_rowcol_to_cell($hashrow{$counter},$datasize+13);
					$stdstring = "=(100*$startcell/$slutcell)";
					$$sheetref{$sheetname}->write($hashrow{$counter},$datasize+14, $stdstring,$stdevformat);

					if ($hashrow{$counter} ==1){
						$$sheetref{$sheetname}->write(0,$datasize+3, "P1 Average",$writeformat{YELLOW});
						$$sheetref{$sheetname}->write(0,$datasize+4, "P2 Average",$writeformat{YELLOW});
						$$sheetref{$sheetname}->write(0,$datasize+5, "P1 avg / P2 avg*100",$writeformat{YELLOW});
						$$sheetref{$sheetname}->write(0,$datasize+6, "P1 Median",$writeformat{RED});
						$$sheetref{$sheetname}->write(0,$datasize+7, "P2 Median",$writeformat{RED});
						$$sheetref{$sheetname}->write(0,$datasize+8, "P1 Median/P2 Median*100",$writeformat{RED});
						$$sheetref{$sheetname}->write(0,$datasize+9, "P1 Percentile $percentilelevel%",$writeformat{GREEN});
						$$sheetref{$sheetname}->write(0,$datasize+10, "P2 Percentile $percentilelevel%",$writeformat{GREEN});
						$$sheetref{$sheetname}->write(0,$datasize+11, "P1 per / P2 per *100",$writeformat{GREEN});
						$$sheetref{$sheetname}->write(0,$datasize+12, "P1 Standard Deviation",$writeformat{MAGENTA});
						$$sheetref{$sheetname}->write(0,$datasize+13, "P2 Standard Deviation",$writeformat{MAGENTA});
						$$sheetref{$sheetname}->write(0,$datasize+14, "P1 stdev / P2 stdev*100",$writeformat{MAGENTA});
					}
				}
			}
		}
	}

	
    sub autofit_columns {
        my $worksheet = shift;
		$worksheet->freeze_panes("C2") if (defined $worksheet);
        my $col       = 0;
        for my $width (@{$worksheet->{__col_widths}}) {
            $worksheet->set_column($col, $col, $width) if $width;
            $col++;
        }
    }

    sub store_string_widths {
    
        my $worksheet = shift;
        my $col       = $_[1];
        my $token     = $_[2];
    
        # Ignore some tokens that we aren't interested in.
        return if not defined $token;       # Ignore undefs.
        return if $token eq '';             # Ignore blank cells.
        return if ref $token eq 'ARRAY';    # Ignore array refs.
        return if $token =~ /^=/;           # Ignore formula
    
        # Ignore numbers
#        return if $token =~ /^([+-]?)(?=\d|\.\d)\d*(\.\d*)?([Ee]([+-]?\d+))?$/;
    
        # Ignore various internal and external hyperlinks. In a real scenario
        # you may wish to track the length of the optional strings used with
        # urls.
        return if $token =~ m{^[fh]tt?ps?://};
        return if $token =~ m{^mailto:};
        return if $token =~ m{^(?:in|ex)ternal:};
    
    
        # We store the string width as data in the Worksheet object. We use
        # a double underscore key name to avoid conflicts with future names.
        #
        my $old_width    = $worksheet->{__col_widths}->[$col];
        my $string_width = string_width($token);
    
        if (not defined $old_width or $string_width > $old_width) {
            # You may wish to set a minimum column width as follows.
            #return undef if $string_width < 10;
    
            $worksheet->{__col_widths}->[$col] = $string_width;
        }
    
    
        # Return control to write();
        return undef;
    }
    
    
    sub string_width {
    
        return 1.0 * length $_[0];
    }
    
    sub set_properties {
		my $workbook = shift;
		$workbook->set_properties(
			title    => 'pm counter visualtzation',
			author   => 'Mathias Aldrin',
			comments => "Created with pmxcel.pl v$version",
			);
	}

	
sub create_info_sheet
{
	my $bookref = shift;
	my $inforef = shift;
	my $useperiods = shift;
	my $percentile = shift;
	my $mom = shift;
	my $counterhashref = shift;
	my $sheethashref = shift;
	my $formfile = shift;

	my $r=0;
	$$inforef = $$bookref->add_worksheet('Information');
	$$inforef->add_write_handler(qr[\w], \&store_string_widths);
	$$inforef->write( $r++,0, "Excelsheet created with pmxcel.pl",$writeformat{CYAN});	
	$$inforef->write( $r++,0, "Version: $version",$writeformat{CYAN});
	$$inforef->write( $r++,0, "Author: Mathias Aldrin",$writeformat{CYAN});
	$r++;
	$$inforef->write( $r++,0, "Original input file: $filename");
	$$inforef->write( $r++,0, "Original output file: $outputfile");
	if (defined $formfile){
		$$inforef->write( $r++,0, "Formula file: $formfile");
	}
	$$inforef->write( $r++,0, "Input type: $mode");
	$r++;
	$$inforef->write( $r++,0, "First ROP: $firstdate");
	$$inforef->write( $r++,0, "Last ROP: $lastdate");
	if ($useperiods){
		$$inforef->write( $r++,0, "Period1: $s1 - $e1");
		$$inforef->write( $r++,0, "Period2: $s2 - $e2");
		$r++;
		$$inforef->write( $r++,0, "Warning level: $warninglevel%");
#		$infosheet->write( $r++,0, "Min Avg: $minAvg%");
		if ($percentile){
			$$inforef->write( $r++,0, "Percentile is used to detect changes");
			$$inforef->write( $r++,0, "Percentile level: $percentilelevel%");
		}else{
			$$inforef->write( $r++,0, "Mean value is used to detect changes");
		}
	}
	$r++;
	$$inforef->write( $r++,0, "Colour explanation:",$writeformat{BOLD});
	$$inforef->write( $r,0, "Lime:           PEG counters are stepped for this MO",$writeformat{NON_EMPTY});
	$$inforef->write_comment( $r++,0, "A peg counter is increased at each occurrence of a specific activity.\nIt can be increased by one or another value, for example to accumulate the number of bits transferred due to specific activity.",x_scale => 6,y_scale => 1);
	$$inforef->write( $r++,0, "Light yellow:  counters are missing for one or more ROPS",$writeformat{MISSING_ROP});
	$$inforef->write( $r++,0, "Magenta:        counters are missing for all ROPS",$writeformat{EMPTY});
	$$inforef->write( $r++,0, "White Italic:   counters are 0 for all ROPS",$writeformat{ITALIC});
	$$inforef->write( $r,0, "Silver:          stepped PDF counters",$writeformat{PDF});
	$$inforef->write_comment( $r++,0, "A Probability Density Function (PDF) counter is a list of range values.\nA value is sampled (read) periodically.\nIf the value falls within a certain range, the range counter for that range is increased.\nAll range counter values are collected and stored in a Result Output Period (ROP) file at the end of each reporting period.",x_scale => 6,y_scale => 1);
	if ($mom) {
		$$inforef->write( $r,0, "Light blue:    stepped GAUGE counters",$writeformat{GAUGE});
		$$inforef->write_comment( $r++,0, "A gauge counter that is increased or decreased depending on the activity in the system.",x_scale => 6,y_scale => 1);
		$$inforef->write( $r,0, "Light red:     stepped ACC counters",$writeformat{ACC});
		$$inforef->write_comment( $r++,0, "An accumulator counter that is increased by the value of a sample.\nIt indicates the total sum of all sample values taken during a certain time.\nThe name of an accumulator counter begins either with pmSum or pmSumOfSamp.",x_scale => 6,y_scale => 1);
		$$inforef->write( $r,0, "Cyan:          stepped SCAN counters",$writeformat{SCAN});
		$$inforef->write_comment( $r++,0, "A scan counter that is increased by 1 each time the corresponding accumulator counter is increased.\nIt indicates how many samples have been read and added to the related accumulator counter.\nA scan counter can, therefore, be considered a type of peg counter.\nDue to these types of counters, it is possible to get the average value of all samples by dividing the accumulator counter by the scan counter.\nThe name of a scan counter begins with pmSamples or pmNoOfSamp.\n\nNote:  Scan counters are not reset by feature deactivation, only at board restart.",x_scale => 6,y_scale => 2);
		$$inforef->write( $r,0, "Orange:          stepped TrigACC counters",$writeformat{TRIGACC});
		$$inforef->write_comment( $r++,0, "Sum of all values accumulated during the ROP at the occurrence of the defined trigger.\n\nTrigACC and TrigSCAN counter pairs define general purpose counters for averaging of any type of value.\nValues are added to the TrigACC counter when a defined trigger occurs and the number of occurrences of the trigger is held in the corresponding TrigSCAN counter.\nAn average value can be calculated by TrigACC / TrigSCAN.\nA trigger can be anything, for example, an incoming 3GPP message, an internal system event or similar, and is defined for each counter pair.",x_scale => 6,y_scale => 2);
		$$inforef->write( $r,0, "Pink:          stepped TrigSQR counters",$writeformat{TRIGSQR});
		$$inforef->write_comment( $r++,0, "Sum of square of all values accumulated during the ROP at the occurrence of the defined trigger.",x_scale => 6,y_scale => 1);
		$$inforef->write( $r,0, "Purple:          stepped TrigSCAN counters",$writeformat{TRIGSCAN});
		$$inforef->write_comment( $r++,0, "Number of occurrences of the defined trigger during the ROP.\n\nTrigACC and TrigSCAN counter pairs define general purpose counters for averaging of any type of value.\nValues are added to the TrigACC counter when a defined trigger occurs and the number of occurrences of the trigger is held in the corresponding TrigSCAN counter.\nAn average value can be calculated by TrigACC / TrigSCAN.\nA trigger can be anything, for example, an incoming 3GPP message, an internal system event or similar, and is defined for each counter pair.",x_scale => 6,y_scale => 2);
		$$inforef->write( $r,0, "Yellow:          stepped DDM counters",$writeformat{DDM});
		$$inforef->write_comment( $r++,0, "DMM",x_scale => 6,y_scale => 1);
		$$inforef->write( $r,0, "Blue:          stepped SQR counters",$writeformat{SQR});
		$$inforef->write_comment( $r++,0, "SQR",x_scale => 6,y_scale => 1);
#		$$inforef->write_comment( $r++,0, "");
	}
	$r++;
	$$inforef->write( $r++,0, "Pdf counters are presented as weighted average of their buckets (weight = bucket position)",$writeformat{PDF});


	my ($obj,$cnt,%tmp,$uniq,$pdfs,%tmp2,$uobj,$urk);
	$obj=0; $cnt=0, $pdfs=0,$uobj=0;
	foreach my $object (sort keys %$counterhashref) {
		$cnt += scalar keys %{$$counterhashref{$object}};
		($urk) = $object =~ /.+?,([^=]+)=[\d|\w]+$/;
		$tmp2{$urk} = 1 if (defined $urk);	# la till villkor för att undvika unitialized warningar
		foreach my $counter (sort keys %{$$counterhashref{$object}}) {
			if (!exists $tmp{$counter} and $$counterhashref{$object}{$counter}{type}){
				$pdfs+=1;
			}
			$tmp{$counter} = 1;
		}
	}
	$obj = scalar keys %counterhash;
	$uniq = scalar keys %tmp;
	$uobj = scalar keys %tmp2;
	$r++;
	$$inforef->write( $r++,0, "Counter stats",$writeformat{BOLD});
	$$inforef->write( $r++,0, "$cnt counters and $obj objects found in log file");
	$$inforef->write( $r++,0, "$uobj unique class names found in log file");
	$$inforef->write( $r++,0, "$uniq unique counter names found in log file");
	$$inforef->write( $r++,0, "$pdfs unique pdf counter names found in log file");
	$$inforef->write( $r++,0, ((scalar keys %$sheethashref) +2) . " different sheets");
	$r++;
#	$$inforef->write( $r++,0, "OBS! If Microsoft Excel complain about xls file then try to open document using Libre Office.",$writeformat{RED});

	$$inforef->set_first_sheet();
	$$inforef->activate();
	
}
sub prep_change_sheet {
	my $s1 = shift;
	my $e1 = shift;
	my $s2 = shift;
	my $e2 = shift;
	print "s1=$s1,	e1=$e2,	s2=$s2,	e2=$e2\n";
#				my @period1slice = @{${$counterhash{$object}}{$counter}{values}}[$s1..$e1];
#					my @period2slice = @{${$counterhash{$object}}{$counter}{values}}[$s2..$e2];
#					my @beforep1 = @{${$counterhash{$object}}{$counter}{values}}[0..($s1-1)];
#					my @afterp2 = @{${$counterhash{$object}}{$counter}{values}}[($s2+1)..@time-1];
#					my @period1slice = @{${$counterhash{$object}}{$counter}{values}}[$periods{s1}..$periods{e1}];
#					my @period2slice = @{${$counterhash{$object}}{$counter}{values}}[$periods{s2}..$periods{e2}];
#					my @beforep1 = @{${$counterhash{$object}}{$counter}{values}}[0..($periods{s1}-1)];
#					my @afterp2 = @{${$counterhash{$object}}{$counter}{values}}[($periods{e2}+1)..@time-1];

#					my @afterp2 = @{${$counterhash{$object}}{$counter}{values}}[($periods{e2}+1)..$arraylength-2];
#					percentile(\@period1slice);
#					print "slices:	beforep1=" . @beforep1 . "	slice1=" . @period1slice . " slice2=" . @period2slice . " afterp2=" . @afterp2 . "\n";
#					debugprint("	SLICE1:	$object\.$counter=@period1slice\n");
#					debugprint("	SLICE2:	$object\.$counter=@period2slice\n");
#					print "	SLICE1:	$object\.$counter=@period1slice\n" if ($debug == 1);
#					print "	SLICE2:	$object\.$counter=@period2slice\n" if ($debug == 1);
}
sub	create_formats
{
	my $bookref = shift;
	my $formatref = shift;
	
	$$formatref{BOLD} = $$bookref->add_format( bold => 1 );
	$$formatref{ITALIC} = $$bookref->add_format( italic => 1 );
	$$formatref{ITALIC_PINK} = $$bookref->add_format( fg_color => $colors{pink}, italic => 1 );
	$$formatref{CENTER} = $$bookref->add_format(align => 'center');
	$$formatref{HEADING} = $$bookref->add_format(align => 'center', bold => 1);
	$$formatref{TIME} = $$bookref->add_format(num_format => 'hh:mm');

	${$formatref}{EMPTY} = ${$bookref}->add_format( fg_color => $colors{magenta},	pattern => 1, border => 1, italic => 1 );
	${$formatref}{NON_EMPTY} = ${$bookref}->add_format( fg_color => $colors{lime},		pattern => 1, border => 1 );
	${$formatref}{MISSING_ROP} = ${$bookref}->add_format( fg_color => $colors{lightyellow},	pattern => 1, border => 1 );
	${$formatref}{WHITE} = ${$bookref}->add_format( fg_color => $colors{white},		pattern => 1, border => 1 );
	${$formatref}{RED} = ${$bookref}->add_format( fg_color => $colors{red},		pattern => 1, border => 1 );
	${$formatref}{YELLOW} = ${$bookref}->add_format( fg_color => $colors{yellow},	pattern => 1, border => 1 );
	${$formatref}{BLUE} = ${$bookref}->add_format( fg_color => $colors{blue},		pattern => 1, border => 1 );
	${$formatref}{CYAN} = ${$bookref}->add_format( fg_color => $colors{cyan},		pattern => 1, border => 1 );
	${$formatref}{BROWN} = ${$bookref}->add_format( fg_color => $colors{brown},	pattern => 1, border => 1 );
	${$formatref}{MAGENTA} = ${$bookref}->add_format( fg_color => $colors{magenta},	pattern => 1, border => 1 );
	${$formatref}{GREEN} = ${$bookref}->add_format( fg_color => $colors{green},	pattern => 1, border => 1 );
	${$formatref}{PEG} = ${$bookref}->add_format( fg_color => $colors{lime},	pattern => 1, border => 1 );
	${$formatref}{PDF} = ${$bookref}->add_format( fg_color => $colors{silver},	pattern => 1, border => 1 );
	${$formatref}{GAUGE} = ${$bookref}->add_format( fg_color => $colors{lightblue},	pattern => 1, border => 1 );
	${$formatref}{ACC} = ${$bookref}->add_format( fg_color => $colors{lightred},	pattern => 1, border => 1 );
	${$formatref}{SCAN} = ${$bookref}->add_format( fg_color => $colors{cyan},	pattern => 1, border => 1 );
	${$formatref}{TRIGACC} = ${$bookref}->add_format( fg_color => $colors{orange},	pattern => 1, border => 1 );
	${$formatref}{TRIGSQR} = ${$bookref}->add_format( fg_color => $colors{pink},	pattern => 1, border => 1 );
	${$formatref}{TRIGSCAN} = ${$bookref}->add_format( fg_color => $colors{purple},	pattern => 1, border => 1 );
	${$formatref}{DDM} = ${$bookref}->add_format( fg_color => $colors{yellow},	pattern => 1, border => 1 );
	${$formatref}{SQR} = ${$bookref}->add_format( fg_color => $colors{blue},	pattern => 1, border => 1 );
	${$formatref}{LIGHTRED} = ${$bookref}->add_format( fg_color => $colors{lightred},	pattern => 1, border => 1 );
	${$formatref}{LIGHTBLUE} = ${$bookref}->add_format( fg_color => $colors{lightblue},pattern => 1, border => 1 );

	${$bookref}->set_custom_color(40, '#FF6600');	#orange
	${$bookref}->set_custom_color(41, '#FFAAAA');	#light red
	${$bookref}->set_custom_color(42, '#AAAAFF');	#light blue
}

sub create_sheets
{
	my $bookref = shift;
	my $worksheetref = shift;
	my $hashref = shift;	# $urkhash{$counter}{SUM}
	my $hashref2 = shift;	# $sheethash{$sheetnamehash{$counter}{sheetname}}
	my $hashref3 = shift;	# $mominfo{$class}{$counter}{TYPE}
	my $mom = shift;
	my $useperiods = shift;
	my $usebuckets = shift;
	my $timeref  = shift;
	my $formatref = shift;
	my $chartref = shift;
	my $sinr = shift;
	my $originalcountername;
	my $class;
#	print __LINE__ . ":	create sheet,	ref=$hashref,	ref2=$hashref2,	ref3=$hashref3\n";
	my @t2 = @$timeref[$periods{s1}..$periods{e1}];
	my @t3 = @$timeref[$periods{s2}..$periods{e2}];
	my @t1 = @$timeref[0..($periods{s1}-1)];
	my @t4 = @$timeref[($periods{e2}+1)..@$timeref-1];
	foreach my $counter (sort keys %$hashref) {
#print __LINE__ . ":	counter=$counter\n";
		if (!exists $$hashref2{$$hashref{$counter}{SHEET}}){
#print __LINE__ . ":     counter=$counter sheet does not exists sum = $$hashref{$counter}{SUM}\n";
		if ($$hashref{$counter}{SUM} ne 0){ # andrade fran "> 0" till "ne 0" pga negativa RBS raknare som RSSI
#print __LINE__ . ":     counter=$counter sum is not 0, sheet should be created\n";
			$originalcountername=$counter;
			if (defined $usebuckets){
				if ($originalcountername =~ /_\d+$/){
					$originalcountername =~ s/(.+)_\S+$/$1/;
					$pdf = 1;
					$$hashref3{$class}{$originalcountername}{TYPE} = "PDF";
				} else{
					# Remove counters with array values that do not end with _X ( ! =~ /_\d+$/ ).
					if (defined $arrays{$counter}){
						delete ($counterhash{$_}{$counter}) foreach (keys %counterhash);
						next;
					}
				}
			}
			$class = find_class($hashref3,$originalcountername);
			if (! defined $class and !defined $formula_file){
				$class = "MISSING";
				if (defined $mom ) {
					print __LINE__ . ":	MISSING class in MOM: class=$class,	counter=$counter,	original countername=$originalcountername,	MOM=$mom\n";
				}
				debugprint (__LINE__ . ":	MISSING class in MOM: class=$class,	counter=$counter,	original countername=$originalcountername,	MOM=$mom\n");
			}
#print __LINE__ .":	adding sheet $counter\n";
			$$hashref2{$$hashref{$counter}{SHEET}} = $$bookref->add_worksheet($$hashref{$counter}{SHEET});
			$$hashref2{$$hashref{$counter}{SHEET}}->add_write_handler(qr[\w], \&store_string_widths);
			if ($mom) {
				if (defined $class) {
					if (!exists $$hashref3{$class}{$originalcountername}{TYPE} and !defined $formula_file){
						print __LINE__ . ": $class->$originalcountername does not exists\n";
						debugprint (__LINE__ . " $class->$originalcountername does not exists\n");
					}
					if ($$hashref3{$class}{$originalcountername}{TYPE} =~ /PDF/){
						$$hashref2{$$hashref{$counter}{SHEET}}->set_tab_color($colors{silver});
					}elsif ($$hashref3{$class}{$originalcountername}{TYPE} =~ /GAUGE/){
						$$hashref2{$$hashref{$counter}{SHEET}}->set_tab_color($colors{lightblue});
					}elsif ($$hashref3{$class}{$originalcountername}{TYPE} =~ /ACC/){
						$$hashref2{$$hashref{$counter}{SHEET}}->set_tab_color($colors{lightred});
					}elsif ($$hashref3{$class}{$originalcountername}{TYPE} =~ /SCAN/){
						$$hashref2{$$hashref{$counter}{SHEET}}->set_tab_color($colors{cyan});
					}elsif ($$hashref3{$class}{$originalcountername}{TYPE} =~ /TrigACC/){
						$$hashref2{$$hashref{$counter}{SHEET}}->set_tab_color($colors{orange});
					}elsif ($$hashref3{$class}{$originalcountername}{TYPE} =~ /TrigSQR/){
						$$hashref2{$$hashref{$counter}{SHEET}}->set_tab_color($colors{pink});
					}elsif ($$hashref3{$class}{$originalcountername}{TYPE} =~ /TrigSCAN/){
						$$hashref2{$$hashref{$counter}{SHEET}}->set_tab_color($colors{purple});
					}elsif ($$hashref3{$class}{$originalcountername}{TYPE} =~ /DDM/){
						$$hashref2{$$hashref{$counter}{SHEET}}->set_tab_color($colors{yellow});
					}
				}else {
					print __LINE__ . ":	\$class is not defined, counter=$originalcountername\n";
				}
			}
			elsif ($pdf){
				$$hashref2{$$hashref{$counter}{SHEET}}->set_tab_color($colors{silver});
			}
			# Check for 'sinr' flag.
			my $label1 = $sinr ? "Counter" : "MO";
			my $label2 = $sinr ? "MO" : "Counter";
			$$hashref2{$$hashref{$counter}{SHEET}}->write( "A1", $label1,${$formatref}{WHITE});
			$$hashref2{$$hashref{$counter}{SHEET}}->write( "B1", $label2,${$formatref}{WHITE});
			if (!$useperiods) {
				$$hashref2{$$hashref{$counter}{SHEET}}->write( 0,2+@t1, [@t2],${$formatref}{RED});
			}

			if (exists $counterhash{$object}{$counter}{special}){
				$$chartref{$$hashref{$counter}{SHEET}} = $$bookref->add_chart( type => 'column', embedded => 1);
			}else {
				$$chartref{$$hashref{$counter}{SHEET}} = $$bookref->add_chart( type => 'line', embedded => 1);
			}
			# Add a chart title and some axis labels.
			$$chartref{$$hashref{$counter}{SHEET}}->set_title ( name => "$counter" );
			if ($sinr){
				$$chartref{$$hashref{$counter}{SHEET}}->set_x_axis( name => 'dB', visible => 1, interval_unit => 1, crossing => $index_of_0);
				$$chartref{$$hashref{$counter}{SHEET}}->set_size ( width => 640, height => 320 );
				$$chartref{$$hashref{$counter}{SHEET}}->set_y_axis( name => 'Occurrences', label_position => 'low');

			}
			else {
				$$chartref{$$hashref{$counter}{SHEET}}->set_x_axis( name => 'Time1', visible => 1);
			}
			my $key1;
			if (defined $class) {
				if (!defined $objecthash{'ManagedElement_' . $counter}{axes}){ #om man kort pmxln sa ar key1 = ManagedElement_.... (rad 374)
					$key1 = $class .  '_' . $counter;
				} else {
					$key1 = 'ManagedElement_' . $counter;
				}
			}else{
				$key1 = 'ManagedElement_' . $counter;
			}
			if ($number_of_xaxes == 2){	#pmxln anvandes
#			if ($objecthash{$key1}{axes} == 2){	#pmxln anvandes
				$$chartref{$$hashref{$counter}{SHEET}}->set_x2_axis( name => 'Time2', label_position => 'next_to', visible => 1 );
#				print __LINE__ . ":	Skapar andra x-axeln	class=$class,	counter=$counter,	key1=$key1\n";
				$$chartref{$$hashref{$counter}{SHEET}}->set_y2_axis(
					crossing => 'max',
					visible  => 0,		#hide second y-axis
				);
			}
#			$$chartref{$$hashref{$counter}{SHEET}}->{_label_position_default} = 'right';
#			$$chartref{$$hashref{$counter}{SHEET}}->{_label_positions} = {
#				center      => 'ctr',
#				right       => 'r',
#				left        => 'l',
#				above       => 't',
#				below       => 'b',
#				# For backward compatibility.
#				top         => 't',
#				bottom      => 'b',
#			};
#			print __LINE__ . ":	PLING	key1=$key1	#axes=$objecthash{$key1}{axes} number_of_xaxes=$number_of_xaxes\n";
			if ($sinr) {
				$$chartref{$$hashref{$counter}{SHEET}}->set_y_axis( name => 'Occurrences', label_position => 'low');
			} else{
				$$chartref{$$hashref{$counter}{SHEET}}->set_y_axis( name => 'Number' );
			}
			$$chartref{$$hashref{$counter}{SHEET}}->set_plotarea( pattern => 'solid' );
			$$chartref{$$hashref{$counter}{SHEET}}->set_plotarea( weight => 'hairline' );
			debugprint (__LINE__ . ":	Adding chart for counter $counter in sheet $$hashref{$counter}{SHEET}\n");

			if ($useperiods) {

#print __LINE__ .":	o=$originalcountername	c=$counter,	type=$mominfo2{$originalcountername}{TYPE} buckets=$buckets\n\n";
				if (exists $mominfo2{$originalcountername}{TYPE} and $mominfo2{$originalcountername}{TYPE} =~ /PDF/ and $buckets){
				
#print __LINE__ .":	PDF	$originalcountername - $counter\n";
					if ($originalcountername ne $counter) {
						#skriv farger i rubriken
						$$hashref2{$$hashref{$counter}{SHEET}}->write( 0,2, [@t1],$$formatref{YELLOW});
						$$hashref2{$$hashref{$counter}{SHEET}}->write( 0,(2+@t1), [@t2],${$formatref}{RED});	# Gjort ovan
						$$hashref2{$$hashref{$counter}{SHEET}}->write( 0,(2+@t1+@t2), [@t3],${$formatref}{GREEN});
						$$hashref2{$$hashref{$counter}{SHEET}}->write( 0,(2+@t1+@t2+@t3), [@t4],${$formatref}{MAGENTA});
					}else { 
						my @desc = split (/\n/,$mominfo2{$originalcountername}{DESC});

						my @columns;
						my $size;
						foreach (@desc){
							if ( $_ =~ /^\[(\d+)\]\s*:/ ) {
								$size = $1;
							}
						}
						for (my $i=0; $i <= $size; $i++) {
							push (@columns,$i);
						}
						# hit kommer vi da vi har buckets, pdf raknare och original countername = counter
						$$hashref2{$$hashref{$counter}{SHEET}}->write( 0,2, [@columns],$$formatref{RED});
						$$hashref2{$$hashref{$counter}{SHEET}}->write( 0,2+ @columns, [@columns],$$formatref{GREEN});
#print __LINE__ .":	Kommer vi hit?,	$counter	$originalcountername	size=$size,	col=@columns,	desc=@desc\n";
					}

				}else{
#print __LINE__ .":	Eller Kommer vi hit?,	$counter	$originalcountername\n";
					#skriv farger i rubriken
					$$hashref2{$$hashref{$counter}{SHEET}}->write( 0,2, [@t1],$$formatref{YELLOW});
					$$hashref2{$$hashref{$counter}{SHEET}}->write( 0,(2+@t1), [@t2],${$formatref}{RED});	# Gjort ovan
					$$hashref2{$$hashref{$counter}{SHEET}}->write( 0,(2+@t1+@t2), [@t3],${$formatref}{GREEN});
					$$hashref2{$$hashref{$counter}{SHEET}}->write( 0,(2+@t1+@t2+@t3), [@t4],${$formatref}{MAGENTA});
				}
#print __LINE__ . ":	special = $counterhash{$object}{$counter}{special}\n";
			}

			# Insert the chart into the worksheet (with an offset).
			if (defined $useperiods and defined $buckets and ($originalcountername ne $counter)){
				$$hashref2{$$hashref{$counter}{SHEET}}->insert_chart('C10',$$chartref{$$hashref{$counter}{SHEET}});
			}else {
#print __LINE__ . ":	Create column graph\n";
				$$hashref2{$$hashref{$counter}{SHEET}}->insert_chart('C10',$$chartref{$$hashref{$counter}{SHEET}},0,0,2,2);
#				print __LINE__ . ":	add shape to I10\n";
#				$shape_rect = $workbook->add_shape( type => 'line');
#				$$hashref2{$$hashref{$counter}{SHEET}}->insert_shape('I10',$shape_rect,0,0,0,10);
			}
#			$$hashref2{$$hashref{$counter}{SHEET}}->insert_chart('E10',$$chartref{$$hashref{$counter}{SHEET}});

#			if ($useperiods) {
#				$$hashref2{$$hashref{$counter}{SHEET}}->insert_chart('S10',$$chartref{$$hashref{$counter}{SHEET} . "_2"});
#				debugprint(__LINE__ . ":	Chart2 added: $counter\.sheetname,	$counter\.sheetname_2\n");
#			}			
		} # end if sum > 0
		} # end if exists sheet
	} # end foreach $hashref
#	} # end foreach $hashref3
	$$worksheetref = $$bookref->add_worksheet('All counters');
	$$worksheetref->add_write_handler(qr[\w], \&store_string_widths);
	$$worksheetref->write( "A1", "MO",${$formatref}{WHITE});
	$$worksheetref->write( "B1", "Counter",${$formatref}{WHITE});

	if ($useperiods) {
		if ($originalcountername ne $counter) {
			$$worksheetref->write( 0,@$timeref+4, "t_prob");
			$$worksheetref->write( 0,@$timeref+5, "significance");
			$$worksheetref->write( 0,@$timeref+6, "standard_error");
			$$worksheetref->write( 0,@$timeref+7, "standard_error_equal");
			$$worksheetref->write( 0,@$timeref+8, "standard_error_unequal");
			$$worksheetref->write( 0,@$timeref+9, "f_cutoff");
			$$worksheetref->write( 0,@$timeref+10, "df1");
			$$worksheetref->write( 0,@$timeref+11, "valid");
			$$worksheetref->write( 0,@$timeref+12, "alpha");
			$$worksheetref->write( 0,@$timeref+13, "df");
			$$worksheetref->write( 0,@$timeref+14, "equal_variance");
			$$worksheetref->write( 0,@$timeref+15, "t_statistic");
			$$worksheetref->write( 0,@$timeref+16, "mean_difference");
			$$worksheetref->write( 0,@$timeref+17, "upper_clm");
			$$worksheetref->write( 0,@$timeref+18, "t_value");
			$$worksheetref->write( 0,@$timeref+19, "df_unequal");
			$$worksheetref->write( 0,@$timeref+20, "df2");
			$$worksheetref->write( 0,@$timeref+21, "variance");
			$$worksheetref->write( 0,@$timeref+22, "standard_deviation");
			$$worksheetref->write( 0,@$timeref+23, "t_statistic_equal");
			$$worksheetref->write( 0,@$timeref+24, "f_statistic");
			$$worksheetref->write( 0,@$timeref+25, "delta");
			$$worksheetref->write( 0,@$timeref+26, "t_statistic_unequal");
			$$worksheetref->write( 0,@$timeref+27, "df_equal");
			$$worksheetref->write( 0,@$timeref+28, "null_hypothesis");
		}
	}
}

sub find_class{
	my $hashref = shift;
	my $wantedcounter = shift;
	my $result;
	foreach my $class (sort keys %$hashref) {
		foreach my $counter (sort keys %{$$hashref{$class}}) {
			if ($counter =~ /$wantedcounter$/){
				$result = $class;
				last;
			}
		}
	}
	return $result;
}

sub write_time
{
	#man måste ha kört subben create_sheets för at worksheetref skall innehålla något
	my $worksheetref = shift;
	my $timeref = shift;
	my $useperiods = shift;
	my $formatref = shift;
	if ($useperiods){
		my @t2 = @$timeref[$periods{s1}..$periods{e1}];
		my @t3 = @$timeref[$periods{s2}..$periods{e2}];
		my @t1 = @$timeref[0..($periods{s1}-1)];
		my @t4 = @$timeref[($periods{e2}+1)..@time-1];
		$$worksheetref->write( 0,3, [@t1],${$formatref}{YELLOW});
		$$worksheetref->write( 0,3+@t1, [@t2],${$formatref}{RED});
		$$worksheetref->write( 0,3+@t1+@t2, [@t3],${$formatref}{GREEN});
		$$worksheetref->write( 0,3+@t1+@t2+@t3, [@t4],${$formatref}{MAGENTA});
	}else{
		$$worksheetref->write( 0,3+@t1, [@t2],${$formatref}{YELLOW});
	}
}

sub decide_writeformat
{
	my $formatref = shift;
	my $mom = shift;
	my $counter = shift;
	my $sum = shift;
	my $empty = shift;
	my $pdf = shift;
	my $missing = shift;
	my $pmom = shift;

	my $format = $$formatref{NON_EMPTY};

	if ($sum eq 0){
		if (defined $empty and $empty == 1){
			$format = $$formatref{ITALIC_PINK};
		}else{
			$format = $$formatref{ITALIC};
		}
	}else{
		if (defined $missing){
			$format = $$formatref{MISSING_ROP};
		}elsif (defined $mom or defined $pmom) {
			if ( defined $mominfo2{$counter}{TYPE} ) {
				if ( $mominfo2{$counter}{TYPE} =~ /PEG/){
					$format = $$formatref{PEG};
				}elsif ( $mominfo2{$counter}{TYPE} =~ /PDF/){
					$format = $$formatref{PDF};
				}elsif ($mominfo2{$counter}{TYPE} =~ /GAUGE/){
					$format = $$formatref{GAUGE};
				}elsif ($mominfo2{$counter}{TYPE} =~ /ACC/){
					$format = $$formatref{ACC};
				}elsif ($mominfo2{$counter}{TYPE} =~ /SCAN/){
					$format = $$formatref{SCAN};
				}elsif ($mominfo2{$counter}{TYPE} =~ uc (/TrigACC/)){
					$format = $$formatref{TRIGACC};
				}elsif ($mominfo2{$counter}{TYPE} =~ uc (/TrigSQR/)){
					$format = $$formatref{TRIGSQR};
				}elsif ($mominfo2{$counter}{TYPE} =~ uc (/TrigSCAN/)){
					$format = $$formatref{TRIGSCAN};
				}elsif ($mominfo2{$counter}{TYPE} =~ /DDM/){
					$format = $$formatref{DDM};
				}elsif ($mominfo2{$counter}{TYPE} =~ /SQR/){
					$format = $$formatref{SQR};
				}
			}
		}elsif (defined $pdf){
			$format = $$formatref{PDF};
		}else{
			$format = $$formatref{NON_EMPTY};
		}
	}
	return $format;
}

sub	create_change_sheet
{
	my $bookref = shift;
	my $sheetref = shift;
	my $useperiods = shift;
	my $formatref = shift;
	
	if ($useperiods) {
		$$sheetref = $$bookref->add_worksheet('Changes');
		$$sheetref->add_write_handler(qr[\w], \&store_string_widths);
		$$sheetref->write( 0,3, "Average ratio");
		$$sheetref->write( 0,4, "Median ratio");
		$$sheetref->write( 0,5, "Percentile ratio");
		$$sheetref->write( 0,6, "Standard Deviation ratio");
		$$sheetref->write( 0,7, "t_prob");
		$$sheetref->write( 0,8, "significance");
		$$sheetref->write( 0,9, "standard_error");
		$$sheetref->write( 0,10, "standard_error_equal");
		$$sheetref->write( 0,11, "standard_error_unequal");
		$$sheetref->write( 0,12, "f_cutoff");
		$$sheetref->write( 0,13, "df1");
		$$sheetref->write( 0,14, "valid");
		$$sheetref->write( 0,15, "alpha");
		$$sheetref->write( 0,16, "df");
		$$sheetref->write( 0,17, "equal_variance");
		$$sheetref->write( 0,18, "t_statistic");
		$$sheetref->write( 0,19, "mean_difference");
		$$sheetref->write( 0,20, "upper_clm");
		$$sheetref->write( 0,21, "t_value");
		$$sheetref->write( 0,22, "df_unequal");
		$$sheetref->write( 0,23, "df2");
		$$sheetref->write( 0,24, "variance");
		$$sheetref->write( 0,25, "standard_deviation");
		$$sheetref->write( 0,26, "t_statistic_equal");
		$$sheetref->write( 0,27, "f_statistic");
		$$sheetref->write( 0,28, "delta");
		$$sheetref->write( 0,29, "t_statistic_unequal");
		$$sheetref->write( 0,30, "df_equal");
		$$sheetref->write( 0,31, "null_hypothesis");
	}
}

sub update_change_sheet
{
	my $sheetref = shift;	# $changesheet
	my $formatref = shift;	# %writeformats
	my $hashref = shift;	# %filterhash
	my $hashref2 = shift;	# %counterhash
	my $hashref3 = shift;	# %urkhash
	my $objectref = shift;
	my $counterref = shift;
	my $useperiods = shift;
	my $ttest = shift;
	my $classname;
	my @tmp;

				if ($useperiods) {
					$$hashref{$$objectref}{$$counterref}{values} = [@{${$$hashref2{$$objectref}}{$$counterref}{values}}];

					my @period1slice = @{${$$hashref2{$$objectref}}{$$counterref}{values}}[$periods{s1}..$periods{e1}];
					my @period2slice = @{${$$hashref2{$$objectref}}{$$counterref}{values}}[$periods{s2}..$periods{e2}];
					my @beforep1 = @{${$$hashref2{$$objectref}}{$$counterref}{values}}[0..($periods{s1}-1)];
					my @afterp2 = @{${$$hashref2{$$objectref}}{$$counterref}{values}}[($periods{e2}+1)..@time-1];

					$$ttest->set_significance(95);
					$$ttest->load_data(\@period1slice,\@period2slice);
					
#					my @afterp2 = @{${$$counterrefhash{$$objectref}}{$$counterref}{values}}[($periods{e2}+1)..$arraylength-2];
#					percentile(\@period1slice);
#					print "slices:	beforep1=" . @beforep1 . "	slice1=" . @period1slice . " slice2=" . @period2slice . " afterp2=" . @afterp2 . "\n";
					debugprint("	SLICE1:	$$objectref\.$$counterref=@period1slice\n");
					debugprint("	SLICE2:	$$objectref\.$$counterref=@period2slice\n");
#					print "	SLICE1:	$$objectref\.$$counterref=@period1slice\n" if ($debug == 1);
#					print "	SLICE2:	$$objectref\.$$counterref=@period2slice\n" if ($debug == 1);
					$$hashref{$$objectref}{$$counterref}{p1avg} = average(\@period1slice);
					$$hashref{$$objectref}{$$counterref}{p2avg} = average(\@period2slice);
					$$hashref{$$objectref}{$$counterref}{p1median} = median(\@period1slice);
					$$hashref{$$objectref}{$$counterref}{p2median} = median(\@period2slice);
					$$hashref{$$objectref}{$$counterref}{p1percentile} = percentile(\@period1slice);
					$$hashref{$$objectref}{$$counterref}{p2percentile} = percentile(\@period2slice);
					$$hashref{$$objectref}{$$counterref}{p1stdev} = stdev(\@period1slice);
					$$hashref{$$objectref}{$$counterref}{p2stdev} = stdev(\@period2slice);
			
					$$hashref{$$objectref}{$$counterref}{t_prob} = $$ttest->t_prob;
					$$hashref{$$objectref}{$$counterref}{significance} = $$ttest->significance;
					$$hashref{$$objectref}{$$counterref}{standard_error} = $$ttest->standard_error;
					$$hashref{$$objectref}{$$counterref}{standard_error_equal} = $$ttest->standard_error_equal;
					$$hashref{$$objectref}{$$counterref}{standard_error_unequal} = $$ttest->standard_error_unequal;
					$$hashref{$$objectref}{$$counterref}{f_cutoff} = $$ttest->f_cutoff;
					$$hashref{$$objectref}{$$counterref}{df1} = $$ttest->df1;
					$$hashref{$$objectref}{$$counterref}{valid} = $$ttest->valid;
					$$hashref{$$objectref}{$$counterref}{alpha} = $$ttest->alpha;
					$$hashref{$$objectref}{$$counterref}{df} = $$ttest->df;
					$$hashref{$$objectref}{$$counterref}{equal_variance} = $$ttest->equal_variance;
					$$hashref{$$objectref}{$$counterref}{t_statistic} = $$ttest->t_statistic;
					$$hashref{$$objectref}{$$counterref}{mean_difference} = $$ttest->mean_difference;
					$$hashref{$$objectref}{$$counterref}{upper_clm} = $$ttest->upper_clm;
					$$hashref{$$objectref}{$$counterref}{t_value} = $$ttest->t_value;
					$$hashref{$$objectref}{$$counterref}{df_unequal} = $$ttest->df_unequal;
					$$hashref{$$objectref}{$$counterref}{df2} = $$ttest->df2;
					$$hashref{$$objectref}{$$counterref}{variance} = $$ttest->variance;
					$$hashref{$$objectref}{$$counterref}{standard_deviation} = $$ttest->standard_deviation;
					$$hashref{$$objectref}{$$counterref}{t_statistic_equal} = $$ttest->t_statistic_equal;
					$$hashref{$$objectref}{$$counterref}{f_statistic} = $$ttest->f_statistic;
					$$hashref{$$objectref}{$$counterref}{delta} = $$ttest->delta;
					$$hashref{$$objectref}{$$counterref}{t_statistic_unequal} = $$ttest->t_statistic_unequal;
					$$hashref{$$objectref}{$$counterref}{df_equal} = $$ttest->df_equal;
					$$hashref{$$objectref}{$$counterref}{null_hypothesis} = $$ttest->null_hypothesis;

					$classname = $object;
					@tmp = split(/=|,/,$object);
					$classname = $tmp[@tmp-2];

					if ($$hashref{$$objectref}{$$counterref}{p2avg} > 0){
						$$hashref{$$objectref}{$$counterref}{avgratio} = int($$hashref{$$objectref}{$$counterref}{p1avg} / $$hashref{$$objectref}{$$counterref}{p2avg} * 100 + 0.5);
					}else{
						$$hashref{$$objectref}{$$counterref}{avgratio} = -1;
					}
					if ($$hashref{$$objectref}{$$counterref}{p2median} > 0){
						$$hashref{$$objectref}{$$counterref}{medianratio} = int($$hashref{$$objectref}{$$counterref}{p1median} / $$hashref{$$objectref}{$$counterref}{p2median} * 100 + 0.5);
					}else{
						$$hashref{$$objectref}{$$counterref}{medianratio} = -1;
					}
					if ($$hashref{$$objectref}{$$counterref}{p2percentile} > 0){
						$$hashref{$$objectref}{$$counterref}{percentileratio} = int($$hashref{$$objectref}{$$counterref}{p1percentile} / $$hashref{$$objectref}{$$counterref}{p2percentile} * 100 + 0.5);
					}else{
						$$hashref{$$objectref}{$$counterref}{percentileratio} = -1;
					}
					if ($$hashref{$$objectref}{$$counterref}{p2stdev} > 0){
						$$hashref{$$objectref}{$$counterref}{stdevratio} = int($$hashref{$$objectref}{$$counterref}{p1stdev} / $$hashref{$$objectref}{$$counterref}{p2stdev} * 100 + 0.5);
					}else{
						$$hashref{$$objectref}{$$counterref}{stdevratio} = -1;
					}

					if (!defined $percentile){
						# Beräkna percentile
						if ($$hashref{$$objectref}{$$counterref}{standard_deviation} > 0 and $$hashref{$$objectref}{$$counterref}{t_prob} < 0.05){
						if (($$hashref{$$objectref}{$$counterref}{p1avg} > $minAvg) || ($$hashref{$$objectref}{$$counterref}{p2avg} > $minAvg)){
							if (($$hashref{$$objectref}{$$counterref}{avgratio} > (100+$warninglevel)) || ($$hashref{$$objectref}{$$counterref}{avgratio} < (100-$warninglevel))){
								$$hashref{$$objectref}{$$counterref}{change} = 1;

								if (defined $$hashref{$$objectref}{$$counterref}{type}){
									$$sheetref->write( $changerow,0, $$objectref,$$formatref{PDF});
									my $link = "internal:$$hashref{$$counterref}{SHEET}!A1";
									my $row2=$changerow+1;
									$$sheetref->write( "B$row2",$link, $$counterref,$$formatref{PDF});
									if (exists $mominfo{$counter}{INFO}){
										$$sheetref->write_comment( "B$row2", $mominfo{$classname}{$$counterref}{INFO},x_scale => XSCALE,y_scale => YSCALE) if (defined $mom);
										print "counter=$$counterref,	MOM=$mominfo{$$counterref}{INFO}\n\n";
									}
								}else{
									$$sheetref->write( $changerow,0, $$objectref,$$formatref{NON_EMPTY});
									my $link = "internal:$$hashref3{$$counterref}{SHEET}!A1";
									my $row2=$changerow+1;
									$$sheetref->write( "B$row2",$link, $$counterref,$$formatref{NON_EMPTY});
									if (exists $mominfo{$counter}{INFO}){
										$$sheetref->write_comment( "B$row2", $mominfo{$classname}{$$counterref}{INFO},x_scale => XSCALE,y_scale => YSCALE)if (defined $mom);
										print "counter=$$counterref,	MOM=$mominfo{$$counterref}{INFO}\n\n";
									}
								}
								$$sheetref->write( $changerow,3, $$hashref{$$objectref}{$$counterref}{avgratio});
								$$sheetref->write( $changerow,4, $$hashref{$$objectref}{$$counterref}{medianratio});
								$$sheetref->write( $changerow,5, $$hashref{$$objectref}{$$counterref}{percentileratio});
								$$sheetref->write( $changerow,6, $$hashref{$$objectref}{$$counterref}{stdevratio});

								$$sheetref->write( $changerow,7, $$hashref{$$objectref}{$$counterref}{t_prob});
								$$sheetref->write( $changerow,8, $$hashref{$$objectref}{$$counterref}{significance});
								$$sheetref->write( $changerow,9, $$hashref{$$objectref}{$$counterref}{standard_error});
								$$sheetref->write( $changerow,10, $$hashref{$$objectref}{$$counterref}{standard_error_equal});
								$$sheetref->write( $changerow,11, $$hashref{$$objectref}{$$counterref}{standard_error_unequal});
								$$sheetref->write( $changerow,12, $$hashref{$$objectref}{$$counterref}{f_cutoff});
								$$sheetref->write( $changerow,13, $$hashref{$$objectref}{$$counterref}{df1});
								$$sheetref->write( $changerow,14, $$hashref{$$objectref}{$$counterref}{valid});
								$$sheetref->write( $changerow,15, $$hashref{$$objectref}{$$counterref}{alpha});
								$$sheetref->write( $changerow,16, $$hashref{$$objectref}{$$counterref}{df});
								$$sheetref->write( $changerow,17, $$hashref{$$objectref}{$$counterref}{equal_variance});
								$$sheetref->write( $changerow,18, $$hashref{$$objectref}{$$counterref}{t_statistic});
								$$sheetref->write( $changerow,19, $$hashref{$$objectref}{$$counterref}{mean_difference});
								$$sheetref->write( $changerow,20, $$hashref{$$objectref}{$$counterref}{upper_clm});
								$$sheetref->write( $changerow,21, $$hashref{$$objectref}{$$counterref}{t_value});
								$$sheetref->write( $changerow,22, $$hashref{$$objectref}{$$counterref}{df_unequal});
								$$sheetref->write( $changerow,23, $$hashref{$$objectref}{$$counterref}{df2});
								$$sheetref->write( $changerow,24, $$hashref{$$objectref}{$$counterref}{variance});
								$$sheetref->write( $changerow,25, $$hashref{$$objectref}{$$counterref}{standard_deviation});
								$$sheetref->write( $changerow,26, $$hashref{$$objectref}{$$counterref}{t_statistic_equal});
								$$sheetref->write( $changerow,27, $$hashref{$$objectref}{$$counterref}{f_statistic});
								$$sheetref->write( $changerow,28, $$hashref{$$objectref}{$$counterref}{delta});
								$$sheetref->write( $changerow,29, $$hashref{$$objectref}{$$counterref}{t_statistic_unequal});
								$$sheetref->write( $changerow,30, $$hashref{$$objectref}{$$counterref}{df_equal});
								$$sheetref->write( $changerow,31, $$hashref{$$objectref}{$$counterref}{null_hypothesis});

#Testar sparklines
								my $tmprow = $$hashref2{$$objectref}{$$counterref}{allsheetrow};
								my $cell = xl_rowcol_to_cell($changerow, 2);
								my $range = xl_range($tmprow, $tmprow, 3, @{${$counterhash{$object}}{$counter}{values}}+2);
								$$sheetref->add_sparkline({location=>"$cell", range=> "'All counters'!$range"});	# sheet!r1, r2, c1, c2
								$changerow++;
#								print __LINE__ . ":	sparkline in change sheet\n";
							}else{
								$$hashref{$$objectref}{$$counterref}{change} = 0;
							} #end else $$hashref{$$objectref}{$$counterref}{avgratio} > (100+$warninglevel))
						} #end if $$hashref{$$objectref}{$$counterref}{p1avg} > $minAvg
						} # end if t_prob
					}else{
						# Beräkna percentile och percenileratio
						if (($$hashref{$$objectref}{$$counterref}{p1percentile} > $minAvg) || ($$hashref{$$objectref}{$$counterref}{p2percentile} > $minAvg)){
							if (($$hashref{$$objectref}{$$counterref}{percentileratio} > (100+$warninglevel)) || ($$hashref{$$objectref}{$$counterref}{percentileratio} < (100-$warninglevel))){
								$$hashref{$$objectref}{$$counterref}{change} = 1;
								$$sheetref->write( $changerow,0, $$objectref,$$formatref{NON_EMPTY});
								my $link = "internal:$$hashref3{$$counterref}{SHEET}!A1";
								my $row2=$changerow+1;
								$$sheetref->write( "B$row2",$link, $$counterref,$$formatref{NON_EMPTY});
								if (exists $mominfo{$counter}{INFO}){
									$$sheetref->write_comment( "B$row2", $mominfo{$classname}{$$counterref}{INFO},x_scale => XSCALE,y_scale => YSCALE) if (defined $mom);
								}
								my $col=2;
								$$sheetref->write( $changerow,3, $$hashref{$$objectref}{$$counterref}{avgratio});
								$$sheetref->write( $changerow,4, $$hashref{$$objectref}{$$counterref}{medianratio});
								$$sheetref->write( $changerow,5, $$hashref{$$objectref}{$$counterref}{percentileratio});
								$$sheetref->write( $changerow,6, $$hashref{$$objectref}{$$counterref}{stdevratio});

								$$sheetref->write( $changerow,7, $$hashref2{$$objectref}{$$counterref}{t_prob});
								$$sheetref->write( $changerow,8, $$hashref2{$$objectref}{$$counterref}{significance});
								$$sheetref->write( $changerow,9, $$hashref2{$$objectref}{$$counterref}{standard_error});
								$$sheetref->write( $changerow,10, $$hashref2{$$objectref}{$$counterref}{standard_error_equal});
								$$sheetref->write( $changerow,11, $$hashref2{$$objectref}{$$counterref}{standard_error_unequal});
								$$sheetref->write( $changerow,12, $$hashref2{$$objectref}{$$counterref}{f_cutoff});
								$$sheetref->write( $changerow,13, $$hashref2{$$objectref}{$$counterref}{df1});
								$$sheetref->write( $changerow,14, $$hashref2{$$objectref}{$$counterref}{valid});
								$$sheetref->write( $changerow,15, $$hashref2{$$objectref}{$$counterref}{alpha});
								$$sheetref->write( $changerow,16, $$hashref2{$$objectref}{$$counterref}{df});
								$$sheetref->write( $changerow,17, $$hashref2{$$objectref}{$$counterref}{equal_variance});
								$$sheetref->write( $changerow,18, $$hashref2{$$objectref}{$$counterref}{t_statistic});
								$$sheetref->write( $changerow,19, $$hashref2{$$objectref}{$$counterref}{mean_difference});
								$$sheetref->write( $changerow,20, $$hashref2{$$objectref}{$$counterref}{upper_clm});
								$$sheetref->write( $changerow,21, $$hashref2{$$objectref}{$$counterref}{t_value});
								$$sheetref->write( $changerow,22, $$hashref2{$$objectref}{$$counterref}{df_unequal});
								$$sheetref->write( $changerow,23, $$hashref2{$$objectref}{$$counterref}{df2});
								$$sheetref->write( $changerow,24, $$hashref2{$$objectref}{$$counterref}{variance});
								$$sheetref->write( $changerow,25, $$hashref2{$$objectref}{$$counterref}{standard_deviation});
								$$sheetref->write( $changerow,26, $$hashref2{$$objectref}{$$counterref}{t_statistic_equal});
								$$sheetref->write( $changerow,27, $$hashref2{$$objectref}{$$counterref}{f_statistic});
								$$sheetref->write( $changerow,28, $$hashref2{$$objectref}{$$counterref}{delta});
								$$sheetref->write( $changerow,29, $$hashref2{$$objectref}{$$counterref}{t_statistic_unequal});
								$$sheetref->write( $changerow,30, $$hashref2{$$objectref}{$$counterref}{df_equal});
								$$sheetref->write( $changerow,31, $$hashref2{$$objectref}{$$counterref}{null_hypothesis});

#Testar sparklines,
								my $tmprow = $$hashref2{$$objectref}{$$counterref}{allsheetrow};
								my $cell = xl_rowcol_to_cell($changerow, 2);
								my $range = xl_range($tmprow, $tmprow, 3, @{${$counterhash{$object}}{$counter}{values}}+2);
								$$sheetref->add_sparkline({location=>"$cell", range=> "'All counters'!$range"});	# sheet!r1, r2, c1, c2
								$changerow++;
							}else{
								$$hashref{$$objectref}{$$counterref}{change} = 0;
							}
						}
					} # end beräkna percentile & percentileratio

#					prep_change_sheet($periods{s1},$periods{e1},$periods{s2},$periods{e1});
				} # end useperiods
}

sub create_book
{
	my $bookref = shift;

	
#	$$bookref  = Spreadsheet::WriteExcel->new( "$outputfile" );
	$$bookref  = Excel::Writer::XLSX->new( "$outputfile" );
	die "Couldn't create new Excel file: $!.\n" unless defined $$bookref;
#	$workbook->compatibility_mode(); 
	set_properties($$bookref);
}


	__END__
    
    
    sub string_width {
    
        require Font::TTFMetrics;
    
        my $arial        = Font::TTFMetrics->new('c:\windows\fonts\arial.ttf');
    
        my $font_size    = 10;
        my $dpi          = 96;
        my $units_per_em = $arial->get_units_per_em();
        my $font_width   = $arial->string_width($_[0]);
    
        # Convert to pixels as per TTFMetrics docs.
        my $pixel_width  = 6 + $font_width *$font_size *$dpi /(72 *$units_per_em);
    
        # Add extra pixels for border around text.
        $pixel_width  += 6;
    
        # Convert to cell width (for Arial) and for cell widths > 1.
        my $cell_width   = ($pixel_width -5) /7;
    
        return $cell_width;
    
    }
	
	__END__
