package formatTXT;

use strict;
use locale;
use Data::Dumper;
sub formatTXT::new() {
  my $class = shift;
  my %self = @_;
  $self{format} = "TXT";
  return bless \%self;
}

sub formatTXT::begin(){
    my $self = shift;
    my $path = shift;
    my $tableName = shift;
    $self->printer( $tableName );
}

sub formatTXT::header(){
    my $self = shift;
    my $string = shift;
    my $notUsed = shift;
    my $noSeparater = shift;
    my $linebreaker = "=" x (length($string));
    $self->printer( $linebreaker ) if !defined $noSeparater;
    $self->printer( $string );
    $self->printer( $linebreaker ) if !defined $noSeparater;
}

sub formatTXT::content(){
    my $self = shift;
    my ( $numberOf, $string, $rops ) = @_;
    $self->printer( $numberOf . $string . $rops );
}

sub formatTXT::end(){
    my $self = shift;
    my $string = shift;
    $self->printer( defined $string ?
                    $string : ""); ##Only print string if it's defined.
}

sub formatTXT::printer(){
    my $self = shift;
    my $string = shift;
    my $fh = $self->{fh};
    $string=~s/;//g;
    print $fh "$string\n";
}

1;
