##description
##updated on 2013-08-26
#1.Concat support four type concat:
#type1@@ (1/2) (2/2),
#type2@@ (Part/Last Part(2)),
#type3@@ Segmenting traces,
#type4@@ follow type3,part of continuous log
#2. Concat support traces mixed from multiple nodes
#
#3.Usage
#$concat->mergePartLogs($_);
#$concat->readPreparedBuffer();
#$concat->cleanFinishedBuffer();

##change history
##
#2013-07-10 add support for trace type like " Last Part(1): "
#2013-08-26 remove the double break line of output result

package concat;
use strict;
use Data::Dumper;

sub concat::new()
{
    my $class = shift;
    my %self  = @_;
    $self{ContiuneFlag} = 0;
    $self{readnext}     = 0;

    $self{IDlist}         = ();
    $self{preparedBuffer} = ();

    $self{BUFFER} = ();

    $self{PARTS} = {};
    $self{dateTimeFormat} =
        qr(\[\d{4}-\d{2}-\d{2}\s\d{2}:\d{2}:\d{2}\.\d{3}\]);
    $self{CONTINUATION} = {};
    $self{CONTINUATION}{parts} = {};
    return bless \%self;
}

sub concat::mergePartLogs()
{
    my $self    = shift;
    my $lineref = shift;
    my $line;

    # #print $lineref;
    chomp($lineref);
    $lineref =~ s/\r$//;
    my $moshell_board = "";
    my $returnval     = "";
    my $iIDlist;
    my $middleTrace;
    if ( $self->{DISABLE} )
    {
        push( @{ $self->{BUFFER} }, $lineref );
        return;
    }

    #start to check the line
    #if hex data, push out or push to tmp
    if ( $lineref =~ /^[0-9A-F]{4}\s+([0-9A-F ]+)\s+'/ )
    {
        if ( $self->{nextHexID} eq
             0 )    #node ID should not be 0, so use 0 as "push out"
        {
            #print("node ID should not be 0, so use 0 as push out\nline is $lineref\n");
            $returnval = $lineref . "\n";
        }
        elsif ( $self->{nextHexID} eq -1 )
        {
            #throw the line
            $returnval = "";
        }
        else
        {
            #hex write to file
            $self->{tmp}->{ $self->{nextHexID} }->{str} .= $lineref . "\n";

            #print("finished hex: $self->{tmp}->{$self->{nextHexID}}->{str}");
            $returnval = "";
        }

        #end of type1/type2 hex
    }    #end of if hex line
    else
    {
        ##print "message line $lineref\n";
        $self->cleanFinishedBuffer();

        $self->{curLineType} = undef;
        $self->{curLineInfo} = undef;

        #type1@@ (1/2) (2/2) merge
        if ( $lineref =~
            /(^.*\]\s\[(\S+)\].+?[CONTINUATION|SEND|RECEIVE]:.+?)\((\d+)\/(\d+)\)\s*offset 0x(\S+)/
           )
        {
            $self->{curLineType}             = "TYPE_MSG_TOTAL";
            $self->{curLineInfo}->{partStr}  = $1;
            $self->{curLineInfo}->{ID}       = $2;
            $self->{curLineInfo}->{curNum}   = $3;
            $self->{curLineInfo}->{totalNum} = $4;
            $self->{curLineInfo}->{offset}   = $5;

            $self->concatImpl();
        }

        #type2 (Part/Last Part(2))
        #about the ID, may meet other log type, improve when have sample
        #20140218 add recording of partStr2.
        elsif ( $lineref =~
            /(^.*\]\s\[(\S+)\].*[CONTINUATION|SEND|RECEIVE]:.*),\s(.*)\((\d+)\)(:\s.*)/
            )
        {
            $self->{curLineType}                 = "TYPE_MSG_LAST";
            $self->{curLineInfo}->{partStr}      = $1;
            $self->{curLineInfo}->{ID}           = $2;
            $self->{curLineInfo}->{LastPartFlag} = $3;
            $self->{curLineInfo}->{curNum}       = $4;
            $self->{curLineInfo}->{partStr2}     = $5;

            $self->concatImpl();
        }
        
        #2014-03-28 this kind of concat is not supported, UEH team will move this kind of seperate
        #@type5, 1(2) added 2014-02-17
        #reported: XIN HE, only change the queue, don't remove the header.
        #sample [2014-01-21 20:38:34.492] [001400]RncLmUePT(UE_SP_CONFIG) ../UehUeCtxtC.cpp:8264 BUS RECEIVE: Received bag part 2(7): esvContainer->ueRef=-1, ueModuleId=0:
        #change regular expression "ID" for some message ID is [002400\03] 
        # elsif ( $lineref =~
        #    /($self->{dateTimeFormat}\s+\[(.*)\].*[CONTINUATION|SEND|RECEIVE]:.*)(\d+)\((\d+)\)(:\s.*)/ )
        #{
        #    $self->{curLineType}                 = "TYPE_MSG_TOTAL2";
        #    $self->{curLineInfo}->{partStr}      = $1;
        #    $self->{curLineInfo}->{ID}           = $2;
        #    $self->{curLineInfo}->{curNum}       = $3;
        #    $self->{curLineInfo}->{totalNum}     = $4;
        #    $self->{curLineInfo}->{partStr2}      = $5;

        #    $self->concatImpl();
        #}
        
        #type3@@ Segmenting traces
        elsif ( $lineref =~
            /$self->{dateTimeFormat}\s+\S+\s+\S+.*?\<\s*Segmenting traces for key ([-]?\d+), (\d+) parts will follow\s*\>/
            )
        {
            $self->{curLineType}             = "TYPE_MSG_PARTS";
            $self->{curLineInfo}->{ID}       = $1;
            $self->{curLineInfo}->{totalNum} = $2;
            my $storeID = $self->{curLineInfo}->{ID};

            $self->{tmp}->{$storeID}->{str} = undef;
            $self->{tmp}->{$storeID} = undef;
            $self->{tmp}->{$storeID}->{totalNum} =
                $self->{curLineInfo}->{totalNum};
        }

        #type4, part of continuous log , may mix when multiple nodes
        elsif ( $lineref =~
            /($self->{dateTimeFormat}\s+\S+\s+.+?)\<key\s*([-]?\d+)\s*part\s*(\d+)\>\"(.*)"$/
            )
        {
            $self->{curLineType}             = "TYPE_MSG_FOLLOW";
            $self->{curLineInfo}->{partStr}  = $1;
            $self->{curLineInfo}->{ID}       = $2;
            $self->{curLineInfo}->{curNum}   = $3;
            $self->{curLineInfo}->{partStr2} = $4;
            $self->concatImpl();
        }    #end of type4
        elsif ( $lineref =~ /\S/ )
        {
            #print ("message lines can't recognize. if follow hex,just push out");
            $self->{nextHexID} = 0;
            $returnval = $lineref . "\n";
        }
        else
        {
            $returnval = "";
        }

    }
    push( @{ $self->{preparedBuffer} }, $returnval );
    $lineref   = undef;
    $returnval = undef;
    return;
}

sub concat::concatImpl()
{
    my $self    = shift;
    my $storeID = $self->{curLineInfo}->{ID};

    if ( $self->{curLineInfo}->{curNum} == 1 )
    {

        if ( $self->{curLineType} eq "TYPE_MSG_FOLLOW" )
        {
            if ( !defined $self->{tmp}->{$storeID} )
            {
                return;
            }
            $self->{tmp}->{$storeID}->{str} .=
                $self->{curLineInfo}->{partStr2};# type follow need to keep last msg str1 and all msg str2
        }
        else
        {
            $self->{tmp}->{$storeID}->{str} = undef;
            $self->{tmp}->{$storeID} = undef;
            $self->{tmp}->{$storeID}->{totalNum} =
                $self->{curLineInfo}->{totalNum};    #only type1/5 has this value
            if ( defined $self->{curLineInfo}->{partStr2} )
           {
            $self->{tmp}->{$storeID}->{str} .=
                $self->{curLineInfo}->{partStr} ;
            $self->{tmp}->{$storeID}->{str} .=
                $self->{curLineInfo}->{partStr2}."\n"; #other type all msgs have some str and only keep first msg
           }else{
            $self->{tmp}->{$storeID}->{str} .=
                $self->{curLineInfo}->{partStr}."\n";
           }
        }
        $self->{tmp}->{$storeID}->{curNum} = $self->{curLineInfo}->{curNum};
        
        $self->{nextHexID} = $storeID;

        $self->handleIfLastPart();

    }
    else
    {
        #print"coming part$self->{curLineInfo}->{curNum}, total part $self->{tmp}->{$storeID}->{totalNum}, last $self->{tmp}->{$storeID}->{curNum}\n";
        my $compareval = $self->{tmp}->{$storeID}->{curNum} + 1;
        if (    ( defined $self->{tmp}->{$storeID} )
             && ( $self->{curLineInfo}->{curNum} == $compareval ) )
        {
            $self->{tmp}->{$storeID}->{curNum} =
                $self->{curLineInfo}->{curNum};
            $self->{nextHexID} = $storeID;

            #store Part Str2
            if ( $self->{curLineType} eq "TYPE_MSG_FOLLOW" )
            {
                $self->{tmp}->{$storeID}->{str} .=
                    $self->{curLineInfo}->{partStr2};
            }

            $self->handleIfLastPart();
        }
        else
        {
            print(
                "Warning: missing bag parts in trace. Bag number $storeID, should get $compareval, but receive part is $self->{curLineInfo}->{curNum}\n"
            );
            $self->{nextHexID} = -1;
        }
    }

}

sub concat::handleIfLastPart()
{
    my $self    = shift;
    my $storeID = $self->{curLineInfo}->{ID};
    if ( $self->curLineIsLastPart() eq 1 )
    {
        $self->{finishID} = $storeID;

        #print("finish ID, the tmp str is $self->{tmp}->{$storeID}->{str}\n") ;

        if ( $self->{curLineType} eq "TYPE_MSG_FOLLOW" )
        {    #store last part str head, and add into the tmp str beginning
            my $totalout = $self->{curLineInfo}->{partStr}
                . $self->{tmp}->{$storeID}->{str} . "\n";
            $self->{tmp}->{$storeID}->{str} = $totalout;
        }
    }

}

sub concat::curLineIsLastPart()
{
    my $self    = shift;
    my $retval  = 0;
    my $storeID = $self->{curLineInfo}->{ID};
    if (    ( $self->{curLineType} eq "TYPE_MSG_FOLLOW" )
         || ( $self->{curLineType} eq "TYPE_MSG_TOTAL" ) )
    {
        #print "ID $storeID , cur num is $self->{curLineInfo}->{curNum}, total number is $self->{tmp}->{$storeID}->{totalNum}\n ";
        $retval = ( $self->{curLineInfo}->{curNum} eq
                    $self->{tmp}->{$storeID}->{totalNum} );

    }
    elsif ($self->{curLineType} eq "TYPE_MSG_LAST" )
    {
        $retval = ( $self->{curLineInfo}->{LastPartFlag} eq "Last Part" );
    }

    return $retval;
}

sub concat::readPreparedBuffer()
{
    my $self = shift;
    my $outline =  shift @{ $self->{preparedBuffer} };
    $/="\n";
    chomp($outline);
    return $outline;

}

sub concat::cleanFinishedBuffer()
{
    my $self = shift;
    if ( defined $self->{finishID} )
    {
        #print"come into handle finishID, \n $self->{tmp}->{$self->{finishID}}->{str}\n";
        #split the string and add to preparedBuffer, return nothing. later read line from readPreparedBuffer()
        for ( split /^/, $self->{tmp}->{ $self->{finishID} }->{str} )
        {
            #print("split line. $_\n") ;
            push( @{ $self->{preparedBuffer} }, $_ );
        }
        $self->{tmp}->{ $self->{finishID} }->{str} = undef;
        $self->{tmp}->{ $self->{finishID} }        = undef;
        $self->{finishID}                          = undef;
    }
}

#=====================================================================================================
sub concat::readBuffer()
{
    my $self = shift;
    my $last = shift;
    if (    defined $last
         && defined $self->{CONTINUATION}->{parts}
         && defined $self->{CONTINUATION}->{lastpart}
         && $self->{CONTINUATION}->{lastpart} ==
         keys %{ $self->{CONTINUATION}->{parts} } )
    {
        push( @{ $self->{BUFFER} }, @{ $self->{CONTINUATION}->{traces} } );
        $self->{CONTINUATION} = {};
    }
    if (    defined $last
         && defined $self->{PARTS}->{parts}
         && defined $self->{PARTS}->{lastpart}
         && $self->{PARTS}->{lastpart} == keys %{ $self->{PARTS}->{parts} } )
    {
        push( @{ $self->{BUFFER} }, @{ $self->{PARTS}->{traces} } );
        $self->{CONTINUATION} = {};
    }
    return shift @{ $self->{BUFFER} };

}

sub concat::cleanBuffer()
{
    my $self = shift;
    if (    defined $self->{CONTINUATION}->{parts}
         && defined $self->{CONTINUATION}->{lastpart}
         && $self->{CONTINUATION}->{lastpart} ==
         keys %{ $self->{CONTINUATION}->{parts} } )
    {
        push( @{ $self->{BUFFER} }, @{ $self->{CONTINUATION}->{traces} } );
        $self->{CONTINUATION} = {};
        $self->{CONTINUATION}->{parts} = {};
    }
    if (    defined $self->{PARTS}->{parts}
         && defined $self->{PARTS}->{lastpart}
         && $self->{PARTS}->{lastpart} ==
         keys %{ $self->{CONTINUATION}->{parts} } )
    {
        push( @{ $self->{BUFFER} }, @{ $self->{PARTS}->{traces} } );
        $self->{PARTS} = {};
        $self->{PARTS}->{parts} = {};
    }
    if ( defined $self->{CONTINUATION}->{traces} )
    {
        my $errString = '*err' . ${ $self->{CONTINUATION}->{traces}->[0] };
        ${ $self->{CONTINUATION}->{traces}->[0] } = $errString;
        push( @{ $self->{BUFFER} }, @{ $self->{CONTINUATION}->{traces} } );
        my @keys = ( keys %{ $self->{CONTINUATION}->{parts} } );
        my $errString2 =
            "***** concat error0: truncated trace, part:'$self->{CONTINUATION}->{part}',expected number of parts:'$self->{CONTINUATION}->{lastpart}',recived parts:'@keys' *****";
        push( @{ $self->{BUFFER} }, \$errString2 );
    }
    $self->{CONTINUATION} = {};
}

sub concat::concat_line()
{
    #    #print "\norigin test, come into concat_line\n";
    my $self    = shift;
    my $lineref = shift;
    my $line;
    chomp($$lineref);
    $$lineref =~ s/\r$//;    #remove ^M
    my $moshell_board = "";
    if ( $self->{DISABLE} )
    {
        push( @{ $self->{BUFFER} }, $lineref );
        return;
    }
    if ( $$lineref =~
         /(^\s*\[.+?BUS[ _](?:RECEIVE|SEND):.+?)\((\d+)\/(\d+)\)\s*offset 0x/ )
    {
        my $string = $1;
        if ( defined $self->{CONTINUATION}->{traces} )
        {
            my $errString = '*err' . ${ $self->{CONTINUATION}->{traces}->[0] };
            ${ $self->{CONTINUATION}->{traces}->[0] } = $errString;
            push( @{ $self->{BUFFER} }, @{ $self->{CONTINUATION}->{traces} } );
            my @keys = ( keys %{ $self->{CONTINUATION}->{parts} } );
            my $errString2 =
                "***** concat error1: truncated trace, part:'$self->{CONTINUATION}->{part}',expected number of parts:'$self->{CONTINUATION}->{lastpart}',recived parts:'@keys' *****";
            push( @{ $self->{BUFFER} }, \$errString2 );
        }
        $self->{CONTINUATION} = {};

        push( @{ $self->{CONTINUATION}->{traces} }, \$string );
        $self->{CONTINUATION}->{part}     = $2;
        $self->{CONTINUATION}->{lastpart} = $3;
        $self->{CONTINUATION}->{part} =~ s/^0//;
        $self->{CONTINUATION}->{lastpart} =~ s/^0//;
        $self->{CONTINUATION}->{parts}->{ $self->{CONTINUATION}->{part} } = 1;
        $$lineref = undef;
    }
    elsif ( $$lineref =~
        /($self->{dateTimeFormat}\s+\S+\s+\S+\s+.+?)\s+Last Part\((\d+)\):(.*)$/
        )
    {

        $self->{PARTS}->{part}        = $2;
        $self->{PARTS}->{parts}->{$2} = 1;
        $self->{PARTS}->{lastpart}    = $2;

        #           #print "last part $2\n";
        my $trace = $1 . ' ' . $3;
        unshift( @{ $self->{PARTS}->{traces} }, \$trace );
        $$lineref = undef;
    }
    elsif ( $$lineref =~
          /($self->{dateTimeFormat}\s+\S+\s+\S+\s+.+?)\s+Part\((\d+)\):(.*)$/ )
    {

        my $part = $2;
        if (    $part == 1
             && defined $self->{PARTS}->{parts}
             && defined $self->{PARTS}->{lastpart}
             && $self->{PARTS}->{lastpart} ==
             keys %{ $self->{PARTS}->{parts} } )
        {
            push( @{ $self->{BUFFER} }, @{ $self->{PARTS}->{traces} } );
            $self->{PARTS} = {};
        }
        elsif (    $part == 1
                && defined $self->{PARTS}->{parts}
                && defined $self->{PARTS}->{lastpart} )
        {
            my $errString = '*err' . ${ $self->{PARTS}->{traces}->[0] };
            ${ $self->{PARTS}->{traces}->[0] } = $errString;
            push( @{ $self->{BUFFER} }, @{ $self->{PARTS}->{traces} } );
            $self->{PARTS} = {};
        }

        $self->{PARTS}->{part} = $2;

        $self->{PARTS}->{parts}->{$2} = 1;
        $self->{PARTS}->{lastpart}    = $2 + 1;
        $self->{PARTS}->{traces}      = [];
        $$lineref                     = undef;

        #       #print "part $2, lastpart:$self->{PARTS}->{lastpart}\n";
    }
    elsif ( defined $self->{PARTS}->{traces}
            && $$lineref =~ /^[0-9A-F]{4}\s+([0-9A-F ]+)\s+'/ )
    {
        push( @{ $self->{PARTS}->{traces} }, $lineref );

    }

    elsif (    defined $self->{CONTINUATION}->{parts}->{1}
            && defined $self->{CONTINUATION}->{traces}
            && $$lineref =~
            /(^\s*\[.+?CONTINUATION:.+?\((\d+)\/(\d+)\)\s*offset 0x)/ )
    {
        my $part = $2;
        $part =~ s/^0//;
        if ( defined $self->{CONTINUATION}->{parts}->{$part} )
        {
            my $errString = '*err' . ${ $self->{CONTINUATION}->{traces}->[0] };
            ${ $self->{CONTINUATION}->{traces}->[0] } = $errString;
            push( @{ $self->{BUFFER} }, @{ $self->{CONTINUATION}->{traces} } );
            my $errString2 = "***** concat error2: truncated trace";
            push( @{ $self->{BUFFER} }, \$errString2 );
            $self->{CONTINUATION} = {};
            return;
        }
        $self->{CONTINUATION}->{part} = $part;
        $self->{CONTINUATION}->{part} =~ s/^0//;
        $self->{CONTINUATION}->{parts}->{$part} = 1;
    }
    elsif ( $$lineref =~
            /(^\s*\[.+?CONTINUATION:.+?)\((\d+)\/(\d+)\)\s*offset 0x/ )
    {
        $$lineref = '*err' . $$lineref;
        push( @{ $self->{BUFFER} }, $lineref );
    }
    elsif ( defined $self->{CONTINUATION}->{traces}
            && $$lineref =~ /^[0-9A-F]{4}\s+([0-9A-F ]+)\s+'/ )
    {
        push( @{ $self->{CONTINUATION}->{traces} }, $lineref );
    }
    elsif ( $$lineref =~
        /($self->{dateTimeFormat})\s+(\S+)\s+(\S+).*?\<\s*Segmenting traces for key ([-]?\d+), (\d+) parts will follow\s*\>/
        )
    {
        my $dateTime  = $1;
        my $keyVal    = $4;
        my $noOfParts = $5;
        $$lineref = undef;
        $self->createNewObject( $dateTime,  $keyVal,
                                $noOfParts, $moshell_board );
    }
    elsif ( $$lineref =~
        /($self->{dateTimeFormat})\s+(\S+)\s+(\S+?):.*?\<\s*Segmenting traces for key ([-]?\d+), (\d+) parts will follow\s*\>/
        )
    {
        my $dateTime  = $1;
        my $keyVal    = $4;
        my $noOfParts = $5;
        $$lineref = undef;
        $self->createNewObject( $dateTime,  $keyVal,
                                $noOfParts, $moshell_board );
    }
    elsif ( $$lineref =~
        /($self->{dateTimeFormat})(\d{4})\s+(\S+)\s+(\S+)\s+(\S+?):.*\<\s*Segmenting traces for key ([-]?\d+),\s+(\d+) parts will follow\s*\>/
        )
    {
        my $dateTime = $1;
        $moshell_board = $2 . ': ';
        my $keyVal    = $6;
        my $noOfParts = $7;
        $$lineref = undef;
        $self->createNewObject( $dateTime,  $keyVal,
                                $noOfParts, $moshell_board );
    }
    elsif ( $$lineref =~
        /($self->{dateTimeFormat})\s+(\S+)\s+(\S+)\s+(.+?)\<key\s*([-]?\d+)\s*part\s*(\d+)\>\"(.*)$/
        )
    {
        my $dateTime   = $1;
        my $traceObj   = $2;
        my $fileLine   = $3;
        my $traceGroup = $4;
        my $keyVal     = $5;
        my $segNo      = $6;
        my $segment    = $7;
        $segment =~ s/\s*\"\s*$//;
        $line =
            $self->addSegmentToObject( $dateTime,   $traceObj, $fileLine,
                                       $traceGroup, $keyVal,   $segNo,
                                       $segment,    $lineref );
        $$lineref = undef;
    }
    elsif ( $$lineref =~
        /($self->{dateTimeFormat})\s+(\S+)\s+(.+?)\<key\s*([-]?\d+)\s*part\s*(\d+)\>\"(.*)$/
        )
    {
        my $dateTime   = $1;
        my $traceObj   = "";
        my $fileLine   = $2;
        my $traceGroup = $3;
        my $keyVal     = $4;
        my $segNo      = $5;
        my $segment    = $6;
        $segment =~ s/\s*\"\s*$//;
        $line = addSegmentToObject( $dateTime,   $traceObj, $fileLine,
                                    $traceGroup, $keyVal,   $segNo,
                                    $segment,    $lineref );
        $$lineref = undef;
    }
    elsif ( $$lineref =~
        /($self->{dateTimeFormat})\d{4}\s+(\S+)\s+(.+?)\<key\s*([-]?\d+)\s*part\s*(\d+)\>\"(.*)$/
        )
    {
        my $dateTime   = $1;
        my $traceObj   = "";
        my $fileLine   = $2;
        my $traceGroup = $3;
        my $keyVal     = $4;
        my $segNo      = $5;
        my $segment    = $6;
        $segment =~ s/\s*\"\s*$//;
        $line =
            $self->addSegmentToObject( $dateTime,   $traceObj, $fileLine,
                                       $traceGroup, $keyVal,   $segNo,
                                       $segment,    $lineref );
        $$lineref = undef;
    }
    else
    {
        push( @{ $self->{BUFFER} }, $lineref );
    }
    if (    defined $self->{CONTINUATION}->{parts}
         && defined $self->{CONTINUATION}->{lastpart}
         && $self->{CONTINUATION}->{lastpart} ==
         keys %{ $self->{CONTINUATION}->{parts} }
         && !( defined $$lineref
               && $$lineref !~ /^[0-9A-F]{4}\s+([0-9A-F ]+)\s+'/ ) )
    {
        push( @{ $self->{BUFFER} }, @{ $self->{CONTINUATION}->{traces} } );
        $self->{CONTINUATION} = {};
    }
    elsif (    defined $self->{PARTS}->{parts}
            && defined $self->{PARTS}->{lastpart}
            && $self->{PARTS}->{lastpart} == keys %{ $self->{PARTS}->{parts} }
            && !( defined $$lineref
                  && $$lineref !~ /^[0-9A-F]{4}\s+([0-9A-F ]+)\s+'/ ) )
    {
        push( @{ $self->{BUFFER} }, @{ $self->{PARTS}->{traces} } );
        $self->{PARTS} = {};
    }
}

sub concat::createNewObject()
{
    my $self = shift;
    my ( $dateTime, $keyVal, $noOfParts, $moshell_board ) = @_;
    return if !defined $noOfParts;
    $self->{PARTS}->{$keyVal}->{noOfParts}        = $noOfParts;
    $self->{PARTS}->{$keyVal}->{moshell_board}    = $moshell_board;
    $self->{PARTS}->{$keyVal}->{dateTime}         = $dateTime;
    $self->{PARTS}->{$keyVal}->{currentNoOfParts} = 0;
    return undef;
}

sub concat::addSegmentToObject()
{
    my $self = shift;
    my ( $dateTime, $traceObj, $fileLine, $traceGroup,
         $keyVal,   $segNo,    $segment,  $lineref )
        = @_;
    my $line;

    if ( defined $self->{PARTS}->{$keyVal} )
    {
        push( @{ $self->{PARTS}->{$keyVal}->{lines} }, $$lineref );
        $self->{PARTS}->{$keyVal}->{traceObj}   = $traceObj;
        $self->{PARTS}->{$keyVal}->{fileLine}   = $fileLine;
        $self->{PARTS}->{$keyVal}->{traceGroup} = $traceGroup;
        push( @{ $self->{PARTS}->{$keyVal}->{segment} }, $segment );
        $self->{PARTS}->{$keyVal}->{currentNoOfParts}++;

        if ( $self->{PARTS}->{$keyVal}->{currentNoOfParts} ==
             $self->{PARTS}->{$keyVal}->{noOfParts} )
        {
            $line =
                  $self->{PARTS}->{$keyVal}->{moshell_board}
                . $self->{PARTS}->{$keyVal}->{dateTime} . " "
                . $self->{PARTS}->{$keyVal}->{traceObj} . " "
                . $self->{PARTS}->{$keyVal}->{fileLine} . " "
                . $self->{PARTS}->{$keyVal}->{traceGroup};

            foreach my $seg ( @{ $self->{PARTS}->{$keyVal}->{segment} } )
            {
                $line .= $seg;
            }
            delete $self->{PARTS}->{$keyVal};
            push( @{ $self->{BUFFER} }, \$line );
        }
    }
}
1;
