package dataAccess;
use strict;
use Data::Dumper;

sub start
{
    my (%arg) = @_;
    my ( $key, $value );
    unless ( defined $arg{ctx}->{ptr}->{2} )
    {
        $arg{ctx}->{ptr}->{0} = undef;
        $arg{ctx}->{ptr}->{1} = $arg{name};
        $arg{ctx}->{ptr}->{2} = [];
    }
    else
    {
        my $t = { 0 => $arg{ctx}->{ptr}, 1 => $arg{name}, 2 => [] };
        push @{ $arg{ctx}->{ptr}->{2} }, $t;
        $arg{ctx}->{ptr} = $t;
    }
    $arg{ctx}->{ptr}->{$key} = $value
        while ( ( $key, $value ) = each( %{ $arg{attributes} } ) );
}

sub data
{
    my (%arg) = @_;
    push @{ $arg{ctx}->{ptr}->{2} }, $arg{data};
}

sub end
{
    my (%arg) = @_;
    return undef if ( $arg{ctx}->{ptr}->{1} ne $arg{name} );
    $arg{ctx}->{ptr} = $arg{ctx}->{ptr}->{0} if defined $arg{ctx}->{ptr}->{0};
    return 1;
}

sub header
{
    my (%arg) = @_;
    push @{ $arg{ctx}->{ptr}->{3} }, $arg{data};
}

sub read
{
    my (%arg) = @_;
    my $result;
    $arg{ctx}    = { ptr => { 3 => [] } };
    $arg{start}  = \&start;
    $arg{data}   = \&data;
    $arg{end}    = \&end;
    $arg{header} = \&header;
    eval "use $arg{format}";
    warn $@ if $@;
    eval '$result=' . $arg{format} . '::read(%arg)';
    warn $@ if $@;
    eval "no $arg{format}";
    warn $@ if $@;
    return $result ? $arg{ctx}->{ptr} : undef;
}

sub checkforsingledata
{
    my ($ref) = @_;
    return 1 if ( @$ref == 0 );
    return 0
        unless (    @$ref == 1
                 && ref $ref->[0] ne "HASH"
                 && length $ref->[0] < 100 );
    return 1;
}

sub write
{
    my (%arg) = @_;
    my ( $init, $header, $start, $data, $end, $final );
    eval "use $arg{format}";
    warn $@ if $@;
    eval '($init,$header,$start,$data,$end,$final)='
        . $arg{format}
        . '::events()';
    warn $@ if $@;
    eval "no $arg{format}";
    warn $@ if $@;
    my ( $obj, $loop, $handle );
    $loop = sub {
        my %attributes;
        while ( my ( $key, $value ) = each %{ $arg{data} } )
        {
            $attributes{$key} = $value if ( $key !~ /^\d+$/ );
        }
        &$start( name       => $arg{data}->{1},
                 attributes => \%attributes,
                 handle     => $handle,
                 nonewline  => checkforsingledata( $arg{data}->{2} ),
                 %arg );
        my $ptr = $arg{data};
        for ( @{ $arg{data}->{2} } )
        {
            if ( ref $_ eq "HASH" )
            {
                $arg{data} = $_;
                &$loop;
            }
            else
            {
                &$data( output    => $_,
                        handle    => $handle,
                        nonewline => checkforsingledata( $arg{data}->{2} ),
                        %arg );
            }
        }
        $arg{data} = $ptr;
        &$end( name      => $arg{data}->{1},
               handle    => $handle,
               nonewline => checkforsingledata( $arg{data}->{2} ),
               %arg );
    };
    $handle = &$init(%arg);
    &$header( output => $_, handle => $handle, %arg )
        for ( @{ $arg{data}->{3} } );
    &$loop;
    &$final( handle => $handle, %arg );
}

sub children
{
    my ($ref) = @_;
    return undef if ( !isnode($ref) );
    return \@{ $ref->{2} };
}

sub parent
{
    my ($ref) = @_;
    return undef if ( !isnode($ref) );
    return $ref->{0};
}

sub name
{
    my ($ref) = @_;
    return undef if ( !isnode($ref) );
    return $ref->{1};
}

sub attributes
{
    my ($ref) = @_;
    return undef if ( !isnode($ref) );
    my %attr;
    for ( keys %$ref )
    {
        $attr{$_} = $ref->{$_} unless $_ =~ /^\d$/;
    }
    return \%attr;
}

sub isnode
{
    my ($ref) = @_;
    return ref $ref eq "HASH";
}

sub simplify
{
    my ($ref) = @_;
    return undef if ( !isnode($ref) );
    my %content;
    $content{ name($_) } = @{ children($_) }[0] for ( @{ children($ref) } );
    return \%content;
}

1;
