package sshConnect;
use Data::Dumper;
use strict;
use Expect;
use Switch;

sub sendCommand
{
    my $self     = shift;
    my (%inData) = @_;
    my $cmd      = $inData{cmd};
    my $slow     = $inData{slow};
    my $timeout  = $inData{timeout};
    my @prompts =
        defined $inData{prompts}
        ? @{ $inData{prompts} }
        : @{ $self->{prompts} };
    my $debug = defined $inData{debug} ? $inData{debug} : $self->{debug};
    my $exp = $self->{handle};
    my ( $matched_pattern_position, $error, $successfully_matching_string,
         $before_match, $after_match );

    #    print "send Command: " . $cmd . "\n";
    #( $matched_pattern_position, $error, $successfully_matching_string, $before_match, $after_match ) = $exp->expect( 1, @prompts );
    $exp->debug($debug) if ( defined $debug );
    $exp->send_slow( 0.001, $cmd . "\n" );
    (  $matched_pattern_position, $error, $successfully_matching_string,
       $before_match, $after_match )
        = $exp->expect( $timeout, @prompts );
    if ($error)
    {
        printExceptions("error: $error");
    }
    return \$before_match;
}

sub sendCommand2
{
    my $self     = shift;
    my (%inData) = @_;
    my $cmd      = $inData{cmd};
    my $slow     = $inData{slow};
    my $timeout  = $inData{timeout};
    my @prompts =
        defined $inData{prompts}
        ? @{ $inData{prompts} }
        : @{ $self->{prompts} };
    my $debug = defined $inData{debug} ? $inData{debug} : $self->{debug};
    my $exp = $self->{handle};
    my ( $matched_pattern_position, $error, $successfully_matching_string,
         $before_match, $after_match );

    #( $matched_pattern_position, $error, $successfully_matching_string, $before_match, $after_match ) = $exp->expect( 1, @prompts );
    $exp->debug($debug) if ( defined $debug );
    $exp->send( $cmd . "\n" );

    #( $matched_pattern_position, $error, $successfully_matching_string, $before_match, $after_match ) = $exp->expect( $timeout, undef );
    $exp->expect( 20, undef );
    my $res = $exp->before();
    if ($error)
    {
        printExceptions("error: $error");
    }
    return \$res;
}

sub connectExpect
{
    my $class    = shift;
    my (%inData) = @_;
    my $host     = $inData{host};
    my $username = $inData{username};
    my $passwd   = $inData{passwd};
    my $logfile  = $inData{logfile};
    my $debug    = $inData{debug};
    my $verbose  = $inData{verbose};
    my @prompts  = @{ $inData{prompts} };
    my @commands = @{ $inData{commands} } if defined $inData{commands};
    if ( !defined $passwd )
    {
        $passwd = askForPassword($username);
    }

    my $exp = Expect->spawn("ssh -l $username $host");
    if ( defined $debug && $debug =~ /0/ )
    {
        $exp->log_user(1);
        $exp->log_stdout(1);
    }
    else
    {
        $exp->log_user(0);
        $exp->log_stdout(0);
    }
    if ( defined $logfile )
    {
        `touch $logfile`;
        `chmod 664 $logfile`;
        $exp->log_file( $logfile, "w" );
    }
    $exp->expect(
        undef,
        [  qr/Your password expires in/i,
           sub {
               my $self = shift;
               $self->send("\n");
               }
        ],
        [  qr/password/i,
           sub {
               my $self = shift;
               $self->send("$passwd\n");
               }
        ],
        [  qr/Are you sure you want to continue connecting/i,
           sub {
               my $self = shift;
               $self->send("yes\n");
               exp_continue;
               }
        ],
        [  qr/Account has been locked out/i,
           sub {
               print "Account has been locked out!\n";
               exit;
               }
        ],
        [  qr/Permission denied, please try again/i,
           sub {
               print "Permission denied, please try again.\n";
               exit;
               }
        ] );
    foreach my $cmd (@commands)
    {
        $exp->send_slow( 0.001, $cmd . "\n" );
    }
    my ( $matched_pattern_position, $error, $successfully_matching_string,
         $before_match, $after_match )
        = $exp->expect( 300, @prompts );
    if ($error)
    {
        printExceptions("error: $error");
        exit;
    }
    elsif ( defined $debug )
    {
        print
            "\nsuccessfully_matching_string: '$successfully_matching_string'\n";
    }
    my $self = { host     => $host,
                 username => $username,
                 passwd   => $passwd,
                 logfile  => $logfile,
                 debug    => $debug,
                 verbose  => $verbose,
                 handle   => $exp,
                 prompts  => \@prompts };
    bless( $self, $class );
    return $self;
}

sub askForPassword
{
    my ($username) = @_;
    my $passwd;
    while ( !$passwd )
    {
        my $trk_loaded = 0;
        eval {
            require Term::ReadKey;
            import Term::ReadKey;
            $trk_loaded = 1;
        };
        print "Enter Password for $username:";
        ReadMode('noecho') if $trk_loaded;    # input echo off
        chomp( $passwd = $trk_loaded ? ReadLine(0) : <STDIN> );
        ReadMode('restore') if $trk_loaded;    # input echo on
        print "\n";
    }
    return $passwd;
}

sub printExceptions
{
    my @exceptions = @_;
    my $errorFound;
    foreach my $exception (@exceptions)
    {
        print "\n" . "\e[31m" . 'Error:' . $exception . "\e[0m" . "\n";
        $errorFound = 1;
    }
    if ( defined $errorFound )
    {
        exit;
    }
}

1;
